/*
 * Decompiled with CFR 0.152.
 */
package apoc.load;

import apoc.load.LoadJsonUtils;
import apoc.result.MapResult;
import apoc.result.ObjectResult;
import apoc.util.CompressionAlgo;
import apoc.util.JsonUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.graphdb.security.URLAccessChecker;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class LoadJson {
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public URLAccessChecker urlAccessChecker;

    @Procedure(value="apoc.load.jsonArray")
    @Description(value="Loads array from a JSON URL (e.g. web-API) to then import the given JSON file as a stream of values.")
    public Stream<ObjectResult> jsonArray(@Name(value="url") String url, @Name(value="path", defaultValue="") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return JsonUtil.loadJson(url, null, null, path, true, (List)config.get("pathOptions"), this.urlAccessChecker).flatMap(value -> {
            if (value instanceof List) {
                List list = (List)value;
                if (list.isEmpty()) {
                    return Stream.empty();
                }
                if (list.get(0) instanceof Map) {
                    return list.stream().map(ObjectResult::new);
                }
            }
            return Stream.of(new ObjectResult(value));
        });
    }

    @Procedure(value="apoc.load.json")
    @Description(value="Imports JSON file as a stream of values if the given JSON file is a `LIST<ANY>`.\nIf the given JSON file is a `MAP`, this procedure imports a single value instead.")
    public Stream<MapResult> json(@Name(value="urlOrKeyOrBinary") Object urlOrKeyOrBinary, @Name(value="path", defaultValue="") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        return this.jsonParams(urlOrKeyOrBinary, null, null, path, config);
    }

    @Procedure(value="apoc.load.jsonParams")
    @Description(value="Loads parameters from a JSON URL (e.g. web-API) as a stream of values if the given JSON file is a `LIST<ANY>`.\nIf the given JSON file is a `MAP`, this procedure imports a single value instead.")
    public Stream<MapResult> jsonParams(@Name(value="urlOrKeyOrBinary") Object urlOrKeyOrBinary, @Name(value="headers") Map<String, Object> headers, @Name(value="payload") String payload, @Name(value="path", defaultValue="") String path, @Name(value="config", defaultValue="{}") Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        boolean failOnError = (Boolean)config.getOrDefault("failOnError", true);
        String compressionAlgo = (String)config.getOrDefault("compression", CompressionAlgo.NONE.name());
        List pathOptions = (List)config.get("pathOptions");
        return LoadJsonUtils.loadJsonStream(urlOrKeyOrBinary, headers, payload, path, failOnError, compressionAlgo, pathOptions, this.terminationGuard, this.urlAccessChecker);
    }
}

