/*
 * Decompiled with CFR 0.152.
 */
package apoc.help;

import apoc.help.HelpResult;
import apoc.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;

public class Help {
    @Context
    public Transaction tx;
    private static final Set<String> extended = new HashSet<String>();

    public Help() {
        try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream("extended.txt");){
            if (stream != null) {
                String name;
                BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
                while ((name = reader.readLine()) != null) {
                    extended.add(name);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load extended file with error: " + e.getMessage());
        }
    }

    @NotThreadSafe
    @Procedure(value="apoc.help")
    @Description(value="Returns descriptions of the available APOC procedures and functions. If a keyword is provided, it will return only those procedures and functions that have the keyword in their name.")
    public Stream<HelpResult> info(@Name(value="proc") String name) {
        boolean searchText = false;
        if (name != null && (name = name.trim()).endsWith("+")) {
            name = name.substring(0, name.lastIndexOf(43)).trim();
            searchText = true;
        }
        String filter = " WHERE name starts with 'apoc.'  AND ($name IS NULL  OR toLower(name) CONTAINS toLower($name)  OR ($desc IS NOT NULL AND toLower(description) CONTAINS toLower($desc))) ";
        String proceduresQuery = "SHOW PROCEDURES yield name, description, signature, isDeprecated " + filter + "RETURN 'procedure' as type, name, description, signature, isDeprecated ";
        String functionsQuery = "SHOW FUNCTIONS yield name, description, signature, isDeprecated " + filter + "RETURN 'function' as type, name, description, signature, isDeprecated ";
        Map<String, Object> params = Util.map("name", name, "desc", searchText ? name : null);
        Stream proceduresResults = this.tx.execute(proceduresQuery, params).stream();
        Stream functionsResults = this.tx.execute(functionsQuery, params).stream();
        return Stream.of(proceduresResults, functionsResults).flatMap(results -> results.map(row -> new HelpResult((Map<String, Object>)row, !extended.contains((String)row.get("name")))));
    }
}

