/*
 * Decompiled with CFR 0.152.
 */
package apoc.hashing;

import apoc.util.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FingerprintingConfig {
    private final String digestAlgorithm;
    private final Map<String, List<String>> nodeAllowMap;
    private final Map<String, List<String>> relAllowMap;
    private final Map<String, List<String>> nodeDisallowMap;
    private final Map<String, List<String>> relDisallowMap;
    private final List<String> mapAllowList;
    private final List<String> mapDisallowList;
    private final List<String> allNodesAllowList;
    private final List<String> allRelsAllowList;
    private final List<String> allNodesDisallowList;
    private final List<String> allRelsDisallowList;
    private final FingerprintStrategy strategy;
    private final Set<String> allLabels;
    private final Set<String> allTypes;

    public FingerprintingConfig(Map<String, Object> config) {
        if (config == null) {
            config = Collections.emptyMap();
        }
        this.digestAlgorithm = (String)config.getOrDefault("digestAlgorithm", "MD5");
        this.nodeAllowMap = config.getOrDefault("nodeAllowMap", Collections.emptyMap());
        this.relAllowMap = config.getOrDefault("relAllowMap", Collections.emptyMap());
        this.nodeDisallowMap = config.getOrDefault("nodeDisallowMap", Collections.emptyMap());
        this.relDisallowMap = config.getOrDefault("relDisallowMap", Collections.emptyMap());
        this.mapAllowList = config.getOrDefault("mapAllowList", Collections.emptyList());
        this.mapDisallowList = config.getOrDefault("mapDisallowList", Collections.emptyList());
        this.allNodesAllowList = config.getOrDefault("allNodesAllowList", Collections.emptyList());
        this.allRelsAllowList = config.getOrDefault("allRelsAllowList", Collections.emptyList());
        this.allNodesDisallowList = config.getOrDefault("allNodesDisallowList", Collections.emptyList());
        this.allRelsDisallowList = config.getOrDefault("allRelsDisallowList", Collections.emptyList());
        this.strategy = FingerprintStrategy.valueOf((String)config.getOrDefault("strategy", FingerprintStrategy.LAZY.toString()));
        this.validateConfig();
        this.allLabels = new HashSet<String>(this.nodeAllowMap.keySet());
        this.allLabels.addAll(this.nodeDisallowMap.keySet());
        this.allTypes = new HashSet<String>(this.relAllowMap.keySet());
        this.allTypes.addAll(this.relDisallowMap.keySet());
    }

    private void validateConfig() {
        String message = "You can't set the same %s for allow and disallow lists for %s";
        if (!Util.intersection(this.nodeAllowMap.keySet(), this.nodeDisallowMap.keySet()).isEmpty()) {
            throw new RuntimeException(String.format("You can't set the same %s for allow and disallow lists for %s", "labels", "nodes"));
        }
        if (!Util.intersection(this.relAllowMap.keySet(), this.relDisallowMap.keySet()).isEmpty()) {
            throw new RuntimeException(String.format("You can't set the same %s for allow and disallow lists for %s", "types", "rels"));
        }
        if (!Util.intersection(this.mapAllowList, this.mapDisallowList).isEmpty()) {
            throw new RuntimeException(String.format("You can't set the same %s for allow and disallow lists for %s", "properties", "maps"));
        }
        if (!Util.intersection(this.allNodesAllowList, this.allNodesDisallowList).isEmpty()) {
            throw new RuntimeException(String.format("You can't set the same %s for allow and disallow lists for %s", "properties", "all nodes"));
        }
        if (!Util.intersection(this.allRelsAllowList, this.allRelsDisallowList).isEmpty()) {
            throw new RuntimeException(String.format("You can't set the same %s for allow and disallow lists for %s", "properties", "all rels"));
        }
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public Map<String, List<String>> getNodeAllowMap() {
        return this.nodeAllowMap;
    }

    public Map<String, List<String>> getRelAllowMap() {
        return this.relAllowMap;
    }

    public Map<String, List<String>> getNodeDisallowMap() {
        return this.nodeDisallowMap;
    }

    public Map<String, List<String>> getRelDisallowMap() {
        return this.relDisallowMap;
    }

    public List<String> getMapAllowList() {
        return this.mapAllowList;
    }

    public List<String> getMapDisallowList() {
        return this.mapDisallowList;
    }

    public List<String> getAllNodesAllowList() {
        return this.allNodesAllowList;
    }

    public List<String> getAllRelsAllowList() {
        return this.allRelsAllowList;
    }

    public List<String> getAllNodesDisallowList() {
        return this.allNodesDisallowList;
    }

    public List<String> getAllRelsDisallowList() {
        return this.allRelsDisallowList;
    }

    public FingerprintStrategy getStrategy() {
        return this.strategy;
    }

    public Set<String> getAllLabels() {
        return this.allLabels;
    }

    public Set<String> getAllTypes() {
        return this.allTypes;
    }

    static enum FingerprintStrategy {
        EAGER,
        LAZY;

    }
}

