/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.util;

import apoc.export.util.SizeCounter;
import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

public class CountingReader
extends FilterReader
implements SizeCounter {
    public static final int BUFFER_SIZE = 0x100000;
    private final long total;
    private long count = 0L;

    public CountingReader(Reader reader, long total) {
        super(new BufferedReader(reader, 0x100000));
        this.total = total;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int read = super.read(cbuf, off, len);
        this.count += (long)read;
        return read;
    }

    @Override
    public int read() throws IOException {
        ++this.count;
        return super.read();
    }

    @Override
    public long skip(long n) throws IOException {
        this.count += n;
        return super.skip(n);
    }

    @Override
    public long getPercent() {
        if (this.total <= 0L) {
            return 0L;
        }
        return this.count * 100L / this.total;
    }
}

