/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.json;

import apoc.export.cypher.ExportFileManager;
import apoc.export.json.JsonFormatSerializer;
import apoc.export.util.ExportConfig;
import apoc.export.util.Reporter;
import apoc.meta.Types;
import apoc.result.ProgressInfo;
import apoc.util.JsonUtil;
import apoc.util.Util;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.security.AuthorizationViolationException;

public class JsonFormat {
    private final GraphDatabaseService db;
    private final Format format;
    private boolean isExportSubGraph = false;

    public JsonFormat(GraphDatabaseService db, Format format) {
        this.db = db;
        this.format = format;
    }

    private ProgressInfo dump(Writer writer, Reporter reporter, Consumer<JsonGenerator> consumer) throws Exception {
        try (Transaction tx = this.db.beginTx();
             JsonGenerator jsonGenerator = this.getJsonGenerator(writer);){
            consumer.accept(jsonGenerator);
            jsonGenerator.flush();
            tx.commit();
        }
        reporter.done();
        return reporter.getTotal();
    }

    public ProgressInfo dump(SubGraph graph, ExportFileManager writer, Reporter reporter, ExportConfig config) throws Exception {
        this.isExportSubGraph = true;
        Consumer<JsonGenerator> consumer = jsonGenerator -> {
            try {
                this.writeJsonContainerStart((JsonGenerator)jsonGenerator);
                this.writeJsonNodeContainerStart((JsonGenerator)jsonGenerator);
                this.writeNodes(graph.getNodes(), reporter, (JsonGenerator)jsonGenerator, config);
                this.writeJsonNodeContainerEnd((JsonGenerator)jsonGenerator);
                this.writeJsonRelationshipContainerStart((JsonGenerator)jsonGenerator);
                this.writeRels(graph.getRelationships(), reporter, (JsonGenerator)jsonGenerator, config);
                this.writeJsonRelationshipContainerEnd((JsonGenerator)jsonGenerator);
                this.writeJsonContainerEnd((JsonGenerator)jsonGenerator);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return this.dump(writer.getPrintWriter("json"), reporter, consumer);
    }

    private void writeJsonRelationshipContainerEnd(JsonGenerator jsonGenerator) throws IOException {
        switch (this.format) {
            case JSON: {
                jsonGenerator.writeEndArray();
                break;
            }
            case JSON_ID_AS_KEYS: {
                jsonGenerator.writeEndObject();
            }
        }
    }

    private void writeJsonRelationshipContainerStart(JsonGenerator jsonGenerator) throws IOException {
        switch (this.format) {
            case JSON: {
                jsonGenerator.writeFieldName("rels");
                jsonGenerator.writeStartArray();
                break;
            }
            case JSON_ID_AS_KEYS: {
                jsonGenerator.writeFieldName("rels");
                jsonGenerator.writeStartObject();
            }
        }
    }

    private void writeJsonNodeContainerEnd(JsonGenerator jsonGenerator) throws IOException {
        switch (this.format) {
            case JSON: {
                jsonGenerator.writeEndArray();
                break;
            }
            case JSON_ID_AS_KEYS: {
                jsonGenerator.writeEndObject();
            }
        }
    }

    private void writeJsonNodeContainerStart(JsonGenerator jsonGenerator) throws IOException {
        switch (this.format) {
            case JSON: {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName("nodes");
                jsonGenerator.writeStartArray();
                break;
            }
            case JSON_ID_AS_KEYS: {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeFieldName("nodes");
                jsonGenerator.writeStartObject();
            }
        }
    }

    private void writeJsonContainerEnd(JsonGenerator jsonGenerator) throws IOException {
        switch (this.format) {
            case ARRAY_JSON: {
                jsonGenerator.writeEndArray();
            }
        }
    }

    private void writeJsonContainerStart(JsonGenerator jsonGenerator) throws IOException {
        switch (this.format) {
            case ARRAY_JSON: {
                jsonGenerator.writeStartArray();
            }
        }
    }

    public ProgressInfo dump(Result result, ExportFileManager writer, Reporter reporter, ExportConfig config) throws Exception {
        Consumer<JsonGenerator> consumer = jsonGenerator -> {
            try {
                this.writeJsonContainerStart((JsonGenerator)jsonGenerator);
                String[] header = result.columns().toArray(new String[result.columns().size()]);
                result.accept(row -> {
                    this.writeJsonResult(reporter, header, (JsonGenerator)jsonGenerator, row, config);
                    reporter.nextRow();
                    return true;
                });
                this.writeJsonContainerEnd((JsonGenerator)jsonGenerator);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (AuthorizationViolationException e) {
                throw new RuntimeException(Util.INVALID_QUERY_MODE_ERROR);
            }
        };
        return this.dump(writer.getPrintWriter("json"), reporter, consumer);
    }

    private JsonGenerator getJsonGenerator(Writer writer) throws IOException {
        JsonGenerator jsonGenerator = new JsonFactory().createGenerator(writer).setCodec((ObjectCodec)JsonUtil.OBJECT_MAPPER).setPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter("\n"));
        return jsonGenerator;
    }

    private void writeNodes(Iterable<Node> nodes, Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config) throws IOException {
        for (Node node : nodes) {
            this.writeNode(reporter, jsonGenerator, node, config);
        }
    }

    private void writeNode(Reporter reporter, JsonGenerator jsonGenerator, Node node, ExportConfig config) throws IOException {
        Map allProperties = node.getAllProperties();
        this.writeJsonIdKeyStart(jsonGenerator, node.getId());
        JsonFormatSerializer.DEFAULT.writeNode(jsonGenerator, node, config);
        reporter.update(1L, 0L, allProperties.size());
    }

    private void writeJsonIdKeyStart(JsonGenerator jsonGenerator, long id) throws IOException {
        if (!this.isExportSubGraph) {
            return;
        }
        switch (this.format) {
            case JSON_ID_AS_KEYS: {
                this.writeFieldName(jsonGenerator, String.valueOf(id), true);
            }
        }
    }

    private void writeRels(Iterable<Relationship> rels, Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config) throws IOException {
        for (Relationship rel : rels) {
            this.writeRel(reporter, jsonGenerator, rel, config);
        }
    }

    private void writeRel(Reporter reporter, JsonGenerator jsonGenerator, Relationship rel, ExportConfig config) throws IOException {
        Map allProperties = rel.getAllProperties();
        this.writeJsonIdKeyStart(jsonGenerator, rel.getId());
        JsonFormatSerializer.DEFAULT.writeRelationship(jsonGenerator, rel, config);
        reporter.update(0L, 1L, allProperties.size());
    }

    private void writeJsonResult(Reporter reporter, String[] header, JsonGenerator jsonGenerator, Result.ResultRow row, ExportConfig config) throws IOException {
        jsonGenerator.writeStartObject();
        for (int col = 0; col < header.length; ++col) {
            String keyName = header[col];
            Object value = row.get(keyName);
            this.write(reporter, jsonGenerator, config, keyName, value, true);
        }
        jsonGenerator.writeEndObject();
    }

    private void write(Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config, String keyName, Object value, boolean writeKey) throws IOException {
        Types type = Types.of(value);
        switch (type) {
            case NODE: {
                this.writeFieldName(jsonGenerator, keyName, writeKey);
                this.writeNode(reporter, jsonGenerator, (Node)value, config);
                break;
            }
            case RELATIONSHIP: {
                this.writeFieldName(jsonGenerator, keyName, writeKey);
                this.writeRel(reporter, jsonGenerator, (Relationship)value, config);
                break;
            }
            case PATH: {
                this.writeFieldName(jsonGenerator, keyName, writeKey);
                this.writePath(reporter, jsonGenerator, config, (Path)value);
                break;
            }
            case MAP: {
                if (writeKey) {
                    jsonGenerator.writeObjectFieldStart(keyName);
                } else {
                    jsonGenerator.writeStartObject();
                    writeKey = true;
                }
                HashMap map = (HashMap)value;
                for (Map.Entry entry : map.entrySet()) {
                    this.write(reporter, jsonGenerator, config, (String)entry.getKey(), entry.getValue(), writeKey);
                }
                jsonGenerator.writeEndObject();
                break;
            }
            case LIST: {
                Object[] list;
                if (writeKey) {
                    jsonGenerator.writeArrayFieldStart(keyName);
                } else {
                    jsonGenerator.writeStartArray();
                }
                for (Object elem : list = Types.toObjectArray(value)) {
                    this.write(reporter, jsonGenerator, config, keyName, elem, false);
                }
                jsonGenerator.writeEndArray();
                break;
            }
            default: {
                JsonFormatSerializer.DEFAULT.serializeProperty(jsonGenerator, keyName, value, writeKey);
                reporter.update(0L, 0L, 1L);
            }
        }
    }

    private void writeFieldName(JsonGenerator jsonGenerator, String keyName, boolean writeKey) throws IOException {
        if (writeKey) {
            jsonGenerator.writeFieldName(keyName);
        }
    }

    private void writePath(Reporter reporter, JsonGenerator jsonGenerator, ExportConfig config, Path path) throws IOException {
        jsonGenerator.writeStartObject();
        jsonGenerator.writeObjectField("length", (Object)path.length());
        jsonGenerator.writeArrayFieldStart("rels");
        this.writeRels(path.relationships(), reporter, jsonGenerator, config);
        jsonGenerator.writeEndArray();
        jsonGenerator.writeArrayFieldStart("nodes");
        this.writeNodes(path.nodes(), reporter, jsonGenerator, config);
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
    }

    static enum Format {
        JSON_LINES,
        ARRAY_JSON,
        JSON,
        JSON_ID_AS_KEYS;

    }
}

