/*
 * Decompiled with CFR 0.152.
 */
package apoc.export.csv;

import apoc.ApocConfig;
import apoc.Pools;
import apoc.export.csv.CsvFormat;
import apoc.export.cypher.ExportFileManager;
import apoc.export.cypher.FileManagerFactory;
import apoc.export.util.ExportConfig;
import apoc.export.util.ExportFormat;
import apoc.export.util.ExportUtils;
import apoc.export.util.NodesAndRelsSubGraph;
import apoc.export.util.ProgressReporter;
import apoc.export.util.Reporter;
import apoc.result.ProgressInfo;
import apoc.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.cypher.export.DatabaseSubGraph;
import org.neo4j.cypher.export.SubGraph;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.TerminationGuard;

public class ExportCSV {
    @Context
    public Transaction tx;
    @Context
    public GraphDatabaseService db;
    @Context
    public TerminationGuard terminationGuard;
    @Context
    public ApocConfig apocConfig;
    @Context
    public Pools pools;

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.all")
    @Description(value="Exports the full database to the provided CSV file.")
    public Stream<ProgressInfo> all(@Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) {
        String source = String.format("database: nodes(%d), rels(%d)", Util.nodeCount(this.tx), Util.relCount(this.tx));
        return this.exportCsv(fileName, source, new DatabaseSubGraph(this.tx), new ExportConfig(config, ExportFormat.CSV));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.data")
    @Description(value="Exports the given `NODE` and `RELATIONSHIP` values to the provided CSV file.")
    public Stream<ProgressInfo> data(@Name(value="nodes") List<Node> nodes, @Name(value="rels") List<Relationship> rels, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) {
        ExportConfig exportConfig = new ExportConfig(config, ExportFormat.CSV);
        this.preventBulkImport(exportConfig);
        String source = String.format("data: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), exportConfig);
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.graph")
    @Description(value="Exports the given graph to the provided CSV file.")
    public Stream<ProgressInfo> graph(@Name(value="graph") Map<String, Object> graph, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) {
        Collection nodes = (Collection)graph.get("nodes");
        Collection rels = (Collection)graph.get("relationships");
        String source = String.format("graph: nodes(%d), rels(%d)", nodes.size(), rels.size());
        return this.exportCsv(fileName, source, new NodesAndRelsSubGraph(this.tx, nodes, rels), new ExportConfig(config, ExportFormat.CSV));
    }

    @NotThreadSafe
    @Procedure(value="apoc.export.csv.query")
    @Description(value="Exports the results from running the given Cypher query to the provided CSV file.")
    public Stream<ProgressInfo> query(@Name(value="query") String query, @Name(value="file") String fileName, @Name(value="config") Map<String, Object> config) {
        ExportConfig exportConfig = new ExportConfig(config, ExportFormat.CSV);
        this.preventBulkImport(exportConfig);
        Map params = config == null ? Collections.emptyMap() : config.getOrDefault("params", Collections.emptyMap());
        Result result = this.tx.execute(query, params);
        String source = String.format("statement: cols(%d)", result.columns().size());
        return this.exportCsv(fileName, source, result, exportConfig);
    }

    private void preventBulkImport(ExportConfig config) {
        if (config.isBulkImport()) {
            throw new RuntimeException("You can use the `bulkImport` only with apoc.export.all and apoc.export.csv.graph");
        }
    }

    private Stream<ProgressInfo> exportCsv(@Name(value="file") String fileName, String source, Object data, ExportConfig exportConfig) {
        this.apocConfig.checkWriteAllowed(exportConfig, fileName);
        String format = "csv";
        ProgressInfo progressInfo = new ProgressInfo(fileName, source, "csv");
        progressInfo.batchSize = exportConfig.getBatchSize();
        ProgressReporter reporter = new ProgressReporter(null, null, progressInfo);
        CsvFormat exporter = new CsvFormat(this.db, (InternalTransaction)this.tx);
        ExportFileManager cypherFileManager = FileManagerFactory.createFileManager(fileName, exportConfig.isBulkImport(), exportConfig);
        if (exportConfig.streamStatements()) {
            return ExportUtils.getProgressInfoStream(this.db, this.pools.getDefaultExecutorService(), this.terminationGuard, "csv", exportConfig, reporter, cypherFileManager, reporterWithConsumer -> this.dump(data, exportConfig, (ProgressReporter)reporterWithConsumer, cypherFileManager, exporter));
        }
        this.dump(data, exportConfig, reporter, cypherFileManager, exporter);
        return reporter.stream();
    }

    private void dump(Object data, ExportConfig c, ProgressReporter reporter, ExportFileManager printWriter, CsvFormat exporter) {
        if (data instanceof SubGraph) {
            exporter.dump((SubGraph)data, printWriter, (Reporter)reporter, c);
        }
        if (data instanceof Result) {
            exporter.dump((Result)data, printWriter, (Reporter)reporter, c);
        }
    }
}

