/*
 * Decompiled with CFR 0.152.
 */
package apoc.create;

import apoc.get.Get;
import apoc.result.NodeResult;
import apoc.result.PathResult;
import apoc.result.RelationshipResult;
import apoc.result.VirtualNode;
import apoc.result.VirtualPath;
import apoc.result.VirtualPathResult;
import apoc.result.VirtualRelationship;
import apoc.util.Util;
import apoc.util.collection.Iterables;
import apoc.uuid.UuidUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;

public class Create {
    public static final String[] EMPTY_ARRAY = new String[0];
    @Context
    public Transaction tx;

    @Procedure(name="apoc.create.node", mode=Mode.WRITE)
    @Description(value="Creates a `NODE` with the given dynamic labels.")
    public Stream<NodeResult> node(@Name(value="labels") List<String> labelNames, @Name(value="props") Map<String, Object> props) {
        return Stream.of(new NodeResult(this.setProperties(this.tx.createNode(Util.labels(labelNames)), props)));
    }

    @Procedure(name="apoc.create.addLabels", mode=Mode.WRITE)
    @Description(value="Adds the given labels to the given `NODE` values.")
    public Stream<NodeResult> addLabels(@Name(value="nodes") Object nodes, @Name(value="labels") List<String> labelNames) {
        Label[] labels = Util.labels(labelNames);
        return new Get((InternalTransaction)this.tx).nodes(nodes).map(r -> {
            Node node = r.node;
            for (Label label : labels) {
                node.addLabel(label);
            }
            return r;
        });
    }

    @Procedure(name="apoc.create.setProperty", mode=Mode.WRITE)
    @Description(value="Sets the given property to the given `NODE` values.")
    public Stream<NodeResult> setProperty(@Name(value="nodes") Object nodes, @Name(value="key") String key, @Name(value="value") Object value) {
        return new Get((InternalTransaction)this.tx).nodes(nodes).map(r -> {
            this.setProperty((Entity)r.node, key, this.toPropertyValue(value));
            return r;
        });
    }

    @Procedure(name="apoc.create.setRelProperty", mode=Mode.WRITE)
    @Description(value="Sets the given property on the `RELATIONSHIP` values.")
    public Stream<RelationshipResult> setRelProperty(@Name(value="rels") Object rels, @Name(value="key") String key, @Name(value="value") Object value) {
        return new Get((InternalTransaction)this.tx).rels(rels).map(r -> {
            this.setProperty((Entity)r.rel, key, this.toPropertyValue(value));
            return r;
        });
    }

    @Procedure(name="apoc.create.setProperties", mode=Mode.WRITE)
    @Description(value="Sets the given properties to the given `NODE` values.")
    public Stream<NodeResult> setProperties(@Name(value="nodes") Object nodes, @Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return new Get((InternalTransaction)this.tx).nodes(nodes).map(r -> {
            this.setProperties(r.node, Util.mapFromLists(keys, values));
            return r;
        });
    }

    @Procedure(name="apoc.create.removeProperties", mode=Mode.WRITE)
    @Description(value="Removes the given properties from the given `NODE` values.")
    public Stream<NodeResult> removeProperties(@Name(value="nodes") Object nodes, @Name(value="keys") List<String> keys) {
        return new Get((InternalTransaction)this.tx).nodes(nodes).map(r -> {
            keys.forEach(arg_0 -> ((Node)r.node).removeProperty(arg_0));
            return r;
        });
    }

    @Procedure(name="apoc.create.setRelProperties", mode=Mode.WRITE)
    @Description(value="Sets the given properties on the `RELATIONSHIP` values.")
    public Stream<RelationshipResult> setRelProperties(@Name(value="rels") Object rels, @Name(value="keys") List<String> keys, @Name(value="values") List<Object> values) {
        return new Get((InternalTransaction)this.tx).rels(rels).map(r -> {
            this.setProperties(r.rel, Util.mapFromLists(keys, values));
            return r;
        });
    }

    @Procedure(name="apoc.create.removeRelProperties", mode=Mode.WRITE)
    @Description(value="Removes the given properties from the given `RELATIONSHIP` values.")
    public Stream<RelationshipResult> removeRelProperties(@Name(value="rels") Object rels, @Name(value="keys") List<String> keys) {
        return new Get((InternalTransaction)this.tx).rels(rels).map(r -> {
            keys.forEach(arg_0 -> ((Relationship)r.rel).removeProperty(arg_0));
            return r;
        });
    }

    @Procedure(name="apoc.create.setLabels", mode=Mode.WRITE)
    @Description(value="Sets the given labels to the given `NODE` values. Non-matching labels are removed from the nodes.")
    public Stream<NodeResult> setLabels(@Name(value="nodes") Object nodes, @Name(value="labels") List<String> labelNames) {
        Label[] labels = Util.labels(labelNames);
        return new Get((InternalTransaction)this.tx).nodes(nodes).map(r -> {
            Node node = r.node;
            for (Label label : node.getLabels()) {
                if (labelNames.contains(label.name())) continue;
                node.removeLabel(label);
            }
            for (Label label : labels) {
                if (node.hasLabel(label)) continue;
                node.addLabel(label);
            }
            return r;
        });
    }

    @Procedure(name="apoc.create.removeLabels", mode=Mode.WRITE)
    @Description(value="Removes the given labels from the given `NODE` values.")
    public Stream<NodeResult> removeLabels(@Name(value="nodes") Object nodes, @Name(value="labels") List<String> labelNames) {
        Label[] labels = Util.labels(labelNames);
        return new Get((InternalTransaction)this.tx).nodes(nodes).map(r -> {
            Node node = r.node;
            for (Label label : labels) {
                node.removeLabel(label);
            }
            return r;
        });
    }

    @Procedure(name="apoc.create.nodes", mode=Mode.WRITE)
    @Description(value="Creates `NODE` values with the given dynamic labels.")
    public Stream<NodeResult> nodes(@Name(value="labels") List<String> labelNames, @Name(value="props") List<Map<String, Object>> props) {
        Label[] labels = Util.labels(labelNames);
        return props.stream().map(p -> new NodeResult(this.setProperties((Entity)this.tx.createNode(labels), (Map<String, Object>)p)));
    }

    @Procedure(name="apoc.create.relationship", mode=Mode.WRITE)
    @Description(value="Creates a `RELATIONSHIP` with the given dynamic relationship type.")
    public Stream<RelationshipResult> relationship(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        VirtualRelationship.validateNodes(from, to);
        return Stream.of(new RelationshipResult(this.setProperties(from.createRelationshipTo(to, RelationshipType.withName((String)relType)), props)));
    }

    @Procedure(value="apoc.create.vNode")
    @Description(value="Returns a virtual `NODE`.")
    public Stream<NodeResult> vNode(@Name(value="labels") List<String> labelNames, @Name(value="props") Map<String, Object> props) {
        return Stream.of(new NodeResult(this.vNodeFunction(labelNames, props)));
    }

    @UserFunction(value="apoc.create.vNode")
    @Description(value="Returns a virtual `NODE`.")
    public Node vNodeFunction(@Name(value="labels") List<String> labelNames, @Name(value="props", defaultValue="{}") Map<String, Object> props) {
        return new VirtualNode(Util.labels(labelNames), props);
    }

    @UserFunction(value="apoc.create.virtual.fromNode")
    @Description(value="Returns a virtual `NODE` from the given existing `NODE`. The virtual `NODE` only contains the requested properties.")
    public Node virtualFromNodeFunction(@Name(value="node") Node node, @Name(value="propertyNames") List<String> propertyNames) {
        return new VirtualNode(node, propertyNames);
    }

    @Procedure(value="apoc.create.vNodes")
    @Description(value="Returns virtual `NODE` values.")
    public Stream<NodeResult> vNodes(@Name(value="labels") List<String> labelNames, @Name(value="props") List<Map<String, Object>> props) {
        Label[] labels = Util.labels(labelNames);
        return props.stream().map(p -> new NodeResult(new VirtualNode(labels, (Map<String, Object>)p)));
    }

    @Procedure(value="apoc.create.vRelationship")
    @Description(value="Returns a virtual `RELATIONSHIP`.")
    public Stream<RelationshipResult> vRelationship(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        return Stream.of(new RelationshipResult(this.vRelationshipFunction(from, relType, props, to)));
    }

    @UserFunction(value="apoc.create.vRelationship")
    @Description(value="Returns a virtual `RELATIONSHIP`.")
    public Relationship vRelationshipFunction(@Name(value="from") Node from, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="to") Node to) {
        return new VirtualRelationship(from, to, RelationshipType.withName((String)relType)).withProperties(props);
    }

    @Procedure(value="apoc.create.virtualPath")
    @Description(value="Returns a virtual `PATH`.")
    public Stream<VirtualPathResult> virtualPath(@Name(value="labelsN") List<String> labelsN, @Name(value="n") Map<String, Object> n, @Name(value="relType") String relType, @Name(value="props") Map<String, Object> props, @Name(value="labelsM") List<String> labelsM, @Name(value="m") Map<String, Object> m) {
        RelationshipType type = RelationshipType.withName((String)relType);
        VirtualNode from = new VirtualNode(Util.labels(labelsN), n);
        VirtualNode to = new VirtualNode(Util.labels(labelsM), m);
        Relationship rel = new VirtualRelationship(from, to, type).withProperties(props);
        return Stream.of(new VirtualPathResult(from, rel, to));
    }

    @Procedure(value="apoc.create.clonePathToVirtual")
    @Description(value="Takes the given `PATH` and returns a virtual representation of it.")
    public Stream<PathResult> clonePathToVirtual(@Name(value="path") Path path) {
        return Stream.of(this.createVirtualPath(path, null));
    }

    @Procedure(value="apoc.create.clonePathsToVirtual")
    @Description(value="Takes the given `LIST<PATH>` and returns a virtual representation of them.")
    public Stream<PathResult> clonePathsToVirtual(@Name(value="paths") List<Path> paths) {
        HashMap createdRelationships = new HashMap();
        return paths.stream().map(path -> this.createVirtualPath((Path)path, createdRelationships));
    }

    private PathResult createVirtualPath(Path path, Map<String, Relationship> createdRelationships) {
        Iterable relationships = path.relationships();
        Node first = path.startNode();
        VirtualPath virtualPath = new VirtualPath(new VirtualNode(first, Iterables.asList(first.getPropertyKeys())));
        for (Relationship rel : relationships) {
            Relationship vRel = Create.getVirtualRelPossiblyFromCache(createdRelationships, rel);
            virtualPath.addRel(vRel);
        }
        return new PathResult(virtualPath);
    }

    private static Relationship getVirtualRelPossiblyFromCache(Map<String, Relationship> cacheRel, Relationship rel) {
        if (cacheRel == null) {
            return Create.getVirtualRel(rel);
        }
        return cacheRel.compute(rel.getElementId(), (k, v) -> {
            if (v == null) {
                return Create.getVirtualRel(rel);
            }
            return v;
        });
    }

    private static Relationship getVirtualRel(Relationship rel) {
        VirtualNode start = VirtualNode.from(rel.getStartNode());
        VirtualNode end = VirtualNode.from(rel.getEndNode());
        return VirtualRelationship.from(start, end, rel);
    }

    private <T extends Entity> T setProperties(T pc, Map<String, Object> p) {
        if (p == null) {
            return pc;
        }
        for (Map.Entry<String, Object> entry : p.entrySet()) {
            this.setProperty(pc, entry.getKey(), entry.getValue());
        }
        return pc;
    }

    private <T extends Entity> void setProperty(T pc, String key, Object value) {
        if (value == null) {
            pc.removeProperty(key);
        } else {
            pc.setProperty(key, this.toPropertyValue(value));
        }
    }

    @UserFunction(name="apoc.create.uuid", deprecatedBy="Neo4j randomUUID() function")
    @Deprecated
    @Description(value="Returns a UUID.")
    public String uuid() {
        return UUID.randomUUID().toString();
    }

    @UserFunction(value="apoc.create.uuidBase64")
    @Description(value="Returns a UUID encoded with base64.")
    public String uuidBase64() {
        return UuidUtil.generateBase64Uuid(UUID.randomUUID());
    }

    @UserFunction(value="apoc.create.uuidBase64ToHex")
    @Description(value="Takes the given base64 encoded UUID and returns it as a hexadecimal `STRING`.")
    public String uuidBase64ToHex(@Name(value="base64Uuid") String base64Uuid) {
        return UuidUtil.fromBase64ToHex(base64Uuid);
    }

    @UserFunction(value="apoc.create.uuidHexToBase64")
    @Description(value="Takes the given UUID represented as a hexadecimal `STRING` and returns it encoded with base64.")
    public String uuidHexToBase64(@Name(value="uuid") String uuidHex) {
        return UuidUtil.fromHexToBase64(uuidHex);
    }

    private Object toPropertyValue(Object value) {
        if (value instanceof Iterable) {
            Iterable it = (Iterable)value;
            Object first = Iterables.firstOrNull(it);
            if (first == null) {
                return EMPTY_ARRAY;
            }
            return Iterables.asArray(first.getClass(), it);
        }
        return value;
    }

    @Procedure(name="apoc.create.uuids", deprecatedBy="Neo4j's randomUUID() function can be used as a replacement, for example: `UNWIND range(0,$count) AS row RETURN row, randomUUID() AS uuid`")
    @Deprecated
    @Description(value="Returns a stream of UUIDs.")
    public Stream<UUIDResult> uuids(@Name(value="count") long count) {
        return LongStream.range(0L, count).mapToObj(UUIDResult::new);
    }

    public static class UUIDResult {
        public final long row;
        public final String uuid;

        public UUIDResult(long row) {
            this.row = row;
            this.uuid = UUID.randomUUID().toString();
        }
    }
}

