/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.util.Util;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ConvertConfig {
    private Map<String, List<String>> nodes;
    private Map<String, List<String>> rels;
    private final boolean sortPaths;

    public ConvertConfig(Map<String, Object> config) {
        this.sortPaths = Util.toBoolean(config.getOrDefault("sortPaths", true));
        this.nodes = (Map)config.getOrDefault("nodes", Collections.EMPTY_MAP);
        this.rels = (Map)config.getOrDefault("rels", Collections.EMPTY_MAP);
        this.nodes.values().forEach(s -> this.validateListProperties((List<String>)s));
        this.rels.values().forEach(s -> this.validateListProperties((List<String>)s));
    }

    public Map<String, List<String>> getNodes() {
        return this.nodes;
    }

    public Map<String, List<String>> getRels() {
        return this.rels;
    }

    public boolean isSortPaths() {
        return this.sortPaths;
    }

    private void validateListProperties(List<String> list) {
        boolean isFirstExclude = list.get(0).startsWith("-");
        Optional<String> hasMixedProp = list.stream().skip(1L).filter(prop -> isFirstExclude && !prop.startsWith("-") || !isFirstExclude && prop.startsWith("-")).findFirst();
        if (hasMixedProp.isPresent()) {
            throw new RuntimeException("Only include or exclude attribute are possible!");
        }
    }
}

