/*
 * Decompiled with CFR 0.152.
 */
package apoc.convert;

import apoc.coll.SetBackedList;
import apoc.convert.ConvertUtils;
import apoc.meta.Types;
import apoc.util.Util;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserFunction;

public class Convert {
    @UserFunction(value="apoc.convert.toMap")
    @Description(value="Converts the given value into a `MAP`.")
    public Map<String, Object> toMap(@Name(value="map") Object map) {
        if (map instanceof Entity) {
            return ((Entity)map).getAllProperties();
        }
        if (map instanceof Map) {
            return (Map)map;
        }
        return null;
    }

    @UserFunction(value="apoc.convert.toList")
    @Description(value="Converts the given value into a `LIST<ANY>`.")
    public List<Object> toList(@Name(value="value") Object list) {
        return ConvertUtils.convertToList(list);
    }

    @UserFunction(value="apoc.convert.toNode")
    @Description(value="Converts the given value into a `NODE`.")
    public Node toNode(@Name(value="node") Object node) {
        return node instanceof Node ? (Node)node : null;
    }

    @UserFunction(value="apoc.convert.toRelationship")
    @Description(value="Converts the given value into a `RELATIONSHIP`.")
    public Relationship toRelationship(@Name(value="rel") Object relationship) {
        return relationship instanceof Relationship ? (Relationship)relationship : null;
    }

    private <T> List<T> convertToList(Object list, Class<T> type) {
        List convertedList = ConvertUtils.convertToList(list);
        if (convertedList == null) {
            return null;
        }
        Stream<Object> stream = null;
        Types varType = Types.of(type);
        switch (varType) {
            case INTEGER: {
                stream = convertedList.stream().map(Util::toLong);
                break;
            }
            case FLOAT: {
                stream = convertedList.stream().map(Util::toDouble);
                break;
            }
            case STRING: {
                stream = convertedList.stream().map(Util::toString);
                break;
            }
            case BOOLEAN: {
                stream = convertedList.stream().map(Util::toBoolean);
                break;
            }
            case NODE: {
                stream = convertedList.stream().map(this::toNode);
                break;
            }
            case RELATIONSHIP: {
                stream = convertedList.stream().map(this::toRelationship);
                break;
            }
            default: {
                throw new RuntimeException("Supported types are: Integer, Float, String, Boolean, Node, Relationship");
            }
        }
        return stream.collect(Collectors.toList());
    }

    @UserFunction(value="apoc.convert.toSet")
    @Description(value="Converts the given value into a set represented in Cypher as a `LIST<ANY>`.")
    public List<Object> toSet(@Name(value="list") Object value) {
        List list = ConvertUtils.convertToList(value);
        return list == null ? null : new SetBackedList(new LinkedHashSet(list));
    }

    @UserFunction(value="apoc.convert.toNodeList")
    @Description(value="Converts the given value into a `LIST<NODE>`.")
    public List<Node> toNodeList(@Name(value="list") Object list) {
        return this.convertToList(list, Node.class);
    }

    @UserFunction(value="apoc.convert.toRelationshipList")
    @Description(value="Converts the given value into a `LIST<RELATIONSHIP>`.")
    public List<Relationship> toRelationshipList(@Name(value="relList") Object list) {
        return this.convertToList(list, Relationship.class);
    }
}

