/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

final class StandardDeviation {
    private StandardDeviation() {
    }

    public static double stdDev(double[] values, boolean isBiasCorrected) {
        return Math.sqrt(StandardDeviation.variance(values, isBiasCorrected));
    }

    private static double variance(double[] values, boolean isBiasCorrected) {
        double variance = Double.NaN;
        int length = values.length;
        if (length == 1) {
            variance = 0.0;
        } else if (length > 1) {
            double m = StandardDeviation.meanValue(values, length);
            double accum = 0.0;
            double accum2 = 0.0;
            for (double value : values) {
                double dev = value - m;
                accum += dev * dev;
                accum2 += dev;
            }
            double len = length;
            variance = isBiasCorrected ? (accum - accum2 * accum2 / len) / (len - 1.0) : (accum - accum2 * accum2 / len) / len;
        }
        return variance;
    }

    private static double meanValue(double[] values, int length) {
        double sum = 0.0;
        for (double i : values) {
            sum += i;
        }
        double xbar = sum / (double)length;
        double correction = 0.0;
        for (double value : values) {
            correction += value - xbar;
        }
        return xbar + correction / (double)length;
    }
}

