/*
 * Decompiled with CFR 0.152.
 */
package apoc.coll;

import apoc.coll.Combinations;
import apoc.coll.SetBackedList;
import apoc.coll.StandardDeviation;
import apoc.convert.ConvertUtils;
import apoc.result.ListResult;
import apoc.util.Util;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.RandomAccess;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.NotThreadSafe;
import org.neo4j.procedure.Procedure;
import org.neo4j.procedure.UserFunction;
import org.neo4j.values.AnyValue;

public class Coll {
    public static final char ASCENDING_ORDER_CHAR = '^';
    @Context
    public Transaction tx;

    @UserFunction(value="apoc.coll.stdev")
    @Description(value="Returns sample or population standard deviation with `isBiasCorrected` true or false respectively.")
    public Number stdev(@Name(value="list") List<Number> list, @Name(value="isBiasCorrected", defaultValue="true") boolean isBiasCorrected) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        double stdev = StandardDeviation.stdDev(list.stream().mapToDouble(Number::doubleValue).toArray(), isBiasCorrected);
        if ((double)((long)stdev) == stdev) {
            return (long)stdev;
        }
        return stdev;
    }

    @UserFunction(value="apoc.coll.runningTotal")
    @Description(value="Returns an accumulative `LIST<INTEGER | FLOAT>`.")
    public List<Number> runningTotal(@Name(value="list") List<Number> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        MutableDouble sum = new MutableDouble();
        return list.stream().map(i -> {
            double value = sum.addAndGet(i.doubleValue());
            if (value == (double)sum.longValue()) {
                return sum.longValue();
            }
            return value;
        }).collect(Collectors.toList());
    }

    @Procedure(value="apoc.coll.zipToRows")
    @Description(value="Returns the two `LIST<ANY>` values zipped together, with one row per zipped pair.")
    public Stream<ListResult> zipToRows(@Name(value="list1") List<Object> list1, @Name(value="list2") List<Object> list2) {
        if (list1.isEmpty()) {
            return Stream.empty();
        }
        ListIterator<Object> it = list2.listIterator();
        return list1.stream().map(e -> new ListResult(Arrays.asList(e, it.hasNext() ? it.next() : null)));
    }

    @UserFunction(value="apoc.coll.zip")
    @Description(value="Returns the two given `LIST<ANY>` values zipped together as a `LIST<LIST<ANY>>`.")
    public List<List<Object>> zip(@Name(value="list1") List<Object> list1, @Name(value="list2") List<Object> list2) {
        if (list1 == null || list2 == null) {
            return null;
        }
        if (list1.isEmpty() || list2.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(list1.size());
        ListIterator<Object> it = list2.listIterator();
        for (Object o1 : list1) {
            result.add(Arrays.asList(o1, it.hasNext() ? it.next() : null));
        }
        return result;
    }

    @UserFunction(value="apoc.coll.pairs")
    @Description(value="Returns a `LIST<ANY>` of adjacent elements in the `LIST<ANY>` ([1,2],[2,3],[3,null]).")
    public List<List<Object>> pairs(@Name(value="list") List<Object> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return this.zip(list, list.subList(1, list.size()));
    }

    @UserFunction(value="apoc.coll.pairsMin")
    @Description(value="Returns `LIST<ANY>` values of adjacent elements in the `LIST<ANY>` ([1,2],[2,3]), skipping the final element.")
    public List<List<Object>> pairsMin(@Name(value="list") List<Object> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        return this.zip(list.subList(0, list.size() - 1), list.subList(1, list.size()));
    }

    @UserFunction(value="apoc.coll.sum")
    @Description(value="Returns the sum of all the `INTEGER | FLOAT` in the `LIST<INTEGER | FLOAT>`.")
    public Double sum(@Name(value="coll") List<Number> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        double sum = 0.0;
        for (Number number : list) {
            sum += number.doubleValue();
        }
        return sum;
    }

    @UserFunction(value="apoc.coll.avg")
    @Description(value="Returns the average of the numbers in the `LIST<INTEGER | FLOAT>`.")
    public Double avg(@Name(value="coll") List<Number> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        double avg = 0.0;
        for (Number number : list) {
            avg += number.doubleValue();
        }
        return avg / (double)list.size();
    }

    @NotThreadSafe
    @UserFunction(value="apoc.coll.min")
    @Description(value="Returns the minimum of all values in the given `LIST<ANY>`.")
    public Object min(@Name(value="values") List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        try (Result result = this.tx.execute("cypher runtime=slotted return reduce(res=null, x in $list | CASE WHEN res IS NULL OR x<res THEN x ELSE res END) as value", Collections.singletonMap("list", list));){
            Object v = result.next().get("value");
            return v;
        }
    }

    @NotThreadSafe
    @UserFunction(value="apoc.coll.max")
    @Description(value="Returns the maximum of all values in the given `LIST<ANY>`.")
    public Object max(@Name(value="values") List<Object> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        try (Result result = this.tx.execute("cypher runtime=slotted return reduce(res=null, x in $list | CASE WHEN res IS NULL OR res<x THEN x ELSE res END) as value", Collections.singletonMap("list", list));){
            Object v = result.next().get("value");
            return v;
        }
    }

    @Procedure(value="apoc.coll.elements")
    @Description(value="Deconstructs a `LIST<ANY>` into identifiers indicating their specific type.")
    public Stream<ElementsResult> elements(@Name(value="coll") List<Object> list, @Name(value="limit", defaultValue="-1") long limit, @Name(value="offset", defaultValue="0") long offset) {
        int elements = (limit < 0L ? list.size() : Math.min((int)(offset + limit), list.size())) - (int)offset;
        if (elements > 10) {
            elements = 10;
        }
        ElementsResult result = new ElementsResult();
        for (int i = 0; i < elements; ++i) {
            result.add(list.get((int)offset + i));
        }
        return Stream.of(result);
    }

    @Procedure(value="apoc.coll.partition")
    @Description(value="Partitions the original `LIST<ANY>` into a new `LIST<ANY>` of the given batch size.\nThe final `LIST<ANY>` may be smaller than the given batch size.")
    public Stream<ListResult> partition(@Name(value="coll") List<Object> list, @Name(value="batchSize") long batchSize) {
        if (list == null || list.isEmpty()) {
            return Stream.empty();
        }
        return this.partitionList(list, (int)batchSize).map(ListResult::new);
    }

    @UserFunction(value="apoc.coll.partition")
    @Description(value="Partitions the original `LIST<ANY>` into a new `LIST<ANY>` of the given batch size.\nThe final `LIST<ANY>` may be smaller than the given batch size.")
    public List<Object> partitionFn(@Name(value="coll") List<Object> list, @Name(value="batchSize") long batchSize) {
        if (list == null || list.isEmpty()) {
            return new ArrayList<Object>();
        }
        return this.partitionList(list, (int)batchSize).collect(Collectors.toList());
    }

    @Procedure(value="apoc.coll.split")
    @Description(value="Splits a collection by the given value.\nThe value itself will not be part of the resulting `LIST<ANY>` values.")
    public Stream<ListResult> split(@Name(value="coll") List<Object> list, @Name(value="value") Object value) {
        if (list == null || list.isEmpty()) {
            return Stream.empty();
        }
        List<Object> l = new ArrayList<Object>(list);
        ArrayList result = new ArrayList(10);
        int idx = Util.indexOf(l, value);
        while (idx != -1) {
            List subList = l.subList(0, idx);
            if (!subList.isEmpty()) {
                result.add(subList);
            }
            l = l.subList(idx + 1, l.size());
            idx = Util.indexOf(l, value);
        }
        if (!l.isEmpty()) {
            result.add(l);
        }
        return result.stream().map(ListResult::new);
    }

    private Stream<List<Object>> partitionList(@Name(value="values") List list, @Name(value="batchSize") int batchSize) {
        int total = list.size();
        int pages = total % batchSize == 0 ? total / batchSize : total / batchSize + 1;
        return IntStream.range(0, pages).parallel().boxed().map(page -> {
            int from = page * batchSize;
            return list.subList(from, Math.min(from + batchSize, total));
        });
    }

    @UserFunction(value="apoc.coll.contains")
    @Description(value="Returns whether or not the given value exists in the given collection (using a HashSet).")
    public boolean contains(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        return new HashSet<Object>(coll).contains(value);
    }

    @UserFunction(value="apoc.coll.set")
    @Description(value="Sets the element at the given index to the new value.")
    public List<Object> set(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="value") Object value) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || value == null || index >= (long)coll.size()) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        list.set((int)index, value);
        return list;
    }

    @UserFunction(value="apoc.coll.insert")
    @Description(value="Inserts a value into the specified index in the `LIST<ANY>`.")
    public List<Object> insert(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="value") Object value) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || value == null || index > (long)coll.size()) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        list.add((int)index, value);
        return list;
    }

    @UserFunction(value="apoc.coll.insertAll")
    @Description(value="Inserts all of the values into the `LIST<ANY>`, starting at the specified index.")
    public List<Object> insertAll(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="values") List<Object> values) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || values == null || values.isEmpty() || index > (long)coll.size()) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        list.addAll((int)index, values);
        return list;
    }

    @UserFunction(value="apoc.coll.remove")
    @Description(value="Removes a range of values from the `LIST<ANY>`, beginning at position index for the given length of values.")
    public List<Object> remove(@Name(value="coll") List<Object> coll, @Name(value="index") long index, @Name(value="length", defaultValue="1") long length) {
        if (coll == null) {
            return null;
        }
        if (index < 0L || index >= (long)coll.size() || length <= 0L) {
            return coll;
        }
        ArrayList<Object> list = new ArrayList<Object>(coll);
        for (long i = index + length - 1L; i >= index; --i) {
            if (i >= (long)list.size()) continue;
            list.remove((int)i);
        }
        return list;
    }

    @UserFunction(value="apoc.coll.indexOf")
    @Description(value="Returns the index for the first occurrence of the specified value in the `LIST<ANY>`.")
    public long indexOf(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        if (coll == null || coll.isEmpty()) {
            return -1L;
        }
        return Util.indexOf(coll, value);
    }

    @UserFunction(value="apoc.coll.containsAll")
    @Description(value="Returns whether or not all of the given values exist in the given collection (using a HashSet).")
    public boolean containsAll(@Name(value="coll1") List<Object> coll, @Name(value="coll2") List<Object> values) {
        if (coll == null || coll.isEmpty() || values == null) {
            return false;
        }
        HashSet<Object> objects = new HashSet<Object>(coll);
        return values.stream().allMatch(i -> Util.containsValueEquals(objects, i));
    }

    @UserFunction(value="apoc.coll.containsSorted")
    @Description(value="Returns whether or not the given value exists in an already sorted collection (using a binary search).")
    public boolean containsSorted(@Name(value="coll") List<Object> coll, @Name(value="value") Object value) {
        if (coll == null || coll.isEmpty()) {
            return false;
        }
        int batchSize = 4999;
        ArrayList list = coll instanceof RandomAccess || coll.size() < batchSize ? coll : new ArrayList(coll);
        return Collections.binarySearch(list, value) >= 0;
    }

    @UserFunction(value="apoc.coll.containsAllSorted")
    @Description(value="Returns whether or not all of the given values in the second `LIST<ANY>` exist in an already sorted collection (using a binary search).")
    public boolean containsAllSorted(@Name(value="coll1") List<Object> coll, @Name(value="coll2") List<Object> values) {
        if (coll == null || values == null) {
            return false;
        }
        int batchSize = 4999;
        ArrayList list = coll instanceof RandomAccess || coll.size() < batchSize ? coll : new ArrayList(coll);
        for (Object value : values) {
            boolean result = Collections.binarySearch(list, value) >= 0;
            if (result) continue;
            return false;
        }
        return true;
    }

    @UserFunction(value="apoc.coll.isEqualCollection")
    @Description(value="Returns true if the two collections contain the same elements with the same cardinality in any order (using a HashMap).")
    public boolean isEqualCollection(@Name(value="coll") List<Object> first, @Name(value="values") List<Object> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null || first.size() != second.size()) {
            return false;
        }
        Map map1 = first.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        Map map2 = second.stream().collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        return map1.equals(map2);
    }

    @UserFunction(value="apoc.coll.toSet")
    @Description(value="Returns a unique `LIST<ANY>` from the given `LIST<ANY>`.")
    public List<Object> toSet(@Name(value="coll") List<Object> list) {
        if (list == null) {
            return null;
        }
        List<AnyValue> anyValues = Util.toAnyValues(list);
        return new SetBackedList<AnyValue>(new LinkedHashSet<AnyValue>(anyValues));
    }

    @UserFunction(value="apoc.coll.sumLongs")
    @Description(value="Returns the sum of all the `INTEGER | FLOAT` in the `LIST<INTEGER | FLOAT>`.")
    public Long sumLongs(@Name(value="coll") List<Number> list) {
        if (list == null) {
            return null;
        }
        long sum = 0L;
        for (Number number : list) {
            sum += number.longValue();
        }
        return sum;
    }

    @UserFunction(value="apoc.coll.sort")
    @Description(value="Sorts the given `LIST<ANY>` into ascending order.")
    public List<Object> sort(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> sorted = new ArrayList<Object>(coll);
        Collections.sort(sorted);
        return sorted;
    }

    @UserFunction(value="apoc.coll.sortNodes")
    @Description(value="Sorts the given `LIST<NODE>` by the property of the nodes into descending order.")
    public List<Node> sortNodes(@Name(value="coll") List<Node> coll, @Name(value="prop") String prop) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Node> sorted = new ArrayList<Node>(coll);
        int reverseOrder = this.reverseOrder(prop);
        String cleanedProp = this.cleanProperty(prop);
        Collections.sort(sorted, (x, y) -> reverseOrder * Coll.compare(x.getProperty(cleanedProp, null), y.getProperty(cleanedProp, null)));
        return sorted;
    }

    @UserFunction(value="apoc.coll.sortMaps")
    @Description(value="Sorts the given `LIST<MAP<STRING, ANY>>` into descending order, based on the `MAP` property indicated by `prop`.")
    public List<Map<String, Object>> sortMaps(@Name(value="list") List<Map<String, Object>> coll, @Name(value="prop") String prop) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> sorted = new ArrayList<Map<String, Object>>(coll);
        int reverseOrder = this.reverseOrder(prop);
        String cleanedProp = this.cleanProperty(prop);
        Collections.sort(sorted, (x, y) -> reverseOrder * Coll.compare(x.get(cleanedProp), y.get(cleanedProp)));
        return sorted;
    }

    public int reverseOrder(String prop) {
        return prop.charAt(0) == '^' ? 1 : -1;
    }

    public String cleanProperty(String prop) {
        return prop.charAt(0) == '^' ? prop.substring(1) : prop;
    }

    public static int compare(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.equals(o2)) {
            return 0;
        }
        if (o1 instanceof Number && o2 instanceof Number) {
            if (o1 instanceof Double || o2 instanceof Double || o1 instanceof Float || o2 instanceof Float) {
                return Double.compare(((Number)o1).doubleValue(), ((Number)o2).doubleValue());
            }
            return Long.compare(((Number)o1).longValue(), ((Number)o2).longValue());
        }
        if (o1 instanceof Boolean) {
            Boolean b1 = (Boolean)o1;
            if (o2 instanceof Boolean) {
                return b1 != false ? 1 : -1;
            }
        }
        if (o1 instanceof Node) {
            Node n1 = (Node)o1;
            if (o2 instanceof Node) {
                Node n2 = (Node)o2;
                return n1.getElementId().compareTo(n2.getElementId());
            }
        }
        if (o1 instanceof Relationship) {
            Relationship rel1 = (Relationship)o1;
            if (o2 instanceof Relationship) {
                Relationship rel2 = (Relationship)o2;
                return rel1.getElementId().compareTo(rel2.getElementId());
            }
        }
        return o1.toString().compareTo(o2.toString());
    }

    @UserFunction(value="apoc.coll.union")
    @Description(value="Returns the distinct union of the two given `LIST<ANY>` values.")
    public List<Object> union(@Name(value="list1") List<Object> first, @Name(value="list2") List<Object> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        HashSet<Object> set = new HashSet<Object>(first);
        set.addAll(second);
        return new SetBackedList<Object>(set);
    }

    @UserFunction(value="apoc.coll.removeAll")
    @Description(value="Returns the first `LIST<ANY>` with all elements also present in the second `LIST<ANY>` removed.")
    public List<Object> removeAll(@Name(value="list1") List<Object> first, @Name(value="list2") List<Object> second) {
        if (first == null) {
            return null;
        }
        ArrayList<AnyValue> list = new ArrayList<AnyValue>(Util.toAnyValues(first));
        if (second != null) {
            list.removeAll(Util.toAnyValues(second));
        }
        return list;
    }

    @UserFunction(value="apoc.coll.subtract")
    @Description(value="Returns the first `LIST<ANY>` as a set with all the elements of the second `LIST<ANY>` removed.")
    public List<Object> subtract(@Name(value="list1") List<Object> first, @Name(value="list2") List<Object> second) {
        if (first == null) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>(first);
        if (second != null) {
            set.removeAll(second);
        }
        return new SetBackedList<Object>(set);
    }

    @UserFunction(value="apoc.coll.intersection")
    @Description(value="Returns the distinct intersection of two `LIST<ANY>` values.")
    public List<Object> intersection(@Name(value="list1") List<Object> first, @Name(value="list2") List<Object> second) {
        if (first == null || second == null) {
            return Collections.emptyList();
        }
        HashSet<Object> set = new HashSet<Object>(first);
        set.retainAll(second);
        return new SetBackedList<Object>(set);
    }

    @UserFunction(value="apoc.coll.disjunction")
    @Description(value="Returns the disjunct set from two `LIST<ANY>` values.")
    public List<Object> disjunction(@Name(value="list1") List<Object> first, @Name(value="list2") List<Object> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        HashSet<Object> intersection = new HashSet<Object>(first);
        intersection.retainAll(second);
        HashSet<Object> set = new HashSet<Object>(first);
        set.addAll(second);
        set.removeAll(intersection);
        return new SetBackedList<Object>(set);
    }

    @UserFunction(value="apoc.coll.unionAll")
    @Description(value="Returns the full union of the two given `LIST<ANY>` values (duplicates included).")
    public List<Object> unionAll(@Name(value="list1") List<Object> first, @Name(value="list2") List<Object> second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        ArrayList<Object> list = new ArrayList<Object>(first);
        list.addAll(second);
        return list;
    }

    @UserFunction(value="apoc.coll.shuffle")
    @Description(value="Returns the `LIST<ANY>` shuffled.")
    public List<Object> shuffle(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        if (coll.size() == 1) {
            return coll;
        }
        ArrayList<Object> shuffledList = new ArrayList<Object>(coll);
        Collections.shuffle(shuffledList);
        return shuffledList;
    }

    @UserFunction(value="apoc.coll.randomItem")
    @Description(value="Returns a random item from the `LIST<ANY>`, or null on `LIST<NOTHING>` or `LIST<NULL>`.")
    public Object randomItem(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        if (coll.size() == 1) {
            return coll.get(0);
        }
        return coll.get(ThreadLocalRandom.current().nextInt(coll.size()));
    }

    @UserFunction(value="apoc.coll.randomItems")
    @Description(value="Returns a `LIST<ANY>` of `itemCount` random items from the original `LIST<ANY>` (optionally allowing elements in the original `LIST<ANY>` to be selected more than once).")
    public List<Object> randomItems(@Name(value="coll") List<Object> coll, @Name(value="itemCount") long itemCount, @Name(value="allowRepick", defaultValue="false") boolean allowRepick) {
        if (coll == null || coll.isEmpty() || itemCount <= 0L) {
            return Collections.emptyList();
        }
        ArrayList<Object> pickList = new ArrayList<Object>(coll);
        ArrayList<Object> randomItems = new ArrayList<Object>((int)itemCount);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        if (!allowRepick && itemCount >= (long)coll.size()) {
            Collections.shuffle(pickList);
            return pickList;
        }
        while ((long)randomItems.size() < itemCount) {
            Object item = allowRepick ? pickList.get(((Random)random).nextInt(pickList.size())) : pickList.remove(((Random)random).nextInt(pickList.size()));
            randomItems.add(item);
        }
        return randomItems;
    }

    @UserFunction(value="apoc.coll.containsDuplicates")
    @Description(value="Returns true if a collection contains duplicate elements.")
    public boolean containsDuplicates(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() <= 1) {
            return false;
        }
        HashSet<Object> set = new HashSet<Object>(coll);
        return set.size() < coll.size();
    }

    @UserFunction(value="apoc.coll.duplicates")
    @Description(value="Returns a `LIST<ANY>` of duplicate items in the collection.")
    public List<Object> duplicates(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() <= 1) {
            return Collections.emptyList();
        }
        HashSet<Object> set = new HashSet<Object>(coll.size());
        LinkedHashSet<Object> duplicates = new LinkedHashSet<Object>();
        for (Object obj : coll) {
            if (set.add(obj)) continue;
            duplicates.add(obj);
        }
        return new ArrayList<Object>(duplicates);
    }

    @UserFunction(value="apoc.coll.duplicatesWithCount")
    @Description(value="Returns a `LIST<ANY>` of duplicate items in the collection and their count, keyed by `item` and `count`.")
    public List<Map<String, Object>> duplicatesWithCount(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() <= 1) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, MutableInt> duplicates = new LinkedHashMap<Object, MutableInt>(coll.size());
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Object obj : coll) {
            MutableInt counter = (MutableInt)duplicates.get(obj);
            if (counter == null) {
                counter = new MutableInt();
                duplicates.put(obj, counter);
            }
            counter.increment();
        }
        duplicates.forEach((o, intCounter) -> {
            int count = intCounter.intValue();
            if (count > 1) {
                LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>(2);
                entry.put("item", o);
                entry.put("count", Long.valueOf(count));
                resultList.add(entry);
            }
        });
        return resultList;
    }

    @UserFunction(value="apoc.coll.frequencies")
    @Description(value="Returns a `LIST<ANY>` of frequencies of the items in the collection, keyed by `item` and `count`.")
    public List<Map<String, Object>> frequencies(@Name(value="coll") List<Object> coll) {
        if (coll == null || coll.size() == 0) {
            return Collections.emptyList();
        }
        LinkedHashMap<Object, MutableInt> counts = new LinkedHashMap<Object, MutableInt>(coll.size());
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        for (Object obj : coll) {
            MutableInt counter = (MutableInt)counts.get(obj);
            if (counter == null) {
                counter = new MutableInt();
                counts.put(obj, counter);
            }
            counter.increment();
        }
        counts.forEach((o, intCounter) -> {
            int count = intCounter.intValue();
            LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>(2);
            entry.put("item", o);
            entry.put("count", Long.valueOf(count));
            resultList.add(entry);
        });
        return resultList;
    }

    @UserFunction(value="apoc.coll.frequenciesAsMap")
    @Description(value="Returns a `MAP` of frequencies of the items in the collection, keyed by `item` and `count`.")
    public Map<String, Object> frequenciesAsMap(@Name(value="coll") List<Object> coll) {
        if (coll == null) {
            return Collections.emptyMap();
        }
        return this.frequencies(coll).stream().collect(Collectors.toMap(t -> t.get("item").toString(), v -> v.get("count")));
    }

    @UserFunction(value="apoc.coll.occurrences")
    @Description(value="Returns the count of the given item in the collection.")
    public long occurrences(@Name(value="coll") List<Object> coll, @Name(value="item") Object item) {
        if (coll == null || coll.isEmpty()) {
            return 0L;
        }
        long occurrences = 0L;
        for (Object obj : coll) {
            if (!item.equals(obj)) continue;
            ++occurrences;
        }
        return occurrences;
    }

    @UserFunction(value="apoc.coll.flatten")
    @Description(value="Flattens the given `LIST<ANY>` (to flatten nested `LIST<ANY>` values, set recursive to true).")
    public List<Object> flatten(@Name(value="coll") List<Object> coll, @Name(value="recursive", defaultValue="false") boolean recursive) {
        if (coll == null) {
            return Collections.emptyList();
        }
        if (recursive) {
            return Coll.flattenRecursive(coll, 0);
        }
        return Coll.flattenRecursive(coll, 0, 2);
    }

    private static List<Object> flattenRecursive(Object aObject, int aDepth, int aStopDepth) {
        ArrayList<Object> vResult = new ArrayList<Object>();
        if (aDepth == aStopDepth) {
            vResult.add(aObject);
        } else if (aObject.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(aObject); ++i) {
                vResult.addAll(Coll.flattenRecursive(Array.get(aObject, i), aDepth + 1, aStopDepth));
            }
        } else if (aObject instanceof List) {
            for (Object vElement : (List)aObject) {
                vResult.addAll(Coll.flattenRecursive(vElement, aDepth + 1, aStopDepth));
            }
        } else {
            vResult.add(aObject);
        }
        return vResult;
    }

    private static List<Object> flattenRecursive(Object aObject, int aDepth) {
        return Coll.flattenRecursive(aObject, aDepth, -1);
    }

    @UserFunction(value="apoc.coll.sortMulti")
    @Description(value="Sorts the given `LIST<MAP<STRING, ANY>>` by the given fields.\nTo indicate that a field should be sorted according to ascending values, prefix it with a caret (^).\nIt is also possible to add limits to the `LIST<MAP<STRING, ANY>>` and to skip values.")
    public List<Map<String, Object>> sortMulti(@Name(value="coll") List<Map<String, Object>> coll, @Name(value="orderFields", defaultValue="[]") List<String> orderFields, @Name(value="limit", defaultValue="-1") long limit, @Name(value="skip", defaultValue="0") long skip) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(coll);
        if (orderFields != null && !orderFields.isEmpty()) {
            List fields = orderFields.stream().map(v -> {
                boolean asc = v.charAt(0) == '^';
                return Pair.of(asc ? v.substring(1) : v, asc);
            }).collect(Collectors.toList());
            Comparator compare = (o1, o2) -> {
                int a = 0;
                for (Pair s : fields) {
                    Comparable v2;
                    if (a != 0) break;
                    String name = (String)s.getLeft();
                    Comparable v1 = (Comparable)o1.get(name);
                    if (v1 == (v2 = (Comparable)o2.get(name))) continue;
                    int cmp = v1 == null ? -1 : (v2 == null ? 1 : v1.compareTo(v2));
                    a = (Boolean)s.getRight() != false ? cmp : -cmp;
                }
                return a;
            };
            Collections.sort(result, compare);
        }
        if (skip > 0L && limit != -1L) {
            return result.subList((int)skip, (int)(skip + limit));
        }
        if (skip > 0L) {
            return result.subList((int)skip, result.size());
        }
        if (limit != -1L) {
            return result.subList(0, (int)limit);
        }
        return result;
    }

    @UserFunction(value="apoc.coll.combinations")
    @Description(value="Returns a collection of all combinations of `LIST<ANY>` elements between the selection size `minSelect` and `maxSelect` (default: `minSelect`).")
    public List<List<Object>> combinations(@Name(value="coll") List<Object> coll, @Name(value="minSelect") long minSelectIn, @Name(value="maxSelect", defaultValue="-1") long maxSelectIn) {
        int minSelect = (int)minSelectIn;
        int maxSelect = (int)maxSelectIn;
        int n = maxSelect = maxSelect == -1 ? minSelect : maxSelect;
        if (coll == null || coll.isEmpty() || minSelect < 1 || minSelect > coll.size() || minSelect > maxSelect || maxSelect > coll.size()) {
            return Collections.emptyList();
        }
        ArrayList<List<Object>> combinations = new ArrayList<List<Object>>();
        for (int i = minSelect; i <= maxSelect; ++i) {
            Iterator<int[]> itr = new Combinations(coll.size(), i).iterator();
            while (itr.hasNext()) {
                ArrayList<Object> entry = new ArrayList<Object>(i);
                int[] indexes = itr.next();
                if (indexes.length <= 0) continue;
                for (int index : indexes) {
                    entry.add(coll.get(index));
                }
                combinations.add(entry);
            }
        }
        return combinations;
    }

    @UserFunction(value="apoc.coll.different")
    @Description(value="Returns true if all the values in the given `LIST<ANY>` are unique.")
    public boolean different(@Name(value="coll") List<Object> values) {
        if (values == null) {
            return false;
        }
        return new HashSet<Object>(values).size() == values.size();
    }

    @UserFunction(value="apoc.coll.dropDuplicateNeighbors")
    @Description(value="Removes duplicate consecutive objects in the `LIST<ANY>`.")
    public List<Object> dropDuplicateNeighbors(@Name(value="list") List<Object> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object> newList = new ArrayList<Object>(list.size());
        Object last = null;
        for (Object element : list) {
            if ((element != null || last == null) && (element == null || element.equals(last))) continue;
            newList.add(element);
            last = element;
        }
        return newList;
    }

    @UserFunction(value="apoc.coll.fill")
    @Description(value="Returns a `LIST<ANY>` with the given count of items.")
    public List<Object> fill(@Name(value="items") String item, @Name(value="count") long count) {
        return Collections.nCopies((int)count, item);
    }

    @UserFunction(value="apoc.coll.sortText")
    @Description(value="Sorts the given `LIST<STRING>` into ascending order.")
    public List<String> sortText(@Name(value="coll") List<String> coll, @Name(value="conf", defaultValue="{}") Map<String, Object> conf) {
        if (conf == null) {
            conf = Collections.emptyMap();
        }
        if (coll == null || coll.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> sorted = new ArrayList<String>(coll);
        String localeAsStr = conf.getOrDefault("locale", "").toString();
        Locale locale = !localeAsStr.isBlank() ? Locale.forLanguageTag(localeAsStr) : null;
        Collator collator = locale != null ? Collator.getInstance(locale) : Collator.getInstance();
        Collections.sort(sorted, collator);
        return sorted;
    }

    @UserFunction(value="apoc.coll.pairWithOffset")
    @Description(value="Returns a `LIST<ANY>` of pairs defined by the offset.")
    public List<List<Object>> pairWithOffsetFn(@Name(value="coll") List<Object> values, @Name(value="offset") long offset) {
        if (values == null) {
            return null;
        }
        BiFunction<List, Long, Object> extract = (list, index) -> index < (long)list.size() && index >= 0L ? list.get(index.intValue()) : null;
        int length = Double.valueOf(Math.ceil((double)values.size() / (double)Math.abs(offset))).intValue();
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(length);
        for (long i = 0L; i < (long)values.size(); ++i) {
            List<Object> objects = Arrays.asList(extract.apply(values, i), extract.apply(values, i + offset));
            result.add(objects);
        }
        return result;
    }

    @Procedure(value="apoc.coll.pairWithOffset")
    @Description(value="Returns a `LIST<ANY>` of pairs defined by the offset.")
    public Stream<ListResult> pairWithOffset(@Name(value="coll") List<Object> values, @Name(value="offset") long offset) {
        return this.pairWithOffsetFn(values, offset).stream().map(ListResult::new);
    }

    public static class ElementsResult {
        public Object _1;
        public Object _2;
        public Object _3;
        public Object _4;
        public Object _5;
        public Object _6;
        public Object _7;
        public Object _8;
        public Object _9;
        public Object _10;
        public String _1s;
        public String _2s;
        public String _3s;
        public String _4s;
        public String _5s;
        public String _6s;
        public String _7s;
        public String _8s;
        public String _9s;
        public String _10s;
        public Long _1i;
        public Long _2i;
        public Long _3i;
        public Long _4i;
        public Long _5i;
        public Long _6i;
        public Long _7i;
        public Long _8i;
        public Long _9i;
        public Long _10i;
        public Double _1f;
        public Double _2f;
        public Double _3f;
        public Double _4f;
        public Double _5f;
        public Double _6f;
        public Double _7f;
        public Double _8f;
        public Double _9f;
        public Double _10f;
        public Boolean _1b;
        public Boolean _2b;
        public Boolean _3b;
        public Boolean _4b;
        public Boolean _5b;
        public Boolean _6b;
        public Boolean _7b;
        public Boolean _8b;
        public Boolean _9b;
        public Boolean _10b;
        public List<Object> _1l;
        public List<Object> _2l;
        public List<Object> _3l;
        public List<Object> _4l;
        public List<Object> _5l;
        public List<Object> _6l;
        public List<Object> _7l;
        public List<Object> _8l;
        public List<Object> _9l;
        public List<Object> _10l;
        public Map<String, Object> _1m;
        public Map<String, Object> _2m;
        public Map<String, Object> _3m;
        public Map<String, Object> _4m;
        public Map<String, Object> _5m;
        public Map<String, Object> _6m;
        public Map<String, Object> _7m;
        public Map<String, Object> _8m;
        public Map<String, Object> _9m;
        public Map<String, Object> _10m;
        public Node _1n;
        public Node _2n;
        public Node _3n;
        public Node _4n;
        public Node _5n;
        public Node _6n;
        public Node _7n;
        public Node _8n;
        public Node _9n;
        public Node _10n;
        public Relationship _1r;
        public Relationship _2r;
        public Relationship _3r;
        public Relationship _4r;
        public Relationship _5r;
        public Relationship _6r;
        public Relationship _7r;
        public Relationship _8r;
        public Relationship _9r;
        public Relationship _10r;
        public Path _1p;
        public Path _2p;
        public Path _3p;
        public Path _4p;
        public Path _5p;
        public Path _6p;
        public Path _7p;
        public Path _8p;
        public Path _9p;
        public Path _10p;
        public long elements;
        static final int MAX_ELEMENTS = 10;

        void add(Object o) {
            if (this.elements == 10L) {
                return;
            }
            if (o != null && o.getClass().isArray()) {
                o = ConvertUtils.convertArrayToList(o);
            }
            this.setObject(o, (int)this.elements);
            if (o instanceof String) {
                this.setString((String)o, (int)this.elements);
            }
            if (o instanceof Number) {
                this.setLong(((Number)o).longValue(), (int)this.elements);
                this.setDouble(((Number)o).doubleValue(), (int)this.elements);
            }
            if (o instanceof Boolean) {
                this.setBoolean((Boolean)o, (int)this.elements);
            }
            if (o instanceof Map) {
                this.setMap((Map)o, (int)this.elements);
            }
            if (o instanceof List) {
                this.setList((List)o, (int)this.elements);
            }
            if (o instanceof Node) {
                this.setNode((Node)o, (int)this.elements);
            }
            if (o instanceof Relationship) {
                this.setRelationship((Relationship)o, (int)this.elements);
            }
            if (o instanceof Path) {
                this.setPath((Path)o, (int)this.elements);
            }
            ++this.elements;
        }

        public void setObject(Object o, int idx) {
            switch (idx) {
                case 0: {
                    this._1 = o;
                    break;
                }
                case 1: {
                    this._2 = o;
                    break;
                }
                case 2: {
                    this._3 = o;
                    break;
                }
                case 3: {
                    this._4 = o;
                    break;
                }
                case 4: {
                    this._5 = o;
                    break;
                }
                case 5: {
                    this._6 = o;
                    break;
                }
                case 6: {
                    this._7 = o;
                    break;
                }
                case 7: {
                    this._8 = o;
                    break;
                }
                case 8: {
                    this._9 = o;
                    break;
                }
                case 9: {
                    this._10 = o;
                }
            }
        }

        public void setString(String o, int idx) {
            switch (idx) {
                case 0: {
                    this._1s = o;
                    break;
                }
                case 1: {
                    this._2s = o;
                    break;
                }
                case 2: {
                    this._3s = o;
                    break;
                }
                case 3: {
                    this._4s = o;
                    break;
                }
                case 4: {
                    this._5s = o;
                    break;
                }
                case 5: {
                    this._6s = o;
                    break;
                }
                case 6: {
                    this._7s = o;
                    break;
                }
                case 7: {
                    this._8s = o;
                    break;
                }
                case 8: {
                    this._9s = o;
                    break;
                }
                case 9: {
                    this._10s = o;
                }
            }
        }

        public void setLong(Long o, int idx) {
            switch (idx) {
                case 0: {
                    this._1i = o;
                    break;
                }
                case 1: {
                    this._2i = o;
                    break;
                }
                case 2: {
                    this._3i = o;
                    break;
                }
                case 3: {
                    this._4i = o;
                    break;
                }
                case 4: {
                    this._5i = o;
                    break;
                }
                case 5: {
                    this._6i = o;
                    break;
                }
                case 6: {
                    this._7i = o;
                    break;
                }
                case 7: {
                    this._8i = o;
                    break;
                }
                case 8: {
                    this._9i = o;
                    break;
                }
                case 9: {
                    this._10i = o;
                }
            }
        }

        public void setBoolean(Boolean o, int idx) {
            switch (idx) {
                case 0: {
                    this._1b = o;
                    break;
                }
                case 1: {
                    this._2b = o;
                    break;
                }
                case 2: {
                    this._3b = o;
                    break;
                }
                case 3: {
                    this._4b = o;
                    break;
                }
                case 4: {
                    this._5b = o;
                    break;
                }
                case 5: {
                    this._6b = o;
                    break;
                }
                case 6: {
                    this._7b = o;
                    break;
                }
                case 7: {
                    this._8b = o;
                    break;
                }
                case 8: {
                    this._9b = o;
                    break;
                }
                case 9: {
                    this._10b = o;
                }
            }
        }

        public void setDouble(Double o, int idx) {
            switch (idx) {
                case 0: {
                    this._1f = o;
                    break;
                }
                case 1: {
                    this._2f = o;
                    break;
                }
                case 2: {
                    this._3f = o;
                    break;
                }
                case 3: {
                    this._4f = o;
                    break;
                }
                case 4: {
                    this._5f = o;
                    break;
                }
                case 5: {
                    this._6f = o;
                    break;
                }
                case 6: {
                    this._7f = o;
                    break;
                }
                case 7: {
                    this._8f = o;
                    break;
                }
                case 8: {
                    this._9f = o;
                    break;
                }
                case 9: {
                    this._10f = o;
                }
            }
        }

        public void setNode(Node o, int idx) {
            switch (idx) {
                case 0: {
                    this._1n = o;
                    break;
                }
                case 1: {
                    this._2n = o;
                    break;
                }
                case 2: {
                    this._3n = o;
                    break;
                }
                case 3: {
                    this._4n = o;
                    break;
                }
                case 4: {
                    this._5n = o;
                    break;
                }
                case 5: {
                    this._6n = o;
                    break;
                }
                case 6: {
                    this._7n = o;
                    break;
                }
                case 7: {
                    this._8n = o;
                    break;
                }
                case 8: {
                    this._9n = o;
                    break;
                }
                case 9: {
                    this._10n = o;
                }
            }
        }

        public void setRelationship(Relationship o, int idx) {
            switch (idx) {
                case 0: {
                    this._1r = o;
                    break;
                }
                case 1: {
                    this._2r = o;
                    break;
                }
                case 2: {
                    this._3r = o;
                    break;
                }
                case 3: {
                    this._4r = o;
                    break;
                }
                case 4: {
                    this._5r = o;
                    break;
                }
                case 5: {
                    this._6r = o;
                    break;
                }
                case 6: {
                    this._7r = o;
                    break;
                }
                case 7: {
                    this._8r = o;
                    break;
                }
                case 8: {
                    this._9r = o;
                    break;
                }
                case 9: {
                    this._10r = o;
                }
            }
        }

        public void setPath(Path o, int idx) {
            switch (idx) {
                case 0: {
                    this._1p = o;
                    break;
                }
                case 1: {
                    this._2p = o;
                    break;
                }
                case 2: {
                    this._3p = o;
                    break;
                }
                case 3: {
                    this._4p = o;
                    break;
                }
                case 4: {
                    this._5p = o;
                    break;
                }
                case 5: {
                    this._6p = o;
                    break;
                }
                case 6: {
                    this._7p = o;
                    break;
                }
                case 7: {
                    this._8p = o;
                    break;
                }
                case 8: {
                    this._9p = o;
                    break;
                }
                case 9: {
                    this._10p = o;
                }
            }
        }

        public void setMap(Map o, int idx) {
            switch (idx) {
                case 0: {
                    this._1m = o;
                    break;
                }
                case 1: {
                    this._2m = o;
                    break;
                }
                case 2: {
                    this._3m = o;
                    break;
                }
                case 3: {
                    this._4m = o;
                    break;
                }
                case 4: {
                    this._5m = o;
                    break;
                }
                case 5: {
                    this._6m = o;
                    break;
                }
                case 6: {
                    this._7m = o;
                    break;
                }
                case 7: {
                    this._8m = o;
                    break;
                }
                case 8: {
                    this._9m = o;
                    break;
                }
                case 9: {
                    this._10m = o;
                }
            }
        }

        public void setList(List o, int idx) {
            switch (idx) {
                case 0: {
                    this._1l = o;
                    break;
                }
                case 1: {
                    this._2l = o;
                    break;
                }
                case 2: {
                    this._3l = o;
                    break;
                }
                case 3: {
                    this._4l = o;
                    break;
                }
                case 4: {
                    this._5l = o;
                    break;
                }
                case 5: {
                    this._6l = o;
                    break;
                }
                case 6: {
                    this._7l = o;
                    break;
                }
                case 7: {
                    this._8l = o;
                    break;
                }
                case 8: {
                    this._9l = o;
                    break;
                }
                case 9: {
                    this._10l = o;
                }
            }
        }
    }
}

