/*
 * Decompiled with CFR 0.152.
 */
package apoc.atomic;

import apoc.atomic.util.AtomicUtils;
import apoc.util.ArrayBackedList;
import apoc.util.MapUtil;
import apoc.util.Util;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Transaction;
import org.neo4j.procedure.Context;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class Atomic {
    @Context
    public Transaction tx;

    @Procedure(name="apoc.atomic.add", mode=Mode.WRITE)
    @Description(value="Sets the given property to the sum of itself and the given `INTEGER` or `FLOAT` value.\nThe procedure then sets the property to the returned sum.")
    public Stream<AtomicResults> add(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="number") Number number, @Name(value="retryAttempts", defaultValue="5") Long retryAttempts) {
        this.checkIsEntity(container);
        Number[] newValue = new Number[1];
        Number[] oldValue = new Number[1];
        Entity entity = Util.rebind(this.tx, (Entity)container);
        ExecutionContext executionContext = new ExecutionContext(this.tx, entity);
        this.retry(executionContext, context -> {
            oldValue[0] = (Number)entity.getProperty(property);
            newValue[0] = AtomicUtils.sum((Number)entity.getProperty(property), number);
            entity.setProperty(property, (Object)newValue[0]);
            return context.entity.getProperty(property);
        }, retryAttempts);
        return Stream.of(new AtomicResults(entity, property, oldValue[0], newValue[0]));
    }

    @Procedure(name="apoc.atomic.subtract", mode=Mode.WRITE)
    @Description(value="Sets the property of a value to itself minus the given `INTEGER` or `FLOAT` value.\nThe procedure then sets the property to the returned sum.")
    public Stream<AtomicResults> subtract(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="number") Number number, @Name(value="retryAttempts", defaultValue="5") Long retryAttempts) {
        this.checkIsEntity(container);
        Entity entity = Util.rebind(this.tx, (Entity)container);
        Number[] newValue = new Number[1];
        Number[] oldValue = new Number[1];
        ExecutionContext executionContext = new ExecutionContext(this.tx, entity);
        this.retry(executionContext, context -> {
            oldValue[0] = (Number)entity.getProperty(property);
            newValue[0] = AtomicUtils.sub((Number)entity.getProperty(property), number);
            entity.setProperty(property, (Object)newValue[0]);
            return context.entity.getProperty(property);
        }, retryAttempts);
        return Stream.of(new AtomicResults(entity, property, oldValue[0], newValue[0]));
    }

    @Procedure(name="apoc.atomic.concat", mode=Mode.WRITE)
    @Description(value="Sets the given property to the concatenation of itself and the `STRING` value.\nThe procedure then sets the property to the returned `STRING`.")
    public Stream<AtomicResults> concat(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="string") String string, @Name(value="retryAttempts", defaultValue="5") Long retryAttempts) {
        this.checkIsEntity(container);
        Entity entity = Util.rebind(this.tx, (Entity)container);
        String[] newValue = new String[1];
        String[] oldValue = new String[1];
        ExecutionContext executionContext = new ExecutionContext(this.tx, entity);
        this.retry(executionContext, context -> {
            oldValue[0] = entity.getProperty(property).toString();
            newValue[0] = oldValue[0].concat(string);
            entity.setProperty(property, (Object)newValue[0]);
            return context.entity.getProperty(property);
        }, retryAttempts);
        return Stream.of(new AtomicResults(entity, property, oldValue[0], newValue[0]));
    }

    @Procedure(name="apoc.atomic.insert", mode=Mode.WRITE)
    @Description(value="Inserts a value at position into the `LIST<ANY>` value of a property.\nThe procedure then sets the result back on the property.")
    public Stream<AtomicResults> insert(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="position") Long position, @Name(value="value") Object value, @Name(value="retryAttempts", defaultValue="5") Long retryAttempts) {
        this.checkIsEntity(container);
        Entity entity = Util.rebind(this.tx, (Entity)container);
        Object[] oldValue = new Object[1];
        Object[] newValue = new Object[1];
        ExecutionContext executionContext = new ExecutionContext(this.tx, entity);
        this.retry(executionContext, context -> {
            Class<?> clazz;
            oldValue[0] = entity.getProperty(property);
            List<Object> values = this.insertValueIntoArray(entity.getProperty(property), position, value);
            try {
                clazz = Class.forName(values.toArray()[0].getClass().getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            newValue[0] = Array.newInstance(clazz, values.size());
            try {
                System.arraycopy(values.toArray(), 0, newValue[0], 0, values.size());
            }
            catch (Exception e) {
                String message = "Property's array value has type: " + values.toArray()[0].getClass().getName() + ", and your value to insert has type: " + value.getClass().getName();
                throw new ArrayStoreException(message);
            }
            entity.setProperty(property, newValue[0]);
            return context.entity.getProperty(property);
        }, retryAttempts);
        return Stream.of(new AtomicResults(entity, property, oldValue[0], newValue[0]));
    }

    @Procedure(name="apoc.atomic.remove", mode=Mode.WRITE)
    @Description(value="Removes the element at position from the `LIST<ANY>` value of a property.\nThe procedure then sets the property to the resulting `LIST<ANY>` value.")
    public Stream<AtomicResults> remove(@Name(value="container") Object container, @Name(value="propertyName") String property, @Name(value="position") Long position, @Name(value="retryAttempts", defaultValue="5") Long retryAttempts) {
        this.checkIsEntity(container);
        Entity entity = Util.rebind(this.tx, (Entity)container);
        Object[] oldValue = new Object[1];
        Object[] newValue = new Object[1];
        ExecutionContext executionContext = new ExecutionContext(this.tx, entity);
        this.retry(executionContext, context -> {
            Class<?> clazz;
            Object[] arrayBackedList;
            oldValue[0] = arrayBackedList = new ArrayBackedList(entity.getProperty(property)).toArray();
            if (position > (long)arrayBackedList.length || position < 0L) {
                throw new RuntimeException("Position " + position + " is out of range for array of length " + arrayBackedList.length);
            }
            Object[] newArray = ArrayUtils.addAll(Arrays.copyOfRange(arrayBackedList, 0, position.intValue()), Arrays.copyOfRange(arrayBackedList, position.intValue() + 1, arrayBackedList.length));
            try {
                clazz = Class.forName(arrayBackedList[0].getClass().getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            newValue[0] = Array.newInstance(clazz, newArray.length);
            System.arraycopy(newArray, 0, newValue[0], 0, newArray.length);
            entity.setProperty(property, newValue[0]);
            return context.entity.getProperty(property);
        }, retryAttempts);
        return Stream.of(new AtomicResults(entity, property, oldValue[0], newValue[0]));
    }

    @Procedure(name="apoc.atomic.update", mode=Mode.WRITE)
    @Description(value="Updates the value of a property with a Cypher operation.")
    public Stream<AtomicResults> update(@Name(value="container") Object nodeOrRelationship, @Name(value="propertyName") String property, @Name(value="operation") String operation, @Name(value="retryAttempts", defaultValue="5") Long retryAttempts) {
        this.checkIsEntity(nodeOrRelationship);
        Entity entity = Util.rebind(this.tx, (Entity)nodeOrRelationship);
        Object[] oldValue = new Object[1];
        ExecutionContext executionContext = new ExecutionContext(this.tx, entity);
        this.retry(executionContext, context -> {
            oldValue[0] = entity.getProperty(property);
            String statement = "WITH $container as n with n set n." + Util.sanitize(property, true) + "=" + operation + ";";
            Map<String, Object> properties = MapUtil.map("container", entity);
            return context.tx.execute(statement, properties);
        }, retryAttempts);
        return Stream.of(new AtomicResults(entity, property, oldValue[0], entity.getProperty(property)));
    }

    private List<Object> insertValueIntoArray(Object oldValue, Long position, Object value) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (oldValue.getClass().isArray()) {
            values.addAll(new ArrayBackedList(oldValue));
        } else {
            values.add(oldValue);
        }
        if (position > (long)values.size()) {
            values.add(value);
        } else {
            values.add(position.intValue(), value);
        }
        return values;
    }

    private void retry(ExecutionContext executionContext, Function<ExecutionContext, Object> work, Long retryAttempts) {
        try {
            this.tx.acquireWriteLock(executionContext.entity);
            work.apply(executionContext);
        }
        catch (AssertionError | Neo4jException | NotFoundException e) {
            if (retryAttempts > 0L) {
                this.retry(executionContext, work, retryAttempts - 1L);
            }
            throw e;
        }
    }

    private void checkIsEntity(Object container) {
        if (!(container instanceof Entity)) {
            throw new RuntimeException("You Must pass Node or Relationship");
        }
    }

    private static class ExecutionContext {
        private final Transaction tx;
        private final Entity entity;

        public ExecutionContext(Transaction tx, Entity entity) {
            this.tx = tx;
            this.entity = entity;
        }
    }

    public class AtomicResults {
        public Object container;
        public String property;
        public Object oldValue;
        public Object newValue;

        public AtomicResults(Object container, String property, Object oldValue, Object newValue) {
            this.container = container;
            this.property = property;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }
}

