/*
 * Decompiled with CFR 0.152.
 */
package apoc.algo;

import apoc.path.RelationshipTypeAndDirections;
import org.apache.commons.lang3.tuple.Pair;
import org.neo4j.graphalgo.EstimateEvaluator;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PathExpanderBuilder;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.values.storable.PointValue;

public class PathFindingUtils {
    public static PathExpander<Double> buildPathExpander(String relationshipsAndDirections) {
        PathExpanderBuilder builder = PathExpanderBuilder.empty();
        for (Pair<RelationshipType, Direction> pair : RelationshipTypeAndDirections.parse(relationshipsAndDirections)) {
            if (pair.getLeft() == null) {
                if (pair.getRight() == null) {
                    builder = PathExpanderBuilder.allTypesAndDirections();
                    continue;
                }
                builder = PathExpanderBuilder.allTypes((Direction)pair.getRight());
                continue;
            }
            if (pair.getRight() == null) {
                builder = builder.add(pair.getLeft());
                continue;
            }
            builder = builder.add(pair.getLeft(), pair.getRight());
        }
        return builder.build();
    }

    public static class GeoEstimateEvaluatorPointCustom
    implements EstimateEvaluator<Double> {
        private static final double EARTH_RADIUS = 6371000.0;
        private Node cachedGoal;
        private final String pointPropertyKey;
        private double[] cachedGoalCoordinates;

        public GeoEstimateEvaluatorPointCustom(String pointPropertyKey) {
            this.pointPropertyKey = pointPropertyKey;
        }

        public Double getCost(Node node, Node goal) {
            double[] nodeCoordinates = this.getCoordinates(node);
            if (this.cachedGoal == null || !this.cachedGoal.equals(goal)) {
                this.cachedGoalCoordinates = this.getCoordinates(goal);
                this.cachedGoal = goal;
            }
            return GeoEstimateEvaluatorPointCustom.distance(nodeCoordinates[0], nodeCoordinates[1], this.cachedGoalCoordinates[0], this.cachedGoalCoordinates[1]);
        }

        private static double distance(double latitude1, double longitude1, double latitude2, double longitude2) {
            latitude1 = Math.toRadians(latitude1);
            longitude1 = Math.toRadians(longitude1);
            latitude2 = Math.toRadians(latitude2);
            longitude2 = Math.toRadians(longitude2);
            double cLa1 = Math.cos(latitude1);
            double xA = 6371000.0 * cLa1 * Math.cos(longitude1);
            double yA = 6371000.0 * cLa1 * Math.sin(longitude1);
            double zA = 6371000.0 * Math.sin(latitude1);
            double cLa2 = Math.cos(latitude2);
            double xB = 6371000.0 * cLa2 * Math.cos(longitude2);
            double yB = 6371000.0 * cLa2 * Math.sin(longitude2);
            double zB = 6371000.0 * Math.sin(latitude2);
            return Math.sqrt((xA - xB) * (xA - xB) + (yA - yB) * (yA - yB) + (zA - zB) * (zA - zB));
        }

        private double[] getCoordinates(Node node) {
            return ((PointValue)node.getProperty(this.pointPropertyKey)).coordinate();
        }
    }
}

