/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import apoc.util.Util;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class MaxAndMinItems {
    @UserAggregationFunction(value="apoc.agg.maxItems")
    @Description(value="Returns a `MAP` `{items: LIST<ANY>, value: ANY}` where the `value` key is the maximum value present, and `items` represent all items with the same value. The size of the list of items can be limited to a given max size.")
    public MaxOrMinItemsFunction maxItems() {
        return new MaxOrMinItemsFunction(true);
    }

    @UserAggregationFunction(value="apoc.agg.minItems")
    @Description(value="Returns a `MAP` `{items: LIST<ANY>, value: ANY}` where the `value` key is the minimum value present, and `items` represent all items with the same value. The size of the list of items can be limited to a given max size.")
    public MaxOrMinItemsFunction minItems() {
        return new MaxOrMinItemsFunction(false);
    }

    public static class MaxOrMinItemsFunction {
        private final List<Object> items = new ArrayList<Object>();
        private final boolean isMax;
        private Comparable value;

        private MaxOrMinItemsFunction(boolean isMax) {
            this.isMax = isMax;
        }

        @UserAggregationUpdate
        public void maxOrMinItems(@Name(value="items") Object item, @Name(value="value") Object inputValue, @Name(value="groupLimit", defaultValue="-1") Long groupLimitParam) {
            boolean noGroupLimit;
            int groupLimit = groupLimitParam.intValue();
            boolean bl = noGroupLimit = groupLimit < 0;
            if (item != null && inputValue != null) {
                int result;
                int n = this.value == null ? (this.isMax ? -1 : 1) : (result = this.value.compareTo(inputValue));
                if (result == 0) {
                    if (noGroupLimit || this.items.size() < groupLimit) {
                        this.items.add(item);
                    }
                } else if (result < 0 == this.isMax) {
                    this.items.clear();
                    this.items.add(item);
                    this.value = (Comparable)inputValue;
                }
            }
        }

        @UserAggregationResult
        public Object result() {
            return Util.map("items", this.items, "value", this.value);
        }
    }
}

