/*
 * Decompiled with CFR 0.152.
 */
package apoc.agg;

import java.util.ArrayList;
import java.util.List;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.UserAggregationFunction;
import org.neo4j.procedure.UserAggregationResult;
import org.neo4j.procedure.UserAggregationUpdate;

public class CollAggregation {
    @UserAggregationFunction(value="apoc.agg.nth")
    @Description(value="Returns the nth value in the given collection (to fetch the last item of an unknown length collection, -1 can be used).")
    public NthFunction nthFunction() {
        return new NthFunction();
    }

    @UserAggregationFunction(value="apoc.agg.first")
    @Description(value="Returns the first value from the given collection.")
    public FirstFunction first() {
        return new FirstFunction();
    }

    @UserAggregationFunction(value="apoc.agg.last")
    @Description(value="Returns the last value from the given collection.")
    public LastFunction last() {
        return new LastFunction();
    }

    @UserAggregationFunction(value="apoc.agg.slice")
    @Description(value="Returns a subset of non-null values from the given collection (the collection is considered to be zero-indexed).\nTo specify the range from start until the end of the collection, the length should be set to -1.")
    public SliceFunction slice() {
        return new SliceFunction();
    }

    public static class NthFunction {
        private Object value;
        private int index;

        @UserAggregationUpdate
        public void nth(@Name(value="value") Object value, @Name(value="offset") long target) {
            if (value != null && (target == (long)this.index++ || target == -1L)) {
                this.value = value;
            }
        }

        @UserAggregationResult
        public Object result() {
            return this.value;
        }
    }

    public static class FirstFunction {
        private Object value;

        @UserAggregationUpdate
        public void first(@Name(value="value") Object value) {
            if (value != null && this.value == null) {
                this.value = value;
            }
        }

        @UserAggregationResult
        public Object result() {
            return this.value;
        }
    }

    public static class LastFunction {
        private Object value;

        @UserAggregationUpdate
        public void last(@Name(value="value") Object value) {
            if (value != null) {
                this.value = value;
            }
        }

        @UserAggregationResult
        public Object result() {
            return this.value;
        }
    }

    public static class SliceFunction {
        private List<Object> values = new ArrayList<Object>();
        private int index;

        @UserAggregationUpdate
        public void nth(@Name(value="value") Object value, @Name(value="from", defaultValue="0") long from, @Name(value="to", defaultValue="-1") long len) {
            if (value != null) {
                if ((long)this.index >= from && (len == -1L || (long)this.index < from + len)) {
                    this.values.add(value);
                }
                ++this.index;
            }
        }

        @UserAggregationResult
        public List<Object> result() {
            return this.values;
        }
    }
}

