//
//  Concentration.swift
//  GiocoDiCarte-fase2
//
//  Created by Luciano Bononi on 12/03/2020.
//  Copyright © 2020 Luciano Bononi. All rights reserved.
//

import Foundation

class Concentration {
//    var cards: Array<Card>()
    private(set) var cards = [Card]()
    
    private var indexOfOneAndOnlyfaceUpCard: Int? {
        get {
            var foundIndex: Int?
            for index in cards.indices {
                if cards[index].isFaceUp {
                   if foundIndex == nil {
                      foundIndex = index
                   } else {
                    return nil
                    }
                }
             }
            return foundIndex
        }
        set(newValue) {
            for index in cards.indices {
                cards[index].isFaceUp = (index == newValue)
            }
        }
    }
    
    internal func chooseCard(at index: Int) {
        assert(cards.indices.contains(index), "Concentration.chooseCard(at \(index)): chosen index is not in the cards")
        if !cards[index].isMatched {
            if let matchIndex = indexOfOneAndOnlyfaceUpCard, matchIndex != index {
                // check if cards match
                if cards[matchIndex].identifier == cards[index].identifier {
                    cards[matchIndex].isMatched = true
                    cards[index].isMatched = true
                }
                cards[index].isFaceUp = true
//                indexOfOneAndOnlyfaceUpCard = nil
            } else {
//                for flipDownIndex in cards.indices {
//                    cards[flipDownIndex].isFaceUp = false
//                }
//                cards[index].isFaceUp = true
                indexOfOneAndOnlyfaceUpCard = index
            }
            //1 no card is face up
            //2 two cards face up, this card is the new one of a pair
            //3 one card faceUp yet, chosen 2nd one index, check match?
        }
        // gestisce il flip delle card nel modello
//        if cards[index].isFaceUp {
//            cards[index].isFaceUp = false
//        } else {
//            cards[index].isFaceUp = true
//        }
    }
    
    private func shuffle(numberOfPairsOfCards: Int) {
                for swapFromIndex in stride(from: 2, through: 2*(numberOfPairsOfCards - 1), by: 2) {
        //           let swapToIndex = Int(arc4random_uniform(UInt32(numberOfPairsOfCards))) * 2
                    let swapToIndex = numberOfPairsOfCards.arc4random * 2
                   let temp = cards[swapFromIndex].identifier
                   cards[swapFromIndex].identifier = cards[swapToIndex].identifier
                   cards[swapToIndex].identifier = temp
    }
    }
    
    init(numberOfPairsOfCards: Int){
        assert(numberOfPairsOfCards > 0, "Concentration.init(\(numberOfPairsOfCards) cards: you must have at least a pair of cards")
        for _ in 0..<numberOfPairsOfCards {
            let card = Card()
//            let matchingCard = card
//            cards.append(card)
//            cards.append(card)
            cards += [card, card]
    }
//         TODO: shuffle cards
        shuffle(numberOfPairsOfCards: numberOfPairsOfCards)
}
}
