//
//  ViewController.swift
//  GiocoDiCarte
//
//  Created by Luciano Bononi on 10/03/2020.
//  Copyright © 2020 Luciano Bononi. All rights reserved.
//

import UIKit

class ViewController: UIViewController {

    lazy var game = Concentration(numberOfPairsOfCards: (cardButtons.count + 1) / 2)
    
    var flipCount: Int = 0
//  var flipCount = 0
    
    var emojiChoices: Array<String> = ["👻", "🤡", "👁", "🍩", "❤️" ,"🥗", "🍟", "☕️", "🍔"]
    
// definisco nuova var emoji di tipo Dictionary che associa indice card a simbolo
//    var emoji = Dictionary<Int, String>() che riscrivo come segue
    var emoji = [Int:String]()
    
// modifico func emoji come segue: notare che emoji[card.identifier] è un optional (in quanto potrei avere finito i simboli delle card) e quindi proteggo con if e poi lo rendo String con explicit unwrap (!).
    func emoji(for card: Card) -> String {
        if emoji[card.identifier] == nil, emojiChoices.count > 0 {
            let randomIndex = Int(arc4random_uniform(UInt32(emojiChoices.count)))
            emoji[card.identifier] = emojiChoices.remove(at: randomIndex)
        }
                return emoji[card.identifier] ?? "?"
//        if emoji[card.identifier] != nil {
//            return emoji[card.identifier]!
//        } else {
//            return "?"
//        }
    }
// in versione 1 questa era la serie di card in ordine nel viewcontroller e UI dependent (non MVC)
//  var emojiChoices = ["👻", "🤡", "👻", "🤡", "❤️" ,"❤️"]
    
    // Outlet flipCountLabel per controllare aggiornamento dei Flips sulla label della View
    @IBOutlet weak var flipCountLabel: UILabel!
    
    // Outlet Collection cardButtons per indicizzare tramite array di UIButtons i buttons della view (le cards)
    @IBOutlet var cardButtons: [UIButton]!
    
    //metodo (target) associato all'evento (action) touch-up inside eseguito nella View all'interno di ogni Button collegato
    @IBAction func touchCard(_ sender: UIButton) {
        flipCount += 1
        if let cardNumber = cardButtons.firstIndex(of: sender) {
            game.chooseCard(at: cardNumber)
            updateViewFromModel()
//            flipCard(withEmoji: emojiChoices[cardNumber], on: sender)
        } else {
            print("chosen card was not in cardButtons")
        }
        flipCountLabel.text = "Flips: \(flipCount)"
    }
    
    func updateViewFromModel() {
//        for index in 0..<cardButtons.count {
        for index in cardButtons.indices {
            let button = cardButtons[index]
            let card = game.cards[index]
            if card.isFaceUp {
                // disegna la card con faccia in su
                button.setTitle(emoji(for: card), for: UIControl.State.normal)
                button.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 1)
            } else {
                // disegna la card a faccia in giu
                button.setTitle("", for: UIControl.State.normal)
                //N.B. se la card è matched nel model la rendo trasparente, altrimenti la copro
                button.backgroundColor = card.isMatched ? #colorLiteral(red: 1, green: 0.5763723254, blue: 0, alpha: 0) : #colorLiteral(red: 1, green: 0.5763723254, blue: 0, alpha: 1)
            }
        }
    }
    
    // vecchio metodo di servizio che girava le cards settando le properties dei buttons (non MVC)
//    func flipCard(withEmoji emoji: String, on button: UIButton) {
//        print("FlipCard with emoji: \(emoji)")
//        if button.currentTitle == emoji {
//            button.setTitle("", for: UIControl.State.normal)
//            button.backgroundColor = #colorLiteral(red: 1, green: 0.5763723254, blue: 0, alpha: 1)
//        } else {
//            button.setTitle(emoji, for: UIControl.State.normal)
//            button.backgroundColor = #colorLiteral(red: 1, green: 1, blue: 1, alpha: 1)
//        }
//    }
}

