package it.unibo.stradivarius.lifecycletester;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;

public class MainActivity extends AppCompatActivity {

    int counter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        Log.d("LIFECYCLE", "ON CREATE");

        counter = 0;

        Button btnIncrease = findViewById(R.id.buttonIncrease);
        btnIncrease.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                counter++;
                updateCounter();
            }
        });

        Button btnExit = findViewById(R.id.buttonExit);
        btnExit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    @Override
    protected void onStart() {
        super.onStart();
        Log.d("LIFECYCLE", "ON START");
    }

    @Override
    protected void onRestart() {
        super.onRestart();
        Log.d("LIFECYCLE", "ON RESTART");
    }

    @Override
    protected void onResume() {
        super.onResume();
        Log.d("LIFECYCLE", "ON RESUME");
        updateCounter();
    }

    @Override
    protected void onPause() {
        super.onPause();
        Log.d("LIFECYCLE", "ON PAUSE");
    }

    @Override
    protected void onStop() {
        super.onStop();
        Log.d("LIFECYCLE", "ON STOP");
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        Log.d("LIFECYCLE", "ON DESTROY");
    }

    private void updateCounter() {
        TextView textCtr = findViewById(R.id.textCounter);
        textCtr.setText(String.valueOf(counter));
    }

    @Override
    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("CTR", counter);
        Log.d("LIFECYCLE", "SAVE INSTANCE");
    }

    @Override
    protected void onRestoreInstanceState(@NonNull Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        counter = savedInstanceState.getInt("CTR");
        Log.d("LIFECYCLE", "RESTORE INSTANCE");
    }
}