'use client'

const Map = () => (
  <>
    <style jsx global>
      {`
        .light .map-travelling path {
          fill-rule: evenodd;
          stroke: #fff;
          fill: #e5e7eb;
        }

        .dark .map-travelling path {
          fill-rule: evenodd;
          stroke: #000;
          fill: rgb(32 32 32);
        }
      `}
    </style>
    <style jsx>
      {`
        path.visited {
          fill: rgb(115 115 115);
          cursor: pointer;
          transition: all 0.1s ease-out;
        }
        path.visited:hover {
          fill: rgb(163 163 163);
        }
        path.home {
          fill: rgb(56 189 248);
          cursor: pointer;
          transition: all 0.1s ease-out;
        }
        path.home:hover {
          fill: rgb(125 211 252);
        }
      `}
    </style>

    <svg
      xmlns="http://www.w3.org/2000/svg"
      preserveAspectRatio="xMinYMin meet"
      viewBox="0 0 1000 647"
      className="map-travelling"
    >
      <defs></defs>
      <g id="countries">
        <path
          id="AF"
          d="m705.1 347.36-1.91-.26-3.93 2.63-1.1-1.13.26-2.94-2.04-2.05-3.57 3.1-.9 1.6-.93-.68-2 1.12-.85-.43-2.1-.73-1.54-.03-.84-.1-1.3-.94-.44 1.24-2.34.68-.55 2.77-3.75 1.56-.58 1.54-2.1.46-2.82-1.3-1.13 4.22-.77 2.44 1.21.5-1.18 1.8 1.12 4.7 2.1.56.23 2.08-2.52 2.91 4.65 1.63 6.93-.49 3.6-1.33.1-2.73 1.54-1.83 6.6-1.94-.15-1.97 1.18-2 1.76-.83-1.09-2.2 2.64.1.65-2.5 1.38-1.42-.98-3.15 1.62-1.5 7.57-1.77 1.62-.39-.5-1h-2.85Z"
          data-id="AF"
          data-name="Afghanistan"
        />
        <path
          id="AO"
          d="m533.91 476.92 2.8 6.34-.85 1.12 1.27 3.98.68 4.7-3.14 4.3-2.39 8.98.26 1.82 3-1.05 3.87 1.2 11.24-.13 1.92 1.4 6.72.4 5.1-1.18-1.81-1.81-1.87-2.37.12-9.11 5.78.03v-4.75l-.29-.87-1.26-.17-3.61.61.15-3.35-1.13-2.78.4-1.69-.6-2.84-6.42-.38-5.39 2.56-2.5-4.05-.68-2.07-8.18-.04-2.92.66-.27.54Zm2.13-4.22-1.04-.95-.83.46-1.12 1.2.74 2.1.7-.3.09-1.2.45-.72 1.01-.59Z"
          data-id="AO"
          data-name="Angola"
        />
        <path
          id="AL"
          d="m553.54 330.11.19 1.19-.15 4.25.24 1.73 1.6 2.01.47.26 1.29-1.76.16-1.18.9-.53.06-.96-1.15-.9-.4-1.58.36-1.26-.19-1.35-.66-.39-.6-1-.74.33-.18-.71-1.2 1.85Z"
          data-id="AL"
          data-name="Albania"
        />
        <path
          id="AE"
          d="m653.76 386.43-3.97 4.03-6.14.3-.1-.83-.5.15.11.7 1.06 3.07 8.34 1.51.56-.63.07-1.21 1.81-5.5 1.42-.01-.9-3.48-1.76 1.9Z"
          data-id="AE"
          data-name="United Arab Emirates"
        />
        <path
          id="AR"
          d="M309.64 631.74v10.47h2.98l1.67.14 1.41 1.7 2.64-.24 1.24-2.41-3.88-1.2-3.6-2.84-1.39-3.5-1.07-2.12Zm4.24-107.53.34.75-.95 3.14-3.03 1.5.34 7.33-1.95 1.94-1.82 2.95-1 2.88.27 3.1-1.7 3.32 1.27 5.66.72.6v3.07l-1.59 3.3.06 2.84-2.1 2.25.01 3.2.85 3.43-1.66 1.3-1.4 6.92.47 4.51-1.11.76.64 4.37 1.26 1.45-.92 1.62.67 5.3-1.01 5.3-1.47 3.5.32 2.09-.88 2.66-2.13 1.86.25 4.56.97 1.59 1.85-.29-.05 3.3 1.15 2.62 6.7.6 2.57.71 1.17.23-1.85-2.61-.9-4.6 1.14-2.04 2.53-1.7 1.8-5 3.28-2.35.96-3.7-2.66-.82-2.72-2.96.8-3 2.17-2.01 2.62-.01 1.06-5.97 2.23-2.37 2.55-1.17-.83-1.95-1.51 1.18-1.88-1.12-.38-3.69 1.07-.96 2.66 1.34 2.85-.5 1.66-1.3-.51-1.84.57-2.7-.59-2.13 3.05.36 5.56-.74 4.11-1.9 2.67-4.49.14-1.69-1.73-1.5.38-2.35-3.53-2.9.2-1.74.78-6.17.74-3.34.7-2.58 3.7-4.35 7.33-6.05.05-2.48-1.39-1.78-1.37.6-.46 2.72-2.51 2.39-2.2.5-5.9-1.33 2.72-4.7-.4-1.36-2.85-1.2-3.39-2.24-2.27-.47-5.1-4.91-.44-.65-3.17-.12-1.08 2.41-1.63-2.16-3.63-.73-2.3 2.7Z"
          data-id="AR"
          data-name="Argentina"
        />
        <path
          id="AM"
          d="m628.92 340.13-2.42-1.58.78-1.15-1.98-2.8-.57-.97-3.85.58.47 1.29-.27 1.77 2.06.9 1.1 1.06.57-.1.82.97 1.23-.01-.01.55 1.13 2.07 1-.1-.06-2.48Z"
          data-id="AM"
          data-name="Armenia"
        />
        <path
          id="TF"
          d="m694.92 618.78.68-2.74-2.62-.53-1.79-1.33-.53 4.88 4.26-.28Z"
          data-id="TF"
          data-name="French Southern and Antarctic Lands"
        />
        <path
          id="AU"
          d="m903.26 583.55-1.82-.33-.07 1.68 1.6 3.24.38 2.47 1.71 3.26 4.2-2.33.98 1.04.28-3.05.95-1.29-.2-4.4-5.33.97-2.68-1.26Zm-5.1-85.58-.1-2.65-2.8-6.13-1.03 1.05-1.26 3.87-.47 3.67.5 3.86-2.28 6.71-1.84 1-4.52-2.63h-.78l-7.77-5.21 1.6-3.65-.32-1.14 2.74-2.77-1.27-1.4-3.31 1.1-9.64-2.75 2.04.93.05 1.45-3.75.2-1.68 1-3.35 5.37.58 1.57-3.5-.28-3.58-3.01-3.88 1.98-3.57 3.03-.34 2.2-1.23-.63-.87 1.4 1 1.37-1.19.58-1.17-2.5-1.94 2.46-.2 2.75-3.84 4.35-7.28 2.04-2.19 1.1-4.14.96-3.6 2.27-1.18 2.06-.2-2.28-1.15 2.15-.95 5.78 2.28 4.29.04 1.58-2.2-2.09 2.04 7.76 2.4 4.25-.12 1.82 1.92 5.11.31 1.94-.7 4.23-1.38.45-.07 1.92 4.44 2.8 3.88.13 3.53-1.88 1.65-1.79 3.9-.52 2.45.61 4.1-.38 1.56-3.09 5.34-2.45 2.65.22 6.75-2.26 4.96-.3 2.67 1.58 1.95.1 3.56 1.98 2.67 4.42-.08 1.78 2.16 1.39 1.07-2.68 1.73-1.14 2.25-2.83.23 2.45-1.5 3.58-1.45 1.87 2.47-.62 1.36-2.34.67 2.5-.91 1.66 2.66.4 2.53 5.78 1.79 2.16 8.24 2.8 2.43-2.57 1.51-.66-.43 1.83 4 2.2 5.51-4.34 3.1-.13 1.6-1.21.91-6.06 1.07-1.7 2.76-7.14 2.06-1.62 1.77-5.3-.06-1.85 1.4-7.12-1.33-2.66.12-3.7-.78-2.47-5.42-5.5-.48-3.19-1.8-.83-1.11.66-2.3-5.82L906 513l-.9-1.98-2.2-8.27.3-1.27-2.25-2.33-1.78 1.08-1-2.25Z"
          data-id="AU"
          data-name="Australia"
        />
        <path
          id="AT"
          d="m545.76 304-1.3.21-4.7.75-2.05-1.35-.98 1.93-1 .53-.73 2.56-3.3.61-4.25-.23-.84.23.1.72-.42 1 1.26.74 1.41.11 1.68.58.33-.77 2.74-.7.62 1.4 3.96 1.05 2.3.31 1.4-.92 2.42-.1.53-.68.92-2.63-.54-.89h1.56l.21-1.7-.27-1.44.22-.53-1.28-.8Z"
          data-id="AT"
          data-name="Austria"
          className="visited"
        />
        <path
          id="AZ"
          d="m624.24 339.23.44 1.36 1.4 1.65 1.9.47-1.13-2.07v-.55h-1.22l-.82-.96-.57.1Zm4.46-7.87-.72.51 1.37 2-3.94-.84-.68.6.57.97 1.98 2.8-.78 1.15 2.42 1.58.06 2.47 3.27-2.63 1.86.78-.95 1.77 2.42 1.68-.08-1.76 1.98-4.89 2.28-.29-2.14-1.15-1.41-2.6-1.46-1.96-1.66 1.5-.47.94-1.23-.25-1.9-2.25-.79-.13Z"
          data-id="AZ"
          data-name="Azerbaijan"
        />
        <path
          id="BI"
          d="m584.5 466.12-1.47-.18-.85 1.58-1.68-.22.7 1.27.02.48 1.02 2.65-.01.12.3-.03 1-1.01 1.74-2.93-.6-.63-.16-1.1Z"
          data-id="BI"
          data-name="Burundi"
        />
        <path
          id="BE"
          d="m509.2 292.93-2.23.87 1.7 1.62 3.22 3.8 1.42-.34 2.43 1.96.3-2.41.72-.16.32-2.95-1.53-1.03-1.75-1.94-2.58.93-2.03-.35Z"
          data-id="BE"
          data-name="Belgium"
          className="visited"
        />
        <path
          id="BJ"
          d="M507.9 425.23h-1l-.92.84-.61.84-1.36.27-.56 1.24-.96.32-.35 1.48 2.48 3.78-.13 6.43.68 1.93 2.3-.33.08-6.29 2.98-6.26-.62-1.68.1-.94-2.1-1.63Z"
          data-id="BJ"
          data-name="Benin"
        />
        <path
          id="BF"
          d="m499.26 417.56-4.81 1.04-4.22 3.5-1.34-.39-1.17 2.65-2.2 2.35-.7 2.16.2 1.63 1.24.62.48.93 3.52-.22 1.9.73-.38-2.13.06-1.6 6.94-.38 1.29.23 2.42.06.96-.32.56-1.24 1.36-.27.6-.84.07-1.95-3.2-.64-2.02-4.55.22-1.39-1.78.02Z"
          data-id="BF"
          data-name="Burkina Faso"
        />
        <path
          id="BD"
          d="m755.57 391.95-1.22 1.94-1.52-1.56 2.1-1.9 1.27-2.58-6.8-.9-.25-2.14-3.52-1.49-.98 2.1 2 1.63-2.35 2.25 1.7.82-.46 1.82 1.39 4.75 1.07.26 2.37.4.62-2.91 2.55.12 1.85 4.7.8 1.55-.19-2.4.97.46.06-2.14-1.46-4.78Z"
          data-id="BD"
          data-name="Bangladesh"
        />
        <path
          id="BG"
          d="m562.84 322.35-.69.88.25 1.4 1.35 1.65-1.22 2.83-.46.53 1.4 1.2.19 2.46 2.05.1 2.22-1.01 1.95 1.3 2.52-.36.04-1.84 2.82-1.18 2.39.5-.9-2.13 1.02-2.71 1.44-1.59-3.65-1.8-4.64 1.87-7.28-.52-.8-1.58Z"
          data-id="BG"
          data-name="Bulgaria"
        />
        <path
          id="BS"
          d="m284.96 391.55-1.82-4.42-.6 1.94 2.42 2.48Zm-.8-8.64-3.21-.65.2 1.15 3.02-.5Zm2.28-.03-.94.19-.05 1.61 1-1.8Z"
          data-id="BS"
          data-name="Bahamas"
        />
        <path
          id="BA"
          d="m551.48 328.4.4-2.08.9-.89.52-.35.66-.16.4-1.81-1.34-1.5.7-1.7h-1l-1.26-.86-6.2.3-1-.9-.58 1.63 5.34 6.9 2.46 1.42Z"
          data-id="BA"
          data-name="Bosnia and Herzegovina"
        />
        <path
          id="BY"
          d="m578.15 270.27-2.98 1.91-1.69.83.26 2.19-2.27 1.55-.65 2.7-3 1.78-2.69-.03.12 2.07.76 3.6-1.67.93.86 2.1.05 2 1.33-.18 1.52-1.21 4.95.25 3.1 1.07 4.26-.04.73 1.04 3.6.22 1.04-3.24 2.38-.27-.68-2.9-.66-1.53.54-.44 2.24.16 1.08-1-3.64-3.79-1.73-3.12.32-3.6-2.71-1.17-1.46.59-.4-1.22-2.91-1.25Z"
          data-id="BY"
          data-name="Belarus"
        />
        <path
          id="BZ"
          d="m253.9 413.79 1.05-.86.2-3.23-.04-2.07v-.43l-.54.04-1.83 1.55.02.43-.02 2.3-.22 3.27h.83l.55-1Z"
          data-id="BZ"
          data-name="Belize"
        />
        <path
          id="BO"
          d="m339.54 515.97.99-5.27-2.06-5.45-5.32-.11-1.06-3.36.8-.05-.7-3.72-3.35-.82-4.11-2.46-3.11-.47-3.01-2.54.17-5.09-3.62.48-4.5 3.05-1.44.07-2.06-.24 2.4 4.56-.79 5.4-1.08 1.43-.14 2.03 1.2 2.43-1.76 3.13 1.36 1.98.37 2.11 1.46 1.24-.88 2.86 1.5 3.33 1.08 4.13 2-.41 2.31-2.71 3.63.73 1.63 2.16 1.08-2.41 3.17.12.44.65 1.1-3.58 1.4-4.2 4.83-.85 2.58.04 2.58 1.5.05.92.86-.61Z"
          data-id="BO"
          data-name="Bolivia"
        />
        <path
          id="BR"
          d="m342.51 454.26-4.87 1.65-1.36-.14-2.62-3.99 1.21-3.34-1.87-3.58-1.44.12.36.79-1.01 1.06-5.1 1.47-.8.66-4.78-.8 1.25.73.79 5.22-3.53 2.28-2.7 1.03-1.52-1.47-.52.34-2.23-1.56-5.4-.06.03 1.74 1.62.28-2.2 1.23-.02 2.02 1.6 3.8-1.25 7.62-2.5-.13-5.81 2.85-.64 3.77-1.67.81-.73 1.7 2.7 4.22-.6 1.2 1.85.17 1.05 1.5 2.44.08 2.28-1.66-.19 4.28 1.27.32 1.56-.48 2.06.24 1.43-.07 4.5-3.05 3.63-.48-.17 5.1 3.01 2.53 3.1.47 4.12 2.46 3.36.82.7 3.72-.81.05 1.06 3.36 5.32.11 2.06 5.45-.99 5.27-.86.6.82 1.66-.19 4.04 2.93.57 1.13-.58 4.01 5.77 1.04-.5.62 4.04-.54 1.77 1.37-.59 1.4 1.78-.06 2.48-7.33 6.05-3.7 4.35 1.8-.34 2.78 2.49 1.03-.1 6.63 6.12-1.22 1.56.77 1.89 1.83-1.9 1.27-3.14 4.32-4.1 3.08-5.65 3.09-6.45-.06-4.02 2.35-3.05 3.26-2.42 3.1-.89 1.96-1.35 4.36-1.16 3.02.01.65-1.8 2.24-1.3.47-3.08 2.81-3.85.5-3.92 1.94-7.53-.2-5.37 3.53-4.62 1.76-3.2 5.32-5.76 1.1-4.63-1.4-5.24-1-.88-4.5-.92-3.55-3.11-4.1-2.3-4.14.1-5.4-1.46-3.23.85.46-1.53-1.36-1.63-8.1-2.7-2.1 1.83-.1-2.78-4.9-.44-.86-.83 2.08-2.29-.07-1.91-1.49-.46-2.24-6.4-.94.14-3.56 5.64-1.33.2-1.85-.15-1.21-.57-1.6-.59-1.3.29-1.12-.25-.06 1.92-1.51-.22-.68.1Z"
          data-id="BR"
          data-name="Brazil"
        />
        <path
          id="BN"
          d="m817.84 445.82-1.1 1.04 1.27 1.44 1.9-.86.3-3.15-2.37 1.53Z"
          data-id="BN"
          data-name="Brunei Darussalam"
        />
        <path
          id="BT"
          d="m753.1 378.35-1.46-.08-1.98-.72-1.5.8-1.84 2.32.06.63 2.52 1.18 6.35-.37.2-1.92-1.13-1-1.22-.84Z"
          data-id="BT"
          data-name="Bhutan"
        />
        <path
          id="BW"
          d="m569.57 509.2-1.56.66-2.61 1.15-1.06-1.2-6.34 1.12-.09 10.51-2.73.1v8.82l.75.46 1.64 2.92.37 2.97 1.98-.31 3.38-3.8 1.36-.7 2.49 1.23 2.26.15 2.54-3.13 1.5-.25 1.77-3.16 2.49-2.26 3.92-2.2-1.77-1.36-2.14-.46-2.01-3.25-3.14-3.23-1.43-2.22-1.07-2.34-.5-.21Z"
          data-id="BW"
          data-name="Botswana"
        />
        <path
          id="CF"
          d="m566.03 435.3-.97-.81.27-3.2-1.6-1.76-.32-1.2-1.75.48-1.4 1.14-2.01 3.07-2.61 1.3-3.47.09.28.99-2.62 2.07-5.16 1.1-2.3.21-1.39 2.83-.66.51-.16 4.16 3.84 4.78.12 1.27.3.8 1.45-2.58 1.65-1.47 1.88.47 1.78.15.25-1.94 2.56-2.3 8.15 2.78 5.56-3 7.3-.06.92-.3-.44-.87-2.08-1.1-3.72-4.35-1.54-2.04-1.89-1.1-.22-.12Z"
          data-id="CF"
          data-name="Central African Republic"
        />
        <path
          id="CA"
          d="m323.43 313.2-.97-1.97-1.05 1.26.7 1.35 3.5 1.7 2.4-1.9-4.58-.44Zm5.15-10.55-.08-.78-2.84-1.79-3.64-1.08-.96.37 2.58 2.02 3.6 1.33 1.34-.07Zm-171.13 2.5-1.15-2.32-2.77-1.76-2.3-3.53-2.62-.46-4.61-1.61.83 3.37 2.85.78.5 1.22 2.49 1.49.83 1.5 4.55 1.9 1.4-.58Zm186.86-9.32.73-4.18-2.4 1.54-1.72 2.5-2.87 6.87-2.33 2.54 1.2 1.13-1.72 1.46.43 1.22 8.36-.12 2.66 1-1.96 1.92 1.66.14 3.21-3.55.78.52-.6 3.34 3.07.62 1.17-3.59-1.21-4.78-1.94.71.85-3.09-2.76-1.3-1.28 1.03-2.46-1.17.97-1.5-1.86-.92-1.81 1.46 1.83-3.8Zm-213.68-15.85.35 3.56 4.1 5.64h1.1l-2.42-3.66.83-5.3-2.66.38-1.3-.62Zm149.53-42.22-1.84-1.35-.47 3.95 1.22.5 1.09-3.1Zm-7.3-3.3.06-1.18-3.81-.06-2.07 2.79.61 1.61 1.96.14 3.25-3.3Zm-9.05-18.8-2-.54-.95 6.08-.36 5.05-2.4 3.1 3.75-.59.95 3.62 3.95-3.2 2.75-3.35 1.56 2.84 4.31 1.5 2.46-1.96-1.98-2.1-2.04.5-.24-3.03-7.83-6-1.42 1.02-.51-2.93Zm25.78-10.33 2.08-6.26-2.16-2.07-2.55 1.04-1.17 4.13.69 3.52 3.1-.36Zm-54.87-14.6-4.18-5.95-2.95-2.3-1.94 3.5-2.44 2.47 3.8 3.5 2.25-.84 3.74 2.33 1.72-2.7Zm-125.74-4.76-.02 27.38-.01 35.1 2.73.16 2.7 1.54 1.93 2.41 2.47 3.57 2.7-3.03 2.78-1.78 1.47 2.83 1.87 2.21 2.54 2.4 1.73 3.76 2.84 5.83 4.72 3.18.07 3.1-1.54 2.33.06 2.46 3.35 3.42.5 3.73 3.54 1.94-.4 2.77 1.55 3.92 5.02 1.81 7.35 6.07.38.01h76.77l.95-1.65.49 2.33 5.63 1.63 2.69 1.3 2.24-.55 3.42 1.08 1.12-1.64 2.82-2.23 2.58.85 3.5 3.02 3.11.62.6 2.38-.46 1.55 1.16.5-.58 1.36.74.13.52-.59.55.9 6.44.94 2.48.77 2.7 4.26-.9 1.3-2.25-.54-1.4-2.43.35 2.47-1.32 2.16-.08 2.89-1.8 1.26-1.3 2.07-.61 1.31 1.52.24 4.1-2.42 1.52.38 4.5-1.53-.24-1.14-.13.04-1.95-.16.83-1.3 5.14-1.55 1.23.73 2.25-1.1.03.07 4.09-3.43 9.32-.03.28-.97 3.05-2.62.85-3.12 2.11-3.08.92 1.08 1.86-.7 1.23 1.18v5.48l1.82 2.24 3.08-.48 4.44-.13-4.82 3.24.1 3.26 2.11.28 3.1-2.77 2.75-1.57 6.15-2.34 3.43-2.6-1.8-1.44-.19-2.93-2.78 4.52-4.58.58-3.6-2-1.79-7.47 2.62-2.8-2.45-2.08-4.15.43-5.82 3.5-4.45 5.4-2.36.68 3.2-3.78 4-5.53 3.53-1.88 2.32-3.1 7.04-.26 5.93.91 4.69-.7 3.49-3.6 4.57-1.57 4-3.26-.2-5.14-1.11-1.76-2.16-.62-1.1-4.01-1.78-1.54-4.43-1.25-2.49-2.8-3.69-2.8 1.12-3.17-6.68-13.03-2.16-4.94-1.84 2.59-2.65 6-4.02 2.94-2-3.13-2.54-.84-.92-6.92.08-4.76-4.94-.43-.85-2.24-6-5.43-2.3 1.57-7.6-2.2-1.93 1.38.93 9.09 1.2 5.07-3.27 5.7 3.37 3.98 1.89 4.4.22 3.4-1.53 3.47-3.15 3.43-4.44 2.26 1.96 2.5 1.45 7.34-1.5 4.64-2.14 1.45-4.12-4.25-2.01-5.12-.87-4.72.46-4.16-7.6-.75-2.94-2.06-3.47-1.37-1.99-2.35-2.77-1.92-5.15-2.21-3.88 1.01-2.55-8.86-4.08-.89.16-6.35 1.07-4.44 3.01-6.54 3.4-4.86 3.22-.76.18-4.01 2.2-2.66 3.96-.42 3.22-4.35.81-2.87 2.67-5.67.83-3.46 2.87 2.08 3.86-1.06 5.43-4.92.35-3.5-1.96-3.94 2.07-4.02-.17-3.82-3.72-3.92-4.1-1.18-3.94-.61-.16 8.62-2.02 6.5-2.9 5.25-2.68-4.9.83-5.55-3.32-4.97-3.7 6.03v-7.91l-5.15-1.61 2.46-3.98-3.77-9.48-2.8-3.87-3.66-1.43-3.28 6.36-.22 9.25 3.24 3.26 2.97 4.86-1.26 7.63-2.23-.2-1.76 5.83.01-6.94-4.3-2.56-2.46 1.33.32 4.62-4.05-.17-4.3 1.16-4.9-3.32-3.1.59-2.79-4.07-2.24-1.83-5.59 1.12-1.8 2.59 2.84 3.15-3.02 3.7-2.95-4.39-2.37 1.3-7.48.86-5.02-1.58 3.9-3.7-3.74-3.86-2.71.5-3.82-1.31-6.49-2.87-4.24-3.34-3.36-.46-1.05 2.33-3.4 1.3-.38-6.09-3.7 5.45-4.68-7.24-1.92-.89-.62 3.87-2.07 1.88-1.9-3.36-4.54 2.03-4.16 3.52-4.12-.97-3.36 2.47-2.43 3.24-2.9-.7-4.36-3.77-5.17-1.92Zm74.38-29.75-2.84-1.86-7.42 5.78-1.93 3.67-2.33 6.7 4.84 2.3 4.28-.12-6.43 3.42 1.46 3.1 3.94.17 5.92-.66 5.37 1.94-3.62 1.43-3.91-.37-6.13 2.26 3.42 6.29 2.46-.88 3.79 2.13 1.5 3.61 11.96-1.86 5.2-2.62 3.23-.47 4.77 2.09 5.02 1.2.94-2.82-1.77-3.02 4.55-.64.3-3.53-5-3.9-4.66-4.16-.86-6.12-1.74-8.83-3.1-3.8-2.77-1.53-2.44 1.4 1.97 9.5-1.39 3.68-2.27-8.88-2.53-3.08-3.14 4.77-3.85-4.71-6.18 2.84 1.39-4.42Zm26.81-2.88-2.1-2.15-3.72.4-.95 1.36 4.33 6.69 2.44-6.3Zm78.1 3.06-4.78-5.33-6.35-1.06-1.33.65-.12 3.52 3.05 5.05.8.57 3.04-1.26 5.94.47-.25-2.61Zm-28.35-.53 2.04-6.3-7.16 2.62-2.85 3.95-2.13 8.34.88 8.96 3.94.03-2.9 3.89 2.3 2.93 4.5 1.24 5.87 2.4 10.1 1.8 5.02-1.04 1.48-2.4 2.2 2.76 2.43.46 2.94 4.92-1.78 1.96 5.62 2.6 4.25 3.64 1.83 5.73-3.58 6.86-.97 3.4.92 2.4-5.7.86-5.22.12-1.82 4.82 2.34 2.2 8.02-1.02-.04-1.87 8.17 6.36-.96 1.76 3.36 3 5.95 3.5 7.52 2.36-.45-2.07-6.8-8.96 6.95 4.95 3.5 1.65.95-4.4-1.8-6.24-1.15-1.71-3.76-3-2.92-3.88.35-3.9 3.59-.87 4.36 6.54 3.41 2.83 4.87-7.8.86-4.88-4.36-.47-3.98-6.63-4.4-1.63-6.54-4.91 5.1-3.6-2.63-7.47-2.42-3.32-6.7-3.32-2.88-5.49-5.15 1.97-.36-3.82-3.82-4.28-6.16-4.67-2.62 3.68-5.49 2.63.42-6-4.76-9.95-7.03 4.02-2.56 7.63-2.19-5.87Zm-38.26-6.7-3.28 4.75 3.06 6.22-5.67-1.16-.05 2.98 6.9 6.97 1.91 3.35 2.67.72 4.55-3.38.5-8.12-4.2-4.04 2.59-4.6-.72-2.86-4.95 1.25-3.3-2.08Zm19.86 10.35 3.3-1.83 4.15-8.65-5.3-2.44-5.77-.36-2.76 2.74-1.45 4.2-.04 4.76 1.73 8.1 3.17.34 2.97-6.86Zm-75.61 12.52v-3.83l3.44-6.34 6.8-6.62 3.48-2.45-2.97-4.15-2.7-2.92-7.08-.57-3.96-2.13-9.38 1.6 2.71 6.16-2.4 6.37-3.11 10.61 6.4 4.65 1.47 3.76 7.3-4.14Zm74.46-34.6-1.02-3.42-2.42-3.88-3.98 2.98-1.48 4.88 3.36 2.76 4.03.78 1.5-4.1Zm-13.56-19.77-.21 1.58-3.9-.7-4.18 4.05-2.98-.36.17 8.83 4.55-.86-.06 6.4 2.98 1.7 4.57-1.09 1.27-8.16-.09-5.89-2.12-5.5Zm-26.93 6.14-.94-5.64-2.86-1.4-2.54 4.37 3.96 10.93-4.84-.84-4.93-6.72-7.8-3.95-2.61 3.28-3.79 10.99 3.88 1.93 12.53-1.29-5.76 4.72.35 3.4 4.22-.23 7-4.54 9.4-1.65 1.68-5.17-.49-5.5-2.9-.5-2.48 1.9-1.08-4.09Zm37.52-10.76-5.72-.8-1.04 5.05 3.21 3.7 5.74 1.44 2.78 5.04.34 5.55.96 5.92 7.37 3.38 4.48 1.28 5.69-.18 7.96-1.6 3.55 1.26 4.13-2.23 1.73-2.81-.62-4.48-2.97-4.18-4.5-.8-5.65.96-4.41 2.42-7.79-1.42-1.76-2.67-3.18-2.59.63-4.38-2.4-3.95-5.46.03-3.07-3.94Zm-59.67-6.95-3.8 1.9-4.26-.18-5.7 8.1-.95 11.36 4.44-1.75 5.16-5 2.59-.58 2.13-4.18.39-9.67Zm62 1.62.34-1.48-1.95-2.42-5.58-.2.74 3.64 5.2.82 1.26-.36Zm-45.33-2.3.92-3.94-3.91-2.1-4.05 1.37-2.25 4.22 4.12 4.16 5.17-3.7Zm1.45-12.22-5.1-3.52-2.84 4.24-.04 1.98 4.6.01 3.38-2.71Zm38.37 7.47.75-4.91-3.32-4.88-1.61-.94-3.6-.57.23 5.84 1.18 5.12 2.26 3.09 4.1-2.75Zm-11.74-3.63-2.12-6.65-7.5-5.3-5.44-2.02.2 5.63 3.35 3.44-2.67 4.14 6.17.51 4.57 4.4 4.52 1.47-1.08-5.62Zm36.17-19.41-2.19-10.54-9.22-6.8-3.54-9.45-6.45.92 1.21 4.1-2.84 1.24-1.92 5.27-1.92 7.37 1.75 7.19L236.6 82l5.07-.12-2.19 3.96-.04 5.24 2.98 5.7 5.75 1.75 4.9-.98 5.13-10.62 3.8-4.4-3.34-4.91Zm51.37-64.67L298 10l-8 3.94-1.48-2.5-8.48.96-4.97 2.54-3.66 3.61-2.1 11.62-3-5.92-3.44-1.13-4.08 7.89-5.44 3.31-3.24.66-4.13 3.8.61 6.57 3.24 5.44 2.31 7.21 4.9 5.82 9.71-1.08L273 64.7l-4.33 5.99-2.2-1.76-7.57-.7 1.17 8.22 3.92 5.97-.79 5.15-4.91 3.43-2.25 5.4 4.5 2.63 3.78 8.45-7.42-5.64-1.69.93 1.37 9.28-5.13 2.8.35 5.8 5.24.62 4.13 1.42 8.15-1.83 7.24 3.24 7.42-7.12-.06-2.99-4.74.48-.4-2.81 3.88-3.79 1.32-5.1 4.28-3.78 2.64-4.71-2.3-7.03 1.92-2.62-3.82-1.87 8.4-1.61 1.76-3.12 5.72-2.57 4.75-13.33 4.52-4.9 6.54-11-6.04.1 2.51-4.26 6.71-3.95 6.77-8.8.12-5.67-5.08-5.98-5.95-2.9-7.41-1.8Z"
          data-id="CA"
          data-name="Canada"
        />
        <path
          id="CH"
          d="m523.64 307.98-.57.9-2.36-.04-.76.7-3.2 2.95-.05 1.83 1.33-.63.95 1.76 1.2.85 4.69-1.04.6-1.61 2.05.5 1.22-.68.22-1.66-1.41-.1-1.26-.75.43-1-.11-.72-2.97-1.26Z"
          data-id="CH"
          data-name="Switzerland"
          className="visited"
        />
        <path
          id="CL"
          d="m314.29 642.35-1.67-.13h-2.97v-10.48l-1.98-.54-2.56 1.89-.9 3.17-1.43 2.16-3.67-1.7-3.9-3.1-2.29-.96 3.82 5.2 6.33 5.24 2.9.7 5.02 2.03 2.38-1.52.92-1.96Zm-7.3-133.38-.74 1.5-1.43.74.58 4.13.2 4.85-1.75 13.05-.5 6-1.63 3.85.34 3.93-.83 2.66.64 4.88-1.18 4.94-3.62 10.95-1.17.12.23 3.95.8 3.47-1.27 2.46-1.82 12.18 1.75.53.87-4.71 1.86 1-1.45 7.9-3.08-1.36-.95 6.51-2.64 3.54 4.21 1.18-2.93 3.16-1.18 4 .36 7.3 1.4 2.9-.8 2.6.88 2.86 6.62 5.83 3.13 1.52 1.18-.1.44-4.35 3.84-2.77 2.47.03-2.57-.7-6.7-.61-1.15-2.61.05-3.3-1.85.28-.97-1.59-.25-4.56 2.13-1.86.88-2.66-.32-2.1 1.47-3.49 1.01-5.3-.67-5.3.92-1.62-1.26-1.45-.64-4.37 1.11-.76-.47-4.5 1.4-6.94 1.66-1.29-.85-3.43v-3.2l2.1-2.25-.07-2.85 1.58-3.29.01-3.07-.72-.6-1.28-5.66 1.71-3.33-.26-3.1.99-2.87 1.82-2.95 1.95-1.94-.34-7.33 3.03-1.5.95-3.14-.34-.75-2 .4-1.09-4.12-1.49-3.33.88-2.86-1.46-1.24-.37-2.11-1.36-1.98Z"
          data-id="CL"
          data-name="Chile"
        />
        <path
          id="CN"
          d="m806.02 406.68 1.86-2.99-.62-1.12-4.62.75-1.37 1.34.08 2.52 2.28.9 2.4-1.4Zm47.01-111.08-3.72-9.2-2.44-1.7-4.15-1.38-3.67.13-3.45.83-2.3 2.3 1.53 1.08.04 2.5-1.55 1.44-2.5 4.69.02 1.91-3.9 2.72-3.33-1.62-1.35 3.22-1.96 4.2.71 1.69 1.57-.53 2.74.65 2.13-1.53 2.22 1.32 2.52 2.87-.3 1.44-2.2-.46-4.02.54-1.95 1.15-2.04 2.64-4.23 1.53-2.76 2.09-4.41-1.15-1.46 2.52 1.34 2.75-3.93 3.33-3.24 1.33-4.16.14-4.48 1.3-3.23 2-1.23-1.16h-3.36l-4.1-2.27-2.74-.56-3.68.53-5.73-.85-3.06.09-1.62-2.25-1.27-3.55-1.71-.43-3.35-2.43-7.03-1.22-1-1.71 1.07-4.7-1.92-3.29-3.95-1.55-2.34-2.21-.72-2.95-1.09.35-2.11 2.8-2.3.4-.14 4.15-1.54 1.85-5.5-1.35-2 7.21-1.42.88-5.5 1.57 2.5 6.7-1.9 1 .22 2.14-.39.85-4.37 2.02-.99 1.46-3.56.44-1.05 2.34-2.93-.5-4.57 2.44.39.84-.8.82.71 3.3.91-.35 1.69.8-.1 1.38.42 2 .49 1 2.05 1.61.82 2.65 4.56 1.38 2.98 3.96-.28 2.73 1.1 1.7-.09 1.68-1.99-.44.78 3.6 2.73 2.06 3.85 2.25 1.15-.77 6.58 3.53.93 1.52 4.41 2 3.14.73 3.23.3 1.7-.65.22 2.46 1.84-2.33 1.5-.8 1.98.73 1.46.08 1.22.85 2.24-.4 2.52-2.34 3.2-2.02 2.32.78 1.98-1.34 1.3 1.98-.94 1.33 3 .47 1.62-.24 2.13 2.6-.03 4.94-2.62 2.56-.33 3.62 2.92-.5.66 2.78 1.76.58-.8 2.5 3.25 1.67 2.04-.87.08 1.23.25.7 1.48.08-.42-3.41 1.44-.44 1.49-.73 4.9-.34 2.37-1.6 1.34 1.13 2.53.55-.44 1.73 1.32 1.21 2.8.78 1.3-.49 3.73.96-.66 1.15.73 2.15 1.53-.17.95-3.14 2.94-.46 3.87-1.5 1.57-1.48.96.97 1.7-1.33 3.12-.35 7.67-5.34 2.58-3.66 4.27-7.45 1.55-.28 1.13-5.1-1.63-1-.67-1.7 1.75-.89.04-2.41-3.57-5.54-1.1-3.29-2.98-1.85 1.43-2.38 2.7-1.71 1.29-1.86 3.93-.97-.45-1.83-1.8-.09-2.46-1.36-3.1 2.5-2.2-1.02-.1-1.58-2.26-.58-1.47-2.39 1.42-1.66 2.72-.18 1.7-2.32 3.14-2.53 2.42-1.29 1.46 1.92-2.2 2.44.59 1.4-1.48 1.65 2.99-.97 2.04-1.68 3.88-1.05 2.26-2.33 3.05-1.97 1.9-2.62 1.33 1.16 2.4.13-.44-1.96 4.28-1.61 1.1-2.11 1.8 2.22-.02-1.91 1.42-.1.4-4.52-.73-3.34 2.38-1.39 3.36.7 1.87-3.86.95-4.42 1.08-1.5 1.45-3.74-4.58 1.23-2.4 1.64h-4.22l-1.12-3.92-3.29-3.01-4.82-1.37-1.03-4.25Z"
          data-id="CN"
          data-name="China"
        />
        <path
          id="CI"
          d="m483.87 430.92-1.08-.85-1.79 1.09-2.9-.45-.37.26-.55.22 1.1 4.36-1.08 1.27-.17 1.22h-.44l-.12.82 2.53 4.71-.39 3.74.54.07 4.67-1.82 3.28-.49 3.72.51 1.26-.02-1.08-3.5.73-3.16 1.16-2.35-.73-4-1.9-.72-3.52.22-.48-.93-1.25-.62-1.14.42Z"
          data-id="CI"
          data-name="C\xC3\xB4te d'Ivoire"
        />
        <path
          id="CM"
          d="m541.3 425.28-1.1-1.82-.78.16-.09.9 1.1 1.14-.45 1.45-2.34 2.19-2.27 5.85-1.48 1.16-1.31 3.7-1.9.95-5.07.55-2.03 4.67-.04.76 2.54 2.12 1.09 1.84-.4 2.19 4.5.06 1.32-.18 1.69.37 1.64-.35.35.15 3.5.1 2.24.74 2.2.65.2-1.5-.3-.8-.11-1.27-3.84-4.78.16-4.16.66-.5 1.4-2.84.43-.75-4.1-5.21.6-1.33 3.59.1-1.51-2.55.1-1.88-.18-1.88Z"
          data-id="CM"
          data-name="Cameroon"
        />
        <path
          id="CD"
          d="m551.18 449.7-.17 1.68-1.71 5.67-.7 4.44-1.82 1.34-2.48 4.12.1 2.29-3.96 3.99-3.67-.25-.73-.28-1 .59-.46.71-.09 1.22-.7.3.39.86 2.92-.66 8.18.04.69 2.07 2.5 4.05 5.38-2.56 6.41.38.62 2.84-.41 1.7 1.13 2.77-.15 3.35 3.6-.61 1.27.17.96.07 3.22 1.07.92 1.28 2.22.4 1.7-.9.62 1.49 2.13.4 2.16 2.77 2.12.03-.23-3.07-3.45-1.1.84-6.17-.62-1.24.79-1.79 4.95-.68.13-.47-3.81-5.8-.26-2.75.5-4.44.01.03-.02-.48-.7-1.27.26-1.52.38-.2.1-1.66.8-.77.02-2.1.64-1.05.16-2.23.58-1.3 3.02-3.16-1.11-.38.17-3.24-2.44-1.85-.66-1.19-1.55.59-3.27-.05-1.68-2.3-.91.3-7.3.05-5.57 3-8.15-2.79-2.56 2.31-.25 1.94Z"
          data-id="CD"
          data-name="Democratic Republic of the Congo"
        />
        <path
          id="CG"
          d="m549.4 449.55-1.88-.47-1.65 1.47-1.46 2.58-.2 1.5-2.2-.65-2.24-.73-3.5-.11-.2 1.2.77 1.44 2.75.33-1.2 3.2 1.32 1.65-.9 5.32-2.45-.12-1.48-1.33-.22 1.23-2.83 1.04 1.05 1.84-2.11 1.53 2.28 2.95 1.12-1.2.83-.47 1.04.95.73.28 3.67.25 3.95-4-.09-2.28 2.48-4.12 1.82-1.34.7-4.44 1.71-5.67.17-1.68-1.78-.15Z"
          data-id="CG"
          data-name="Republic of Congo"
        />
        <path
          id="CO"
          d="m302.7 425.58-1.7-.92-4.61 3.43-2.17-.24-3.56 1.95-1.68 3.61-2.09 1.97-1.43-.1.3 2.07-.51.83-1.25 1.16 1.12 1.49.97 7.91-2.23 3.2-1.38.19-1.56 2.6.38.87 3.96 2.73 2.36.38 2.15.48 1.18.66.74-.27 4.02 3.34 1.63 2.91 2.07.35 4.19-.5 2.12 1.3-1.78 2.83.82.07 1.4 1.48 1.24-7.62-1.6-3.8.01-2.02 2.21-1.23-1.62-.28-.04-1.74 5.4.06 2.24 1.56.52-.34-.85-2.77-1.74-1.58 1.4-1.38-1.44-3.3 1.34-4.43-.98-.48-4.7.47-1.95-2.4-5.18-.1-1.33-3.95-2.4-2.1 1.1-3.65 2.6-3.27 1.77-.48.54-.95Z"
          data-id="CO"
          data-name="Colombia"
        />
        <path
          id="CR"
          d="m261.64 429.02.78 2.72 2.63.07.18.82 3.16 3.28 1.5.63.28-1.64.41-.33.48-1.8-1.3-1.2-1.07-1.14-.7-1.53-.67.6-5.04-1.02-.64.54Z"
          data-id="CR"
          data-name="Costa Rica"
        />
        <path
          id="CU"
          d="m279.01 394.56-2.6-1.03-10.02 1.63-.6 1.08 2.64.1 2-1.55 2.71.15-.07 1.34 3.62.46 3.41 1.43 1.57-.12 4.54 3.52-1.86 1.65 9.59-.57.33-.7-6.5-2.73-5.07-3.9-2.59.34-1.1-1.1Z"
          data-id="CU"
          data-name="Cuba"
        />
        <path
          id={'NCY'}
          d="m594.02 354.85 1.88-1.45-2.52 1.02-2.4.77-.2.02 1.81-.08.4.42 1.24-.06-.2-.64Z"
          data-id={'NCY'}
          data-name="Northern Cyprus"
        />
        <path
          id="CY"
          d="m589.46 355.33.65 1.36 1.36.44 2.84-1.37-.08-.27-1.25.06-.39-.42-1.8.08-1.33.12Z"
          data-id="CY"
          data-name="Cyprus"
        />
        <path
          id="CZ"
          d="m540.41 294.45-3.42 1.18-3.04 2.04.78 3.1 1.41 1.02 1.57 1.82 2.06 1.35 4.69-.75 1.3-.22 1.28.8.4-.93 1.22.07 2.8-2.94h.83l-1.28-2.12-2.06-.26-.26-1.36-1.9-.49-.42 1.13-1.33-2.1-2.08-.38-1.31-1.42-1.24.46Z"
          data-id="CZ"
          data-name="Czech Republic"
          className="visited"
        />
        <path
          id="DE"
          d="m537.85 280.43-3.13-1.88-1.56 1.3-2.82.9.03-1.69-2.8-1.11-.05-1.86-1.78.73-2.1-.63.13 2.72.64 1.78-1.88 2.31-.52-1.03-2.32.25-.54 1 .52 1.56-1.4 5.89h-1.66l.47 4.65-.32 2.95.55.97-.15 1.88 1.3 1.11 4 .78-1.4 2.88-.35 2.95 2.36.03.57-.9 2.97 1.27.84-.23 4.24.23 3.31-.61.73-2.56 1-.53.98-1.93-1.57-1.82-1.41-1.03-.78-3.1 3.04-2.03 3.42-1.18 1.24-.46-1.14-2.84-1.47-5.62.77-1.23-.65-2.37-1.3-1.5Z"
          data-id="DE"
          data-name="Germany"
          className="visited"
        />
        <path
          id="DJ"
          d="m618.47 426.65 1.58-.68.1-1.18-.66-.88-.84.7-1.19-.25-.97 1.25-.68 2.97 1.55.05.67-.2.61.5 1.02-1.5-1.19-.78Z"
          data-id="DJ"
          data-name="Djibouti"
        />
        <path
          id="DK"
          d="m535.2 273.04-.89-2.48-4.07 1.64.39 2.04 2.9 2.73 1.67-3.93Zm-11.55 3.15 2.1.63 1.77-.73-.76-2.37 2-3.55 1.5-1.35-1.01-3.84.1-2.65-3.21 2.88-2.44.31-1.26 2.9.08 5.07 1.13 2.7Z"
          data-id="DK"
          data-name="Denmark"
        />
        <path
          id="DO"
          d="m301.26 409.37.71.46 6.2-2.4 1.32.63 1.03-1.19-2.5-2.05-1.52.06-2.88-1.73-2.17-.02-.34.5.03 2.74-.68.49.66 1.67.14.84Z"
          data-id="DO"
          data-name="Dominican Republic"
        />
        <path
          id="DZ"
          d="m521.46 349.22-1.13-.8-2.96.02-2.61 1.37-1.4-.51-9.3.9-4.41 2.46-3 .6-2.67 1.85 2.4 9.7-3.64.55-2.86 1.49-.12 2.4-3.24 1.28-1.06 1.6-5.04 1.35-4.48 2.35.03 3.73v.2l-.06.61 10.44 7.49 9.35 6.61 9.36 6.52 3.67 2.7.03 1.88 3.08-.29 3.9-1.31 8.04-5.82 9.5-5.72-1.22-1.9-2.19-1.42-1.3.56-2.72-5.26 1.1-1.29-.1-5.1.35-4.05-.9-2.82-1.18-5.82-4-4.1-.25-2.5 1.7-1.88.66-2.8-.44-3.26.57-1.78-1.9.21Z"
          data-id="DZ"
          data-name="Algeria"
        />
        <path
          id="EC"
          d="m289.77 459.2-2.15-.49-2.36-.38-3.96-2.73-1.91 1.1-3.86 5.66 1.57 4.52 1.06-1.3.6 1.22-1.48 2.07-.39 2.84 3.44 1.49 1.56-1.15 2.23-4.3 3.33-1.09 3.03-2.9.86-1.8-.39-2.11-1.18-.66Z"
          data-id="EC"
          data-name="Ecuador"
        />
        <path
          id="EG"
          d="m569.8 367.07-1.01 1.56-.28 3.36.83 2.58v22.28h32.91l-.49-.61-3.23-2.7.46-2.5-2.49-3.37-5.71-11.41-.86-3.65 1.97 4.55 2.18 2.42.65-.55 2.13-5.3-.28-.83-1.55-4.7-1.36.82-5.78-1.5-5.56.8-2.14 1.02-6.7-2.32-3.7.05Z"
          data-id="EG"
          data-name="Egypt"
        />
        <path
          id="ER"
          d="m606.53 408.67-1.4 1.66-2.05.48-.87.89-.27 1.92-1.2 4.23.3 1.15 3.23.6.86-2.14 1.69 1.3 2.3-.08 1.9.04 2.4 1.15.72.98 1.23.92 1.14 1.67.95.92 1.19.25.84-.7-1.37-.85-3.91-4.26-5.3-4.12-.77-2.65-1.61-3.36Z"
          data-id="ER"
          data-name="Eritrea"
        />
        <path
          id="ES"
          d="m490.24 325.34-2.3.2-2.95-.65-3.72.03-3.4-.7-3.92 2.76 1.13 1.64-.14 2.67 2.14-1.5.7 1.83 3.72-.34.78 1.86-1.28 1-.6 5.1-1.2.29 1.11 2.15-.98 6.8 2.59.55 3.17 3.43 2.8-2.52 6.16.02 1.96-2.68 2.1-.7.6-2.28 1.6-1.58-1.08-2.04 1.07-2.94 1.95-3.25 3.55-.78 2.63-2.47-.15-2.17-3.21.49-3.12-1.7-1.01.8-5.1-1.7-1.11-1.49-4.49-.13Z"
          data-id="ES"
          data-name="Spain"
          className="home"
        />
        <path
          id="EE"
          d="m567.43 262 2.36-.92 1.22.64 2.39 1.92 2.28.01 1.2-1.64-.83-4.92 1.97-3.1-.41-.95-2.87.16-3-.9-3.5.79-3.5 1.51.23 3.09 1.76 1.88 1.02-.66-.32 3.1Z"
          data-id="EE"
          data-name="Estonia"
        />
        <path
          id="ET"
          d="m601.04 419-.45 2.45-1.12 2.8-1.68 1.41-2.78 4.11-.82 2.95v.34l.04 2.19-1.89.92-.94 1.6 1.7.2 3.16 3.13 1.64 3.03 1.44.47 6.39 4.84 3.99.49 3.35-2.32 1.12.94h1.9l.75-.88 1.78-.05 2.47-1.96 3.62-.12 7.83-8.38-2.33.01-9.07-3.32-1.06-1-1.02-1.36-1.02-1.55.6-1-.61-.5-.67.2-1.55-.06.68-2.97.97-1.25-.95-.92-1.14-1.67-1.23-.92-.71-.98-2.42-1.15-1.9-.04-2.3.08-1.68-1.3-.86 2.14-3.23-.6Z"
          data-id="ET"
          data-name="Ethiopia"
        />
        <path
          id="FI"
          d="m580.47 185.54-3.55-3.22-4.31 2.74-1.36 5.8-2.65 3.4-2.97-1.85-3.63.38-3.08-4.1-1.66 2.06 3.7 3.76 4.33 5.1.07 11.02.94 2.67 3.85 3.2.3 2.8-1.86 1.38-6.35 6.95-2.51 3.9-1.32 3.55 1.34 5.36-.61 5.67 2.68 1.85 1.6 3.04 4.52-1.17 4.88-2.05 5.03-.45 8.52-10.75 1.04-3.08-4.1-4.21 1.13-4.1-2.5-4.82 1.87-5.7-3.23-7.88 2.56-5.43-4.25-4.94.4-5.35 1.18-5.53Z"
          data-id="FI"
          data-name="Finland"
          className="visited"
        />
        <path
          id="FJ"
          d="m994.72 508.27-3.02 1.12.26 1.28 3.25-.04-.5-2.36Zm2.74-1.56 1.77-.72v-1.4l-3.9 1.65.36 1.08 1.77-.61Z"
          data-id="FJ"
          data-name="Fiji"
        />
        <path
          id="FK"
          d="m337.61 624.83-1.66 1.78-2.36-1.11-3.33 2.67 1.39 2.03 2.36-2.03 1.25 1.58 3.74-1.35.83-1.57-2.22-2Z"
          data-id="FK"
          data-name="Falkland Islands"
        />
        <path
          id="GF"
          d="m356.27 446.75-2.94-2.35-2.04-.66-.94-.3-1.45 2.39.22 1.9 1.08 1.64-.48 1.2-.24 1.26-.7 1.18 1.2.57 1.86.15 1.33-.2 3.56-5.64-.46-1.14Z"
          data-id="GF"
          data-name="France"
        />
        <path
          id="GA"
          d="m535.92 452.99-1.64.35-1.69-.37-1.31.18.02 3.34-4.04-.03-.93.16-.56 2.06-1.37 3.83 1.69 2.86 1.83 2.3 2.85 2.8 2.11-1.53-1.05-1.84 2.83-1.04.22-1.23 1.48 1.33 2.45.12.9-5.32-1.32-1.64 1.2-3.21-2.75-.33-.78-1.43.2-1.21-.34-.15Z"
          data-id="GA"
          data-name="Gabon"
        />
        <path
          id="GB"
          d="m479 275.37.57 2.58-.57 2.55 3.81.9 1.49-3.25-2.98-2.98-2.32.2Zm12.67-17.8-3.35.45-2.22-.42-2.15 4.27-1 5.3 1.4 2.57.16 4.76 1.49-2.32.91 1.35-1 2.18.65 1.3 5.27 3.84-.4 2.72-4.13-.42-.53 3.03 1.52 2.46-2.9 1.4 2.66 3.5-4.07 4.59 1.47.86 1.95-1.65 2.57.5 1.83-2.05 1.3.86 4.72-1.2 3.7.04 2.5-2.31-1.1-2.3 1.4-1.33.34-2.9-3.36-.88-2.5-7.19-1.9-.77-5.55-6.57 2.5-4.5.72-4.17-3.04-.03-2.83.7 2.97-5.67Z"
          data-id="GB"
          data-name="United Kingdom"
          className="visited"
        />
        <path
          id="GE"
          d="m611.15 324.97-.34.45 1.02 1.17 1.54.44 1.6 1.4.7 2.55-.42 1.59 2.95-.18 2.68 1.82 3.85-.58.68-.6 3.94.85-1.37-2 .72-.52-1.74-.86-.85-1.54-2.59-.79-1.68.6-.48-.7-3.78-1.83-4.08-.61-2.35-.66Z"
          data-id="GE"
          data-name="Georgia"
        />
        <path
          id="GH"
          d="m498.78 428.45-6.94.38-.06 1.6.38 2.13.73 3.99-1.16 2.35-.73 3.16 1.08 3.5 2.47.79 2.5-.81 1.54-.96 4.35-1.63-1.58-4.14.61-2.52-.95-5.28-1.16-1.45.2-.88-1.28-.23Z"
          data-id="GH"
          data-name="Ghana"
        />
        <path
          id="GN"
          d="m467.67 424.8-2.34.16-1.99-.7-1.34-.03-.05.97-.07 1.23-1.77.86-2.07 1.32.8.47.4.62.32 1.24 2.48 2.03 1.22 1.66 3.69-3.21h2.22l1.7 4.77.76-.16.59-.07 3.02 3.14.57-1.13.78.07h.44l.17-1.22 1.08-1.27-1.1-4.36.55-.22-.85-.82-.11-2.53-4.96-1.28-3.58-.66-.16-1.04-.4.16Z"
          data-id="GN"
          data-name="Guinea"
        />
        <path
          id="GM"
          d="m453.29 422.63 2.52.06 2.2-1.08 1.19.6 2.4-.6-3.43-1.05-4.53.8-.35 1.27Z"
          data-id="GM"
          data-name="The Gambia"
        />
        <path
          id="GW"
          d="m456.88 424.11-.75.32-.92-.09-1.46.47.17.6 1.47 1.83 1.17.2 1.48 1.17 2.07-1.32 1.77-.86.07-1.23.05-.97-5.12-.12Z"
          data-id="GW"
          data-name="Guinea-Bissau"
        />
        <path
          id="GQ"
          d="m526.76 453.09-.95 3.12.52.41.93-.16 4.04.03-.02-3.34-4.52-.06Z"
          data-id="GQ"
          data-name="Equatorial Guinea"
        />
        <path
          id="GR"
          d="m565.73 353.29-.51 1.44 3.35 1.22 4-.28.34-1-5.66-.23-1.52-1.15Zm6.7-21.8-.03 1.84-2.52.35-1.95-1.29-2.22 1.02-2.05-.11-.53.12-.46.65-1.5-.08-1.06.8-1.81.33-.06.96-.9.53-.16 1.18-1.3 1.76.2 1.02 2.98 6 1.04 2.8 2.28 1.5 1.84-.04-1.05-3.06 1.76-.37-.82-1.79 2.56.93-.04-1.98-2.91-2.67 1.04-.78-1.49-4.65 1.47 1.87 2.96-.59-1.93-2.05 3.36-.95 1.45.35 1.69.1.66-.41.86-2.3-1.35-1Z"
          data-id="GR"
          data-name="Greece"
        />
        <path
          id="GL"
          d="m402.68 0-9.8 2.39-3.54 8.86-9.73-1.06-9.3 13.46-.39 9 6.6 10.65-5.76-6.34-3.9-1.58-6.62-7.7-7.35 11.21-3.03-6.24-8.52.18-8.53 3.18-6.57 5.18 1.15 8.48-4.03 1.96-9.6 12.2-2.42 6.57 7.49 5.7-1.08 5.58-10.16 7.08-10.5 6.8-.38 5.28 6.25 5.38 11.87 3.33-5.58.67-7.28 3.93 4.82 7.58 3.21 3.7 6.77-.84 7.41-.47 5.9.84 7.44 6.63-.04 4.57 3.53 4.14 5.54 17.47 1.69 3.48-3.1 8.42 2.32 2.17 2.76-1.22 7.25 8.35-5.66-2.23-2.57.12-1.09 4.43.19 5.5 3.4 2.57 7.17-5.13-.58 6.2-1.1 3.22-4.17 2.82-2.74 8.57 1.85 2.5-1 5.13 3.84 6.2.38 5.84 1.4 4.11 4.81 7.6 1.85 5.75 2.7 3.15 5.54.03 4.1 4.6 3.9-.34 2.67-10.32-1.12-4.66 4.52-4.9 1.4-4.13.05-4.52 2.37-4.08 7.68-3.23 1.92-.28 5.96-4.84 3.86-7.56 2.87-2.84 3.06-.04 8.11-2.59 7.54-6.06 7.44-6.96-11.14-.8 3.22-4.36-.94-5.8 5.56 8.15 4.95-1.6-1.05-6.9-3.64-5.41-3.74-2.27 1.42-2.46 5.5 3.79-.05-4.09-3.47-6.41 3.87-.03 3.9-1.5.92-3.47-3.22-4.1 6.16-.74-3.6-9.05 2.97-1.01-.65-9.53-5.12-6.23 4.56-3.84 4.34-.5-3.33-8.25-.1-15.1 2.24-9.5 3.25-11.38-6.43-.78 8.87-2.83 1.56-3.86 11.31-12.53-1.56-8.02-8.31-3.78-13.47 7.47-7.06 6.85 3.04-10.84-2.3-7.08-5.39 6.06-8.35-6.84-9.82 2.22-1.4-3.6 14.93-2.01 10.61-.92 5.13-8.22-17.35-18.39L402.68 0Z"
          data-id="GL"
          data-name="Greenland"
        />
        <path
          id="GT"
          d="M250.2 409.19h-2.6v1.64l1.5 3.43-3.56.01-1.34 2.35v2.04l1.5 1.18 1.27.57 1.73.05 1.42.5.09-.42 1.32-1.37.65-.18.58-.73 1.29-1.92 1.26-1.1-.81-.36-.24.43-.9-.52h-.84l.22-3.27.02-2.3-2.56-.03Z"
          data-id="GT"
          data-name="Guatemala"
        />
        <path
          id="GY"
          d="m340.4 441.86-2.6-2.87-1.72-1.82-1.82-1.03-3.88 4.67.05 1.3-.75.76 1.88 2.11 1.44-.12 1.87 3.58-1.2 3.34 2.6 4 1.37.13 4.87-1.65.68-.1-1.7-2.42-2.48-3.59 2.05-2.81.44-2.51-1.1-.97Z"
          data-id="GY"
          data-name="Guyana"
        />
        <path
          id="HN"
          d="m268.66 416.56-1.8-1.08-2.56-1-8.7.88-.3-.11-1.25 1.1-1.3 1.91-.57.73.82.24 1.54 1.42 1.21-.34.76 1.65.84.25.48.9 1.62-.8-.06-1.4 2.64-.24 3.75-2.24 3.61-1.08-.73-.79Z"
          data-id="HN"
          data-name="Honduras"
        />
        <path
          id="HR"
          d="m545.94 313.39-2.2 1.07-1.24 2.02.01 1.1-4.47-.18-.1.06.76 2.68.85-1.7 1.78.63.76 3.25 2.33 2.83 6.75 3.9.3-.65-2.45-1.43-5.34-6.9.58-1.62 1 .9 6.2-.3 1.25.87 1.07-1.48-.88-1.13-.68-1.54-1.03.6-2.3-.77-2.07-1.71-.88-.5Z"
          data-id="HR"
          data-name="Croatia"
        />
        <path
          id="HT"
          d="m298.7 403.17-2.32.69 1.75.46 1.25 2.39-1 .65-4.64-.64 1.24 1.85 4.3-.54 1.84.5-.66-1.67.68-.5-.03-2.72-2.4-.47Z"
          data-id="HT"
          data-name="Haiti"
        />
        <path
          id="HU"
          d="m547.1 306.76-.22 1.7h-1.56l.54.9-.92 2.62.46.05.54 1.36.88.5 2.08 1.71 2.29.77 1.03-.6 2.13-1.05 1.73.18 2.22-.76 1.68-2.74 1.31-2.77 1.7-.87-.2-1.1-1.54-1.14-.59.43-3.88-1.02-.65.98-7.63 1.91-1.4-1.06Z"
          data-id="HU"
          data-name="Hungary"
        />
        <path
          id="ID"
          d="m834.8 487.98-2.26-2.47-2.58.55 3.68 1.97 1.16-.05Zm12.13-2.38-.05-.86-.28-.55-2.74 1.12-1.11 3 2.37-.61 1.81-2.1ZM827 481.95l-2.26 1.02-.95 1.61 6.62-.92-.7-1.19-2.7-.52Zm13.88 0-6.07.4-2.2.58v1.03l3.7.34 4.16-.8.41-1.55Zm-39.6-3.68-3.77-2.3-3.37-.16-1.9 2.66 2.54.2.48 1.21 5.06 1.15 3.19-.07 3.2 1.07 8 .63 3.04 1.13 3.17-1.06-3.4-1.67-4.17-.51-1-1.81-5.15-1.34-.61 1.15-5.31-.28Zm72.39-1.57v-1.33l-1.7 1.12.27 2.1 1.43-1.9Zm-20.74-7.67-.69-.92-2.8.13.54 1.2 1.92.5 1.03-.91Zm8.94-1.02-3.05-.8-3.43.1-.65 1.53 5.8.15 2.34 1.15-1.01-2.13Zm29.3 16.81-.05-9.12-.05-9.06-2.98-.53-4.42-1.96h-2.47l-3.18 1.68-2.32 2.94-2.87-1.66-1.21-5.52-4.46-1.14-1.42.9-3.74.68 1.18 1.37 2.48.51 1.1 1.65h4.05l-4.73 1.7 3.82 3.34.82-1.35 4.17 2.57 2.28.23 5.38 2.36 1.33 2.34.73 3.03-1.75.78-1.18 2.28 3.52-.09.68-.8 2.82.57 2.47 2.3Zm-43.8-29.33-.5-.62-2.73 2.01-6.69-.27-2.17-.82-2.35 2.06-2.37 7.53-1.15 1.82.86 1.9 1.17.02.43 2.69-.8 2.56 2.95.41-.34-7.22 1.84-.84-.2 2.7 2 1.63.33 1.85 2.72-1.08-1.34 2.28 1.09.98 1.48-.82.02-1.83-2.5-3.2.52-.96-2.63-3.56 2.44-1.08 2.64-2.5-5.17.95-1.5 1.25-2.48-2.46.4-2.1 7.04-.54 2.67.54 2.08-.53 2.23-2.75Zm9.55.8-1.9-1.38-1.67 1.71.82 3.55 1.18-1.73 1.43.27.14-2.43Zm-29.97-8.35-5.59-.47-.96 3.16-1.07.97-1.42 3.86-2.26.59-3.96-.54-1.61 1.4-3.56.37-1.9-1.57-.46-1.85-1.65 1.84.06 5 1.34 2.37 1.38.77.42 3.73 4.1.16 1.02 1.35 3.3-1 3.36 1.05 1.1 1.7 3.15-1.25.4.98 1.07-4.24.08-2.77 2.66-1.9-.12-2.5.93-1.9 3.29-.33-3.11-2.56.48-1.28-2.04-2.63 1.57-2.51Zm-33.46 27.75.11-4.31.7-3.46-1.35-1.76-2.04-.24-4.02-4.52 1.11-2.26-2.1-1.27-1.61-2.32-2.33-1.9-2.82-.05-6.3-6.02-2.46-2.73-6.08-.65.25 1.42 4.98 4.62 1.45 2.38 2.5 1.75 1.84 4.55 2.43 2.31 2.11 3.88 4.67 6.03 3.56 2.27 2.33 2.33 3.07-.05Z"
          data-id="ID"
          data-name="Indonesia"
        />
        <path
          id="IN"
          d="m721.1 369.3-2.72-2.06-.78-3.6 2 .44.08-1.69-1.1-1.7.28-2.72-2.98-3.96-2.68 2.84-3.09.5-4.2-.82-1.37 1.45 1.95 5.17 2.24 1.63-2.37 1.89.05 2.31-2.7 3.23-1.73 3.23-2.9 3.31-3.23-.24-3.05 3.28 1.81 1.4.32 2.37 1.56 1.56.55 2.62h-6.1l-1.85 2.02 3.25 2.56.82 1.18-1.33 1.08 3.62 3.62 1.95.35 4.04-1.78.53 6.36 1.98 9.36 2.52 3.95 1.17 5.35 1.47 2.73 3.32 8.12 2.63 2.62 2.04-2.71 2.53-.8-.84-.92 1.26-2.15 1.43-.14.02-4.8 1.17-2.7-.72-6.1.83-2.19 5.18-1.9v-1.33l7.95-7.19 4-1.98 1.48-1.76-.16-2.23 5.3-.58.4-1.1-1.4-4.74.48-1.82-1.7-.82 2.34-2.25-2-1.63.98-2.1 3.52 1.5.24 2.13 6.81.9-1.28 2.58-2.1 1.9 1.53 1.56 1.22-1.94 1.46 4.78 1.36-.71.45-5.43 2.16.69 2.91-6.58-.08-1.77 3.59-2.15 1.98.56.74-2.5-.2-1.18-3-.47.94-1.33-1.3-1.98-1.98 1.34-2.32-.78-3.2 2.02-2.52 2.34-2.24.4 1.13 1-.2 1.9-6.35.38-2.52-1.18-.06-.63-.23-2.46-1.69.66-.21 1.35.04 3.2-2.3.05-5.49-1.01-1.6-1.59-3.8-.4-8.92-4.5 1.08-2.97 1.76-1.45-3.85-2.25Z"
          data-id="IN"
          data-name="India"
        />
        <path
          id="IE"
          d="m476.9 277.62-3.77 3.72 1.45 4.73-2.25 4.74 3.92.68 4.92-2.66 2.1-4.09-.46-3.33-3.81-.9.57-2.56-.57-2.58-2.1 2.25Z"
          data-id="IE"
          data-name="Ireland"
        />
        <path
          id="IR"
          d="m624.24 339.23-1.9 1.02.86 4.09-.54 1.1 1.52 2.8 1.8 4.11 1.81 1.03.21 1.99-1.4 1.17-.64 2.62 1.92 3.16 3.4 1.8 1.43 2.5-.46 2.35 2.45 3.4 1.04-1.25 1.76 1.06 1.5-.52 3.9 7.24 2.66.9 2.8 2.39 3.4 1.03 6.25-1.5 1.18 3.79 6.15 1.1 5.22.93 1.05-3.58 4-1.6-1.56-1.94-.08-2.76-2.65-1.39-1.11-1.91-1.38-1.68 2.52-2.9-.23-2.1-2.1-.54-1.12-4.7 1.18-1.82-1.2-.49.76-2.44 1.13-4.22-.25-2.88-2.06-.13-3.17-3.07-2.22-.38-3.06-1.78-5.05.23-1.97 2-2.44.68-.27.8-4.33.93-3.94-.6-1.93-1.75-2.63-.72-.87-2.6-2.42-1.68.95-1.77-1.86-.78-3.27 2.63-1 .1-1.9-.46-1.4-1.65-.44-1.36Z"
          data-id="IR"
          data-name="Iran"
        />
        <path
          id="IQ"
          d="m617.46 348.03-1.43 2.16-1.51.85.26 2.5-1.05 4.1-6.14 3.48 1.12 4.02 3.34.88 4.13 2.28 7.82 6.46 5.16.25 2.03-3.06 1.87.26 1.64.16-2.45-3.4.46-2.36-1.43-2.48-3.4-1.81-1.92-3.16.65-2.62 1.4-1.17-.22-1.99-1.82-1.03-1.8-4.12-1.32.6-.98-.9-3.22-.44-1.2.54Z"
          data-id="IQ"
          data-name="Iraq"
        />
        <path
          id="IS"
          d="m459.76 210.21-4.6-.5-4.52 3.68-3.5-1.94-4.2 3.72-4.33-4.64-4.2 1.02-1.88 4.43 5.82 1.55.12 1.95-4.9 1.27 6.03 3.17-2.73 2.81 11.39 2.9 10.39-5.47 3.6-4.96-3.13-4.55.64-4.44Z"
          data-id="IS"
          data-name="Iceland"
        />
        <path
          id="IL"
          d="m598.6 361.5-.25.58h-.93l-.08.03-.4.84-.55 2.48-1.36 2.78 1.55 4.69.28.83 1.38-5.14-.07-1.26-1.3.44.13-1.67.58-2.18 1 .45.49-1.03-.05-.03.37-.5-.04-1.35-.74.04Z"
          data-id="IL"
          data-name="Israel"
        />
        <path
          id="IT"
          d="m543.05 344.52-4.94.69-3.24-.32-.4 1.8 7.41 3.45.17-2.86 1-2.76Zm-17.5-10.75-2.92.96.63 2.09.12 4.35 1.05.95 2.39-.97.39-4.77-1.67-2.6Zm3.41-21.96-.22 1.66-1.22.68-2.05-.5-.6 1.61-4.7 1.04-1.19-.85-.11 1.12.81 1.49-.96 1.2.72 3.01 1.5.5-.32 1.66 1.15-.28 2.88-2.31 3.64 1.72.86 3.78 6.6 6.27 2.05.24 2.98 2.14 3.9 5.92-.6.76.58 2.71 1.48-3.04 1.16-.2.32-1.87-2-1.34 1.17-2.34 2.4.6 1.55 1.69.23-1.98-2.38-1.9-4.52-2.45.78-.74-2.85-.8-3.09-3.03-1.4-3.14-2.6-1.94-.72-5.03 2.26-1.41 2.2.58-.66-1.7.3-1.97-3.96-1.05-.62-1.4-2.74.7-.33.77-1.68-.58Z"
          data-id="IT"
          data-name="Italy"
          className="visited"
        />
        <path
          id="JM"
          d="m286.71 409.05 1.5-.86-1.48-.7-3.67-.16-.33.67 3.98 1.05Z"
          data-id="JM"
          data-name="Jamaica"
        />
        <path
          id="JO"
          d="m607.59 361.12-5.43 3.52-3.1-1.3-.47 1.03v2l-.42.96.07 1.26-1.38 5.14.09.46 3.09.5 1.86-2.12 2.12-.45 1.37-1.62-2.77-3.23 5.56-1.64.53-.5-1.12-4Z"
          data-id="JO"
          data-name="Jordan"
        />
        <path
          id="JP"
          d="m873.42 358.55-2.04-.72-1.14 1.4-1.58-.38-1.53 1.99-.02 1.57 1.8.94.74-1.93 1.42-.78 1.14 1.07 1.56-2.01-.35-1.15ZM891 348.33l-.05-3.61 2.56-3.58.09-2.92-1.52-5.07-2.94.68-1.18 2.31.48 4.08-1.74 4.35-5.65 4.86-1.85-1.66-2.9 6.12-2.97-.7-5.52 1.02-2.03 2.32-2.8 1.74-1.45 2.1-2.62 1.03 1.13 2.26 1.75.96-.68 2.94 1.35 1.26 1.79-1.36 1.85-5.58-2.81-2.45 3.24-.06 3.29-1.58 4.82-.74.12 2.5 1.86 1.28 3.95-3.82 4.88-.2 3.54-1.6 1.44-2.4-.48-1.71 1.05-2.77Zm8.13-25.75-2.13-1.3-3.26-4.09-1.62 8.41-2.97.21-1.37 2.92.38 3.71 3.09-.05 1.5-4.1 4.37 2.57 2.43-3.74 4.11-1.04-.62-4.31-1.96 1.64-1.95-.83Z"
          data-id="JP"
          data-name="Japan"
        />
        <path
          id="KZ"
          d="m682.13 277.93-1.36 1.18-10.38 1.64-1.27 1.6 2 3.19-2.66 1.2.52 1.24-2.66 2.2 4.5 3.07-.7 2.1-3.9-.2-.8 1.3-3.55-2.27-4.4.09-2.94 1.85-3.28-1.78-6.12-3.07-4.33.11-5.72 4.81-.35 3.17-2.85-2.51-2.22 4.73.81.87-1.6 3.19 2.36 2.81 2.06-.11 1.76 2.73-.28 2.09 1.41.65 2.59-.84 3.21-1.79 2.36 1 2.77-.2.5 2.5-.5 3.87-2.42-.59-2.36.64-.11 2.86-2.7-.37 1.63 2.25 1.25 3.44 3.21 1.29-.15 2.87.15.9 1.23-1.23 3.15-.78 1.87 1.05 1.94 2.9 1.43-.17-.11-14.03 7.14-2.33 7.08 4.64 2.65 3.47 8.01-.86 3.32 2.79-.2 3.77 1.35.03.56 3.04 3.53.11 1.8 1.72 1.2-2.63 3.66-2.6 1.6-.68.61-1.65 1.83-.53 4.56 1.3.43-2.24 1.58-.78 3.95 1.6 1-.42 8.72.5 1.39 1.35 1.71.55-.22-2.15 1.9-.99-2.5-6.7 5.5-1.57 1.42-.88 2-7.2 5.5 1.34 1.54-1.85.14-4.15 2.3-.4 2.11-2.8-1.47-2.61-3.57.57-1.18-1.83-1.94-.84-1.34-2.52-1.53-.8-3.98 1.13-3.82-2.54-1.48 2.31-6.2-11.48-3.54-3.62 1.02-1.5-6.95 4.46-2.67.27.23-2.56-3.56-1.62-2.9 1.15-.87-4.96-4.98-1.05-2.5 2.01-6.93 1.78Z"
          data-id="KZ"
          data-name="Kazakhstan"
        />
        <path
          id="KE"
          d="m614.19 448.55-1.12-.94-3.35 2.32-4-.5-6.38-4.83-1.44-.47-1.88 1.84-1.7 1.66 1.3 1.93 1.55 4.58-1 2.02-2.17 3.1.68 1.05-.18 2.06 10.06 5.65.19 1.61 3.98 2.78 1.11-.92 1.44-2.97.39-1.96 1.72-1.36 1.95-1.1-1.65-2.3-.03-10.1 2.42-3.15h-1.9Z"
          data-id="KE"
          data-name="Kenya"
        />
        <path
          id="KG"
          d="m720.89 328.98-1.39-1.35-8.71-.5-1.01.41-3.95-1.6-1.58.8-.43 2.23-4.56-1.3-1.83.53-.62 1.65.83.37-2.33 2.4 2.05 1.4 1.97-.92 3.29 1.94-3.55 2.62-2.11-.35-1.02 1.12-3.02-.61-.26 2.08 3-.28 3.43 1.17 5.25-.55.79-.82-.39-.84 4.57-2.43 2.93.49 1.05-2.34 3.56-.44.99-1.46 4.37-2.02.39-.85-1.71-.55Z"
          data-id="KG"
          data-name="Kyrgyzstan"
        />
        <path
          id="KH"
          d="m795.37 418.57-1.26 1.97-2.29-1.12-2.6-.4-3.58.54-1.78 2.37.66 3.44 1.4 2.92 1.13 1.48 2.32.4 2.4-1.13 2.91-.2-1.22-1.72 4.67-2.18.34-3.4-.65-1.91-2.45-1.06Z"
          data-id="KH"
          data-name="Cambodia"
        />
        <path
          id="KR"
          d="m851.84 349.2-2.06.58 1.23 3.58-.2 4.38 2.5-.29 2.21-1.4 2.51-.65 1.05-1.86-.02-3.96-.69-2.26-2.4-4.15-3.53 1.26-1.08 1.59-1.42.2 1.9 2.98Z"
          data-id="KR"
          data-name="Republic of Korea"
        />
        <path
          d="m556.18 327.79-.51.84.59 1.01.66.39.19 1.35.35.03.12-.76 1.64-.58.62-.15-.09-.28.64-1.36-3.54-.76-.67.27Z"
          data-id={-99}
          data-name="Kosovo"
        />
        <path
          id="KW"
          d="m629.16 375 2.47.31.69 1.51 1.96-.08-.9-2.39.26-.73-.58-1.4-1.87-.27-2.03 3.06Z"
          data-id="KW"
          data-name="Kuwait"
        />
        <path
          id="LA"
          d="m798.33 416.76-.7-2.03-6.15-8.02-3.32-1.75 2.56-1.83-1.07-2.58-3.42-.02-1.24-2.7-1.62-2.37-1.44.44.42 3.41-1.48-.08-.25-.7-2.36 1.94-.59 1.09 1.2.91.16 1.77 1.87.14-.61 5.7 2.92-1.74 5.11-.38 2.11 2.36.17 2.87 2.25 2.51-.12 2.43-.9 1.3 2.28 1.11 1.26-1.97 2.45 1.06.5-2.87Z"
          data-id="LA"
          data-name="Lao PDR"
        />
        <path
          id="LB"
          d="m600.03 359.63 1.51-1.26-.45-1.31-1.25-.18-.05.12-1.38 2.37-.99 2.7.93.01.26-.58.74-.04.68-1.83Z"
          data-id="LB"
          data-name="Lebanon"
        />
        <path
          id="LR"
          d="m475.8 437.97-.56 1.13-3.02-3.14-.6.07-1.28 1.3-1.26 1.52-.14.82-.67.9 1.87 1.8 2.37 1.52 2.52 2.12 2.85 1.32.73-.02.4-3.74-2.54-4.71.12-.82-.78-.07Z"
          data-id="LR"
          data-name="Liberia"
        />
        <path
          id="LY"
          d="m569.12 366-4.67-.96-.95-1.47-3.75-.68-1.91.45-2.87 3.13.65 2.5-2.68 2.31-2.96-1.6-6.4-1.98-1.3-2.9-7.16-1.74-3.26-1.14-.15 2.54-4.11 3.24.05 2.7-1.35.75.9 2.82-.34 4.06.09 5.1-1.1 1.28 2.73 5.26 1.3-.56 2.18 1.42 1.22 1.9 4.39 1.3 1.56 1.65 1.96-1.12 2.8-1.65 11.06 5.75 11.06 5.67.04-1.24h3.19v-28.22l-.83-2.58.28-3.36 1-1.56-.67-1.08Z"
          data-id="LY"
          data-name="Libya"
        />
        <path
          id="LK"
          d="m725.26 442.2 1.16-.79.42-2.91-4.55-6.46-1.26 4.56.5 4.02 1.31 2.22 2.42-.64Z"
          data-id="LK"
          data-name="Sri Lanka"
        />
        <path
          id="LS"
          d="m577.95 548.47 3.38-4.12-2.17-1.94-4.28 3.9 2.08 2.48 1-.32Z"
          data-id="LS"
          data-name="Lesotho"
        />
        <path
          id="LT"
          d="m570.82 270.61-1.87-1.36-2.72.5-4.66-.32-3.17 1.53.59 4.12 2.9.85 1.23.77-.3 1.31.22 1.22 1.43.51.66 1.46 2.68.03 3.01-1.78.65-2.7 2.27-1.55-.26-2.19-2.66-2.4Z"
          data-id="LT"
          data-name="Lithuania"
        />
        <path
          id="LU"
          d="m517.31 299.24-.55-.97-.72.16-.3 2.41.62.37.8-.09.15-1.88Z"
          data-id="LU"
          data-name="Luxembourg"
        />
        <path
          id="LV"
          d="m573.4 263.64-2.4-1.92-1.2-.64-2.37.92-.53 3.95-2.23.1-2.2-3.84-2.61 1.77-1.37 3.2-.1 3.78 3.18-1.53 4.66.32 2.72-.5 1.87 1.36 2.66 2.4 1.69-.83 2.98-1.91-.9-2.96-.23-2.47-1.34-1.19h-2.28Z"
          data-id="LV"
          data-name="Latvia"
        />
        <path
          id="MA"
          d="m492.78 355.08-2.88-.75-2.63.23-1.68-1.44-2.04-.02-2.72 5.58-4.84 2.9-1.79 2.23-1.42 4.53.7 4-5.9 5.67-2.58.35-3.2 4.43-1.85 1.13-1.07 3.54-3.2 4.2-2.76 5.53-.13 1.39 6.3-.24 1.47-2.42.91-4.16 3.86-3.28 1.3-3.87 1.77-2.64 7.2-.74-.06-1.67h.43l-.03-3.73 4.48-2.35 5.04-1.35 1.06-1.6 3.24-1.28.12-2.4 2.86-1.5 3.63-.55-2.39-9.69-1.2-.03Z"
          data-id="MA"
          data-name="Morocco"
        />
        <path
          id="MD"
          d="m579 317.01 1.25-2.64 2.29-.36.41-1.3-2.38-3.41.2-1.4-4.44-2.57-1.84.41-.66.62.84.4 3.34 5.4.1 1.76-.3 1.71.5 1.81.7-.43Z"
          data-id="MD"
          data-name="Moldova"
        />
        <path
          id="MG"
          d="m638.83 497.38-2.39-4.31-.97 2.98-3.16 4.3-3.86 3.4-5.18 1.26-1.34 3.46 1.4 5.92-.26 1.88-2.6 3.75-.5 2.15 2.17 8.87 3.8 1.88 4.68-2.02 6.49-20.85 1.18-7.35.94 1.69-.4-7.01Z"
          data-id="MG"
          data-name="Madagascar"
        />
        <path
          id="MX"
          d="m176.27 366.85 3.34 6.7 3.76 3.15-1.13 2.59.3 1.87 6 3.5.32 3.92 5.24 3.97.73 1.83-.4-4.36-1.33-.1-2.67-7.27-3.17-3.48-2.3-4.04-2.06-2.2-1.68-5.29.45-1.32 4.51 2.04.94 3.7 4.53 6.6 1.49.26.69 2.18 3.05 2.24-.42 1.9 2.89 2.01 1.35 1.9 2.79 2.38 4.56 7.05-.37 2.64-.92.3 2.05 3.29 2.98 1.66 1.15 1.34 2.84.92 16.42 6.73 3.63-1.37 5.24 1.48 3.14 3.1v-2.05l1.33-2.35h3.56l-1.5-3.44v-1.64h2.6l2.56.03-.02-.43 1.83-1.55.53-.04.58-.05.7.75 2.75-7.62.1-1.43-4.8-.49-4.82 1.47-1.36 5.07-1.77 1.2-8.37 2.14-1.14-1.22-2.95-.78-3.57-5.33-1.63-6.86.2-4.05 1.56-4.9-1.08.1-4.13-1.64-1.39-3.64-3.98-5.8-1.96-1.28-2.27.06-1.74 2.52-4.43-3.67-.92-1.68-4.08-3.6h-4.8v1.34l-7.72.02-10.52-3.89.26-.64-6.67.6 1.12 2.95Z"
          data-id="MX"
          data-name="Mexico"
        />
        <path
          id="MK"
          d="m562.07 329.64-1.28.07-.95.21-.62.15-1.64.58-.12.76-.35-.03-.36 1.26.4 1.59 1.15.9 1.81-.33 1.06-.8 1.5.07.46-.65.53-.12-.2-2.46-1.39-1.2Z"
          data-id="MK"
          data-name="Macedonia"
        />
        <path
          id="ML"
          d="m508.76 405.57-.03-1.87-3.67-2.71-9.36-6.52-9.35-6.61-4.25.05 2.68 25.61-.14 2.38-11.13.04-6.33 1.98-.94.52.13 1.78.55 1.63 1.04.8.23 1.1-.12.9.16 1.03 3.58.66 4.96 1.28.11 2.53.85.82.36-.26 2.91.45 1.79-1.09 1.08.85 1.14-.42-.18-1.63.69-2.16 2.2-2.35 1.17-2.65 1.34.39 4.22-3.5 4.81-1.04 1.78-.02 1.78-.1 1.02-1.03 6.25-.7.24-1.78 1.51-1.93v-6.72l-3.08.29Z"
          data-id="ML"
          data-name="Mali"
        />
        <path
          id="MM"
          d="m780.54 397.3-2.04.87-3.26-1.67.81-2.5-1.76-.58-.66-2.79-2.92.5.33-3.6 2.62-2.57.03-4.94-2.13-2.6-1.62.24.2 1.19-.74 2.5-1.98-.57-3.6 2.15.1 1.77-2.92 6.58-2.16-.7-.45 5.44-1.36.7-.06 2.15-.97-.45.18 2.39 1.97 2.41 3.46 4.82.58 2.72-.96 3.6 3.28.93 4.97-3.51 1.2 2.4 1.4 7.05 1.13 1.48-.22 3.1.93 1.67-.85 2.17.27 2.09 2.86-5.54-1.08-2.59-.27-2.91-1.85-2.28 1.3-4.47-4.23-6.59 1.17-.53 1.27-3.18 1.95-.13 1.62-1.28 1.59-.68.6-1.1 2.35-1.93-.08-1.23Z"
          data-id="MM"
          data-name="Myanmar"
        />
        <path
          id="ME"
          d="m556.41 327.46-1.06-.78-.9-.41-.41-.53-.74-.66-.52.35-.9.89-.4 2.08-.3.64 1.19.75.78 1.22.58.29-.19-1.19 1.2-1.85.18.7.75-.33.51-.84.23-.33Z"
          data-id="ME"
          data-name="Montenegro"
        />
        <path
          id="MN"
          d="m779.82 292.17-2.52-.52-3.1-1.86-2.88 4.62 1.12 2.58-2.7 3-4-1.07-2.77-.16-1.85-2.02-2.9-.07-2.4-1.34-4.23 2.05-5.29 3.71-2.92.74.72 2.95 2.34 2.2 3.95 1.56 1.92 3.3-1.07 4.69 1 1.71 7.03 1.22 3.35 2.43 1.71.43 1.27 3.55 1.62 2.25 3.06-.09 5.73.85 3.68-.53 2.74.56 4.1 2.28h3.36l1.23 1.15 3.23-2 4.48-1.3 4.16-.14 3.24-1.33 3.93-3.33-1.34-2.75 1.46-2.52 4.41 1.15 2.76-2.09 4.23-1.53 2.04-2.64 1.95-1.15 4.03-.54 2.18.46.3-1.44-2.5-2.87-2.23-1.32-2.13 1.53-2.74-.65-1.57.53-.71-1.7 1.96-4.19 1.35-3.22-3.31.36-3.12-1.91-4.06 3.03-3.65.7-2.55 1.06-6.07-.65-1.68-2.18-2.72-2.08-2.78-.57-3.5.57-2.62.8-3.94-1.83-.53-3.29-3.26-1.14Z"
          data-id="MN"
          data-name="Mongolia"
        />
        <path
          id="MZ"
          d="m611.82 488.2-2.2 1.63-3.04 1.1-1.67-.05-.98.85-1.93.07-.73.36-3.33-.8-1.05.12-.67 2.67.43 3.26 2.33 2.99.23 3.7-2.04 2.6-1.81-1.78.37-3.37-2.01-1.61-1.6-1.37-8.42 2.36.27 2.04.17 1.08 2.32-.06 4.64 2.46v3.68l-.65 4.22.44.87-1.46 4.14-2.92 3.4 1.33 4.23.72 2.16-.5 3.4.24 1.11.41 1.39.24 1.37 2.1.02.24-1.63-.94-1.5 1.21-1.14 5.62-2.69 1.16-1.08.3-6.13-2.4-4.74.24-2.11 4.15-3.3 3.13-3.13 5.66-2.52 1.77-1.79 1.9-4.05-.49-1.4-.33-9.77-.45-1.26Z"
          data-id="MZ"
          data-name="Mozambique"
        />
        <path
          id="MR"
          d="M475.91 380.37v4.7l-9.1-.16.08 7.81-2.6.27-.67 1.55.52 4.32-10.86-.02-.6 1 1.46 1.27.71 1.41.37 5.82-1.12 4.17.24 1.56 5.23-1.34 3.17 1.62 1.67 2.12 1.83 1.97.94-.52 6.33-1.98 11.13-.04.14-2.38-2.68-25.61 4.25-.05-10.44-7.49Z"
          data-id="MR"
          data-name="Mauritania"
        />
        <path
          id="MW"
          d="m594.13 486.43-.55-.77-2.72-.52 1.3 1.25-.32 5.45.53 2.35-1.71 3.64 1.46.74 1.6 1.37 2.01 1.61-.37 3.37 1.8 1.79 2.05-2.62-.23-3.7-2.33-2.98.05.38-.44 1.6-1.87-5.84.8-1.58-.17-3.4-.98-1.83.09-.3Z"
          data-id="MW"
          data-name="Malawi"
        />
        <path
          id="MY"
          d="m778.2 442.64-.3 2.03 1.38 3.82 1.93 3.28 5.9 4.25 1.97-.18-1.04-3.4-.98-.76-.33-5.74-2.8-3.54-.64-.26-2.74 1.47-.22-1.43-2.74-.72.6 1.18Zm42 1.65-.29 3.15-1.9.86-1.27-1.44-1.36 1.76-1.99 2.2-4.5 1.12-.57 2.35-2.14.52-2.03-.95.46 1.85 1.9 1.57 3.56-.36 1.61-1.4 3.96.53 2.26-.6 1.42-3.85 1.07-.97.96-3.16 5.6.47 2.04-.95-.5-1.36 1.86-.13.2-1.1-4.14-1.61-.13-1.21-2.54-1.4-1.4 2.17-2.14 1.94Z"
          data-id="MY"
          data-name="Malaysia"
        />
        <path
          id="NA"
          d="m559.29 509.99-6.72-.41-1.92-1.4-11.24.13-3.87-1.2-3 1.05.17 2.23 2.26 2.86 2.06 5.4 2.87 5.32.06 3.61 2.23 9.95 1.08 2.28 2.06 2.38 1.33-1.56 1.56 2.21 4.48.6 2.48-1.62v-20.27l2.73-.1.09-10.52 6.34-1.12 1.06 1.2 2.6-1.15 1.57-.65-.02-.25-1.1-.65-1.8-.17-2.26.66-5.1 1.19Z"
          data-id="NA"
          data-name="Namibia"
        />
        <path
          id="NC"
          d="m963.5 522.48-7.37-6.07-.81.96 1.83 2.1 5.3 3.73 1.05-.72Z"
          data-id="NC"
          data-name="New Caledonia"
        />
        <path
          id="NE"
          d="m533.28 392.43-9.5 5.72-8.03 5.82-3.91 1.31V412l-1.51 1.93-.24 1.78-6.25.7-1.02 1.02-1.78.11-.22 1.4 2.02 4.54 3.2.64-.06 1.95.93-.83 1-.01 2.1 1.63.2-2.53 1.9-3.4 2.99-.34 2.78 1.06 3.77.43 3.35 1.47 3.05-1.28 3.92-.15 6.85 2.47.51-.06.1-.91.77-.16.28-1.34-1.78-.07v-1.84l-1.15-1.06 1.2-3.78 3.54-2.72.15-3.78 1.06-5.95.6-1.27-1.15-1.02-.04-.94-1.04-.77-.68-4.66-1.96 1.12-1.56-1.65-4.39-1.3Z"
          data-id="NE"
          data-name="Niger"
        />
        <path
          id="NG"
          d="m538.82 424.59-6.85-2.47-3.92.15-3.05 1.28-3.35-1.47-3.77-.43-2.78-1.06-2.98.34-1.91 3.4-.2 2.53-.1.94.62 1.68-2.98 6.26-.08 6.3h2.44L512 442l1.96 1.84 2.4 3.75 4.34-.41 2.88-1 2.03-4.67 5.06-.55 1.9-.95 1.32-3.7 1.48-1.16 2.27-5.85 2.34-2.19.45-1.45-1.1-1.13-.51.06Z"
          data-id="NG"
          data-name="Nigeria"
        />
        <path
          id="NI"
          d="m257.62 423.3-.77.01 3.17 3.14 1.3 1.14.96.89 5.04 1.02.66-.6-.42-.46.93-3.73-.13-3.27.8-3.81.23-.28-3.6 1.08-3.76 2.24-2.64.24.06 1.4-1.62.8-.21.2Z"
          data-id="NI"
          data-name="Nicaragua"
        />
        <path
          id="NL"
          d="m516.85 283.08-3.8 1.94-2.43 6.69-1.43 1.22 2.03.35 2.58-.93 1.75 1.94 1.53 1.03-.47-4.65h1.67l1.39-5.89-.52-1.57-2.3-.13Z"
          data-id="NL"
          data-name="Netherlands"
          className="visited"
        />
        <path
          id="NO"
          d="m530.58 256.39 1.23-3.12 2.3-3.78.92-6.66-1.77-2.95-.17-7.97 1.8-5.85 2.75.1.97-2.52-1.01-2.21 4.3-9.4 4.6-12.99 2.67.02.74-4.17 5.22 1.21.41-5.03 1.72-.32 1.66-2.07 3.08 4.11 3.63-.38 2.97 1.85 2.65-3.4 1.36-5.8 4.3-2.74 3.56 3.22-1.17 5.53 2.24-.71 4.72-3.16-3.04-5.06 3.57-2.2-8.67-6.19-4.98 1.7-5.06-.37-4.22 6.93-4.57-.44-6.08 3.56-7.63 9.8-4.64 5.6-6.66 13.64-5.08 9.2-5.48 6.53-7.32 5.14-2.55 3.83.87 13.14 1 5.8 3.83 2.7 3.7-1.23 5.47-6.21 1.86 3.32Zm38-153.02-4.01-3-1.1-5.12-5.75 2.75 1.68 4.3-1.92 3.39 4.9 2.99 6.2-5.3Zm-17.96-26.4-3.5-5.5-4.07.56L542 77.4l-3.95.22-1.52-5.5-7.56 5.62 2.15 11.66 5.4 11.7 4.17 3.82-2.52 4.58 5.96 7.56 3.35-.47 1.32-10.4 2.43-2.46 1.54-9.98 6.98-5.6-9.13-11.17Zm19.96-11.33-7.01-4.2-2.8 5.03-4.04-4.03-8.56 4.67 3.03 7.4 3.98.27.5 4.28 8.18 2.53 8.04-1.78 4.11-8.43-5.43-5.74Z"
          data-id="NO"
          data-name="Norway"
        />
        <path
          id="NP"
          d="m741.17 378.56-3.14-.72-4.4-2.01-.94-1.52-6.58-3.53-1.15.77-1.76 1.45-1.08 2.97 8.92 4.5 3.8.4 1.6 1.59 5.48 1.01 2.31-.05-.04-3.2.21-1.35-3.23-.31Z"
          data-id="NP"
          data-name="Nepal"
        />
        <path
          id="NZ"
          d="m979.87 584-.62-1.55-1.94 1.7-2.7 5.78-1.66 1.96-6.16 4.18-3.49 3.85-1.49 2.93.47 1.47 3.01.28 1.8 1.33 2.55.09 3.56-2.94 2.32-6.55 2.37-1.45 2.14-.05-1.02-1.84 4.27-6.04-.8-3.11-1.98 1.49-.63-1.52Zm4.41-16.89-.78-3.04-2.16-.88-1.5-1.88-1.04.27 5.72 9.77-.34 5-2 1.24-.08 1.3 2.98 1.44.91 2-1.6 3.01 1.63 1.5 2.15-1.47 2.83-5.15.48-2.63 2.12.07 1.51-5.21-1.4-.4-1.59 1.33-4.1-1.42-.42-2.63-1.25-.95-.06 2.37-2-3.64Z"
          data-id="NZ"
          data-name="New Zealand"
        />
        <path
          id="OM"
          d="m656.42 388-1.42.02-1.8 5.5-.08 1.2 1.27 2.13-1.85 5.94-8.32 2.95 2.17 4.81.9 2.03 1.29-.16 11.7-6.88-.34-1.97 2.28-2.04 3.66-6.28-3-3.1-5.22-2.06-1.24-2.08Zm-.9-3.47.88.5.26-1.28-.34-.27-.8 1.05Z"
          data-id="OM"
          data-name="Oman"
        />
        <path
          id="PK"
          d="m711.32 352.63-.82-2.65-2.05-1.62-1.62.4-7.57 1.76-1.62 1.5.98 3.15-1.38 1.42-.65 2.5-2.64-.1 1.1 2.2-1.77.84-1.18 1.99.15 1.97-6.6 1.94-1.54 1.83-.1 2.73-3.6 1.33-6.93.5-4.65-1.64 1.38 1.68 1.11 1.91 2.65 1.4.08 2.75 1.56 1.94-4 1.6-1.05 3.58 3.9-.43 4.51-.06 5.11-.58 2.15 2.34.82 2.18 2.04.77 1.84-2.03 6.1.01-.54-2.62-1.56-1.56-.32-2.38-1.81-1.4 3.05-3.27 3.22.24 2.9-3.3 1.74-3.24 2.7-3.23-.05-2.31 2.37-1.9-2.24-1.62-1.95-5.17 1.36-1.45 4.21.83 3.1-.5 2.67-2.85-4.56-1.38Z"
          data-id="PK"
          data-name="Pakistan"
        />
        <path
          id="PA"
          d="m284.42 434.51-5.12-1.87-.94.84-6.36.9.06-.6-1-1.01-.48 1.8-.41.33-.27 1.64.31.42 4.97.72.48 1.67 2.45-.92-1.32-1.52 3.77-2.54 1.38.78 1.13 3.38.93.8 1.25-1.15.52-.83-.3-2.06-1.05-.78Z"
          data-id="PA"
          data-name="Panama"
        />
        <path
          id="PE"
          d="m304.76 469.88-.82-.07 1.78-2.82-2.12-1.3-4.2.49-2.06-.35-1.63-2.9-4.02-3.35-.74.27.4 2.1-.87 1.8-3.03 2.91-3.33 1.1-2.23 4.3-1.56 1.14-3.44-1.49.4-2.84-2.22 1.76-.86 1.95 1.34 2.65-.9 1.25 4.14 2.95 2 3.34 5.36 10.82 2.35 3.73-.46.82 1.15 2.37 2.14 1.76 4.97 3.16 5.5 2.9.24 1.2 2.78 1.68 1.43-.75.74-1.5 1.75-3.12-1.2-2.43.15-2.03 1.08-1.44.79-5.4-2.4-4.55-1.56.48-1.27-.32.19-4.28-2.28 1.66-2.44-.08-1.05-1.5-1.84-.16.58-1.2-2.7-4.24.74-1.69 1.67-.8.64-3.78 5.81-2.85 2.5.13-1.39-1.48Z"
          data-id="PE"
          data-name="Peru"
        />
        <path
          id="PH"
          d="m850.5 436-.42-2.44-2.25-1.34.16 2.18-1.96.07-.45 1.25-2.1.77-.99-1.27-3.26 1.85-.63 3.17 4.23-2.6 1.76 1.31-.85 1.33.78 2.02 3.27 1.62.79-1.3-.89-2.06 1.3-1.42L850 442l.5-5.99Zm-6.64-5.24.27-2.69-2.05 2.73.44-1.9-1.53.16-1.57 3.3 1.7 1.94 2.74-3.54Zm-15.19 2.71 3.29-3.48-.5-2.3-1.45 2.8-5.03 5.65 3.69-2.67Zm9.37-7.27.33 4.1 1.76-.84 1.34-2.38-3.43-.88Zm10.04-.76-.76-1.06-2.67-.07 1.73 3.24-1.63-.22 1.39 3.84 2.72-2.57-.78-3.16Zm-11.03-2.58-.96-1.03-2.37-.1 2.6 3.58.73-2.45Zm-.57-15.67h-1.68l-.9 2.64-.29 4.53-1.11-.95 2.06 7.2 1.38.63 2.52-.42 1.77 1.7.71-1.04 3.19 2.9-.36-3.55-3.46-1.59-2.7.03-.62-2.29.44-2.32 1.63-.96.74-2.4-3.32-4.11Z"
          data-id="PH"
          data-name="Philippines"
        />
        <path
          id="PG"
          d="m932.33 478.39-3.79-4.7.6 2.13 3.2 2.57Zm-10.8-3.75.92-1.7-2.16-1.94.3 1.63-2.33 1.95-4.18.36-2.49-.41 3.63 2.45h1.47l3.38-2.1 1.45-.24Zm-30.47-8 .05 9.06.05 9.12 2.86.12 1.56.47 2.18-.97-.36-2.07 4.05-1.72 3.61 1.22 3.02 4 2.15 1.8 5.19.74.68.73 2.15-1.01-4.15-3.44-1.59.1-1.8-2.98-2.48-1.84-.6-1.86 2.54-.3-.67-1.48-4.62-1.72-3.88-4.47-5.13-1.59-4.8-1.91Zm33.67 5.28-6.1-5.56 1.23 1.49 4.87 4.07Z"
          data-id="PG"
          data-name="Papua New Guinea"
        />
        <path
          id="PL"
          d="m551.85 278.7-.2-1.16-2.77-.82-7.82 3.82-1.9 1.39.65 2.37-.77 1.23 1.47 5.62 1.14 2.84 1.31 1.42 2.08.38 1.33 2.1.42-1.13 1.9.5.26 1.35 2.06.26 1.28 2.11.16.26 1.14-.58 1.4 1.51 4.94-1.08 2.63 1.64.61.24-.72-1.9 2.52-3.59 1.68-1.73-1.4-3.86-.05-2-.86-2.1 1.67-.92-.76-3.6-.12-2.07-.66-1.46-1.43-.5-5.1.06-3.41-.54-2.68-.06Z"
          data-id="PL"
          data-name="Poland"
          className="visited"
        />
        <path
          id="PR"
          d="m318.08 408-4.18-.86-.23 1.68 4.41-.82Z"
          data-id="PR"
          data-name="Puerto Rico"
        />
        <path
          id="KP"
          d="m862.33 329.36-1.8-2.22-1.1 2.11-4.28 1.61.43 1.96-2.4-.13-1.31-1.16-1.9 2.62-3.06 1.97-2.26 2.33 1.3.97 1.8.98-1.86 4.55 2.7.6 1.35.66 1.42-.2 1.08-1.58 3.54-1.26-1.58-1.56-.69-2.54 3.05-1.57 2.98-2.52-.11-2.65 2.03-2.54 1.06.23-.4-.66Z"
          data-id="KP"
          data-name="Dem. Rep. Korea"
        />
        <path
          id="PT"
          d="m475.06 332.54.56 1.33-.72 5.2-1.1 1.31 1.68 4.01-.16 4.9 2.9.1 1.1-.9 1-6.81-1.12-2.15 1.2-.3.6-5.1 1.28-1-.78-1.85-3.72.34-.7-1.83-2.14 1.5.12 1.25Z"
          data-id="PT"
          data-name="Portugal"
          className="visited"
        />
        <path
          id="PY"
          d="m338.63 515.67-2.58-1.5-2.58-.05-4.83.86-1.4 4.2-1.1 3.57 5.1 4.91 2.27.47 3.39 2.25 2.86 1.2.4 1.35-2.74 4.7 5.92 1.33 2.19-.5 2.51-2.39.46-2.73.54-1.77-.62-4.03-1.04.49-4-5.77-1.14.58-2.93-.57.19-4.04-.82-1.65-.05-.91Z"
          data-id="PY"
          data-name="Paraguay"
        />
        <path
          id="PS"
          d="m597.58 363.92-.58 2.18-.13 1.67 1.3-.44.41-.96v-2l-1-.45Z"
          data-id="PS"
          data-name="Palestine"
        />
        <path
          id="QA"
          d="m643.13 387.12-.05-1.8-2.34.98.18 2.23.84.6.77-.21.6-1.8Z"
          data-id="QA"
          data-name="Qatar"
        />
        <path
          id="RO"
          d="m572.66 306.36-3.7 2-1.28-1-3.5-.48-1.2.88-1.69.87-1.3 2.77-1.69 2.74-2.22.76 1.5 1.57 2 2.19.22 1.61 2.53 1.4.5.68.8 1.58 7.29.52 4.64-1.87 3.65 1.8.77-4.67.84.36 1.35-.84-.07-1.02-1.25-.67-1.3.63-1.24-.73-.5-1.8.3-1.72-.1-1.77-3.34-5.39-.84-.4h-1.17Z"
          data-id="RO"
          data-name="Romania"
        />
        <path
          id="RU"
          d="m898.4 295.57-1.14-4.47.07-4.46-1.68-7.59-1.23.67 1.1 2.18-2.57 2.15-.24 6.24 1.62 4.38-.12 5.8-.64 3.21.32 4.5-.31 3.99.51 3.37 1.82-3.1 2.1 2.42.08-2.82-2.7-4.2 1.7-6.05 4.1 1.4-2.78-7.62ZM562.83 278l.3-1.31-1.23-.77-2.9-.85-3.83 1.57-.63 2.11 3.41.54 5.1-.07-.22-1.22ZM14.6 209.31l.24-4.39-7.27-7.26-6.8-5.8v28.31l1.58-2.8-1.25-3.17 3.32-1.62-.6 2.53 1.5 2.35 3.16-.87 2.81 1.09.62 2.86 3.69 1.9 2.11 2.24 2.6.2 1.11-1.34.07-6.4 4.55-.7 2.75-2.94-5.43-6.5-7.53-1.05.64 5.1-1.87-1.73Zm984.63-32.54v-5.88l-3.54 3.6.5 2.7 3.04-.42ZM4.4 176.25l2.85-2.04.24-1.18-4.01-2.49-2.7.35v5.88l3.62-.52Zm893.88-20.9-.33-2.55-3.94-3.77-3.47.92-2.63 3.88.48.51 5.69 1.07 4.2-.06Zm19.77-19.03-6.96-2.84-5.17-1.67-.66 3.55 5.15 4.22 4.44.94 3.2-4.2Zm-15.66-5.24-10.02-6-7.32-.51-3.66 2.15-1.5 7.68 5.5 6.94 4.6-2.5 10.22.3 2.18-8.06Zm-242.82 46.63-5.3-7.04-.57-7.44 4.35-9.05 4.14-9.71 8.61-10.07 8.47-5.28 9.83-5.68 1.86-3.67-1.93-4.77-5.4 1.58-4.74 4.45-9.24 2.2-9.15 7.33-6.2 5.79.74 4.82-6.64 8.93 2.55 1.21-5.5 8.19.1 5.03-2.84 1.94.4 4.78 5.03 2.32.73 3.78 9.07 1.1 1.63-.74Zm-73.31 9.49-4.72 3.16-2.24.71-.4 5.35 4.24 4.94-2.56 5.43 3.23 7.88-1.87 5.7 2.5 4.81-1.14 4.1 4.1 4.22-1.03 3.08-8.52 10.75 2.9 2.66-3.14 3.05.41.95-1.97 3.1.82 4.92-1.19 1.64 1.34 1.19.24 2.47.89 2.96 2.92 1.25.4 1.22 1.45-.59 2.7 1.17-.31 3.6 1.73 3.12 3.64 3.78-1.08 1.01-2.24-.16-.54.44.66 1.52.68 2.91 1.03.19.7-1.03 3.72-.21 1.77 2.55-.46 2.29 2.21.21.99 1.91-.06.86 3.52 1.53 2.13-.68 1.71 2.02 1.62-.04 4.1 1.4.02 1.25-1.12 2.21.61 2.31-.44 1.38-2.68.3-1.43 1.16-.09 1.82 2.5-.66.07.89-4.1 1.65 1.56 1.6-2.3 3.33-2.02.63 2.4 2.3 3.16 1.46 3.53 3.25.34-.45 2.35.66 4.08.61 3.78 1.82.48.7 1.68-.59 2.6.79.84 1.54 1.74.86.78.13 1.9 2.25 1.24.25.47-.94 1.66-1.5-3.03-4.42.27-2.57-2.52-3.66 2.76-4.06 2.69-.66 1.26-2.37-1.4-.65.27-2.09-1.76-2.73-2.06.11-2.36-2.81 1.6-3.2-.8-.86 2.2-4.73 2.86 2.5.35-3.16 5.72-4.8 4.33-.12 6.12 3.07 3.28 1.78 2.94-1.85 4.4-.1 3.55 2.28.8-1.3 3.9.2.7-2.1-4.5-3.07 2.66-2.2-.52-1.25 2.66-1.2-2-3.17 1.27-1.6 10.38-1.65 1.36-1.18 6.94-1.78 2.49-2.01 4.98 1.05.88 4.96 2.9-1.15 3.55 1.62-.23 2.56 2.67-.27 6.95-4.45-1.02 1.49 3.54 3.62 6.2 11.48 1.48-2.31 3.82 2.54 3.98-1.13 1.53.8 1.34 2.52 1.94.84 1.18 1.83 3.57-.57 1.47 2.6 1.09-.34 2.92-.74 5.3-3.7 4.21-2.06 2.41 1.34 2.9.07 1.85 2.02 2.77.16 4 1.08 2.7-3.01-1.12-2.58 2.87-4.62 3.1 1.86 2.53.52 3.26 1.14.53 3.3 3.94 1.82 2.62-.8 3.5-.57 2.78.57 2.72 2.08 1.68 2.18 6.07.65 2.55-1.05 3.65-.71 4.06-3.03 3.12 1.9 3.3-.35 3.34 1.62 3.9-2.72-.02-1.91 2.5-4.69 1.55-1.44-.04-2.5-1.52-1.08 2.29-2.3 3.45-.83 3.67-.13 4.15 1.38 2.44 1.7 3.72 9.2 1.03 4.25 4.82 1.37 3.29 3.01 1.12 3.91h4.22l2.4-1.63 4.58-1.23-1.45 3.74-1.08 1.5-.95 4.42-1.87 3.86-3.36-.7-2.38 1.4.73 3.33-.4 4.52-1.42.1.02 1.91.39.66.43-1.25 3.72-2.77 1.74 1.84 1.75-.05 3.7-2.23 9.29-11.38.93-2.8 4.18-5.96 1.25-6.8.23-5.22 2.17-4.48-.1-3.89-4-5.14-3.04-.31-1.77 2.36-2.7-1.05-1.36-2.97-4.37-.6 10.63-11.68 8.98-10.24 9.13-1.6 8.48.93 3.43-2.68 4.31.83-.2 3.91 4.3-.55 6.18-1.4-2.29-3.35 6.94-9.48 7.16-1.98 2.27 7.08 7.04-6.3 1.66-4.88 3.37-.5-2.22 8.28-5 4.53-4.76 5.67-4.96 6.72-4.3 1.17-.15 2.42-2.34 3.04-1.34 6.9 1.55 10.55 1.19 6.64 1.02 3.06 4-4.15.83-4.62 4.14-1.13.96-5.36 4.85-2.44-1.15-2.09 1.18-4.12 2.58-.18.37-7.4-3.16-1.16-.1-2.11 3.33-5.18.9-3.6 3.7.76 2.67-2.37 1.27 2.06 7.22-4.38 3.97 3.86 1.02-2.52 8.27-7.54 2.47-.68 7.75-4.47 5.17 1.3.71-1.58-.32-2.5-1.28-1.66-1.65-5.15-2.5-3.41 3.6.47 3.58-31.2-3.89-3.41-7.97-3.8-5.77.48-8.85-2.27-1.24 3.59 2.25 5.02-3.44 2.46-4.83-6.93-5.26.88-5.23-1.56-4.92.21-3.71 1.63-3.42-2.27.34-5.95-2.31-3.47-5.52-1.4-11.2 1.61-7.26-6.58-2.36-5.3-25.05-6-3.67 4.02 2 8.31-4.53-1.22-2.04 2.44-5.37-2.68-4.73 2.35-4.45-3.96-2.67 9.09-4.36-3.46-3.49-6.91 1.64-3.8-1.27-5.97-4.48-5.09-4.43.05-5.89-1.72-.16 7.4-11.59-1.42-.68-4.53-8.9-1.63-4.43 1.56-1.22 2.53-1.41-6.32-2.5 1.89-4.1-2.53-3.44-1.42 2.08-3.04 7.3-5.86 3.06-3.2.69-5.8-2.23-4.3-6.25-5.79-8.1-.16-2.54 2.91-.75-5.97-6.28-1.9 3.77-3.09-4.75-4.16-6.55 5.25-2.65 5.28-.76 5.18-5.1-.2-6.22 6.18-2.27-2.58-7.29 1.07-.92 3.12-7.33 1.5-5.39 5.45-3.18.3-3.21 6.94 2.25 5.33-6.01 1.3-6.67-.43-4.82 2 .27 10.17 2.47 7.55-5.13-5.13-5.75.48-4.64 3.55 1.26 6.3-2.97-1.57 1.1-8.58-1.46-5.14-1.38.22.64 6.55-4.97 5.98 3.6 6.96-2.2 8.2.66 4.37 3.03.64-1.3 5.03 1.63 4.22-2.4 3.45-.74 3.52-3.05 1.8-1.1 2.49-3.18-1.02 5.44-10.1 1.19-4.95-3.06-4.69.63-10.96-.9-5.88-1.72-2.75 2.63-7.2-.58-5.14-7.34-2.49-2.07 1.86-1.82 8.34-5.11 7.9.08 2.71 1.48 6.43-.91 3.79 3.34.77.08 1.66 2.82 4.07-1.85 3.94-10.05-8.71-3.84-2.47-8.2-2.42-1.44 2.64 2.9 4.53-3.14 5.04-3.16-4.58-4.12 3.17-5.2.2-1.99 2.56-3.44-.77 2.74-4.6-2.1-.38-9.67 6.48-5.8 3.5-.68 4.56-4.28 1.52-2.18-2.41-.02-4 3.5-.9-1.58-4.14-7.75-2.42 2.03 4.65-1.35 4.36 2.3 4.24-1.6 4.77-2.6-2.41-2.56-.4-6.46 6.68 1.87 4.83-2.34 1.57-6.7-4.06-1.77 2.49 1.67 2.77-.36 3.08-5.73-3.6-.36-9.8-4.52-5.05 2.03-.9 12.38 5.27 4.53-1.83 3.08-3.66-.18-4.74-2.13-3.48-10.48-8.56-7.6-1.85-4.55-4.82-2.86 2.79Zm205.17-89.91.82-5.66-7.03-8.26-2.09-.97-2.27 1.68-5.07 18.4 15.64-5.2Zm-149.6-34 1.07-2.59-4.12-3.8-2.61 2.87-1.6 4.08-.56-4.6-4.21.2-5.42 3.13 6.17.51-1.58 5.2 3 3.83 3.25-2.66.39-2.7 6.22-3.46Zm135.35 25.95.69-13.48-6.4-15.87-5.38-8.93-6 4.07-7.2 11.7 3.78 3.24 2.13 11.22 4.6 5.67 7.73 4.16 6.05-1.78Z"
          data-id="RU"
          data-name="Russian Federation"
        />
        <path
          id="RW"
          d="m582.7 463.43-.66-.28-.8.77-.1 1.65-.38.21-.26 1.52 1.68.22.85-1.58 1.48.18.8-.35.16-1.63-1.1-1.57-1.66.86Z"
          data-id="RW"
          data-name="Rwanda"
        />
        <path
          id="EH"
          d="m475.54 379.56.07 1.67-7.2.74-1.78 2.64-1.3 3.87-3.86 3.28-.91 4.16-1.47 2.42-6.3.24-.12 1.25.61-.99 10.86.02-.52-4.32.67-1.55 2.6-.27-.09-7.81 9.1.16.01-4.7.06-.6v-.21h-.43Z"
          data-id="EH"
          data-name="Western Sahara"
        />
        <path
          id="SA"
          d="m624 374.76-7.82-6.46-4.13-2.28-3.34-.88-.53.5-5.56 1.63 2.77 3.23-1.37 1.62-2.12.45-1.86 2.13-3.09-.51-.34 1.27-.56 2.83 1.38-.01 3.1 4.66 3.43 7.02 2.8 1.81 1.59 3.34.2 3.85 1.84 2.83 3.15 2.52 4.75 7.91.36 1.24 1.67-3.58 1.89.5 9.44.85 1.99-3.06 2.58-1.31 8-1.12 8.32-2.95 1.85-5.94-1.27-2.12-.56.63-8.34-1.51-1.06-3.07-.1-.7-.53-1.16-.77.21-.84-.6-.41-.75-1.52-2.9.1-2.31-3.72-3.12-1.09-2.71-1.96.08-.7-1.5-2.46-.31-5.16-.25Z"
          data-id="SA"
          data-name="Saudi Arabia"
        />
        <path
          id="SD"
          d="m602.21 411.7.87-.9 2.05-.47 1.4-1.66-1.52-1.08-1.05-.72-1.43-6.55.61-.54-.9-2.93h-32.9v5.94h-3.2l-.03 1.24.14 11.55-2.4-.2-1.41 4.56-.92.87-.68 3.42.98-.17 1.63 3.58-.04.69.32 1.2 1.6 1.77-.27 3.19.97.8.22.14.85-.3.95-.54 1.48-3.81 2-.39 2.67 2.66 1-.48 5.14.67 2.86-2.51 2.33 1.64 1.43-.29 2.9-3.58-.9-2.53 3.14-.58v4.13l1.71 3.48.39.06v-.34l.81-2.95 2.78-4.1 1.68-1.41 1.12-2.8.45-2.46-.3-1.15 1.2-4.23.27-1.92Z"
          data-id="SD"
          data-name="Sudan"
        />
        <path
          id="SS"
          d="m566.25 435.43 1.89 1.1 1.54 2.03 3.72 4.34 2.08 1.1.44.89 1.68 2.3 3.27.05 1.55-.59.66 1.19 2.44 1.85 1.14-.76 1.76.62 2.24-.65h1.95l1.7-1.27 1.7-1.66 1.89-1.84-1.64-3.03-3.16-3.13-1.7-.2.94-1.6 1.89-.92-.03-2.2-.39-.05-1.71-3.48v-4.13l-3.14.58.9 2.53-2.9 3.58-1.43.3-2.33-1.65-2.86 2.51-5.14-.67-1 .48-2.67-2.66-2 .39-1.48 3.81-.95.53-.85.3Z"
          data-id="SS"
          data-name="South Sudan"
        />
        <path
          id="SN"
          d="m464.41 416.47-1.67-2.12-3.17-1.62-5.23 1.34-.66 1.48-1.34 2.02-1.22.55 1.38 1.02 1.14 2.22 4.53-.8 3.43 1.06-2.4.59-1.2-.6-2.19 1.08-2.52-.06.46 2.18 1.46-.47.92.1.75-.33 5.12.12 1.34.03 2 .7 2.33-.16.4-.16.12-.88-.23-1.1-1.04-.8-.55-1.64-.13-1.78-1.83-1.97Z"
          data-id="SN"
          data-name="Senegal"
        />
        <path
          id="SB"
          d="m949.63 488.66-2.21-.78 1.05 1.73 1.16-.95Zm-3.5-1.72-3.2-1.77-.17 1.12 3.36.65Zm2.29-.76-2.11-3.6-.37 1.68 2.06 2.44.42-.52Zm-5-3.55-4.21-2.85-.41.29 4.73 3.12-.12-.56Zm-6.49-2.77-2.76-2.09-.14.46 2.9 1.63Z"
          data-id="SB"
          data-name="Solomon Islands"
        />
        <path
          id="SL"
          d="m470.86 436.19-1.7-4.77h-2.21l-3.69 3.21.34 2.08.49 1.02 1.44 1.5 2 1.12.74.21.67-.9.14-.8 1.26-1.53 1.29-1.3-.77.16Z"
          data-id="SL"
          data-name="Sierra Leone"
        />
        <path
          id="SV"
          d="m252.18 419-.65.17-1.32 1.37-.09.42.79.61 1.54.18 3.75.88.3-.67-.75-1.65-1.21.34-1.54-1.42-.82-.24Z"
          data-id="SV"
          data-name="El Salvador"
        />
        <path
          d="m619.66 427.42-1.02 1.51-.6 1 1.02 1.56 1.02 1.35 1.06 1 9.07 3.33 2.33-.01 1.94-2.34 1.25-1.73.01-5.48.02-.04-6.39 1.68-7.01 1.04-1.8-2.35-.9-.52Z"
          data-id={-99}
          data-name="Somaliland"
        />
        <path
          id="SO"
          d="m615.96 463.44.64-1.46 3.04-3.36 9.5-7.12 5.64-6.9 2.38-4.1 4.41-10.76.19-3.91-5.12 1.68-.88.06-.02.04-.01 5.48-1.25 1.73-1.94 2.34-7.83 8.38-3.62.12-2.47 1.96-1.78.05-.76.88-2.42 3.15.03 10.1 1.65 2.3.62-.66Z"
          data-id="SO"
          data-name="Somalia"
        />
        <path
          id="RS"
          d="m556.08 314.9-1.73-.18-2.13 1.05.68 1.54.88 1.13-1.07 1.48 1-.02-.69 1.72 1.34 1.49-.4 1.8-.66.17.74.66.4.53.91.4 1.06.8-.23.32.67-.27 3.54.76-.64 1.36.1.28.94-.21 1.28-.07.46-.53 1.22-2.83-1.35-1.65-.25-1.4.69-.88-.5-.68-2.54-1.4-.22-1.61-2-2.2-1.5-1.56Z"
          data-id="RS"
          data-name="Serbia"
        />
        <path
          id="SR"
          d="m341.5 442.83-.44 2.5-2.05 2.82 2.49 3.6 1.69 2.4 1.5.23.07-1.92 1.12.25 1.3-.29 1.6.6.7-1.18.25-1.27.48-1.2-1.09-1.64-.22-1.9 1.45-2.4-2.98-.75-2.25.2-.3.5-3.32-.55Z"
          data-id="SR"
          data-name="Suriname"
        />
        <path
          id="SK"
          d="m559.93 301.1-4.95 1.07-1.4-1.51-1.13.58-.16-.26h-.83l-2.8 2.95-1.23-.07-.4.93-.21.53.27 1.44 1.41 1.06 7.63-1.9.65-.99 3.88 1.02.6-.43.54-1.7.76-1.1-2.63-1.63Z"
          data-id="SK"
          data-name="Slovakia"
          className="visited"
        />
        <path
          id="SI"
          d="m545.4 312.03-.46-.05-.53.68-2.43.1-1.4.92-2.29-.31-.3 1.97.67 1.7-.62.36 4.47.19v-1.11l1.22-2.02 2.21-1.07-.54-1.36Z"
          data-id="SI"
          data-name="Slovenia"
        />
        <path
          id="SE"
          d="m557.26 190.75-1.72.32-.4 5.03-5.23-1.21-.74 4.17-2.66-.02-4.6 12.98-4.31 9.4 1 2.22-.96 2.53-2.75-.11-1.8 5.85.17 7.97 1.77 2.95-.92 6.66-2.3 3.78-1.23 3.12 2.11 7.43 2.33 5.76.88 4.67 3.2-.22 1.58-3.92 3.36.48 1.58-4.71 1.06-8.76 2.88-1.26 2.55-6.17-2.66-3.1-1.97-4.04 2.02-8.33 5.36-5.29 4.4-5.09-.42-3.97 2.68-4.65 4.78-1.92-.94-2.67-.07-11.01-4.33-5.1-3.7-3.77Z"
          data-id="SE"
          data-name="Sweden"
          className="visited"
        />
        <path
          id="SZ"
          d="m586.9 533.1-1.82 2.28 1.68 2.76 1.63-.34.56-1.38-.24-1.37-.4-1.39-1.4-.56Z"
          data-id="SZ"
          data-name="Swaziland"
        />
        <path
          id="SY"
          d="m613.73 357.64 1.05-4.1-.26-2.5 1.51-.85 1.43-2.16-3.16.54-1.5-.06-3.18 1.3-3.76-.64-3.06.96-.9-.67-1.64 3.43-.68 1.4.26 2.6 1.25.17.45 1.31-1.51 1.26-.68 1.83.04 1.35-.37.5.05.03 3.09 1.3 5.43-3.52 6.14-3.48Z"
          data-id="SY"
          data-name="Syria"
        />
        <path
          id="TD"
          d="M555.05 398.36 544 392.61l-2.8 1.65.68 4.66 1.04.77.04.94 1.16 1.02-.6 1.27-1.07 5.95-.15 3.78-3.54 2.72-1.2 3.78 1.16 1.06v1.84l1.77.07-.28 1.34 1.1 1.82.2 1.88-.11 1.88 1.51 2.56-3.6-.11-.6 1.33 4.11 5.2-.43.76 2.29-.2 5.16-1.1 2.62-2.08-.28-1 3.47-.07 2.6-1.3 2.01-3.08 1.4-1.14 1.76-.48.04-.69-1.63-3.58-.98.17.68-3.42.92-.87 1.42-4.56 2.39.2-.14-11.55-11.06-5.67Z"
          data-id="TD"
          data-name="Chad"
        />
        <path
          id="TG"
          d="m500.07 428.68-.2.88 1.15 1.45.95 5.28-.6 2.52 1.57 4.14 2.23-.6-.68-1.92.13-6.43-2.48-3.78.35-1.48-2.42-.06Z"
          data-id="TG"
          data-name="Togo"
        />
        <path
          id="TH"
          d="m792.73 418.13.12-2.43-2.25-2.51-.17-2.87-2.1-2.36-5.12.38-2.92 1.74.61-5.7-1.87-.14-.16-1.77-1.2-.91-1.59.68-1.62 1.28-1.95.13-1.27 3.18-1.17.53 4.24 6.59-1.31 4.47 1.85 2.28.27 2.91 1.08 2.6-2.86 5.53-.82 2.7.22 3.3.46-1.65 3.29 4.3 1.1 1.07 2.74.72.22 1.43 2.74-1.47-1.44-1.45-1.68-.33-1.55-1.6-1.62-4.98-1.8-.1-.2-2.03 2.4-6.62.22-3.13 2.44-.02-.4 2.24 2.37-.06 2.49 1.3-.66-3.43 1.78-2.37 3.58-.55 2.6.41.9-1.29Z"
          data-id="TH"
          data-name="Thailand"
        />
        <path
          id="TJ"
          d="m695.81 337.4.18-2.7-3.7.84-2.2 4.34-2.32-.17-.72 1.58 2.04.85.6 2.64-1.56 3.54.84.43 2.01-1.12.93.67.9-1.6 3.57-3.09 2.04 2.05-.26 2.94 1.1 1.13 3.93-2.63 1.9.26h2.87l-.42-2 .1-1.37-1.69-.8-.91.35-.7-3.3-5.25.55-3.42-1.17-3.01.28.26-2.08 3.02.6 1.02-1.11-1.15.09Z"
          data-id="TJ"
          data-name="Tajikistan"
        />
        <path
          id="TM"
          d="m684.56 345.42-3.68-1.51-7.89-5.91-1.36-3.77-.93-.67-3 .17-1.06-.75-.3-2.97-3.73-1.99-2.34 2.18-2.37 1.29.46 1.87-3.13.05-1.43.18-1.94-2.91-1.87-1.05-3.15.78-1.23 1.24.87 2.4.28-2.72 2.24-.95.8 2.13 2.01 2.22-2.44 1.17-2.61-.9-.61 3.07 1.84.21-.72 2.47 2.17 1.2-.4 3.71.51 2.48 2.44-.68 1.97-2 5.05-.23 3.06 1.78 2.22.38 3.17 3.07 2.06.13.25 2.88 2.83 1.3 2.09-.46.58-1.54 3.75-1.56.55-2.77 2.34-.68.43-1.24 1.31.94.84.1.07-2.14Z"
          data-id="TM"
          data-name="Turkmenistan"
        />
        <path
          id="TL"
          d="m849.25 484.79 3.91-2-3.85.1-2.39.64-.32.66.28.55.05.86 2.32-.81Z"
          data-id="TL"
          data-name="Timor-Leste"
        />
        <path
          id="TT"
          d="m331 431.24-2.07-1.83.06 1.11 2 .72Z"
          data-id="TT"
          data-name="Trinidad and Tobago"
        />
        <path
          id="TN"
          d="m530.8 361.4-.69-1.58-1.43-.05-.53-1.83 1.83-1.7.36-2.93-2.1-3.53.08-1.75-1.94-.42-3.02 1.4-.57 1.78.44 3.26-.65 2.8-1.71 1.87.24 2.52 4 4.09 1.19 5.82 1.35-.75-.05-2.7 4.1-3.24.16-2.54-1.05-.52Z"
          data-id="TN"
          data-name="Tunisia"
        />
        <path
          id="TR"
          d="m600.26 352.89 1.64-3.43.9.67 3.06-.96 3.76.64 3.19-1.3 1.5.06 3.15-.54 1.19-.54 3.22.45.98.88 1.33-.59-1.52-2.8.54-1.1-.86-4.08 1.9-1.02-1.1-1.06-2.06-.9.27-1.77-.47-1.3-2.68-1.8-2.95.17-3.27 1.92-2.4-.32-3.22.56-3.98-1.42-4.84-2.62-4.6.08-3.22 1.05-3.34 2.4-5.28-.48-1.17 2.78-4.27.15-3.08 3.46 1.76 1.7-1.35 2.77 2.03 1.95 1.64 3.46 3.03-.06 2.68 1.83 1.92-.4.64-1.44 2.99.12 2.24 1.85 4.21-.39 1.91-1.98 2.96 1.8 1.02 1.55Zm-22.61-22.08-2.39-.5-2.82 1.18 1.35.98-.86 2.3-.66.42-.04.76.87 1.7 3.5-3.1 3.3-.2.5-.91-2.42-1.2-.33-1.43Z"
          data-id="TR"
          data-name="Turkey"
        />
        <path
          id="TW"
          d="m836.08 394.48 2.15-6.7-1.27-.9-2.22 2.3-1.63 2.99.32 2.24 1.46 2.53 1.19-2.46Z"
          data-id="TW"
          data-name="Taiwan"
        />
        <path
          id="TZ"
          d="m584.37 462.57 1.1 1.57-.16 1.63-.8.35.16 1.1.6.63-1.74 2.93-1 1-.3.04-.13 1.2.97 2.69-.64 1.07 2.24 1.9.21 1.72 1.4 2.87 1.24.55 1.76.47 1.58.85 2.72.52.55.77.16-.55 1.46 1.5.23 2.97.92 1.08-.01.05 1.05-.12 3.33.8.73-.36 1.93-.07.98-.85 1.67.05 3.03-1.1 2.2-1.63-1.01-.62-2.12-4.53.79-3.88-1.86-1.75-.16-1.58 1.28-3.43-3.98-2.78-.2-1.61-10.05-5.65-2.28 2.49 1.1.95-5.54.08.6-3.61-3.04-.04-.97.33Z"
          data-id="TZ"
          data-name="Tanzania"
        />
        <path
          id="UG"
          d="M592.6 448.9h-1.94l-2.24.65-1.76-.62-1.14.76-.17 3.24 1.11.38-3.02 3.17-.58 1.29-.16 2.23-.64 1.05-.02 2.1.67.28 1.66-.86.97-.33 3.04.04-.14-1.08 1.27-1.62 4.37-.51.12.19 2.16-3.1 1.01-2.02-1.54-4.58-1.32-1.93-1.7 1.28Z"
          data-id="UG"
          data-name="Uganda"
        />
        <path
          id="UA"
          d="m589.2 289.73-1.04-.19-2.38.27-1.04 3.24-3.6-.22-.73-1.04-4.27.04-3.1-1.07-4.94-.25-1.52 1.2-1.33.18 1.4 3.86-1.68 1.73-2.52 3.58.72 1.91-.6-.24-.77 1.1-.55 1.69 1.54 1.13.2 1.11 1.2-.88 3.49.47 1.29 1.01 3.69-2h1.17l.66-.62 1.84-.4 4.44 2.56-.2 1.4 2.38 3.4-.41 1.3-2.3.37-1.24 2.64-.7.43 1.24.73 1.3-.63 1.26.67 2.15-2.93 1.03-2.21 2.57-.5.2 1.5 4.3 1.02.8.91-3.14 2.08 3.03 1.15-.61 1.84 1.54.79 3.77-2.26 3.03-.68.55-1.4-2.83.23-1.36-.95-.16-2.48 2.39-1.5 2.6-.22 1.84-1.3 2.21-.33.09-1.82 1.43-1.15 2.68-.3.44-1.39-.61-2.3 1.12-2.22-.03-1.26-4.09-1.4-1.62.05-1.71-2.02-2.13.68-3.52-1.53.06-.86-.99-1.9-2.2-.22.45-2.29-1.77-2.55-3.72.2-.7 1.04Z"
          data-id="UA"
          data-name="Ukraine"
        />
        <path
          id="UY"
          d="m340.18 547.4-.7 2.59-.74 3.34-.79 6.17 1.7 1.85 1.87-.1 2.57 1.44 3.55.32 3.13-1.88 1.2-2.1-.77-1.89 1.22-1.56-6.63-6.12-1.03.1-2.78-2.5-1.8.35Z"
          data-id="UY"
          data-name="Uruguay"
        />
        <path
          id="US"
          d="m68.6 405.5 2.04-1.26-3.13 1.32 1.1-.07Zm-1.48-4.61-.5-.81-.43 1.02.93-.21Zm93.13-94.36.44 3.38-.68 1.08-1.48-3.88-4.01-1.41 1.35 6.23.5 5.38-.68 7.07-1.08 3.59.89 2.87.1 3.18-.62 3.04 1.48 1.97.38 2.93 3.28 4.94 2.3 4.82 2.7 3.43 7.76 5.16 1.8 1.91.47 1.69 6.67-.61-.26.64 10.52 3.9 7.71-.03v-1.35h4.81l4.08 3.6.92 1.69 4.43 3.67 1.74-2.52 2.27-.06 1.96 1.27 3.98 5.81 1.39 3.64 4.13 1.64 1.08-.1-.63-4.68 2.15-2.9 2.75-1.37 2.53-2.35 8.5-.63 2.07 1.68 2 .1 2.06-2.48 2.76-1.57 2.47.36 3.13-.4 1.74.79 4.64.2 1.08.49 2.94 4.4-.57 2.1 3.18 6.27 2.86 2.42.82-.38.9-5.17-1.32-4.99-2.65-7.2.43-2.3 2.87-3.5 8.05-6.66 2.87-1 1.76-2.52-1.47-4.87-.79-6.15.53-1.54.33 2.96 1.42 1.34-.86 2.38 2.7-4.03-1.3-3.9 1.72 2 2.02-2.76.6-2.6 5.6-1.84-.83-.7-4.07.7 2.3-1.07 6.61-2.16-.91-1.98 1.96-5.12 2.93-1.14 5.81-3.22-.47-1.28-1.82-2.24v-5.48l-1.23-1.18-1.86.7-.92-1.08-2.11 3.08-.85 3.12-3.05 2.62-.28.97-9.32.03-4.1 3.43.3.54.16 1.5-2.08 1.25-4.46-.46-1.3.44.24 1.14.05.37-2.39 2.25-5.16 2.62-2 .49-3.1-.96.95-1.44.6-1.3 1.31-2.08-.64-3.79-3.44.31 1.53-1.54.03-3.56-2.05-1.54-2.36-.8-1.5 3.85-.25-1.31-2.52 4.15.78 4-.08 2.48-1.12 1.83-2.26.94-1.3-5.98 1.16-4.85 1.44-3.02-2.46 2.54-.37-.46 2.74-3.96 4.05-1.16 4.71.08-1.38-1.6-.74-.12-1.43-1.3-5.19 1.26-3.52-2.06.89-2.15-6.81 3.7-1.7-1.4-2.78.85 3.86-3.95 2.83-1.37-3.42-1.08-2.24.54-2.7-1.29-5.62-1.63-.5-2.33-.94 1.65H159.3l.94 3.44Zm-84.61-41.04 2.4-2.44-1.18-1.61-5.84 2.28.43 2.4 1.42 1.31 2.77-1.94Zm-34.87-14.84-.27-2.14-2.2-.5-2.73.95 3.5 2.55 1.7-.86Zm-17.06-22.8.49 2.9 2.45-.36 3.16 2.45 2.33-1.97-2.75-.83-2.24-1.64-1.73.64-1.71-1.19Zm114.25 49.1 1.54-2.33-.07-3.1-4.72-3.17-2.84-5.83-1.73-3.76-2.54-2.4-1.87-2.2-1.47-2.84-2.78 1.78-2.7 3.03-2.47-3.57-1.93-2.41-2.7-1.54-2.73-.17.03-62.47-3.02-1.12-4.2-2.44-3.7 1.32-2.13-1.05-5.33-.77-5.85-2.61-2.82.83-4.25-1.41.17-1.94-4.69-.5-1.23 1.63-2-3.83-4.2-1.81-4.27 4.56-2.55-.57-5.26 3.72-2.7.95-2.84 3.87-.66 3.88-3.5 3.55-4.92.25-1.55 3.98 3.81 2.37 2.66 3.13 1.98 3.6 3.4 2.7 2.26 4.3-5.85.26.37-3.45h-2.28l-6.18 3.37-3.9 2.84 3.5 3.87 1.17 2.63 4.06 1.55 3.93-.72 2.18 1.41.85-1.42 2.94-1.4 1.7-.08-2.05 2.5 1.55 1.14.52 2.9-2.11 1.93-2.02-.54-2.23 2.98-1.9-.98-2.25.45-1 3.12-2.25 3.34-1.07 3.37 2.13 2.46.01 3.22 4.24 3.96 3.6-1.06 1.8 1.96-.5 2 .23 3.2h1.7l2.78-2.14 1.03 2.67.75-1.92 1.81 2.71 1.5-1.94.9.92 3.2-1.62-1.41 3.15-.48 3.96-2.67 2.84-3.84 3.03-1.37 2.04-3.44.56-2.96 2.69-5.74 3.75.43.8 4.76-1.37 7.7-4.63 1.91.38 3.25-2.11.87-2.34 4.33-2.61.7-2.27 5.75-3.76 2.62-3.82-2.03-2.62 4-3.91 1.89-3.74 3.53-3.19.77 1.44-2.95 1.76-1.25 5.48.4 3.21 3.07-1.15 2.44-1.85 4.74-1.5-.57-3.9 3.08-1.2 3.3 2.42 5.45 2.56 3.84-.47 7.5 3.02 5.74 5.59 3.25 1.52 7.08.47 1.5 4.9 3.57 4.09.78 4.32 2.45 1.55 1.52 1.82Z"
          data-id="US"
          data-name="United States"
          className="visited"
        />
        <path
          id="UZ"
          d="m695.22 330.54-3.66 2.59-1.2 2.63-1.8-1.72-3.53-.11-.56-3.04-1.36-.03.21-3.77-3.32-2.79-8 .86-2.66-3.47-7.08-4.64-7.14 2.33.1 14.03 3.14-.05-.46-1.87 2.37-1.29 2.34-2.18 3.73 1.99.3 2.97 1.06.75 3-.17.93.67L673 338l7.89 5.91 3.68 1.51-.07 2.14 1.54.03 2.1.73 1.55-3.54-.6-2.64-2.03-.85.72-1.58 2.31.17 2.2-4.34 3.71-.85-.18 2.71 1.15-.1 2.1.36 3.56-2.62-3.29-1.94-1.97.92-2.05-1.4 2.33-2.4-.83-.37-1.59.69Z"
          data-id="UZ"
          data-name="Uzbekistan"
        />
        <path
          id="VE"
          d="m333.17 435.48-1.44.06-.44-2.25-2.1-1.38-2.22-.22-.95-1.33 2.35-.83-6.75.21-1.6 1.6-2.11-.36-1.6-1.26-5.45.27-1.9-2.52-1.95-.04-1-2-.58 2.24-3.46 1.15 1 3.12-.62 2.04-1.2.18-1.05-2.23.36-4.4 1.62-.33.08-.67-1.78.48-2.58 3.27-1.11 3.65 2.4 2.1 1.33 3.96 5.18.08 1.95 2.4 4.7-.46.98.48-1.34 4.43 1.45 3.3-1.41 1.38 1.74 1.58.85 2.77 1.53 1.47 2.69-1.03 3.53-2.28-.8-5.22-1.24-.72 4.78.8.8-.67 5.1-1.47 1.01-1.06-.36-.79-1.88-2.11.75-.77-.05-1.29 3.88-4.67-1.09-.66Z"
          data-id="VE"
          data-name="Venezuela"
        />
        <path
          id="VN"
          d="m783.37 395.46 1.62 2.36 1.24 2.7 3.42.03 1.07 2.58-2.56 1.83 3.32 1.75 6.15 8.02.7 2.03-.5 2.87.64 1.9-.34 3.41-4.67 2.18 1.22 1.72-2.91.2-2.4 1.14 2.06 1.6-.78 1.9 1 1.8 3.46-2.61 2.27-2.35 5.48-3.68.38-5-1.27-5.3-1.69-2.3-2.51-1.8-4.72-6.87.61-2.04 2.31-2.8 3.7-2.54-2.79-.78-1.32-1.21.44-1.73-2.53-.55-1.34-1.13-2.37 1.6-4.9.34-1.5.73Z"
          data-id="VN"
          data-name="Vietnam"
        />
        <path
          id="VU"
          d="m963.47 501.32-1.33-.88.06 2.2 1.72 1-.45-2.32Z"
          data-id="VU"
          data-name="Vanuatu"
        />
        <path
          id="YE"
          d="m644.22 405.74-8 1.12-2.58 1.31-2 3.06-9.43-.85-1.9-.5-1.66 3.58.12 1.26-.6 2 .8 1.19 1.63 6.18 4.18-.18.43-.72 9.8-3 2.48-2.01 7.2-2.56.6-2.26 2-.78-.9-2.03-2.17-4.81Z"
          data-id="YE"
          data-name="Yemen"
        />
        <path
          id="ZA"
          d="m585.03 522.45-.93.36-1.34-.5-1.13-.04-3.92 2.21-2.5 2.26-1.75 3.16-1.51.25-2.54 3.13-2.26-.15-2.5-1.23-1.35.7-3.38 3.8-1.98.31-.37-2.97-1.64-2.92-.75-.46v11.46l-2.48 1.62-4.48-.6-1.56-2.2-1.33 1.55 2 4.13 3.2 5.76.08 2.51-.9.6 1.39 4.6 1.2 1.5 3.37 1.18 1.71-1.27 5.23-1.85 2.83-.23 3 .64 4.83-1.24 2.9-1.3 7.19-6.83 2.35-3.96 3.6-3.69 1.05-4.03.7-2.27-2.11-.02-.56 1.38-1.63.34-1.68-2.76 1.82-2.28 1.4.56-.24-1.1.5-3.41-.72-2.16-1.33-4.24-1.48-.3Zm-7.08 26.02-.99.32-2.08-2.47 4.28-3.9 2.17 1.93-3.38 4.12Z"
          data-id="ZA"
          data-name="South Africa"
        />
        <path
          id="ZM"
          d="m584.65 482.48-4.95.68-.8 1.8.63 1.23-.84 6.18 3.45 1.1.23 3.06-2.12-.03-2.16-2.77-2.13-.4-.62-1.49-1.7.9-2.22-.4-.92-1.28-3.22-1.07-.96-.07.3.87-.01 4.75-5.78-.03-.12 9.11 1.87 2.37 1.8 1.81 2.28-.66 1.8.17 1.1.65.01.25.5.21 3.1.32 3.37-1.61 2.42-2.39 2.9-2.37 2.1-.4-.26-2.04 8.42-2.36-1.46-.74 1.71-3.64-.53-2.35.33-5.45-1.31-1.25-1.58-.85-1.76-.47-1.24-.55.22.46-.46.16-.6-.58-.95-.23.16-.6Z"
          data-id="ZM"
          data-name="Zambia"
        />
        <path
          id="ZW"
          d="m589.43 519.36 1.46-4.14-.44-.87.66-4.22v-3.68l-4.65-2.46-2.32.06-.17-1.08-2.1.4-2.91 2.37-2.42 2.39-3.37 1.61-3.1-.32 1.07 2.34 1.43 2.22 3.14 3.23 2 3.25 2.15.46 1.77 1.35 1.13.04 1.34.5.93-.36 1.48.3 2.92-3.39Z"
          data-id="ZW"
          data-name="Zimbabwe"
        />
        <path
          id="FR"
          d="m526.51 330.27-.47-3.23-2.34 2.84.64 2.51 1.26.75.91-2.87Zm-21.96-35.58-.84 3.58-6.45 3.35-2.62-1.84.88 4.8-4.66-1.07-3.6.91.28 3.04 4.24 1.59 2.05 2.07 2.86 4.23-.53 7.82-1.43 2.3 1.1 1.48 5.1 1.72 1.02-.82 3.12 1.7 3.21-.48.32-2.28 4.04-1.23 5.47 1.03 2.51-2.16.32-1.67-1.5-.49-.72-3.01.96-1.2-.81-1.49.11-1.12-.95-1.76-1.33.63.04-1.83 3.2-2.95.77-.7.35-2.95 1.4-2.88-4-.78-1.3-1.11-.8.09-.62-.37-2.43-1.96-1.42.34-3.23-3.8-1.69-1.62-2.42.9Z"
          data-id="FR"
          data-name="France"
          className="visited"
        />
      </g>
    </svg>
  </>
)

export default Map
