---
title: Labels descriptions
description: The standard labels used in our GitHub projects
---

In this part you will find a description of all the labels we use on issues.

## Labels

| Label       | Description                                                                                                                                                                                      |
| ----------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| Don't merge | While this label is present this pull request should not be merged                                                                                                                               |
| Duplicate   | This issue already exists                                                                                                                                                                        |
| Epic        | This issue is a [ZenHub epic](https://www.zenhub.com/blog/working-with-epics-in-github/), which is a GitHub issue that points to a list of other Issues. It is uses to support our Agile process |
| Master Epic | This is a master [ZenHub epic](https://www.zenhub.com/blog/working-with-epics-in-github/), or an Epic of Epics                                                                                   |

## Priority

| Label    | Description                                                        |
| -------- | ------------------------------------------------------------------ |
| Critical | Has to be fixed ASAP                                               |
| High     | This issue is causing a major regression, restricting functionally |
| Medium   | This is not a damaging issue but requires attention in due course  |
| Low      | Has been confirmed as a nice to have                               |

## Review

Each review label has 3 steps:

- **-1:** Not approved
- **Needed:** needs to get reviewed
- **+1:** Approved

| Label  | Description                     |
| ------ | ------------------------------- |
| Code   | Validation steps of your code   |
| Design | Validation steps of your design |
| QA     | Validation steps of QA          |
| UX     | Validation steps of UX          |

## Status

| Label       | Description                                                                                                                    |
| ----------- | ------------------------------------------------------------------------------------------------------------------------------ |
| Blocked ⛔  | Alerts managers that unblocking it requires their help. Any blocked issue should have a comment explaining what help you need. |
| Declined 🚫 | Not appropriate or relevant for this project                                                                                   |
| Released ✈️ | This issue/PR has been released to production                                                                                  |

## Type

| Label               | Description                                                                                                                                                                                                          |
| ------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| Question ❓         | To ask a question about something on the project                                                                                                                                                                     |
| Good first issue 🔰 | Lets potential contributors know that [the issue would be a good one to start with](https://help.github.com/articles/helping-new-contributors-find-your-project-with-labels/). For example, a typo or grammar error. |
| Help wanted 🏮      | Alerts contributors that the assigned person (or if there is none, the team as a whole) would prefer outside help in fixing the problem.                                                                             |
| Performance ⚡️     | This issue is related to our Project Fuse, which aims to speed up the site for end users                                                                                                                             |
| Breaking change 💣  | This change will break users of earlier versions of the code                                                                                                                                                         |
| Bug 🐛              | This is a bug that needs fixing                                                                                                                                                                                      |
| Feature 🎁          | This change represents a substantial change that users would notice                                                                                                                                                  |
| Maintenance 🔨      | This issue is required to keep the site up to date with other code, websites or updates                                                                                                                              |
