---
title: Squad stand-ups
description: How to run stand-ups in team squads
---

Each squad must have a [stand-up meeting](https://en.wikipedia.org/wiki/Stand-up_meeting) every morning, with the possible exception of end-of-iteration demo days.

## Guidelines

All stand-ups should try to follow these guidelines, as well as [general best practice](https://martinfowler.com/articles/itsNotJustStandingUp.html).

- Stand-ups should be as quick a possible and no longer than 15min
- Stand-ups should happen each day at the same time each day, even if a team member is late

### Standard format

During a stand-up, each team should discuss:

- the state and progress of current work (cards and epics)
- anything blocking current work and how to resolve it
- how close the team is to achieving their iteration goals

### Appropriate questions

- Questions about the progress/ state of the work
- Questions about the state and quality of task cards and epics
- Questions about dependencies between various task cards

### Before stand-up

Each team member can help the stand-up go smoothly by checking these points before each stand-up:

- Make sure your task cards are updated and are in correct columns
- Make sure you know the latest state of your work e.g if you're waiting for a review to come through
- Make sure you checked your emails so you know if anything that might impact your work came through over night
- Make sure you update your team on early leave or similar events

### General tips

If team members get involved into a lengthy conversation ask them to stop and continue the discussion after stand up with the relevant people.

If you're having trouble with the TV, inform your PM and use your laptop in the meantime.
