---
title: Iteration creation
description: These are the steps to follow when creating a new iteration
---

## Before the iteration starts

### Create a milestone

Go to your squad's repo and create a milestone titled:

Iteration `{YY}`-`{week}` `{date from}` - `{date to}`

For example: "Iteration 18-47 20th November - 3rd December."

### Create a small task epic

Create a new epic on the squad repo and attach it to the new milestone. Usually in the format "Small Tasks: Iteration {YY}-{week}"

### Set up the backlog

Populate the "Proposed iteration" area in the backlog spreadsheet with high-level rows describing work for the upcoming iteration

Move all incomplete epics down from the "Previous iteration" to the "Current iteration" section. Apart from the small tasks epic. Instead, reassign all small tasks from the previous iteration to the new small tasks epic in this iteration.

### Create epics for every proposed backlog item

Create epics in the appropriate squad's repo (e.g. ubuntudesign/web-squad) and title the epic the same as the title in the backlog. Assign them to the appropriate milestone.

Create and then estimate tasks in the appropriate repo for the work (e.g. canonical-websites/jp.ubuntu.com), once they are broken down, for each epic in the next milestone. Assign them to the appropriate next milestone and set their pipeline status to "Triaged".

## At the start of the iteration

Rename the sections of the backlog from "Current iteration:" to "Previous iteration". Then rename "Next iteration" to "Current iteration". Then create a new row titled "Next iteration" below "Current iteration".

This should result in the "Previous iteration" being 100% complete. You may now hide the iteration rows.

Pull up the epics that are prioritised from this iteration.

Be sure to check the "sum" cells are set currently.

Hide the content of the completed iteration.

Ensure all rows are correctly broken into issues with estimations.

Check the number of points in the new iteration are achievable, if not, remove or add rows. This will inform the squad how much they take on as small tasks.

### Assigning issues to small tasks

Once you have completed your planning and know how many points you can still take on in the iteration, scroll through the Triaged pipeline and choose a number of high, medium and low issues.

A suggested ratio might be 3 high, 2 medium and 1 small.

This allows for a churn of low priority issues to be resolved regularly.

### Assign the milestone to the epic and cards

Once you have organised the backlog and you know which epics you are taking on, highlight each epic and move them to the "Iteration epics" pipeline and assign the newly created milestone. You can then show all cards for this epic via the board view. Select each issue and move them to the "Current iteration" pipeline and also assign them to the milestone.

You are now ready to take on your next iteration.
