---
title: Copy reviews
description: A checklist for reviewing written content
---

Use this list to review the copy on Canonical and Ubuntu sites and web apps.

You can find more detailed information on the [Canonical copy style guide](https://wiki.canonical.com/Marketing/Style_guide), including lists of product names and commonly used words.

If something is ambiguous, ill-defined or absent from the style guide, please [submit an issue](https://github.com/ubuntudesign/webteam-practices/issues/new) for an amendment or addition to the guide.

## Checklist

- Has the entire document been spellchecked?
- Have you read all the content on the page/screen? Is there anything that doesn’t make sense, or that you had to read more than once to understand the meaning? It probably means it should be reworded: ask for help or make your own suggestion
- Do all links work?
- Does the document follow British spelling and grammar?
  - Correct: _colour_, _virtualisation_, _centre_
  - Incorrect: _color_, _virtualization_, _center_
- Are all titles written in sentence case?
  - Correct: _Multiple devices, one experience_
  - Incorrect: _Multiple Devices, One Experience_
  - **Tip:** when in doubt, double-check whether nouns are product names (which should be capitalised) or not (most times they’re not)
- Are Ubuntu releases mentioned by their full name?
- Correct: _Ubuntu 16.04 LTS_
- Incorrect: _Ubuntu 16.04_; _16.04_; _16.04 LTS_
- Are brands and company names correctly written? (Always double-check using official sources)
  - Correct: _GitHub_, _JavaScript_, _WordPress_, _PayPal_
  - Incorrect: _Github_, _Javascript_, _Wordpress_, _Paypal_
- Are there any ampersands in the document?
  - Unless part of an official brand or product name, replace ampersands for the word “and”
- Do headings have a full stop? (They shouldn’t)
- Do features lists have full stops? (They shouldn’t)
- Do enumerations use the serial comma? (They shouldn’t)
  - Correct: _We design, build and run your private cloud._
  - Incorrect: _We design, build, and run your private cloud._
- Do call to action links (as opposed links inline with text) or buttons start with a verb?
  - Correct: _Read the Netflix case study_
  - Incorrect: _Netflix case study_
- Are dates formatted correctly?
  - Correct: _1 January 2017_; _1-2 January 2017_; _1 January - 2 February 2017_
  - Incorrect: any other format, including ordinal indicators (st, nd, th) and shortened month names
- Do currency symbols precede the amount?
  - Correct: _€13_
  - Incorrect: _13€_
- Are USD indicated by the currency symbol only?
  - Correct: _\$2,500_
  - Incorrect: _USD \$2,5000_; _USD 2,500_
- Do numbers over 3 digits have a comma?
  - Correct: _1,000 machines_
  - Incorrect: _1000 machines_
- Is there a space between values and units? (There shouldn’t be)
  - Correct: _3GB_; _124g_
  - Incorrect: _3 GB_; _124 g_
- Does the document use any exclamation marks? Are they needed or can they be removed? (Do it)
- Does the document include any directional words? (It shouldn’t)
  - Incorrect: _Check out the list below/above/to the left/right_
- Does the document include any non-inclusive language? (It shouldn't) A full list of non-inclusive terms can be found [here](https://github.com/canonical-web-and-design/Inclusive-naming/blob/main/config.yml).
  - Correct: _allowlist_, _blocklist_, _main_
  - Incorrect: _whitelist_, _blacklist_, _master_
