---
title: Browser support
description: The browsers we officially support in our CSS and JavaScript
---

Our baseline browser support for our websites. There are two levels of support.

## Full support

Any browser with full support needs to be pixel perfect and all functionality should work.

| Browser | Version                                                                                                  |
| ------- | -------------------------------------------------------------------------------------------------------- |
| Chrome  | Should work for the last 3 [stable major versions](https://www.chromestatus.com/features/schedule)       |
| Firefox | Should work for the last 3 [stable major versions](https://wiki.mozilla.org/Release_Management/Calendar) |
| Safari  | [latest major version](https://developer.apple.com/safari/technology-preview/release-notes)              |
| IE      | 11 or greater                                                                                            |
| Edge    | Latest                                                                                                   |
| Opera   | Should work for the last 3 [stable major versions](https://www.opera.com/docs/history/#history)          |

## Accessible support

The content on these browsers should be readable but it does not have to look perfect.

| Browser | Version |
| ------- | ------- |
| Chrome  | 49      |
| Firefox | 45      |
| Edge    | 14      |

Any browser not mentioned here is not supported and therefore not tested.

### Testing on different browsers

The team has an account with [BrowserStack](https://www.browserstack.com) to test your site on browsers you don't have installed or different versions. You can find the teams email and password in our credentials document.
