# Guidelines for contributing to these practices

This repository contains best practices specifically for the Canonical web and design team. The documents contained here should remain concise and of a high quality.

Anyone is welcome to suggest improvements in one of two ways:

- Start a discussion by submitting [a new issue](https://github.com/ubuntudesign/webteam-practices/issues/new)
- Suggest a change by submitting a pull request ([how?](https://help.github.com/articles/about-pull-requests/))

## Submitting suggestions

Pull requests are a starting point for discussion. The team should collaborate to refine the suggested points before reaching a consensus.

Since the webteam-practices represent the culture of the whole team it will be common for pull requests to generate discussion before being accepted. Quality and team consensus should take precedence over speed.

Individual pull requests should remain small so that they can be agreed upon and approved more easily. Usually a pull request should not add more than a single subsection to a document.

### Starting a new document

To start a new document, the initial pull request should simply create the document with only a single heading.

This can then be merged more quickly so that others can start adding sections to the new document as soon as possible.

### Collaborating on large documents

The process of approving small pull requests can seem overly cumbersome when trying to add significant amounts of content. This will likely be most difficult more towards the project's inception, when there's still not much content, and become less relevant over time.

To get around this it may make more sense to ask the team to collaborate on long documents in an interactive writing tool like [Google Docs](https://docs.google.com/), where many people can quickly build up a shared vision.

The parts of the newly created document should then be submitted as pull requests in the normal way, subject to all the normal rules of approval, but if most of the relevant team members were already involved in the collaborative phase then approval should go by much more easily.

## Reviewing pull requests

As this repository represents the whole team, team members should try to collaborate on any pull request they are aware of.

To encourage participation and activity on the project, comments should remain as polite and accommodating as possible. The [GitHub reviews](https://help.github.com/articles/about-pull-request-reviews/) features ("approve" and "request changes") should _not_ be used, as all discussion is merely a discussion of opinions.

### Approval criteria

Before a pull request is approved and merged:

- A reasonable effort should be made to bring it to the attention of the whole team
- It should also have been :+1:d by at least 2 team members
- It should have been open for at least 24 hours
  - For expediency, this rule does not apply to pull requests to create new [empty documents](#starting-a-new-document)

Once it is merged, it should be brought up in the next relevant team meeting to ensure the whole team is aware of the change.
