# Generated by Django 2.0.5 on 2018-05-19 13:23

from django.conf import settings
import django.contrib.auth.models
import django.contrib.auth.validators
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0009_alter_user_last_name_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('username', models.CharField(error_messages={'unique': 'A user with that username already exists.'}, help_text='Required. 150 characters or fewer. Letters, digits and @/./+/-/_ only.', max_length=150, unique=True, validators=[django.contrib.auth.validators.UnicodeUsernameValidator()], verbose_name='username')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=150, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'user',
                'verbose_name_plural': 'users',
                'abstract': False,
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='CNC',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('cncName', models.CharField(max_length=255, unique=True)),
                ('cncNo', models.CharField(max_length=255, unique=True)),
                ('cncIpAddressWithPort', models.CharField(max_length=255, unique=True)),
                ('cncRegistCode', models.CharField(max_length=255, unique=True)),
                ('cncMachineCode', models.CharField(max_length=255, unique=True)),
                ('cncImageIndex', models.PositiveIntegerField()),
                ('ipcIpAddressWithPort', models.CharField(max_length=255)),
                ('lastClockSyncedTime', models.DateTimeField()),
                ('isInUsing', models.BooleanField()),
                ('reservedField_1', models.CharField(max_length=255, null=True)),
                ('reservedField_2', models.CharField(max_length=255, null=True)),
                ('reservedField_3', models.CharField(max_length=255, null=True)),
                ('reservedField_4', models.CharField(max_length=255, null=True)),
                ('reservedField_5', models.CharField(max_length=255, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CNCAlarm',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('alarmID', models.CharField(max_length=255, unique=True)),
                ('alarmReason', models.TextField(max_length=4000, null=True)),
                ('alarmAppearance', models.TextField(max_length=4000, null=True)),
                ('alarmSolution', models.TextField(max_length=4000, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='CNCType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('typeName', models.CharField(max_length=255, unique=True)),
                ('typeNo', models.CharField(max_length=255, unique=True)),
            ],
        ),
        migrations.CreateModel(
            name='NCBrand',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('brandName', models.CharField(max_length=255, unique=True)),
                ('hasInternetInterface', models.BooleanField()),
            ],
        ),
        migrations.AddField(
            model_name='cnc',
            name='cncAlarm',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='cncs', to='app.CNCAlarm'),
        ),
        migrations.AddField(
            model_name='cnc',
            name='cncManager',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='cncs', to=settings.AUTH_USER_MODEL),
        ),
        migrations.AddField(
            model_name='cnc',
            name='cncType',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='cncs', to='app.CNCType'),
        ),
        migrations.AddField(
            model_name='cnc',
            name='ncBrand',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='cncs', to='app.NCBrand'),
        ),
    ]
