export const DEFAULT_SLIDER_POSITION = 0.5;

export const CANVAS_ERROR_MESSAGE = 'Invalid or forbidden canvas'
export const GO_HOME_BUTTON = 'Go Home';

// 3D Renderer constants
export const RENDER_WRAPPER_ID = 'renderwrapper';
export const CANVAS_MISSING = 'Canvas not present for image capture.';
export const IMAGE_UPLOAD_PAUSED = 'Canvas image upload paused.';
export const IMAGE_UPLOAD_ERROR = 'Error uploading canvas image.';
export const IMAGE_SAVE_MESSAGE = 'Image saved!';

// Sidebar buttons
export const CLONE_ELEMENT_BUTTON = 'Clone Current Model';
export const DELETE_ELEMENT_BUTTON = 'Delete Current Model';
export const SIDEBAR_BUTTONS = [CLONE_ELEMENT_BUTTON, DELETE_ELEMENT_BUTTON];
export const AUTO_RENDER_CHECKBOX = 'Auto Render';
export const AUTO_RENDER_LABEL_POSITION = 'left';

// Initial element conditions
export const INIT_POSITION = {
  'x': 300,
  'y': 50
};
export const INIT_SIZE = {
  'width': 100,
  'height': 100,
}
export const INIT_ROTATION = 0;

// Max element conditions
export const MIN_DIM = 20;
export const MAX_WIDTH = 1820;
export const MAX_HEIGHT = 1240;

// Initial canvas settings
export const OVERHEAD_VIEW = 'overhead';
export const SIDE_VIEW = 'side';
