; BootLoader加载到内存中的起始位置
LOADER_BASE_ADDR equ 0x900
; BootLoader在磁盘上的起始LBA扇区编号
LOADER_START_SECTOR equ 0x2


KERNEL_BIN_BASE_ADDR equ 0x70000 ; 内核载入内存的起始地址
KERNEL_START_SECTOR equ 0x9 ; 内核所在的起始扇区
KERNEL_ENTRY_POINT equ 0xc0001500 ; 内核入口代码地址

; --------------   gdt描述符属性  -------------
DESC_G_4K equ 1_00000000000000000000000b
DESC_D_32 equ 1_0000000000000000000000b
;  64位代码标记，此处标记为0便可。
DESC_L equ 0_000000000000000000000b
;  cpu不用此位，暂置为0
DESC_AVL equ 0_00000000000000000000b
DESC_LIMIT_CODE2 equ 1111_0000000000000000b
DESC_LIMIT_DATA2 equ DESC_LIMIT_CODE2
DESC_LIMIT_VIDEO2 equ 0000_000000000000000b
DESC_P equ 1_000000000000000b
DESC_DPL_0 equ 00_0000000000000b
DESC_DPL_1 equ 01_0000000000000b
DESC_DPL_2 equ 10_0000000000000b
DESC_DPL_3 equ 11_0000000000000b
DESC_S_CODE equ 1_000000000000b
DESC_S_DATA equ DESC_S_CODE
DESC_S_sys equ 0_000000000000b
;x=1,c=0,r=0,a=0 代码段是可执行的,非依从的,不可读的,已访问位a清0.
DESC_TYPE_CODE equ 1000_00000000b
;x=0,e=0,w=1,a=0 数据段是不可执行的,向上扩展的,可写的,已访问位a清0.
DESC_TYPE_DATA equ 0010_00000000b

DESC_CODE_HIGH4 equ (0x00 << 24) + DESC_G_4K + DESC_D_32 + DESC_L + DESC_AVL + DESC_LIMIT_CODE2 + DESC_P + DESC_DPL_0 + DESC_S_CODE + DESC_TYPE_CODE + 0x00
DESC_DATA_HIGH4 equ (0x00 << 24) + DESC_G_4K + DESC_D_32 + DESC_L + DESC_AVL + DESC_LIMIT_DATA2 + DESC_P + DESC_DPL_0 + DESC_S_DATA + DESC_TYPE_DATA + 0x00
DESC_VIDEO_HIGH4 equ (0x00 << 24) + DESC_G_4K + DESC_D_32 + DESC_L + DESC_AVL + DESC_LIMIT_VIDEO2 + DESC_P + DESC_DPL_0 + DESC_S_DATA + DESC_TYPE_DATA + 0x0b

;--------------   段选择子属性  ---------------
RPL0  equ   00b
RPL1  equ   01b
RPL2  equ   10b
RPL3  equ   11b
TI_GDT	 equ   000b
TI_LDT	 equ   100b

;--------------   页表配置  ---------------
PAGE_DIR_TABLE_POS equ 0x100000 ; 分页目录表的起始位置
PG_P equ 1b
PG_RW_R equ 0_0b
PG_RW_W equ 1_0b
PG_US_S equ 0_00b
PG_US_U equ 1_00b

;-------------  program type 定义   --------------
PT_NULL equ 0