import { resolve } from 'path'
// 项目根目录
export const projRoot = resolve(__dirname, '..', '..')
export const pkgRoot = resolve(projRoot, 'packages')
export const compRoot = resolve(pkgRoot, 'components')
export const themeRoot = resolve(pkgRoot, 'theme-chalk')
export const hookRoot = resolve(pkgRoot, 'hooks')
export const directiveRoot = resolve(pkgRoot, 'directives')
export const epRoot = resolve(pkgRoot, 'element-ultra')
export const utilRoot = resolve(pkgRoot, 'utils')
export const docRoot = resolve(projRoot, 'docs')

/** dist */
export const buildOutput = resolve(projRoot, 'dist')
/** dist/element-ultra */
export const epOutput = resolve(buildOutput, 'element-ultra')

export const projPackage = resolve(projRoot, 'package.json')
export const compPackage = resolve(compRoot, 'package.json')
export const themePackage = resolve(themeRoot, 'package.json')
export const hookPackage = resolve(hookRoot, 'package.json')
export const directivePackage = resolve(directiveRoot, 'package.json')
export const epPackage = resolve(epRoot, 'package.json')
export const utilPackage = resolve(utilRoot, 'package.json')
export const docPackage = resolve(docRoot, 'package.json')

// 应用文件夹
export const icPath = resolve(projRoot, '../ic2')
/** ic vite缓存 */
export const viteCache = resolve(icPath, 'node_modules/.vite')
/** ic 待替换的文件夹 */
export const icTarget = resolve(icPath, 'packages/element-ultra')