---
title: Scrollbar 滚动条
lang: zh-CN
---

# Scrollbar 滚动条

用于替换浏览器原生滚动条。

## 基础用法

:::demo 通过 `height` 属性设置滚动条高度，若不设置则根据父容器高度自适应。

scrollbar/basic-usage

:::

## 横向滚动

:::demo 当元素宽度大于滚动条宽度时，会显示横向滚动条。

scrollbar/horizontal-scroll

:::

## 最大高度

:::demo 当元素高度超过最大高度，才会显示滚动条。

scrollbar/max-height

:::

## 手动滚动

:::demo 通过使用 `setScrollTop` 与 `setScrollLeft` 方法，可以手动控制滚动条滚动。

scrollbar/manual-scroll

:::

## Scrollbar 属性

| 属性         | 说明                                 | 类型              | 可选值 | 默认值   |
| ---------- | ---------------------------------- | --------------- | --- | ----- |
| height     | 滚动条高度                              | string / number | —   | —     |
| max-height | 滚动条最大高度                            | string / number | —   | —     |
| wrap-style | 包裹容器的自定义样式                         | string          | —   | —     |
| wrap-class | 包裹容器的自定义类名                         | string          | —   | —     |
| view-style | 视图的自定义样式                           | string          | —   | —     |
| view-class | 视图的自定义类名                           | string          | —   | —     |
| noresize   | 不响应容器尺寸变化，如果容器尺寸不会发生变化，最好设置它可以优化性能 | boolean         | —   | false |
| tag        | 视图的元素标签                            | string          | —   | div   |
| always     | 滚动条总是显示(鼠标不放在上面也会显示)                            | boolean         | —   | false |
| bar-visible     | 是否显示滚动条                            | boolean         | —   | true |
| min-size   | 滚动条最小尺寸                            | number          | —   | 20    |
| bar-z-index   | 滚动条的zIndex                            | number          | —   | 1    |

## Scrollbar 事件

| 事件名    | 说明       | 参数                               |
| ------ | -------- | -------------------------------- |
| scroll | 滚动时触发的事件 | 滚动距离 `{ scrollLeft, scrollTop }` |

## Scrollbar 方法

| 方法名           | 说明          | 参数                   |
| ------------- | ----------- | -------------------- |
| setScrollTop  | 设置滚动条到顶部的距离 | (scrollTop: number)  |
| setScrollLeft | 设置滚动条到左边的距离 | (scrollLeft: number) |
| update        | 手动更新滚动条状态   | —                    |

## Scrollbar 插槽

| 名称 | 说明      |
| -- | ------- |
| —  | 自定义默认内容 |
