export const sidebars = {
  '/guide/': [
    {
      text: '基础',
      children: [
        {
          text: '设计',
          link: '/guide/design'
        },
        {
          text: '导航',
          link: '/guide/nav'
        },
        {
          text: '安装',
          link: '/guide/installation'
        },
        {
          text: '快速开始',
          link: '/guide/quickstart'
        },
        {
          text: 'css变量',
          link: '/guide/css-var'
        }
      ]
    },
    {
      text: '进阶',
      children: [
        {
          text: '从 Element UI 升级',
          link: '/guide/migration'
        },
        {
          text: '主题',
          link: '/guide/theming'
        },
        {
          text: '内置过渡动画',
          link: '/guide/transitions'
        },
        {
          text: '更新日志',
          link: '/guide/changelog'
        }
      ]
    }
  ],
  '/component/': [
    {
      text: 'Basic 基础组件',
      children: [
        {
          link: '/component/button',
          text: 'Button 按钮'
        },
        {
          link: '/component/border',
          text: 'Border 边框'
        },
        {
          link: '/component/color',
          text: 'Color 色彩'
        },
        {
          link: '/component/container',
          text: 'Container 布局容器'
        },
        {
          link: '/component/icon',
          text: 'Icon 图标'
        },
        {
          link: '/component/layout',
          text: 'Layout 布局'
        },
        {
          link: '/component/link',
          text: 'Link 链接'
        },
        {
          link: '/component/scrollbar',
          text: 'Scrollbar 滚动条'
        },
        {
          link: '/component/space',
          text: 'Space 间距'
        },
        {
          link: '/component/typography',
          text: 'Typography 排版'
        }
      ]
    },
    {
      text: '配置组件',
      children: [
        {
          link: '/component/config-store',
          text: 'Config 全局配置(新)'
        }
      ]
    },
    {
      text: 'Form 表单组件',
      children: [
        {
          link: '/component/cascade',
          text: 'Cascade 级联选择器'
        },
        {
          link: '/component/checkbox',
          text: 'Checkbox 多选框'
        },
        {
          link: '/component/color-picker',
          text: 'Color Picker 取色器'
        },
        {
          link: '/component/date-picker',
          text: 'Date Picker 日期选择器'
        },
        {
          link: '/component/datetime-picker',
          text: 'DateTime Picker 日期时间选择器'
        },
        {
          link: '/component/form',
          text: 'Form 表单'
        },
        {
          link: '/component/input',
          text: 'Input 输入框'
        },
        {
          link: '/component/batch-input',
          text: 'BatchInput 批量输入'
        },
        {
          link: '/component/input-number',
          text: 'Input Number 数字输入框'
        },
        {
          link: '/component/textarea',
          text: 'Textarea 文本域'
        },
        {
          link: '/component/radio',
          text: 'Radio 单选框'
        },
        {
          link: '/component/rate',
          text: 'Rate 评分'
        },

        {
          link: '/component/select',
          text: 'Select 选择器'
        },
        {
          link: '/component/slider',
          text: 'Slider 滑块'
        },
        {
          link: '/component/switch',
          text: 'Switch 开关'
        },
        {
          link: '/component/time-picker',
          text: 'Time Picker 时间选择器'
        },
        {
          link: '/component/time-select',
          text: 'Time Select 时间选择'
        },
        {
          link: '/component/transfer',
          text: 'Transfer 穿梭框'
        },
        {
          link: '/component/upload',
          text: 'Upload 上传'
        }
      ]
    },
    {
      text: 'Data 数据展示',
      children: [
        {
          link: '/component/avatar',
          text: 'Avatar 头像'
        },
        {
          link: '/component/badge',
          text: 'Badge 徽章'
        },
        {
          link: '/component/calendar',
          text: 'Calendar 日历'
        },
        {
          link: '/component/card',
          text: 'Card 卡片'
        },
        {
          link: '/component/carousel',
          text: 'Carousel 走马灯'
        },
        {
          link: '/component/collapse',
          text: 'Collapse 折叠面板'
        },
        {
          link: '/component/descriptions',
          text: 'Descriptions 描述列表'
        },
        {
          link: '/component/empty',
          text: 'Empty 空状态'
        },
        {
          link: '/component/image',
          text: 'Image 图片'
        },
        {
          link: '/component/infinite-scroll',
          text: 'Infinite Scroll 无限滚动'
        },
        {
          link: '/component/pagination',
          text: 'Pagination 分页'
        },
        {
          link: '/component/progress',
          text: 'Progress 进度条'
        },
        {
          link: '/component/result',
          text: 'Result 结果'
        },
        {
          link: '/component/skeleton',
          text: 'Skeleton 骨架屏'
        },
        {
          link: '/component/table',
          text: 'Table 表格'
        },
        {
          link: '/component/data-table',
          text: 'DataTable 数据表格'
        },
        {
          link: '/component/tag',
          text: 'Tag 标签'
        },
        {
          link: '/component/timeline',
          text: 'Timeline 时间线'
        },
        {
          link: '/component/tree',
          text: 'Tree 树形控件'
        },
        {
          link: '/component/tree-select',
          text: 'TreeSelect 树形选择器'
        }
      ]
    },
    {
      text: 'Navigation 导航',
      children: [
        {
          link: '/component/affix',
          text: 'Affix 固钉'
        },
        {
          link: '/component/backtop',
          text: 'Backtop 回到顶部'
        },
        {
          link: '/component/breadcrumb',
          text: 'Breadcrumb 面包屑'
        },
        {
          link: '/component/dropdown',
          text: 'Dropdown 下拉菜单'
        },
        {
          link: '/component/menu',
          text: 'Menu 菜单'
        },
        {
          link: '/component/page',
          text: 'Page 页面'
        },
        {
          link: '/component/page-header',
          text: 'Page Header 页头'
        },
        {
          link: '/component/steps',
          text: 'Steps 步骤条'
        },
        {
          link: '/component/tabs',
          text: 'Tabs 标签页'
        }
      ]
    },
    {
      text: 'Feedback 反馈组件',
      children: [
        {
          link: '/component/alert',
          text: 'Alert 提示'
        },
        {
          link: '/component/dialog',
          text: 'Dialog 对话框'
        },
        {
          link: '/component/drawer',
          text: 'Drawer 抽屉'
        },
        {
          link: '/component/loading',
          text: 'Loading 加载'
        },
        {
          link: '/component/message',
          text: 'Message 消息提示'
        },
        {
          link: '/component/message-box',
          text: 'Message Box 消息弹出框'
        },
        {
          link: '/component/notification',
          text: 'Notification 通知'
        },
        {
          link: '/component/popconfirm',
          text: 'Pop Confirm 弹出确认框'
        },
        {
          link: '/component/popover',
          text: 'Popover 弹出框'
        },
        {
          link: '/component/tooltip',
          text: 'Tooltip 文字提示'
        },
        {
          link: '/component/action',
          text: 'Action 操作按钮'
        }
      ]
    },
    {
      text: 'Others 其他',
      children: [
        {
          link: '/component/divider',
          text: 'Divider 分割线'
        }
      ]
    },
    {
      text: 'Integrated 集成组件',
      children: [
        {
          link: '/component/pro-table',
          text: 'ProTable 集成表格'
        },
        {
          link: '/component/form-dialog',
          text: 'FormDialog 表单弹框'
        },
        {
          link: '/component/multiple-form',
          text: 'MultipleForm 多行表单'
        },
        {
          link: '/component/edit-bar',
          text: 'EditBar 编辑栏'
        },
        {
          link: '/component/table-select',
          text: 'TableSelect 表格选择组件'
        }
      ]
    }
  ]
}
