# [Bulma Css Components](https://components.bulma-css.com)

Open-Source project. The initial components generated by [bulma.dev](https://bulma.dev/). 

<br />

![Bulma Css Components - Gif animated presentation](https://github.com/app-generator/static/blob/master/bulma-css/bulma-css-components-intro.gif?raw=true)

<br />

## Getting Started

Project's source files are placed in ./src/ directory. 

* ./src/assets - default static files (eg. image placeholders). You should replace them with your own files.

* ./src/scss/ - Sass sources used to build Bulma theme. Variables used in Theme Customizer are located in custom-variables.scss file.

* ./src/*.pug - All your pages (templates) are stored in separated .pug files.

<br />

## How to use it

```
# Install dependencies
$ yarn

# Run dev server with live preview (Browsersync)
$ yarn start 

# Or make production build
yarn build
```

<br />

## Components

 - [admin](/src/admin.pug) - [demo](https://components.bulma-css.com/admin.html)
 - [blog](/src/blog.pug) - [demo](https://components.bulma-css.com/blog.html)
 - [contacts](/src/contacts.pug) - [demo](https://components.bulma-css.com/contacts.html)
 - [content](/src/content.pug) - [demo](https://components.bulma-css.com/content.html)
 - [cookies](/src/cookies.pug) - [demo](https://components.bulma-css.com/cookies.html)
 - [cta](/src/cta.pug) - [demo](https://components.bulma-css.com/cta.html)
 - [ecomm](/src/ecomm.pug) - [demo](https://components.bulma-css.com/ecomm.html)
 - [faq](/src/faq.pug) - [demo](https://components.bulma-css.com/faq.html)
 - [features](/src/features.pug) - [demo](https://components.bulma-css.com/features.html)
 - [gallery](/src/gallery.pug) - [demo](https://components.bulma-css.com/gallery.html)
 - [grid](/src/grid.pug) - [demo](https://components.bulma-css.com/grid.html)
 - [hero](/src/hero.pug) - [demo](https://components.bulma-css.com/hero.html)
 - [how-it-works](/src/how-it-works.pug) - [demo](https://components.bulma-css.com/how-it-works.html)
 - [http-codes](/src/http-codes.pug) - [demo](https://components.bulma-css.com/http-codes.html)
 - [navbar](/src/navbar.pug) - [demo](https://components.bulma-css.com/navbar.html)
 - [pagination](/src/pagination.pug) - [demo](https://components.bulma-css.com/pagination.html)
 - [portfolio](/src/portfolio.pug) - [demo](https://components.bulma-css.com/portfolio.html)
 - [pricing](/src/pricing.pug) - [demo](https://components.bulma-css.com/pricing.html)
 - [sign-in](/src/sign-in.pug) - [demo](https://components.bulma-css.com/sign-in.html)
 - [team](/src/team.pug) - [demo](https://components.bulma-css.com/team.html)
 - [testimonials](/src/testimonials.pug) - [demo](https://components.bulma-css.com/testimonials.html)

<br />

--- 
Supported by [Bulma-CSS](https://bulma-css.com/)
