# python_class_101

Welcome to this programming course! In this course, we will be introducing the basics of programming using the Python language. Python is a powerful and versatile programming language that is widely used in a variety of fields, such as web development, scientific computing, data analysis, and artificial intelligence. One of the reasons why Python is so popular is because it is easy to read and write, and its syntax is simple and consistent.

Throughout this course, we will be focusing on the fundamental concepts of programming rather than the specific syntax of the Python language. This means that we will **NOT** be teaching you the most optimal or efficient way to write Python code, but rather the basic concepts that you need to know in order to understand and write your own programs.

You will learn how to use variables, control flow structures, loops, functions, Object Oriented programming, and how to work with data structures like lists and dictionaries. By the end of this course, you will have a solid understanding of the basic concepts of programming and will be able to write your own simple programs using Python and be able to take these general concepts to learn other programming languages as well.

So, let's get started!

This project/course consists primarily of two components:
* Jupyter Notebooks outlining essential concepts in programming. These are stored in the `01-lesson_notebooks` directory.
* A corresponding larger project exercise, intended to be built in an IDE (program assumes VS Code), is also included in the `02-IDE_excecises folder`.

## How to use the materials
Lesson notebooks are arranged by topic denoted with a lesson number like `01a-...`, `03b-...`, or `09c-...` . Each notebook contains explanations and examples of the programming principle/concept for that section. Lesson notebooks have simple exercises that you can work out directly in the notebook itself.

Each lesson set has a corresponding "IDE Exercise" with the same lesson number that relates to the set of notebooks i.e. `01-...`, `02a-...`, `10-...`, etc. These are projects with a larger scope that you should practice building within in your IDE. I'm generally assuming you're using VS Code as your IDE in the included notes. Each project folder has a `README`, included with the project exercise description.

## How to get started
Navigate to the setup workbooks [00a-Mac_Setup.ipynb](01-lesson_notebooks/00a-Mac_Setup.ipynb) and/or the [00b-Windows_Setup.ipynb](01-lesson_notebooks/00b-Windows_Setup.ipynb) and follow the instructions to begin downloading the various tools we recommend. You can then checkout [01a-Some_Context.ipynb](01-lesson_notebooks/01a-Some_Context.ipynb) to get an understanding of the basics and WHY we downloaded the tools we that did.

## How you can contribute to the project
There are many ways that people can help contribute to your project. One of the most important ways is by expanding on the explanations and descriptions provided in the project. This can include adding more detailed information and examples, creating diagrams and images to help illustrate key concepts, and providing additional resources and materials for users to reference.

Another way that people can help contribute to your project is by adding project exercises and challenges. These can include coding challenges, quizzes, and other interactive activities that help users test their understanding of the concepts covered in the project.

Another way to help is to proofreading and spell checking the project for any errors or typos. This will ensure that the project is easy to read and understand for users of all levels.

Finally, adding unit tests for users to test their program is a great way to ensure that the program is working correctly and that users are able to understand the concepts covered in the project.

Overall, there are many ways that people can help contribute to your project and make it a valuable resource for users. By working together and leveraging the skills and expertise of a diverse group of contributors, you can create a high-quality and effective project that helps users learn and grow.

## TODO:
* [ ] Add exercise to count occurence of vowels in string
* [ ] Add exercise to count occurence of set of strings in total strings
* [ ] Add exercise that prints the longest substring of string s in which letters occur in alphabetical order
* [ ] Finish 7b presentation...
* [ ] Finish 7b Notes by adding the pictures
* [ ] Add tests for IDE project solutions
* [ ] Update embedded images in Jupyter notebooks. [Reference](https://stackoverflow.com/questions/32370281/how-to-embed-image-or-picture-in-jupyter-notebook-either-from-a-local-machine-o)

