/************************************************************************************
 *
 * D++, A Lightweight C++ library for Discord
 *
 * Copyright 2022 Craig Edwards and D++ contributors
 * (https://github.com/brainboxdotcc/DPP/graphs/contributors)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************************/


/* Auto @generated by buildtools/make_sync_struct.php.
 *
 * DO NOT EDIT BY HAND!
 *
 * To re-generate this header file re-run the script!
 */

#include <dpp/export.h>
#include <dpp/snowflake.h>
#include <dpp/cluster.h>

namespace dpp {

slashcommand_map cluster::global_bulk_command_create_sync(const std::vector<slashcommand> &commands) {
	return dpp::sync<slashcommand_map>(this, static_cast<void (cluster::*)(const std::vector<slashcommand> &, command_completion_event_t)>(&cluster::global_bulk_command_create), commands);
}

slashcommand_map cluster::global_bulk_command_delete_sync() {
	return dpp::sync<slashcommand_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::global_bulk_command_delete));
}

slashcommand cluster::global_command_create_sync(const slashcommand &s) {
	return dpp::sync<slashcommand>(this, static_cast<void (cluster::*)(const slashcommand &, command_completion_event_t)>(&cluster::global_command_create), s);
}

slashcommand cluster::global_command_get_sync(snowflake id) {
	return dpp::sync<slashcommand>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::global_command_get), id);
}

confirmation cluster::global_command_delete_sync(snowflake id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::global_command_delete), id);
}

confirmation cluster::global_command_edit_sync(const slashcommand &s) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const slashcommand &, command_completion_event_t)>(&cluster::global_command_edit), s);
}

slashcommand_map cluster::global_commands_get_sync() {
	return dpp::sync<slashcommand_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::global_commands_get));
}

slashcommand_map cluster::guild_bulk_command_create_sync(const std::vector<slashcommand> &commands, snowflake guild_id) {
	return dpp::sync<slashcommand_map>(this, static_cast<void (cluster::*)(const std::vector<slashcommand> &, snowflake, command_completion_event_t)>(&cluster::guild_bulk_command_create), commands, guild_id);
}

slashcommand_map cluster::guild_bulk_command_delete_sync(snowflake guild_id) {
	return dpp::sync<slashcommand_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_bulk_command_delete), guild_id);
}

guild_command_permissions_map cluster::guild_commands_get_permissions_sync(snowflake guild_id) {
	return dpp::sync<guild_command_permissions_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_commands_get_permissions), guild_id);
}

guild_command_permissions_map cluster::guild_bulk_command_edit_permissions_sync(const std::vector<slashcommand> &commands, snowflake guild_id) {
	return dpp::sync<guild_command_permissions_map>(this, static_cast<void (cluster::*)(const std::vector<slashcommand> &, snowflake, command_completion_event_t)>(&cluster::guild_bulk_command_edit_permissions), commands, guild_id);
}

slashcommand cluster::guild_command_create_sync(const slashcommand &s, snowflake guild_id) {
	return dpp::sync<slashcommand>(this, static_cast<void (cluster::*)(const slashcommand &, snowflake, command_completion_event_t)>(&cluster::guild_command_create), s, guild_id);
}

confirmation cluster::guild_command_delete_sync(snowflake id, snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_command_delete), id, guild_id);
}

confirmation cluster::guild_command_edit_permissions_sync(const slashcommand &s, snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const slashcommand &, snowflake, command_completion_event_t)>(&cluster::guild_command_edit_permissions), s, guild_id);
}

slashcommand cluster::guild_command_get_sync(snowflake id, snowflake guild_id) {
	return dpp::sync<slashcommand>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_command_get), id, guild_id);
}

guild_command_permissions cluster::guild_command_get_permissions_sync(snowflake id, snowflake guild_id) {
	return dpp::sync<guild_command_permissions>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_command_get_permissions), id, guild_id);
}

confirmation cluster::guild_command_edit_sync(const slashcommand &s, snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const slashcommand &, snowflake, command_completion_event_t)>(&cluster::guild_command_edit), s, guild_id);
}

slashcommand_map cluster::guild_commands_get_sync(snowflake guild_id) {
	return dpp::sync<slashcommand_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_commands_get), guild_id);
}

confirmation cluster::interaction_response_create_sync(snowflake interaction_id, const std::string &token, const interaction_response &r) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const std::string &, const interaction_response &, command_completion_event_t)>(&cluster::interaction_response_create), interaction_id, token, r);
}

confirmation cluster::interaction_response_edit_sync(const std::string &token, const message &m) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::string &, const message &, command_completion_event_t)>(&cluster::interaction_response_edit), token, m);
}

message cluster::interaction_response_get_original_sync(const std::string &token) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const std::string &, command_completion_event_t)>(&cluster::interaction_response_get_original), token);
}

confirmation cluster::interaction_followup_create_sync(const std::string &token, const message &m) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::string &, const message &, command_completion_event_t)>(&cluster::interaction_followup_create), token, m);
}

confirmation cluster::interaction_followup_edit_original_sync(const std::string &token, const message &m) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::string &, const message &, command_completion_event_t)>(&cluster::interaction_followup_edit_original), token, m);
}

confirmation cluster::interaction_followup_delete_sync(const std::string &token) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::string &, command_completion_event_t)>(&cluster::interaction_followup_delete), token);
}

confirmation cluster::interaction_followup_edit_sync(const std::string &token, const message &m) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::string &, const message &, command_completion_event_t)>(&cluster::interaction_followup_edit), token, m);
}

message cluster::interaction_followup_get_sync(const std::string &token, snowflake message_id) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const std::string &, snowflake, command_completion_event_t)>(&cluster::interaction_followup_get), token, message_id);
}

message cluster::interaction_followup_get_original_sync(const std::string &token) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const std::string &, command_completion_event_t)>(&cluster::interaction_followup_get_original), token);
}

automod_rule_map cluster::automod_rules_get_sync(snowflake guild_id) {
	return dpp::sync<automod_rule_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::automod_rules_get), guild_id);
}

automod_rule cluster::automod_rule_get_sync(snowflake guild_id, snowflake rule_id) {
	return dpp::sync<automod_rule>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::automod_rule_get), guild_id, rule_id);
}

automod_rule cluster::automod_rule_create_sync(snowflake guild_id, const automod_rule& r) {
	return dpp::sync<automod_rule>(this, static_cast<void (cluster::*)(snowflake, const automod_rule&, command_completion_event_t)>(&cluster::automod_rule_create), guild_id, r);
}

automod_rule cluster::automod_rule_edit_sync(snowflake guild_id, const automod_rule& r) {
	return dpp::sync<automod_rule>(this, static_cast<void (cluster::*)(snowflake, const automod_rule&, command_completion_event_t)>(&cluster::automod_rule_edit), guild_id, r);
}

confirmation cluster::automod_rule_delete_sync(snowflake guild_id, snowflake rule_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::automod_rule_delete), guild_id, rule_id);
}

channel cluster::channel_create_sync(const class channel &c) {
	return dpp::sync<channel>(this, static_cast<void (cluster::*)(const class channel &, command_completion_event_t)>(&cluster::channel_create), c);
}

confirmation cluster::channel_delete_permission_sync(const class channel &c, snowflake overwrite_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class channel &, snowflake, command_completion_event_t)>(&cluster::channel_delete_permission), c, overwrite_id);
}

confirmation cluster::channel_delete_sync(snowflake channel_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::channel_delete), channel_id);
}

confirmation cluster::channel_edit_permissions_sync(const class channel &c, const snowflake overwrite_id, const uint64_t allow, const uint64_t deny, const bool member) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class channel &, const snowflake, const uint64_t, const uint64_t, const bool, command_completion_event_t)>(&cluster::channel_edit_permissions), c, overwrite_id, allow, deny, member);
}

confirmation cluster::channel_edit_permissions_sync(const snowflake channel_id, const snowflake overwrite_id, const uint64_t allow, const uint64_t deny, const bool member) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const snowflake, const snowflake, const uint64_t, const uint64_t, const bool, command_completion_event_t)>(&cluster::channel_edit_permissions), channel_id, overwrite_id, allow, deny, member);
}

confirmation cluster::channel_edit_positions_sync(const std::vector<channel> &c) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::vector<channel> &, command_completion_event_t)>(&cluster::channel_edit_positions), c);
}

channel cluster::channel_edit_sync(const class channel &c) {
	return dpp::sync<channel>(this, static_cast<void (cluster::*)(const class channel &, command_completion_event_t)>(&cluster::channel_edit), c);
}

confirmation cluster::channel_follow_news_sync(const class channel &c, snowflake target_channel_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class channel &, snowflake, command_completion_event_t)>(&cluster::channel_follow_news), c, target_channel_id);
}

channel cluster::channel_get_sync(snowflake c) {
	return dpp::sync<channel>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::channel_get), c);
}

invite cluster::channel_invite_create_sync(const class channel &c, const class invite &i) {
	return dpp::sync<invite>(this, static_cast<void (cluster::*)(const class channel &, const class invite &, command_completion_event_t)>(&cluster::channel_invite_create), c, i);
}

invite_map cluster::channel_invites_get_sync(const class channel &c) {
	return dpp::sync<invite_map>(this, static_cast<void (cluster::*)(const class channel &, command_completion_event_t)>(&cluster::channel_invites_get), c);
}

confirmation cluster::channel_typing_sync(const class channel &c) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class channel &, command_completion_event_t)>(&cluster::channel_typing), c);
}

confirmation cluster::channel_typing_sync(snowflake cid) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::channel_typing), cid);
}

channel_map cluster::channels_get_sync(snowflake guild_id) {
	return dpp::sync<channel_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::channels_get), guild_id);
}

confirmation cluster::channel_set_voice_status_sync(snowflake channel_id, const std::string& status) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const std::string&, command_completion_event_t)>(&cluster::channel_set_voice_status), channel_id, status);
}

channel cluster::create_dm_channel_sync(snowflake user_id) {
	return dpp::sync<channel>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::create_dm_channel), user_id);
}

channel_map cluster::current_user_get_dms_sync() {
	return dpp::sync<channel_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::current_user_get_dms));
}

message cluster::direct_message_create_sync(snowflake user_id, const message &m) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(snowflake, const message &, command_completion_event_t)>(&cluster::direct_message_create), user_id, m);
}

confirmation cluster::gdm_add_sync(snowflake channel_id, snowflake user_id, const std::string &access_token, const std::string &nick) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, const std::string &, const std::string &, command_completion_event_t)>(&cluster::gdm_add), channel_id, user_id, access_token, nick);
}

confirmation cluster::gdm_remove_sync(snowflake channel_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::gdm_remove), channel_id, user_id);
}

emoji cluster::guild_emoji_create_sync(snowflake guild_id, const class emoji& newemoji) {
	return dpp::sync<emoji>(this, static_cast<void (cluster::*)(snowflake, const class emoji&, command_completion_event_t)>(&cluster::guild_emoji_create), guild_id, newemoji);
}

confirmation cluster::guild_emoji_delete_sync(snowflake guild_id, snowflake emoji_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_emoji_delete), guild_id, emoji_id);
}

emoji cluster::guild_emoji_edit_sync(snowflake guild_id, const class emoji& newemoji) {
	return dpp::sync<emoji>(this, static_cast<void (cluster::*)(snowflake, const class emoji&, command_completion_event_t)>(&cluster::guild_emoji_edit), guild_id, newemoji);
}

emoji cluster::guild_emoji_get_sync(snowflake guild_id, snowflake emoji_id) {
	return dpp::sync<emoji>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_emoji_get), guild_id, emoji_id);
}

emoji_map cluster::guild_emojis_get_sync(snowflake guild_id) {
	return dpp::sync<emoji_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_emojis_get), guild_id);
}

emoji_map cluster::application_emojis_get_sync() {
	return dpp::sync<emoji_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::application_emojis_get));
}

emoji cluster::application_emoji_get_sync(snowflake emoji_id) {
	return dpp::sync<emoji>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::application_emoji_get), emoji_id);
}

emoji cluster::application_emoji_create_sync(const class emoji& newemoji) {
	return dpp::sync<emoji>(this, static_cast<void (cluster::*)(const class emoji&, command_completion_event_t)>(&cluster::application_emoji_create), newemoji);
}

emoji cluster::application_emoji_edit_sync(const class emoji& newemoji) {
	return dpp::sync<emoji>(this, static_cast<void (cluster::*)(const class emoji&, command_completion_event_t)>(&cluster::application_emoji_edit), newemoji);
}

confirmation cluster::application_emoji_delete_sync(snowflake emoji_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::application_emoji_delete), emoji_id);
}

entitlement_map cluster::entitlements_get_sync(snowflake user_id, const std::vector<snowflake>& sku_ids, snowflake before_id, snowflake after_id, uint8_t limit, snowflake guild_id, bool exclude_ended) {
	return dpp::sync<entitlement_map>(this, static_cast<void (cluster::*)(snowflake, const std::vector<snowflake>&, snowflake, snowflake, uint8_t, snowflake, bool, command_completion_event_t)>(&cluster::entitlements_get), user_id, sku_ids, before_id, after_id, limit, guild_id, exclude_ended);
}

entitlement cluster::entitlement_test_create_sync(const class entitlement& new_entitlement) {
	return dpp::sync<entitlement>(this, static_cast<void (cluster::*)(const class entitlement&, command_completion_event_t)>(&cluster::entitlement_test_create), new_entitlement);
}

confirmation cluster::entitlement_test_delete_sync(const class snowflake entitlement_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class snowflake, command_completion_event_t)>(&cluster::entitlement_test_delete), entitlement_id);
}

confirmation cluster::entitlement_consume_sync(const class snowflake entitlement_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class snowflake, command_completion_event_t)>(&cluster::entitlement_consume), entitlement_id);
}

gateway cluster::get_gateway_bot_sync() {
	return dpp::sync<gateway>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::get_gateway_bot));
}

confirmation cluster::guild_current_member_edit_sync(snowflake guild_id, const std::string &nickname) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const std::string &, command_completion_event_t)>(&cluster::guild_current_member_edit), guild_id, nickname);
}

auditlog cluster::guild_auditlog_get_sync(snowflake guild_id, snowflake user_id, uint32_t action_type, snowflake before, snowflake after, uint32_t limit) {
	return dpp::sync<auditlog>(this, static_cast<void (cluster::*)(snowflake, snowflake, uint32_t, snowflake, snowflake, uint32_t, command_completion_event_t)>(&cluster::guild_auditlog_get), guild_id, user_id, action_type, before, after, limit);
}

confirmation cluster::guild_ban_add_sync(snowflake guild_id, snowflake user_id, uint32_t delete_message_seconds) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, uint32_t, command_completion_event_t)>(&cluster::guild_ban_add), guild_id, user_id, delete_message_seconds);
}

confirmation cluster::guild_ban_delete_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_ban_delete), guild_id, user_id);
}

guild cluster::guild_create_sync(const class guild &g) {
	return dpp::sync<guild>(this, static_cast<void (cluster::*)(const class guild &, command_completion_event_t)>(&cluster::guild_create), g);
}

confirmation cluster::guild_delete_sync(snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_delete), guild_id);
}

confirmation cluster::guild_delete_integration_sync(snowflake guild_id, snowflake integration_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_delete_integration), guild_id, integration_id);
}

guild cluster::guild_edit_sync(const class guild &g) {
	return dpp::sync<guild>(this, static_cast<void (cluster::*)(const class guild &, command_completion_event_t)>(&cluster::guild_edit), g);
}

guild_widget cluster::guild_edit_widget_sync(snowflake guild_id, const class guild_widget &gw) {
	return dpp::sync<guild_widget>(this, static_cast<void (cluster::*)(snowflake, const class guild_widget &, command_completion_event_t)>(&cluster::guild_edit_widget), guild_id, gw);
}

ban cluster::guild_get_ban_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<ban>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_get_ban), guild_id, user_id);
}

ban_map cluster::guild_get_bans_sync(snowflake guild_id, snowflake before, snowflake after, snowflake limit) {
	return dpp::sync<ban_map>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, snowflake, command_completion_event_t)>(&cluster::guild_get_bans), guild_id, before, after, limit);
}

guild cluster::guild_get_sync(snowflake guild_id) {
	return dpp::sync<guild>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get), guild_id);
}

integration_map cluster::guild_get_integrations_sync(snowflake guild_id) {
	return dpp::sync<integration_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_integrations), guild_id);
}

guild cluster::guild_get_preview_sync(snowflake guild_id) {
	return dpp::sync<guild>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_preview), guild_id);
}

invite cluster::guild_get_vanity_sync(snowflake guild_id) {
	return dpp::sync<invite>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_vanity), guild_id);
}

guild_widget cluster::guild_get_widget_sync(snowflake guild_id) {
	return dpp::sync<guild_widget>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_widget), guild_id);
}

confirmation cluster::guild_modify_integration_sync(snowflake guild_id, const class integration &i) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const class integration &, command_completion_event_t)>(&cluster::guild_modify_integration), guild_id, i);
}

prune cluster::guild_get_prune_counts_sync(snowflake guild_id, const struct prune& pruneinfo) {
	return dpp::sync<prune>(this, static_cast<void (cluster::*)(snowflake, const struct prune&, command_completion_event_t)>(&cluster::guild_get_prune_counts), guild_id, pruneinfo);
}

prune cluster::guild_begin_prune_sync(snowflake guild_id, const struct prune& pruneinfo) {
	return dpp::sync<prune>(this, static_cast<void (cluster::*)(snowflake, const struct prune&, command_completion_event_t)>(&cluster::guild_begin_prune), guild_id, pruneinfo);
}

confirmation cluster::guild_set_nickname_sync(snowflake guild_id, const std::string &nickname) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const std::string &, command_completion_event_t)>(&cluster::guild_set_nickname), guild_id, nickname);
}

confirmation cluster::guild_sync_integration_sync(snowflake guild_id, snowflake integration_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_sync_integration), guild_id, integration_id);
}

onboarding cluster::guild_get_onboarding_sync(snowflake guild_id) {
	return dpp::sync<onboarding>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_onboarding), guild_id);
}

onboarding cluster::guild_edit_onboarding_sync(const struct onboarding& o) {
	return dpp::sync<onboarding>(this, static_cast<void (cluster::*)(const struct onboarding&, command_completion_event_t)>(&cluster::guild_edit_onboarding), o);
}

dpp::welcome_screen cluster::guild_get_welcome_screen_sync(snowflake guild_id) {
	return dpp::sync<dpp::welcome_screen>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_welcome_screen), guild_id);
}

dpp::welcome_screen cluster::guild_edit_welcome_screen_sync(snowflake guild_id, const struct welcome_screen& welcome_screen, bool enabled) {
	return dpp::sync<dpp::welcome_screen>(this, static_cast<void (cluster::*)(snowflake, const struct welcome_screen&, bool, command_completion_event_t)>(&cluster::guild_edit_welcome_screen), guild_id, welcome_screen, enabled);
}

confirmation cluster::guild_add_member_sync(const guild_member& gm, const std::string &access_token) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const guild_member&, const std::string &, command_completion_event_t)>(&cluster::guild_add_member), gm, access_token);
}

guild_member cluster::guild_edit_member_sync(const guild_member& gm) {
	return dpp::sync<guild_member>(this, static_cast<void (cluster::*)(const guild_member&, command_completion_event_t)>(&cluster::guild_edit_member), gm);
}

guild_member cluster::guild_get_member_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<guild_member>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_get_member), guild_id, user_id);
}

guild_member_map cluster::guild_get_members_sync(snowflake guild_id, uint16_t limit, snowflake after) {
	return dpp::sync<guild_member_map>(this, static_cast<void (cluster::*)(snowflake, uint16_t, snowflake, command_completion_event_t)>(&cluster::guild_get_members), guild_id, limit, after);
}

confirmation cluster::guild_member_add_role_sync(snowflake guild_id, snowflake user_id, snowflake role_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, command_completion_event_t)>(&cluster::guild_member_add_role), guild_id, user_id, role_id);
}

confirmation cluster::guild_member_delete_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_member_delete), guild_id, user_id);
}

confirmation cluster::guild_member_kick_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_member_kick), guild_id, user_id);
}

confirmation cluster::guild_member_timeout_sync(snowflake guild_id, snowflake user_id, time_t communication_disabled_until) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, time_t, command_completion_event_t)>(&cluster::guild_member_timeout), guild_id, user_id, communication_disabled_until);
}

confirmation cluster::guild_member_timeout_remove_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_member_timeout_remove), guild_id, user_id);
}

confirmation cluster::guild_member_delete_role_sync(snowflake guild_id, snowflake user_id, snowflake role_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, command_completion_event_t)>(&cluster::guild_member_delete_role), guild_id, user_id, role_id);
}

confirmation cluster::guild_member_remove_role_sync(snowflake guild_id, snowflake user_id, snowflake role_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, command_completion_event_t)>(&cluster::guild_member_remove_role), guild_id, user_id, role_id);
}

guild_member cluster::guild_member_move_sync(const snowflake channel_id, const snowflake guild_id, const snowflake user_id) {
	return dpp::sync<guild_member>(this, static_cast<void (cluster::*)(const snowflake, const snowflake, const snowflake, command_completion_event_t)>(&cluster::guild_member_move), channel_id, guild_id, user_id);
}

guild_member_map cluster::guild_search_members_sync(snowflake guild_id, const std::string& query, uint16_t limit) {
	return dpp::sync<guild_member_map>(this, static_cast<void (cluster::*)(snowflake, const std::string&, uint16_t, command_completion_event_t)>(&cluster::guild_search_members), guild_id, query, limit);
}

invite_map cluster::guild_get_invites_sync(snowflake guild_id) {
	return dpp::sync<invite_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_invites), guild_id);
}

invite cluster::invite_delete_sync(const std::string &invitecode) {
	return dpp::sync<invite>(this, static_cast<void (cluster::*)(const std::string &, command_completion_event_t)>(&cluster::invite_delete), invitecode);
}

invite cluster::invite_get_sync(const std::string &invite_code) {
	return dpp::sync<invite>(this, static_cast<void (cluster::*)(const std::string &, command_completion_event_t)>(&cluster::invite_get), invite_code);
}

confirmation cluster::message_add_reaction_sync(const struct message &m, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const struct message &, const std::string &, command_completion_event_t)>(&cluster::message_add_reaction), m, reaction);
}

confirmation cluster::message_add_reaction_sync(snowflake message_id, snowflake channel_id, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, const std::string &, command_completion_event_t)>(&cluster::message_add_reaction), message_id, channel_id, reaction);
}

message cluster::message_create_sync(const message &m) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const message &, command_completion_event_t)>(&cluster::message_create), m);
}

message cluster::message_crosspost_sync(snowflake message_id, snowflake channel_id) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::message_crosspost), message_id, channel_id);
}

confirmation cluster::message_delete_all_reactions_sync(const struct message &m) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const struct message &, command_completion_event_t)>(&cluster::message_delete_all_reactions), m);
}

confirmation cluster::message_delete_all_reactions_sync(snowflake message_id, snowflake channel_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::message_delete_all_reactions), message_id, channel_id);
}

confirmation cluster::message_delete_bulk_sync(const std::vector<snowflake>& message_ids, snowflake channel_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const std::vector<snowflake>&, snowflake, command_completion_event_t)>(&cluster::message_delete_bulk), message_ids, channel_id);
}

confirmation cluster::message_delete_sync(snowflake message_id, snowflake channel_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::message_delete), message_id, channel_id);
}

confirmation cluster::message_delete_own_reaction_sync(const struct message &m, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const struct message &, const std::string &, command_completion_event_t)>(&cluster::message_delete_own_reaction), m, reaction);
}

confirmation cluster::message_delete_own_reaction_sync(snowflake message_id, snowflake channel_id, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, const std::string &, command_completion_event_t)>(&cluster::message_delete_own_reaction), message_id, channel_id, reaction);
}

confirmation cluster::message_delete_reaction_sync(const struct message &m, snowflake user_id, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const struct message &, snowflake, const std::string &, command_completion_event_t)>(&cluster::message_delete_reaction), m, user_id, reaction);
}

confirmation cluster::message_delete_reaction_sync(snowflake message_id, snowflake channel_id, snowflake user_id, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, const std::string &, command_completion_event_t)>(&cluster::message_delete_reaction), message_id, channel_id, user_id, reaction);
}

confirmation cluster::message_delete_reaction_emoji_sync(const struct message &m, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const struct message &, const std::string &, command_completion_event_t)>(&cluster::message_delete_reaction_emoji), m, reaction);
}

confirmation cluster::message_delete_reaction_emoji_sync(snowflake message_id, snowflake channel_id, const std::string &reaction) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, const std::string &, command_completion_event_t)>(&cluster::message_delete_reaction_emoji), message_id, channel_id, reaction);
}

message cluster::message_edit_sync(const message &m) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const message &, command_completion_event_t)>(&cluster::message_edit), m);
}

message cluster::message_edit_flags_sync(const message &m) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const message &, command_completion_event_t)>(&cluster::message_edit_flags), m);
}

message cluster::message_get_sync(snowflake message_id, snowflake channel_id) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::message_get), message_id, channel_id);
}

user_map cluster::message_get_reactions_sync(const struct message &m, const std::string &reaction, snowflake before, snowflake after, snowflake limit) {
	return dpp::sync<user_map>(this, static_cast<void (cluster::*)(const struct message &, const std::string &, snowflake, snowflake, snowflake, command_completion_event_t)>(&cluster::message_get_reactions), m, reaction, before, after, limit);
}

emoji_map cluster::message_get_reactions_sync(snowflake message_id, snowflake channel_id, const std::string &reaction, snowflake before, snowflake after, snowflake limit) {
	return dpp::sync<emoji_map>(this, static_cast<void (cluster::*)(snowflake, snowflake, const std::string &, snowflake, snowflake, snowflake, command_completion_event_t)>(&cluster::message_get_reactions), message_id, channel_id, reaction, before, after, limit);
}

confirmation cluster::message_pin_sync(snowflake channel_id, snowflake message_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::message_pin), channel_id, message_id);
}

message_map cluster::messages_get_sync(snowflake channel_id, snowflake around, snowflake before, snowflake after, uint64_t limit) {
	return dpp::sync<message_map>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, snowflake, uint64_t, command_completion_event_t)>(&cluster::messages_get), channel_id, around, before, after, limit);
}

confirmation cluster::message_unpin_sync(snowflake channel_id, snowflake message_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::message_unpin), channel_id, message_id);
}

user_map cluster::poll_get_answer_voters_sync(const message& m, uint32_t answer_id, snowflake after, uint64_t limit) {
	return dpp::sync<user_map>(this, static_cast<void (cluster::*)(const message&, uint32_t, snowflake, uint64_t, command_completion_event_t)>(&cluster::poll_get_answer_voters), m, answer_id, after, limit);
}

user_map cluster::poll_get_answer_voters_sync(snowflake message_id, snowflake channel_id, uint32_t answer_id, snowflake after, uint64_t limit) {
	return dpp::sync<user_map>(this, static_cast<void (cluster::*)(snowflake, snowflake, uint32_t, snowflake, uint64_t, command_completion_event_t)>(&cluster::poll_get_answer_voters), message_id, channel_id, answer_id, after, limit);
}

message cluster::poll_end_sync(const message &m) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const message &, command_completion_event_t)>(&cluster::poll_end), m);
}

message cluster::poll_end_sync(snowflake message_id, snowflake channel_id) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::poll_end), message_id, channel_id);
}

message_map cluster::channel_pins_get_sync(snowflake channel_id) {
	return dpp::sync<message_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::channel_pins_get), channel_id);
}

role cluster::role_create_sync(const class role &r) {
	return dpp::sync<role>(this, static_cast<void (cluster::*)(const class role &, command_completion_event_t)>(&cluster::role_create), r);
}

confirmation cluster::role_delete_sync(snowflake guild_id, snowflake role_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::role_delete), guild_id, role_id);
}

role cluster::role_edit_sync(const class role &r) {
	return dpp::sync<role>(this, static_cast<void (cluster::*)(const class role &, command_completion_event_t)>(&cluster::role_edit), r);
}

role_map cluster::roles_edit_position_sync(snowflake guild_id, const std::vector<role> &roles) {
	return dpp::sync<role_map>(this, static_cast<void (cluster::*)(snowflake, const std::vector<role> &, command_completion_event_t)>(&cluster::roles_edit_position), guild_id, roles);
}

role_map cluster::roles_get_sync(snowflake guild_id) {
	return dpp::sync<role_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::roles_get), guild_id);
}

application_role_connection cluster::application_role_connection_get_sync(snowflake application_id) {
	return dpp::sync<application_role_connection>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::application_role_connection_get), application_id);
}

application_role_connection cluster::application_role_connection_update_sync(snowflake application_id, const std::vector<application_role_connection_metadata> &connection_metadata) {
	return dpp::sync<application_role_connection>(this, static_cast<void (cluster::*)(snowflake, const std::vector<application_role_connection_metadata> &, command_completion_event_t)>(&cluster::application_role_connection_update), application_id, connection_metadata);
}

application_role_connection cluster::user_application_role_connection_get_sync(snowflake application_id) {
	return dpp::sync<application_role_connection>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::user_application_role_connection_get), application_id);
}

application_role_connection cluster::user_application_role_connection_update_sync(snowflake application_id, const application_role_connection &connection) {
	return dpp::sync<application_role_connection>(this, static_cast<void (cluster::*)(snowflake, const application_role_connection &, command_completion_event_t)>(&cluster::user_application_role_connection_update), application_id, connection);
}

scheduled_event_map cluster::guild_events_get_sync(snowflake guild_id) {
	return dpp::sync<scheduled_event_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_events_get), guild_id);
}

scheduled_event cluster::guild_event_create_sync(const scheduled_event& event) {
	return dpp::sync<scheduled_event>(this, static_cast<void (cluster::*)(const scheduled_event&, command_completion_event_t)>(&cluster::guild_event_create), event);
}

confirmation cluster::guild_event_delete_sync(snowflake event_id, snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_event_delete), event_id, guild_id);
}

scheduled_event cluster::guild_event_edit_sync(const scheduled_event& event) {
	return dpp::sync<scheduled_event>(this, static_cast<void (cluster::*)(const scheduled_event&, command_completion_event_t)>(&cluster::guild_event_edit), event);
}

scheduled_event cluster::guild_event_get_sync(snowflake guild_id, snowflake event_id) {
	return dpp::sync<scheduled_event>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_event_get), guild_id, event_id);
}

sku_map cluster::skus_get_sync() {
	return dpp::sync<sku_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::skus_get));
}

stage_instance cluster::stage_instance_create_sync(const stage_instance& si) {
	return dpp::sync<stage_instance>(this, static_cast<void (cluster::*)(const stage_instance&, command_completion_event_t)>(&cluster::stage_instance_create), si);
}

stage_instance cluster::stage_instance_get_sync(const snowflake channel_id) {
	return dpp::sync<stage_instance>(this, static_cast<void (cluster::*)(const snowflake, command_completion_event_t)>(&cluster::stage_instance_get), channel_id);
}

stage_instance cluster::stage_instance_edit_sync(const stage_instance& si) {
	return dpp::sync<stage_instance>(this, static_cast<void (cluster::*)(const stage_instance&, command_completion_event_t)>(&cluster::stage_instance_edit), si);
}

confirmation cluster::stage_instance_delete_sync(const snowflake channel_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const snowflake, command_completion_event_t)>(&cluster::stage_instance_delete), channel_id);
}

sticker cluster::guild_sticker_create_sync(const sticker &s) {
	return dpp::sync<sticker>(this, static_cast<void (cluster::*)(const sticker &, command_completion_event_t)>(&cluster::guild_sticker_create), s);
}

confirmation cluster::guild_sticker_delete_sync(snowflake sticker_id, snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_sticker_delete), sticker_id, guild_id);
}

sticker cluster::guild_sticker_get_sync(snowflake id, snowflake guild_id) {
	return dpp::sync<sticker>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::guild_sticker_get), id, guild_id);
}

sticker cluster::guild_sticker_modify_sync(const sticker &s) {
	return dpp::sync<sticker>(this, static_cast<void (cluster::*)(const sticker &, command_completion_event_t)>(&cluster::guild_sticker_modify), s);
}

sticker_map cluster::guild_stickers_get_sync(snowflake guild_id) {
	return dpp::sync<sticker_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_stickers_get), guild_id);
}

sticker cluster::nitro_sticker_get_sync(snowflake id) {
	return dpp::sync<sticker>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::nitro_sticker_get), id);
}

sticker_pack_map cluster::sticker_packs_get_sync() {
	return dpp::sync<sticker_pack_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::sticker_packs_get));
}

guild cluster::guild_create_from_template_sync(const std::string &code, const std::string &name) {
	return dpp::sync<guild>(this, static_cast<void (cluster::*)(const std::string &, const std::string &, command_completion_event_t)>(&cluster::guild_create_from_template), code, name);
}

dtemplate cluster::guild_template_create_sync(snowflake guild_id, const std::string &name, const std::string &description) {
	return dpp::sync<dtemplate>(this, static_cast<void (cluster::*)(snowflake, const std::string &, const std::string &, command_completion_event_t)>(&cluster::guild_template_create), guild_id, name, description);
}

confirmation cluster::guild_template_delete_sync(snowflake guild_id, const std::string &code) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const std::string &, command_completion_event_t)>(&cluster::guild_template_delete), guild_id, code);
}

dtemplate cluster::guild_template_modify_sync(snowflake guild_id, const std::string &code, const std::string &name, const std::string &description) {
	return dpp::sync<dtemplate>(this, static_cast<void (cluster::*)(snowflake, const std::string &, const std::string &, const std::string &, command_completion_event_t)>(&cluster::guild_template_modify), guild_id, code, name, description);
}

dtemplate_map cluster::guild_templates_get_sync(snowflake guild_id) {
	return dpp::sync<dtemplate_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_templates_get), guild_id);
}

dtemplate cluster::guild_template_sync_sync(snowflake guild_id, const std::string &code) {
	return dpp::sync<dtemplate>(this, static_cast<void (cluster::*)(snowflake, const std::string &, command_completion_event_t)>(&cluster::guild_template_sync), guild_id, code);
}

dtemplate cluster::template_get_sync(const std::string &code) {
	return dpp::sync<dtemplate>(this, static_cast<void (cluster::*)(const std::string &, command_completion_event_t)>(&cluster::template_get), code);
}

confirmation cluster::current_user_join_thread_sync(snowflake thread_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::current_user_join_thread), thread_id);
}

confirmation cluster::current_user_leave_thread_sync(snowflake thread_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::current_user_leave_thread), thread_id);
}

active_threads cluster::threads_get_active_sync(snowflake guild_id) {
	return dpp::sync<active_threads>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::threads_get_active), guild_id);
}

thread_map cluster::threads_get_joined_private_archived_sync(snowflake channel_id, snowflake before_id, uint16_t limit) {
	return dpp::sync<thread_map>(this, static_cast<void (cluster::*)(snowflake, snowflake, uint16_t, command_completion_event_t)>(&cluster::threads_get_joined_private_archived), channel_id, before_id, limit);
}

thread_map cluster::threads_get_private_archived_sync(snowflake channel_id, time_t before_timestamp, uint16_t limit) {
	return dpp::sync<thread_map>(this, static_cast<void (cluster::*)(snowflake, time_t, uint16_t, command_completion_event_t)>(&cluster::threads_get_private_archived), channel_id, before_timestamp, limit);
}

thread_map cluster::threads_get_public_archived_sync(snowflake channel_id, time_t before_timestamp, uint16_t limit) {
	return dpp::sync<thread_map>(this, static_cast<void (cluster::*)(snowflake, time_t, uint16_t, command_completion_event_t)>(&cluster::threads_get_public_archived), channel_id, before_timestamp, limit);
}

thread_member cluster::thread_member_get_sync(const snowflake thread_id, const snowflake user_id) {
	return dpp::sync<thread_member>(this, static_cast<void (cluster::*)(const snowflake, const snowflake, command_completion_event_t)>(&cluster::thread_member_get), thread_id, user_id);
}

thread_member_map cluster::thread_members_get_sync(snowflake thread_id) {
	return dpp::sync<thread_member_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::thread_members_get), thread_id);
}

thread cluster::thread_create_in_forum_sync(const std::string& thread_name, snowflake channel_id, const message& msg, auto_archive_duration_t auto_archive_duration, uint16_t rate_limit_per_user, std::vector<snowflake> applied_tags) {
	return dpp::sync<thread>(this, static_cast<void (cluster::*)(const std::string&, snowflake, const message&, auto_archive_duration_t, uint16_t, std::vector<snowflake>, command_completion_event_t)>(&cluster::thread_create_in_forum), thread_name, channel_id, msg, auto_archive_duration, rate_limit_per_user, applied_tags);
}

thread cluster::thread_create_sync(const std::string& thread_name, snowflake channel_id, uint16_t auto_archive_duration, channel_type thread_type, bool invitable, uint16_t rate_limit_per_user) {
	return dpp::sync<thread>(this, static_cast<void (cluster::*)(const std::string&, snowflake, uint16_t, channel_type, bool, uint16_t, command_completion_event_t)>(&cluster::thread_create), thread_name, channel_id, auto_archive_duration, thread_type, invitable, rate_limit_per_user);
}

thread cluster::thread_edit_sync(const thread &t) {
	return dpp::sync<thread>(this, static_cast<void (cluster::*)(const thread &, command_completion_event_t)>(&cluster::thread_edit), t);
}

thread cluster::thread_create_with_message_sync(const std::string& thread_name, snowflake channel_id, snowflake message_id, uint16_t auto_archive_duration, uint16_t rate_limit_per_user) {
	return dpp::sync<thread>(this, static_cast<void (cluster::*)(const std::string&, snowflake, snowflake, uint16_t, uint16_t, command_completion_event_t)>(&cluster::thread_create_with_message), thread_name, channel_id, message_id, auto_archive_duration, rate_limit_per_user);
}

confirmation cluster::thread_member_add_sync(snowflake thread_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::thread_member_add), thread_id, user_id);
}

confirmation cluster::thread_member_remove_sync(snowflake thread_id, snowflake user_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::thread_member_remove), thread_id, user_id);
}

thread cluster::thread_get_sync(snowflake thread_id) {
	return dpp::sync<thread>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::thread_get), thread_id);
}

user cluster::current_user_edit_sync(const std::string &nickname, const std::string& avatar_blob, const image_type avatar_type, const std::string& banner_blob, const image_type banner_type) {
	return dpp::sync<user>(this, static_cast<void (cluster::*)(const std::string &, const std::string&, const image_type, const std::string&, const image_type, command_completion_event_t)>(&cluster::current_user_edit), nickname, avatar_blob, avatar_type, banner_blob, banner_type);
}

application cluster::current_application_get_sync() {
	return dpp::sync<application>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::current_application_get));
}

user_identified cluster::current_user_get_sync() {
	return dpp::sync<user_identified>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::current_user_get));
}

confirmation cluster::current_user_set_voice_state_sync(snowflake guild_id, snowflake channel_id, bool suppress, time_t request_to_speak_timestamp) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, bool, time_t, command_completion_event_t)>(&cluster::current_user_set_voice_state), guild_id, channel_id, suppress, request_to_speak_timestamp);
}

voicestate cluster::current_user_get_voice_state_sync(snowflake guild_id) {
	return dpp::sync<voicestate>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::current_user_get_voice_state), guild_id);
}

confirmation cluster::user_set_voice_state_sync(snowflake user_id, snowflake guild_id, snowflake channel_id, bool suppress) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, snowflake, snowflake, bool, command_completion_event_t)>(&cluster::user_set_voice_state), user_id, guild_id, channel_id, suppress);
}

voicestate cluster::user_get_voice_state_sync(snowflake guild_id, snowflake user_id) {
	return dpp::sync<voicestate>(this, static_cast<void (cluster::*)(snowflake, snowflake, command_completion_event_t)>(&cluster::user_get_voice_state), guild_id, user_id);
}

connection_map cluster::current_user_connections_get_sync() {
	return dpp::sync<connection_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::current_user_connections_get));
}

guild_map cluster::current_user_get_guilds_sync() {
	return dpp::sync<guild_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::current_user_get_guilds));
}

confirmation cluster::current_user_leave_guild_sync(snowflake guild_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::current_user_leave_guild), guild_id);
}

user_identified cluster::user_get_sync(snowflake user_id) {
	return dpp::sync<user_identified>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::user_get), user_id);
}

user_identified cluster::user_get_cached_sync(snowflake user_id) {
	return dpp::sync<user_identified>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::user_get_cached), user_id);
}

voiceregion_map cluster::get_voice_regions_sync() {
	return dpp::sync<voiceregion_map>(this, static_cast<void (cluster::*)(command_completion_event_t)>(&cluster::get_voice_regions));
}

voiceregion_map cluster::guild_get_voice_regions_sync(snowflake guild_id) {
	return dpp::sync<voiceregion_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::guild_get_voice_regions), guild_id);
}

webhook cluster::create_webhook_sync(const class webhook &wh) {
	return dpp::sync<webhook>(this, static_cast<void (cluster::*)(const class webhook &, command_completion_event_t)>(&cluster::create_webhook), wh);
}

confirmation cluster::delete_webhook_sync(snowflake webhook_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::delete_webhook), webhook_id);
}

confirmation cluster::delete_webhook_message_sync(const class webhook &wh, snowflake message_id, snowflake thread_id) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(const class webhook &, snowflake, snowflake, command_completion_event_t)>(&cluster::delete_webhook_message), wh, message_id, thread_id);
}

confirmation cluster::delete_webhook_with_token_sync(snowflake webhook_id, const std::string &token) {
	return dpp::sync<confirmation>(this, static_cast<void (cluster::*)(snowflake, const std::string &, command_completion_event_t)>(&cluster::delete_webhook_with_token), webhook_id, token);
}

webhook cluster::edit_webhook_sync(const class webhook& wh) {
	return dpp::sync<webhook>(this, static_cast<void (cluster::*)(const class webhook&, command_completion_event_t)>(&cluster::edit_webhook), wh);
}

message cluster::edit_webhook_message_sync(const class webhook &wh, const struct message& m, snowflake thread_id) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const class webhook &, const struct message&, snowflake, command_completion_event_t)>(&cluster::edit_webhook_message), wh, m, thread_id);
}

webhook cluster::edit_webhook_with_token_sync(const class webhook& wh) {
	return dpp::sync<webhook>(this, static_cast<void (cluster::*)(const class webhook&, command_completion_event_t)>(&cluster::edit_webhook_with_token), wh);
}

message cluster::execute_webhook_sync(const class webhook &wh, const struct message& m, bool wait, snowflake thread_id, const std::string& thread_name) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const class webhook &, const struct message&, bool, snowflake, const std::string&, command_completion_event_t)>(&cluster::execute_webhook), wh, m, wait, thread_id, thread_name);
}

webhook_map cluster::get_channel_webhooks_sync(snowflake channel_id) {
	return dpp::sync<webhook_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::get_channel_webhooks), channel_id);
}

webhook_map cluster::get_guild_webhooks_sync(snowflake guild_id) {
	return dpp::sync<webhook_map>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::get_guild_webhooks), guild_id);
}

webhook cluster::get_webhook_sync(snowflake webhook_id) {
	return dpp::sync<webhook>(this, static_cast<void (cluster::*)(snowflake, command_completion_event_t)>(&cluster::get_webhook), webhook_id);
}

message cluster::get_webhook_message_sync(const class webhook &wh, snowflake message_id, snowflake thread_id) {
	return dpp::sync<message>(this, static_cast<void (cluster::*)(const class webhook &, snowflake, snowflake, command_completion_event_t)>(&cluster::get_webhook_message), wh, message_id, thread_id);
}

webhook cluster::get_webhook_with_token_sync(snowflake webhook_id, const std::string &token) {
	return dpp::sync<webhook>(this, static_cast<void (cluster::*)(snowflake, const std::string &, command_completion_event_t)>(&cluster::get_webhook_with_token), webhook_id, token);
}


};

/* End of auto-generated definitions */
