#pragma once

namespace dpp {

/**
 * @brief Emoji unicodes.
 *
 * @note The unicode emojis in this namespace are auto-generated from https://raw.githubusercontent.com/ArkinSolomon/discord-emoji-converter/master/emojis.json
 *
 * @warning If you want to use this, you have to pull the header in separately. For example:
 * ```cpp
 * #include <dpp/dpp.h>
 * #include <dpp/unicode_emoji.h>
 * ```
 */
namespace unicode_emoji {
	inline constexpr const char _100[] = "💯";
	inline constexpr const char _1234[] = "🔢";
	inline constexpr const char soccer[] = "⚽";
	inline constexpr const char soccer_ball[] = "⚽";
	inline constexpr const char basketball[] = "🏀";
	inline constexpr const char football[] = "🏈";
	inline constexpr const char baseball[] = "⚾";
	inline constexpr const char softball[] = "🥎";
	inline constexpr const char tennis[] = "🎾";
	inline constexpr const char volleyball[] = "🏐";
	inline constexpr const char rugby_football[] = "🏉";
	inline constexpr const char flying_disc[] = "🥏";
	inline constexpr const char _8ball[] = "🎱";
	inline constexpr const char yo_yo[] = "🪀";
	inline constexpr const char ping_pong[] = "🏓";
	inline constexpr const char table_tennis[] = "🏓";
	inline constexpr const char badminton[] = "🏸";
	inline constexpr const char hockey[] = "🏒";
	inline constexpr const char ice_hockey[] = "🏒";
	inline constexpr const char field_hockey[] = "🏑";
	inline constexpr const char lacrosse[] = "🥍";
	inline constexpr const char cricket_game[] = "🏏";
	inline constexpr const char cricket_bat_ball[] = "🏏";
	inline constexpr const char boomerang[] = "🪃";
	inline constexpr const char goal[] = "🥅";
	inline constexpr const char goal_net[] = "🥅";
	inline constexpr const char golf[] = "⛳";
	inline constexpr const char flag_in_hole[] = "⛳";
	inline constexpr const char kite[] = "🪁";
	inline constexpr const char playground_slide[] = "🛝";
	inline constexpr const char bow_and_arrow[] = "🏹";
	inline constexpr const char archery[] = "🏹";
	inline constexpr const char fishing_pole_and_fish[] = "🎣";
	inline constexpr const char fishing_pole[] = "🎣";
	inline constexpr const char diving_mask[] = "🤿";
	inline constexpr const char boxing_glove[] = "🥊";
	inline constexpr const char boxing_gloves[] = "🥊";
	inline constexpr const char martial_arts_uniform[] = "🥋";
	inline constexpr const char karate_uniform[] = "🥋";
	inline constexpr const char running_shirt_with_sash[] = "🎽";
	inline constexpr const char running_shirt[] = "🎽";
	inline constexpr const char skateboard[] = "🛹";
	inline constexpr const char roller_skate[] = "🛼";
	inline constexpr const char sled[] = "🛷";
	inline constexpr const char ice_skate[] = "⛸️";
	inline constexpr const char curling_stone[] = "🥌";
	inline constexpr const char ski[] = "🎿";
	inline constexpr const char skis[] = "🎿";
	inline constexpr const char skier[] = "⛷️";
	inline constexpr const char snowboarder[] = "🏂";
	inline constexpr const char snowboarder_tone1[] = "🏂🏻";
	inline constexpr const char snowboarder_light_skin_tone[] = "🏂🏻";
	inline constexpr const char snowboarder_tone2[] = "🏂🏼";
	inline constexpr const char snowboarder_medium_light_skin_tone[] = "🏂🏼";
	inline constexpr const char snowboarder_tone3[] = "🏂🏽";
	inline constexpr const char snowboarder_medium_skin_tone[] = "🏂🏽";
	inline constexpr const char snowboarder_tone4[] = "🏂🏾";
	inline constexpr const char snowboarder_medium_dark_skin_tone[] = "🏂🏾";
	inline constexpr const char snowboarder_tone5[] = "🏂🏿";
	inline constexpr const char snowboarder_dark_skin_tone[] = "🏂🏿";
	inline constexpr const char parachute[] = "🪂";
	inline constexpr const char person_lifting_weights[] = "🏋️";
	inline constexpr const char lifter[] = "🏋️";
	inline constexpr const char weight_lifter[] = "🏋️";
	inline constexpr const char person_lifting_weights_tone1[] = "🏋🏻";
	inline constexpr const char lifter_tone1[] = "🏋🏻";
	inline constexpr const char weight_lifter_tone1[] = "🏋🏻";
	inline constexpr const char person_lifting_weights_tone2[] = "🏋🏼";
	inline constexpr const char lifter_tone2[] = "🏋🏼";
	inline constexpr const char weight_lifter_tone2[] = "🏋🏼";
	inline constexpr const char person_lifting_weights_tone3[] = "🏋🏽";
	inline constexpr const char lifter_tone3[] = "🏋🏽";
	inline constexpr const char weight_lifter_tone3[] = "🏋🏽";
	inline constexpr const char person_lifting_weights_tone4[] = "🏋🏾";
	inline constexpr const char lifter_tone4[] = "🏋🏾";
	inline constexpr const char weight_lifter_tone4[] = "🏋🏾";
	inline constexpr const char person_lifting_weights_tone5[] = "🏋🏿";
	inline constexpr const char lifter_tone5[] = "🏋🏿";
	inline constexpr const char weight_lifter_tone5[] = "🏋🏿";
	inline constexpr const char woman_lifting_weights[] = "🏋️‍♀️";
	inline constexpr const char woman_lifting_weights_tone1[] = "🏋🏻‍♀️";
	inline constexpr const char woman_lifting_weights_light_skin_tone[] = "🏋🏻‍♀️";
	inline constexpr const char woman_lifting_weights_tone2[] = "🏋🏼‍♀️";
	inline constexpr const char woman_lifting_weights_medium_light_skin_tone[] = "🏋🏼‍♀️";
	inline constexpr const char woman_lifting_weights_tone3[] = "🏋🏽‍♀️";
	inline constexpr const char woman_lifting_weights_medium_skin_tone[] = "🏋🏽‍♀️";
	inline constexpr const char woman_lifting_weights_tone4[] = "🏋🏾‍♀️";
	inline constexpr const char woman_lifting_weights_medium_dark_skin_tone[] = "🏋🏾‍♀️";
	inline constexpr const char woman_lifting_weights_tone5[] = "🏋🏿‍♀️";
	inline constexpr const char woman_lifting_weights_dark_skin_tone[] = "🏋🏿‍♀️";
	inline constexpr const char man_lifting_weights[] = "🏋️‍♂️";
	inline constexpr const char man_lifting_weights_tone1[] = "🏋🏻‍♂️";
	inline constexpr const char man_lifting_weights_light_skin_tone[] = "🏋🏻‍♂️";
	inline constexpr const char man_lifting_weights_tone2[] = "🏋🏼‍♂️";
	inline constexpr const char man_lifting_weights_medium_light_skin_tone[] = "🏋🏼‍♂️";
	inline constexpr const char man_lifting_weights_tone3[] = "🏋🏽‍♂️";
	inline constexpr const char man_lifting_weights_medium_skin_tone[] = "🏋🏽‍♂️";
	inline constexpr const char man_lifting_weights_tone4[] = "🏋🏾‍♂️";
	inline constexpr const char man_lifting_weights_medium_dark_skin_tone[] = "🏋🏾‍♂️";
	inline constexpr const char man_lifting_weights_tone5[] = "🏋🏿‍♂️";
	inline constexpr const char man_lifting_weights_dark_skin_tone[] = "🏋🏿‍♂️";
	inline constexpr const char people_wrestling[] = "🤼";
	inline constexpr const char wrestlers[] = "🤼";
	inline constexpr const char wrestling[] = "🤼";
	inline constexpr const char women_wrestling[] = "🤼‍♀️";
	inline constexpr const char men_wrestling[] = "🤼‍♂️";
	inline constexpr const char person_doing_cartwheel[] = "🤸";
	inline constexpr const char cartwheel[] = "🤸";
	inline constexpr const char person_doing_cartwheel_tone1[] = "🤸🏻";
	inline constexpr const char cartwheel_tone1[] = "🤸🏻";
	inline constexpr const char person_doing_cartwheel_tone2[] = "🤸🏼";
	inline constexpr const char cartwheel_tone2[] = "🤸🏼";
	inline constexpr const char person_doing_cartwheel_tone3[] = "🤸🏽";
	inline constexpr const char cartwheel_tone3[] = "🤸🏽";
	inline constexpr const char person_doing_cartwheel_tone4[] = "🤸🏾";
	inline constexpr const char cartwheel_tone4[] = "🤸🏾";
	inline constexpr const char person_doing_cartwheel_tone5[] = "🤸🏿";
	inline constexpr const char cartwheel_tone5[] = "🤸🏿";
	inline constexpr const char woman_cartwheeling[] = "🤸‍♀️";
	inline constexpr const char woman_cartwheeling_tone1[] = "🤸🏻‍♀️";
	inline constexpr const char woman_cartwheeling_light_skin_tone[] = "🤸🏻‍♀️";
	inline constexpr const char woman_cartwheeling_tone2[] = "🤸🏼‍♀️";
	inline constexpr const char woman_cartwheeling_medium_light_skin_tone[] = "🤸🏼‍♀️";
	inline constexpr const char woman_cartwheeling_tone3[] = "🤸🏽‍♀️";
	inline constexpr const char woman_cartwheeling_medium_skin_tone[] = "🤸🏽‍♀️";
	inline constexpr const char woman_cartwheeling_tone4[] = "🤸🏾‍♀️";
	inline constexpr const char woman_cartwheeling_medium_dark_skin_tone[] = "🤸🏾‍♀️";
	inline constexpr const char woman_cartwheeling_tone5[] = "🤸🏿‍♀️";
	inline constexpr const char woman_cartwheeling_dark_skin_tone[] = "🤸🏿‍♀️";
	inline constexpr const char man_cartwheeling[] = "🤸‍♂️";
	inline constexpr const char man_cartwheeling_tone1[] = "🤸🏻‍♂️";
	inline constexpr const char man_cartwheeling_light_skin_tone[] = "🤸🏻‍♂️";
	inline constexpr const char man_cartwheeling_tone2[] = "🤸🏼‍♂️";
	inline constexpr const char man_cartwheeling_medium_light_skin_tone[] = "🤸🏼‍♂️";
	inline constexpr const char man_cartwheeling_tone3[] = "🤸🏽‍♂️";
	inline constexpr const char man_cartwheeling_medium_skin_tone[] = "🤸🏽‍♂️";
	inline constexpr const char man_cartwheeling_tone4[] = "🤸🏾‍♂️";
	inline constexpr const char man_cartwheeling_medium_dark_skin_tone[] = "🤸🏾‍♂️";
	inline constexpr const char man_cartwheeling_tone5[] = "🤸🏿‍♂️";
	inline constexpr const char man_cartwheeling_dark_skin_tone[] = "🤸🏿‍♂️";
	inline constexpr const char person_bouncing_ball[] = "⛹️";
	inline constexpr const char basketball_player[] = "⛹️";
	inline constexpr const char person_with_ball[] = "⛹️";
	inline constexpr const char person_bouncing_ball_tone1[] = "⛹🏻";
	inline constexpr const char basketball_player_tone1[] = "⛹🏻";
	inline constexpr const char person_with_ball_tone1[] = "⛹🏻";
	inline constexpr const char person_bouncing_ball_tone2[] = "⛹🏼";
	inline constexpr const char basketball_player_tone2[] = "⛹🏼";
	inline constexpr const char person_with_ball_tone2[] = "⛹🏼";
	inline constexpr const char person_bouncing_ball_tone3[] = "⛹🏽";
	inline constexpr const char basketball_player_tone3[] = "⛹🏽";
	inline constexpr const char person_with_ball_tone3[] = "⛹🏽";
	inline constexpr const char person_bouncing_ball_tone4[] = "⛹🏾";
	inline constexpr const char basketball_player_tone4[] = "⛹🏾";
	inline constexpr const char person_with_ball_tone4[] = "⛹🏾";
	inline constexpr const char person_bouncing_ball_tone5[] = "⛹🏿";
	inline constexpr const char basketball_player_tone5[] = "⛹🏿";
	inline constexpr const char person_with_ball_tone5[] = "⛹🏿";
	inline constexpr const char woman_bouncing_ball[] = "⛹️‍♀️";
	inline constexpr const char woman_bouncing_ball_tone1[] = "⛹🏻‍♀️";
	inline constexpr const char woman_bouncing_ball_light_skin_tone[] = "⛹🏻‍♀️";
	inline constexpr const char woman_bouncing_ball_tone2[] = "⛹🏼‍♀️";
	inline constexpr const char woman_bouncing_ball_medium_light_skin_tone[] = "⛹🏼‍♀️";
	inline constexpr const char woman_bouncing_ball_tone3[] = "⛹🏽‍♀️";
	inline constexpr const char woman_bouncing_ball_medium_skin_tone[] = "⛹🏽‍♀️";
	inline constexpr const char woman_bouncing_ball_tone4[] = "⛹🏾‍♀️";
	inline constexpr const char woman_bouncing_ball_medium_dark_skin_tone[] = "⛹🏾‍♀️";
	inline constexpr const char woman_bouncing_ball_tone5[] = "⛹🏿‍♀️";
	inline constexpr const char woman_bouncing_ball_dark_skin_tone[] = "⛹🏿‍♀️";
	inline constexpr const char man_bouncing_ball[] = "⛹️‍♂️";
	inline constexpr const char man_bouncing_ball_tone1[] = "⛹🏻‍♂️";
	inline constexpr const char man_bouncing_ball_light_skin_tone[] = "⛹🏻‍♂️";
	inline constexpr const char man_bouncing_ball_tone2[] = "⛹🏼‍♂️";
	inline constexpr const char man_bouncing_ball_medium_light_skin_tone[] = "⛹🏼‍♂️";
	inline constexpr const char man_bouncing_ball_tone3[] = "⛹🏽‍♂️";
	inline constexpr const char man_bouncing_ball_medium_skin_tone[] = "⛹🏽‍♂️";
	inline constexpr const char man_bouncing_ball_tone4[] = "⛹🏾‍♂️";
	inline constexpr const char man_bouncing_ball_medium_dark_skin_tone[] = "⛹🏾‍♂️";
	inline constexpr const char man_bouncing_ball_tone5[] = "⛹🏿‍♂️";
	inline constexpr const char man_bouncing_ball_dark_skin_tone[] = "⛹🏿‍♂️";
	inline constexpr const char person_fencing[] = "🤺";
	inline constexpr const char fencer[] = "🤺";
	inline constexpr const char fencing[] = "🤺";
	inline constexpr const char person_playing_handball[] = "🤾";
	inline constexpr const char handball[] = "🤾";
	inline constexpr const char person_playing_handball_tone1[] = "🤾🏻";
	inline constexpr const char handball_tone1[] = "🤾🏻";
	inline constexpr const char person_playing_handball_tone2[] = "🤾🏼";
	inline constexpr const char handball_tone2[] = "🤾🏼";
	inline constexpr const char person_playing_handball_tone3[] = "🤾🏽";
	inline constexpr const char handball_tone3[] = "🤾🏽";
	inline constexpr const char person_playing_handball_tone4[] = "🤾🏾";
	inline constexpr const char handball_tone4[] = "🤾🏾";
	inline constexpr const char person_playing_handball_tone5[] = "🤾🏿";
	inline constexpr const char handball_tone5[] = "🤾🏿";
	inline constexpr const char woman_playing_handball[] = "🤾‍♀️";
	inline constexpr const char woman_playing_handball_tone1[] = "🤾🏻‍♀️";
	inline constexpr const char woman_playing_handball_light_skin_tone[] = "🤾🏻‍♀️";
	inline constexpr const char woman_playing_handball_tone2[] = "🤾🏼‍♀️";
	inline constexpr const char woman_playing_handball_medium_light_skin_tone[] = "🤾🏼‍♀️";
	inline constexpr const char woman_playing_handball_tone3[] = "🤾🏽‍♀️";
	inline constexpr const char woman_playing_handball_medium_skin_tone[] = "🤾🏽‍♀️";
	inline constexpr const char woman_playing_handball_tone4[] = "🤾🏾‍♀️";
	inline constexpr const char woman_playing_handball_medium_dark_skin_tone[] = "🤾🏾‍♀️";
	inline constexpr const char woman_playing_handball_tone5[] = "🤾🏿‍♀️";
	inline constexpr const char woman_playing_handball_dark_skin_tone[] = "🤾🏿‍♀️";
	inline constexpr const char man_playing_handball[] = "🤾‍♂️";
	inline constexpr const char man_playing_handball_tone1[] = "🤾🏻‍♂️";
	inline constexpr const char man_playing_handball_light_skin_tone[] = "🤾🏻‍♂️";
	inline constexpr const char man_playing_handball_tone2[] = "🤾🏼‍♂️";
	inline constexpr const char man_playing_handball_medium_light_skin_tone[] = "🤾🏼‍♂️";
	inline constexpr const char man_playing_handball_tone3[] = "🤾🏽‍♂️";
	inline constexpr const char man_playing_handball_medium_skin_tone[] = "🤾🏽‍♂️";
	inline constexpr const char man_playing_handball_tone4[] = "🤾🏾‍♂️";
	inline constexpr const char man_playing_handball_medium_dark_skin_tone[] = "🤾🏾‍♂️";
	inline constexpr const char man_playing_handball_tone5[] = "🤾🏿‍♂️";
	inline constexpr const char man_playing_handball_dark_skin_tone[] = "🤾🏿‍♂️";
	inline constexpr const char person_golfing[] = "🏌️";
	inline constexpr const char golfer[] = "🏌️";
	inline constexpr const char person_golfing_tone1[] = "🏌🏻";
	inline constexpr const char person_golfing_light_skin_tone[] = "🏌🏻";
	inline constexpr const char person_golfing_tone2[] = "🏌🏼";
	inline constexpr const char person_golfing_medium_light_skin_tone[] = "🏌🏼";
	inline constexpr const char person_golfing_tone3[] = "🏌🏽";
	inline constexpr const char person_golfing_medium_skin_tone[] = "🏌🏽";
	inline constexpr const char person_golfing_tone4[] = "🏌🏾";
	inline constexpr const char person_golfing_medium_dark_skin_tone[] = "🏌🏾";
	inline constexpr const char person_golfing_tone5[] = "🏌🏿";
	inline constexpr const char person_golfing_dark_skin_tone[] = "🏌🏿";
	inline constexpr const char woman_golfing[] = "🏌️‍♀️";
	inline constexpr const char woman_golfing_tone1[] = "🏌🏻‍♀️";
	inline constexpr const char woman_golfing_light_skin_tone[] = "🏌🏻‍♀️";
	inline constexpr const char woman_golfing_tone2[] = "🏌🏼‍♀️";
	inline constexpr const char woman_golfing_medium_light_skin_tone[] = "🏌🏼‍♀️";
	inline constexpr const char woman_golfing_tone3[] = "🏌🏽‍♀️";
	inline constexpr const char woman_golfing_medium_skin_tone[] = "🏌🏽‍♀️";
	inline constexpr const char woman_golfing_tone4[] = "🏌🏾‍♀️";
	inline constexpr const char woman_golfing_medium_dark_skin_tone[] = "🏌🏾‍♀️";
	inline constexpr const char woman_golfing_tone5[] = "🏌🏿‍♀️";
	inline constexpr const char woman_golfing_dark_skin_tone[] = "🏌🏿‍♀️";
	inline constexpr const char man_golfing[] = "🏌️‍♂️";
	inline constexpr const char man_golfing_tone1[] = "🏌🏻‍♂️";
	inline constexpr const char man_golfing_light_skin_tone[] = "🏌🏻‍♂️";
	inline constexpr const char man_golfing_tone2[] = "🏌🏼‍♂️";
	inline constexpr const char man_golfing_medium_light_skin_tone[] = "🏌🏼‍♂️";
	inline constexpr const char man_golfing_tone3[] = "🏌🏽‍♂️";
	inline constexpr const char man_golfing_medium_skin_tone[] = "🏌🏽‍♂️";
	inline constexpr const char man_golfing_tone4[] = "🏌🏾‍♂️";
	inline constexpr const char man_golfing_medium_dark_skin_tone[] = "🏌🏾‍♂️";
	inline constexpr const char man_golfing_tone5[] = "🏌🏿‍♂️";
	inline constexpr const char man_golfing_dark_skin_tone[] = "🏌🏿‍♂️";
	inline constexpr const char horse_racing[] = "🏇";
	inline constexpr const char horse_racing_tone1[] = "🏇🏻";
	inline constexpr const char horse_racing_tone2[] = "🏇🏼";
	inline constexpr const char horse_racing_tone3[] = "🏇🏽";
	inline constexpr const char horse_racing_tone4[] = "🏇🏾";
	inline constexpr const char horse_racing_tone5[] = "🏇🏿";
	inline constexpr const char person_in_lotus_position[] = "🧘";
	inline constexpr const char person_in_lotus_position_tone1[] = "🧘🏻";
	inline constexpr const char person_in_lotus_position_light_skin_tone[] = "🧘🏻";
	inline constexpr const char person_in_lotus_position_tone2[] = "🧘🏼";
	inline constexpr const char person_in_lotus_position_medium_light_skin_tone[] = "🧘🏼";
	inline constexpr const char person_in_lotus_position_tone3[] = "🧘🏽";
	inline constexpr const char person_in_lotus_position_medium_skin_tone[] = "🧘🏽";
	inline constexpr const char person_in_lotus_position_tone4[] = "🧘🏾";
	inline constexpr const char person_in_lotus_position_medium_dark_skin_tone[] = "🧘🏾";
	inline constexpr const char person_in_lotus_position_tone5[] = "🧘🏿";
	inline constexpr const char person_in_lotus_position_dark_skin_tone[] = "🧘🏿";
	inline constexpr const char woman_in_lotus_position[] = "🧘‍♀️";
	inline constexpr const char woman_in_lotus_position_tone1[] = "🧘🏻‍♀️";
	inline constexpr const char woman_in_lotus_position_light_skin_tone[] = "🧘🏻‍♀️";
	inline constexpr const char woman_in_lotus_position_tone2[] = "🧘🏼‍♀️";
	inline constexpr const char woman_in_lotus_position_medium_light_skin_tone[] = "🧘🏼‍♀️";
	inline constexpr const char woman_in_lotus_position_tone3[] = "🧘🏽‍♀️";
	inline constexpr const char woman_in_lotus_position_medium_skin_tone[] = "🧘🏽‍♀️";
	inline constexpr const char woman_in_lotus_position_tone4[] = "🧘🏾‍♀️";
	inline constexpr const char woman_in_lotus_position_medium_dark_skin_tone[] = "🧘🏾‍♀️";
	inline constexpr const char woman_in_lotus_position_tone5[] = "🧘🏿‍♀️";
	inline constexpr const char woman_in_lotus_position_dark_skin_tone[] = "🧘🏿‍♀️";
	inline constexpr const char man_in_lotus_position[] = "🧘‍♂️";
	inline constexpr const char man_in_lotus_position_tone1[] = "🧘🏻‍♂️";
	inline constexpr const char man_in_lotus_position_light_skin_tone[] = "🧘🏻‍♂️";
	inline constexpr const char man_in_lotus_position_tone2[] = "🧘🏼‍♂️";
	inline constexpr const char man_in_lotus_position_medium_light_skin_tone[] = "🧘🏼‍♂️";
	inline constexpr const char man_in_lotus_position_tone3[] = "🧘🏽‍♂️";
	inline constexpr const char man_in_lotus_position_medium_skin_tone[] = "🧘🏽‍♂️";
	inline constexpr const char man_in_lotus_position_tone4[] = "🧘🏾‍♂️";
	inline constexpr const char man_in_lotus_position_medium_dark_skin_tone[] = "🧘🏾‍♂️";
	inline constexpr const char man_in_lotus_position_tone5[] = "🧘🏿‍♂️";
	inline constexpr const char man_in_lotus_position_dark_skin_tone[] = "🧘🏿‍♂️";
	inline constexpr const char person_surfing[] = "🏄";
	inline constexpr const char surfer[] = "🏄";
	inline constexpr const char person_surfing_tone1[] = "🏄🏻";
	inline constexpr const char surfer_tone1[] = "🏄🏻";
	inline constexpr const char person_surfing_tone2[] = "🏄🏼";
	inline constexpr const char surfer_tone2[] = "🏄🏼";
	inline constexpr const char person_surfing_tone3[] = "🏄🏽";
	inline constexpr const char surfer_tone3[] = "🏄🏽";
	inline constexpr const char person_surfing_tone4[] = "🏄🏾";
	inline constexpr const char surfer_tone4[] = "🏄🏾";
	inline constexpr const char person_surfing_tone5[] = "🏄🏿";
	inline constexpr const char surfer_tone5[] = "🏄🏿";
	inline constexpr const char woman_surfing[] = "🏄‍♀️";
	inline constexpr const char woman_surfing_tone1[] = "🏄🏻‍♀️";
	inline constexpr const char woman_surfing_light_skin_tone[] = "🏄🏻‍♀️";
	inline constexpr const char woman_surfing_tone2[] = "🏄🏼‍♀️";
	inline constexpr const char woman_surfing_medium_light_skin_tone[] = "🏄🏼‍♀️";
	inline constexpr const char woman_surfing_tone3[] = "🏄🏽‍♀️";
	inline constexpr const char woman_surfing_medium_skin_tone[] = "🏄🏽‍♀️";
	inline constexpr const char woman_surfing_tone4[] = "🏄🏾‍♀️";
	inline constexpr const char woman_surfing_medium_dark_skin_tone[] = "🏄🏾‍♀️";
	inline constexpr const char woman_surfing_tone5[] = "🏄🏿‍♀️";
	inline constexpr const char woman_surfing_dark_skin_tone[] = "🏄🏿‍♀️";
	inline constexpr const char man_surfing[] = "🏄‍♂️";
	inline constexpr const char man_surfing_tone1[] = "🏄🏻‍♂️";
	inline constexpr const char man_surfing_light_skin_tone[] = "🏄🏻‍♂️";
	inline constexpr const char man_surfing_tone2[] = "🏄🏼‍♂️";
	inline constexpr const char man_surfing_medium_light_skin_tone[] = "🏄🏼‍♂️";
	inline constexpr const char man_surfing_tone3[] = "🏄🏽‍♂️";
	inline constexpr const char man_surfing_medium_skin_tone[] = "🏄🏽‍♂️";
	inline constexpr const char man_surfing_tone4[] = "🏄🏾‍♂️";
	inline constexpr const char man_surfing_medium_dark_skin_tone[] = "🏄🏾‍♂️";
	inline constexpr const char man_surfing_tone5[] = "🏄🏿‍♂️";
	inline constexpr const char man_surfing_dark_skin_tone[] = "🏄🏿‍♂️";
	inline constexpr const char person_swimming[] = "🏊";
	inline constexpr const char swimmer[] = "🏊";
	inline constexpr const char person_swimming_tone1[] = "🏊🏻";
	inline constexpr const char swimmer_tone1[] = "🏊🏻";
	inline constexpr const char person_swimming_tone2[] = "🏊🏼";
	inline constexpr const char swimmer_tone2[] = "🏊🏼";
	inline constexpr const char person_swimming_tone3[] = "🏊🏽";
	inline constexpr const char swimmer_tone3[] = "🏊🏽";
	inline constexpr const char person_swimming_tone4[] = "🏊🏾";
	inline constexpr const char swimmer_tone4[] = "🏊🏾";
	inline constexpr const char person_swimming_tone5[] = "🏊🏿";
	inline constexpr const char swimmer_tone5[] = "🏊🏿";
	inline constexpr const char woman_swimming[] = "🏊‍♀️";
	inline constexpr const char woman_swimming_tone1[] = "🏊🏻‍♀️";
	inline constexpr const char woman_swimming_light_skin_tone[] = "🏊🏻‍♀️";
	inline constexpr const char woman_swimming_tone2[] = "🏊🏼‍♀️";
	inline constexpr const char woman_swimming_medium_light_skin_tone[] = "🏊🏼‍♀️";
	inline constexpr const char woman_swimming_tone3[] = "🏊🏽‍♀️";
	inline constexpr const char woman_swimming_medium_skin_tone[] = "🏊🏽‍♀️";
	inline constexpr const char woman_swimming_tone4[] = "🏊🏾‍♀️";
	inline constexpr const char woman_swimming_medium_dark_skin_tone[] = "🏊🏾‍♀️";
	inline constexpr const char woman_swimming_tone5[] = "🏊🏿‍♀️";
	inline constexpr const char woman_swimming_dark_skin_tone[] = "🏊🏿‍♀️";
	inline constexpr const char man_swimming[] = "🏊‍♂️";
	inline constexpr const char man_swimming_tone1[] = "🏊🏻‍♂️";
	inline constexpr const char man_swimming_light_skin_tone[] = "🏊🏻‍♂️";
	inline constexpr const char man_swimming_tone2[] = "🏊🏼‍♂️";
	inline constexpr const char man_swimming_medium_light_skin_tone[] = "🏊🏼‍♂️";
	inline constexpr const char man_swimming_tone3[] = "🏊🏽‍♂️";
	inline constexpr const char man_swimming_medium_skin_tone[] = "🏊🏽‍♂️";
	inline constexpr const char man_swimming_tone4[] = "🏊🏾‍♂️";
	inline constexpr const char man_swimming_medium_dark_skin_tone[] = "🏊🏾‍♂️";
	inline constexpr const char man_swimming_tone5[] = "🏊🏿‍♂️";
	inline constexpr const char man_swimming_dark_skin_tone[] = "🏊🏿‍♂️";
	inline constexpr const char person_playing_water_polo[] = "🤽";
	inline constexpr const char water_polo[] = "🤽";
	inline constexpr const char person_playing_water_polo_tone1[] = "🤽🏻";
	inline constexpr const char water_polo_tone1[] = "🤽🏻";
	inline constexpr const char person_playing_water_polo_tone2[] = "🤽🏼";
	inline constexpr const char water_polo_tone2[] = "🤽🏼";
	inline constexpr const char person_playing_water_polo_tone3[] = "🤽🏽";
	inline constexpr const char water_polo_tone3[] = "🤽🏽";
	inline constexpr const char person_playing_water_polo_tone4[] = "🤽🏾";
	inline constexpr const char water_polo_tone4[] = "🤽🏾";
	inline constexpr const char person_playing_water_polo_tone5[] = "🤽🏿";
	inline constexpr const char water_polo_tone5[] = "🤽🏿";
	inline constexpr const char woman_playing_water_polo[] = "🤽‍♀️";
	inline constexpr const char woman_playing_water_polo_tone1[] = "🤽🏻‍♀️";
	inline constexpr const char woman_playing_water_polo_light_skin_tone[] = "🤽🏻‍♀️";
	inline constexpr const char woman_playing_water_polo_tone2[] = "🤽🏼‍♀️";
	inline constexpr const char woman_playing_water_polo_medium_light_skin_tone[] = "🤽🏼‍♀️";
	inline constexpr const char woman_playing_water_polo_tone3[] = "🤽🏽‍♀️";
	inline constexpr const char woman_playing_water_polo_medium_skin_tone[] = "🤽🏽‍♀️";
	inline constexpr const char woman_playing_water_polo_tone4[] = "🤽🏾‍♀️";
	inline constexpr const char woman_playing_water_polo_medium_dark_skin_tone[] = "🤽🏾‍♀️";
	inline constexpr const char woman_playing_water_polo_tone5[] = "🤽🏿‍♀️";
	inline constexpr const char woman_playing_water_polo_dark_skin_tone[] = "🤽🏿‍♀️";
	inline constexpr const char man_playing_water_polo[] = "🤽‍♂️";
	inline constexpr const char man_playing_water_polo_tone1[] = "🤽🏻‍♂️";
	inline constexpr const char man_playing_water_polo_light_skin_tone[] = "🤽🏻‍♂️";
	inline constexpr const char man_playing_water_polo_tone2[] = "🤽🏼‍♂️";
	inline constexpr const char man_playing_water_polo_medium_light_skin_tone[] = "🤽🏼‍♂️";
	inline constexpr const char man_playing_water_polo_tone3[] = "🤽🏽‍♂️";
	inline constexpr const char man_playing_water_polo_medium_skin_tone[] = "🤽🏽‍♂️";
	inline constexpr const char man_playing_water_polo_tone4[] = "🤽🏾‍♂️";
	inline constexpr const char man_playing_water_polo_medium_dark_skin_tone[] = "🤽🏾‍♂️";
	inline constexpr const char man_playing_water_polo_tone5[] = "🤽🏿‍♂️";
	inline constexpr const char man_playing_water_polo_dark_skin_tone[] = "🤽🏿‍♂️";
	inline constexpr const char person_rowing_boat[] = "🚣";
	inline constexpr const char rowboat[] = "🚣";
	inline constexpr const char person_rowing_boat_tone1[] = "🚣🏻";
	inline constexpr const char rowboat_tone1[] = "🚣🏻";
	inline constexpr const char person_rowing_boat_tone2[] = "🚣🏼";
	inline constexpr const char rowboat_tone2[] = "🚣🏼";
	inline constexpr const char person_rowing_boat_tone3[] = "🚣🏽";
	inline constexpr const char rowboat_tone3[] = "🚣🏽";
	inline constexpr const char person_rowing_boat_tone4[] = "🚣🏾";
	inline constexpr const char rowboat_tone4[] = "🚣🏾";
	inline constexpr const char person_rowing_boat_tone5[] = "🚣🏿";
	inline constexpr const char rowboat_tone5[] = "🚣🏿";
	inline constexpr const char woman_rowing_boat[] = "🚣‍♀️";
	inline constexpr const char woman_rowing_boat_tone1[] = "🚣🏻‍♀️";
	inline constexpr const char woman_rowing_boat_light_skin_tone[] = "🚣🏻‍♀️";
	inline constexpr const char woman_rowing_boat_tone2[] = "🚣🏼‍♀️";
	inline constexpr const char woman_rowing_boat_medium_light_skin_tone[] = "🚣🏼‍♀️";
	inline constexpr const char woman_rowing_boat_tone3[] = "🚣🏽‍♀️";
	inline constexpr const char woman_rowing_boat_medium_skin_tone[] = "🚣🏽‍♀️";
	inline constexpr const char woman_rowing_boat_tone4[] = "🚣🏾‍♀️";
	inline constexpr const char woman_rowing_boat_medium_dark_skin_tone[] = "🚣🏾‍♀️";
	inline constexpr const char woman_rowing_boat_tone5[] = "🚣🏿‍♀️";
	inline constexpr const char woman_rowing_boat_dark_skin_tone[] = "🚣🏿‍♀️";
	inline constexpr const char man_rowing_boat[] = "🚣‍♂️";
	inline constexpr const char man_rowing_boat_tone1[] = "🚣🏻‍♂️";
	inline constexpr const char man_rowing_boat_light_skin_tone[] = "🚣🏻‍♂️";
	inline constexpr const char man_rowing_boat_tone2[] = "🚣🏼‍♂️";
	inline constexpr const char man_rowing_boat_medium_light_skin_tone[] = "🚣🏼‍♂️";
	inline constexpr const char man_rowing_boat_tone3[] = "🚣🏽‍♂️";
	inline constexpr const char man_rowing_boat_medium_skin_tone[] = "🚣🏽‍♂️";
	inline constexpr const char man_rowing_boat_tone4[] = "🚣🏾‍♂️";
	inline constexpr const char man_rowing_boat_medium_dark_skin_tone[] = "🚣🏾‍♂️";
	inline constexpr const char man_rowing_boat_tone5[] = "🚣🏿‍♂️";
	inline constexpr const char man_rowing_boat_dark_skin_tone[] = "🚣🏿‍♂️";
	inline constexpr const char person_climbing[] = "🧗";
	inline constexpr const char person_climbing_tone1[] = "🧗🏻";
	inline constexpr const char person_climbing_light_skin_tone[] = "🧗🏻";
	inline constexpr const char person_climbing_tone2[] = "🧗🏼";
	inline constexpr const char person_climbing_medium_light_skin_tone[] = "🧗🏼";
	inline constexpr const char person_climbing_tone3[] = "🧗🏽";
	inline constexpr const char person_climbing_medium_skin_tone[] = "🧗🏽";
	inline constexpr const char person_climbing_tone4[] = "🧗🏾";
	inline constexpr const char person_climbing_medium_dark_skin_tone[] = "🧗🏾";
	inline constexpr const char person_climbing_tone5[] = "🧗🏿";
	inline constexpr const char person_climbing_dark_skin_tone[] = "🧗🏿";
	inline constexpr const char woman_climbing[] = "🧗‍♀️";
	inline constexpr const char woman_climbing_tone1[] = "🧗🏻‍♀️";
	inline constexpr const char woman_climbing_light_skin_tone[] = "🧗🏻‍♀️";
	inline constexpr const char woman_climbing_tone2[] = "🧗🏼‍♀️";
	inline constexpr const char woman_climbing_medium_light_skin_tone[] = "🧗🏼‍♀️";
	inline constexpr const char woman_climbing_tone3[] = "🧗🏽‍♀️";
	inline constexpr const char woman_climbing_medium_skin_tone[] = "🧗🏽‍♀️";
	inline constexpr const char woman_climbing_tone4[] = "🧗🏾‍♀️";
	inline constexpr const char woman_climbing_medium_dark_skin_tone[] = "🧗🏾‍♀️";
	inline constexpr const char woman_climbing_tone5[] = "🧗🏿‍♀️";
	inline constexpr const char woman_climbing_dark_skin_tone[] = "🧗🏿‍♀️";
	inline constexpr const char man_climbing[] = "🧗‍♂️";
	inline constexpr const char man_climbing_tone1[] = "🧗🏻‍♂️";
	inline constexpr const char man_climbing_light_skin_tone[] = "🧗🏻‍♂️";
	inline constexpr const char man_climbing_tone2[] = "🧗🏼‍♂️";
	inline constexpr const char man_climbing_medium_light_skin_tone[] = "🧗🏼‍♂️";
	inline constexpr const char man_climbing_tone3[] = "🧗🏽‍♂️";
	inline constexpr const char man_climbing_medium_skin_tone[] = "🧗🏽‍♂️";
	inline constexpr const char man_climbing_tone4[] = "🧗🏾‍♂️";
	inline constexpr const char man_climbing_medium_dark_skin_tone[] = "🧗🏾‍♂️";
	inline constexpr const char man_climbing_tone5[] = "🧗🏿‍♂️";
	inline constexpr const char man_climbing_dark_skin_tone[] = "🧗🏿‍♂️";
	inline constexpr const char person_mountain_biking[] = "🚵";
	inline constexpr const char mountain_bicyclist[] = "🚵";
	inline constexpr const char person_mountain_biking_tone1[] = "🚵🏻";
	inline constexpr const char mountain_bicyclist_tone1[] = "🚵🏻";
	inline constexpr const char person_mountain_biking_tone2[] = "🚵🏼";
	inline constexpr const char mountain_bicyclist_tone2[] = "🚵🏼";
	inline constexpr const char person_mountain_biking_tone3[] = "🚵🏽";
	inline constexpr const char mountain_bicyclist_tone3[] = "🚵🏽";
	inline constexpr const char person_mountain_biking_tone4[] = "🚵🏾";
	inline constexpr const char mountain_bicyclist_tone4[] = "🚵🏾";
	inline constexpr const char person_mountain_biking_tone5[] = "🚵🏿";
	inline constexpr const char mountain_bicyclist_tone5[] = "🚵🏿";
	inline constexpr const char woman_mountain_biking[] = "🚵‍♀️";
	inline constexpr const char woman_mountain_biking_tone1[] = "🚵🏻‍♀️";
	inline constexpr const char woman_mountain_biking_light_skin_tone[] = "🚵🏻‍♀️";
	inline constexpr const char woman_mountain_biking_tone2[] = "🚵🏼‍♀️";
	inline constexpr const char woman_mountain_biking_medium_light_skin_tone[] = "🚵🏼‍♀️";
	inline constexpr const char woman_mountain_biking_tone3[] = "🚵🏽‍♀️";
	inline constexpr const char woman_mountain_biking_medium_skin_tone[] = "🚵🏽‍♀️";
	inline constexpr const char woman_mountain_biking_tone4[] = "🚵🏾‍♀️";
	inline constexpr const char woman_mountain_biking_medium_dark_skin_tone[] = "🚵🏾‍♀️";
	inline constexpr const char woman_mountain_biking_tone5[] = "🚵🏿‍♀️";
	inline constexpr const char woman_mountain_biking_dark_skin_tone[] = "🚵🏿‍♀️";
	inline constexpr const char man_mountain_biking[] = "🚵‍♂️";
	inline constexpr const char man_mountain_biking_tone1[] = "🚵🏻‍♂️";
	inline constexpr const char man_mountain_biking_light_skin_tone[] = "🚵🏻‍♂️";
	inline constexpr const char man_mountain_biking_tone2[] = "🚵🏼‍♂️";
	inline constexpr const char man_mountain_biking_medium_light_skin_tone[] = "🚵🏼‍♂️";
	inline constexpr const char man_mountain_biking_tone3[] = "🚵🏽‍♂️";
	inline constexpr const char man_mountain_biking_medium_skin_tone[] = "🚵🏽‍♂️";
	inline constexpr const char man_mountain_biking_tone4[] = "🚵🏾‍♂️";
	inline constexpr const char man_mountain_biking_medium_dark_skin_tone[] = "🚵🏾‍♂️";
	inline constexpr const char man_mountain_biking_tone5[] = "🚵🏿‍♂️";
	inline constexpr const char man_mountain_biking_dark_skin_tone[] = "🚵🏿‍♂️";
	inline constexpr const char person_biking[] = "🚴";
	inline constexpr const char bicyclist[] = "🚴";
	inline constexpr const char person_biking_tone1[] = "🚴🏻";
	inline constexpr const char bicyclist_tone1[] = "🚴🏻";
	inline constexpr const char person_biking_tone2[] = "🚴🏼";
	inline constexpr const char bicyclist_tone2[] = "🚴🏼";
	inline constexpr const char person_biking_tone3[] = "🚴🏽";
	inline constexpr const char bicyclist_tone3[] = "🚴🏽";
	inline constexpr const char person_biking_tone4[] = "🚴🏾";
	inline constexpr const char bicyclist_tone4[] = "🚴🏾";
	inline constexpr const char person_biking_tone5[] = "🚴🏿";
	inline constexpr const char bicyclist_tone5[] = "🚴🏿";
	inline constexpr const char woman_biking[] = "🚴‍♀️";
	inline constexpr const char woman_biking_tone1[] = "🚴🏻‍♀️";
	inline constexpr const char woman_biking_light_skin_tone[] = "🚴🏻‍♀️";
	inline constexpr const char woman_biking_tone2[] = "🚴🏼‍♀️";
	inline constexpr const char woman_biking_medium_light_skin_tone[] = "🚴🏼‍♀️";
	inline constexpr const char woman_biking_tone3[] = "🚴🏽‍♀️";
	inline constexpr const char woman_biking_medium_skin_tone[] = "🚴🏽‍♀️";
	inline constexpr const char woman_biking_tone4[] = "🚴🏾‍♀️";
	inline constexpr const char woman_biking_medium_dark_skin_tone[] = "🚴🏾‍♀️";
	inline constexpr const char woman_biking_tone5[] = "🚴🏿‍♀️";
	inline constexpr const char woman_biking_dark_skin_tone[] = "🚴🏿‍♀️";
	inline constexpr const char man_biking[] = "🚴‍♂️";
	inline constexpr const char man_biking_tone1[] = "🚴🏻‍♂️";
	inline constexpr const char man_biking_light_skin_tone[] = "🚴🏻‍♂️";
	inline constexpr const char man_biking_tone2[] = "🚴🏼‍♂️";
	inline constexpr const char man_biking_medium_light_skin_tone[] = "🚴🏼‍♂️";
	inline constexpr const char man_biking_tone3[] = "🚴🏽‍♂️";
	inline constexpr const char man_biking_medium_skin_tone[] = "🚴🏽‍♂️";
	inline constexpr const char man_biking_tone4[] = "🚴🏾‍♂️";
	inline constexpr const char man_biking_medium_dark_skin_tone[] = "🚴🏾‍♂️";
	inline constexpr const char man_biking_tone5[] = "🚴🏿‍♂️";
	inline constexpr const char man_biking_dark_skin_tone[] = "🚴🏿‍♂️";
	inline constexpr const char trophy[] = "🏆";
	inline constexpr const char first_place[] = "🥇";
	inline constexpr const char first_place_medal[] = "🥇";
	inline constexpr const char second_place[] = "🥈";
	inline constexpr const char second_place_medal[] = "🥈";
	inline constexpr const char third_place[] = "🥉";
	inline constexpr const char third_place_medal[] = "🥉";
	inline constexpr const char medal[] = "🏅";
	inline constexpr const char sports_medal[] = "🏅";
	inline constexpr const char military_medal[] = "🎖️";
	inline constexpr const char rosette[] = "🏵️";
	inline constexpr const char reminder_ribbon[] = "🎗️";
	inline constexpr const char ticket[] = "🎫";
	inline constexpr const char tickets[] = "🎟️";
	inline constexpr const char admission_tickets[] = "🎟️";
	inline constexpr const char circus_tent[] = "🎪";
	inline constexpr const char person_juggling[] = "🤹";
	inline constexpr const char juggling[] = "🤹";
	inline constexpr const char juggler[] = "🤹";
	inline constexpr const char person_juggling_tone1[] = "🤹🏻";
	inline constexpr const char juggling_tone1[] = "🤹🏻";
	inline constexpr const char juggler_tone1[] = "🤹🏻";
	inline constexpr const char person_juggling_tone2[] = "🤹🏼";
	inline constexpr const char juggling_tone2[] = "🤹🏼";
	inline constexpr const char juggler_tone2[] = "🤹🏼";
	inline constexpr const char person_juggling_tone3[] = "🤹🏽";
	inline constexpr const char juggling_tone3[] = "🤹🏽";
	inline constexpr const char juggler_tone3[] = "🤹🏽";
	inline constexpr const char person_juggling_tone4[] = "🤹🏾";
	inline constexpr const char juggling_tone4[] = "🤹🏾";
	inline constexpr const char juggler_tone4[] = "🤹🏾";
	inline constexpr const char person_juggling_tone5[] = "🤹🏿";
	inline constexpr const char juggling_tone5[] = "🤹🏿";
	inline constexpr const char juggler_tone5[] = "🤹🏿";
	inline constexpr const char woman_juggling[] = "🤹‍♀️";
	inline constexpr const char woman_juggling_tone1[] = "🤹🏻‍♀️";
	inline constexpr const char woman_juggling_light_skin_tone[] = "🤹🏻‍♀️";
	inline constexpr const char woman_juggling_tone2[] = "🤹🏼‍♀️";
	inline constexpr const char woman_juggling_medium_light_skin_tone[] = "🤹🏼‍♀️";
	inline constexpr const char woman_juggling_tone3[] = "🤹🏽‍♀️";
	inline constexpr const char woman_juggling_medium_skin_tone[] = "🤹🏽‍♀️";
	inline constexpr const char woman_juggling_tone4[] = "🤹🏾‍♀️";
	inline constexpr const char woman_juggling_medium_dark_skin_tone[] = "🤹🏾‍♀️";
	inline constexpr const char woman_juggling_tone5[] = "🤹🏿‍♀️";
	inline constexpr const char woman_juggling_dark_skin_tone[] = "🤹🏿‍♀️";
	inline constexpr const char man_juggling[] = "🤹‍♂️";
	inline constexpr const char man_juggling_tone1[] = "🤹🏻‍♂️";
	inline constexpr const char man_juggling_light_skin_tone[] = "🤹🏻‍♂️";
	inline constexpr const char man_juggling_tone2[] = "🤹🏼‍♂️";
	inline constexpr const char man_juggling_medium_light_skin_tone[] = "🤹🏼‍♂️";
	inline constexpr const char man_juggling_tone3[] = "🤹🏽‍♂️";
	inline constexpr const char man_juggling_medium_skin_tone[] = "🤹🏽‍♂️";
	inline constexpr const char man_juggling_tone4[] = "🤹🏾‍♂️";
	inline constexpr const char man_juggling_medium_dark_skin_tone[] = "🤹🏾‍♂️";
	inline constexpr const char man_juggling_tone5[] = "🤹🏿‍♂️";
	inline constexpr const char man_juggling_dark_skin_tone[] = "🤹🏿‍♂️";
	inline constexpr const char performing_arts[] = "🎭";
	inline constexpr const char ballet_shoes[] = "🩰";
	inline constexpr const char art[] = "🎨";
	inline constexpr const char clapper[] = "🎬";
	inline constexpr const char clapper_board[] = "🎬";
	inline constexpr const char microphone[] = "🎤";
	inline constexpr const char headphones[] = "🎧";
	inline constexpr const char headphone[] = "🎧";
	inline constexpr const char musical_score[] = "🎼";
	inline constexpr const char musical_keyboard[] = "🎹";
	inline constexpr const char maracas[] = "🪇";
	inline constexpr const char drum[] = "🥁";
	inline constexpr const char drum_with_drumsticks[] = "🥁";
	inline constexpr const char long_drum[] = "🪘";
	inline constexpr const char saxophone[] = "🎷";
	inline constexpr const char trumpet[] = "🎺";
	inline constexpr const char accordion[] = "🪗";
	inline constexpr const char guitar[] = "🎸";
	inline constexpr const char banjo[] = "🪕";
	inline constexpr const char violin[] = "🎻";
	inline constexpr const char flute[] = "🪈";
	inline constexpr const char game_die[] = "🎲";
	inline constexpr const char chess_pawn[] = "♟️";
	inline constexpr const char dart[] = "🎯";
	inline constexpr const char direct_hit[] = "🎯";
	inline constexpr const char bowling[] = "🎳";
	inline constexpr const char video_game[] = "🎮";
	inline constexpr const char slot_machine[] = "🎰";
	inline constexpr const char jigsaw[] = "🧩";
	inline constexpr const char puzzle_piece[] = "🧩";
	inline constexpr const char flag_white[] = "🏳️";
	inline constexpr const char flag_black[] = "🏴";
	inline constexpr const char pirate_flag[] = "🏴‍☠️";
	inline constexpr const char checkered_flag[] = "🏁";
	inline constexpr const char triangular_flag_on_post[] = "🚩";
	inline constexpr const char rainbow_flag[] = "🏳️‍🌈";
	inline constexpr const char gay_pride_flag[] = "🏳️‍🌈";
	inline constexpr const char transgender_flag[] = "🏳️‍⚧️";
	inline constexpr const char united_nations[] = "🇺🇳";
	inline constexpr const char flag_af[] = "🇦🇫";
	inline constexpr const char flag_ax[] = "🇦🇽";
	inline constexpr const char flag_al[] = "🇦🇱";
	inline constexpr const char flag_dz[] = "🇩🇿";
	inline constexpr const char flag_as[] = "🇦🇸";
	inline constexpr const char flag_ad[] = "🇦🇩";
	inline constexpr const char flag_ao[] = "🇦🇴";
	inline constexpr const char flag_ai[] = "🇦🇮";
	inline constexpr const char flag_aq[] = "🇦🇶";
	inline constexpr const char flag_ag[] = "🇦🇬";
	inline constexpr const char flag_ar[] = "🇦🇷";
	inline constexpr const char flag_am[] = "🇦🇲";
	inline constexpr const char flag_aw[] = "🇦🇼";
	inline constexpr const char flag_au[] = "🇦🇺";
	inline constexpr const char flag_at[] = "🇦🇹";
	inline constexpr const char flag_az[] = "🇦🇿";
	inline constexpr const char flag_bs[] = "🇧🇸";
	inline constexpr const char flag_bh[] = "🇧🇭";
	inline constexpr const char flag_bd[] = "🇧🇩";
	inline constexpr const char flag_bb[] = "🇧🇧";
	inline constexpr const char flag_by[] = "🇧🇾";
	inline constexpr const char flag_be[] = "🇧🇪";
	inline constexpr const char flag_bz[] = "🇧🇿";
	inline constexpr const char flag_bj[] = "🇧🇯";
	inline constexpr const char flag_bm[] = "🇧🇲";
	inline constexpr const char flag_bt[] = "🇧🇹";
	inline constexpr const char flag_bo[] = "🇧🇴";
	inline constexpr const char flag_ba[] = "🇧🇦";
	inline constexpr const char flag_bw[] = "🇧🇼";
	inline constexpr const char flag_br[] = "🇧🇷";
	inline constexpr const char flag_io[] = "🇮🇴";
	inline constexpr const char flag_vg[] = "🇻🇬";
	inline constexpr const char flag_bn[] = "🇧🇳";
	inline constexpr const char flag_bg[] = "🇧🇬";
	inline constexpr const char flag_bf[] = "🇧🇫";
	inline constexpr const char flag_bi[] = "🇧🇮";
	inline constexpr const char flag_kh[] = "🇰🇭";
	inline constexpr const char flag_cm[] = "🇨🇲";
	inline constexpr const char flag_ca[] = "🇨🇦";
	inline constexpr const char flag_ic[] = "🇮🇨";
	inline constexpr const char flag_cv[] = "🇨🇻";
	inline constexpr const char flag_bq[] = "🇧🇶";
	inline constexpr const char flag_ky[] = "🇰🇾";
	inline constexpr const char flag_cf[] = "🇨🇫";
	inline constexpr const char flag_td[] = "🇹🇩";
	inline constexpr const char flag_cl[] = "🇨🇱";
	inline constexpr const char flag_cn[] = "🇨🇳";
	inline constexpr const char flag_cx[] = "🇨🇽";
	inline constexpr const char flag_cc[] = "🇨🇨";
	inline constexpr const char flag_co[] = "🇨🇴";
	inline constexpr const char flag_km[] = "🇰🇲";
	inline constexpr const char flag_cg[] = "🇨🇬";
	inline constexpr const char flag_cd[] = "🇨🇩";
	inline constexpr const char flag_ck[] = "🇨🇰";
	inline constexpr const char flag_cr[] = "🇨🇷";
	inline constexpr const char flag_ci[] = "🇨🇮";
	inline constexpr const char flag_hr[] = "🇭🇷";
	inline constexpr const char flag_cu[] = "🇨🇺";
	inline constexpr const char flag_cw[] = "🇨🇼";
	inline constexpr const char flag_cy[] = "🇨🇾";
	inline constexpr const char flag_cz[] = "🇨🇿";
	inline constexpr const char flag_dk[] = "🇩🇰";
	inline constexpr const char flag_dj[] = "🇩🇯";
	inline constexpr const char flag_dm[] = "🇩🇲";
	inline constexpr const char flag_do[] = "🇩🇴";
	inline constexpr const char flag_ec[] = "🇪🇨";
	inline constexpr const char flag_eg[] = "🇪🇬";
	inline constexpr const char flag_sv[] = "🇸🇻";
	inline constexpr const char flag_gq[] = "🇬🇶";
	inline constexpr const char flag_er[] = "🇪🇷";
	inline constexpr const char flag_ee[] = "🇪🇪";
	inline constexpr const char flag_et[] = "🇪🇹";
	inline constexpr const char flag_eu[] = "🇪🇺";
	inline constexpr const char flag_fk[] = "🇫🇰";
	inline constexpr const char flag_fo[] = "🇫🇴";
	inline constexpr const char flag_fj[] = "🇫🇯";
	inline constexpr const char flag_fi[] = "🇫🇮";
	inline constexpr const char flag_fr[] = "🇫🇷";
	inline constexpr const char flag_gf[] = "🇬🇫";
	inline constexpr const char flag_pf[] = "🇵🇫";
	inline constexpr const char flag_tf[] = "🇹🇫";
	inline constexpr const char flag_ga[] = "🇬🇦";
	inline constexpr const char flag_gm[] = "🇬🇲";
	inline constexpr const char flag_ge[] = "🇬🇪";
	inline constexpr const char flag_de[] = "🇩🇪";
	inline constexpr const char flag_gh[] = "🇬🇭";
	inline constexpr const char flag_gi[] = "🇬🇮";
	inline constexpr const char flag_gr[] = "🇬🇷";
	inline constexpr const char flag_gl[] = "🇬🇱";
	inline constexpr const char flag_gd[] = "🇬🇩";
	inline constexpr const char flag_gp[] = "🇬🇵";
	inline constexpr const char flag_gu[] = "🇬🇺";
	inline constexpr const char flag_gt[] = "🇬🇹";
	inline constexpr const char flag_gg[] = "🇬🇬";
	inline constexpr const char flag_gn[] = "🇬🇳";
	inline constexpr const char flag_gw[] = "🇬🇼";
	inline constexpr const char flag_gy[] = "🇬🇾";
	inline constexpr const char flag_ht[] = "🇭🇹";
	inline constexpr const char flag_hn[] = "🇭🇳";
	inline constexpr const char flag_hk[] = "🇭🇰";
	inline constexpr const char flag_hu[] = "🇭🇺";
	inline constexpr const char flag_is[] = "🇮🇸";
	inline constexpr const char flag_in[] = "🇮🇳";
	inline constexpr const char flag_id[] = "🇮🇩";
	inline constexpr const char flag_ir[] = "🇮🇷";
	inline constexpr const char flag_iq[] = "🇮🇶";
	inline constexpr const char flag_ie[] = "🇮🇪";
	inline constexpr const char flag_im[] = "🇮🇲";
	inline constexpr const char flag_il[] = "🇮🇱";
	inline constexpr const char flag_it[] = "🇮🇹";
	inline constexpr const char flag_jm[] = "🇯🇲";
	inline constexpr const char flag_jp[] = "🇯🇵";
	inline constexpr const char crossed_flags[] = "🎌";
	inline constexpr const char flag_je[] = "🇯🇪";
	inline constexpr const char flag_jo[] = "🇯🇴";
	inline constexpr const char flag_kz[] = "🇰🇿";
	inline constexpr const char flag_ke[] = "🇰🇪";
	inline constexpr const char flag_ki[] = "🇰🇮";
	inline constexpr const char flag_xk[] = "🇽🇰";
	inline constexpr const char flag_kw[] = "🇰🇼";
	inline constexpr const char flag_kg[] = "🇰🇬";
	inline constexpr const char flag_la[] = "🇱🇦";
	inline constexpr const char flag_lv[] = "🇱🇻";
	inline constexpr const char flag_lb[] = "🇱🇧";
	inline constexpr const char flag_ls[] = "🇱🇸";
	inline constexpr const char flag_lr[] = "🇱🇷";
	inline constexpr const char flag_ly[] = "🇱🇾";
	inline constexpr const char flag_li[] = "🇱🇮";
	inline constexpr const char flag_lt[] = "🇱🇹";
	inline constexpr const char flag_lu[] = "🇱🇺";
	inline constexpr const char flag_mo[] = "🇲🇴";
	inline constexpr const char flag_mk[] = "🇲🇰";
	inline constexpr const char flag_mg[] = "🇲🇬";
	inline constexpr const char flag_mw[] = "🇲🇼";
	inline constexpr const char flag_my[] = "🇲🇾";
	inline constexpr const char flag_mv[] = "🇲🇻";
	inline constexpr const char flag_ml[] = "🇲🇱";
	inline constexpr const char flag_mt[] = "🇲🇹";
	inline constexpr const char flag_mh[] = "🇲🇭";
	inline constexpr const char flag_mq[] = "🇲🇶";
	inline constexpr const char flag_mr[] = "🇲🇷";
	inline constexpr const char flag_mu[] = "🇲🇺";
	inline constexpr const char flag_yt[] = "🇾🇹";
	inline constexpr const char flag_mx[] = "🇲🇽";
	inline constexpr const char flag_fm[] = "🇫🇲";
	inline constexpr const char flag_md[] = "🇲🇩";
	inline constexpr const char flag_mc[] = "🇲🇨";
	inline constexpr const char flag_mn[] = "🇲🇳";
	inline constexpr const char flag_me[] = "🇲🇪";
	inline constexpr const char flag_ms[] = "🇲🇸";
	inline constexpr const char flag_ma[] = "🇲🇦";
	inline constexpr const char flag_mz[] = "🇲🇿";
	inline constexpr const char flag_mm[] = "🇲🇲";
	inline constexpr const char flag_na[] = "🇳🇦";
	inline constexpr const char flag_nr[] = "🇳🇷";
	inline constexpr const char flag_np[] = "🇳🇵";
	inline constexpr const char flag_nl[] = "🇳🇱";
	inline constexpr const char flag_nc[] = "🇳🇨";
	inline constexpr const char flag_nz[] = "🇳🇿";
	inline constexpr const char flag_ni[] = "🇳🇮";
	inline constexpr const char flag_ne[] = "🇳🇪";
	inline constexpr const char flag_ng[] = "🇳🇬";
	inline constexpr const char flag_nu[] = "🇳🇺";
	inline constexpr const char flag_nf[] = "🇳🇫";
	inline constexpr const char flag_kp[] = "🇰🇵";
	inline constexpr const char flag_mp[] = "🇲🇵";
	inline constexpr const char flag_no[] = "🇳🇴";
	inline constexpr const char flag_om[] = "🇴🇲";
	inline constexpr const char flag_pk[] = "🇵🇰";
	inline constexpr const char flag_pw[] = "🇵🇼";
	inline constexpr const char flag_ps[] = "🇵🇸";
	inline constexpr const char flag_pa[] = "🇵🇦";
	inline constexpr const char flag_pg[] = "🇵🇬";
	inline constexpr const char flag_py[] = "🇵🇾";
	inline constexpr const char flag_pe[] = "🇵🇪";
	inline constexpr const char flag_ph[] = "🇵🇭";
	inline constexpr const char flag_pn[] = "🇵🇳";
	inline constexpr const char flag_pl[] = "🇵🇱";
	inline constexpr const char flag_pt[] = "🇵🇹";
	inline constexpr const char flag_pr[] = "🇵🇷";
	inline constexpr const char flag_qa[] = "🇶🇦";
	inline constexpr const char flag_re[] = "🇷🇪";
	inline constexpr const char flag_ro[] = "🇷🇴";
	inline constexpr const char flag_ru[] = "🇷🇺";
	inline constexpr const char flag_rw[] = "🇷🇼";
	inline constexpr const char flag_ws[] = "🇼🇸";
	inline constexpr const char flag_sm[] = "🇸🇲";
	inline constexpr const char flag_st[] = "🇸🇹";
	inline constexpr const char flag_sa[] = "🇸🇦";
	inline constexpr const char flag_sn[] = "🇸🇳";
	inline constexpr const char flag_rs[] = "🇷🇸";
	inline constexpr const char flag_sc[] = "🇸🇨";
	inline constexpr const char flag_sl[] = "🇸🇱";
	inline constexpr const char flag_sg[] = "🇸🇬";
	inline constexpr const char flag_sx[] = "🇸🇽";
	inline constexpr const char flag_sk[] = "🇸🇰";
	inline constexpr const char flag_si[] = "🇸🇮";
	inline constexpr const char flag_gs[] = "🇬🇸";
	inline constexpr const char flag_sb[] = "🇸🇧";
	inline constexpr const char flag_so[] = "🇸🇴";
	inline constexpr const char flag_za[] = "🇿🇦";
	inline constexpr const char flag_kr[] = "🇰🇷";
	inline constexpr const char flag_ss[] = "🇸🇸";
	inline constexpr const char flag_es[] = "🇪🇸";
	inline constexpr const char flag_lk[] = "🇱🇰";
	inline constexpr const char flag_bl[] = "🇧🇱";
	inline constexpr const char flag_sh[] = "🇸🇭";
	inline constexpr const char flag_kn[] = "🇰🇳";
	inline constexpr const char flag_lc[] = "🇱🇨";
	inline constexpr const char flag_pm[] = "🇵🇲";
	inline constexpr const char flag_vc[] = "🇻🇨";
	inline constexpr const char flag_sd[] = "🇸🇩";
	inline constexpr const char flag_sr[] = "🇸🇷";
	inline constexpr const char flag_sz[] = "🇸🇿";
	inline constexpr const char flag_se[] = "🇸🇪";
	inline constexpr const char flag_ch[] = "🇨🇭";
	inline constexpr const char flag_sy[] = "🇸🇾";
	inline constexpr const char flag_tw[] = "🇹🇼";
	inline constexpr const char flag_tj[] = "🇹🇯";
	inline constexpr const char flag_tz[] = "🇹🇿";
	inline constexpr const char flag_th[] = "🇹🇭";
	inline constexpr const char flag_tl[] = "🇹🇱";
	inline constexpr const char flag_tg[] = "🇹🇬";
	inline constexpr const char flag_tk[] = "🇹🇰";
	inline constexpr const char flag_to[] = "🇹🇴";
	inline constexpr const char flag_tt[] = "🇹🇹";
	inline constexpr const char flag_tn[] = "🇹🇳";
	inline constexpr const char flag_tr[] = "🇹🇷";
	inline constexpr const char flag_tm[] = "🇹🇲";
	inline constexpr const char flag_tc[] = "🇹🇨";
	inline constexpr const char flag_vi[] = "🇻🇮";
	inline constexpr const char flag_tv[] = "🇹🇻";
	inline constexpr const char flag_ug[] = "🇺🇬";
	inline constexpr const char flag_ua[] = "🇺🇦";
	inline constexpr const char flag_ae[] = "🇦🇪";
	inline constexpr const char flag_gb[] = "🇬🇧";
	inline constexpr const char england[] = "🏴󠁧󠁢󠁥󠁮󠁧󠁿";
	inline constexpr const char scotland[] = "🏴󠁧󠁢󠁳󠁣󠁴󠁿";
	inline constexpr const char wales[] = "🏴󠁧󠁢󠁷󠁬󠁳󠁿";
	inline constexpr const char flag_us[] = "🇺🇸";
	inline constexpr const char flag_uy[] = "🇺🇾";
	inline constexpr const char flag_uz[] = "🇺🇿";
	inline constexpr const char flag_vu[] = "🇻🇺";
	inline constexpr const char flag_va[] = "🇻🇦";
	inline constexpr const char flag_ve[] = "🇻🇪";
	inline constexpr const char flag_vn[] = "🇻🇳";
	inline constexpr const char flag_wf[] = "🇼🇫";
	inline constexpr const char flag_eh[] = "🇪🇭";
	inline constexpr const char flag_ye[] = "🇾🇪";
	inline constexpr const char flag_zm[] = "🇿🇲";
	inline constexpr const char flag_zw[] = "🇿🇼";
	inline constexpr const char flag_ac[] = "🇦🇨";
	inline constexpr const char flag_bv[] = "🇧🇻";
	inline constexpr const char flag_cp[] = "🇨🇵";
	inline constexpr const char flag_ea[] = "🇪🇦";
	inline constexpr const char flag_dg[] = "🇩🇬";
	inline constexpr const char flag_hm[] = "🇭🇲";
	inline constexpr const char flag_mf[] = "🇲🇫";
	inline constexpr const char flag_sj[] = "🇸🇯";
	inline constexpr const char flag_ta[] = "🇹🇦";
	inline constexpr const char flag_um[] = "🇺🇲";
	inline constexpr const char green_apple[] = "🍏";
	inline constexpr const char apple[] = "🍎";
	inline constexpr const char red_apple[] = "🍎";
	inline constexpr const char pear[] = "🍐";
	inline constexpr const char tangerine[] = "🍊";
	inline constexpr const char lemon[] = "🍋";
	inline constexpr const char banana[] = "🍌";
	inline constexpr const char watermelon[] = "🍉";
	inline constexpr const char grapes[] = "🍇";
	inline constexpr const char strawberry[] = "🍓";
	inline constexpr const char blueberries[] = "🫐";
	inline constexpr const char melon[] = "🍈";
	inline constexpr const char cherries[] = "🍒";
	inline constexpr const char peach[] = "🍑";
	inline constexpr const char mango[] = "🥭";
	inline constexpr const char pineapple[] = "🍍";
	inline constexpr const char coconut[] = "🥥";
	inline constexpr const char kiwi[] = "🥝";
	inline constexpr const char kiwifruit[] = "🥝";
	inline constexpr const char kiwi_fruit[] = "🥝";
	inline constexpr const char tomato[] = "🍅";
	inline constexpr const char eggplant[] = "🍆";
	inline constexpr const char avocado[] = "🥑";
	inline constexpr const char pea_pod[] = "🫛";
	inline constexpr const char broccoli[] = "🥦";
	inline constexpr const char leafy_green[] = "🥬";
	inline constexpr const char cucumber[] = "🥒";
	inline constexpr const char hot_pepper[] = "🌶️";
	inline constexpr const char bell_pepper[] = "🫑";
	inline constexpr const char corn[] = "🌽";
	inline constexpr const char ear_of_corn[] = "🌽";
	inline constexpr const char carrot[] = "🥕";
	inline constexpr const char olive[] = "🫒";
	inline constexpr const char garlic[] = "🧄";
	inline constexpr const char onion[] = "🧅";
	inline constexpr const char potato[] = "🥔";
	inline constexpr const char sweet_potato[] = "🍠";
	inline constexpr const char ginger_root[] = "🫚";
	inline constexpr const char croissant[] = "🥐";
	inline constexpr const char bagel[] = "🥯";
	inline constexpr const char bread[] = "🍞";
	inline constexpr const char french_bread[] = "🥖";
	inline constexpr const char baguette_bread[] = "🥖";
	inline constexpr const char pretzel[] = "🥨";
	inline constexpr const char cheese[] = "🧀";
	inline constexpr const char cheese_wedge[] = "🧀";
	inline constexpr const char egg[] = "🥚";
	inline constexpr const char cooking[] = "🍳";
	inline constexpr const char butter[] = "🧈";
	inline constexpr const char pancakes[] = "🥞";
	inline constexpr const char waffle[] = "🧇";
	inline constexpr const char bacon[] = "🥓";
	inline constexpr const char cut_of_meat[] = "🥩";
	inline constexpr const char poultry_leg[] = "🍗";
	inline constexpr const char meat_on_bone[] = "🍖";
	inline constexpr const char bone[] = "🦴";
	inline constexpr const char hotdog[] = "🌭";
	inline constexpr const char hot_dog[] = "🌭";
	inline constexpr const char hamburger[] = "🍔";
	inline constexpr const char fries[] = "🍟";
	inline constexpr const char french_fries[] = "🍟";
	inline constexpr const char pizza[] = "🍕";
	inline constexpr const char flatbread[] = "🫓";
	inline constexpr const char sandwich[] = "🥪";
	inline constexpr const char stuffed_flatbread[] = "🥙";
	inline constexpr const char stuffed_pita[] = "🥙";
	inline constexpr const char falafel[] = "🧆";
	inline constexpr const char taco[] = "🌮";
	inline constexpr const char burrito[] = "🌯";
	inline constexpr const char tamale[] = "🫔";
	inline constexpr const char salad[] = "🥗";
	inline constexpr const char green_salad[] = "🥗";
	inline constexpr const char shallow_pan_of_food[] = "🥘";
	inline constexpr const char paella[] = "🥘";
	inline constexpr const char fondue[] = "🫕";
	inline constexpr const char canned_food[] = "🥫";
	inline constexpr const char jar[] = "🫙";
	inline constexpr const char spaghetti[] = "🍝";
	inline constexpr const char ramen[] = "🍜";
	inline constexpr const char steaming_bowl[] = "🍜";
	inline constexpr const char stew[] = "🍲";
	inline constexpr const char pot_of_food[] = "🍲";
	inline constexpr const char curry[] = "🍛";
	inline constexpr const char curry_rice[] = "🍛";
	inline constexpr const char sushi[] = "🍣";
	inline constexpr const char bento[] = "🍱";
	inline constexpr const char bento_box[] = "🍱";
	inline constexpr const char dumpling[] = "🥟";
	inline constexpr const char oyster[] = "🦪";
	inline constexpr const char fried_shrimp[] = "🍤";
	inline constexpr const char rice_ball[] = "🍙";
	inline constexpr const char rice[] = "🍚";
	inline constexpr const char cooked_rice[] = "🍚";
	inline constexpr const char rice_cracker[] = "🍘";
	inline constexpr const char fish_cake[] = "🍥";
	inline constexpr const char fortune_cookie[] = "🥠";
	inline constexpr const char moon_cake[] = "🥮";
	inline constexpr const char oden[] = "🍢";
	inline constexpr const char dango[] = "🍡";
	inline constexpr const char shaved_ice[] = "🍧";
	inline constexpr const char ice_cream[] = "🍨";
	inline constexpr const char icecream[] = "🍦";
	inline constexpr const char pie[] = "🥧";
	inline constexpr const char cupcake[] = "🧁";
	inline constexpr const char cake[] = "🍰";
	inline constexpr const char shortcake[] = "🍰";
	inline constexpr const char birthday[] = "🎂";
	inline constexpr const char birthday_cake[] = "🎂";
	inline constexpr const char custard[] = "🍮";
	inline constexpr const char pudding[] = "🍮";
	inline constexpr const char flan[] = "🍮";
	inline constexpr const char lollipop[] = "🍭";
	inline constexpr const char candy[] = "🍬";
	inline constexpr const char chocolate_bar[] = "🍫";
	inline constexpr const char popcorn[] = "🍿";
	inline constexpr const char doughnut[] = "🍩";
	inline constexpr const char cookie[] = "🍪";
	inline constexpr const char chestnut[] = "🌰";
	inline constexpr const char peanuts[] = "🥜";
	inline constexpr const char shelled_peanut[] = "🥜";
	inline constexpr const char beans[] = "🫘";
	inline constexpr const char honey_pot[] = "🍯";
	inline constexpr const char milk[] = "🥛";
	inline constexpr const char glass_of_milk[] = "🥛";
	inline constexpr const char pouring_liquid[] = "🫗";
	inline constexpr const char baby_bottle[] = "🍼";
	inline constexpr const char teapot[] = "🫖";
	inline constexpr const char coffee[] = "☕";
	inline constexpr const char hot_beverage[] = "☕";
	inline constexpr const char tea[] = "🍵";
	inline constexpr const char mate[] = "🧉";
	inline constexpr const char beverage_box[] = "🧃";
	inline constexpr const char cup_with_straw[] = "🥤";
	inline constexpr const char bubble_tea[] = "🧋";
	inline constexpr const char sake[] = "🍶";
	inline constexpr const char beer[] = "🍺";
	inline constexpr const char beer_mug[] = "🍺";
	inline constexpr const char beers[] = "🍻";
	inline constexpr const char champagne_glass[] = "🥂";
	inline constexpr const char clinking_glass[] = "🥂";
	inline constexpr const char wine_glass[] = "🍷";
	inline constexpr const char tumbler_glass[] = "🥃";
	inline constexpr const char whisky[] = "🥃";
	inline constexpr const char cocktail[] = "🍸";
	inline constexpr const char tropical_drink[] = "🍹";
	inline constexpr const char champagne[] = "🍾";
	inline constexpr const char bottle_with_popping_cork[] = "🍾";
	inline constexpr const char ice_cube[] = "🧊";
	inline constexpr const char spoon[] = "🥄";
	inline constexpr const char fork_and_knife[] = "🍴";
	inline constexpr const char fork_knife_plate[] = "🍽️";
	inline constexpr const char fork_and_knife_with_plate[] = "🍽️";
	inline constexpr const char bowl_with_spoon[] = "🥣";
	inline constexpr const char takeout_box[] = "🥡";
	inline constexpr const char chopsticks[] = "🥢";
	inline constexpr const char salt[] = "🧂";
	inline constexpr const char dog[] = "🐶";
	inline constexpr const char dog_face[] = "🐶";
	inline constexpr const char cat[] = "🐱";
	inline constexpr const char cat_face[] = "🐱";
	inline constexpr const char mouse[] = "🐭";
	inline constexpr const char mouse_face[] = "🐭";
	inline constexpr const char hamster[] = "🐹";
	inline constexpr const char rabbit[] = "🐰";
	inline constexpr const char rabbit_face[] = "🐰";
	inline constexpr const char fox[] = "🦊";
	inline constexpr const char fox_face[] = "🦊";
	inline constexpr const char bear[] = "🐻";
	inline constexpr const char panda_face[] = "🐼";
	inline constexpr const char panda[] = "🐼";
	inline constexpr const char polar_bear[] = "🐻‍❄️";
	inline constexpr const char koala[] = "🐨";
	inline constexpr const char tiger[] = "🐯";
	inline constexpr const char tiger_face[] = "🐯";
	inline constexpr const char lion_face[] = "🦁";
	inline constexpr const char lion[] = "🦁";
	inline constexpr const char cow[] = "🐮";
	inline constexpr const char cow_face[] = "🐮";
	inline constexpr const char pig[] = "🐷";
	inline constexpr const char pig_face[] = "🐷";
	inline constexpr const char pig_nose[] = "🐽";
	inline constexpr const char frog[] = "🐸";
	inline constexpr const char monkey_face[] = "🐵";
	inline constexpr const char see_no_evil[] = "🙈";
	inline constexpr const char hear_no_evil[] = "🙉";
	inline constexpr const char speak_no_evil[] = "🙊";
	inline constexpr const char monkey[] = "🐒";
	inline constexpr const char chicken[] = "🐔";
	inline constexpr const char penguin[] = "🐧";
	inline constexpr const char bird[] = "🐦";
	inline constexpr const char baby_chick[] = "🐤";
	inline constexpr const char hatching_chick[] = "🐣";
	inline constexpr const char hatched_chick[] = "🐥";
	inline constexpr const char goose[] = "🪿";
	inline constexpr const char duck[] = "🦆";
	inline constexpr const char black_bird[] = "🐦‍⬛";
	inline constexpr const char eagle[] = "🦅";
	inline constexpr const char owl[] = "🦉";
	inline constexpr const char bat[] = "🦇";
	inline constexpr const char wolf[] = "🐺";
	inline constexpr const char boar[] = "🐗";
	inline constexpr const char horse[] = "🐴";
	inline constexpr const char horse_face[] = "🐴";
	inline constexpr const char unicorn[] = "🦄";
	inline constexpr const char unicorn_face[] = "🦄";
	inline constexpr const char moose[] = "🫎";
	inline constexpr const char bee[] = "🐝";
	inline constexpr const char honeybee[] = "🐝";
	inline constexpr const char worm[] = "🪱";
	inline constexpr const char bug[] = "🐛";
	inline constexpr const char butterfly[] = "🦋";
	inline constexpr const char snail[] = "🐌";
	inline constexpr const char lady_beetle[] = "🐞";
	inline constexpr const char ant[] = "🐜";
	inline constexpr const char fly[] = "🪰";
	inline constexpr const char beetle[] = "🪲";
	inline constexpr const char cockroach[] = "🪳";
	inline constexpr const char mosquito[] = "🦟";
	inline constexpr const char cricket[] = "🦗";
	inline constexpr const char spider[] = "🕷️";
	inline constexpr const char spider_web[] = "🕸️";
	inline constexpr const char scorpion[] = "🦂";
	inline constexpr const char turtle[] = "🐢";
	inline constexpr const char snake[] = "🐍";
	inline constexpr const char lizard[] = "🦎";
	inline constexpr const char t_rex[] = "🦖";
	inline constexpr const char sauropod[] = "🦕";
	inline constexpr const char octopus[] = "🐙";
	inline constexpr const char squid[] = "🦑";
	inline constexpr const char jellyfish[] = "🪼";
	inline constexpr const char shrimp[] = "🦐";
	inline constexpr const char lobster[] = "🦞";
	inline constexpr const char crab[] = "🦀";
	inline constexpr const char blowfish[] = "🐡";
	inline constexpr const char tropical_fish[] = "🐠";
	inline constexpr const char fish[] = "🐟";
	inline constexpr const char dolphin[] = "🐬";
	inline constexpr const char whale[] = "🐳";
	inline constexpr const char whale2[] = "🐋";
	inline constexpr const char shark[] = "🦈";
	inline constexpr const char seal[] = "🦭";
	inline constexpr const char crocodile[] = "🐊";
	inline constexpr const char tiger2[] = "🐅";
	inline constexpr const char leopard[] = "🐆";
	inline constexpr const char zebra[] = "🦓";
	inline constexpr const char gorilla[] = "🦍";
	inline constexpr const char orangutan[] = "🦧";
	inline constexpr const char mammoth[] = "🦣";
	inline constexpr const char elephant[] = "🐘";
	inline constexpr const char hippopotamus[] = "🦛";
	inline constexpr const char rhino[] = "🦏";
	inline constexpr const char rhinoceros[] = "🦏";
	inline constexpr const char dromedary_camel[] = "🐪";
	inline constexpr const char camel[] = "🐫";
	inline constexpr const char giraffe[] = "🦒";
	inline constexpr const char kangaroo[] = "🦘";
	inline constexpr const char bison[] = "🦬";
	inline constexpr const char water_buffalo[] = "🐃";
	inline constexpr const char ox[] = "🐂";
	inline constexpr const char cow2[] = "🐄";
	inline constexpr const char donkey[] = "🫏";
	inline constexpr const char racehorse[] = "🐎";
	inline constexpr const char pig2[] = "🐖";
	inline constexpr const char ram[] = "🐏";
	inline constexpr const char sheep[] = "🐑";
	inline constexpr const char ewe[] = "🐑";
	inline constexpr const char llama[] = "🦙";
	inline constexpr const char goat[] = "🐐";
	inline constexpr const char deer[] = "🦌";
	inline constexpr const char dog2[] = "🐕";
	inline constexpr const char poodle[] = "🐩";
	inline constexpr const char guide_dog[] = "🦮";
	inline constexpr const char service_dog[] = "🐕‍🦺";
	inline constexpr const char cat2[] = "🐈";
	inline constexpr const char black_cat[] = "🐈‍⬛";
	inline constexpr const char feather[] = "🪶";
	inline constexpr const char wing[] = "🪽";
	inline constexpr const char rooster[] = "🐓";
	inline constexpr const char turkey[] = "🦃";
	inline constexpr const char dodo[] = "🦤";
	inline constexpr const char peacock[] = "🦚";
	inline constexpr const char parrot[] = "🦜";
	inline constexpr const char swan[] = "🦢";
	inline constexpr const char flamingo[] = "🦩";
	inline constexpr const char dove[] = "🕊️";
	inline constexpr const char dove_of_peace[] = "🕊️";
	inline constexpr const char rabbit2[] = "🐇";
	inline constexpr const char raccoon[] = "🦝";
	inline constexpr const char skunk[] = "🦨";
	inline constexpr const char badger[] = "🦡";
	inline constexpr const char beaver[] = "🦫";
	inline constexpr const char otter[] = "🦦";
	inline constexpr const char sloth[] = "🦥";
	inline constexpr const char mouse2[] = "🐁";
	inline constexpr const char rat[] = "🐀";
	inline constexpr const char chipmunk[] = "🐿️";
	inline constexpr const char hedgehog[] = "🦔";
	inline constexpr const char feet[] = "🐾";
	inline constexpr const char paw_prints[] = "🐾";
	inline constexpr const char dragon[] = "🐉";
	inline constexpr const char dragon_face[] = "🐲";
	inline constexpr const char cactus[] = "🌵";
	inline constexpr const char christmas_tree[] = "🎄";
	inline constexpr const char evergreen_tree[] = "🌲";
	inline constexpr const char deciduous_tree[] = "🌳";
	inline constexpr const char palm_tree[] = "🌴";
	inline constexpr const char wood[] = "🪵";
	inline constexpr const char seedling[] = "🌱";
	inline constexpr const char herb[] = "🌿";
	inline constexpr const char shamrock[] = "☘️";
	inline constexpr const char four_leaf_clover[] = "🍀";
	inline constexpr const char bamboo[] = "🎍";
	inline constexpr const char potted_plant[] = "🪴";
	inline constexpr const char tanabata_tree[] = "🎋";
	inline constexpr const char leaves[] = "🍃";
	inline constexpr const char fallen_leaf[] = "🍂";
	inline constexpr const char maple_leaf[] = "🍁";
	inline constexpr const char nest_with_eggs[] = "🪺";
	inline constexpr const char empty_nest[] = "🪹";
	inline constexpr const char mushroom[] = "🍄";
	inline constexpr const char shell[] = "🐚";
	inline constexpr const char spiral_shell[] = "🐚";
	inline constexpr const char coral[] = "🪸";
	inline constexpr const char rock[] = "🪨";
	inline constexpr const char ear_of_rice[] = "🌾";
	inline constexpr const char sheaf_of_rice[] = "🌾";
	inline constexpr const char bouquet[] = "💐";
	inline constexpr const char tulip[] = "🌷";
	inline constexpr const char rose[] = "🌹";
	inline constexpr const char wilted_rose[] = "🥀";
	inline constexpr const char wilted_flower[] = "🥀";
	inline constexpr const char hyacinth[] = "🪻";
	inline constexpr const char lotus[] = "🪷";
	inline constexpr const char hibiscus[] = "🌺";
	inline constexpr const char cherry_blossom[] = "🌸";
	inline constexpr const char blossom[] = "🌼";
	inline constexpr const char sunflower[] = "🌻";
	inline constexpr const char sun_with_face[] = "🌞";
	inline constexpr const char full_moon_with_face[] = "🌝";
	inline constexpr const char first_quarter_moon_with_face[] = "🌛";
	inline constexpr const char last_quarter_moon_with_face[] = "🌜";
	inline constexpr const char new_moon_with_face[] = "🌚";
	inline constexpr const char new_moon_face[] = "🌚";
	inline constexpr const char full_moon[] = "🌕";
	inline constexpr const char waning_gibbous_moon[] = "🌖";
	inline constexpr const char last_quarter_moon[] = "🌗";
	inline constexpr const char waning_crescent_moon[] = "🌘";
	inline constexpr const char new_moon[] = "🌑";
	inline constexpr const char waxing_crescent_moon[] = "🌒";
	inline constexpr const char first_quarter_moon[] = "🌓";
	inline constexpr const char waxing_gibbous_moon[] = "🌔";
	inline constexpr const char crescent_moon[] = "🌙";
	inline constexpr const char earth_americas[] = "🌎";
	inline constexpr const char earth_africa[] = "🌍";
	inline constexpr const char earth_asia[] = "🌏";
	inline constexpr const char ringed_planet[] = "🪐";
	inline constexpr const char dizzy[] = "💫";
	inline constexpr const char star[] = "⭐";
	inline constexpr const char star2[] = "🌟";
	inline constexpr const char glowing_star[] = "🌟";
	inline constexpr const char sparkles[] = "✨";
	inline constexpr const char zap[] = "⚡";
	inline constexpr const char high_voltage[] = "⚡";
	inline constexpr const char comet[] = "☄️";
	inline constexpr const char boom[] = "💥";
	inline constexpr const char collision[] = "💥";
	inline constexpr const char fire[] = "🔥";
	inline constexpr const char flame[] = "🔥";
	inline constexpr const char cloud_tornado[] = "🌪️";
	inline constexpr const char cloud_with_tornado[] = "🌪️";
	inline constexpr const char tornado[] = "🌪️";
	inline constexpr const char rainbow[] = "🌈";
	inline constexpr const char sunny[] = "☀️";
	inline constexpr const char sun[] = "☀️";
	inline constexpr const char white_sun_small_cloud[] = "🌤️";
	inline constexpr const char white_sun_with_small_cloud[] = "🌤️";
	inline constexpr const char partly_sunny[] = "⛅";
	inline constexpr const char white_sun_cloud[] = "🌥️";
	inline constexpr const char white_sun_behind_cloud[] = "🌥️";
	inline constexpr const char cloud[] = "☁️";
	inline constexpr const char white_sun_rain_cloud[] = "🌦️";
	inline constexpr const char white_sun_behind_cloud_with_rain[] = "🌦️";
	inline constexpr const char cloud_rain[] = "🌧️";
	inline constexpr const char cloud_with_rain[] = "🌧️";
	inline constexpr const char thunder_cloud_rain[] = "⛈️";
	inline constexpr const char thunder_cloud_and_rain[] = "⛈️";
	inline constexpr const char cloud_lightning[] = "🌩️";
	inline constexpr const char cloud_with_lightning[] = "🌩️";
	inline constexpr const char cloud_snow[] = "🌨️";
	inline constexpr const char cloud_with_snow[] = "🌨️";
	inline constexpr const char snowflake[] = "❄️";
	inline constexpr const char snowman2[] = "☃️";
	inline constexpr const char snowman[] = "⛄";
	inline constexpr const char wind_blowing_face[] = "🌬️";
	inline constexpr const char wind_face[] = "🌬️";
	inline constexpr const char dash[] = "💨";
	inline constexpr const char dashing_away[] = "💨";
	inline constexpr const char droplet[] = "💧";
	inline constexpr const char sweat_drops[] = "💦";
	inline constexpr const char bubbles[] = "🫧";
	inline constexpr const char umbrella[] = "☔";
	inline constexpr const char umbrella2[] = "☂️";
	inline constexpr const char ocean[] = "🌊";
	inline constexpr const char water_wave[] = "🌊";
	inline constexpr const char fog[] = "🌫️";
	inline constexpr const char watch[] = "⌚";
	inline constexpr const char mobile_phone[] = "📱";
	inline constexpr const char iphone[] = "📱";
	inline constexpr const char calling[] = "📲";
	inline constexpr const char computer[] = "💻";
	inline constexpr const char keyboard[] = "⌨️";
	inline constexpr const char desktop[] = "🖥️";
	inline constexpr const char desktop_computer[] = "🖥️";
	inline constexpr const char printer[] = "🖨️";
	inline constexpr const char mouse_three_button[] = "🖱️";
	inline constexpr const char three_button_mouse[] = "🖱️";
	inline constexpr const char trackball[] = "🖲️";
	inline constexpr const char joystick[] = "🕹️";
	inline constexpr const char compression[] = "🗜️";
	inline constexpr const char clamp[] = "🗜️";
	inline constexpr const char minidisc[] = "💽";
	inline constexpr const char computer_disk[] = "💽";
	inline constexpr const char floppy_disk[] = "💾";
	inline constexpr const char cd[] = "💿";
	inline constexpr const char optical_disk[] = "💿";
	inline constexpr const char dvd[] = "📀";
	inline constexpr const char vhs[] = "📼";
	inline constexpr const char videocassette[] = "📼";
	inline constexpr const char camera[] = "📷";
	inline constexpr const char camera_with_flash[] = "📸";
	inline constexpr const char video_camera[] = "📹";
	inline constexpr const char movie_camera[] = "🎥";
	inline constexpr const char projector[] = "📽️";
	inline constexpr const char film_projector[] = "📽️";
	inline constexpr const char film_frames[] = "🎞️";
	inline constexpr const char telephone_receiver[] = "📞";
	inline constexpr const char telephone[] = "☎️";
	inline constexpr const char pager[] = "📟";
	inline constexpr const char fax[] = "📠";
	inline constexpr const char fax_machine[] = "📠";
	inline constexpr const char tv[] = "📺";
	inline constexpr const char television[] = "📺";
	inline constexpr const char radio[] = "📻";
	inline constexpr const char microphone2[] = "🎙️";
	inline constexpr const char studio_microphone[] = "🎙️";
	inline constexpr const char level_slider[] = "🎚️";
	inline constexpr const char control_knobs[] = "🎛️";
	inline constexpr const char compass[] = "🧭";
	inline constexpr const char stopwatch[] = "⏱️";
	inline constexpr const char timer[] = "⏲️";
	inline constexpr const char timer_clock[] = "⏲️";
	inline constexpr const char alarm_clock[] = "⏰";
	inline constexpr const char clock[] = "🕰️";
	inline constexpr const char mantlepiece_clock[] = "🕰️";
	inline constexpr const char hourglass[] = "⌛";
	inline constexpr const char hourglass_flowing_sand[] = "⏳";
	inline constexpr const char satellite[] = "📡";
	inline constexpr const char battery[] = "🔋";
	inline constexpr const char low_battery[] = "🪫";
	inline constexpr const char electric_plug[] = "🔌";
	inline constexpr const char bulb[] = "💡";
	inline constexpr const char light_bulb[] = "💡";
	inline constexpr const char flashlight[] = "🔦";
	inline constexpr const char candle[] = "🕯️";
	inline constexpr const char diya_lamp[] = "🪔";
	inline constexpr const char fire_extinguisher[] = "🧯";
	inline constexpr const char oil[] = "🛢️";
	inline constexpr const char oil_drum[] = "🛢️";
	inline constexpr const char money_with_wings[] = "💸";
	inline constexpr const char dollar[] = "💵";
	inline constexpr const char yen[] = "💴";
	inline constexpr const char yen_banknote[] = "💴";
	inline constexpr const char euro[] = "💶";
	inline constexpr const char euro_banknote[] = "💶";
	inline constexpr const char pound[] = "💷";
	inline constexpr const char coin[] = "🪙";
	inline constexpr const char moneybag[] = "💰";
	inline constexpr const char money_bag[] = "💰";
	inline constexpr const char credit_card[] = "💳";
	inline constexpr const char identification_card[] = "🪪";
	inline constexpr const char gem[] = "💎";
	inline constexpr const char gem_stone[] = "💎";
	inline constexpr const char scales[] = "⚖️";
	inline constexpr const char balance_scale[] = "⚖️";
	inline constexpr const char ladder[] = "🪜";
	inline constexpr const char toolbox[] = "🧰";
	inline constexpr const char screwdriver[] = "🪛";
	inline constexpr const char wrench[] = "🔧";
	inline constexpr const char hammer[] = "🔨";
	inline constexpr const char hammer_pick[] = "⚒️";
	inline constexpr const char hammer_and_pick[] = "⚒️";
	inline constexpr const char tools[] = "🛠️";
	inline constexpr const char hammer_and_wrench[] = "🛠️";
	inline constexpr const char pick[] = "⛏️";
	inline constexpr const char carpentry_saw[] = "🪚";
	inline constexpr const char nut_and_bolt[] = "🔩";
	inline constexpr const char gear[] = "⚙️";
	inline constexpr const char mouse_trap[] = "🪤";
	inline constexpr const char bricks[] = "🧱";
	inline constexpr const char brick[] = "🧱";
	inline constexpr const char chains[] = "⛓️";
	inline constexpr const char magnet[] = "🧲";
	inline constexpr const char gun[] = "🔫";
	inline constexpr const char pistol[] = "🔫";
	inline constexpr const char bomb[] = "💣";
	inline constexpr const char firecracker[] = "🧨";
	inline constexpr const char axe[] = "🪓";
	inline constexpr const char knife[] = "🔪";
	inline constexpr const char kitchen_knife[] = "🔪";
	inline constexpr const char dagger[] = "🗡️";
	inline constexpr const char dagger_knife[] = "🗡️";
	inline constexpr const char crossed_swords[] = "⚔️";
	inline constexpr const char shield[] = "🛡️";
	inline constexpr const char smoking[] = "🚬";
	inline constexpr const char cigarette[] = "🚬";
	inline constexpr const char coffin[] = "⚰️";
	inline constexpr const char headstone[] = "🪦";
	inline constexpr const char urn[] = "⚱️";
	inline constexpr const char funeral_urn[] = "⚱️";
	inline constexpr const char amphora[] = "🏺";
	inline constexpr const char crystal_ball[] = "🔮";
	inline constexpr const char prayer_beads[] = "📿";
	inline constexpr const char nazar_amulet[] = "🧿";
	inline constexpr const char hamsa[] = "🪬";
	inline constexpr const char barber[] = "💈";
	inline constexpr const char barber_pole[] = "💈";
	inline constexpr const char alembic[] = "⚗️";
	inline constexpr const char telescope[] = "🔭";
	inline constexpr const char microscope[] = "🔬";
	inline constexpr const char hole[] = "🕳️";
	inline constexpr const char x_ray[] = "🩻";
	inline constexpr const char adhesive_bandage[] = "🩹";
	inline constexpr const char stethoscope[] = "🩺";
	inline constexpr const char pill[] = "💊";
	inline constexpr const char syringe[] = "💉";
	inline constexpr const char drop_of_blood[] = "🩸";
	inline constexpr const char dna[] = "🧬";
	inline constexpr const char microbe[] = "🦠";
	inline constexpr const char petri_dish[] = "🧫";
	inline constexpr const char test_tube[] = "🧪";
	inline constexpr const char thermometer[] = "🌡️";
	inline constexpr const char broom[] = "🧹";
	inline constexpr const char plunger[] = "🪠";
	inline constexpr const char basket[] = "🧺";
	inline constexpr const char roll_of_paper[] = "🧻";
	inline constexpr const char toilet[] = "🚽";
	inline constexpr const char potable_water[] = "🚰";
	inline constexpr const char shower[] = "🚿";
	inline constexpr const char bathtub[] = "🛁";
	inline constexpr const char bath[] = "🛀";
	inline constexpr const char bath_tone1[] = "🛀🏻";
	inline constexpr const char bath_tone2[] = "🛀🏼";
	inline constexpr const char bath_tone3[] = "🛀🏽";
	inline constexpr const char bath_tone4[] = "🛀🏾";
	inline constexpr const char bath_tone5[] = "🛀🏿";
	inline constexpr const char soap[] = "🧼";
	inline constexpr const char toothbrush[] = "🪥";
	inline constexpr const char razor[] = "🪒";
	inline constexpr const char hair_pick[] = "🪮";
	inline constexpr const char sponge[] = "🧽";
	inline constexpr const char bucket[] = "🪣";
	inline constexpr const char squeeze_bottle[] = "🧴";
	inline constexpr const char lotion_bottle[] = "🧴";
	inline constexpr const char bellhop[] = "🛎️";
	inline constexpr const char bellhop_bell[] = "🛎️";
	inline constexpr const char key[] = "🔑";
	inline constexpr const char key2[] = "🗝️";
	inline constexpr const char old_key[] = "🗝️";
	inline constexpr const char door[] = "🚪";
	inline constexpr const char chair[] = "🪑";
	inline constexpr const char couch[] = "🛋️";
	inline constexpr const char couch_and_lamp[] = "🛋️";
	inline constexpr const char bed[] = "🛏️";
	inline constexpr const char sleeping_accommodation[] = "🛌";
	inline constexpr const char person_in_bed[] = "🛌";
	inline constexpr const char person_in_bed_tone1[] = "🛌🏻";
	inline constexpr const char person_in_bed_light_skin_tone[] = "🛌🏻";
	inline constexpr const char person_in_bed_tone2[] = "🛌🏼";
	inline constexpr const char person_in_bed_medium_light_skin_tone[] = "🛌🏼";
	inline constexpr const char person_in_bed_tone3[] = "🛌🏽";
	inline constexpr const char person_in_bed_medium_skin_tone[] = "🛌🏽";
	inline constexpr const char person_in_bed_tone4[] = "🛌🏾";
	inline constexpr const char person_in_bed_medium_dark_skin_tone[] = "🛌🏾";
	inline constexpr const char person_in_bed_tone5[] = "🛌🏿";
	inline constexpr const char person_in_bed_dark_skin_tone[] = "🛌🏿";
	inline constexpr const char teddy_bear[] = "🧸";
	inline constexpr const char nesting_dolls[] = "🪆";
	inline constexpr const char frame_photo[] = "🖼️";
	inline constexpr const char frame_with_picture[] = "🖼️";
	inline constexpr const char mirror[] = "🪞";
	inline constexpr const char window[] = "🪟";
	inline constexpr const char shopping_bags[] = "🛍️";
	inline constexpr const char shopping_cart[] = "🛒";
	inline constexpr const char shopping_trolley[] = "🛒";
	inline constexpr const char gift[] = "🎁";
	inline constexpr const char wrapped_gift[] = "🎁";
	inline constexpr const char balloon[] = "🎈";
	inline constexpr const char flags[] = "🎏";
	inline constexpr const char carp_streamer[] = "🎏";
	inline constexpr const char ribbon[] = "🎀";
	inline constexpr const char magic_wand[] = "🪄";
	inline constexpr const char pinata[] = "🪅";
	inline constexpr const char confetti_ball[] = "🎊";
	inline constexpr const char tada[] = "🎉";
	inline constexpr const char party_popper[] = "🎉";
	inline constexpr const char dolls[] = "🎎";
	inline constexpr const char folding_hand_fan[] = "🪭";
	inline constexpr const char izakaya_lantern[] = "🏮";
	inline constexpr const char wind_chime[] = "🎐";
	inline constexpr const char mirror_ball[] = "🪩";
	inline constexpr const char red_envelope[] = "🧧";
	inline constexpr const char envelope[] = "✉️";
	inline constexpr const char envelope_with_arrow[] = "📩";
	inline constexpr const char incoming_envelope[] = "📨";
	inline constexpr const char e_mail[] = "📧";
	inline constexpr const char email[] = "📧";
	inline constexpr const char love_letter[] = "💌";
	inline constexpr const char inbox_tray[] = "📥";
	inline constexpr const char outbox_tray[] = "📤";
	inline constexpr const char package[] = "📦";
	inline constexpr const char label[] = "🏷️";
	inline constexpr const char placard[] = "🪧";
	inline constexpr const char mailbox_closed[] = "📪";
	inline constexpr const char mailbox[] = "📫";
	inline constexpr const char mailbox_with_mail[] = "📬";
	inline constexpr const char mailbox_with_no_mail[] = "📭";
	inline constexpr const char postbox[] = "📮";
	inline constexpr const char postal_horn[] = "📯";
	inline constexpr const char scroll[] = "📜";
	inline constexpr const char page_with_curl[] = "📃";
	inline constexpr const char page_facing_up[] = "📄";
	inline constexpr const char bookmark_tabs[] = "📑";
	inline constexpr const char receipt[] = "🧾";
	inline constexpr const char bar_chart[] = "📊";
	inline constexpr const char chart_with_upwards_trend[] = "📈";
	inline constexpr const char chart_with_downwards_trend[] = "📉";
	inline constexpr const char notepad_spiral[] = "🗒️";
	inline constexpr const char spiral_note_pad[] = "🗒️";
	inline constexpr const char calendar_spiral[] = "🗓️";
	inline constexpr const char spiral_calendar_pad[] = "🗓️";
	inline constexpr const char calendar[] = "📆";
	inline constexpr const char date[] = "📅";
	inline constexpr const char wastebasket[] = "🗑️";
	inline constexpr const char card_index[] = "📇";
	inline constexpr const char card_box[] = "🗃️";
	inline constexpr const char card_file_box[] = "🗃️";
	inline constexpr const char ballot_box[] = "🗳️";
	inline constexpr const char ballot_box_with_ballot[] = "🗳️";
	inline constexpr const char file_cabinet[] = "🗄️";
	inline constexpr const char clipboard[] = "📋";
	inline constexpr const char file_folder[] = "📁";
	inline constexpr const char open_file_folder[] = "📂";
	inline constexpr const char dividers[] = "🗂️";
	inline constexpr const char card_index_dividers[] = "🗂️";
	inline constexpr const char newspaper2[] = "🗞️";
	inline constexpr const char rolled_up_newspaper[] = "🗞️";
	inline constexpr const char newspaper[] = "📰";
	inline constexpr const char notebook[] = "📓";
	inline constexpr const char notebook_with_decorative_cover[] = "📔";
	inline constexpr const char ledger[] = "📒";
	inline constexpr const char closed_book[] = "📕";
	inline constexpr const char green_book[] = "📗";
	inline constexpr const char blue_book[] = "📘";
	inline constexpr const char orange_book[] = "📙";
	inline constexpr const char books[] = "📚";
	inline constexpr const char book[] = "📖";
	inline constexpr const char open_book[] = "📖";
	inline constexpr const char bookmark[] = "🔖";
	inline constexpr const char safety_pin[] = "🧷";
	inline constexpr const char link[] = "🔗";
	inline constexpr const char paperclip[] = "📎";
	inline constexpr const char paperclips[] = "🖇️";
	inline constexpr const char linked_paperclips[] = "🖇️";
	inline constexpr const char triangular_ruler[] = "📐";
	inline constexpr const char straight_ruler[] = "📏";
	inline constexpr const char abacus[] = "🧮";
	inline constexpr const char pushpin[] = "📌";
	inline constexpr const char round_pushpin[] = "📍";
	inline constexpr const char scissors[] = "✂️";
	inline constexpr const char pen_ballpoint[] = "🖊️";
	inline constexpr const char lower_left_ballpoint_pen[] = "🖊️";
	inline constexpr const char pen[] = "🖊️";
	inline constexpr const char pen_fountain[] = "🖋️";
	inline constexpr const char lower_left_fountain_pen[] = "🖋️";
	inline constexpr const char fountain_pen[] = "🖋️";
	inline constexpr const char black_nib[] = "✒️";
	inline constexpr const char paintbrush[] = "🖌️";
	inline constexpr const char lower_left_paintbrush[] = "🖌️";
	inline constexpr const char crayon[] = "🖍️";
	inline constexpr const char lower_left_crayon[] = "🖍️";
	inline constexpr const char pencil[] = "📝";
	inline constexpr const char memo[] = "📝";
	inline constexpr const char pencil2[] = "✏️";
	inline constexpr const char mag[] = "🔍";
	inline constexpr const char mag_right[] = "🔎";
	inline constexpr const char lock_with_ink_pen[] = "🔏";
	inline constexpr const char closed_lock_with_key[] = "🔐";
	inline constexpr const char lock[] = "🔒";
	inline constexpr const char locked[] = "🔒";
	inline constexpr const char unlock[] = "🔓";
	inline constexpr const char unlocked[] = "🔓";
	inline constexpr const char grinning[] = "😀";
	inline constexpr const char grinning_face[] = "😀";
	inline constexpr const char smiley[] = "😃";
	inline constexpr const char smile[] = "😄";
	inline constexpr const char grin[] = "😁";
	inline constexpr const char laughing[] = "😆";
	inline constexpr const char satisfied[] = "😆";
	inline constexpr const char face_holding_back_tears[] = "🥹";
	inline constexpr const char sweat_smile[] = "😅";
	inline constexpr const char joy[] = "😂";
	inline constexpr const char rofl[] = "🤣";
	inline constexpr const char rolling_on_the_floor_laughing[] = "🤣";
	inline constexpr const char smiling_face_with_tear[] = "🥲";
	inline constexpr const char relaxed[] = "☺️";
	inline constexpr const char smiling_face[] = "☺️";
	inline constexpr const char blush[] = "😊";
	inline constexpr const char innocent[] = "😇";
	inline constexpr const char slight_smile[] = "🙂";
	inline constexpr const char slightly_smiling_face[] = "🙂";
	inline constexpr const char upside_down[] = "🙃";
	inline constexpr const char upside_down_face[] = "🙃";
	inline constexpr const char wink[] = "😉";
	inline constexpr const char winking_face[] = "😉";
	inline constexpr const char relieved[] = "😌";
	inline constexpr const char relieved_face[] = "😌";
	inline constexpr const char heart_eyes[] = "😍";
	inline constexpr const char smiling_face_with_3_hearts[] = "🥰";
	inline constexpr const char kissing_heart[] = "😘";
	inline constexpr const char kissing[] = "😗";
	inline constexpr const char kissing_face[] = "😗";
	inline constexpr const char kissing_smiling_eyes[] = "😙";
	inline constexpr const char kissing_closed_eyes[] = "😚";
	inline constexpr const char yum[] = "😋";
	inline constexpr const char stuck_out_tongue[] = "😛";
	inline constexpr const char stuck_out_tongue_closed_eyes[] = "😝";
	inline constexpr const char stuck_out_tongue_winking_eye[] = "😜";
	inline constexpr const char zany_face[] = "🤪";
	inline constexpr const char face_with_raised_eyebrow[] = "🤨";
	inline constexpr const char face_with_monocle[] = "🧐";
	inline constexpr const char nerd[] = "🤓";
	inline constexpr const char nerd_face[] = "🤓";
	inline constexpr const char sunglasses[] = "😎";
	inline constexpr const char disguised_face[] = "🥸";
	inline constexpr const char star_struck[] = "🤩";
	inline constexpr const char partying_face[] = "🥳";
	inline constexpr const char smirk[] = "😏";
	inline constexpr const char smirking_face[] = "😏";
	inline constexpr const char unamused[] = "😒";
	inline constexpr const char unamused_face[] = "😒";
	inline constexpr const char disappointed[] = "😞";
	inline constexpr const char pensive[] = "😔";
	inline constexpr const char pensive_face[] = "😔";
	inline constexpr const char worried[] = "😟";
	inline constexpr const char worried_face[] = "😟";
	inline constexpr const char confused[] = "😕";
	inline constexpr const char confused_face[] = "😕";
	inline constexpr const char slight_frown[] = "🙁";
	inline constexpr const char slightly_frowning_face[] = "🙁";
	inline constexpr const char frowning2[] = "☹️";
	inline constexpr const char white_frowning_face[] = "☹️";
	inline constexpr const char frowning_face[] = "☹️";
	inline constexpr const char persevere[] = "😣";
	inline constexpr const char confounded[] = "😖";
	inline constexpr const char tired_face[] = "😫";
	inline constexpr const char weary[] = "😩";
	inline constexpr const char weary_face[] = "😩";
	inline constexpr const char pleading_face[] = "🥺";
	inline constexpr const char cry[] = "😢";
	inline constexpr const char crying_face[] = "😢";
	inline constexpr const char sob[] = "😭";
	inline constexpr const char triumph[] = "😤";
	inline constexpr const char angry[] = "😠";
	inline constexpr const char angry_face[] = "😠";
	inline constexpr const char rage[] = "😡";
	inline constexpr const char pouting_face[] = "😡";
	inline constexpr const char face_with_symbols_over_mouth[] = "🤬";
	inline constexpr const char exploding_head[] = "🤯";
	inline constexpr const char flushed[] = "😳";
	inline constexpr const char flushed_face[] = "😳";
	inline constexpr const char hot_face[] = "🥵";
	inline constexpr const char cold_face[] = "🥶";
	inline constexpr const char face_in_clouds[] = "😶‍🌫️";
	inline constexpr const char scream[] = "😱";
	inline constexpr const char fearful[] = "😨";
	inline constexpr const char fearful_face[] = "😨";
	inline constexpr const char cold_sweat[] = "😰";
	inline constexpr const char disappointed_relieved[] = "😥";
	inline constexpr const char sweat[] = "😓";
	inline constexpr const char hugging[] = "🤗";
	inline constexpr const char hugging_face[] = "🤗";
	inline constexpr const char thinking[] = "🤔";
	inline constexpr const char thinking_face[] = "🤔";
	inline constexpr const char face_with_peeking_eye[] = "🫣";
	inline constexpr const char face_with_hand_over_mouth[] = "🤭";
	inline constexpr const char face_with_open_eyes_and_hand_over_mouth[] = "🫢";
	inline constexpr const char saluting_face[] = "🫡";
	inline constexpr const char shushing_face[] = "🤫";
	inline constexpr const char melting_face[] = "🫠";
	inline constexpr const char lying_face[] = "🤥";
	inline constexpr const char liar[] = "🤥";
	inline constexpr const char no_mouth[] = "😶";
	inline constexpr const char dotted_line_face[] = "🫥";
	inline constexpr const char neutral_face[] = "😐";
	inline constexpr const char face_with_diagonal_mouth[] = "🫤";
	inline constexpr const char expressionless[] = "😑";
	inline constexpr const char shaking_face[] = "🫨";
	inline constexpr const char grimacing[] = "😬";
	inline constexpr const char rolling_eyes[] = "🙄";
	inline constexpr const char face_with_rolling_eyes[] = "🙄";
	inline constexpr const char hushed[] = "😯";
	inline constexpr const char hushed_face[] = "😯";
	inline constexpr const char frowning[] = "😦";
	inline constexpr const char anguished[] = "😧";
	inline constexpr const char open_mouth[] = "😮";
	inline constexpr const char astonished[] = "😲";
	inline constexpr const char yawning_face[] = "🥱";
	inline constexpr const char sleeping[] = "😴";
	inline constexpr const char sleeping_face[] = "😴";
	inline constexpr const char drooling_face[] = "🤤";
	inline constexpr const char drool[] = "🤤";
	inline constexpr const char sleepy[] = "😪";
	inline constexpr const char sleepy_face[] = "😪";
	inline constexpr const char face_exhaling[] = "😮‍💨";
	inline constexpr const char dizzy_face[] = "😵";
	inline constexpr const char face_with_spiral_eyes[] = "😵‍💫";
	inline constexpr const char zipper_mouth[] = "🤐";
	inline constexpr const char zipper_mouth_face[] = "🤐";
	inline constexpr const char woozy_face[] = "🥴";
	inline constexpr const char nauseated_face[] = "🤢";
	inline constexpr const char sick[] = "🤢";
	inline constexpr const char face_vomiting[] = "🤮";
	inline constexpr const char sneezing_face[] = "🤧";
	inline constexpr const char sneeze[] = "🤧";
	inline constexpr const char mask[] = "😷";
	inline constexpr const char thermometer_face[] = "🤒";
	inline constexpr const char face_with_thermometer[] = "🤒";
	inline constexpr const char head_bandage[] = "🤕";
	inline constexpr const char face_with_head_bandage[] = "🤕";
	inline constexpr const char money_mouth[] = "🤑";
	inline constexpr const char money_mouth_face[] = "🤑";
	inline constexpr const char cowboy[] = "🤠";
	inline constexpr const char face_with_cowboy_hat[] = "🤠";
	inline constexpr const char smiling_imp[] = "😈";
	inline constexpr const char imp[] = "👿";
	inline constexpr const char japanese_ogre[] = "👹";
	inline constexpr const char ogre[] = "👹";
	inline constexpr const char japanese_goblin[] = "👺";
	inline constexpr const char goblin[] = "👺";
	inline constexpr const char clown[] = "🤡";
	inline constexpr const char clown_face[] = "🤡";
	inline constexpr const char poop[] = "💩";
	inline constexpr const char shit[] = "💩";
	inline constexpr const char hankey[] = "💩";
	inline constexpr const char poo[] = "💩";
	inline constexpr const char pile_of_poo[] = "💩";
	inline constexpr const char ghost[] = "👻";
	inline constexpr const char skull[] = "💀";
	inline constexpr const char skeleton[] = "💀";
	inline constexpr const char skull_crossbones[] = "☠️";
	inline constexpr const char skull_and_crossbones[] = "☠️";
	inline constexpr const char alien[] = "👽";
	inline constexpr const char space_invader[] = "👾";
	inline constexpr const char alien_monster[] = "👾";
	inline constexpr const char robot[] = "🤖";
	inline constexpr const char robot_face[] = "🤖";
	inline constexpr const char jack_o_lantern[] = "🎃";
	inline constexpr const char smiley_cat[] = "😺";
	inline constexpr const char grinning_cat[] = "😺";
	inline constexpr const char smile_cat[] = "😸";
	inline constexpr const char joy_cat[] = "😹";
	inline constexpr const char heart_eyes_cat[] = "😻";
	inline constexpr const char smirk_cat[] = "😼";
	inline constexpr const char kissing_cat[] = "😽";
	inline constexpr const char scream_cat[] = "🙀";
	inline constexpr const char weary_cat[] = "🙀";
	inline constexpr const char crying_cat_face[] = "😿";
	inline constexpr const char crying_cat[] = "😿";
	inline constexpr const char pouting_cat[] = "😾";
	inline constexpr const char heart_hands[] = "🫶";
	inline constexpr const char heart_hands_tone1[] = "🫶🏻";
	inline constexpr const char heart_hands_light_skin_tone[] = "🫶🏻";
	inline constexpr const char heart_hands_tone2[] = "🫶🏼";
	inline constexpr const char heart_hands_medium_light_skin_tone[] = "🫶🏼";
	inline constexpr const char heart_hands_tone3[] = "🫶🏽";
	inline constexpr const char heart_hands_medium_skin_tone[] = "🫶🏽";
	inline constexpr const char heart_hands_tone4[] = "🫶🏾";
	inline constexpr const char heart_hands_medium_dark_skin_tone[] = "🫶🏾";
	inline constexpr const char heart_hands_tone5[] = "🫶🏿";
	inline constexpr const char heart_hands_dark_skin_tone[] = "🫶🏿";
	inline constexpr const char palms_up_together[] = "🤲";
	inline constexpr const char palms_up_together_tone1[] = "🤲🏻";
	inline constexpr const char palms_up_together_light_skin_tone[] = "🤲🏻";
	inline constexpr const char palms_up_together_tone2[] = "🤲🏼";
	inline constexpr const char palms_up_together_medium_light_skin_tone[] = "🤲🏼";
	inline constexpr const char palms_up_together_tone3[] = "🤲🏽";
	inline constexpr const char palms_up_together_medium_skin_tone[] = "🤲🏽";
	inline constexpr const char palms_up_together_tone4[] = "🤲🏾";
	inline constexpr const char palms_up_together_medium_dark_skin_tone[] = "🤲🏾";
	inline constexpr const char palms_up_together_tone5[] = "🤲🏿";
	inline constexpr const char palms_up_together_dark_skin_tone[] = "🤲🏿";
	inline constexpr const char open_hands[] = "👐";
	inline constexpr const char open_hands_tone1[] = "👐🏻";
	inline constexpr const char open_hands_tone2[] = "👐🏼";
	inline constexpr const char open_hands_tone3[] = "👐🏽";
	inline constexpr const char open_hands_tone4[] = "👐🏾";
	inline constexpr const char open_hands_tone5[] = "👐🏿";
	inline constexpr const char raised_hands[] = "🙌";
	inline constexpr const char raising_hands[] = "🙌";
	inline constexpr const char raised_hands_tone1[] = "🙌🏻";
	inline constexpr const char raised_hands_tone2[] = "🙌🏼";
	inline constexpr const char raised_hands_tone3[] = "🙌🏽";
	inline constexpr const char raised_hands_tone4[] = "🙌🏾";
	inline constexpr const char raised_hands_tone5[] = "🙌🏿";
	inline constexpr const char clap[] = "👏";
	inline constexpr const char clap_tone1[] = "👏🏻";
	inline constexpr const char clap_tone2[] = "👏🏼";
	inline constexpr const char clap_tone3[] = "👏🏽";
	inline constexpr const char clap_tone4[] = "👏🏾";
	inline constexpr const char clap_tone5[] = "👏🏿";
	inline constexpr const char handshake[] = "🤝";
	inline constexpr const char shaking_hands[] = "🤝";
	inline constexpr const char handshake_tone1[] = "🤝🏻";
	inline constexpr const char handshake_light_skin_tone[] = "🤝🏻";
	inline constexpr const char handshake_tone1_tone2[] = "🫱🏻‍🫲🏼";
	inline constexpr const char handshake_light_skin_tone_medium_light_skin_tone[] = "🫱🏻‍🫲🏼";
	inline constexpr const char handshake_tone1_tone3[] = "🫱🏻‍🫲🏽";
	inline constexpr const char handshake_light_skin_tone_medium_skin_tone[] = "🫱🏻‍🫲🏽";
	inline constexpr const char handshake_tone1_tone4[] = "🫱🏻‍🫲🏾";
	inline constexpr const char handshake_light_skin_tone_medium_dark_skin_tone[] = "🫱🏻‍🫲🏾";
	inline constexpr const char handshake_tone1_tone5[] = "🫱🏻‍🫲🏿";
	inline constexpr const char handshake_light_skin_tone_dark_skin_tone[] = "🫱🏻‍🫲🏿";
	inline constexpr const char handshake_tone2_tone1[] = "🫱🏼‍🫲🏻";
	inline constexpr const char handshake_medium_light_skin_tone_light_skin_tone[] = "🫱🏼‍🫲🏻";
	inline constexpr const char handshake_tone2[] = "🤝🏼";
	inline constexpr const char handshake_medium_light_skin_tone[] = "🤝🏼";
	inline constexpr const char handshake_tone2_tone3[] = "🫱🏼‍🫲🏽";
	inline constexpr const char handshake_medium_light_skin_tone_medium_skin_tone[] = "🫱🏼‍🫲🏽";
	inline constexpr const char handshake_tone2_tone4[] = "🫱🏼‍🫲🏾";
	inline constexpr const char handshake_medium_light_skin_tone_medium_dark_skin_tone[] = "🫱🏼‍🫲🏾";
	inline constexpr const char handshake_tone2_tone5[] = "🫱🏼‍🫲🏿";
	inline constexpr const char handshake_medium_light_skin_tone_dark_skin_tone[] = "🫱🏼‍🫲🏿";
	inline constexpr const char handshake_tone3_tone1[] = "🫱🏽‍🫲🏻";
	inline constexpr const char handshake_medium_skin_tone_light_skin_tone[] = "🫱🏽‍🫲🏻";
	inline constexpr const char handshake_tone3_tone2[] = "🫱🏽‍🫲🏼";
	inline constexpr const char handshake_medium_skin_tone_medium_light_skin_tone[] = "🫱🏽‍🫲🏼";
	inline constexpr const char handshake_tone3[] = "🤝🏽";
	inline constexpr const char handshake_medium_skin_tone[] = "🤝🏽";
	inline constexpr const char handshake_tone3_tone4[] = "🫱🏽‍🫲🏾";
	inline constexpr const char handshake_medium_skin_tone_medium_dark_skin_tone[] = "🫱🏽‍🫲🏾";
	inline constexpr const char handshake_tone3_tone5[] = "🫱🏽‍🫲🏿";
	inline constexpr const char handshake_medium_skin_tone_dark_skin_tone[] = "🫱🏽‍🫲🏿";
	inline constexpr const char handshake_tone4_tone1[] = "🫱🏾‍🫲🏻";
	inline constexpr const char handshake_medium_dark_skin_tone_light_skin_tone[] = "🫱🏾‍🫲🏻";
	inline constexpr const char handshake_tone4_tone2[] = "🫱🏾‍🫲🏼";
	inline constexpr const char handshake_medium_dark_skin_tone_medium_light_skin_tone[] = "🫱🏾‍🫲🏼";
	inline constexpr const char handshake_tone4_tone3[] = "🫱🏾‍🫲🏽";
	inline constexpr const char handshake_medium_dark_skin_tone_medium_skin_tone[] = "🫱🏾‍🫲🏽";
	inline constexpr const char handshake_tone4[] = "🤝🏾";
	inline constexpr const char handshake_medium_dark_skin_tone[] = "🤝🏾";
	inline constexpr const char handshake_tone4_tone5[] = "🫱🏾‍🫲🏿";
	inline constexpr const char handshake_medium_dark_skin_tone_dark_skin_tone[] = "🫱🏾‍🫲🏿";
	inline constexpr const char handshake_tone5_tone1[] = "🫱🏿‍🫲🏻";
	inline constexpr const char handshake_dark_skin_tone_light_skin_tone[] = "🫱🏿‍🫲🏻";
	inline constexpr const char handshake_tone5_tone2[] = "🫱🏿‍🫲🏼";
	inline constexpr const char handshake_dark_skin_tone_medium_light_skin_tone[] = "🫱🏿‍🫲🏼";
	inline constexpr const char handshake_tone5_tone3[] = "🫱🏿‍🫲🏽";
	inline constexpr const char handshake_dark_skin_tone_medium_skin_tone[] = "🫱🏿‍🫲🏽";
	inline constexpr const char handshake_tone5_tone4[] = "🫱🏿‍🫲🏾";
	inline constexpr const char handshake_dark_skin_tone_medium_dark_skin_tone[] = "🫱🏿‍🫲🏾";
	inline constexpr const char handshake_tone5[] = "🤝🏿";
	inline constexpr const char handshake_dark_skin_tone[] = "🤝🏿";
	inline constexpr const char thumbsup[] = "👍";
	inline constexpr const char plus1[] = "👍";
	inline constexpr const char thumbup[] = "👍";
	inline constexpr const char thumbs_up[] = "👍";
	inline constexpr const char thumbsup_tone1[] = "👍🏻";
	inline constexpr const char plus1_tone1[] = "👍🏻";
	inline constexpr const char thumbup_tone1[] = "👍🏻";
	inline constexpr const char thumbsup_tone2[] = "👍🏼";
	inline constexpr const char plus1_tone2[] = "👍🏼";
	inline constexpr const char thumbup_tone2[] = "👍🏼";
	inline constexpr const char thumbsup_tone3[] = "👍🏽";
	inline constexpr const char plus1_tone3[] = "👍🏽";
	inline constexpr const char thumbup_tone3[] = "👍🏽";
	inline constexpr const char thumbsup_tone4[] = "👍🏾";
	inline constexpr const char plus1_tone4[] = "👍🏾";
	inline constexpr const char thumbup_tone4[] = "👍🏾";
	inline constexpr const char thumbsup_tone5[] = "👍🏿";
	inline constexpr const char plus1_tone5[] = "👍🏿";
	inline constexpr const char thumbup_tone5[] = "👍🏿";
	inline constexpr const char thumbsdown[] = "👎";
	inline constexpr const char minus1[] = "👎";
	inline constexpr const char thumbdown[] = "👎";
	inline constexpr const char thumbs_down[] = "👎";
	inline constexpr const char thumbsdown_tone1[] = "👎🏻";
	inline constexpr const char _1_tone1[] = "👎🏻";
	inline constexpr const char thumbdown_tone1[] = "👎🏻";
	inline constexpr const char thumbsdown_tone2[] = "👎🏼";
	inline constexpr const char _1_tone2[] = "👎🏼";
	inline constexpr const char thumbdown_tone2[] = "👎🏼";
	inline constexpr const char thumbsdown_tone3[] = "👎🏽";
	inline constexpr const char _1_tone3[] = "👎🏽";
	inline constexpr const char thumbdown_tone3[] = "👎🏽";
	inline constexpr const char thumbsdown_tone4[] = "👎🏾";
	inline constexpr const char _1_tone4[] = "👎🏾";
	inline constexpr const char thumbdown_tone4[] = "👎🏾";
	inline constexpr const char thumbsdown_tone5[] = "👎🏿";
	inline constexpr const char _1_tone5[] = "👎🏿";
	inline constexpr const char thumbdown_tone5[] = "👎🏿";
	inline constexpr const char punch[] = "👊";
	inline constexpr const char oncoming_fist[] = "👊";
	inline constexpr const char punch_tone1[] = "👊🏻";
	inline constexpr const char punch_tone2[] = "👊🏼";
	inline constexpr const char punch_tone3[] = "👊🏽";
	inline constexpr const char punch_tone4[] = "👊🏾";
	inline constexpr const char punch_tone5[] = "👊🏿";
	inline constexpr const char fist[] = "✊";
	inline constexpr const char raised_fist[] = "✊";
	inline constexpr const char fist_tone1[] = "✊🏻";
	inline constexpr const char fist_tone2[] = "✊🏼";
	inline constexpr const char fist_tone3[] = "✊🏽";
	inline constexpr const char fist_tone4[] = "✊🏾";
	inline constexpr const char fist_tone5[] = "✊🏿";
	inline constexpr const char left_facing_fist[] = "🤛";
	inline constexpr const char left_fist[] = "🤛";
	inline constexpr const char left_facing_fist_tone1[] = "🤛🏻";
	inline constexpr const char left_fist_tone1[] = "🤛🏻";
	inline constexpr const char left_facing_fist_tone2[] = "🤛🏼";
	inline constexpr const char left_fist_tone2[] = "🤛🏼";
	inline constexpr const char left_facing_fist_tone3[] = "🤛🏽";
	inline constexpr const char left_fist_tone3[] = "🤛🏽";
	inline constexpr const char left_facing_fist_tone4[] = "🤛🏾";
	inline constexpr const char left_fist_tone4[] = "🤛🏾";
	inline constexpr const char left_facing_fist_tone5[] = "🤛🏿";
	inline constexpr const char left_fist_tone5[] = "🤛🏿";
	inline constexpr const char right_facing_fist[] = "🤜";
	inline constexpr const char right_fist[] = "🤜";
	inline constexpr const char right_facing_fist_tone1[] = "🤜🏻";
	inline constexpr const char right_fist_tone1[] = "🤜🏻";
	inline constexpr const char right_facing_fist_tone2[] = "🤜🏼";
	inline constexpr const char right_fist_tone2[] = "🤜🏼";
	inline constexpr const char right_facing_fist_tone3[] = "🤜🏽";
	inline constexpr const char right_fist_tone3[] = "🤜🏽";
	inline constexpr const char right_facing_fist_tone4[] = "🤜🏾";
	inline constexpr const char right_fist_tone4[] = "🤜🏾";
	inline constexpr const char right_facing_fist_tone5[] = "🤜🏿";
	inline constexpr const char right_fist_tone5[] = "🤜🏿";
	inline constexpr const char leftwards_pushing_hand[] = "🫷";
	inline constexpr const char leftwards_pushing_hand_tone1[] = "🫷🏻";
	inline constexpr const char leftwards_pushing_hand_light_skin_tone[] = "🫷🏻";
	inline constexpr const char leftwards_pushing_hand_tone2[] = "🫷🏼";
	inline constexpr const char leftwards_pushing_hand_medium_light_skin_tone[] = "🫷🏼";
	inline constexpr const char leftwards_pushing_hand_tone3[] = "🫷🏽";
	inline constexpr const char leftwards_pushing_hand_medium_skin_tone[] = "🫷🏽";
	inline constexpr const char leftwards_pushing_hand_tone4[] = "🫷🏾";
	inline constexpr const char leftwards_pushing_hand_medium_dark_skin_tone[] = "🫷🏾";
	inline constexpr const char leftwards_pushing_hand_tone5[] = "🫷🏿";
	inline constexpr const char leftwards_pushing_hand_dark_skin_tone[] = "🫷🏿";
	inline constexpr const char rightwards_pushing_hand[] = "🫸";
	inline constexpr const char rightwards_pushing_hand_tone1[] = "🫸🏻";
	inline constexpr const char rightwards_pushing_hand_light_skin_tone[] = "🫸🏻";
	inline constexpr const char rightwards_pushing_hand_tone2[] = "🫸🏼";
	inline constexpr const char rightwards_pushing_hand_medium_light_skin_tone[] = "🫸🏼";
	inline constexpr const char rightwards_pushing_hand_tone3[] = "🫸🏽";
	inline constexpr const char rightwards_pushing_hand_medium_skin_tone[] = "🫸🏽";
	inline constexpr const char rightwards_pushing_hand_tone4[] = "🫸🏾";
	inline constexpr const char rightwards_pushing_hand_medium_dark_skin_tone[] = "🫸🏾";
	inline constexpr const char rightwards_pushing_hand_tone5[] = "🫸🏿";
	inline constexpr const char rightwards_pushing_hand_dark_skin_tone[] = "🫸🏿";
	inline constexpr const char fingers_crossed[] = "🤞";
	inline constexpr const char hand_with_index_and_middle_finger_crossed[] = "🤞";
	inline constexpr const char fingers_crossed_tone1[] = "🤞🏻";
	inline constexpr const char hand_with_index_and_middle_fingers_crossed_tone1[] = "🤞🏻";
	inline constexpr const char fingers_crossed_tone2[] = "🤞🏼";
	inline constexpr const char hand_with_index_and_middle_fingers_crossed_tone2[] = "🤞🏼";
	inline constexpr const char fingers_crossed_tone3[] = "🤞🏽";
	inline constexpr const char hand_with_index_and_middle_fingers_crossed_tone3[] = "🤞🏽";
	inline constexpr const char fingers_crossed_tone4[] = "🤞🏾";
	inline constexpr const char hand_with_index_and_middle_fingers_crossed_tone4[] = "🤞🏾";
	inline constexpr const char fingers_crossed_tone5[] = "🤞🏿";
	inline constexpr const char hand_with_index_and_middle_fingers_crossed_tone5[] = "🤞🏿";
	inline constexpr const char v[] = "✌️";
	inline constexpr const char victory_hand[] = "✌️";
	inline constexpr const char v_tone1[] = "✌🏻";
	inline constexpr const char v_tone2[] = "✌🏼";
	inline constexpr const char v_tone3[] = "✌🏽";
	inline constexpr const char v_tone4[] = "✌🏾";
	inline constexpr const char v_tone5[] = "✌🏿";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed[] = "🫰";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_tone1[] = "🫰🏻";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_light_skin_tone[] = "🫰🏻";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_tone2[] = "🫰🏼";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_medium_light_skin_tone[] = "🫰🏼";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_tone3[] = "🫰🏽";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_medium_skin_tone[] = "🫰🏽";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_tone4[] = "🫰🏾";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_medium_dark_skin_tone[] = "🫰🏾";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_tone5[] = "🫰🏿";
	inline constexpr const char hand_with_index_finger_and_thumb_crossed_dark_skin_tone[] = "🫰🏿";
	inline constexpr const char love_you_gesture[] = "🤟";
	inline constexpr const char love_you_gesture_tone1[] = "🤟🏻";
	inline constexpr const char love_you_gesture_light_skin_tone[] = "🤟🏻";
	inline constexpr const char love_you_gesture_tone2[] = "🤟🏼";
	inline constexpr const char love_you_gesture_medium_light_skin_tone[] = "🤟🏼";
	inline constexpr const char love_you_gesture_tone3[] = "🤟🏽";
	inline constexpr const char love_you_gesture_medium_skin_tone[] = "🤟🏽";
	inline constexpr const char love_you_gesture_tone4[] = "🤟🏾";
	inline constexpr const char love_you_gesture_medium_dark_skin_tone[] = "🤟🏾";
	inline constexpr const char love_you_gesture_tone5[] = "🤟🏿";
	inline constexpr const char love_you_gesture_dark_skin_tone[] = "🤟🏿";
	inline constexpr const char metal[] = "🤘";
	inline constexpr const char sign_of_the_horns[] = "🤘";
	inline constexpr const char metal_tone1[] = "🤘🏻";
	inline constexpr const char sign_of_the_horns_tone1[] = "🤘🏻";
	inline constexpr const char metal_tone2[] = "🤘🏼";
	inline constexpr const char sign_of_the_horns_tone2[] = "🤘🏼";
	inline constexpr const char metal_tone3[] = "🤘🏽";
	inline constexpr const char sign_of_the_horns_tone3[] = "🤘🏽";
	inline constexpr const char metal_tone4[] = "🤘🏾";
	inline constexpr const char sign_of_the_horns_tone4[] = "🤘🏾";
	inline constexpr const char metal_tone5[] = "🤘🏿";
	inline constexpr const char sign_of_the_horns_tone5[] = "🤘🏿";
	inline constexpr const char ok_hand[] = "👌";
	inline constexpr const char ok_hand_tone1[] = "👌🏻";
	inline constexpr const char ok_hand_tone2[] = "👌🏼";
	inline constexpr const char ok_hand_tone3[] = "👌🏽";
	inline constexpr const char ok_hand_tone4[] = "👌🏾";
	inline constexpr const char ok_hand_tone5[] = "👌🏿";
	inline constexpr const char pinched_fingers[] = "🤌";
	inline constexpr const char pinched_fingers_tone2[] = "🤌🏼";
	inline constexpr const char pinched_fingers_medium_light_skin_tone[] = "🤌🏼";
	inline constexpr const char pinched_fingers_tone1[] = "🤌🏻";
	inline constexpr const char pinched_fingers_light_skin_tone[] = "🤌🏻";
	inline constexpr const char pinched_fingers_tone3[] = "🤌🏽";
	inline constexpr const char pinched_fingers_medium_skin_tone[] = "🤌🏽";
	inline constexpr const char pinched_fingers_tone4[] = "🤌🏾";
	inline constexpr const char pinched_fingers_medium_dark_skin_tone[] = "🤌🏾";
	inline constexpr const char pinched_fingers_tone5[] = "🤌🏿";
	inline constexpr const char pinched_fingers_dark_skin_tone[] = "🤌🏿";
	inline constexpr const char pinching_hand[] = "🤏";
	inline constexpr const char pinching_hand_tone1[] = "🤏🏻";
	inline constexpr const char pinching_hand_light_skin_tone[] = "🤏🏻";
	inline constexpr const char pinching_hand_tone2[] = "🤏🏼";
	inline constexpr const char pinching_hand_medium_light_skin_tone[] = "🤏🏼";
	inline constexpr const char pinching_hand_tone3[] = "🤏🏽";
	inline constexpr const char pinching_hand_medium_skin_tone[] = "🤏🏽";
	inline constexpr const char pinching_hand_tone4[] = "🤏🏾";
	inline constexpr const char pinching_hand_medium_dark_skin_tone[] = "🤏🏾";
	inline constexpr const char pinching_hand_tone5[] = "🤏🏿";
	inline constexpr const char pinching_hand_dark_skin_tone[] = "🤏🏿";
	inline constexpr const char palm_down_hand[] = "🫳";
	inline constexpr const char palm_down_hand_tone1[] = "🫳🏻";
	inline constexpr const char palm_down_hand_light_skin_tone[] = "🫳🏻";
	inline constexpr const char palm_down_hand_tone2[] = "🫳🏼";
	inline constexpr const char palm_down_hand_medium_light_skin_tone[] = "🫳🏼";
	inline constexpr const char palm_down_hand_tone3[] = "🫳🏽";
	inline constexpr const char palm_down_hand_medium_skin_tone[] = "🫳🏽";
	inline constexpr const char palm_down_hand_tone4[] = "🫳🏾";
	inline constexpr const char palm_down_hand_medium_dark_skin_tone[] = "🫳🏾";
	inline constexpr const char palm_down_hand_tone5[] = "🫳🏿";
	inline constexpr const char palm_down_hand_dark_skin_tone[] = "🫳🏿";
	inline constexpr const char palm_up_hand[] = "🫴";
	inline constexpr const char palm_up_hand_tone1[] = "🫴🏻";
	inline constexpr const char palm_up_hand_light_skin_tone[] = "🫴🏻";
	inline constexpr const char palm_up_hand_tone2[] = "🫴🏼";
	inline constexpr const char palm_up_hand_medium_light_skin_tone[] = "🫴🏼";
	inline constexpr const char palm_up_hand_tone3[] = "🫴🏽";
	inline constexpr const char palm_up_hand_medium_skin_tone[] = "🫴🏽";
	inline constexpr const char palm_up_hand_tone4[] = "🫴🏾";
	inline constexpr const char palm_up_hand_medium_dark_skin_tone[] = "🫴🏾";
	inline constexpr const char palm_up_hand_tone5[] = "🫴🏿";
	inline constexpr const char palm_up_hand_dark_skin_tone[] = "🫴🏿";
	inline constexpr const char point_left[] = "👈";
	inline constexpr const char point_left_tone1[] = "👈🏻";
	inline constexpr const char point_left_tone2[] = "👈🏼";
	inline constexpr const char point_left_tone3[] = "👈🏽";
	inline constexpr const char point_left_tone4[] = "👈🏾";
	inline constexpr const char point_left_tone5[] = "👈🏿";
	inline constexpr const char point_right[] = "👉";
	inline constexpr const char point_right_tone1[] = "👉🏻";
	inline constexpr const char point_right_tone2[] = "👉🏼";
	inline constexpr const char point_right_tone3[] = "👉🏽";
	inline constexpr const char point_right_tone4[] = "👉🏾";
	inline constexpr const char point_right_tone5[] = "👉🏿";
	inline constexpr const char point_up_2[] = "👆";
	inline constexpr const char point_up_2_tone1[] = "👆🏻";
	inline constexpr const char point_up_2_tone2[] = "👆🏼";
	inline constexpr const char point_up_2_tone3[] = "👆🏽";
	inline constexpr const char point_up_2_tone4[] = "👆🏾";
	inline constexpr const char point_up_2_tone5[] = "👆🏿";
	inline constexpr const char point_down[] = "👇";
	inline constexpr const char point_down_tone1[] = "👇🏻";
	inline constexpr const char point_down_tone2[] = "👇🏼";
	inline constexpr const char point_down_tone3[] = "👇🏽";
	inline constexpr const char point_down_tone4[] = "👇🏾";
	inline constexpr const char point_down_tone5[] = "👇🏿";
	inline constexpr const char point_up[] = "☝️";
	inline constexpr const char point_up_tone1[] = "☝🏻";
	inline constexpr const char point_up_tone2[] = "☝🏼";
	inline constexpr const char point_up_tone3[] = "☝🏽";
	inline constexpr const char point_up_tone4[] = "☝🏾";
	inline constexpr const char point_up_tone5[] = "☝🏿";
	inline constexpr const char raised_hand[] = "✋";
	inline constexpr const char raised_hand_tone1[] = "✋🏻";
	inline constexpr const char raised_hand_tone2[] = "✋🏼";
	inline constexpr const char raised_hand_tone3[] = "✋🏽";
	inline constexpr const char raised_hand_tone4[] = "✋🏾";
	inline constexpr const char raised_hand_tone5[] = "✋🏿";
	inline constexpr const char raised_back_of_hand[] = "🤚";
	inline constexpr const char back_of_hand[] = "🤚";
	inline constexpr const char raised_back_of_hand_tone1[] = "🤚🏻";
	inline constexpr const char back_of_hand_tone1[] = "🤚🏻";
	inline constexpr const char raised_back_of_hand_tone2[] = "🤚🏼";
	inline constexpr const char back_of_hand_tone2[] = "🤚🏼";
	inline constexpr const char raised_back_of_hand_tone3[] = "🤚🏽";
	inline constexpr const char back_of_hand_tone3[] = "🤚🏽";
	inline constexpr const char raised_back_of_hand_tone4[] = "🤚🏾";
	inline constexpr const char back_of_hand_tone4[] = "🤚🏾";
	inline constexpr const char raised_back_of_hand_tone5[] = "🤚🏿";
	inline constexpr const char back_of_hand_tone5[] = "🤚🏿";
	inline constexpr const char hand_splayed[] = "🖐️";
	inline constexpr const char raised_hand_with_fingers_splayed[] = "🖐️";
	inline constexpr const char hand_splayed_tone1[] = "🖐🏻";
	inline constexpr const char raised_hand_with_fingers_splayed_tone1[] = "🖐🏻";
	inline constexpr const char hand_splayed_tone2[] = "🖐🏼";
	inline constexpr const char raised_hand_with_fingers_splayed_tone2[] = "🖐🏼";
	inline constexpr const char hand_splayed_tone3[] = "🖐🏽";
	inline constexpr const char raised_hand_with_fingers_splayed_tone3[] = "🖐🏽";
	inline constexpr const char hand_splayed_tone4[] = "🖐🏾";
	inline constexpr const char raised_hand_with_fingers_splayed_tone4[] = "🖐🏾";
	inline constexpr const char hand_splayed_tone5[] = "🖐🏿";
	inline constexpr const char raised_hand_with_fingers_splayed_tone5[] = "🖐🏿";
	inline constexpr const char vulcan[] = "🖖";
	inline constexpr const char raised_hand_with_part_between_middle_and_ring_fingers[] = "🖖";
	inline constexpr const char vulcan_salute[] = "🖖";
	inline constexpr const char vulcan_tone1[] = "🖖🏻";
	inline constexpr const char raised_hand_with_part_between_middle_and_ring_fingers_tone1[] = "🖖🏻";
	inline constexpr const char vulcan_tone2[] = "🖖🏼";
	inline constexpr const char raised_hand_with_part_between_middle_and_ring_fingers_tone2[] = "🖖🏼";
	inline constexpr const char vulcan_tone3[] = "🖖🏽";
	inline constexpr const char raised_hand_with_part_between_middle_and_ring_fingers_tone3[] = "🖖🏽";
	inline constexpr const char vulcan_tone4[] = "🖖🏾";
	inline constexpr const char raised_hand_with_part_between_middle_and_ring_fingers_tone4[] = "🖖🏾";
	inline constexpr const char vulcan_tone5[] = "🖖🏿";
	inline constexpr const char raised_hand_with_part_between_middle_and_ring_fingers_tone5[] = "🖖🏿";
	inline constexpr const char wave[] = "👋";
	inline constexpr const char waving_hand[] = "👋";
	inline constexpr const char wave_tone1[] = "👋🏻";
	inline constexpr const char wave_tone2[] = "👋🏼";
	inline constexpr const char wave_tone3[] = "👋🏽";
	inline constexpr const char wave_tone4[] = "👋🏾";
	inline constexpr const char wave_tone5[] = "👋🏿";
	inline constexpr const char call_me[] = "🤙";
	inline constexpr const char call_me_hand[] = "🤙";
	inline constexpr const char call_me_tone1[] = "🤙🏻";
	inline constexpr const char call_me_hand_tone1[] = "🤙🏻";
	inline constexpr const char call_me_tone2[] = "🤙🏼";
	inline constexpr const char call_me_hand_tone2[] = "🤙🏼";
	inline constexpr const char call_me_tone3[] = "🤙🏽";
	inline constexpr const char call_me_hand_tone3[] = "🤙🏽";
	inline constexpr const char call_me_tone4[] = "🤙🏾";
	inline constexpr const char call_me_hand_tone4[] = "🤙🏾";
	inline constexpr const char call_me_tone5[] = "🤙🏿";
	inline constexpr const char call_me_hand_tone5[] = "🤙🏿";
	inline constexpr const char leftwards_hand[] = "🫲";
	inline constexpr const char leftwards_hand_tone1[] = "🫲🏻";
	inline constexpr const char leftwards_hand_light_skin_tone[] = "🫲🏻";
	inline constexpr const char leftwards_hand_tone2[] = "🫲🏼";
	inline constexpr const char leftwards_hand_medium_light_skin_tone[] = "🫲🏼";
	inline constexpr const char leftwards_hand_tone3[] = "🫲🏽";
	inline constexpr const char leftwards_hand_medium_skin_tone[] = "🫲🏽";
	inline constexpr const char leftwards_hand_tone4[] = "🫲🏾";
	inline constexpr const char leftwards_hand_medium_dark_skin_tone[] = "🫲🏾";
	inline constexpr const char leftwards_hand_tone5[] = "🫲🏿";
	inline constexpr const char leftwards_hand_dark_skin_tone[] = "🫲🏿";
	inline constexpr const char rightwards_hand[] = "🫱";
	inline constexpr const char rightwards_hand_tone1[] = "🫱🏻";
	inline constexpr const char rightwards_hand_light_skin_tone[] = "🫱🏻";
	inline constexpr const char rightwards_hand_tone2[] = "🫱🏼";
	inline constexpr const char rightwards_hand_medium_light_skin_tone[] = "🫱🏼";
	inline constexpr const char rightwards_hand_tone3[] = "🫱🏽";
	inline constexpr const char rightwards_hand_medium_skin_tone[] = "🫱🏽";
	inline constexpr const char rightwards_hand_tone4[] = "🫱🏾";
	inline constexpr const char rightwards_hand_medium_dark_skin_tone[] = "🫱🏾";
	inline constexpr const char rightwards_hand_tone5[] = "🫱🏿";
	inline constexpr const char rightwards_hand_dark_skin_tone[] = "🫱🏿";
	inline constexpr const char muscle[] = "💪";
	inline constexpr const char flexed_biceps[] = "💪";
	inline constexpr const char muscle_tone1[] = "💪🏻";
	inline constexpr const char muscle_tone2[] = "💪🏼";
	inline constexpr const char muscle_tone3[] = "💪🏽";
	inline constexpr const char muscle_tone4[] = "💪🏾";
	inline constexpr const char muscle_tone5[] = "💪🏿";
	inline constexpr const char mechanical_arm[] = "🦾";
	inline constexpr const char middle_finger[] = "🖕";
	inline constexpr const char reversed_hand_with_middle_finger_extended[] = "🖕";
	inline constexpr const char middle_finger_tone1[] = "🖕🏻";
	inline constexpr const char reversed_hand_with_middle_finger_extended_tone1[] = "🖕🏻";
	inline constexpr const char middle_finger_tone2[] = "🖕🏼";
	inline constexpr const char reversed_hand_with_middle_finger_extended_tone2[] = "🖕🏼";
	inline constexpr const char middle_finger_tone3[] = "🖕🏽";
	inline constexpr const char reversed_hand_with_middle_finger_extended_tone3[] = "🖕🏽";
	inline constexpr const char middle_finger_tone4[] = "🖕🏾";
	inline constexpr const char reversed_hand_with_middle_finger_extended_tone4[] = "🖕🏾";
	inline constexpr const char middle_finger_tone5[] = "🖕🏿";
	inline constexpr const char reversed_hand_with_middle_finger_extended_tone5[] = "🖕🏿";
	inline constexpr const char writing_hand[] = "✍️";
	inline constexpr const char writing_hand_tone1[] = "✍🏻";
	inline constexpr const char writing_hand_tone2[] = "✍🏼";
	inline constexpr const char writing_hand_tone3[] = "✍🏽";
	inline constexpr const char writing_hand_tone4[] = "✍🏾";
	inline constexpr const char writing_hand_tone5[] = "✍🏿";
	inline constexpr const char pray[] = "🙏";
	inline constexpr const char folded_hands[] = "🙏";
	inline constexpr const char pray_tone1[] = "🙏🏻";
	inline constexpr const char pray_tone2[] = "🙏🏼";
	inline constexpr const char pray_tone3[] = "🙏🏽";
	inline constexpr const char pray_tone4[] = "🙏🏾";
	inline constexpr const char pray_tone5[] = "🙏🏿";
	inline constexpr const char index_pointing_at_the_viewer[] = "🫵";
	inline constexpr const char index_pointing_at_the_viewer_tone1[] = "🫵🏻";
	inline constexpr const char index_pointing_at_the_viewer_light_skin_tone[] = "🫵🏻";
	inline constexpr const char index_pointing_at_the_viewer_tone2[] = "🫵🏼";
	inline constexpr const char index_pointing_at_the_viewer_medium_light_skin_tone[] = "🫵🏼";
	inline constexpr const char index_pointing_at_the_viewer_tone3[] = "🫵🏽";
	inline constexpr const char index_pointing_at_the_viewer_medium_skin_tone[] = "🫵🏽";
	inline constexpr const char index_pointing_at_the_viewer_tone4[] = "🫵🏾";
	inline constexpr const char index_pointing_at_the_viewer_medium_dark_skin_tone[] = "🫵🏾";
	inline constexpr const char index_pointing_at_the_viewer_tone5[] = "🫵🏿";
	inline constexpr const char index_pointing_at_the_viewer_dark_skin_tone[] = "🫵🏿";
	inline constexpr const char foot[] = "🦶";
	inline constexpr const char foot_tone1[] = "🦶🏻";
	inline constexpr const char foot_light_skin_tone[] = "🦶🏻";
	inline constexpr const char foot_tone2[] = "🦶🏼";
	inline constexpr const char foot_medium_light_skin_tone[] = "🦶🏼";
	inline constexpr const char foot_tone3[] = "🦶🏽";
	inline constexpr const char foot_medium_skin_tone[] = "🦶🏽";
	inline constexpr const char foot_tone4[] = "🦶🏾";
	inline constexpr const char foot_medium_dark_skin_tone[] = "🦶🏾";
	inline constexpr const char foot_tone5[] = "🦶🏿";
	inline constexpr const char foot_dark_skin_tone[] = "🦶🏿";
	inline constexpr const char leg[] = "🦵";
	inline constexpr const char leg_tone1[] = "🦵🏻";
	inline constexpr const char leg_light_skin_tone[] = "🦵🏻";
	inline constexpr const char leg_tone2[] = "🦵🏼";
	inline constexpr const char leg_medium_light_skin_tone[] = "🦵🏼";
	inline constexpr const char leg_tone3[] = "🦵🏽";
	inline constexpr const char leg_medium_skin_tone[] = "🦵🏽";
	inline constexpr const char leg_tone4[] = "🦵🏾";
	inline constexpr const char leg_medium_dark_skin_tone[] = "🦵🏾";
	inline constexpr const char leg_tone5[] = "🦵🏿";
	inline constexpr const char leg_dark_skin_tone[] = "🦵🏿";
	inline constexpr const char mechanical_leg[] = "🦿";
	inline constexpr const char lipstick[] = "💄";
	inline constexpr const char kiss[] = "💋";
	inline constexpr const char kiss_mark[] = "💋";
	inline constexpr const char lips[] = "👄";
	inline constexpr const char mouth[] = "👄";
	inline constexpr const char biting_lip[] = "🫦";
	inline constexpr const char tooth[] = "🦷";
	inline constexpr const char tongue[] = "👅";
	inline constexpr const char ear[] = "👂";
	inline constexpr const char ear_tone1[] = "👂🏻";
	inline constexpr const char ear_tone2[] = "👂🏼";
	inline constexpr const char ear_tone3[] = "👂🏽";
	inline constexpr const char ear_tone4[] = "👂🏾";
	inline constexpr const char ear_tone5[] = "👂🏿";
	inline constexpr const char ear_with_hearing_aid[] = "🦻";
	inline constexpr const char ear_with_hearing_aid_tone1[] = "🦻🏻";
	inline constexpr const char ear_with_hearing_aid_light_skin_tone[] = "🦻🏻";
	inline constexpr const char ear_with_hearing_aid_tone2[] = "🦻🏼";
	inline constexpr const char ear_with_hearing_aid_medium_light_skin_tone[] = "🦻🏼";
	inline constexpr const char ear_with_hearing_aid_tone3[] = "🦻🏽";
	inline constexpr const char ear_with_hearing_aid_medium_skin_tone[] = "🦻🏽";
	inline constexpr const char ear_with_hearing_aid_tone4[] = "🦻🏾";
	inline constexpr const char ear_with_hearing_aid_medium_dark_skin_tone[] = "🦻🏾";
	inline constexpr const char ear_with_hearing_aid_tone5[] = "🦻🏿";
	inline constexpr const char ear_with_hearing_aid_dark_skin_tone[] = "🦻🏿";
	inline constexpr const char nose[] = "👃";
	inline constexpr const char nose_tone1[] = "👃🏻";
	inline constexpr const char nose_tone2[] = "👃🏼";
	inline constexpr const char nose_tone3[] = "👃🏽";
	inline constexpr const char nose_tone4[] = "👃🏾";
	inline constexpr const char nose_tone5[] = "👃🏿";
	inline constexpr const char footprints[] = "👣";
	inline constexpr const char eye[] = "👁️";
	inline constexpr const char eyes[] = "👀";
	inline constexpr const char anatomical_heart[] = "🫀";
	inline constexpr const char lungs[] = "🫁";
	inline constexpr const char brain[] = "🧠";
	inline constexpr const char speaking_head[] = "🗣️";
	inline constexpr const char speaking_head_in_silhouette[] = "🗣️";
	inline constexpr const char bust_in_silhouette[] = "👤";
	inline constexpr const char busts_in_silhouette[] = "👥";
	inline constexpr const char people_hugging[] = "🫂";
	inline constexpr const char baby[] = "👶";
	inline constexpr const char baby_tone1[] = "👶🏻";
	inline constexpr const char baby_tone2[] = "👶🏼";
	inline constexpr const char baby_tone3[] = "👶🏽";
	inline constexpr const char baby_tone4[] = "👶🏾";
	inline constexpr const char baby_tone5[] = "👶🏿";
	inline constexpr const char child[] = "🧒";
	inline constexpr const char child_tone1[] = "🧒🏻";
	inline constexpr const char child_light_skin_tone[] = "🧒🏻";
	inline constexpr const char child_tone2[] = "🧒🏼";
	inline constexpr const char child_medium_light_skin_tone[] = "🧒🏼";
	inline constexpr const char child_tone3[] = "🧒🏽";
	inline constexpr const char child_medium_skin_tone[] = "🧒🏽";
	inline constexpr const char child_tone4[] = "🧒🏾";
	inline constexpr const char child_medium_dark_skin_tone[] = "🧒🏾";
	inline constexpr const char child_tone5[] = "🧒🏿";
	inline constexpr const char child_dark_skin_tone[] = "🧒🏿";
	inline constexpr const char girl[] = "👧";
	inline constexpr const char girl_tone1[] = "👧🏻";
	inline constexpr const char girl_tone2[] = "👧🏼";
	inline constexpr const char girl_tone3[] = "👧🏽";
	inline constexpr const char girl_tone4[] = "👧🏾";
	inline constexpr const char girl_tone5[] = "👧🏿";
	inline constexpr const char boy[] = "👦";
	inline constexpr const char boy_tone1[] = "👦🏻";
	inline constexpr const char boy_tone2[] = "👦🏼";
	inline constexpr const char boy_tone3[] = "👦🏽";
	inline constexpr const char boy_tone4[] = "👦🏾";
	inline constexpr const char boy_tone5[] = "👦🏿";
	inline constexpr const char adult[] = "🧑";
	inline constexpr const char person[] = "🧑";
	inline constexpr const char adult_tone1[] = "🧑🏻";
	inline constexpr const char adult_light_skin_tone[] = "🧑🏻";
	inline constexpr const char adult_tone2[] = "🧑🏼";
	inline constexpr const char adult_medium_light_skin_tone[] = "🧑🏼";
	inline constexpr const char adult_tone3[] = "🧑🏽";
	inline constexpr const char adult_medium_skin_tone[] = "🧑🏽";
	inline constexpr const char adult_tone4[] = "🧑🏾";
	inline constexpr const char adult_medium_dark_skin_tone[] = "🧑🏾";
	inline constexpr const char adult_tone5[] = "🧑🏿";
	inline constexpr const char adult_dark_skin_tone[] = "🧑🏿";
	inline constexpr const char woman[] = "👩";
	inline constexpr const char woman_tone1[] = "👩🏻";
	inline constexpr const char woman_tone2[] = "👩🏼";
	inline constexpr const char woman_tone3[] = "👩🏽";
	inline constexpr const char woman_tone4[] = "👩🏾";
	inline constexpr const char woman_tone5[] = "👩🏿";
	inline constexpr const char man[] = "👨";
	inline constexpr const char man_tone1[] = "👨🏻";
	inline constexpr const char man_tone2[] = "👨🏼";
	inline constexpr const char man_tone3[] = "👨🏽";
	inline constexpr const char man_tone4[] = "👨🏾";
	inline constexpr const char man_tone5[] = "👨🏿";
	inline constexpr const char person_curly_hair[] = "🧑‍🦱";
	inline constexpr const char person_tone1_curly_hair[] = "🧑🏻‍🦱";
	inline constexpr const char person_light_skin_tone_curly_hair[] = "🧑🏻‍🦱";
	inline constexpr const char person_tone2_curly_hair[] = "🧑🏼‍🦱";
	inline constexpr const char person_medium_light_skin_tone_curly_hair[] = "🧑🏼‍🦱";
	inline constexpr const char person_tone3_curly_hair[] = "🧑🏽‍🦱";
	inline constexpr const char person_medium_skin_tone_curly_hair[] = "🧑🏽‍🦱";
	inline constexpr const char person_tone4_curly_hair[] = "🧑🏾‍🦱";
	inline constexpr const char person_medium_dark_skin_tone_curly_hair[] = "🧑🏾‍🦱";
	inline constexpr const char person_tone5_curly_hair[] = "🧑🏿‍🦱";
	inline constexpr const char person_dark_skin_tone_curly_hair[] = "🧑🏿‍🦱";
	inline constexpr const char woman_curly_haired[] = "👩‍🦱";
	inline constexpr const char woman_curly_haired_tone1[] = "👩🏻‍🦱";
	inline constexpr const char woman_curly_haired_light_skin_tone[] = "👩🏻‍🦱";
	inline constexpr const char woman_curly_haired_tone2[] = "👩🏼‍🦱";
	inline constexpr const char woman_curly_haired_medium_light_skin_tone[] = "👩🏼‍🦱";
	inline constexpr const char woman_curly_haired_tone3[] = "👩🏽‍🦱";
	inline constexpr const char woman_curly_haired_medium_skin_tone[] = "👩🏽‍🦱";
	inline constexpr const char woman_curly_haired_tone4[] = "👩🏾‍🦱";
	inline constexpr const char woman_curly_haired_medium_dark_skin_tone[] = "👩🏾‍🦱";
	inline constexpr const char woman_curly_haired_tone5[] = "👩🏿‍🦱";
	inline constexpr const char woman_curly_haired_dark_skin_tone[] = "👩🏿‍🦱";
	inline constexpr const char man_curly_haired[] = "👨‍🦱";
	inline constexpr const char man_curly_haired_tone1[] = "👨🏻‍🦱";
	inline constexpr const char man_curly_haired_light_skin_tone[] = "👨🏻‍🦱";
	inline constexpr const char man_curly_haired_tone2[] = "👨🏼‍🦱";
	inline constexpr const char man_curly_haired_medium_light_skin_tone[] = "👨🏼‍🦱";
	inline constexpr const char man_curly_haired_tone3[] = "👨🏽‍🦱";
	inline constexpr const char man_curly_haired_medium_skin_tone[] = "👨🏽‍🦱";
	inline constexpr const char man_curly_haired_tone4[] = "👨🏾‍🦱";
	inline constexpr const char man_curly_haired_medium_dark_skin_tone[] = "👨🏾‍🦱";
	inline constexpr const char man_curly_haired_tone5[] = "👨🏿‍🦱";
	inline constexpr const char man_curly_haired_dark_skin_tone[] = "👨🏿‍🦱";
	inline constexpr const char person_red_hair[] = "🧑‍🦰";
	inline constexpr const char person_tone1_red_hair[] = "🧑🏻‍🦰";
	inline constexpr const char person_light_skin_tone_red_hair[] = "🧑🏻‍🦰";
	inline constexpr const char person_tone2_red_hair[] = "🧑🏼‍🦰";
	inline constexpr const char person_medium_light_skin_tone_red_hair[] = "🧑🏼‍🦰";
	inline constexpr const char person_tone3_red_hair[] = "🧑🏽‍🦰";
	inline constexpr const char person_medium_skin_tone_red_hair[] = "🧑🏽‍🦰";
	inline constexpr const char person_tone4_red_hair[] = "🧑🏾‍🦰";
	inline constexpr const char person_medium_dark_skin_tone_red_hair[] = "🧑🏾‍🦰";
	inline constexpr const char person_tone5_red_hair[] = "🧑🏿‍🦰";
	inline constexpr const char person_dark_skin_tone_red_hair[] = "🧑🏿‍🦰";
	inline constexpr const char woman_red_haired[] = "👩‍🦰";
	inline constexpr const char woman_red_haired_tone1[] = "👩🏻‍🦰";
	inline constexpr const char woman_red_haired_light_skin_tone[] = "👩🏻‍🦰";
	inline constexpr const char woman_red_haired_tone2[] = "👩🏼‍🦰";
	inline constexpr const char woman_red_haired_medium_light_skin_tone[] = "👩🏼‍🦰";
	inline constexpr const char woman_red_haired_tone3[] = "👩🏽‍🦰";
	inline constexpr const char woman_red_haired_medium_skin_tone[] = "👩🏽‍🦰";
	inline constexpr const char woman_red_haired_tone4[] = "👩🏾‍🦰";
	inline constexpr const char woman_red_haired_medium_dark_skin_tone[] = "👩🏾‍🦰";
	inline constexpr const char woman_red_haired_tone5[] = "👩🏿‍🦰";
	inline constexpr const char woman_red_haired_dark_skin_tone[] = "👩🏿‍🦰";
	inline constexpr const char man_red_haired[] = "👨‍🦰";
	inline constexpr const char man_red_hair[] = "👨‍🦰";
	inline constexpr const char man_red_haired_tone1[] = "👨🏻‍🦰";
	inline constexpr const char man_red_haired_light_skin_tone[] = "👨🏻‍🦰";
	inline constexpr const char man_red_haired_tone2[] = "👨🏼‍🦰";
	inline constexpr const char man_red_haired_medium_light_skin_tone[] = "👨🏼‍🦰";
	inline constexpr const char man_red_haired_tone3[] = "👨🏽‍🦰";
	inline constexpr const char man_red_haired_medium_skin_tone[] = "👨🏽‍🦰";
	inline constexpr const char man_red_haired_tone4[] = "👨🏾‍🦰";
	inline constexpr const char man_red_haired_medium_dark_skin_tone[] = "👨🏾‍🦰";
	inline constexpr const char man_red_haired_tone5[] = "👨🏿‍🦰";
	inline constexpr const char man_red_haired_dark_skin_tone[] = "👨🏿‍🦰";
	inline constexpr const char blond_haired_person[] = "👱";
	inline constexpr const char person_with_blond_hair[] = "👱";
	inline constexpr const char blond_haired_person_tone1[] = "👱🏻";
	inline constexpr const char person_with_blond_hair_tone1[] = "👱🏻";
	inline constexpr const char blond_haired_person_tone2[] = "👱🏼";
	inline constexpr const char person_with_blond_hair_tone2[] = "👱🏼";
	inline constexpr const char blond_haired_person_tone3[] = "👱🏽";
	inline constexpr const char person_with_blond_hair_tone3[] = "👱🏽";
	inline constexpr const char blond_haired_person_tone4[] = "👱🏾";
	inline constexpr const char person_with_blond_hair_tone4[] = "👱🏾";
	inline constexpr const char blond_haired_person_tone5[] = "👱🏿";
	inline constexpr const char person_with_blond_hair_tone5[] = "👱🏿";
	inline constexpr const char blond_haired_woman[] = "👱‍♀️";
	inline constexpr const char blond_haired_woman_tone1[] = "👱🏻‍♀️";
	inline constexpr const char blond_haired_woman_light_skin_tone[] = "👱🏻‍♀️";
	inline constexpr const char blond_haired_woman_tone2[] = "👱🏼‍♀️";
	inline constexpr const char blond_haired_woman_medium_light_skin_tone[] = "👱🏼‍♀️";
	inline constexpr const char blond_haired_woman_tone3[] = "👱🏽‍♀️";
	inline constexpr const char blond_haired_woman_medium_skin_tone[] = "👱🏽‍♀️";
	inline constexpr const char blond_haired_woman_tone4[] = "👱🏾‍♀️";
	inline constexpr const char blond_haired_woman_medium_dark_skin_tone[] = "👱🏾‍♀️";
	inline constexpr const char blond_haired_woman_tone5[] = "👱🏿‍♀️";
	inline constexpr const char blond_haired_woman_dark_skin_tone[] = "👱🏿‍♀️";
	inline constexpr const char blond_haired_man[] = "👱‍♂️";
	inline constexpr const char blond_haired_man_tone1[] = "👱🏻‍♂️";
	inline constexpr const char blond_haired_man_light_skin_tone[] = "👱🏻‍♂️";
	inline constexpr const char blond_haired_man_tone2[] = "👱🏼‍♂️";
	inline constexpr const char blond_haired_man_medium_light_skin_tone[] = "👱🏼‍♂️";
	inline constexpr const char blond_haired_man_tone3[] = "👱🏽‍♂️";
	inline constexpr const char blond_haired_man_medium_skin_tone[] = "👱🏽‍♂️";
	inline constexpr const char blond_haired_man_tone4[] = "👱🏾‍♂️";
	inline constexpr const char blond_haired_man_medium_dark_skin_tone[] = "👱🏾‍♂️";
	inline constexpr const char blond_haired_man_tone5[] = "👱🏿‍♂️";
	inline constexpr const char blond_haired_man_dark_skin_tone[] = "👱🏿‍♂️";
	inline constexpr const char person_white_hair[] = "🧑‍🦳";
	inline constexpr const char person_tone1_white_hair[] = "🧑🏻‍🦳";
	inline constexpr const char person_light_skin_tone_white_hair[] = "🧑🏻‍🦳";
	inline constexpr const char person_tone2_white_hair[] = "🧑🏼‍🦳";
	inline constexpr const char person_medium_light_skin_tone_white_hair[] = "🧑🏼‍🦳";
	inline constexpr const char person_tone3_white_hair[] = "🧑🏽‍🦳";
	inline constexpr const char person_medium_skin_tone_white_hair[] = "🧑🏽‍🦳";
	inline constexpr const char person_tone4_white_hair[] = "🧑🏾‍🦳";
	inline constexpr const char person_medium_dark_skin_tone_white_hair[] = "🧑🏾‍🦳";
	inline constexpr const char person_tone5_white_hair[] = "🧑🏿‍🦳";
	inline constexpr const char person_dark_skin_tone_white_hair[] = "🧑🏿‍🦳";
	inline constexpr const char woman_white_haired[] = "👩‍🦳";
	inline constexpr const char woman_white_haired_tone1[] = "👩🏻‍🦳";
	inline constexpr const char woman_white_haired_light_skin_tone[] = "👩🏻‍🦳";
	inline constexpr const char woman_white_haired_tone2[] = "👩🏼‍🦳";
	inline constexpr const char woman_white_haired_medium_light_skin_tone[] = "👩🏼‍🦳";
	inline constexpr const char woman_white_haired_tone3[] = "👩🏽‍🦳";
	inline constexpr const char woman_white_haired_medium_skin_tone[] = "👩🏽‍🦳";
	inline constexpr const char woman_white_haired_tone4[] = "👩🏾‍🦳";
	inline constexpr const char woman_white_haired_medium_dark_skin_tone[] = "👩🏾‍🦳";
	inline constexpr const char woman_white_haired_tone5[] = "👩🏿‍🦳";
	inline constexpr const char woman_white_haired_dark_skin_tone[] = "👩🏿‍🦳";
	inline constexpr const char man_white_haired[] = "👨‍🦳";
	inline constexpr const char man_white_haired_tone1[] = "👨🏻‍🦳";
	inline constexpr const char man_white_haired_light_skin_tone[] = "👨🏻‍🦳";
	inline constexpr const char man_white_haired_tone2[] = "👨🏼‍🦳";
	inline constexpr const char man_white_haired_medium_light_skin_tone[] = "👨🏼‍🦳";
	inline constexpr const char man_white_haired_tone3[] = "👨🏽‍🦳";
	inline constexpr const char man_white_haired_medium_skin_tone[] = "👨🏽‍🦳";
	inline constexpr const char man_white_haired_tone4[] = "👨🏾‍🦳";
	inline constexpr const char man_white_haired_medium_dark_skin_tone[] = "👨🏾‍🦳";
	inline constexpr const char man_white_haired_tone5[] = "👨🏿‍🦳";
	inline constexpr const char man_white_haired_dark_skin_tone[] = "👨🏿‍🦳";
	inline constexpr const char person_bald[] = "🧑‍🦲";
	inline constexpr const char person_tone1_bald[] = "🧑🏻‍🦲";
	inline constexpr const char person_light_skin_tone_bald[] = "🧑🏻‍🦲";
	inline constexpr const char person_tone2_bald[] = "🧑🏼‍🦲";
	inline constexpr const char person_medium_light_skin_tone_bald[] = "🧑🏼‍🦲";
	inline constexpr const char person_tone3_bald[] = "🧑🏽‍🦲";
	inline constexpr const char person_medium_skin_tone_bald[] = "🧑🏽‍🦲";
	inline constexpr const char person_tone4_bald[] = "🧑🏾‍🦲";
	inline constexpr const char person_medium_dark_skin_tone_bald[] = "🧑🏾‍🦲";
	inline constexpr const char person_tone5_bald[] = "🧑🏿‍🦲";
	inline constexpr const char person_dark_skin_tone_bald[] = "🧑🏿‍🦲";
	inline constexpr const char woman_bald[] = "👩‍🦲";
	inline constexpr const char woman_bald_tone1[] = "👩🏻‍🦲";
	inline constexpr const char woman_bald_light_skin_tone[] = "👩🏻‍🦲";
	inline constexpr const char woman_bald_tone2[] = "👩🏼‍🦲";
	inline constexpr const char woman_bald_medium_light_skin_tone[] = "👩🏼‍🦲";
	inline constexpr const char woman_bald_tone3[] = "👩🏽‍🦲";
	inline constexpr const char woman_bald_medium_skin_tone[] = "👩🏽‍🦲";
	inline constexpr const char woman_bald_tone4[] = "👩🏾‍🦲";
	inline constexpr const char woman_bald_medium_dark_skin_tone[] = "👩🏾‍🦲";
	inline constexpr const char woman_bald_tone5[] = "👩🏿‍🦲";
	inline constexpr const char woman_bald_dark_skin_tone[] = "👩🏿‍🦲";
	inline constexpr const char man_bald[] = "👨‍🦲";
	inline constexpr const char man_bald_tone1[] = "👨🏻‍🦲";
	inline constexpr const char man_bald_light_skin_tone[] = "👨🏻‍🦲";
	inline constexpr const char man_bald_tone2[] = "👨🏼‍🦲";
	inline constexpr const char man_bald_medium_light_skin_tone[] = "👨🏼‍🦲";
	inline constexpr const char man_bald_tone3[] = "👨🏽‍🦲";
	inline constexpr const char man_bald_medium_skin_tone[] = "👨🏽‍🦲";
	inline constexpr const char man_bald_tone4[] = "👨🏾‍🦲";
	inline constexpr const char man_bald_medium_dark_skin_tone[] = "👨🏾‍🦲";
	inline constexpr const char man_bald_tone5[] = "👨🏿‍🦲";
	inline constexpr const char man_bald_dark_skin_tone[] = "👨🏿‍🦲";
	inline constexpr const char bearded_person[] = "🧔";
	inline constexpr const char person_beard[] = "🧔";
	inline constexpr const char bearded_person_tone1[] = "🧔🏻";
	inline constexpr const char bearded_person_light_skin_tone[] = "🧔🏻";
	inline constexpr const char bearded_person_tone2[] = "🧔🏼";
	inline constexpr const char bearded_person_medium_light_skin_tone[] = "🧔🏼";
	inline constexpr const char bearded_person_tone3[] = "🧔🏽";
	inline constexpr const char bearded_person_medium_skin_tone[] = "🧔🏽";
	inline constexpr const char bearded_person_tone4[] = "🧔🏾";
	inline constexpr const char bearded_person_medium_dark_skin_tone[] = "🧔🏾";
	inline constexpr const char bearded_person_tone5[] = "🧔🏿";
	inline constexpr const char bearded_person_dark_skin_tone[] = "🧔🏿";
	inline constexpr const char woman_beard[] = "🧔‍♀️";
	inline constexpr const char woman_tone1_beard[] = "🧔🏻‍♀️";
	inline constexpr const char woman_light_skin_tone_beard[] = "🧔🏻‍♀️";
	inline constexpr const char woman_tone2_beard[] = "🧔🏼‍♀️";
	inline constexpr const char woman_medium_light_skin_tone_beard[] = "🧔🏼‍♀️";
	inline constexpr const char woman_tone3_beard[] = "🧔🏽‍♀️";
	inline constexpr const char woman_medium_skin_tone_beard[] = "🧔🏽‍♀️";
	inline constexpr const char woman_tone4_beard[] = "🧔🏾‍♀️";
	inline constexpr const char woman_medium_dark_skin_tone_beard[] = "🧔🏾‍♀️";
	inline constexpr const char woman_tone5_beard[] = "🧔🏿‍♀️";
	inline constexpr const char woman_dark_skin_tone_beard[] = "🧔🏿‍♀️";
	inline constexpr const char man_beard[] = "🧔‍♂️";
	inline constexpr const char man_tone1_beard[] = "🧔🏻‍♂️";
	inline constexpr const char man_light_skin_tone_beard[] = "🧔🏻‍♂️";
	inline constexpr const char man_tone2_beard[] = "🧔🏼‍♂️";
	inline constexpr const char man_medium_light_skin_tone_beard[] = "🧔🏼‍♂️";
	inline constexpr const char man_tone3_beard[] = "🧔🏽‍♂️";
	inline constexpr const char man_medium_skin_tone_beard[] = "🧔🏽‍♂️";
	inline constexpr const char man_tone4_beard[] = "🧔🏾‍♂️";
	inline constexpr const char man_medium_dark_skin_tone_beard[] = "🧔🏾‍♂️";
	inline constexpr const char man_tone5_beard[] = "🧔🏿‍♂️";
	inline constexpr const char man_dark_skin_tone_beard[] = "🧔🏿‍♂️";
	inline constexpr const char older_adult[] = "🧓";
	inline constexpr const char older_person[] = "🧓";
	inline constexpr const char older_adult_tone1[] = "🧓🏻";
	inline constexpr const char older_adult_light_skin_tone[] = "🧓🏻";
	inline constexpr const char older_adult_tone2[] = "🧓🏼";
	inline constexpr const char older_adult_medium_light_skin_tone[] = "🧓🏼";
	inline constexpr const char older_adult_tone3[] = "🧓🏽";
	inline constexpr const char older_adult_medium_skin_tone[] = "🧓🏽";
	inline constexpr const char older_adult_tone4[] = "🧓🏾";
	inline constexpr const char older_adult_medium_dark_skin_tone[] = "🧓🏾";
	inline constexpr const char older_adult_tone5[] = "🧓🏿";
	inline constexpr const char older_adult_dark_skin_tone[] = "🧓🏿";
	inline constexpr const char older_woman[] = "👵";
	inline constexpr const char grandma[] = "👵";
	inline constexpr const char old_woman[] = "👵";
	inline constexpr const char older_woman_tone1[] = "👵🏻";
	inline constexpr const char grandma_tone1[] = "👵🏻";
	inline constexpr const char older_woman_tone2[] = "👵🏼";
	inline constexpr const char grandma_tone2[] = "👵🏼";
	inline constexpr const char older_woman_tone3[] = "👵🏽";
	inline constexpr const char grandma_tone3[] = "👵🏽";
	inline constexpr const char older_woman_tone4[] = "👵🏾";
	inline constexpr const char grandma_tone4[] = "👵🏾";
	inline constexpr const char older_woman_tone5[] = "👵🏿";
	inline constexpr const char grandma_tone5[] = "👵🏿";
	inline constexpr const char older_man[] = "👴";
	inline constexpr const char old_man[] = "👴";
	inline constexpr const char older_man_tone1[] = "👴🏻";
	inline constexpr const char older_man_tone2[] = "👴🏼";
	inline constexpr const char older_man_tone3[] = "👴🏽";
	inline constexpr const char older_man_tone4[] = "👴🏾";
	inline constexpr const char older_man_tone5[] = "👴🏿";
	inline constexpr const char man_with_chinese_cap[] = "👲";
	inline constexpr const char man_with_gua_pi_mao[] = "👲";
	inline constexpr const char man_with_chinese_cap_tone1[] = "👲🏻";
	inline constexpr const char man_with_gua_pi_mao_tone1[] = "👲🏻";
	inline constexpr const char man_with_chinese_cap_tone2[] = "👲🏼";
	inline constexpr const char man_with_gua_pi_mao_tone2[] = "👲🏼";
	inline constexpr const char man_with_chinese_cap_tone3[] = "👲🏽";
	inline constexpr const char man_with_gua_pi_mao_tone3[] = "👲🏽";
	inline constexpr const char man_with_chinese_cap_tone4[] = "👲🏾";
	inline constexpr const char man_with_gua_pi_mao_tone4[] = "👲🏾";
	inline constexpr const char man_with_chinese_cap_tone5[] = "👲🏿";
	inline constexpr const char man_with_gua_pi_mao_tone5[] = "👲🏿";
	inline constexpr const char person_wearing_turban[] = "👳";
	inline constexpr const char man_with_turban[] = "👳";
	inline constexpr const char person_wearing_turban_tone1[] = "👳🏻";
	inline constexpr const char man_with_turban_tone1[] = "👳🏻";
	inline constexpr const char person_wearing_turban_tone2[] = "👳🏼";
	inline constexpr const char man_with_turban_tone2[] = "👳🏼";
	inline constexpr const char person_wearing_turban_tone3[] = "👳🏽";
	inline constexpr const char man_with_turban_tone3[] = "👳🏽";
	inline constexpr const char person_wearing_turban_tone4[] = "👳🏾";
	inline constexpr const char man_with_turban_tone4[] = "👳🏾";
	inline constexpr const char person_wearing_turban_tone5[] = "👳🏿";
	inline constexpr const char man_with_turban_tone5[] = "👳🏿";
	inline constexpr const char woman_wearing_turban[] = "👳‍♀️";
	inline constexpr const char woman_wearing_turban_tone1[] = "👳🏻‍♀️";
	inline constexpr const char woman_wearing_turban_light_skin_tone[] = "👳🏻‍♀️";
	inline constexpr const char woman_wearing_turban_tone2[] = "👳🏼‍♀️";
	inline constexpr const char woman_wearing_turban_medium_light_skin_tone[] = "👳🏼‍♀️";
	inline constexpr const char woman_wearing_turban_tone3[] = "👳🏽‍♀️";
	inline constexpr const char woman_wearing_turban_medium_skin_tone[] = "👳🏽‍♀️";
	inline constexpr const char woman_wearing_turban_tone4[] = "👳🏾‍♀️";
	inline constexpr const char woman_wearing_turban_medium_dark_skin_tone[] = "👳🏾‍♀️";
	inline constexpr const char woman_wearing_turban_tone5[] = "👳🏿‍♀️";
	inline constexpr const char woman_wearing_turban_dark_skin_tone[] = "👳🏿‍♀️";
	inline constexpr const char man_wearing_turban[] = "👳‍♂️";
	inline constexpr const char man_wearing_turban_tone1[] = "👳🏻‍♂️";
	inline constexpr const char man_wearing_turban_light_skin_tone[] = "👳🏻‍♂️";
	inline constexpr const char man_wearing_turban_tone2[] = "👳🏼‍♂️";
	inline constexpr const char man_wearing_turban_medium_light_skin_tone[] = "👳🏼‍♂️";
	inline constexpr const char man_wearing_turban_tone3[] = "👳🏽‍♂️";
	inline constexpr const char man_wearing_turban_medium_skin_tone[] = "👳🏽‍♂️";
	inline constexpr const char man_wearing_turban_tone4[] = "👳🏾‍♂️";
	inline constexpr const char man_wearing_turban_medium_dark_skin_tone[] = "👳🏾‍♂️";
	inline constexpr const char man_wearing_turban_tone5[] = "👳🏿‍♂️";
	inline constexpr const char man_wearing_turban_dark_skin_tone[] = "👳🏿‍♂️";
	inline constexpr const char woman_with_headscarf[] = "🧕";
	inline constexpr const char woman_with_headscarf_tone1[] = "🧕🏻";
	inline constexpr const char woman_with_headscarf_light_skin_tone[] = "🧕🏻";
	inline constexpr const char woman_with_headscarf_tone2[] = "🧕🏼";
	inline constexpr const char woman_with_headscarf_medium_light_skin_tone[] = "🧕🏼";
	inline constexpr const char woman_with_headscarf_tone3[] = "🧕🏽";
	inline constexpr const char woman_with_headscarf_medium_skin_tone[] = "🧕🏽";
	inline constexpr const char woman_with_headscarf_tone4[] = "🧕🏾";
	inline constexpr const char woman_with_headscarf_medium_dark_skin_tone[] = "🧕🏾";
	inline constexpr const char woman_with_headscarf_tone5[] = "🧕🏿";
	inline constexpr const char woman_with_headscarf_dark_skin_tone[] = "🧕🏿";
	inline constexpr const char police_officer[] = "👮";
	inline constexpr const char cop[] = "👮";
	inline constexpr const char police_officer_tone1[] = "👮🏻";
	inline constexpr const char cop_tone1[] = "👮🏻";
	inline constexpr const char police_officer_tone2[] = "👮🏼";
	inline constexpr const char cop_tone2[] = "👮🏼";
	inline constexpr const char police_officer_tone3[] = "👮🏽";
	inline constexpr const char cop_tone3[] = "👮🏽";
	inline constexpr const char police_officer_tone4[] = "👮🏾";
	inline constexpr const char cop_tone4[] = "👮🏾";
	inline constexpr const char police_officer_tone5[] = "👮🏿";
	inline constexpr const char cop_tone5[] = "👮🏿";
	inline constexpr const char woman_police_officer[] = "👮‍♀️";
	inline constexpr const char woman_police_officer_tone1[] = "👮🏻‍♀️";
	inline constexpr const char woman_police_officer_light_skin_tone[] = "👮🏻‍♀️";
	inline constexpr const char woman_police_officer_tone2[] = "👮🏼‍♀️";
	inline constexpr const char woman_police_officer_medium_light_skin_tone[] = "👮🏼‍♀️";
	inline constexpr const char woman_police_officer_tone3[] = "👮🏽‍♀️";
	inline constexpr const char woman_police_officer_medium_skin_tone[] = "👮🏽‍♀️";
	inline constexpr const char woman_police_officer_tone4[] = "👮🏾‍♀️";
	inline constexpr const char woman_police_officer_medium_dark_skin_tone[] = "👮🏾‍♀️";
	inline constexpr const char woman_police_officer_tone5[] = "👮🏿‍♀️";
	inline constexpr const char woman_police_officer_dark_skin_tone[] = "👮🏿‍♀️";
	inline constexpr const char man_police_officer[] = "👮‍♂️";
	inline constexpr const char man_police_officer_tone1[] = "👮🏻‍♂️";
	inline constexpr const char man_police_officer_light_skin_tone[] = "👮🏻‍♂️";
	inline constexpr const char man_police_officer_tone2[] = "👮🏼‍♂️";
	inline constexpr const char man_police_officer_medium_light_skin_tone[] = "👮🏼‍♂️";
	inline constexpr const char man_police_officer_tone3[] = "👮🏽‍♂️";
	inline constexpr const char man_police_officer_medium_skin_tone[] = "👮🏽‍♂️";
	inline constexpr const char man_police_officer_tone4[] = "👮🏾‍♂️";
	inline constexpr const char man_police_officer_medium_dark_skin_tone[] = "👮🏾‍♂️";
	inline constexpr const char man_police_officer_tone5[] = "👮🏿‍♂️";
	inline constexpr const char man_police_officer_dark_skin_tone[] = "👮🏿‍♂️";
	inline constexpr const char construction_worker[] = "👷";
	inline constexpr const char construction_worker_tone1[] = "👷🏻";
	inline constexpr const char construction_worker_tone2[] = "👷🏼";
	inline constexpr const char construction_worker_tone3[] = "👷🏽";
	inline constexpr const char construction_worker_tone4[] = "👷🏾";
	inline constexpr const char construction_worker_tone5[] = "👷🏿";
	inline constexpr const char woman_construction_worker[] = "👷‍♀️";
	inline constexpr const char woman_construction_worker_tone1[] = "👷🏻‍♀️";
	inline constexpr const char woman_construction_worker_light_skin_tone[] = "👷🏻‍♀️";
	inline constexpr const char woman_construction_worker_tone2[] = "👷🏼‍♀️";
	inline constexpr const char woman_construction_worker_medium_light_skin_tone[] = "👷🏼‍♀️";
	inline constexpr const char woman_construction_worker_tone3[] = "👷🏽‍♀️";
	inline constexpr const char woman_construction_worker_medium_skin_tone[] = "👷🏽‍♀️";
	inline constexpr const char woman_construction_worker_tone4[] = "👷🏾‍♀️";
	inline constexpr const char woman_construction_worker_medium_dark_skin_tone[] = "👷🏾‍♀️";
	inline constexpr const char woman_construction_worker_tone5[] = "👷🏿‍♀️";
	inline constexpr const char woman_construction_worker_dark_skin_tone[] = "👷🏿‍♀️";
	inline constexpr const char man_construction_worker[] = "👷‍♂️";
	inline constexpr const char man_construction_worker_tone1[] = "👷🏻‍♂️";
	inline constexpr const char man_construction_worker_light_skin_tone[] = "👷🏻‍♂️";
	inline constexpr const char man_construction_worker_tone2[] = "👷🏼‍♂️";
	inline constexpr const char man_construction_worker_medium_light_skin_tone[] = "👷🏼‍♂️";
	inline constexpr const char man_construction_worker_tone3[] = "👷🏽‍♂️";
	inline constexpr const char man_construction_worker_medium_skin_tone[] = "👷🏽‍♂️";
	inline constexpr const char man_construction_worker_tone4[] = "👷🏾‍♂️";
	inline constexpr const char man_construction_worker_medium_dark_skin_tone[] = "👷🏾‍♂️";
	inline constexpr const char man_construction_worker_tone5[] = "👷🏿‍♂️";
	inline constexpr const char man_construction_worker_dark_skin_tone[] = "👷🏿‍♂️";
	inline constexpr const char guard[] = "💂";
	inline constexpr const char guardsman[] = "💂";
	inline constexpr const char guard_tone1[] = "💂🏻";
	inline constexpr const char guardsman_tone1[] = "💂🏻";
	inline constexpr const char guard_tone2[] = "💂🏼";
	inline constexpr const char guardsman_tone2[] = "💂🏼";
	inline constexpr const char guard_tone3[] = "💂🏽";
	inline constexpr const char guardsman_tone3[] = "💂🏽";
	inline constexpr const char guard_tone4[] = "💂🏾";
	inline constexpr const char guardsman_tone4[] = "💂🏾";
	inline constexpr const char guard_tone5[] = "💂🏿";
	inline constexpr const char guardsman_tone5[] = "💂🏿";
	inline constexpr const char woman_guard[] = "💂‍♀️";
	inline constexpr const char woman_guard_tone1[] = "💂🏻‍♀️";
	inline constexpr const char woman_guard_light_skin_tone[] = "💂🏻‍♀️";
	inline constexpr const char woman_guard_tone2[] = "💂🏼‍♀️";
	inline constexpr const char woman_guard_medium_light_skin_tone[] = "💂🏼‍♀️";
	inline constexpr const char woman_guard_tone3[] = "💂🏽‍♀️";
	inline constexpr const char woman_guard_medium_skin_tone[] = "💂🏽‍♀️";
	inline constexpr const char woman_guard_tone4[] = "💂🏾‍♀️";
	inline constexpr const char woman_guard_medium_dark_skin_tone[] = "💂🏾‍♀️";
	inline constexpr const char woman_guard_tone5[] = "💂🏿‍♀️";
	inline constexpr const char woman_guard_dark_skin_tone[] = "💂🏿‍♀️";
	inline constexpr const char man_guard[] = "💂‍♂️";
	inline constexpr const char man_guard_tone1[] = "💂🏻‍♂️";
	inline constexpr const char man_guard_light_skin_tone[] = "💂🏻‍♂️";
	inline constexpr const char man_guard_tone2[] = "💂🏼‍♂️";
	inline constexpr const char man_guard_medium_light_skin_tone[] = "💂🏼‍♂️";
	inline constexpr const char man_guard_tone3[] = "💂🏽‍♂️";
	inline constexpr const char man_guard_medium_skin_tone[] = "💂🏽‍♂️";
	inline constexpr const char man_guard_tone4[] = "💂🏾‍♂️";
	inline constexpr const char man_guard_medium_dark_skin_tone[] = "💂🏾‍♂️";
	inline constexpr const char man_guard_tone5[] = "💂🏿‍♂️";
	inline constexpr const char man_guard_dark_skin_tone[] = "💂🏿‍♂️";
	inline constexpr const char detective[] = "🕵️";
	inline constexpr const char spy[] = "🕵️";
	inline constexpr const char sleuth_or_spy[] = "🕵️";
	inline constexpr const char detective_tone1[] = "🕵🏻";
	inline constexpr const char spy_tone1[] = "🕵🏻";
	inline constexpr const char sleuth_or_spy_tone1[] = "🕵🏻";
	inline constexpr const char detective_tone2[] = "🕵🏼";
	inline constexpr const char spy_tone2[] = "🕵🏼";
	inline constexpr const char sleuth_or_spy_tone2[] = "🕵🏼";
	inline constexpr const char detective_tone3[] = "🕵🏽";
	inline constexpr const char spy_tone3[] = "🕵🏽";
	inline constexpr const char sleuth_or_spy_tone3[] = "🕵🏽";
	inline constexpr const char detective_tone4[] = "🕵🏾";
	inline constexpr const char spy_tone4[] = "🕵🏾";
	inline constexpr const char sleuth_or_spy_tone4[] = "🕵🏾";
	inline constexpr const char detective_tone5[] = "🕵🏿";
	inline constexpr const char spy_tone5[] = "🕵🏿";
	inline constexpr const char sleuth_or_spy_tone5[] = "🕵🏿";
	inline constexpr const char woman_detective[] = "🕵️‍♀️";
	inline constexpr const char woman_detective_tone1[] = "🕵🏻‍♀️";
	inline constexpr const char woman_detective_light_skin_tone[] = "🕵🏻‍♀️";
	inline constexpr const char woman_detective_tone2[] = "🕵🏼‍♀️";
	inline constexpr const char woman_detective_medium_light_skin_tone[] = "🕵🏼‍♀️";
	inline constexpr const char woman_detective_tone3[] = "🕵🏽‍♀️";
	inline constexpr const char woman_detective_medium_skin_tone[] = "🕵🏽‍♀️";
	inline constexpr const char woman_detective_tone4[] = "🕵🏾‍♀️";
	inline constexpr const char woman_detective_medium_dark_skin_tone[] = "🕵🏾‍♀️";
	inline constexpr const char woman_detective_tone5[] = "🕵🏿‍♀️";
	inline constexpr const char woman_detective_dark_skin_tone[] = "🕵🏿‍♀️";
	inline constexpr const char man_detective[] = "🕵️‍♂️";
	inline constexpr const char man_detective_tone1[] = "🕵🏻‍♂️";
	inline constexpr const char man_detective_light_skin_tone[] = "🕵🏻‍♂️";
	inline constexpr const char man_detective_tone2[] = "🕵🏼‍♂️";
	inline constexpr const char man_detective_medium_light_skin_tone[] = "🕵🏼‍♂️";
	inline constexpr const char man_detective_tone3[] = "🕵🏽‍♂️";
	inline constexpr const char man_detective_medium_skin_tone[] = "🕵🏽‍♂️";
	inline constexpr const char man_detective_tone4[] = "🕵🏾‍♂️";
	inline constexpr const char man_detective_medium_dark_skin_tone[] = "🕵🏾‍♂️";
	inline constexpr const char man_detective_tone5[] = "🕵🏿‍♂️";
	inline constexpr const char man_detective_dark_skin_tone[] = "🕵🏿‍♂️";
	inline constexpr const char health_worker[] = "🧑‍⚕️";
	inline constexpr const char health_worker_tone1[] = "🧑🏻‍⚕️";
	inline constexpr const char health_worker_light_skin_tone[] = "🧑🏻‍⚕️";
	inline constexpr const char health_worker_tone2[] = "🧑🏼‍⚕️";
	inline constexpr const char health_worker_medium_light_skin_tone[] = "🧑🏼‍⚕️";
	inline constexpr const char health_worker_tone3[] = "🧑🏽‍⚕️";
	inline constexpr const char health_worker_medium_skin_tone[] = "🧑🏽‍⚕️";
	inline constexpr const char health_worker_tone4[] = "🧑🏾‍⚕️";
	inline constexpr const char health_worker_medium_dark_skin_tone[] = "🧑🏾‍⚕️";
	inline constexpr const char health_worker_tone5[] = "🧑🏿‍⚕️";
	inline constexpr const char health_worker_dark_skin_tone[] = "🧑🏿‍⚕️";
	inline constexpr const char woman_health_worker[] = "👩‍⚕️";
	inline constexpr const char woman_health_worker_tone1[] = "👩🏻‍⚕️";
	inline constexpr const char woman_health_worker_light_skin_tone[] = "👩🏻‍⚕️";
	inline constexpr const char woman_health_worker_tone2[] = "👩🏼‍⚕️";
	inline constexpr const char woman_health_worker_medium_light_skin_tone[] = "👩🏼‍⚕️";
	inline constexpr const char woman_health_worker_tone3[] = "👩🏽‍⚕️";
	inline constexpr const char woman_health_worker_medium_skin_tone[] = "👩🏽‍⚕️";
	inline constexpr const char woman_health_worker_tone4[] = "👩🏾‍⚕️";
	inline constexpr const char woman_health_worker_medium_dark_skin_tone[] = "👩🏾‍⚕️";
	inline constexpr const char woman_health_worker_tone5[] = "👩🏿‍⚕️";
	inline constexpr const char woman_health_worker_dark_skin_tone[] = "👩🏿‍⚕️";
	inline constexpr const char man_health_worker[] = "👨‍⚕️";
	inline constexpr const char man_health_worker_tone1[] = "👨🏻‍⚕️";
	inline constexpr const char man_health_worker_light_skin_tone[] = "👨🏻‍⚕️";
	inline constexpr const char man_health_worker_tone2[] = "👨🏼‍⚕️";
	inline constexpr const char man_health_worker_medium_light_skin_tone[] = "👨🏼‍⚕️";
	inline constexpr const char man_health_worker_tone3[] = "👨🏽‍⚕️";
	inline constexpr const char man_health_worker_medium_skin_tone[] = "👨🏽‍⚕️";
	inline constexpr const char man_health_worker_tone4[] = "👨🏾‍⚕️";
	inline constexpr const char man_health_worker_medium_dark_skin_tone[] = "👨🏾‍⚕️";
	inline constexpr const char man_health_worker_tone5[] = "👨🏿‍⚕️";
	inline constexpr const char man_health_worker_dark_skin_tone[] = "👨🏿‍⚕️";
	inline constexpr const char farmer[] = "🧑‍🌾";
	inline constexpr const char farmer_tone1[] = "🧑🏻‍🌾";
	inline constexpr const char farmer_light_skin_tone[] = "🧑🏻‍🌾";
	inline constexpr const char farmer_tone2[] = "🧑🏼‍🌾";
	inline constexpr const char farmer_medium_light_skin_tone[] = "🧑🏼‍🌾";
	inline constexpr const char farmer_tone3[] = "🧑🏽‍🌾";
	inline constexpr const char farmer_medium_skin_tone[] = "🧑🏽‍🌾";
	inline constexpr const char farmer_tone4[] = "🧑🏾‍🌾";
	inline constexpr const char farmer_medium_dark_skin_tone[] = "🧑🏾‍🌾";
	inline constexpr const char farmer_tone5[] = "🧑🏿‍🌾";
	inline constexpr const char farmer_dark_skin_tone[] = "🧑🏿‍🌾";
	inline constexpr const char woman_farmer[] = "👩‍🌾";
	inline constexpr const char woman_farmer_tone1[] = "👩🏻‍🌾";
	inline constexpr const char woman_farmer_light_skin_tone[] = "👩🏻‍🌾";
	inline constexpr const char woman_farmer_tone2[] = "👩🏼‍🌾";
	inline constexpr const char woman_farmer_medium_light_skin_tone[] = "👩🏼‍🌾";
	inline constexpr const char woman_farmer_tone3[] = "👩🏽‍🌾";
	inline constexpr const char woman_farmer_medium_skin_tone[] = "👩🏽‍🌾";
	inline constexpr const char woman_farmer_tone4[] = "👩🏾‍🌾";
	inline constexpr const char woman_farmer_medium_dark_skin_tone[] = "👩🏾‍🌾";
	inline constexpr const char woman_farmer_tone5[] = "👩🏿‍🌾";
	inline constexpr const char woman_farmer_dark_skin_tone[] = "👩🏿‍🌾";
	inline constexpr const char man_farmer[] = "👨‍🌾";
	inline constexpr const char man_farmer_tone1[] = "👨🏻‍🌾";
	inline constexpr const char man_farmer_light_skin_tone[] = "👨🏻‍🌾";
	inline constexpr const char man_farmer_tone2[] = "👨🏼‍🌾";
	inline constexpr const char man_farmer_medium_light_skin_tone[] = "👨🏼‍🌾";
	inline constexpr const char man_farmer_tone3[] = "👨🏽‍🌾";
	inline constexpr const char man_farmer_medium_skin_tone[] = "👨🏽‍🌾";
	inline constexpr const char man_farmer_tone4[] = "👨🏾‍🌾";
	inline constexpr const char man_farmer_medium_dark_skin_tone[] = "👨🏾‍🌾";
	inline constexpr const char man_farmer_tone5[] = "👨🏿‍🌾";
	inline constexpr const char man_farmer_dark_skin_tone[] = "👨🏿‍🌾";
	inline constexpr const char cook[] = "🧑‍🍳";
	inline constexpr const char cook_tone1[] = "🧑🏻‍🍳";
	inline constexpr const char cook_light_skin_tone[] = "🧑🏻‍🍳";
	inline constexpr const char cook_tone2[] = "🧑🏼‍🍳";
	inline constexpr const char cook_medium_light_skin_tone[] = "🧑🏼‍🍳";
	inline constexpr const char cook_tone3[] = "🧑🏽‍🍳";
	inline constexpr const char cook_medium_skin_tone[] = "🧑🏽‍🍳";
	inline constexpr const char cook_tone4[] = "🧑🏾‍🍳";
	inline constexpr const char cook_medium_dark_skin_tone[] = "🧑🏾‍🍳";
	inline constexpr const char cook_tone5[] = "🧑🏿‍🍳";
	inline constexpr const char cook_dark_skin_tone[] = "🧑🏿‍🍳";
	inline constexpr const char woman_cook[] = "👩‍🍳";
	inline constexpr const char woman_cook_tone1[] = "👩🏻‍🍳";
	inline constexpr const char woman_cook_light_skin_tone[] = "👩🏻‍🍳";
	inline constexpr const char woman_cook_tone2[] = "👩🏼‍🍳";
	inline constexpr const char woman_cook_medium_light_skin_tone[] = "👩🏼‍🍳";
	inline constexpr const char woman_cook_tone3[] = "👩🏽‍🍳";
	inline constexpr const char woman_cook_medium_skin_tone[] = "👩🏽‍🍳";
	inline constexpr const char woman_cook_tone4[] = "👩🏾‍🍳";
	inline constexpr const char woman_cook_medium_dark_skin_tone[] = "👩🏾‍🍳";
	inline constexpr const char woman_cook_tone5[] = "👩🏿‍🍳";
	inline constexpr const char woman_cook_dark_skin_tone[] = "👩🏿‍🍳";
	inline constexpr const char man_cook[] = "👨‍🍳";
	inline constexpr const char man_cook_tone1[] = "👨🏻‍🍳";
	inline constexpr const char man_cook_light_skin_tone[] = "👨🏻‍🍳";
	inline constexpr const char man_cook_tone2[] = "👨🏼‍🍳";
	inline constexpr const char man_cook_medium_light_skin_tone[] = "👨🏼‍🍳";
	inline constexpr const char man_cook_tone3[] = "👨🏽‍🍳";
	inline constexpr const char man_cook_medium_skin_tone[] = "👨🏽‍🍳";
	inline constexpr const char man_cook_tone4[] = "👨🏾‍🍳";
	inline constexpr const char man_cook_medium_dark_skin_tone[] = "👨🏾‍🍳";
	inline constexpr const char man_cook_tone5[] = "👨🏿‍🍳";
	inline constexpr const char man_cook_dark_skin_tone[] = "👨🏿‍🍳";
	inline constexpr const char student[] = "🧑‍🎓";
	inline constexpr const char student_tone1[] = "🧑🏻‍🎓";
	inline constexpr const char student_light_skin_tone[] = "🧑🏻‍🎓";
	inline constexpr const char student_tone2[] = "🧑🏼‍🎓";
	inline constexpr const char student_medium_light_skin_tone[] = "🧑🏼‍🎓";
	inline constexpr const char student_tone3[] = "🧑🏽‍🎓";
	inline constexpr const char student_medium_skin_tone[] = "🧑🏽‍🎓";
	inline constexpr const char student_tone4[] = "🧑🏾‍🎓";
	inline constexpr const char student_medium_dark_skin_tone[] = "🧑🏾‍🎓";
	inline constexpr const char student_tone5[] = "🧑🏿‍🎓";
	inline constexpr const char student_dark_skin_tone[] = "🧑🏿‍🎓";
	inline constexpr const char woman_student[] = "👩‍🎓";
	inline constexpr const char woman_student_tone1[] = "👩🏻‍🎓";
	inline constexpr const char woman_student_light_skin_tone[] = "👩🏻‍🎓";
	inline constexpr const char woman_student_tone2[] = "👩🏼‍🎓";
	inline constexpr const char woman_student_medium_light_skin_tone[] = "👩🏼‍🎓";
	inline constexpr const char woman_student_tone3[] = "👩🏽‍🎓";
	inline constexpr const char woman_student_medium_skin_tone[] = "👩🏽‍🎓";
	inline constexpr const char woman_student_tone4[] = "👩🏾‍🎓";
	inline constexpr const char woman_student_medium_dark_skin_tone[] = "👩🏾‍🎓";
	inline constexpr const char woman_student_tone5[] = "👩🏿‍🎓";
	inline constexpr const char woman_student_dark_skin_tone[] = "👩🏿‍🎓";
	inline constexpr const char man_student[] = "👨‍🎓";
	inline constexpr const char man_student_tone1[] = "👨🏻‍🎓";
	inline constexpr const char man_student_light_skin_tone[] = "👨🏻‍🎓";
	inline constexpr const char man_student_tone2[] = "👨🏼‍🎓";
	inline constexpr const char man_student_medium_light_skin_tone[] = "👨🏼‍🎓";
	inline constexpr const char man_student_tone3[] = "👨🏽‍🎓";
	inline constexpr const char man_student_medium_skin_tone[] = "👨🏽‍🎓";
	inline constexpr const char man_student_tone4[] = "👨🏾‍🎓";
	inline constexpr const char man_student_medium_dark_skin_tone[] = "👨🏾‍🎓";
	inline constexpr const char man_student_tone5[] = "👨🏿‍🎓";
	inline constexpr const char man_student_dark_skin_tone[] = "👨🏿‍🎓";
	inline constexpr const char singer[] = "🧑‍🎤";
	inline constexpr const char singer_tone1[] = "🧑🏻‍🎤";
	inline constexpr const char singer_light_skin_tone[] = "🧑🏻‍🎤";
	inline constexpr const char singer_tone2[] = "🧑🏼‍🎤";
	inline constexpr const char singer_medium_light_skin_tone[] = "🧑🏼‍🎤";
	inline constexpr const char singer_tone3[] = "🧑🏽‍🎤";
	inline constexpr const char singer_medium_skin_tone[] = "🧑🏽‍🎤";
	inline constexpr const char singer_tone4[] = "🧑🏾‍🎤";
	inline constexpr const char singer_medium_dark_skin_tone[] = "🧑🏾‍🎤";
	inline constexpr const char singer_tone5[] = "🧑🏿‍🎤";
	inline constexpr const char singer_dark_skin_tone[] = "🧑🏿‍🎤";
	inline constexpr const char woman_singer[] = "👩‍🎤";
	inline constexpr const char woman_singer_tone1[] = "👩🏻‍🎤";
	inline constexpr const char woman_singer_light_skin_tone[] = "👩🏻‍🎤";
	inline constexpr const char woman_singer_tone2[] = "👩🏼‍🎤";
	inline constexpr const char woman_singer_medium_light_skin_tone[] = "👩🏼‍🎤";
	inline constexpr const char woman_singer_tone3[] = "👩🏽‍🎤";
	inline constexpr const char woman_singer_medium_skin_tone[] = "👩🏽‍🎤";
	inline constexpr const char woman_singer_tone4[] = "👩🏾‍🎤";
	inline constexpr const char woman_singer_medium_dark_skin_tone[] = "👩🏾‍🎤";
	inline constexpr const char woman_singer_tone5[] = "👩🏿‍🎤";
	inline constexpr const char woman_singer_dark_skin_tone[] = "👩🏿‍🎤";
	inline constexpr const char man_singer[] = "👨‍🎤";
	inline constexpr const char man_singer_tone1[] = "👨🏻‍🎤";
	inline constexpr const char man_singer_light_skin_tone[] = "👨🏻‍🎤";
	inline constexpr const char man_singer_tone2[] = "👨🏼‍🎤";
	inline constexpr const char man_singer_medium_light_skin_tone[] = "👨🏼‍🎤";
	inline constexpr const char man_singer_tone3[] = "👨🏽‍🎤";
	inline constexpr const char man_singer_medium_skin_tone[] = "👨🏽‍🎤";
	inline constexpr const char man_singer_tone4[] = "👨🏾‍🎤";
	inline constexpr const char man_singer_medium_dark_skin_tone[] = "👨🏾‍🎤";
	inline constexpr const char man_singer_tone5[] = "👨🏿‍🎤";
	inline constexpr const char man_singer_dark_skin_tone[] = "👨🏿‍🎤";
	inline constexpr const char teacher[] = "🧑‍🏫";
	inline constexpr const char teacher_tone1[] = "🧑🏻‍🏫";
	inline constexpr const char teacher_light_skin_tone[] = "🧑🏻‍🏫";
	inline constexpr const char teacher_tone2[] = "🧑🏼‍🏫";
	inline constexpr const char teacher_medium_light_skin_tone[] = "🧑🏼‍🏫";
	inline constexpr const char teacher_tone3[] = "🧑🏽‍🏫";
	inline constexpr const char teacher_medium_skin_tone[] = "🧑🏽‍🏫";
	inline constexpr const char teacher_tone4[] = "🧑🏾‍🏫";
	inline constexpr const char teacher_medium_dark_skin_tone[] = "🧑🏾‍🏫";
	inline constexpr const char teacher_tone5[] = "🧑🏿‍🏫";
	inline constexpr const char teacher_dark_skin_tone[] = "🧑🏿‍🏫";
	inline constexpr const char woman_teacher[] = "👩‍🏫";
	inline constexpr const char woman_teacher_tone1[] = "👩🏻‍🏫";
	inline constexpr const char woman_teacher_light_skin_tone[] = "👩🏻‍🏫";
	inline constexpr const char woman_teacher_tone2[] = "👩🏼‍🏫";
	inline constexpr const char woman_teacher_medium_light_skin_tone[] = "👩🏼‍🏫";
	inline constexpr const char woman_teacher_tone3[] = "👩🏽‍🏫";
	inline constexpr const char woman_teacher_medium_skin_tone[] = "👩🏽‍🏫";
	inline constexpr const char woman_teacher_tone4[] = "👩🏾‍🏫";
	inline constexpr const char woman_teacher_medium_dark_skin_tone[] = "👩🏾‍🏫";
	inline constexpr const char woman_teacher_tone5[] = "👩🏿‍🏫";
	inline constexpr const char woman_teacher_dark_skin_tone[] = "👩🏿‍🏫";
	inline constexpr const char man_teacher[] = "👨‍🏫";
	inline constexpr const char man_teacher_tone1[] = "👨🏻‍🏫";
	inline constexpr const char man_teacher_light_skin_tone[] = "👨🏻‍🏫";
	inline constexpr const char man_teacher_tone2[] = "👨🏼‍🏫";
	inline constexpr const char man_teacher_medium_light_skin_tone[] = "👨🏼‍🏫";
	inline constexpr const char man_teacher_tone3[] = "👨🏽‍🏫";
	inline constexpr const char man_teacher_medium_skin_tone[] = "👨🏽‍🏫";
	inline constexpr const char man_teacher_tone4[] = "👨🏾‍🏫";
	inline constexpr const char man_teacher_medium_dark_skin_tone[] = "👨🏾‍🏫";
	inline constexpr const char man_teacher_tone5[] = "👨🏿‍🏫";
	inline constexpr const char man_teacher_dark_skin_tone[] = "👨🏿‍🏫";
	inline constexpr const char factory_worker[] = "🧑‍🏭";
	inline constexpr const char factory_worker_tone1[] = "🧑🏻‍🏭";
	inline constexpr const char factory_worker_light_skin_tone[] = "🧑🏻‍🏭";
	inline constexpr const char factory_worker_tone2[] = "🧑🏼‍🏭";
	inline constexpr const char factory_worker_medium_light_skin_tone[] = "🧑🏼‍🏭";
	inline constexpr const char factory_worker_tone3[] = "🧑🏽‍🏭";
	inline constexpr const char factory_worker_medium_skin_tone[] = "🧑🏽‍🏭";
	inline constexpr const char factory_worker_tone4[] = "🧑🏾‍🏭";
	inline constexpr const char factory_worker_medium_dark_skin_tone[] = "🧑🏾‍🏭";
	inline constexpr const char factory_worker_tone5[] = "🧑🏿‍🏭";
	inline constexpr const char factory_worker_dark_skin_tone[] = "🧑🏿‍🏭";
	inline constexpr const char woman_factory_worker[] = "👩‍🏭";
	inline constexpr const char woman_factory_worker_tone1[] = "👩🏻‍🏭";
	inline constexpr const char woman_factory_worker_light_skin_tone[] = "👩🏻‍🏭";
	inline constexpr const char woman_factory_worker_tone2[] = "👩🏼‍🏭";
	inline constexpr const char woman_factory_worker_medium_light_skin_tone[] = "👩🏼‍🏭";
	inline constexpr const char woman_factory_worker_tone3[] = "👩🏽‍🏭";
	inline constexpr const char woman_factory_worker_medium_skin_tone[] = "👩🏽‍🏭";
	inline constexpr const char woman_factory_worker_tone4[] = "👩🏾‍🏭";
	inline constexpr const char woman_factory_worker_medium_dark_skin_tone[] = "👩🏾‍🏭";
	inline constexpr const char woman_factory_worker_tone5[] = "👩🏿‍🏭";
	inline constexpr const char woman_factory_worker_dark_skin_tone[] = "👩🏿‍🏭";
	inline constexpr const char man_factory_worker[] = "👨‍🏭";
	inline constexpr const char man_factory_worker_tone1[] = "👨🏻‍🏭";
	inline constexpr const char man_factory_worker_light_skin_tone[] = "👨🏻‍🏭";
	inline constexpr const char man_factory_worker_tone2[] = "👨🏼‍🏭";
	inline constexpr const char man_factory_worker_medium_light_skin_tone[] = "👨🏼‍🏭";
	inline constexpr const char man_factory_worker_tone3[] = "👨🏽‍🏭";
	inline constexpr const char man_factory_worker_medium_skin_tone[] = "👨🏽‍🏭";
	inline constexpr const char man_factory_worker_tone4[] = "👨🏾‍🏭";
	inline constexpr const char man_factory_worker_medium_dark_skin_tone[] = "👨🏾‍🏭";
	inline constexpr const char man_factory_worker_tone5[] = "👨🏿‍🏭";
	inline constexpr const char man_factory_worker_dark_skin_tone[] = "👨🏿‍🏭";
	inline constexpr const char technologist[] = "🧑‍💻";
	inline constexpr const char technologist_tone1[] = "🧑🏻‍💻";
	inline constexpr const char technologist_light_skin_tone[] = "🧑🏻‍💻";
	inline constexpr const char technologist_tone2[] = "🧑🏼‍💻";
	inline constexpr const char technologist_medium_light_skin_tone[] = "🧑🏼‍💻";
	inline constexpr const char technologist_tone3[] = "🧑🏽‍💻";
	inline constexpr const char technologist_medium_skin_tone[] = "🧑🏽‍💻";
	inline constexpr const char technologist_tone4[] = "🧑🏾‍💻";
	inline constexpr const char technologist_medium_dark_skin_tone[] = "🧑🏾‍💻";
	inline constexpr const char technologist_tone5[] = "🧑🏿‍💻";
	inline constexpr const char technologist_dark_skin_tone[] = "🧑🏿‍💻";
	inline constexpr const char woman_technologist[] = "👩‍💻";
	inline constexpr const char woman_technologist_tone1[] = "👩🏻‍💻";
	inline constexpr const char woman_technologist_light_skin_tone[] = "👩🏻‍💻";
	inline constexpr const char woman_technologist_tone2[] = "👩🏼‍💻";
	inline constexpr const char woman_technologist_medium_light_skin_tone[] = "👩🏼‍💻";
	inline constexpr const char woman_technologist_tone3[] = "👩🏽‍💻";
	inline constexpr const char woman_technologist_medium_skin_tone[] = "👩🏽‍💻";
	inline constexpr const char woman_technologist_tone4[] = "👩🏾‍💻";
	inline constexpr const char woman_technologist_medium_dark_skin_tone[] = "👩🏾‍💻";
	inline constexpr const char woman_technologist_tone5[] = "👩🏿‍💻";
	inline constexpr const char woman_technologist_dark_skin_tone[] = "👩🏿‍💻";
	inline constexpr const char man_technologist[] = "👨‍💻";
	inline constexpr const char man_technologist_tone1[] = "👨🏻‍💻";
	inline constexpr const char man_technologist_light_skin_tone[] = "👨🏻‍💻";
	inline constexpr const char man_technologist_tone2[] = "👨🏼‍💻";
	inline constexpr const char man_technologist_medium_light_skin_tone[] = "👨🏼‍💻";
	inline constexpr const char man_technologist_tone3[] = "👨🏽‍💻";
	inline constexpr const char man_technologist_medium_skin_tone[] = "👨🏽‍💻";
	inline constexpr const char man_technologist_tone4[] = "👨🏾‍💻";
	inline constexpr const char man_technologist_medium_dark_skin_tone[] = "👨🏾‍💻";
	inline constexpr const char man_technologist_tone5[] = "👨🏿‍💻";
	inline constexpr const char man_technologist_dark_skin_tone[] = "👨🏿‍💻";
	inline constexpr const char office_worker[] = "🧑‍💼";
	inline constexpr const char office_worker_tone1[] = "🧑🏻‍💼";
	inline constexpr const char office_worker_light_skin_tone[] = "🧑🏻‍💼";
	inline constexpr const char office_worker_tone2[] = "🧑🏼‍💼";
	inline constexpr const char office_worker_medium_light_skin_tone[] = "🧑🏼‍💼";
	inline constexpr const char office_worker_tone3[] = "🧑🏽‍💼";
	inline constexpr const char office_worker_medium_skin_tone[] = "🧑🏽‍💼";
	inline constexpr const char office_worker_tone4[] = "🧑🏾‍💼";
	inline constexpr const char office_worker_medium_dark_skin_tone[] = "🧑🏾‍💼";
	inline constexpr const char office_worker_tone5[] = "🧑🏿‍💼";
	inline constexpr const char office_worker_dark_skin_tone[] = "🧑🏿‍💼";
	inline constexpr const char woman_office_worker[] = "👩‍💼";
	inline constexpr const char woman_office_worker_tone1[] = "👩🏻‍💼";
	inline constexpr const char woman_office_worker_light_skin_tone[] = "👩🏻‍💼";
	inline constexpr const char woman_office_worker_tone2[] = "👩🏼‍💼";
	inline constexpr const char woman_office_worker_medium_light_skin_tone[] = "👩🏼‍💼";
	inline constexpr const char woman_office_worker_tone3[] = "👩🏽‍💼";
	inline constexpr const char woman_office_worker_medium_skin_tone[] = "👩🏽‍💼";
	inline constexpr const char woman_office_worker_tone4[] = "👩🏾‍💼";
	inline constexpr const char woman_office_worker_medium_dark_skin_tone[] = "👩🏾‍💼";
	inline constexpr const char woman_office_worker_tone5[] = "👩🏿‍💼";
	inline constexpr const char woman_office_worker_dark_skin_tone[] = "👩🏿‍💼";
	inline constexpr const char man_office_worker[] = "👨‍💼";
	inline constexpr const char man_office_worker_tone1[] = "👨🏻‍💼";
	inline constexpr const char man_office_worker_light_skin_tone[] = "👨🏻‍💼";
	inline constexpr const char man_office_worker_tone2[] = "👨🏼‍💼";
	inline constexpr const char man_office_worker_medium_light_skin_tone[] = "👨🏼‍💼";
	inline constexpr const char man_office_worker_tone3[] = "👨🏽‍💼";
	inline constexpr const char man_office_worker_medium_skin_tone[] = "👨🏽‍💼";
	inline constexpr const char man_office_worker_tone4[] = "👨🏾‍💼";
	inline constexpr const char man_office_worker_medium_dark_skin_tone[] = "👨🏾‍💼";
	inline constexpr const char man_office_worker_tone5[] = "👨🏿‍💼";
	inline constexpr const char man_office_worker_dark_skin_tone[] = "👨🏿‍💼";
	inline constexpr const char mechanic[] = "🧑‍🔧";
	inline constexpr const char mechanic_tone1[] = "🧑🏻‍🔧";
	inline constexpr const char mechanic_light_skin_tone[] = "🧑🏻‍🔧";
	inline constexpr const char mechanic_tone2[] = "🧑🏼‍🔧";
	inline constexpr const char mechanic_medium_light_skin_tone[] = "🧑🏼‍🔧";
	inline constexpr const char mechanic_tone3[] = "🧑🏽‍🔧";
	inline constexpr const char mechanic_medium_skin_tone[] = "🧑🏽‍🔧";
	inline constexpr const char mechanic_tone4[] = "🧑🏾‍🔧";
	inline constexpr const char mechanic_medium_dark_skin_tone[] = "🧑🏾‍🔧";
	inline constexpr const char mechanic_tone5[] = "🧑🏿‍🔧";
	inline constexpr const char mechanic_dark_skin_tone[] = "🧑🏿‍🔧";
	inline constexpr const char woman_mechanic[] = "👩‍🔧";
	inline constexpr const char woman_mechanic_tone1[] = "👩🏻‍🔧";
	inline constexpr const char woman_mechanic_light_skin_tone[] = "👩🏻‍🔧";
	inline constexpr const char woman_mechanic_tone2[] = "👩🏼‍🔧";
	inline constexpr const char woman_mechanic_medium_light_skin_tone[] = "👩🏼‍🔧";
	inline constexpr const char woman_mechanic_tone3[] = "👩🏽‍🔧";
	inline constexpr const char woman_mechanic_medium_skin_tone[] = "👩🏽‍🔧";
	inline constexpr const char woman_mechanic_tone4[] = "👩🏾‍🔧";
	inline constexpr const char woman_mechanic_medium_dark_skin_tone[] = "👩🏾‍🔧";
	inline constexpr const char woman_mechanic_tone5[] = "👩🏿‍🔧";
	inline constexpr const char woman_mechanic_dark_skin_tone[] = "👩🏿‍🔧";
	inline constexpr const char man_mechanic[] = "👨‍🔧";
	inline constexpr const char man_mechanic_tone1[] = "👨🏻‍🔧";
	inline constexpr const char man_mechanic_light_skin_tone[] = "👨🏻‍🔧";
	inline constexpr const char man_mechanic_tone2[] = "👨🏼‍🔧";
	inline constexpr const char man_mechanic_medium_light_skin_tone[] = "👨🏼‍🔧";
	inline constexpr const char man_mechanic_tone3[] = "👨🏽‍🔧";
	inline constexpr const char man_mechanic_medium_skin_tone[] = "👨🏽‍🔧";
	inline constexpr const char man_mechanic_tone4[] = "👨🏾‍🔧";
	inline constexpr const char man_mechanic_medium_dark_skin_tone[] = "👨🏾‍🔧";
	inline constexpr const char man_mechanic_tone5[] = "👨🏿‍🔧";
	inline constexpr const char man_mechanic_dark_skin_tone[] = "👨🏿‍🔧";
	inline constexpr const char scientist[] = "🧑‍🔬";
	inline constexpr const char scientist_tone1[] = "🧑🏻‍🔬";
	inline constexpr const char scientist_light_skin_tone[] = "🧑🏻‍🔬";
	inline constexpr const char scientist_tone2[] = "🧑🏼‍🔬";
	inline constexpr const char scientist_medium_light_skin_tone[] = "🧑🏼‍🔬";
	inline constexpr const char scientist_tone3[] = "🧑🏽‍🔬";
	inline constexpr const char scientist_medium_skin_tone[] = "🧑🏽‍🔬";
	inline constexpr const char scientist_tone4[] = "🧑🏾‍🔬";
	inline constexpr const char scientist_medium_dark_skin_tone[] = "🧑🏾‍🔬";
	inline constexpr const char scientist_tone5[] = "🧑🏿‍🔬";
	inline constexpr const char scientist_dark_skin_tone[] = "🧑🏿‍🔬";
	inline constexpr const char woman_scientist[] = "👩‍🔬";
	inline constexpr const char woman_scientist_tone1[] = "👩🏻‍🔬";
	inline constexpr const char woman_scientist_light_skin_tone[] = "👩🏻‍🔬";
	inline constexpr const char woman_scientist_tone2[] = "👩🏼‍🔬";
	inline constexpr const char woman_scientist_medium_light_skin_tone[] = "👩🏼‍🔬";
	inline constexpr const char woman_scientist_tone3[] = "👩🏽‍🔬";
	inline constexpr const char woman_scientist_medium_skin_tone[] = "👩🏽‍🔬";
	inline constexpr const char woman_scientist_tone4[] = "👩🏾‍🔬";
	inline constexpr const char woman_scientist_medium_dark_skin_tone[] = "👩🏾‍🔬";
	inline constexpr const char woman_scientist_tone5[] = "👩🏿‍🔬";
	inline constexpr const char woman_scientist_dark_skin_tone[] = "👩🏿‍🔬";
	inline constexpr const char man_scientist[] = "👨‍🔬";
	inline constexpr const char man_scientist_tone1[] = "👨🏻‍🔬";
	inline constexpr const char man_scientist_light_skin_tone[] = "👨🏻‍🔬";
	inline constexpr const char man_scientist_tone2[] = "👨🏼‍🔬";
	inline constexpr const char man_scientist_medium_light_skin_tone[] = "👨🏼‍🔬";
	inline constexpr const char man_scientist_tone3[] = "👨🏽‍🔬";
	inline constexpr const char man_scientist_medium_skin_tone[] = "👨🏽‍🔬";
	inline constexpr const char man_scientist_tone4[] = "👨🏾‍🔬";
	inline constexpr const char man_scientist_medium_dark_skin_tone[] = "👨🏾‍🔬";
	inline constexpr const char man_scientist_tone5[] = "👨🏿‍🔬";
	inline constexpr const char man_scientist_dark_skin_tone[] = "👨🏿‍🔬";
	inline constexpr const char artist[] = "🧑‍🎨";
	inline constexpr const char artist_tone1[] = "🧑🏻‍🎨";
	inline constexpr const char artist_light_skin_tone[] = "🧑🏻‍🎨";
	inline constexpr const char artist_tone2[] = "🧑🏼‍🎨";
	inline constexpr const char artist_medium_light_skin_tone[] = "🧑🏼‍🎨";
	inline constexpr const char artist_tone3[] = "🧑🏽‍🎨";
	inline constexpr const char artist_medium_skin_tone[] = "🧑🏽‍🎨";
	inline constexpr const char artist_tone4[] = "🧑🏾‍🎨";
	inline constexpr const char artist_medium_dark_skin_tone[] = "🧑🏾‍🎨";
	inline constexpr const char artist_tone5[] = "🧑🏿‍🎨";
	inline constexpr const char artist_dark_skin_tone[] = "🧑🏿‍🎨";
	inline constexpr const char woman_artist[] = "👩‍🎨";
	inline constexpr const char woman_artist_tone1[] = "👩🏻‍🎨";
	inline constexpr const char woman_artist_light_skin_tone[] = "👩🏻‍🎨";
	inline constexpr const char woman_artist_tone2[] = "👩🏼‍🎨";
	inline constexpr const char woman_artist_medium_light_skin_tone[] = "👩🏼‍🎨";
	inline constexpr const char woman_artist_tone3[] = "👩🏽‍🎨";
	inline constexpr const char woman_artist_medium_skin_tone[] = "👩🏽‍🎨";
	inline constexpr const char woman_artist_tone4[] = "👩🏾‍🎨";
	inline constexpr const char woman_artist_medium_dark_skin_tone[] = "👩🏾‍🎨";
	inline constexpr const char woman_artist_tone5[] = "👩🏿‍🎨";
	inline constexpr const char woman_artist_dark_skin_tone[] = "👩🏿‍🎨";
	inline constexpr const char man_artist[] = "👨‍🎨";
	inline constexpr const char man_artist_tone1[] = "👨🏻‍🎨";
	inline constexpr const char man_artist_light_skin_tone[] = "👨🏻‍🎨";
	inline constexpr const char man_artist_tone2[] = "👨🏼‍🎨";
	inline constexpr const char man_artist_medium_light_skin_tone[] = "👨🏼‍🎨";
	inline constexpr const char man_artist_tone3[] = "👨🏽‍🎨";
	inline constexpr const char man_artist_medium_skin_tone[] = "👨🏽‍🎨";
	inline constexpr const char man_artist_tone4[] = "👨🏾‍🎨";
	inline constexpr const char man_artist_medium_dark_skin_tone[] = "👨🏾‍🎨";
	inline constexpr const char man_artist_tone5[] = "👨🏿‍🎨";
	inline constexpr const char man_artist_dark_skin_tone[] = "👨🏿‍🎨";
	inline constexpr const char firefighter[] = "🧑‍🚒";
	inline constexpr const char firefighter_tone1[] = "🧑🏻‍🚒";
	inline constexpr const char firefighter_light_skin_tone[] = "🧑🏻‍🚒";
	inline constexpr const char firefighter_tone2[] = "🧑🏼‍🚒";
	inline constexpr const char firefighter_medium_light_skin_tone[] = "🧑🏼‍🚒";
	inline constexpr const char firefighter_tone3[] = "🧑🏽‍🚒";
	inline constexpr const char firefighter_medium_skin_tone[] = "🧑🏽‍🚒";
	inline constexpr const char firefighter_tone4[] = "🧑🏾‍🚒";
	inline constexpr const char firefighter_medium_dark_skin_tone[] = "🧑🏾‍🚒";
	inline constexpr const char firefighter_tone5[] = "🧑🏿‍🚒";
	inline constexpr const char firefighter_dark_skin_tone[] = "🧑🏿‍🚒";
	inline constexpr const char woman_firefighter[] = "👩‍🚒";
	inline constexpr const char woman_firefighter_tone1[] = "👩🏻‍🚒";
	inline constexpr const char woman_firefighter_light_skin_tone[] = "👩🏻‍🚒";
	inline constexpr const char woman_firefighter_tone2[] = "👩🏼‍🚒";
	inline constexpr const char woman_firefighter_medium_light_skin_tone[] = "👩🏼‍🚒";
	inline constexpr const char woman_firefighter_tone3[] = "👩🏽‍🚒";
	inline constexpr const char woman_firefighter_medium_skin_tone[] = "👩🏽‍🚒";
	inline constexpr const char woman_firefighter_tone4[] = "👩🏾‍🚒";
	inline constexpr const char woman_firefighter_medium_dark_skin_tone[] = "👩🏾‍🚒";
	inline constexpr const char woman_firefighter_tone5[] = "👩🏿‍🚒";
	inline constexpr const char woman_firefighter_dark_skin_tone[] = "👩🏿‍🚒";
	inline constexpr const char man_firefighter[] = "👨‍🚒";
	inline constexpr const char man_firefighter_tone1[] = "👨🏻‍🚒";
	inline constexpr const char man_firefighter_light_skin_tone[] = "👨🏻‍🚒";
	inline constexpr const char man_firefighter_tone2[] = "👨🏼‍🚒";
	inline constexpr const char man_firefighter_medium_light_skin_tone[] = "👨🏼‍🚒";
	inline constexpr const char man_firefighter_tone3[] = "👨🏽‍🚒";
	inline constexpr const char man_firefighter_medium_skin_tone[] = "👨🏽‍🚒";
	inline constexpr const char man_firefighter_tone4[] = "👨🏾‍🚒";
	inline constexpr const char man_firefighter_medium_dark_skin_tone[] = "👨🏾‍🚒";
	inline constexpr const char man_firefighter_tone5[] = "👨🏿‍🚒";
	inline constexpr const char man_firefighter_dark_skin_tone[] = "👨🏿‍🚒";
	inline constexpr const char pilot[] = "🧑‍✈️";
	inline constexpr const char pilot_tone1[] = "🧑🏻‍✈️";
	inline constexpr const char pilot_light_skin_tone[] = "🧑🏻‍✈️";
	inline constexpr const char pilot_tone2[] = "🧑🏼‍✈️";
	inline constexpr const char pilot_medium_light_skin_tone[] = "🧑🏼‍✈️";
	inline constexpr const char pilot_tone3[] = "🧑🏽‍✈️";
	inline constexpr const char pilot_medium_skin_tone[] = "🧑🏽‍✈️";
	inline constexpr const char pilot_tone4[] = "🧑🏾‍✈️";
	inline constexpr const char pilot_medium_dark_skin_tone[] = "🧑🏾‍✈️";
	inline constexpr const char pilot_tone5[] = "🧑🏿‍✈️";
	inline constexpr const char pilot_dark_skin_tone[] = "🧑🏿‍✈️";
	inline constexpr const char woman_pilot[] = "👩‍✈️";
	inline constexpr const char woman_pilot_tone1[] = "👩🏻‍✈️";
	inline constexpr const char woman_pilot_light_skin_tone[] = "👩🏻‍✈️";
	inline constexpr const char woman_pilot_tone2[] = "👩🏼‍✈️";
	inline constexpr const char woman_pilot_medium_light_skin_tone[] = "👩🏼‍✈️";
	inline constexpr const char woman_pilot_tone3[] = "👩🏽‍✈️";
	inline constexpr const char woman_pilot_medium_skin_tone[] = "👩🏽‍✈️";
	inline constexpr const char woman_pilot_tone4[] = "👩🏾‍✈️";
	inline constexpr const char woman_pilot_medium_dark_skin_tone[] = "👩🏾‍✈️";
	inline constexpr const char woman_pilot_tone5[] = "👩🏿‍✈️";
	inline constexpr const char woman_pilot_dark_skin_tone[] = "👩🏿‍✈️";
	inline constexpr const char man_pilot[] = "👨‍✈️";
	inline constexpr const char man_pilot_tone1[] = "👨🏻‍✈️";
	inline constexpr const char man_pilot_light_skin_tone[] = "👨🏻‍✈️";
	inline constexpr const char man_pilot_tone2[] = "👨🏼‍✈️";
	inline constexpr const char man_pilot_medium_light_skin_tone[] = "👨🏼‍✈️";
	inline constexpr const char man_pilot_tone3[] = "👨🏽‍✈️";
	inline constexpr const char man_pilot_medium_skin_tone[] = "👨🏽‍✈️";
	inline constexpr const char man_pilot_tone4[] = "👨🏾‍✈️";
	inline constexpr const char man_pilot_medium_dark_skin_tone[] = "👨🏾‍✈️";
	inline constexpr const char man_pilot_tone5[] = "👨🏿‍✈️";
	inline constexpr const char man_pilot_dark_skin_tone[] = "👨🏿‍✈️";
	inline constexpr const char astronaut[] = "🧑‍🚀";
	inline constexpr const char astronaut_tone1[] = "🧑🏻‍🚀";
	inline constexpr const char astronaut_light_skin_tone[] = "🧑🏻‍🚀";
	inline constexpr const char astronaut_tone2[] = "🧑🏼‍🚀";
	inline constexpr const char astronaut_medium_light_skin_tone[] = "🧑🏼‍🚀";
	inline constexpr const char astronaut_tone3[] = "🧑🏽‍🚀";
	inline constexpr const char astronaut_medium_skin_tone[] = "🧑🏽‍🚀";
	inline constexpr const char astronaut_tone4[] = "🧑🏾‍🚀";
	inline constexpr const char astronaut_medium_dark_skin_tone[] = "🧑🏾‍🚀";
	inline constexpr const char astronaut_tone5[] = "🧑🏿‍🚀";
	inline constexpr const char astronaut_dark_skin_tone[] = "🧑🏿‍🚀";
	inline constexpr const char woman_astronaut[] = "👩‍🚀";
	inline constexpr const char woman_astronaut_tone1[] = "👩🏻‍🚀";
	inline constexpr const char woman_astronaut_light_skin_tone[] = "👩🏻‍🚀";
	inline constexpr const char woman_astronaut_tone2[] = "👩🏼‍🚀";
	inline constexpr const char woman_astronaut_medium_light_skin_tone[] = "👩🏼‍🚀";
	inline constexpr const char woman_astronaut_tone3[] = "👩🏽‍🚀";
	inline constexpr const char woman_astronaut_medium_skin_tone[] = "👩🏽‍🚀";
	inline constexpr const char woman_astronaut_tone4[] = "👩🏾‍🚀";
	inline constexpr const char woman_astronaut_medium_dark_skin_tone[] = "👩🏾‍🚀";
	inline constexpr const char woman_astronaut_tone5[] = "👩🏿‍🚀";
	inline constexpr const char woman_astronaut_dark_skin_tone[] = "👩🏿‍🚀";
	inline constexpr const char man_astronaut[] = "👨‍🚀";
	inline constexpr const char man_astronaut_tone1[] = "👨🏻‍🚀";
	inline constexpr const char man_astronaut_light_skin_tone[] = "👨🏻‍🚀";
	inline constexpr const char man_astronaut_tone2[] = "👨🏼‍🚀";
	inline constexpr const char man_astronaut_medium_light_skin_tone[] = "👨🏼‍🚀";
	inline constexpr const char man_astronaut_tone3[] = "👨🏽‍🚀";
	inline constexpr const char man_astronaut_medium_skin_tone[] = "👨🏽‍🚀";
	inline constexpr const char man_astronaut_tone4[] = "👨🏾‍🚀";
	inline constexpr const char man_astronaut_medium_dark_skin_tone[] = "👨🏾‍🚀";
	inline constexpr const char man_astronaut_tone5[] = "👨🏿‍🚀";
	inline constexpr const char man_astronaut_dark_skin_tone[] = "👨🏿‍🚀";
	inline constexpr const char judge[] = "🧑‍⚖️";
	inline constexpr const char judge_tone1[] = "🧑🏻‍⚖️";
	inline constexpr const char judge_light_skin_tone[] = "🧑🏻‍⚖️";
	inline constexpr const char judge_tone2[] = "🧑🏼‍⚖️";
	inline constexpr const char judge_medium_light_skin_tone[] = "🧑🏼‍⚖️";
	inline constexpr const char judge_tone3[] = "🧑🏽‍⚖️";
	inline constexpr const char judge_medium_skin_tone[] = "🧑🏽‍⚖️";
	inline constexpr const char judge_tone4[] = "🧑🏾‍⚖️";
	inline constexpr const char judge_medium_dark_skin_tone[] = "🧑🏾‍⚖️";
	inline constexpr const char judge_tone5[] = "🧑🏿‍⚖️";
	inline constexpr const char judge_dark_skin_tone[] = "🧑🏿‍⚖️";
	inline constexpr const char woman_judge[] = "👩‍⚖️";
	inline constexpr const char woman_judge_tone1[] = "👩🏻‍⚖️";
	inline constexpr const char woman_judge_light_skin_tone[] = "👩🏻‍⚖️";
	inline constexpr const char woman_judge_tone2[] = "👩🏼‍⚖️";
	inline constexpr const char woman_judge_medium_light_skin_tone[] = "👩🏼‍⚖️";
	inline constexpr const char woman_judge_tone3[] = "👩🏽‍⚖️";
	inline constexpr const char woman_judge_medium_skin_tone[] = "👩🏽‍⚖️";
	inline constexpr const char woman_judge_tone4[] = "👩🏾‍⚖️";
	inline constexpr const char woman_judge_medium_dark_skin_tone[] = "👩🏾‍⚖️";
	inline constexpr const char woman_judge_tone5[] = "👩🏿‍⚖️";
	inline constexpr const char woman_judge_dark_skin_tone[] = "👩🏿‍⚖️";
	inline constexpr const char man_judge[] = "👨‍⚖️";
	inline constexpr const char man_judge_tone1[] = "👨🏻‍⚖️";
	inline constexpr const char man_judge_light_skin_tone[] = "👨🏻‍⚖️";
	inline constexpr const char man_judge_tone2[] = "👨🏼‍⚖️";
	inline constexpr const char man_judge_medium_light_skin_tone[] = "👨🏼‍⚖️";
	inline constexpr const char man_judge_tone3[] = "👨🏽‍⚖️";
	inline constexpr const char man_judge_medium_skin_tone[] = "👨🏽‍⚖️";
	inline constexpr const char man_judge_tone4[] = "👨🏾‍⚖️";
	inline constexpr const char man_judge_medium_dark_skin_tone[] = "👨🏾‍⚖️";
	inline constexpr const char man_judge_tone5[] = "👨🏿‍⚖️";
	inline constexpr const char man_judge_dark_skin_tone[] = "👨🏿‍⚖️";
	inline constexpr const char person_with_veil[] = "👰";
	inline constexpr const char person_with_veil_tone1[] = "👰🏻";
	inline constexpr const char person_with_veil_tone2[] = "👰🏼";
	inline constexpr const char person_with_veil_tone3[] = "👰🏽";
	inline constexpr const char person_with_veil_tone4[] = "👰🏾";
	inline constexpr const char person_with_veil_tone5[] = "👰🏿";
	inline constexpr const char woman_with_veil[] = "👰‍♀️";
	inline constexpr const char bride_with_veil[] = "👰‍♀️";
	inline constexpr const char woman_with_veil_tone1[] = "👰🏻‍♀️";
	inline constexpr const char woman_with_veil_light_skin_tone[] = "👰🏻‍♀️";
	inline constexpr const char woman_with_veil_tone2[] = "👰🏼‍♀️";
	inline constexpr const char woman_with_veil_medium_light_skin_tone[] = "👰🏼‍♀️";
	inline constexpr const char woman_with_veil_tone3[] = "👰🏽‍♀️";
	inline constexpr const char woman_with_veil_medium_skin_tone[] = "👰🏽‍♀️";
	inline constexpr const char woman_with_veil_tone4[] = "👰🏾‍♀️";
	inline constexpr const char woman_with_veil_medium_dark_skin_tone[] = "👰🏾‍♀️";
	inline constexpr const char woman_with_veil_tone5[] = "👰🏿‍♀️";
	inline constexpr const char woman_with_veil_dark_skin_tone[] = "👰🏿‍♀️";
	inline constexpr const char man_with_veil[] = "👰‍♂️";
	inline constexpr const char man_with_veil_tone1[] = "👰🏻‍♂️";
	inline constexpr const char man_with_veil_light_skin_tone[] = "👰🏻‍♂️";
	inline constexpr const char man_with_veil_tone2[] = "👰🏼‍♂️";
	inline constexpr const char man_with_veil_medium_light_skin_tone[] = "👰🏼‍♂️";
	inline constexpr const char man_with_veil_tone3[] = "👰🏽‍♂️";
	inline constexpr const char man_with_veil_medium_skin_tone[] = "👰🏽‍♂️";
	inline constexpr const char man_with_veil_tone4[] = "👰🏾‍♂️";
	inline constexpr const char man_with_veil_medium_dark_skin_tone[] = "👰🏾‍♂️";
	inline constexpr const char man_with_veil_tone5[] = "👰🏿‍♂️";
	inline constexpr const char man_with_veil_dark_skin_tone[] = "👰🏿‍♂️";
	inline constexpr const char person_in_tuxedo[] = "🤵";
	inline constexpr const char person_in_tuxedo_tone1[] = "🤵🏻";
	inline constexpr const char tuxedo_tone1[] = "🤵🏻";
	inline constexpr const char person_in_tuxedo_tone2[] = "🤵🏼";
	inline constexpr const char tuxedo_tone2[] = "🤵🏼";
	inline constexpr const char person_in_tuxedo_tone3[] = "🤵🏽";
	inline constexpr const char tuxedo_tone3[] = "🤵🏽";
	inline constexpr const char person_in_tuxedo_tone4[] = "🤵🏾";
	inline constexpr const char tuxedo_tone4[] = "🤵🏾";
	inline constexpr const char person_in_tuxedo_tone5[] = "🤵🏿";
	inline constexpr const char tuxedo_tone5[] = "🤵🏿";
	inline constexpr const char woman_in_tuxedo[] = "🤵‍♀️";
	inline constexpr const char woman_in_tuxedo_tone1[] = "🤵🏻‍♀️";
	inline constexpr const char woman_in_tuxedo_light_skin_tone[] = "🤵🏻‍♀️";
	inline constexpr const char woman_in_tuxedo_tone2[] = "🤵🏼‍♀️";
	inline constexpr const char woman_in_tuxedo_medium_light_skin_tone[] = "🤵🏼‍♀️";
	inline constexpr const char woman_in_tuxedo_tone3[] = "🤵🏽‍♀️";
	inline constexpr const char woman_in_tuxedo_medium_skin_tone[] = "🤵🏽‍♀️";
	inline constexpr const char woman_in_tuxedo_tone4[] = "🤵🏾‍♀️";
	inline constexpr const char woman_in_tuxedo_medium_dark_skin_tone[] = "🤵🏾‍♀️";
	inline constexpr const char woman_in_tuxedo_tone5[] = "🤵🏿‍♀️";
	inline constexpr const char woman_in_tuxedo_dark_skin_tone[] = "🤵🏿‍♀️";
	inline constexpr const char man_in_tuxedo[] = "🤵‍♂️";
	inline constexpr const char man_in_tuxedo_tone1[] = "🤵🏻‍♂️";
	inline constexpr const char man_in_tuxedo_light_skin_tone[] = "🤵🏻‍♂️";
	inline constexpr const char man_in_tuxedo_tone2[] = "🤵🏼‍♂️";
	inline constexpr const char man_in_tuxedo_medium_light_skin_tone[] = "🤵🏼‍♂️";
	inline constexpr const char man_in_tuxedo_tone3[] = "🤵🏽‍♂️";
	inline constexpr const char man_in_tuxedo_medium_skin_tone[] = "🤵🏽‍♂️";
	inline constexpr const char man_in_tuxedo_tone4[] = "🤵🏾‍♂️";
	inline constexpr const char man_in_tuxedo_medium_dark_skin_tone[] = "🤵🏾‍♂️";
	inline constexpr const char man_in_tuxedo_tone5[] = "🤵🏿‍♂️";
	inline constexpr const char man_in_tuxedo_dark_skin_tone[] = "🤵🏿‍♂️";
	inline constexpr const char person_with_crown[] = "🫅";
	inline constexpr const char person_with_crown_tone1[] = "🫅🏻";
	inline constexpr const char person_with_crown_light_skin_tone[] = "🫅🏻";
	inline constexpr const char person_with_crown_tone2[] = "🫅🏼";
	inline constexpr const char person_with_crown_medium_light_skin_tone[] = "🫅🏼";
	inline constexpr const char person_with_crown_tone3[] = "🫅🏽";
	inline constexpr const char person_with_crown_medium_skin_tone[] = "🫅🏽";
	inline constexpr const char person_with_crown_tone4[] = "🫅🏾";
	inline constexpr const char person_with_crown_medium_dark_skin_tone[] = "🫅🏾";
	inline constexpr const char person_with_crown_tone5[] = "🫅🏿";
	inline constexpr const char person_with_crown_dark_skin_tone[] = "🫅🏿";
	inline constexpr const char princess[] = "👸";
	inline constexpr const char princess_tone1[] = "👸🏻";
	inline constexpr const char princess_tone2[] = "👸🏼";
	inline constexpr const char princess_tone3[] = "👸🏽";
	inline constexpr const char princess_tone4[] = "👸🏾";
	inline constexpr const char princess_tone5[] = "👸🏿";
	inline constexpr const char prince[] = "🤴";
	inline constexpr const char prince_tone1[] = "🤴🏻";
	inline constexpr const char prince_tone2[] = "🤴🏼";
	inline constexpr const char prince_tone3[] = "🤴🏽";
	inline constexpr const char prince_tone4[] = "🤴🏾";
	inline constexpr const char prince_tone5[] = "🤴🏿";
	inline constexpr const char superhero[] = "🦸";
	inline constexpr const char superhero_tone1[] = "🦸🏻";
	inline constexpr const char superhero_light_skin_tone[] = "🦸🏻";
	inline constexpr const char superhero_tone2[] = "🦸🏼";
	inline constexpr const char superhero_medium_light_skin_tone[] = "🦸🏼";
	inline constexpr const char superhero_tone3[] = "🦸🏽";
	inline constexpr const char superhero_medium_skin_tone[] = "🦸🏽";
	inline constexpr const char superhero_tone4[] = "🦸🏾";
	inline constexpr const char superhero_medium_dark_skin_tone[] = "🦸🏾";
	inline constexpr const char superhero_tone5[] = "🦸🏿";
	inline constexpr const char superhero_dark_skin_tone[] = "🦸🏿";
	inline constexpr const char woman_superhero[] = "🦸‍♀️";
	inline constexpr const char woman_superhero_tone1[] = "🦸🏻‍♀️";
	inline constexpr const char woman_superhero_light_skin_tone[] = "🦸🏻‍♀️";
	inline constexpr const char woman_superhero_tone2[] = "🦸🏼‍♀️";
	inline constexpr const char woman_superhero_medium_light_skin_tone[] = "🦸🏼‍♀️";
	inline constexpr const char woman_superhero_tone3[] = "🦸🏽‍♀️";
	inline constexpr const char woman_superhero_medium_skin_tone[] = "🦸🏽‍♀️";
	inline constexpr const char woman_superhero_tone4[] = "🦸🏾‍♀️";
	inline constexpr const char woman_superhero_medium_dark_skin_tone[] = "🦸🏾‍♀️";
	inline constexpr const char woman_superhero_tone5[] = "🦸🏿‍♀️";
	inline constexpr const char woman_superhero_dark_skin_tone[] = "🦸🏿‍♀️";
	inline constexpr const char man_superhero[] = "🦸‍♂️";
	inline constexpr const char man_superhero_tone1[] = "🦸🏻‍♂️";
	inline constexpr const char man_superhero_light_skin_tone[] = "🦸🏻‍♂️";
	inline constexpr const char man_superhero_tone2[] = "🦸🏼‍♂️";
	inline constexpr const char man_superhero_medium_light_skin_tone[] = "🦸🏼‍♂️";
	inline constexpr const char man_superhero_tone3[] = "🦸🏽‍♂️";
	inline constexpr const char man_superhero_medium_skin_tone[] = "🦸🏽‍♂️";
	inline constexpr const char man_superhero_tone4[] = "🦸🏾‍♂️";
	inline constexpr const char man_superhero_medium_dark_skin_tone[] = "🦸🏾‍♂️";
	inline constexpr const char man_superhero_tone5[] = "🦸🏿‍♂️";
	inline constexpr const char man_superhero_dark_skin_tone[] = "🦸🏿‍♂️";
	inline constexpr const char supervillain[] = "🦹";
	inline constexpr const char supervillain_tone1[] = "🦹🏻";
	inline constexpr const char supervillain_light_skin_tone[] = "🦹🏻";
	inline constexpr const char supervillain_tone2[] = "🦹🏼";
	inline constexpr const char supervillain_medium_light_skin_tone[] = "🦹🏼";
	inline constexpr const char supervillain_tone3[] = "🦹🏽";
	inline constexpr const char supervillain_medium_skin_tone[] = "🦹🏽";
	inline constexpr const char supervillain_tone4[] = "🦹🏾";
	inline constexpr const char supervillain_medium_dark_skin_tone[] = "🦹🏾";
	inline constexpr const char supervillain_tone5[] = "🦹🏿";
	inline constexpr const char supervillain_dark_skin_tone[] = "🦹🏿";
	inline constexpr const char woman_supervillain[] = "🦹‍♀️";
	inline constexpr const char woman_supervillain_tone1[] = "🦹🏻‍♀️";
	inline constexpr const char woman_supervillain_light_skin_tone[] = "🦹🏻‍♀️";
	inline constexpr const char woman_supervillain_tone2[] = "🦹🏼‍♀️";
	inline constexpr const char woman_supervillain_medium_light_skin_tone[] = "🦹🏼‍♀️";
	inline constexpr const char woman_supervillain_tone3[] = "🦹🏽‍♀️";
	inline constexpr const char woman_supervillain_medium_skin_tone[] = "🦹🏽‍♀️";
	inline constexpr const char woman_supervillain_tone4[] = "🦹🏾‍♀️";
	inline constexpr const char woman_supervillain_medium_dark_skin_tone[] = "🦹🏾‍♀️";
	inline constexpr const char woman_supervillain_tone5[] = "🦹🏿‍♀️";
	inline constexpr const char woman_supervillain_dark_skin_tone[] = "🦹🏿‍♀️";
	inline constexpr const char man_supervillain[] = "🦹‍♂️";
	inline constexpr const char man_supervillain_tone1[] = "🦹🏻‍♂️";
	inline constexpr const char man_supervillain_light_skin_tone[] = "🦹🏻‍♂️";
	inline constexpr const char man_supervillain_tone2[] = "🦹🏼‍♂️";
	inline constexpr const char man_supervillain_medium_light_skin_tone[] = "🦹🏼‍♂️";
	inline constexpr const char man_supervillain_tone3[] = "🦹🏽‍♂️";
	inline constexpr const char man_supervillain_medium_skin_tone[] = "🦹🏽‍♂️";
	inline constexpr const char man_supervillain_tone4[] = "🦹🏾‍♂️";
	inline constexpr const char man_supervillain_medium_dark_skin_tone[] = "🦹🏾‍♂️";
	inline constexpr const char man_supervillain_tone5[] = "🦹🏿‍♂️";
	inline constexpr const char man_supervillain_dark_skin_tone[] = "🦹🏿‍♂️";
	inline constexpr const char ninja[] = "🥷";
	inline constexpr const char ninja_tone1[] = "🥷🏻";
	inline constexpr const char ninja_light_skin_tone[] = "🥷🏻";
	inline constexpr const char ninja_tone2[] = "🥷🏼";
	inline constexpr const char ninja_medium_light_skin_tone[] = "🥷🏼";
	inline constexpr const char ninja_tone3[] = "🥷🏽";
	inline constexpr const char ninja_medium_skin_tone[] = "🥷🏽";
	inline constexpr const char ninja_tone4[] = "🥷🏾";
	inline constexpr const char ninja_medium_dark_skin_tone[] = "🥷🏾";
	inline constexpr const char ninja_tone5[] = "🥷🏿";
	inline constexpr const char ninja_dark_skin_tone[] = "🥷🏿";
	inline constexpr const char mx_claus[] = "🧑‍🎄";
	inline constexpr const char mx_claus_tone1[] = "🧑🏻‍🎄";
	inline constexpr const char mx_claus_light_skin_tone[] = "🧑🏻‍🎄";
	inline constexpr const char mx_claus_tone2[] = "🧑🏼‍🎄";
	inline constexpr const char mx_claus_medium_light_skin_tone[] = "🧑🏼‍🎄";
	inline constexpr const char mx_claus_tone3[] = "🧑🏽‍🎄";
	inline constexpr const char mx_claus_medium_skin_tone[] = "🧑🏽‍🎄";
	inline constexpr const char mx_claus_tone4[] = "🧑🏾‍🎄";
	inline constexpr const char mx_claus_medium_dark_skin_tone[] = "🧑🏾‍🎄";
	inline constexpr const char mx_claus_tone5[] = "🧑🏿‍🎄";
	inline constexpr const char mx_claus_dark_skin_tone[] = "🧑🏿‍🎄";
	inline constexpr const char mrs_claus[] = "🤶";
	inline constexpr const char mother_christmas[] = "🤶";
	inline constexpr const char mrs_claus_tone1[] = "🤶🏻";
	inline constexpr const char mother_christmas_tone1[] = "🤶🏻";
	inline constexpr const char mrs_claus_tone2[] = "🤶🏼";
	inline constexpr const char mother_christmas_tone2[] = "🤶🏼";
	inline constexpr const char mrs_claus_tone3[] = "🤶🏽";
	inline constexpr const char mother_christmas_tone3[] = "🤶🏽";
	inline constexpr const char mrs_claus_tone4[] = "🤶🏾";
	inline constexpr const char mother_christmas_tone4[] = "🤶🏾";
	inline constexpr const char mrs_claus_tone5[] = "🤶🏿";
	inline constexpr const char mother_christmas_tone5[] = "🤶🏿";
	inline constexpr const char santa[] = "🎅";
	inline constexpr const char santa_claus[] = "🎅";
	inline constexpr const char santa_tone1[] = "🎅🏻";
	inline constexpr const char santa_tone2[] = "🎅🏼";
	inline constexpr const char santa_tone3[] = "🎅🏽";
	inline constexpr const char santa_tone4[] = "🎅🏾";
	inline constexpr const char santa_tone5[] = "🎅🏿";
	inline constexpr const char mage[] = "🧙";
	inline constexpr const char mage_tone1[] = "🧙🏻";
	inline constexpr const char mage_light_skin_tone[] = "🧙🏻";
	inline constexpr const char mage_tone2[] = "🧙🏼";
	inline constexpr const char mage_medium_light_skin_tone[] = "🧙🏼";
	inline constexpr const char mage_tone3[] = "🧙🏽";
	inline constexpr const char mage_medium_skin_tone[] = "🧙🏽";
	inline constexpr const char mage_tone4[] = "🧙🏾";
	inline constexpr const char mage_medium_dark_skin_tone[] = "🧙🏾";
	inline constexpr const char mage_tone5[] = "🧙🏿";
	inline constexpr const char mage_dark_skin_tone[] = "🧙🏿";
	inline constexpr const char woman_mage[] = "🧙‍♀️";
	inline constexpr const char woman_mage_tone1[] = "🧙🏻‍♀️";
	inline constexpr const char woman_mage_light_skin_tone[] = "🧙🏻‍♀️";
	inline constexpr const char woman_mage_tone2[] = "🧙🏼‍♀️";
	inline constexpr const char woman_mage_medium_light_skin_tone[] = "🧙🏼‍♀️";
	inline constexpr const char woman_mage_tone3[] = "🧙🏽‍♀️";
	inline constexpr const char woman_mage_medium_skin_tone[] = "🧙🏽‍♀️";
	inline constexpr const char woman_mage_tone4[] = "🧙🏾‍♀️";
	inline constexpr const char woman_mage_medium_dark_skin_tone[] = "🧙🏾‍♀️";
	inline constexpr const char woman_mage_tone5[] = "🧙🏿‍♀️";
	inline constexpr const char woman_mage_dark_skin_tone[] = "🧙🏿‍♀️";
	inline constexpr const char man_mage[] = "🧙‍♂️";
	inline constexpr const char man_mage_tone1[] = "🧙🏻‍♂️";
	inline constexpr const char man_mage_light_skin_tone[] = "🧙🏻‍♂️";
	inline constexpr const char man_mage_tone2[] = "🧙🏼‍♂️";
	inline constexpr const char man_mage_medium_light_skin_tone[] = "🧙🏼‍♂️";
	inline constexpr const char man_mage_tone3[] = "🧙🏽‍♂️";
	inline constexpr const char man_mage_medium_skin_tone[] = "🧙🏽‍♂️";
	inline constexpr const char man_mage_tone4[] = "🧙🏾‍♂️";
	inline constexpr const char man_mage_medium_dark_skin_tone[] = "🧙🏾‍♂️";
	inline constexpr const char man_mage_tone5[] = "🧙🏿‍♂️";
	inline constexpr const char man_mage_dark_skin_tone[] = "🧙🏿‍♂️";
	inline constexpr const char elf[] = "🧝";
	inline constexpr const char elf_tone1[] = "🧝🏻";
	inline constexpr const char elf_light_skin_tone[] = "🧝🏻";
	inline constexpr const char elf_tone2[] = "🧝🏼";
	inline constexpr const char elf_medium_light_skin_tone[] = "🧝🏼";
	inline constexpr const char elf_tone3[] = "🧝🏽";
	inline constexpr const char elf_medium_skin_tone[] = "🧝🏽";
	inline constexpr const char elf_tone4[] = "🧝🏾";
	inline constexpr const char elf_medium_dark_skin_tone[] = "🧝🏾";
	inline constexpr const char elf_tone5[] = "🧝🏿";
	inline constexpr const char elf_dark_skin_tone[] = "🧝🏿";
	inline constexpr const char woman_elf[] = "🧝‍♀️";
	inline constexpr const char woman_elf_tone1[] = "🧝🏻‍♀️";
	inline constexpr const char woman_elf_light_skin_tone[] = "🧝🏻‍♀️";
	inline constexpr const char woman_elf_tone2[] = "🧝🏼‍♀️";
	inline constexpr const char woman_elf_medium_light_skin_tone[] = "🧝🏼‍♀️";
	inline constexpr const char woman_elf_tone3[] = "🧝🏽‍♀️";
	inline constexpr const char woman_elf_medium_skin_tone[] = "🧝🏽‍♀️";
	inline constexpr const char woman_elf_tone4[] = "🧝🏾‍♀️";
	inline constexpr const char woman_elf_medium_dark_skin_tone[] = "🧝🏾‍♀️";
	inline constexpr const char woman_elf_tone5[] = "🧝🏿‍♀️";
	inline constexpr const char woman_elf_dark_skin_tone[] = "🧝🏿‍♀️";
	inline constexpr const char man_elf[] = "🧝‍♂️";
	inline constexpr const char man_elf_tone1[] = "🧝🏻‍♂️";
	inline constexpr const char man_elf_light_skin_tone[] = "🧝🏻‍♂️";
	inline constexpr const char man_elf_tone2[] = "🧝🏼‍♂️";
	inline constexpr const char man_elf_medium_light_skin_tone[] = "🧝🏼‍♂️";
	inline constexpr const char man_elf_tone3[] = "🧝🏽‍♂️";
	inline constexpr const char man_elf_medium_skin_tone[] = "🧝🏽‍♂️";
	inline constexpr const char man_elf_tone4[] = "🧝🏾‍♂️";
	inline constexpr const char man_elf_medium_dark_skin_tone[] = "🧝🏾‍♂️";
	inline constexpr const char man_elf_tone5[] = "🧝🏿‍♂️";
	inline constexpr const char man_elf_dark_skin_tone[] = "🧝🏿‍♂️";
	inline constexpr const char troll[] = "🧌";
	inline constexpr const char vampire[] = "🧛";
	inline constexpr const char vampire_tone1[] = "🧛🏻";
	inline constexpr const char vampire_light_skin_tone[] = "🧛🏻";
	inline constexpr const char vampire_tone2[] = "🧛🏼";
	inline constexpr const char vampire_medium_light_skin_tone[] = "🧛🏼";
	inline constexpr const char vampire_tone3[] = "🧛🏽";
	inline constexpr const char vampire_medium_skin_tone[] = "🧛🏽";
	inline constexpr const char vampire_tone4[] = "🧛🏾";
	inline constexpr const char vampire_medium_dark_skin_tone[] = "🧛🏾";
	inline constexpr const char vampire_tone5[] = "🧛🏿";
	inline constexpr const char vampire_dark_skin_tone[] = "🧛🏿";
	inline constexpr const char woman_vampire[] = "🧛‍♀️";
	inline constexpr const char woman_vampire_tone1[] = "🧛🏻‍♀️";
	inline constexpr const char woman_vampire_light_skin_tone[] = "🧛🏻‍♀️";
	inline constexpr const char woman_vampire_tone2[] = "🧛🏼‍♀️";
	inline constexpr const char woman_vampire_medium_light_skin_tone[] = "🧛🏼‍♀️";
	inline constexpr const char woman_vampire_tone3[] = "🧛🏽‍♀️";
	inline constexpr const char woman_vampire_medium_skin_tone[] = "🧛🏽‍♀️";
	inline constexpr const char woman_vampire_tone4[] = "🧛🏾‍♀️";
	inline constexpr const char woman_vampire_medium_dark_skin_tone[] = "🧛🏾‍♀️";
	inline constexpr const char woman_vampire_tone5[] = "🧛🏿‍♀️";
	inline constexpr const char woman_vampire_dark_skin_tone[] = "🧛🏿‍♀️";
	inline constexpr const char man_vampire[] = "🧛‍♂️";
	inline constexpr const char man_vampire_tone1[] = "🧛🏻‍♂️";
	inline constexpr const char man_vampire_light_skin_tone[] = "🧛🏻‍♂️";
	inline constexpr const char man_vampire_tone2[] = "🧛🏼‍♂️";
	inline constexpr const char man_vampire_medium_light_skin_tone[] = "🧛🏼‍♂️";
	inline constexpr const char man_vampire_tone3[] = "🧛🏽‍♂️";
	inline constexpr const char man_vampire_medium_skin_tone[] = "🧛🏽‍♂️";
	inline constexpr const char man_vampire_tone4[] = "🧛🏾‍♂️";
	inline constexpr const char man_vampire_medium_dark_skin_tone[] = "🧛🏾‍♂️";
	inline constexpr const char man_vampire_tone5[] = "🧛🏿‍♂️";
	inline constexpr const char man_vampire_dark_skin_tone[] = "🧛🏿‍♂️";
	inline constexpr const char zombie[] = "🧟";
	inline constexpr const char woman_zombie[] = "🧟‍♀️";
	inline constexpr const char man_zombie[] = "🧟‍♂️";
	inline constexpr const char genie[] = "🧞";
	inline constexpr const char woman_genie[] = "🧞‍♀️";
	inline constexpr const char man_genie[] = "🧞‍♂️";
	inline constexpr const char merperson[] = "🧜";
	inline constexpr const char merperson_tone1[] = "🧜🏻";
	inline constexpr const char merperson_light_skin_tone[] = "🧜🏻";
	inline constexpr const char merperson_tone2[] = "🧜🏼";
	inline constexpr const char merperson_medium_light_skin_tone[] = "🧜🏼";
	inline constexpr const char merperson_tone3[] = "🧜🏽";
	inline constexpr const char merperson_medium_skin_tone[] = "🧜🏽";
	inline constexpr const char merperson_tone4[] = "🧜🏾";
	inline constexpr const char merperson_medium_dark_skin_tone[] = "🧜🏾";
	inline constexpr const char merperson_tone5[] = "🧜🏿";
	inline constexpr const char merperson_dark_skin_tone[] = "🧜🏿";
	inline constexpr const char mermaid[] = "🧜‍♀️";
	inline constexpr const char mermaid_tone1[] = "🧜🏻‍♀️";
	inline constexpr const char mermaid_light_skin_tone[] = "🧜🏻‍♀️";
	inline constexpr const char mermaid_tone2[] = "🧜🏼‍♀️";
	inline constexpr const char mermaid_medium_light_skin_tone[] = "🧜🏼‍♀️";
	inline constexpr const char mermaid_tone3[] = "🧜🏽‍♀️";
	inline constexpr const char mermaid_medium_skin_tone[] = "🧜🏽‍♀️";
	inline constexpr const char mermaid_tone4[] = "🧜🏾‍♀️";
	inline constexpr const char mermaid_medium_dark_skin_tone[] = "🧜🏾‍♀️";
	inline constexpr const char mermaid_tone5[] = "🧜🏿‍♀️";
	inline constexpr const char mermaid_dark_skin_tone[] = "🧜🏿‍♀️";
	inline constexpr const char merman[] = "🧜‍♂️";
	inline constexpr const char merman_tone1[] = "🧜🏻‍♂️";
	inline constexpr const char merman_light_skin_tone[] = "🧜🏻‍♂️";
	inline constexpr const char merman_tone2[] = "🧜🏼‍♂️";
	inline constexpr const char merman_medium_light_skin_tone[] = "🧜🏼‍♂️";
	inline constexpr const char merman_tone3[] = "🧜🏽‍♂️";
	inline constexpr const char merman_medium_skin_tone[] = "🧜🏽‍♂️";
	inline constexpr const char merman_tone4[] = "🧜🏾‍♂️";
	inline constexpr const char merman_medium_dark_skin_tone[] = "🧜🏾‍♂️";
	inline constexpr const char merman_tone5[] = "🧜🏿‍♂️";
	inline constexpr const char merman_dark_skin_tone[] = "🧜🏿‍♂️";
	inline constexpr const char fairy[] = "🧚";
	inline constexpr const char fairy_tone1[] = "🧚🏻";
	inline constexpr const char fairy_light_skin_tone[] = "🧚🏻";
	inline constexpr const char fairy_tone2[] = "🧚🏼";
	inline constexpr const char fairy_medium_light_skin_tone[] = "🧚🏼";
	inline constexpr const char fairy_tone3[] = "🧚🏽";
	inline constexpr const char fairy_medium_skin_tone[] = "🧚🏽";
	inline constexpr const char fairy_tone4[] = "🧚🏾";
	inline constexpr const char fairy_medium_dark_skin_tone[] = "🧚🏾";
	inline constexpr const char fairy_tone5[] = "🧚🏿";
	inline constexpr const char fairy_dark_skin_tone[] = "🧚🏿";
	inline constexpr const char woman_fairy[] = "🧚‍♀️";
	inline constexpr const char woman_fairy_tone1[] = "🧚🏻‍♀️";
	inline constexpr const char woman_fairy_light_skin_tone[] = "🧚🏻‍♀️";
	inline constexpr const char woman_fairy_tone2[] = "🧚🏼‍♀️";
	inline constexpr const char woman_fairy_medium_light_skin_tone[] = "🧚🏼‍♀️";
	inline constexpr const char woman_fairy_tone3[] = "🧚🏽‍♀️";
	inline constexpr const char woman_fairy_medium_skin_tone[] = "🧚🏽‍♀️";
	inline constexpr const char woman_fairy_tone4[] = "🧚🏾‍♀️";
	inline constexpr const char woman_fairy_medium_dark_skin_tone[] = "🧚🏾‍♀️";
	inline constexpr const char woman_fairy_tone5[] = "🧚🏿‍♀️";
	inline constexpr const char woman_fairy_dark_skin_tone[] = "🧚🏿‍♀️";
	inline constexpr const char man_fairy[] = "🧚‍♂️";
	inline constexpr const char man_fairy_tone1[] = "🧚🏻‍♂️";
	inline constexpr const char man_fairy_light_skin_tone[] = "🧚🏻‍♂️";
	inline constexpr const char man_fairy_tone2[] = "🧚🏼‍♂️";
	inline constexpr const char man_fairy_medium_light_skin_tone[] = "🧚🏼‍♂️";
	inline constexpr const char man_fairy_tone3[] = "🧚🏽‍♂️";
	inline constexpr const char man_fairy_medium_skin_tone[] = "🧚🏽‍♂️";
	inline constexpr const char man_fairy_tone4[] = "🧚🏾‍♂️";
	inline constexpr const char man_fairy_medium_dark_skin_tone[] = "🧚🏾‍♂️";
	inline constexpr const char man_fairy_tone5[] = "🧚🏿‍♂️";
	inline constexpr const char man_fairy_dark_skin_tone[] = "🧚🏿‍♂️";
	inline constexpr const char angel[] = "👼";
	inline constexpr const char baby_angel[] = "👼";
	inline constexpr const char angel_tone1[] = "👼🏻";
	inline constexpr const char angel_tone2[] = "👼🏼";
	inline constexpr const char angel_tone3[] = "👼🏽";
	inline constexpr const char angel_tone4[] = "👼🏾";
	inline constexpr const char angel_tone5[] = "👼🏿";
	inline constexpr const char pregnant_person[] = "🫄";
	inline constexpr const char pregnant_person_tone1[] = "🫄🏻";
	inline constexpr const char pregnant_person_light_skin_tone[] = "🫄🏻";
	inline constexpr const char pregnant_person_tone2[] = "🫄🏼";
	inline constexpr const char pregnant_person_medium_light_skin_tone[] = "🫄🏼";
	inline constexpr const char pregnant_person_tone3[] = "🫄🏽";
	inline constexpr const char pregnant_person_medium_skin_tone[] = "🫄🏽";
	inline constexpr const char pregnant_person_tone4[] = "🫄🏾";
	inline constexpr const char pregnant_person_medium_dark_skin_tone[] = "🫄🏾";
	inline constexpr const char pregnant_person_tone5[] = "🫄🏿";
	inline constexpr const char pregnant_person_dark_skin_tone[] = "🫄🏿";
	inline constexpr const char pregnant_woman[] = "🤰";
	inline constexpr const char expecting_woman[] = "🤰";
	inline constexpr const char pregnant_woman_tone1[] = "🤰🏻";
	inline constexpr const char expecting_woman_tone1[] = "🤰🏻";
	inline constexpr const char pregnant_woman_tone2[] = "🤰🏼";
	inline constexpr const char expecting_woman_tone2[] = "🤰🏼";
	inline constexpr const char pregnant_woman_tone3[] = "🤰🏽";
	inline constexpr const char expecting_woman_tone3[] = "🤰🏽";
	inline constexpr const char pregnant_woman_tone4[] = "🤰🏾";
	inline constexpr const char expecting_woman_tone4[] = "🤰🏾";
	inline constexpr const char pregnant_woman_tone5[] = "🤰🏿";
	inline constexpr const char expecting_woman_tone5[] = "🤰🏿";
	inline constexpr const char pregnant_man[] = "🫃";
	inline constexpr const char pregnant_man_tone1[] = "🫃🏻";
	inline constexpr const char pregnant_man_light_skin_tone[] = "🫃🏻";
	inline constexpr const char pregnant_man_tone2[] = "🫃🏼";
	inline constexpr const char pregnant_man_medium_light_skin_tone[] = "🫃🏼";
	inline constexpr const char pregnant_man_tone3[] = "🫃🏽";
	inline constexpr const char pregnant_man_medium_skin_tone[] = "🫃🏽";
	inline constexpr const char pregnant_man_tone4[] = "🫃🏾";
	inline constexpr const char pregnant_man_medium_dark_skin_tone[] = "🫃🏾";
	inline constexpr const char pregnant_man_tone5[] = "🫃🏿";
	inline constexpr const char pregnant_man_dark_skin_tone[] = "🫃🏿";
	inline constexpr const char breast_feeding[] = "🤱";
	inline constexpr const char breast_feeding_tone1[] = "🤱🏻";
	inline constexpr const char breast_feeding_light_skin_tone[] = "🤱🏻";
	inline constexpr const char breast_feeding_tone2[] = "🤱🏼";
	inline constexpr const char breast_feeding_medium_light_skin_tone[] = "🤱🏼";
	inline constexpr const char breast_feeding_tone3[] = "🤱🏽";
	inline constexpr const char breast_feeding_medium_skin_tone[] = "🤱🏽";
	inline constexpr const char breast_feeding_tone4[] = "🤱🏾";
	inline constexpr const char breast_feeding_medium_dark_skin_tone[] = "🤱🏾";
	inline constexpr const char breast_feeding_tone5[] = "🤱🏿";
	inline constexpr const char breast_feeding_dark_skin_tone[] = "🤱🏿";
	inline constexpr const char person_feeding_baby[] = "🧑‍🍼";
	inline constexpr const char person_feeding_baby_tone1[] = "🧑🏻‍🍼";
	inline constexpr const char person_feeding_baby_light_skin_tone[] = "🧑🏻‍🍼";
	inline constexpr const char person_feeding_baby_tone2[] = "🧑🏼‍🍼";
	inline constexpr const char person_feeding_baby_medium_light_skin_tone[] = "🧑🏼‍🍼";
	inline constexpr const char person_feeding_baby_tone3[] = "🧑🏽‍🍼";
	inline constexpr const char person_feeding_baby_medium_skin_tone[] = "🧑🏽‍🍼";
	inline constexpr const char person_feeding_baby_tone4[] = "🧑🏾‍🍼";
	inline constexpr const char person_feeding_baby_medium_dark_skin_tone[] = "🧑🏾‍🍼";
	inline constexpr const char person_feeding_baby_tone5[] = "🧑🏿‍🍼";
	inline constexpr const char person_feeding_baby_dark_skin_tone[] = "🧑🏿‍🍼";
	inline constexpr const char woman_feeding_baby[] = "👩‍🍼";
	inline constexpr const char woman_feeding_baby_tone1[] = "👩🏻‍🍼";
	inline constexpr const char woman_feeding_baby_light_skin_tone[] = "👩🏻‍🍼";
	inline constexpr const char woman_feeding_baby_tone2[] = "👩🏼‍🍼";
	inline constexpr const char woman_feeding_baby_medium_light_skin_tone[] = "👩🏼‍🍼";
	inline constexpr const char woman_feeding_baby_tone3[] = "👩🏽‍🍼";
	inline constexpr const char woman_feeding_baby_medium_skin_tone[] = "👩🏽‍🍼";
	inline constexpr const char woman_feeding_baby_tone4[] = "👩🏾‍🍼";
	inline constexpr const char woman_feeding_baby_medium_dark_skin_tone[] = "👩🏾‍🍼";
	inline constexpr const char woman_feeding_baby_tone5[] = "👩🏿‍🍼";
	inline constexpr const char woman_feeding_baby_dark_skin_tone[] = "👩🏿‍🍼";
	inline constexpr const char man_feeding_baby[] = "👨‍🍼";
	inline constexpr const char man_feeding_baby_tone1[] = "👨🏻‍🍼";
	inline constexpr const char man_feeding_baby_light_skin_tone[] = "👨🏻‍🍼";
	inline constexpr const char man_feeding_baby_tone2[] = "👨🏼‍🍼";
	inline constexpr const char man_feeding_baby_medium_light_skin_tone[] = "👨🏼‍🍼";
	inline constexpr const char man_feeding_baby_tone3[] = "👨🏽‍🍼";
	inline constexpr const char man_feeding_baby_medium_skin_tone[] = "👨🏽‍🍼";
	inline constexpr const char man_feeding_baby_tone4[] = "👨🏾‍🍼";
	inline constexpr const char man_feeding_baby_medium_dark_skin_tone[] = "👨🏾‍🍼";
	inline constexpr const char man_feeding_baby_tone5[] = "👨🏿‍🍼";
	inline constexpr const char man_feeding_baby_dark_skin_tone[] = "👨🏿‍🍼";
	inline constexpr const char person_bowing[] = "🙇";
	inline constexpr const char bow[] = "🙇";
	inline constexpr const char person_bowing_tone1[] = "🙇🏻";
	inline constexpr const char bow_tone1[] = "🙇🏻";
	inline constexpr const char person_bowing_tone2[] = "🙇🏼";
	inline constexpr const char bow_tone2[] = "🙇🏼";
	inline constexpr const char person_bowing_tone3[] = "🙇🏽";
	inline constexpr const char bow_tone3[] = "🙇🏽";
	inline constexpr const char person_bowing_tone4[] = "🙇🏾";
	inline constexpr const char bow_tone4[] = "🙇🏾";
	inline constexpr const char person_bowing_tone5[] = "🙇🏿";
	inline constexpr const char bow_tone5[] = "🙇🏿";
	inline constexpr const char woman_bowing[] = "🙇‍♀️";
	inline constexpr const char woman_bowing_tone1[] = "🙇🏻‍♀️";
	inline constexpr const char woman_bowing_light_skin_tone[] = "🙇🏻‍♀️";
	inline constexpr const char woman_bowing_tone2[] = "🙇🏼‍♀️";
	inline constexpr const char woman_bowing_medium_light_skin_tone[] = "🙇🏼‍♀️";
	inline constexpr const char woman_bowing_tone3[] = "🙇🏽‍♀️";
	inline constexpr const char woman_bowing_medium_skin_tone[] = "🙇🏽‍♀️";
	inline constexpr const char woman_bowing_tone4[] = "🙇🏾‍♀️";
	inline constexpr const char woman_bowing_medium_dark_skin_tone[] = "🙇🏾‍♀️";
	inline constexpr const char woman_bowing_tone5[] = "🙇🏿‍♀️";
	inline constexpr const char woman_bowing_dark_skin_tone[] = "🙇🏿‍♀️";
	inline constexpr const char man_bowing[] = "🙇‍♂️";
	inline constexpr const char man_bowing_tone1[] = "🙇🏻‍♂️";
	inline constexpr const char man_bowing_light_skin_tone[] = "🙇🏻‍♂️";
	inline constexpr const char man_bowing_tone2[] = "🙇🏼‍♂️";
	inline constexpr const char man_bowing_medium_light_skin_tone[] = "🙇🏼‍♂️";
	inline constexpr const char man_bowing_tone3[] = "🙇🏽‍♂️";
	inline constexpr const char man_bowing_medium_skin_tone[] = "🙇🏽‍♂️";
	inline constexpr const char man_bowing_tone4[] = "🙇🏾‍♂️";
	inline constexpr const char man_bowing_medium_dark_skin_tone[] = "🙇🏾‍♂️";
	inline constexpr const char man_bowing_tone5[] = "🙇🏿‍♂️";
	inline constexpr const char man_bowing_dark_skin_tone[] = "🙇🏿‍♂️";
	inline constexpr const char person_tipping_hand[] = "💁";
	inline constexpr const char information_desk_person[] = "💁";
	inline constexpr const char person_tipping_hand_tone1[] = "💁🏻";
	inline constexpr const char information_desk_person_tone1[] = "💁🏻";
	inline constexpr const char person_tipping_hand_tone2[] = "💁🏼";
	inline constexpr const char information_desk_person_tone2[] = "💁🏼";
	inline constexpr const char person_tipping_hand_tone3[] = "💁🏽";
	inline constexpr const char information_desk_person_tone3[] = "💁🏽";
	inline constexpr const char person_tipping_hand_tone4[] = "💁🏾";
	inline constexpr const char information_desk_person_tone4[] = "💁🏾";
	inline constexpr const char person_tipping_hand_tone5[] = "💁🏿";
	inline constexpr const char information_desk_person_tone5[] = "💁🏿";
	inline constexpr const char woman_tipping_hand[] = "💁‍♀️";
	inline constexpr const char woman_tipping_hand_tone1[] = "💁🏻‍♀️";
	inline constexpr const char woman_tipping_hand_light_skin_tone[] = "💁🏻‍♀️";
	inline constexpr const char woman_tipping_hand_tone2[] = "💁🏼‍♀️";
	inline constexpr const char woman_tipping_hand_medium_light_skin_tone[] = "💁🏼‍♀️";
	inline constexpr const char woman_tipping_hand_tone3[] = "💁🏽‍♀️";
	inline constexpr const char woman_tipping_hand_medium_skin_tone[] = "💁🏽‍♀️";
	inline constexpr const char woman_tipping_hand_tone4[] = "💁🏾‍♀️";
	inline constexpr const char woman_tipping_hand_medium_dark_skin_tone[] = "💁🏾‍♀️";
	inline constexpr const char woman_tipping_hand_tone5[] = "💁🏿‍♀️";
	inline constexpr const char woman_tipping_hand_dark_skin_tone[] = "💁🏿‍♀️";
	inline constexpr const char man_tipping_hand[] = "💁‍♂️";
	inline constexpr const char man_tipping_hand_tone1[] = "💁🏻‍♂️";
	inline constexpr const char man_tipping_hand_light_skin_tone[] = "💁🏻‍♂️";
	inline constexpr const char man_tipping_hand_tone2[] = "💁🏼‍♂️";
	inline constexpr const char man_tipping_hand_medium_light_skin_tone[] = "💁🏼‍♂️";
	inline constexpr const char man_tipping_hand_tone3[] = "💁🏽‍♂️";
	inline constexpr const char man_tipping_hand_medium_skin_tone[] = "💁🏽‍♂️";
	inline constexpr const char man_tipping_hand_tone4[] = "💁🏾‍♂️";
	inline constexpr const char man_tipping_hand_medium_dark_skin_tone[] = "💁🏾‍♂️";
	inline constexpr const char man_tipping_hand_tone5[] = "💁🏿‍♂️";
	inline constexpr const char man_tipping_hand_dark_skin_tone[] = "💁🏿‍♂️";
	inline constexpr const char person_gesturing_no[] = "🙅";
	inline constexpr const char no_good[] = "🙅";
	inline constexpr const char person_gesturing_no_tone1[] = "🙅🏻";
	inline constexpr const char no_good_tone1[] = "🙅🏻";
	inline constexpr const char person_gesturing_no_tone2[] = "🙅🏼";
	inline constexpr const char no_good_tone2[] = "🙅🏼";
	inline constexpr const char person_gesturing_no_tone3[] = "🙅🏽";
	inline constexpr const char no_good_tone3[] = "🙅🏽";
	inline constexpr const char person_gesturing_no_tone4[] = "🙅🏾";
	inline constexpr const char no_good_tone4[] = "🙅🏾";
	inline constexpr const char person_gesturing_no_tone5[] = "🙅🏿";
	inline constexpr const char no_good_tone5[] = "🙅🏿";
	inline constexpr const char woman_gesturing_no[] = "🙅‍♀️";
	inline constexpr const char woman_gesturing_no_tone1[] = "🙅🏻‍♀️";
	inline constexpr const char woman_gesturing_no_light_skin_tone[] = "🙅🏻‍♀️";
	inline constexpr const char woman_gesturing_no_tone2[] = "🙅🏼‍♀️";
	inline constexpr const char woman_gesturing_no_medium_light_skin_tone[] = "🙅🏼‍♀️";
	inline constexpr const char woman_gesturing_no_tone3[] = "🙅🏽‍♀️";
	inline constexpr const char woman_gesturing_no_medium_skin_tone[] = "🙅🏽‍♀️";
	inline constexpr const char woman_gesturing_no_tone4[] = "🙅🏾‍♀️";
	inline constexpr const char woman_gesturing_no_medium_dark_skin_tone[] = "🙅🏾‍♀️";
	inline constexpr const char woman_gesturing_no_tone5[] = "🙅🏿‍♀️";
	inline constexpr const char woman_gesturing_no_dark_skin_tone[] = "🙅🏿‍♀️";
	inline constexpr const char man_gesturing_no[] = "🙅‍♂️";
	inline constexpr const char man_gesturing_no_tone1[] = "🙅🏻‍♂️";
	inline constexpr const char man_gesturing_no_light_skin_tone[] = "🙅🏻‍♂️";
	inline constexpr const char man_gesturing_no_tone2[] = "🙅🏼‍♂️";
	inline constexpr const char man_gesturing_no_medium_light_skin_tone[] = "🙅🏼‍♂️";
	inline constexpr const char man_gesturing_no_tone3[] = "🙅🏽‍♂️";
	inline constexpr const char man_gesturing_no_medium_skin_tone[] = "🙅🏽‍♂️";
	inline constexpr const char man_gesturing_no_tone4[] = "🙅🏾‍♂️";
	inline constexpr const char man_gesturing_no_medium_dark_skin_tone[] = "🙅🏾‍♂️";
	inline constexpr const char man_gesturing_no_tone5[] = "🙅🏿‍♂️";
	inline constexpr const char man_gesturing_no_dark_skin_tone[] = "🙅🏿‍♂️";
	inline constexpr const char person_gesturing_ok[] = "🙆";
	inline constexpr const char person_gesturing_ok_tone1[] = "🙆🏻";
	inline constexpr const char person_gesturing_ok_tone2[] = "🙆🏼";
	inline constexpr const char person_gesturing_ok_tone3[] = "🙆🏽";
	inline constexpr const char person_gesturing_ok_tone4[] = "🙆🏾";
	inline constexpr const char person_gesturing_ok_tone5[] = "🙆🏿";
	inline constexpr const char woman_gesturing_ok[] = "🙆‍♀️";
	inline constexpr const char woman_gesturing_ok_tone1[] = "🙆🏻‍♀️";
	inline constexpr const char woman_gesturing_ok_light_skin_tone[] = "🙆🏻‍♀️";
	inline constexpr const char woman_gesturing_ok_tone2[] = "🙆🏼‍♀️";
	inline constexpr const char woman_gesturing_ok_medium_light_skin_tone[] = "🙆🏼‍♀️";
	inline constexpr const char woman_gesturing_ok_tone3[] = "🙆🏽‍♀️";
	inline constexpr const char woman_gesturing_ok_medium_skin_tone[] = "🙆🏽‍♀️";
	inline constexpr const char woman_gesturing_ok_tone4[] = "🙆🏾‍♀️";
	inline constexpr const char woman_gesturing_ok_medium_dark_skin_tone[] = "🙆🏾‍♀️";
	inline constexpr const char woman_gesturing_ok_tone5[] = "🙆🏿‍♀️";
	inline constexpr const char woman_gesturing_ok_dark_skin_tone[] = "🙆🏿‍♀️";
	inline constexpr const char man_gesturing_ok[] = "🙆‍♂️";
	inline constexpr const char man_gesturing_ok_tone1[] = "🙆🏻‍♂️";
	inline constexpr const char man_gesturing_ok_light_skin_tone[] = "🙆🏻‍♂️";
	inline constexpr const char man_gesturing_ok_tone2[] = "🙆🏼‍♂️";
	inline constexpr const char man_gesturing_ok_medium_light_skin_tone[] = "🙆🏼‍♂️";
	inline constexpr const char man_gesturing_ok_tone3[] = "🙆🏽‍♂️";
	inline constexpr const char man_gesturing_ok_medium_skin_tone[] = "🙆🏽‍♂️";
	inline constexpr const char man_gesturing_ok_tone4[] = "🙆🏾‍♂️";
	inline constexpr const char man_gesturing_ok_medium_dark_skin_tone[] = "🙆🏾‍♂️";
	inline constexpr const char man_gesturing_ok_tone5[] = "🙆🏿‍♂️";
	inline constexpr const char man_gesturing_ok_dark_skin_tone[] = "🙆🏿‍♂️";
	inline constexpr const char person_raising_hand[] = "🙋";
	inline constexpr const char raising_hand[] = "🙋";
	inline constexpr const char person_raising_hand_tone1[] = "🙋🏻";
	inline constexpr const char raising_hand_tone1[] = "🙋🏻";
	inline constexpr const char person_raising_hand_tone2[] = "🙋🏼";
	inline constexpr const char raising_hand_tone2[] = "🙋🏼";
	inline constexpr const char person_raising_hand_tone3[] = "🙋🏽";
	inline constexpr const char raising_hand_tone3[] = "🙋🏽";
	inline constexpr const char person_raising_hand_tone4[] = "🙋🏾";
	inline constexpr const char raising_hand_tone4[] = "🙋🏾";
	inline constexpr const char person_raising_hand_tone5[] = "🙋🏿";
	inline constexpr const char raising_hand_tone5[] = "🙋🏿";
	inline constexpr const char woman_raising_hand[] = "🙋‍♀️";
	inline constexpr const char woman_raising_hand_tone1[] = "🙋🏻‍♀️";
	inline constexpr const char woman_raising_hand_light_skin_tone[] = "🙋🏻‍♀️";
	inline constexpr const char woman_raising_hand_tone2[] = "🙋🏼‍♀️";
	inline constexpr const char woman_raising_hand_medium_light_skin_tone[] = "🙋🏼‍♀️";
	inline constexpr const char woman_raising_hand_tone3[] = "🙋🏽‍♀️";
	inline constexpr const char woman_raising_hand_medium_skin_tone[] = "🙋🏽‍♀️";
	inline constexpr const char woman_raising_hand_tone4[] = "🙋🏾‍♀️";
	inline constexpr const char woman_raising_hand_medium_dark_skin_tone[] = "🙋🏾‍♀️";
	inline constexpr const char woman_raising_hand_tone5[] = "🙋🏿‍♀️";
	inline constexpr const char woman_raising_hand_dark_skin_tone[] = "🙋🏿‍♀️";
	inline constexpr const char man_raising_hand[] = "🙋‍♂️";
	inline constexpr const char man_raising_hand_tone1[] = "🙋🏻‍♂️";
	inline constexpr const char man_raising_hand_light_skin_tone[] = "🙋🏻‍♂️";
	inline constexpr const char man_raising_hand_tone2[] = "🙋🏼‍♂️";
	inline constexpr const char man_raising_hand_medium_light_skin_tone[] = "🙋🏼‍♂️";
	inline constexpr const char man_raising_hand_tone3[] = "🙋🏽‍♂️";
	inline constexpr const char man_raising_hand_medium_skin_tone[] = "🙋🏽‍♂️";
	inline constexpr const char man_raising_hand_tone4[] = "🙋🏾‍♂️";
	inline constexpr const char man_raising_hand_medium_dark_skin_tone[] = "🙋🏾‍♂️";
	inline constexpr const char man_raising_hand_tone5[] = "🙋🏿‍♂️";
	inline constexpr const char man_raising_hand_dark_skin_tone[] = "🙋🏿‍♂️";
	inline constexpr const char deaf_person[] = "🧏";
	inline constexpr const char deaf_person_tone1[] = "🧏🏻";
	inline constexpr const char deaf_person_light_skin_tone[] = "🧏🏻";
	inline constexpr const char deaf_person_tone2[] = "🧏🏼";
	inline constexpr const char deaf_person_medium_light_skin_tone[] = "🧏🏼";
	inline constexpr const char deaf_person_tone3[] = "🧏🏽";
	inline constexpr const char deaf_person_medium_skin_tone[] = "🧏🏽";
	inline constexpr const char deaf_person_tone4[] = "🧏🏾";
	inline constexpr const char deaf_person_medium_dark_skin_tone[] = "🧏🏾";
	inline constexpr const char deaf_person_tone5[] = "🧏🏿";
	inline constexpr const char deaf_person_dark_skin_tone[] = "🧏🏿";
	inline constexpr const char deaf_woman[] = "🧏‍♀️";
	inline constexpr const char deaf_woman_tone1[] = "🧏🏻‍♀️";
	inline constexpr const char deaf_woman_light_skin_tone[] = "🧏🏻‍♀️";
	inline constexpr const char deaf_woman_tone2[] = "🧏🏼‍♀️";
	inline constexpr const char deaf_woman_medium_light_skin_tone[] = "🧏🏼‍♀️";
	inline constexpr const char deaf_woman_tone3[] = "🧏🏽‍♀️";
	inline constexpr const char deaf_woman_medium_skin_tone[] = "🧏🏽‍♀️";
	inline constexpr const char deaf_woman_tone4[] = "🧏🏾‍♀️";
	inline constexpr const char deaf_woman_medium_dark_skin_tone[] = "🧏🏾‍♀️";
	inline constexpr const char deaf_woman_tone5[] = "🧏🏿‍♀️";
	inline constexpr const char deaf_woman_dark_skin_tone[] = "🧏🏿‍♀️";
	inline constexpr const char deaf_man[] = "🧏‍♂️";
	inline constexpr const char deaf_man_tone1[] = "🧏🏻‍♂️";
	inline constexpr const char deaf_man_light_skin_tone[] = "🧏🏻‍♂️";
	inline constexpr const char deaf_man_tone2[] = "🧏🏼‍♂️";
	inline constexpr const char deaf_man_medium_light_skin_tone[] = "🧏🏼‍♂️";
	inline constexpr const char deaf_man_tone3[] = "🧏🏽‍♂️";
	inline constexpr const char deaf_man_medium_skin_tone[] = "🧏🏽‍♂️";
	inline constexpr const char deaf_man_tone4[] = "🧏🏾‍♂️";
	inline constexpr const char deaf_man_medium_dark_skin_tone[] = "🧏🏾‍♂️";
	inline constexpr const char deaf_man_tone5[] = "🧏🏿‍♂️";
	inline constexpr const char deaf_man_dark_skin_tone[] = "🧏🏿‍♂️";
	inline constexpr const char person_facepalming[] = "🤦";
	inline constexpr const char face_palm[] = "🤦";
	inline constexpr const char facepalm[] = "🤦";
	inline constexpr const char person_facepalming_tone1[] = "🤦🏻";
	inline constexpr const char face_palm_tone1[] = "🤦🏻";
	inline constexpr const char facepalm_tone1[] = "🤦🏻";
	inline constexpr const char person_facepalming_tone2[] = "🤦🏼";
	inline constexpr const char face_palm_tone2[] = "🤦🏼";
	inline constexpr const char facepalm_tone2[] = "🤦🏼";
	inline constexpr const char person_facepalming_tone3[] = "🤦🏽";
	inline constexpr const char face_palm_tone3[] = "🤦🏽";
	inline constexpr const char facepalm_tone3[] = "🤦🏽";
	inline constexpr const char person_facepalming_tone4[] = "🤦🏾";
	inline constexpr const char face_palm_tone4[] = "🤦🏾";
	inline constexpr const char facepalm_tone4[] = "🤦🏾";
	inline constexpr const char person_facepalming_tone5[] = "🤦🏿";
	inline constexpr const char face_palm_tone5[] = "🤦🏿";
	inline constexpr const char facepalm_tone5[] = "🤦🏿";
	inline constexpr const char woman_facepalming[] = "🤦‍♀️";
	inline constexpr const char woman_facepalming_tone1[] = "🤦🏻‍♀️";
	inline constexpr const char woman_facepalming_light_skin_tone[] = "🤦🏻‍♀️";
	inline constexpr const char woman_facepalming_tone2[] = "🤦🏼‍♀️";
	inline constexpr const char woman_facepalming_medium_light_skin_tone[] = "🤦🏼‍♀️";
	inline constexpr const char woman_facepalming_tone3[] = "🤦🏽‍♀️";
	inline constexpr const char woman_facepalming_medium_skin_tone[] = "🤦🏽‍♀️";
	inline constexpr const char woman_facepalming_tone4[] = "🤦🏾‍♀️";
	inline constexpr const char woman_facepalming_medium_dark_skin_tone[] = "🤦🏾‍♀️";
	inline constexpr const char woman_facepalming_tone5[] = "🤦🏿‍♀️";
	inline constexpr const char woman_facepalming_dark_skin_tone[] = "🤦🏿‍♀️";
	inline constexpr const char man_facepalming[] = "🤦‍♂️";
	inline constexpr const char man_facepalming_tone1[] = "🤦🏻‍♂️";
	inline constexpr const char man_facepalming_light_skin_tone[] = "🤦🏻‍♂️";
	inline constexpr const char man_facepalming_tone2[] = "🤦🏼‍♂️";
	inline constexpr const char man_facepalming_medium_light_skin_tone[] = "🤦🏼‍♂️";
	inline constexpr const char man_facepalming_tone3[] = "🤦🏽‍♂️";
	inline constexpr const char man_facepalming_medium_skin_tone[] = "🤦🏽‍♂️";
	inline constexpr const char man_facepalming_tone4[] = "🤦🏾‍♂️";
	inline constexpr const char man_facepalming_medium_dark_skin_tone[] = "🤦🏾‍♂️";
	inline constexpr const char man_facepalming_tone5[] = "🤦🏿‍♂️";
	inline constexpr const char man_facepalming_dark_skin_tone[] = "🤦🏿‍♂️";
	inline constexpr const char person_shrugging[] = "🤷";
	inline constexpr const char shrug[] = "🤷";
	inline constexpr const char person_shrugging_tone1[] = "🤷🏻";
	inline constexpr const char shrug_tone1[] = "🤷🏻";
	inline constexpr const char person_shrugging_tone2[] = "🤷🏼";
	inline constexpr const char shrug_tone2[] = "🤷🏼";
	inline constexpr const char person_shrugging_tone3[] = "🤷🏽";
	inline constexpr const char shrug_tone3[] = "🤷🏽";
	inline constexpr const char person_shrugging_tone4[] = "🤷🏾";
	inline constexpr const char shrug_tone4[] = "🤷🏾";
	inline constexpr const char person_shrugging_tone5[] = "🤷🏿";
	inline constexpr const char shrug_tone5[] = "🤷🏿";
	inline constexpr const char woman_shrugging[] = "🤷‍♀️";
	inline constexpr const char woman_shrugging_tone1[] = "🤷🏻‍♀️";
	inline constexpr const char woman_shrugging_light_skin_tone[] = "🤷🏻‍♀️";
	inline constexpr const char woman_shrugging_tone2[] = "🤷🏼‍♀️";
	inline constexpr const char woman_shrugging_medium_light_skin_tone[] = "🤷🏼‍♀️";
	inline constexpr const char woman_shrugging_tone3[] = "🤷🏽‍♀️";
	inline constexpr const char woman_shrugging_medium_skin_tone[] = "🤷🏽‍♀️";
	inline constexpr const char woman_shrugging_tone4[] = "🤷🏾‍♀️";
	inline constexpr const char woman_shrugging_medium_dark_skin_tone[] = "🤷🏾‍♀️";
	inline constexpr const char woman_shrugging_tone5[] = "🤷🏿‍♀️";
	inline constexpr const char woman_shrugging_dark_skin_tone[] = "🤷🏿‍♀️";
	inline constexpr const char man_shrugging[] = "🤷‍♂️";
	inline constexpr const char man_shrugging_tone1[] = "🤷🏻‍♂️";
	inline constexpr const char man_shrugging_light_skin_tone[] = "🤷🏻‍♂️";
	inline constexpr const char man_shrugging_tone2[] = "🤷🏼‍♂️";
	inline constexpr const char man_shrugging_medium_light_skin_tone[] = "🤷🏼‍♂️";
	inline constexpr const char man_shrugging_tone3[] = "🤷🏽‍♂️";
	inline constexpr const char man_shrugging_medium_skin_tone[] = "🤷🏽‍♂️";
	inline constexpr const char man_shrugging_tone4[] = "🤷🏾‍♂️";
	inline constexpr const char man_shrugging_medium_dark_skin_tone[] = "🤷🏾‍♂️";
	inline constexpr const char man_shrugging_tone5[] = "🤷🏿‍♂️";
	inline constexpr const char man_shrugging_dark_skin_tone[] = "🤷🏿‍♂️";
	inline constexpr const char person_pouting[] = "🙎";
	inline constexpr const char person_with_pouting_face[] = "🙎";
	inline constexpr const char person_pouting_tone1[] = "🙎🏻";
	inline constexpr const char person_with_pouting_face_tone1[] = "🙎🏻";
	inline constexpr const char person_pouting_tone2[] = "🙎🏼";
	inline constexpr const char person_with_pouting_face_tone2[] = "🙎🏼";
	inline constexpr const char person_pouting_tone3[] = "🙎🏽";
	inline constexpr const char person_with_pouting_face_tone3[] = "🙎🏽";
	inline constexpr const char person_pouting_tone4[] = "🙎🏾";
	inline constexpr const char person_with_pouting_face_tone4[] = "🙎🏾";
	inline constexpr const char person_pouting_tone5[] = "🙎🏿";
	inline constexpr const char person_with_pouting_face_tone5[] = "🙎🏿";
	inline constexpr const char woman_pouting[] = "🙎‍♀️";
	inline constexpr const char woman_pouting_tone1[] = "🙎🏻‍♀️";
	inline constexpr const char woman_pouting_light_skin_tone[] = "🙎🏻‍♀️";
	inline constexpr const char woman_pouting_tone2[] = "🙎🏼‍♀️";
	inline constexpr const char woman_pouting_medium_light_skin_tone[] = "🙎🏼‍♀️";
	inline constexpr const char woman_pouting_tone3[] = "🙎🏽‍♀️";
	inline constexpr const char woman_pouting_medium_skin_tone[] = "🙎🏽‍♀️";
	inline constexpr const char woman_pouting_tone4[] = "🙎🏾‍♀️";
	inline constexpr const char woman_pouting_medium_dark_skin_tone[] = "🙎🏾‍♀️";
	inline constexpr const char woman_pouting_tone5[] = "🙎🏿‍♀️";
	inline constexpr const char woman_pouting_dark_skin_tone[] = "🙎🏿‍♀️";
	inline constexpr const char man_pouting[] = "🙎‍♂️";
	inline constexpr const char man_pouting_tone1[] = "🙎🏻‍♂️";
	inline constexpr const char man_pouting_light_skin_tone[] = "🙎🏻‍♂️";
	inline constexpr const char man_pouting_tone2[] = "🙎🏼‍♂️";
	inline constexpr const char man_pouting_medium_light_skin_tone[] = "🙎🏼‍♂️";
	inline constexpr const char man_pouting_tone3[] = "🙎🏽‍♂️";
	inline constexpr const char man_pouting_medium_skin_tone[] = "🙎🏽‍♂️";
	inline constexpr const char man_pouting_tone4[] = "🙎🏾‍♂️";
	inline constexpr const char man_pouting_medium_dark_skin_tone[] = "🙎🏾‍♂️";
	inline constexpr const char man_pouting_tone5[] = "🙎🏿‍♂️";
	inline constexpr const char man_pouting_dark_skin_tone[] = "🙎🏿‍♂️";
	inline constexpr const char person_frowning[] = "🙍";
	inline constexpr const char person_frowning_tone1[] = "🙍🏻";
	inline constexpr const char person_frowning_tone2[] = "🙍🏼";
	inline constexpr const char person_frowning_tone3[] = "🙍🏽";
	inline constexpr const char person_frowning_tone4[] = "🙍🏾";
	inline constexpr const char person_frowning_tone5[] = "🙍🏿";
	inline constexpr const char woman_frowning[] = "🙍‍♀️";
	inline constexpr const char woman_frowning_tone1[] = "🙍🏻‍♀️";
	inline constexpr const char woman_frowning_light_skin_tone[] = "🙍🏻‍♀️";
	inline constexpr const char woman_frowning_tone2[] = "🙍🏼‍♀️";
	inline constexpr const char woman_frowning_medium_light_skin_tone[] = "🙍🏼‍♀️";
	inline constexpr const char woman_frowning_tone3[] = "🙍🏽‍♀️";
	inline constexpr const char woman_frowning_medium_skin_tone[] = "🙍🏽‍♀️";
	inline constexpr const char woman_frowning_tone4[] = "🙍🏾‍♀️";
	inline constexpr const char woman_frowning_medium_dark_skin_tone[] = "🙍🏾‍♀️";
	inline constexpr const char woman_frowning_tone5[] = "🙍🏿‍♀️";
	inline constexpr const char woman_frowning_dark_skin_tone[] = "🙍🏿‍♀️";
	inline constexpr const char man_frowning[] = "🙍‍♂️";
	inline constexpr const char man_frowning_tone1[] = "🙍🏻‍♂️";
	inline constexpr const char man_frowning_light_skin_tone[] = "🙍🏻‍♂️";
	inline constexpr const char man_frowning_tone2[] = "🙍🏼‍♂️";
	inline constexpr const char man_frowning_medium_light_skin_tone[] = "🙍🏼‍♂️";
	inline constexpr const char man_frowning_tone3[] = "🙍🏽‍♂️";
	inline constexpr const char man_frowning_medium_skin_tone[] = "🙍🏽‍♂️";
	inline constexpr const char man_frowning_tone4[] = "🙍🏾‍♂️";
	inline constexpr const char man_frowning_medium_dark_skin_tone[] = "🙍🏾‍♂️";
	inline constexpr const char man_frowning_tone5[] = "🙍🏿‍♂️";
	inline constexpr const char man_frowning_dark_skin_tone[] = "🙍🏿‍♂️";
	inline constexpr const char person_getting_haircut[] = "💇";
	inline constexpr const char haircut[] = "💇";
	inline constexpr const char person_getting_haircut_tone1[] = "💇🏻";
	inline constexpr const char haircut_tone1[] = "💇🏻";
	inline constexpr const char person_getting_haircut_tone2[] = "💇🏼";
	inline constexpr const char haircut_tone2[] = "💇🏼";
	inline constexpr const char person_getting_haircut_tone3[] = "💇🏽";
	inline constexpr const char haircut_tone3[] = "💇🏽";
	inline constexpr const char person_getting_haircut_tone4[] = "💇🏾";
	inline constexpr const char haircut_tone4[] = "💇🏾";
	inline constexpr const char person_getting_haircut_tone5[] = "💇🏿";
	inline constexpr const char haircut_tone5[] = "💇🏿";
	inline constexpr const char woman_getting_haircut[] = "💇‍♀️";
	inline constexpr const char woman_getting_haircut_tone1[] = "💇🏻‍♀️";
	inline constexpr const char woman_getting_haircut_light_skin_tone[] = "💇🏻‍♀️";
	inline constexpr const char woman_getting_haircut_tone2[] = "💇🏼‍♀️";
	inline constexpr const char woman_getting_haircut_medium_light_skin_tone[] = "💇🏼‍♀️";
	inline constexpr const char woman_getting_haircut_tone3[] = "💇🏽‍♀️";
	inline constexpr const char woman_getting_haircut_medium_skin_tone[] = "💇🏽‍♀️";
	inline constexpr const char woman_getting_haircut_tone4[] = "💇🏾‍♀️";
	inline constexpr const char woman_getting_haircut_medium_dark_skin_tone[] = "💇🏾‍♀️";
	inline constexpr const char woman_getting_haircut_tone5[] = "💇🏿‍♀️";
	inline constexpr const char woman_getting_haircut_dark_skin_tone[] = "💇🏿‍♀️";
	inline constexpr const char man_getting_haircut[] = "💇‍♂️";
	inline constexpr const char man_getting_haircut_tone1[] = "💇🏻‍♂️";
	inline constexpr const char man_getting_haircut_light_skin_tone[] = "💇🏻‍♂️";
	inline constexpr const char man_getting_haircut_tone2[] = "💇🏼‍♂️";
	inline constexpr const char man_getting_haircut_medium_light_skin_tone[] = "💇🏼‍♂️";
	inline constexpr const char man_getting_haircut_tone3[] = "💇🏽‍♂️";
	inline constexpr const char man_getting_haircut_medium_skin_tone[] = "💇🏽‍♂️";
	inline constexpr const char man_getting_haircut_tone4[] = "💇🏾‍♂️";
	inline constexpr const char man_getting_haircut_medium_dark_skin_tone[] = "💇🏾‍♂️";
	inline constexpr const char man_getting_haircut_tone5[] = "💇🏿‍♂️";
	inline constexpr const char man_getting_haircut_dark_skin_tone[] = "💇🏿‍♂️";
	inline constexpr const char person_getting_massage[] = "💆";
	inline constexpr const char massage[] = "💆";
	inline constexpr const char person_getting_massage_tone1[] = "💆🏻";
	inline constexpr const char massage_tone1[] = "💆🏻";
	inline constexpr const char person_getting_massage_tone2[] = "💆🏼";
	inline constexpr const char massage_tone2[] = "💆🏼";
	inline constexpr const char person_getting_massage_tone3[] = "💆🏽";
	inline constexpr const char massage_tone3[] = "💆🏽";
	inline constexpr const char person_getting_massage_tone4[] = "💆🏾";
	inline constexpr const char massage_tone4[] = "💆🏾";
	inline constexpr const char person_getting_massage_tone5[] = "💆🏿";
	inline constexpr const char massage_tone5[] = "💆🏿";
	inline constexpr const char woman_getting_face_massage[] = "💆‍♀️";
	inline constexpr const char woman_getting_face_massage_tone1[] = "💆🏻‍♀️";
	inline constexpr const char woman_getting_face_massage_light_skin_tone[] = "💆🏻‍♀️";
	inline constexpr const char woman_getting_face_massage_tone2[] = "💆🏼‍♀️";
	inline constexpr const char woman_getting_face_massage_medium_light_skin_tone[] = "💆🏼‍♀️";
	inline constexpr const char woman_getting_face_massage_tone3[] = "💆🏽‍♀️";
	inline constexpr const char woman_getting_face_massage_medium_skin_tone[] = "💆🏽‍♀️";
	inline constexpr const char woman_getting_face_massage_tone4[] = "💆🏾‍♀️";
	inline constexpr const char woman_getting_face_massage_medium_dark_skin_tone[] = "💆🏾‍♀️";
	inline constexpr const char woman_getting_face_massage_tone5[] = "💆🏿‍♀️";
	inline constexpr const char woman_getting_face_massage_dark_skin_tone[] = "💆🏿‍♀️";
	inline constexpr const char man_getting_face_massage[] = "💆‍♂️";
	inline constexpr const char man_getting_face_massage_tone1[] = "💆🏻‍♂️";
	inline constexpr const char man_getting_face_massage_light_skin_tone[] = "💆🏻‍♂️";
	inline constexpr const char man_getting_face_massage_tone2[] = "💆🏼‍♂️";
	inline constexpr const char man_getting_face_massage_medium_light_skin_tone[] = "💆🏼‍♂️";
	inline constexpr const char man_getting_face_massage_tone3[] = "💆🏽‍♂️";
	inline constexpr const char man_getting_face_massage_medium_skin_tone[] = "💆🏽‍♂️";
	inline constexpr const char man_getting_face_massage_tone4[] = "💆🏾‍♂️";
	inline constexpr const char man_getting_face_massage_medium_dark_skin_tone[] = "💆🏾‍♂️";
	inline constexpr const char man_getting_face_massage_tone5[] = "💆🏿‍♂️";
	inline constexpr const char man_getting_face_massage_dark_skin_tone[] = "💆🏿‍♂️";
	inline constexpr const char person_in_steamy_room[] = "🧖";
	inline constexpr const char person_in_steamy_room_tone1[] = "🧖🏻";
	inline constexpr const char person_in_steamy_room_light_skin_tone[] = "🧖🏻";
	inline constexpr const char person_in_steamy_room_tone2[] = "🧖🏼";
	inline constexpr const char person_in_steamy_room_medium_light_skin_tone[] = "🧖🏼";
	inline constexpr const char person_in_steamy_room_tone3[] = "🧖🏽";
	inline constexpr const char person_in_steamy_room_medium_skin_tone[] = "🧖🏽";
	inline constexpr const char person_in_steamy_room_tone4[] = "🧖🏾";
	inline constexpr const char person_in_steamy_room_medium_dark_skin_tone[] = "🧖🏾";
	inline constexpr const char person_in_steamy_room_tone5[] = "🧖🏿";
	inline constexpr const char person_in_steamy_room_dark_skin_tone[] = "🧖🏿";
	inline constexpr const char woman_in_steamy_room[] = "🧖‍♀️";
	inline constexpr const char woman_in_steamy_room_tone1[] = "🧖🏻‍♀️";
	inline constexpr const char woman_in_steamy_room_light_skin_tone[] = "🧖🏻‍♀️";
	inline constexpr const char woman_in_steamy_room_tone2[] = "🧖🏼‍♀️";
	inline constexpr const char woman_in_steamy_room_medium_light_skin_tone[] = "🧖🏼‍♀️";
	inline constexpr const char woman_in_steamy_room_tone3[] = "🧖🏽‍♀️";
	inline constexpr const char woman_in_steamy_room_medium_skin_tone[] = "🧖🏽‍♀️";
	inline constexpr const char woman_in_steamy_room_tone4[] = "🧖🏾‍♀️";
	inline constexpr const char woman_in_steamy_room_medium_dark_skin_tone[] = "🧖🏾‍♀️";
	inline constexpr const char woman_in_steamy_room_tone5[] = "🧖🏿‍♀️";
	inline constexpr const char woman_in_steamy_room_dark_skin_tone[] = "🧖🏿‍♀️";
	inline constexpr const char man_in_steamy_room[] = "🧖‍♂️";
	inline constexpr const char man_in_steamy_room_tone1[] = "🧖🏻‍♂️";
	inline constexpr const char man_in_steamy_room_light_skin_tone[] = "🧖🏻‍♂️";
	inline constexpr const char man_in_steamy_room_tone2[] = "🧖🏼‍♂️";
	inline constexpr const char man_in_steamy_room_medium_light_skin_tone[] = "🧖🏼‍♂️";
	inline constexpr const char man_in_steamy_room_tone3[] = "🧖🏽‍♂️";
	inline constexpr const char man_in_steamy_room_medium_skin_tone[] = "🧖🏽‍♂️";
	inline constexpr const char man_in_steamy_room_tone4[] = "🧖🏾‍♂️";
	inline constexpr const char man_in_steamy_room_medium_dark_skin_tone[] = "🧖🏾‍♂️";
	inline constexpr const char man_in_steamy_room_tone5[] = "🧖🏿‍♂️";
	inline constexpr const char man_in_steamy_room_dark_skin_tone[] = "🧖🏿‍♂️";
	inline constexpr const char nail_care[] = "💅";
	inline constexpr const char nail_polish[] = "💅";
	inline constexpr const char nail_care_tone1[] = "💅🏻";
	inline constexpr const char nail_care_tone2[] = "💅🏼";
	inline constexpr const char nail_care_tone3[] = "💅🏽";
	inline constexpr const char nail_care_tone4[] = "💅🏾";
	inline constexpr const char nail_care_tone5[] = "💅🏿";
	inline constexpr const char selfie[] = "🤳";
	inline constexpr const char selfie_tone1[] = "🤳🏻";
	inline constexpr const char selfie_tone2[] = "🤳🏼";
	inline constexpr const char selfie_tone3[] = "🤳🏽";
	inline constexpr const char selfie_tone4[] = "🤳🏾";
	inline constexpr const char selfie_tone5[] = "🤳🏿";
	inline constexpr const char dancer[] = "💃";
	inline constexpr const char woman_dancing[] = "💃";
	inline constexpr const char dancer_tone1[] = "💃🏻";
	inline constexpr const char dancer_tone2[] = "💃🏼";
	inline constexpr const char dancer_tone3[] = "💃🏽";
	inline constexpr const char dancer_tone4[] = "💃🏾";
	inline constexpr const char dancer_tone5[] = "💃🏿";
	inline constexpr const char man_dancing[] = "🕺";
	inline constexpr const char male_dancer[] = "🕺";
	inline constexpr const char man_dancing_tone1[] = "🕺🏻";
	inline constexpr const char male_dancer_tone1[] = "🕺🏻";
	inline constexpr const char man_dancing_tone2[] = "🕺🏼";
	inline constexpr const char male_dancer_tone2[] = "🕺🏼";
	inline constexpr const char man_dancing_tone3[] = "🕺🏽";
	inline constexpr const char male_dancer_tone3[] = "🕺🏽";
	inline constexpr const char man_dancing_tone5[] = "🕺🏿";
	inline constexpr const char male_dancer_tone5[] = "🕺🏿";
	inline constexpr const char man_dancing_tone4[] = "🕺🏾";
	inline constexpr const char male_dancer_tone4[] = "🕺🏾";
	inline constexpr const char people_with_bunny_ears_partying[] = "👯";
	inline constexpr const char dancers[] = "👯";
	inline constexpr const char women_with_bunny_ears_partying[] = "👯‍♀️";
	inline constexpr const char men_with_bunny_ears_partying[] = "👯‍♂️";
	inline constexpr const char levitate[] = "🕴️";
	inline constexpr const char man_in_business_suit_levitating[] = "🕴️";
	inline constexpr const char levitate_tone1[] = "🕴🏻";
	inline constexpr const char man_in_business_suit_levitating_tone1[] = "🕴🏻";
	inline constexpr const char man_in_business_suit_levitating_light_skin_tone[] = "🕴🏻";
	inline constexpr const char levitate_tone2[] = "🕴🏼";
	inline constexpr const char man_in_business_suit_levitating_tone2[] = "🕴🏼";
	inline constexpr const char man_in_business_suit_levitating_medium_light_skin_tone[] = "🕴🏼";
	inline constexpr const char levitate_tone3[] = "🕴🏽";
	inline constexpr const char man_in_business_suit_levitating_tone3[] = "🕴🏽";
	inline constexpr const char man_in_business_suit_levitating_medium_skin_tone[] = "🕴🏽";
	inline constexpr const char levitate_tone4[] = "🕴🏾";
	inline constexpr const char man_in_business_suit_levitating_tone4[] = "🕴🏾";
	inline constexpr const char man_in_business_suit_levitating_medium_dark_skin_tone[] = "🕴🏾";
	inline constexpr const char levitate_tone5[] = "🕴🏿";
	inline constexpr const char man_in_business_suit_levitating_tone5[] = "🕴🏿";
	inline constexpr const char man_in_business_suit_levitating_dark_skin_tone[] = "🕴🏿";
	inline constexpr const char person_in_manual_wheelchair[] = "🧑‍🦽";
	inline constexpr const char person_in_manual_wheelchair_tone1[] = "🧑🏻‍🦽";
	inline constexpr const char person_in_manual_wheelchair_light_skin_tone[] = "🧑🏻‍🦽";
	inline constexpr const char person_in_manual_wheelchair_tone2[] = "🧑🏼‍🦽";
	inline constexpr const char person_in_manual_wheelchair_medium_light_skin_tone[] = "🧑🏼‍🦽";
	inline constexpr const char person_in_manual_wheelchair_tone3[] = "🧑🏽‍🦽";
	inline constexpr const char person_in_manual_wheelchair_medium_skin_tone[] = "🧑🏽‍🦽";
	inline constexpr const char person_in_manual_wheelchair_tone4[] = "🧑🏾‍🦽";
	inline constexpr const char person_in_manual_wheelchair_medium_dark_skin_tone[] = "🧑🏾‍🦽";
	inline constexpr const char person_in_manual_wheelchair_tone5[] = "🧑🏿‍🦽";
	inline constexpr const char person_in_manual_wheelchair_dark_skin_tone[] = "🧑🏿‍🦽";
	inline constexpr const char woman_in_manual_wheelchair[] = "👩‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_tone1[] = "👩🏻‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_light_skin_tone[] = "👩🏻‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_tone2[] = "👩🏼‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_medium_light_skin_tone[] = "👩🏼‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_tone3[] = "👩🏽‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_medium_skin_tone[] = "👩🏽‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_tone4[] = "👩🏾‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_medium_dark_skin_tone[] = "👩🏾‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_tone5[] = "👩🏿‍🦽";
	inline constexpr const char woman_in_manual_wheelchair_dark_skin_tone[] = "👩🏿‍🦽";
	inline constexpr const char man_in_manual_wheelchair[] = "👨‍🦽";
	inline constexpr const char man_in_manual_wheelchair_tone1[] = "👨🏻‍🦽";
	inline constexpr const char man_in_manual_wheelchair_light_skin_tone[] = "👨🏻‍🦽";
	inline constexpr const char man_in_manual_wheelchair_tone2[] = "👨🏼‍🦽";
	inline constexpr const char man_in_manual_wheelchair_medium_light_skin_tone[] = "👨🏼‍🦽";
	inline constexpr const char man_in_manual_wheelchair_tone3[] = "👨🏽‍🦽";
	inline constexpr const char man_in_manual_wheelchair_medium_skin_tone[] = "👨🏽‍🦽";
	inline constexpr const char man_in_manual_wheelchair_tone4[] = "👨🏾‍🦽";
	inline constexpr const char man_in_manual_wheelchair_medium_dark_skin_tone[] = "👨🏾‍🦽";
	inline constexpr const char man_in_manual_wheelchair_tone5[] = "👨🏿‍🦽";
	inline constexpr const char man_in_manual_wheelchair_dark_skin_tone[] = "👨🏿‍🦽";
	inline constexpr const char person_in_motorized_wheelchair[] = "🧑‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_tone1[] = "🧑🏻‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_light_skin_tone[] = "🧑🏻‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_tone2[] = "🧑🏼‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_medium_light_skin_tone[] = "🧑🏼‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_tone3[] = "🧑🏽‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_medium_skin_tone[] = "🧑🏽‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_tone4[] = "🧑🏾‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_medium_dark_skin_tone[] = "🧑🏾‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_tone5[] = "🧑🏿‍🦼";
	inline constexpr const char person_in_motorized_wheelchair_dark_skin_tone[] = "🧑🏿‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair[] = "👩‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_tone1[] = "👩🏻‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_light_skin_tone[] = "👩🏻‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_tone2[] = "👩🏼‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_medium_light_skin_tone[] = "👩🏼‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_tone3[] = "👩🏽‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_medium_skin_tone[] = "👩🏽‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_tone4[] = "👩🏾‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_medium_dark_skin_tone[] = "👩🏾‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_tone5[] = "👩🏿‍🦼";
	inline constexpr const char woman_in_motorized_wheelchair_dark_skin_tone[] = "👩🏿‍🦼";
	inline constexpr const char man_in_motorized_wheelchair[] = "👨‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_tone1[] = "👨🏻‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_light_skin_tone[] = "👨🏻‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_tone2[] = "👨🏼‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_medium_light_skin_tone[] = "👨🏼‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_tone3[] = "👨🏽‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_medium_skin_tone[] = "👨🏽‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_tone4[] = "👨🏾‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_medium_dark_skin_tone[] = "👨🏾‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_tone5[] = "👨🏿‍🦼";
	inline constexpr const char man_in_motorized_wheelchair_dark_skin_tone[] = "👨🏿‍🦼";
	inline constexpr const char person_walking[] = "🚶";
	inline constexpr const char walking[] = "🚶";
	inline constexpr const char person_walking_tone1[] = "🚶🏻";
	inline constexpr const char walking_tone1[] = "🚶🏻";
	inline constexpr const char person_walking_tone2[] = "🚶🏼";
	inline constexpr const char walking_tone2[] = "🚶🏼";
	inline constexpr const char person_walking_tone3[] = "🚶🏽";
	inline constexpr const char walking_tone3[] = "🚶🏽";
	inline constexpr const char person_walking_tone4[] = "🚶🏾";
	inline constexpr const char walking_tone4[] = "🚶🏾";
	inline constexpr const char person_walking_tone5[] = "🚶🏿";
	inline constexpr const char walking_tone5[] = "🚶🏿";
	inline constexpr const char woman_walking[] = "🚶‍♀️";
	inline constexpr const char woman_walking_tone1[] = "🚶🏻‍♀️";
	inline constexpr const char woman_walking_light_skin_tone[] = "🚶🏻‍♀️";
	inline constexpr const char woman_walking_tone2[] = "🚶🏼‍♀️";
	inline constexpr const char woman_walking_medium_light_skin_tone[] = "🚶🏼‍♀️";
	inline constexpr const char woman_walking_tone3[] = "🚶🏽‍♀️";
	inline constexpr const char woman_walking_medium_skin_tone[] = "🚶🏽‍♀️";
	inline constexpr const char woman_walking_tone4[] = "🚶🏾‍♀️";
	inline constexpr const char woman_walking_medium_dark_skin_tone[] = "🚶🏾‍♀️";
	inline constexpr const char woman_walking_tone5[] = "🚶🏿‍♀️";
	inline constexpr const char woman_walking_dark_skin_tone[] = "🚶🏿‍♀️";
	inline constexpr const char man_walking[] = "🚶‍♂️";
	inline constexpr const char man_walking_tone1[] = "🚶🏻‍♂️";
	inline constexpr const char man_walking_light_skin_tone[] = "🚶🏻‍♂️";
	inline constexpr const char man_walking_tone2[] = "🚶🏼‍♂️";
	inline constexpr const char man_walking_medium_light_skin_tone[] = "🚶🏼‍♂️";
	inline constexpr const char man_walking_tone3[] = "🚶🏽‍♂️";
	inline constexpr const char man_walking_medium_skin_tone[] = "🚶🏽‍♂️";
	inline constexpr const char man_walking_tone4[] = "🚶🏾‍♂️";
	inline constexpr const char man_walking_medium_dark_skin_tone[] = "🚶🏾‍♂️";
	inline constexpr const char man_walking_tone5[] = "🚶🏿‍♂️";
	inline constexpr const char man_walking_dark_skin_tone[] = "🚶🏿‍♂️";
	inline constexpr const char person_with_probing_cane[] = "🧑‍🦯";
	inline constexpr const char person_with_probing_cane_tone1[] = "🧑🏻‍🦯";
	inline constexpr const char person_with_probing_cane_light_skin_tone[] = "🧑🏻‍🦯";
	inline constexpr const char person_with_probing_cane_tone2[] = "🧑🏼‍🦯";
	inline constexpr const char person_with_probing_cane_medium_light_skin_tone[] = "🧑🏼‍🦯";
	inline constexpr const char person_with_probing_cane_tone3[] = "🧑🏽‍🦯";
	inline constexpr const char person_with_probing_cane_medium_skin_tone[] = "🧑🏽‍🦯";
	inline constexpr const char person_with_probing_cane_tone4[] = "🧑🏾‍🦯";
	inline constexpr const char person_with_probing_cane_medium_dark_skin_tone[] = "🧑🏾‍🦯";
	inline constexpr const char person_with_probing_cane_tone5[] = "🧑🏿‍🦯";
	inline constexpr const char person_with_probing_cane_dark_skin_tone[] = "🧑🏿‍🦯";
	inline constexpr const char woman_with_probing_cane[] = "👩‍🦯";
	inline constexpr const char woman_with_probing_cane_tone1[] = "👩🏻‍🦯";
	inline constexpr const char woman_with_probing_cane_light_skin_tone[] = "👩🏻‍🦯";
	inline constexpr const char woman_with_probing_cane_tone2[] = "👩🏼‍🦯";
	inline constexpr const char woman_with_probing_cane_medium_light_skin_tone[] = "👩🏼‍🦯";
	inline constexpr const char woman_with_probing_cane_tone3[] = "👩🏽‍🦯";
	inline constexpr const char woman_with_probing_cane_medium_skin_tone[] = "👩🏽‍🦯";
	inline constexpr const char woman_with_probing_cane_tone4[] = "👩🏾‍🦯";
	inline constexpr const char woman_with_probing_cane_medium_dark_skin_tone[] = "👩🏾‍🦯";
	inline constexpr const char woman_with_probing_cane_tone5[] = "👩🏿‍🦯";
	inline constexpr const char woman_with_probing_cane_dark_skin_tone[] = "👩🏿‍🦯";
	inline constexpr const char man_with_probing_cane[] = "👨‍🦯";
	inline constexpr const char man_with_probing_cane_tone1[] = "👨🏻‍🦯";
	inline constexpr const char man_with_probing_cane_light_skin_tone[] = "👨🏻‍🦯";
	inline constexpr const char man_with_probing_cane_tone2[] = "👨🏼‍🦯";
	inline constexpr const char man_with_probing_cane_medium_light_skin_tone[] = "👨🏼‍🦯";
	inline constexpr const char man_with_probing_cane_tone3[] = "👨🏽‍🦯";
	inline constexpr const char man_with_probing_cane_medium_skin_tone[] = "👨🏽‍🦯";
	inline constexpr const char man_with_probing_cane_tone4[] = "👨🏾‍🦯";
	inline constexpr const char man_with_probing_cane_medium_dark_skin_tone[] = "👨🏾‍🦯";
	inline constexpr const char man_with_probing_cane_tone5[] = "👨🏿‍🦯";
	inline constexpr const char man_with_probing_cane_dark_skin_tone[] = "👨🏿‍🦯";
	inline constexpr const char person_kneeling[] = "🧎";
	inline constexpr const char person_kneeling_tone1[] = "🧎🏻";
	inline constexpr const char person_kneeling_light_skin_tone[] = "🧎🏻";
	inline constexpr const char person_kneeling_tone2[] = "🧎🏼";
	inline constexpr const char person_kneeling_medium_light_skin_tone[] = "🧎🏼";
	inline constexpr const char person_kneeling_tone3[] = "🧎🏽";
	inline constexpr const char person_kneeling_medium_skin_tone[] = "🧎🏽";
	inline constexpr const char person_kneeling_tone4[] = "🧎🏾";
	inline constexpr const char person_kneeling_medium_dark_skin_tone[] = "🧎🏾";
	inline constexpr const char person_kneeling_tone5[] = "🧎🏿";
	inline constexpr const char person_kneeling_dark_skin_tone[] = "🧎🏿";
	inline constexpr const char woman_kneeling[] = "🧎‍♀️";
	inline constexpr const char woman_kneeling_tone1[] = "🧎🏻‍♀️";
	inline constexpr const char woman_kneeling_light_skin_tone[] = "🧎🏻‍♀️";
	inline constexpr const char woman_kneeling_tone2[] = "🧎🏼‍♀️";
	inline constexpr const char woman_kneeling_medium_light_skin_tone[] = "🧎🏼‍♀️";
	inline constexpr const char woman_kneeling_tone3[] = "🧎🏽‍♀️";
	inline constexpr const char woman_kneeling_medium_skin_tone[] = "🧎🏽‍♀️";
	inline constexpr const char woman_kneeling_tone4[] = "🧎🏾‍♀️";
	inline constexpr const char woman_kneeling_medium_dark_skin_tone[] = "🧎🏾‍♀️";
	inline constexpr const char woman_kneeling_tone5[] = "🧎🏿‍♀️";
	inline constexpr const char woman_kneeling_dark_skin_tone[] = "🧎🏿‍♀️";
	inline constexpr const char man_kneeling[] = "🧎‍♂️";
	inline constexpr const char man_kneeling_tone1[] = "🧎🏻‍♂️";
	inline constexpr const char man_kneeling_light_skin_tone[] = "🧎🏻‍♂️";
	inline constexpr const char man_kneeling_tone2[] = "🧎🏼‍♂️";
	inline constexpr const char man_kneeling_medium_light_skin_tone[] = "🧎🏼‍♂️";
	inline constexpr const char man_kneeling_tone3[] = "🧎🏽‍♂️";
	inline constexpr const char man_kneeling_medium_skin_tone[] = "🧎🏽‍♂️";
	inline constexpr const char man_kneeling_tone4[] = "🧎🏾‍♂️";
	inline constexpr const char man_kneeling_medium_dark_skin_tone[] = "🧎🏾‍♂️";
	inline constexpr const char man_kneeling_tone5[] = "🧎🏿‍♂️";
	inline constexpr const char man_kneeling_dark_skin_tone[] = "🧎🏿‍♂️";
	inline constexpr const char person_running[] = "🏃";
	inline constexpr const char runner[] = "🏃";
	inline constexpr const char person_running_tone1[] = "🏃🏻";
	inline constexpr const char runner_tone1[] = "🏃🏻";
	inline constexpr const char person_running_tone2[] = "🏃🏼";
	inline constexpr const char runner_tone2[] = "🏃🏼";
	inline constexpr const char person_running_tone3[] = "🏃🏽";
	inline constexpr const char runner_tone3[] = "🏃🏽";
	inline constexpr const char person_running_tone4[] = "🏃🏾";
	inline constexpr const char runner_tone4[] = "🏃🏾";
	inline constexpr const char person_running_tone5[] = "🏃🏿";
	inline constexpr const char runner_tone5[] = "🏃🏿";
	inline constexpr const char woman_running[] = "🏃‍♀️";
	inline constexpr const char woman_running_tone1[] = "🏃🏻‍♀️";
	inline constexpr const char woman_running_light_skin_tone[] = "🏃🏻‍♀️";
	inline constexpr const char woman_running_tone2[] = "🏃🏼‍♀️";
	inline constexpr const char woman_running_medium_light_skin_tone[] = "🏃🏼‍♀️";
	inline constexpr const char woman_running_tone3[] = "🏃🏽‍♀️";
	inline constexpr const char woman_running_medium_skin_tone[] = "🏃🏽‍♀️";
	inline constexpr const char woman_running_tone4[] = "🏃🏾‍♀️";
	inline constexpr const char woman_running_medium_dark_skin_tone[] = "🏃🏾‍♀️";
	inline constexpr const char woman_running_tone5[] = "🏃🏿‍♀️";
	inline constexpr const char woman_running_dark_skin_tone[] = "🏃🏿‍♀️";
	inline constexpr const char man_running[] = "🏃‍♂️";
	inline constexpr const char man_running_tone1[] = "🏃🏻‍♂️";
	inline constexpr const char man_running_light_skin_tone[] = "🏃🏻‍♂️";
	inline constexpr const char man_running_tone2[] = "🏃🏼‍♂️";
	inline constexpr const char man_running_medium_light_skin_tone[] = "🏃🏼‍♂️";
	inline constexpr const char man_running_tone3[] = "🏃🏽‍♂️";
	inline constexpr const char man_running_medium_skin_tone[] = "🏃🏽‍♂️";
	inline constexpr const char man_running_tone4[] = "🏃🏾‍♂️";
	inline constexpr const char man_running_medium_dark_skin_tone[] = "🏃🏾‍♂️";
	inline constexpr const char man_running_tone5[] = "🏃🏿‍♂️";
	inline constexpr const char man_running_dark_skin_tone[] = "🏃🏿‍♂️";
	inline constexpr const char person_standing[] = "🧍";
	inline constexpr const char person_standing_tone1[] = "🧍🏻";
	inline constexpr const char person_standing_light_skin_tone[] = "🧍🏻";
	inline constexpr const char person_standing_tone2[] = "🧍🏼";
	inline constexpr const char person_standing_medium_light_skin_tone[] = "🧍🏼";
	inline constexpr const char person_standing_tone3[] = "🧍🏽";
	inline constexpr const char person_standing_medium_skin_tone[] = "🧍🏽";
	inline constexpr const char person_standing_tone4[] = "🧍🏾";
	inline constexpr const char person_standing_medium_dark_skin_tone[] = "🧍🏾";
	inline constexpr const char person_standing_tone5[] = "🧍🏿";
	inline constexpr const char person_standing_dark_skin_tone[] = "🧍🏿";
	inline constexpr const char woman_standing[] = "🧍‍♀️";
	inline constexpr const char woman_standing_tone1[] = "🧍🏻‍♀️";
	inline constexpr const char woman_standing_light_skin_tone[] = "🧍🏻‍♀️";
	inline constexpr const char woman_standing_tone2[] = "🧍🏼‍♀️";
	inline constexpr const char woman_standing_medium_light_skin_tone[] = "🧍🏼‍♀️";
	inline constexpr const char woman_standing_tone3[] = "🧍🏽‍♀️";
	inline constexpr const char woman_standing_medium_skin_tone[] = "🧍🏽‍♀️";
	inline constexpr const char woman_standing_tone4[] = "🧍🏾‍♀️";
	inline constexpr const char woman_standing_medium_dark_skin_tone[] = "🧍🏾‍♀️";
	inline constexpr const char woman_standing_tone5[] = "🧍🏿‍♀️";
	inline constexpr const char woman_standing_dark_skin_tone[] = "🧍🏿‍♀️";
	inline constexpr const char man_standing[] = "🧍‍♂️";
	inline constexpr const char man_standing_tone1[] = "🧍🏻‍♂️";
	inline constexpr const char man_standing_light_skin_tone[] = "🧍🏻‍♂️";
	inline constexpr const char man_standing_tone2[] = "🧍🏼‍♂️";
	inline constexpr const char man_standing_medium_light_skin_tone[] = "🧍🏼‍♂️";
	inline constexpr const char man_standing_tone3[] = "🧍🏽‍♂️";
	inline constexpr const char man_standing_medium_skin_tone[] = "🧍🏽‍♂️";
	inline constexpr const char man_standing_tone4[] = "🧍🏾‍♂️";
	inline constexpr const char man_standing_medium_dark_skin_tone[] = "🧍🏾‍♂️";
	inline constexpr const char man_standing_tone5[] = "🧍🏿‍♂️";
	inline constexpr const char man_standing_dark_skin_tone[] = "🧍🏿‍♂️";
	inline constexpr const char people_holding_hands[] = "🧑‍🤝‍🧑";
	inline constexpr const char people_holding_hands_tone1[] = "🧑🏻‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_light_skin_tone[] = "🧑🏻‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_tone1_tone2[] = "🧑🏻‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_light_skin_tone_medium_light_skin_tone[] = "🧑🏻‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_tone1_tone3[] = "🧑🏻‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_light_skin_tone_medium_skin_tone[] = "🧑🏻‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_tone1_tone4[] = "🧑🏻‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_light_skin_tone_medium_dark_skin_tone[] = "🧑🏻‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_tone1_tone5[] = "🧑🏻‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_light_skin_tone_dark_skin_tone[] = "🧑🏻‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_tone2_tone1[] = "🧑🏼‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_medium_light_skin_tone_light_skin_tone[] = "🧑🏼‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_tone2[] = "🧑🏼‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_medium_light_skin_tone[] = "🧑🏼‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_tone2_tone3[] = "🧑🏼‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_medium_light_skin_tone_medium_skin_tone[] = "🧑🏼‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_tone2_tone4[] = "🧑🏼‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_medium_light_skin_tone_medium_dark_skin_tone[] = "🧑🏼‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_tone2_tone5[] = "🧑🏼‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_medium_light_skin_tone_dark_skin_tone[] = "🧑🏼‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_tone3_tone1[] = "🧑🏽‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_medium_skin_tone_light_skin_tone[] = "🧑🏽‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_tone3_tone2[] = "🧑🏽‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_medium_skin_tone_medium_light_skin_tone[] = "🧑🏽‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_tone3[] = "🧑🏽‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_medium_skin_tone[] = "🧑🏽‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_tone3_tone4[] = "🧑🏽‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_medium_skin_tone_medium_dark_skin_tone[] = "🧑🏽‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_tone3_tone5[] = "🧑🏽‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_medium_skin_tone_dark_skin_tone[] = "🧑🏽‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_tone4_tone1[] = "🧑🏾‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_medium_dark_skin_tone_light_skin_tone[] = "🧑🏾‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_tone4_tone2[] = "🧑🏾‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_medium_dark_skin_tone_medium_light_skin_tone[] = "🧑🏾‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_tone4_tone3[] = "🧑🏾‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_medium_dark_skin_tone_medium_skin_tone[] = "🧑🏾‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_tone4[] = "🧑🏾‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_medium_dark_skin_tone[] = "🧑🏾‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_tone4_tone5[] = "🧑🏾‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_medium_dark_skin_tone_dark_skin_tone[] = "🧑🏾‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_tone5_tone1[] = "🧑🏿‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_dark_skin_tone_light_skin_tone[] = "🧑🏿‍🤝‍🧑🏻";
	inline constexpr const char people_holding_hands_tone5_tone2[] = "🧑🏿‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_dark_skin_tone_medium_light_skin_tone[] = "🧑🏿‍🤝‍🧑🏼";
	inline constexpr const char people_holding_hands_tone5_tone3[] = "🧑🏿‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_dark_skin_tone_medium_skin_tone[] = "🧑🏿‍🤝‍🧑🏽";
	inline constexpr const char people_holding_hands_tone5_tone4[] = "🧑🏿‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_dark_skin_tone_medium_dark_skin_tone[] = "🧑🏿‍🤝‍🧑🏾";
	inline constexpr const char people_holding_hands_tone5[] = "🧑🏿‍🤝‍🧑🏿";
	inline constexpr const char people_holding_hands_dark_skin_tone[] = "🧑🏿‍🤝‍🧑🏿";
	inline constexpr const char couple[] = "👫";
	inline constexpr const char woman_and_man_holding_hands_tone1[] = "👫🏻";
	inline constexpr const char woman_and_man_holding_hands_light_skin_tone[] = "👫🏻";
	inline constexpr const char woman_and_man_holding_hands_tone1_tone2[] = "👩🏻‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_light_skin_tone_medium_light_skin_tone[] = "👩🏻‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_tone1_tone3[] = "👩🏻‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_light_skin_tone_medium_skin_tone[] = "👩🏻‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_tone1_tone4[] = "👩🏻‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_light_skin_tone_medium_dark_skin_tone[] = "👩🏻‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_tone1_tone5[] = "👩🏻‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_light_skin_tone_dark_skin_tone[] = "👩🏻‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_tone2_tone1[] = "👩🏼‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_medium_light_skin_tone_light_skin_tone[] = "👩🏼‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_tone2[] = "👫🏼";
	inline constexpr const char woman_and_man_holding_hands_medium_light_skin_tone[] = "👫🏼";
	inline constexpr const char woman_and_man_holding_hands_tone2_tone3[] = "👩🏼‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_medium_light_skin_tone_medium_skin_tone[] = "👩🏼‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_tone2_tone4[] = "👩🏼‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_medium_light_skin_tone_medium_dark_skin_tone[] = "👩🏼‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_tone2_tone5[] = "👩🏼‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_medium_light_skin_tone_dark_skin_tone[] = "👩🏼‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_tone3_tone1[] = "👩🏽‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_medium_skin_tone_light_skin_tone[] = "👩🏽‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_tone3_tone2[] = "👩🏽‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_medium_skin_tone_medium_light_skin_tone[] = "👩🏽‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_tone3[] = "👫🏽";
	inline constexpr const char woman_and_man_holding_hands_medium_skin_tone[] = "👫🏽";
	inline constexpr const char woman_and_man_holding_hands_tone3_tone4[] = "👩🏽‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_medium_skin_tone_medium_dark_skin_tone[] = "👩🏽‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_tone3_tone5[] = "👩🏽‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_medium_skin_tone_dark_skin_tone[] = "👩🏽‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_tone4_tone1[] = "👩🏾‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_medium_dark_skin_tone_light_skin_tone[] = "👩🏾‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_tone4_tone2[] = "👩🏾‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_medium_dark_skin_tone_medium_light_skin_tone[] = "👩🏾‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_tone4_tone3[] = "👩🏾‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_medium_dark_skin_tone_medium_skin_tone[] = "👩🏾‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_tone4[] = "👫🏾";
	inline constexpr const char woman_and_man_holding_hands_medium_dark_skin_tone[] = "👫🏾";
	inline constexpr const char woman_and_man_holding_hands_tone4_tone5[] = "👩🏾‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_medium_dark_skin_tone_dark_skin_tone[] = "👩🏾‍🤝‍👨🏿";
	inline constexpr const char woman_and_man_holding_hands_tone5_tone1[] = "👩🏿‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_dark_skin_tone_light_skin_tone[] = "👩🏿‍🤝‍👨🏻";
	inline constexpr const char woman_and_man_holding_hands_tone5_tone2[] = "👩🏿‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_dark_skin_tone_medium_light_skin_tone[] = "👩🏿‍🤝‍👨🏼";
	inline constexpr const char woman_and_man_holding_hands_tone5_tone3[] = "👩🏿‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_dark_skin_tone_medium_skin_tone[] = "👩🏿‍🤝‍👨🏽";
	inline constexpr const char woman_and_man_holding_hands_tone5_tone4[] = "👩🏿‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_dark_skin_tone_medium_dark_skin_tone[] = "👩🏿‍🤝‍👨🏾";
	inline constexpr const char woman_and_man_holding_hands_tone5[] = "👫🏿";
	inline constexpr const char woman_and_man_holding_hands_dark_skin_tone[] = "👫🏿";
	inline constexpr const char two_women_holding_hands[] = "👭";
	inline constexpr const char women_holding_hands_tone1[] = "👭🏻";
	inline constexpr const char women_holding_hands_light_skin_tone[] = "👭🏻";
	inline constexpr const char women_holding_hands_tone1_tone2[] = "👩🏻‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_light_skin_tone_medium_light_skin_tone[] = "👩🏻‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_tone1_tone3[] = "👩🏻‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_light_skin_tone_medium_skin_tone[] = "👩🏻‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_tone1_tone4[] = "👩🏻‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_light_skin_tone_medium_dark_skin_tone[] = "👩🏻‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_tone1_tone5[] = "👩🏻‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_light_skin_tone_dark_skin_tone[] = "👩🏻‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_tone2_tone1[] = "👩🏼‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_medium_light_skin_tone_light_skin_tone[] = "👩🏼‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_tone2[] = "👭🏼";
	inline constexpr const char women_holding_hands_medium_light_skin_tone[] = "👭🏼";
	inline constexpr const char women_holding_hands_tone2_tone3[] = "👩🏼‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_medium_light_skin_tone_medium_skin_tone[] = "👩🏼‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_tone2_tone4[] = "👩🏼‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_medium_light_skin_tone_medium_dark_skin_tone[] = "👩🏼‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_tone2_tone5[] = "👩🏼‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_medium_light_skin_tone_dark_skin_tone[] = "👩🏼‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_tone3_tone1[] = "👩🏽‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_medium_skin_tone_light_skin_tone[] = "👩🏽‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_tone3_tone2[] = "👩🏽‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_medium_skin_tone_medium_light_skin_tone[] = "👩🏽‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_tone3[] = "👭🏽";
	inline constexpr const char women_holding_hands_medium_skin_tone[] = "👭🏽";
	inline constexpr const char women_holding_hands_tone3_tone4[] = "👩🏽‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_medium_skin_tone_medium_dark_skin_tone[] = "👩🏽‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_tone3_tone5[] = "👩🏽‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_medium_skin_tone_dark_skin_tone[] = "👩🏽‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_tone4_tone1[] = "👩🏾‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_medium_dark_skin_tone_light_skin_tone[] = "👩🏾‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_tone4_tone2[] = "👩🏾‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_medium_dark_skin_tone_medium_light_skin_tone[] = "👩🏾‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_tone4_tone3[] = "👩🏾‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_medium_dark_skin_tone_medium_skin_tone[] = "👩🏾‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_tone4[] = "👭🏾";
	inline constexpr const char women_holding_hands_medium_dark_skin_tone[] = "👭🏾";
	inline constexpr const char women_holding_hands_tone4_tone5[] = "👩🏾‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_medium_dark_skin_tone_dark_skin_tone[] = "👩🏾‍🤝‍👩🏿";
	inline constexpr const char women_holding_hands_tone5_tone1[] = "👩🏿‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_dark_skin_tone_light_skin_tone[] = "👩🏿‍🤝‍👩🏻";
	inline constexpr const char women_holding_hands_tone5_tone2[] = "👩🏿‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_dark_skin_tone_medium_light_skin_tone[] = "👩🏿‍🤝‍👩🏼";
	inline constexpr const char women_holding_hands_tone5_tone3[] = "👩🏿‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_dark_skin_tone_medium_skin_tone[] = "👩🏿‍🤝‍👩🏽";
	inline constexpr const char women_holding_hands_tone5_tone4[] = "👩🏿‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_dark_skin_tone_medium_dark_skin_tone[] = "👩🏿‍🤝‍👩🏾";
	inline constexpr const char women_holding_hands_tone5[] = "👭🏿";
	inline constexpr const char women_holding_hands_dark_skin_tone[] = "👭🏿";
	inline constexpr const char two_men_holding_hands[] = "👬";
	inline constexpr const char men_holding_hands_tone1[] = "👬🏻";
	inline constexpr const char men_holding_hands_light_skin_tone[] = "👬🏻";
	inline constexpr const char men_holding_hands_tone1_tone2[] = "👨🏻‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_light_skin_tone_medium_light_skin_tone[] = "👨🏻‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_tone1_tone3[] = "👨🏻‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_light_skin_tone_medium_skin_tone[] = "👨🏻‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_tone1_tone4[] = "👨🏻‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_light_skin_tone_medium_dark_skin_tone[] = "👨🏻‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_tone1_tone5[] = "👨🏻‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_light_skin_tone_dark_skin_tone[] = "👨🏻‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_tone2_tone1[] = "👨🏼‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_medium_light_skin_tone_light_skin_tone[] = "👨🏼‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_tone2[] = "👬🏼";
	inline constexpr const char men_holding_hands_medium_light_skin_tone[] = "👬🏼";
	inline constexpr const char men_holding_hands_tone2_tone3[] = "👨🏼‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_medium_light_skin_tone_medium_skin_tone[] = "👨🏼‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_tone2_tone4[] = "👨🏼‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_medium_light_skin_tone_medium_dark_skin_tone[] = "👨🏼‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_tone2_tone5[] = "👨🏼‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_medium_light_skin_tone_dark_skin_tone[] = "👨🏼‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_tone3_tone1[] = "👨🏽‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_medium_skin_tone_light_skin_tone[] = "👨🏽‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_tone3_tone2[] = "👨🏽‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_medium_skin_tone_medium_light_skin_tone[] = "👨🏽‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_tone3[] = "👬🏽";
	inline constexpr const char men_holding_hands_medium_skin_tone[] = "👬🏽";
	inline constexpr const char men_holding_hands_tone3_tone4[] = "👨🏽‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_medium_skin_tone_medium_dark_skin_tone[] = "👨🏽‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_tone3_tone5[] = "👨🏽‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_medium_skin_tone_dark_skin_tone[] = "👨🏽‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_tone4_tone1[] = "👨🏾‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_medium_dark_skin_tone_light_skin_tone[] = "👨🏾‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_tone4_tone2[] = "👨🏾‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_medium_dark_skin_tone_medium_light_skin_tone[] = "👨🏾‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_tone4_tone3[] = "👨🏾‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_medium_dark_skin_tone_medium_skin_tone[] = "👨🏾‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_tone4[] = "👬🏾";
	inline constexpr const char men_holding_hands_medium_dark_skin_tone[] = "👬🏾";
	inline constexpr const char men_holding_hands_tone4_tone5[] = "👨🏾‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_medium_dark_skin_tone_dark_skin_tone[] = "👨🏾‍🤝‍👨🏿";
	inline constexpr const char men_holding_hands_tone5_tone1[] = "👨🏿‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_dark_skin_tone_light_skin_tone[] = "👨🏿‍🤝‍👨🏻";
	inline constexpr const char men_holding_hands_tone5_tone2[] = "👨🏿‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_dark_skin_tone_medium_light_skin_tone[] = "👨🏿‍🤝‍👨🏼";
	inline constexpr const char men_holding_hands_tone5_tone3[] = "👨🏿‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_dark_skin_tone_medium_skin_tone[] = "👨🏿‍🤝‍👨🏽";
	inline constexpr const char men_holding_hands_tone5_tone4[] = "👨🏿‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_dark_skin_tone_medium_dark_skin_tone[] = "👨🏿‍🤝‍👨🏾";
	inline constexpr const char men_holding_hands_tone5[] = "👬🏿";
	inline constexpr const char men_holding_hands_dark_skin_tone[] = "👬🏿";
	inline constexpr const char couple_with_heart[] = "💑";
	inline constexpr const char couple_with_heart_tone1[] = "💑🏻";
	inline constexpr const char couple_with_heart_light_skin_tone[] = "💑🏻";
	inline constexpr const char couple_with_heart_person_person_tone1_tone2[] = "🧑🏻‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_light_skin_tone_medium_light_skin_tone[] = "🧑🏻‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_tone1_tone3[] = "🧑🏻‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_light_skin_tone_medium_skin_tone[] = "🧑🏻‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_tone1_tone4[] = "🧑🏻‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_light_skin_tone_medium_dark_skin_tone[] = "🧑🏻‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_tone1_tone5[] = "🧑🏻‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_light_skin_tone_dark_skin_tone[] = "🧑🏻‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_tone2_tone1[] = "🧑🏼‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_medium_light_skin_tone_light_skin_tone[] = "🧑🏼‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_tone2[] = "💑🏼";
	inline constexpr const char couple_with_heart_medium_light_skin_tone[] = "💑🏼";
	inline constexpr const char couple_with_heart_person_person_tone2_tone3[] = "🧑🏼‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_medium_light_skin_tone_medium_skin_tone[] = "🧑🏼‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_tone2_tone4[] = "🧑🏼‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_medium_light_skin_tone_medium_dark_skin_tone[] = "🧑🏼‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_tone2_tone5[] = "🧑🏼‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_medium_light_skin_tone_dark_skin_tone[] = "🧑🏼‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_tone3_tone1[] = "🧑🏽‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_medium_skin_tone_light_skin_tone[] = "🧑🏽‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_tone3_tone2[] = "🧑🏽‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_medium_skin_tone_medium_light_skin_tone[] = "🧑🏽‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_tone3[] = "💑🏽";
	inline constexpr const char couple_with_heart_medium_skin_tone[] = "💑🏽";
	inline constexpr const char couple_with_heart_person_person_tone3_tone4[] = "🧑🏽‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_medium_skin_tone_medium_dark_skin_tone[] = "🧑🏽‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_tone3_tone5[] = "🧑🏽‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_medium_skin_tone_dark_skin_tone[] = "🧑🏽‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_tone4_tone1[] = "🧑🏾‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_medium_dark_skin_tone_light_skin_tone[] = "🧑🏾‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_tone4_tone2[] = "🧑🏾‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_medium_dark_skin_tone_medium_light_skin_tone[] = "🧑🏾‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_tone4_tone3[] = "🧑🏾‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_medium_dark_skin_tone_medium_skin_tone[] = "🧑🏾‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_tone4[] = "💑🏾";
	inline constexpr const char couple_with_heart_medium_dark_skin_tone[] = "💑🏾";
	inline constexpr const char couple_with_heart_person_person_tone4_tone5[] = "🧑🏾‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_medium_dark_skin_tone_dark_skin_tone[] = "🧑🏾‍❤️‍🧑🏿";
	inline constexpr const char couple_with_heart_person_person_tone5_tone1[] = "🧑🏿‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_dark_skin_tone_light_skin_tone[] = "🧑🏿‍❤️‍🧑🏻";
	inline constexpr const char couple_with_heart_person_person_tone5_tone2[] = "🧑🏿‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_dark_skin_tone_medium_light_skin_tone[] = "🧑🏿‍❤️‍🧑🏼";
	inline constexpr const char couple_with_heart_person_person_tone5_tone3[] = "🧑🏿‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_dark_skin_tone_medium_skin_tone[] = "🧑🏿‍❤️‍🧑🏽";
	inline constexpr const char couple_with_heart_person_person_tone5_tone4[] = "🧑🏿‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_person_person_dark_skin_tone_medium_dark_skin_tone[] = "🧑🏿‍❤️‍🧑🏾";
	inline constexpr const char couple_with_heart_tone5[] = "💑🏿";
	inline constexpr const char couple_with_heart_dark_skin_tone[] = "💑🏿";
	inline constexpr const char couple_with_heart_woman_man[] = "👩‍❤️‍👨";
	inline constexpr const char couple_with_heart_woman_man_tone1[] = "👩🏻‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_light_skin_tone[] = "👩🏻‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_tone1_tone2[] = "👩🏻‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_light_skin_tone_medium_light_skin_tone[] = "👩🏻‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_tone1_tone3[] = "👩🏻‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_light_skin_tone_medium_skin_tone[] = "👩🏻‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_tone1_tone4[] = "👩🏻‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_light_skin_tone_medium_dark_skin_tone[] = "👩🏻‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_tone1_tone5[] = "👩🏻‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_light_skin_tone_dark_skin_tone[] = "👩🏻‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_tone2_tone1[] = "👩🏼‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_medium_light_skin_tone_light_skin_tone[] = "👩🏼‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_tone2[] = "👩🏼‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_medium_light_skin_tone[] = "👩🏼‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_tone2_tone3[] = "👩🏼‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_medium_light_skin_tone_medium_skin_tone[] = "👩🏼‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_tone2_tone4[] = "👩🏼‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_medium_light_skin_tone_medium_dark_skin_tone[] = "👩🏼‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_tone2_tone5[] = "👩🏼‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_medium_light_skin_tone_dark_skin_tone[] = "👩🏼‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_tone3_tone1[] = "👩🏽‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_medium_skin_tone_light_skin_tone[] = "👩🏽‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_tone3_tone2[] = "👩🏽‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_medium_skin_tone_medium_light_skin_tone[] = "👩🏽‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_tone3[] = "👩🏽‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_medium_skin_tone[] = "👩🏽‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_tone3_tone4[] = "👩🏽‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_medium_skin_tone_medium_dark_skin_tone[] = "👩🏽‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_tone3_tone5[] = "👩🏽‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_medium_skin_tone_dark_skin_tone[] = "👩🏽‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_tone4_tone1[] = "👩🏾‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_medium_dark_skin_tone_light_skin_tone[] = "👩🏾‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_tone4_tone2[] = "👩🏾‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_medium_dark_skin_tone_medium_light_skin_tone[] = "👩🏾‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_tone4_tone3[] = "👩🏾‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_medium_dark_skin_tone_medium_skin_tone[] = "👩🏾‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_tone4[] = "👩🏾‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_medium_dark_skin_tone[] = "👩🏾‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_tone4_tone5[] = "👩🏾‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_medium_dark_skin_tone_dark_skin_tone[] = "👩🏾‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_tone5_tone1[] = "👩🏿‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_dark_skin_tone_light_skin_tone[] = "👩🏿‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_woman_man_tone5_tone2[] = "👩🏿‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_dark_skin_tone_medium_light_skin_tone[] = "👩🏿‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_woman_man_tone5_tone3[] = "👩🏿‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_dark_skin_tone_medium_skin_tone[] = "👩🏿‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_woman_man_tone5_tone4[] = "👩🏿‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_dark_skin_tone_medium_dark_skin_tone[] = "👩🏿‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_woman_man_tone5[] = "👩🏿‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_woman_man_dark_skin_tone[] = "👩🏿‍❤️‍👨🏿";
	inline constexpr const char couple_ww[] = "👩‍❤️‍👩";
	inline constexpr const char couple_with_heart_ww[] = "👩‍❤️‍👩";
	inline constexpr const char couple_with_heart_woman_woman_tone1[] = "👩🏻‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_light_skin_tone[] = "👩🏻‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_tone1_tone2[] = "👩🏻‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_light_skin_tone_medium_light_skin_tone[] = "👩🏻‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_tone1_tone3[] = "👩🏻‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_light_skin_tone_medium_skin_tone[] = "👩🏻‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_tone1_tone4[] = "👩🏻‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_light_skin_tone_medium_dark_skin_tone[] = "👩🏻‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_tone1_tone5[] = "👩🏻‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_light_skin_tone_dark_skin_tone[] = "👩🏻‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_tone2_tone1[] = "👩🏼‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_medium_light_skin_tone_light_skin_tone[] = "👩🏼‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_tone2[] = "👩🏼‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_medium_light_skin_tone[] = "👩🏼‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_tone2_tone3[] = "👩🏼‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_medium_light_skin_tone_medium_skin_tone[] = "👩🏼‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_tone2_tone4[] = "👩🏼‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_medium_light_skin_tone_medium_dark_skin_tone[] = "👩🏼‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_tone2_tone5[] = "👩🏼‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_medium_light_skin_tone_dark_skin_tone[] = "👩🏼‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_tone3_tone1[] = "👩🏽‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_medium_skin_tone_light_skin_tone[] = "👩🏽‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_tone3_tone2[] = "👩🏽‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_medium_skin_tone_medium_light_skin_tone[] = "👩🏽‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_tone3[] = "👩🏽‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_medium_skin_tone[] = "👩🏽‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_tone3_tone4[] = "👩🏽‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_medium_skin_tone_medium_dark_skin_tone[] = "👩🏽‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_tone3_tone5[] = "👩🏽‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_medium_skin_tone_dark_skin_tone[] = "👩🏽‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_tone4_tone1[] = "👩🏾‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_medium_dark_skin_tone_light_skin_tone[] = "👩🏾‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_tone4_tone2[] = "👩🏾‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_medium_dark_skin_tone_medium_light_skin_tone[] = "👩🏾‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_tone4_tone3[] = "👩🏾‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_medium_dark_skin_tone_medium_skin_tone[] = "👩🏾‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_tone4[] = "👩🏾‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_medium_dark_skin_tone[] = "👩🏾‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_tone4_tone5[] = "👩🏾‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_medium_dark_skin_tone_dark_skin_tone[] = "👩🏾‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_tone5_tone1[] = "👩🏿‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_dark_skin_tone_light_skin_tone[] = "👩🏿‍❤️‍👩🏻";
	inline constexpr const char couple_with_heart_woman_woman_tone5_tone2[] = "👩🏿‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_dark_skin_tone_medium_light_skin_tone[] = "👩🏿‍❤️‍👩🏼";
	inline constexpr const char couple_with_heart_woman_woman_tone5_tone3[] = "👩🏿‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_dark_skin_tone_medium_skin_tone[] = "👩🏿‍❤️‍👩🏽";
	inline constexpr const char couple_with_heart_woman_woman_tone5_tone4[] = "👩🏿‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_dark_skin_tone_medium_dark_skin_tone[] = "👩🏿‍❤️‍👩🏾";
	inline constexpr const char couple_with_heart_woman_woman_tone5[] = "👩🏿‍❤️‍👩🏿";
	inline constexpr const char couple_with_heart_woman_woman_dark_skin_tone[] = "👩🏿‍❤️‍👩🏿";
	inline constexpr const char couple_mm[] = "👨‍❤️‍👨";
	inline constexpr const char couple_with_heart_mm[] = "👨‍❤️‍👨";
	inline constexpr const char couple_with_heart_man_man_tone1[] = "👨🏻‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_light_skin_tone[] = "👨🏻‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_tone1_tone2[] = "👨🏻‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_light_skin_tone_medium_light_skin_tone[] = "👨🏻‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_tone1_tone3[] = "👨🏻‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_light_skin_tone_medium_skin_tone[] = "👨🏻‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_tone1_tone4[] = "👨🏻‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_light_skin_tone_medium_dark_skin_tone[] = "👨🏻‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_tone1_tone5[] = "👨🏻‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_light_skin_tone_dark_skin_tone[] = "👨🏻‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_tone2_tone1[] = "👨🏼‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_medium_light_skin_tone_light_skin_tone[] = "👨🏼‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_tone2[] = "👨🏼‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_medium_light_skin_tone[] = "👨🏼‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_tone2_tone3[] = "👨🏼‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_medium_light_skin_tone_medium_skin_tone[] = "👨🏼‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_tone2_tone4[] = "👨🏼‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_medium_light_skin_tone_medium_dark_skin_tone[] = "👨🏼‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_tone2_tone5[] = "👨🏼‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_medium_light_skin_tone_dark_skin_tone[] = "👨🏼‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_tone3_tone1[] = "👨🏽‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_medium_skin_tone_light_skin_tone[] = "👨🏽‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_tone3_tone2[] = "👨🏽‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_medium_skin_tone_medium_light_skin_tone[] = "👨🏽‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_tone3[] = "👨🏽‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_medium_skin_tone[] = "👨🏽‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_tone3_tone4[] = "👨🏽‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_medium_skin_tone_medium_dark_skin_tone[] = "👨🏽‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_tone3_tone5[] = "👨🏽‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_medium_skin_tone_dark_skin_tone[] = "👨🏽‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_tone4_tone1[] = "👨🏾‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_medium_dark_skin_tone_light_skin_tone[] = "👨🏾‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_tone4_tone2[] = "👨🏾‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_medium_dark_skin_tone_medium_light_skin_tone[] = "👨🏾‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_tone4_tone3[] = "👨🏾‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_medium_dark_skin_tone_medium_skin_tone[] = "👨🏾‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_tone4[] = "👨🏾‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_medium_dark_skin_tone[] = "👨🏾‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_tone4_tone5[] = "👨🏾‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_medium_dark_skin_tone_dark_skin_tone[] = "👨🏾‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_tone5_tone1[] = "👨🏿‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_dark_skin_tone_light_skin_tone[] = "👨🏿‍❤️‍👨🏻";
	inline constexpr const char couple_with_heart_man_man_tone5_tone2[] = "👨🏿‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_dark_skin_tone_medium_light_skin_tone[] = "👨🏿‍❤️‍👨🏼";
	inline constexpr const char couple_with_heart_man_man_tone5_tone3[] = "👨🏿‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_dark_skin_tone_medium_skin_tone[] = "👨🏿‍❤️‍👨🏽";
	inline constexpr const char couple_with_heart_man_man_tone5_tone4[] = "👨🏿‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_dark_skin_tone_medium_dark_skin_tone[] = "👨🏿‍❤️‍👨🏾";
	inline constexpr const char couple_with_heart_man_man_tone5[] = "👨🏿‍❤️‍👨🏿";
	inline constexpr const char couple_with_heart_man_man_dark_skin_tone[] = "👨🏿‍❤️‍👨🏿";
	inline constexpr const char couplekiss[] = "💏";
	inline constexpr const char kiss_tone1[] = "💏🏻";
	inline constexpr const char kiss_light_skin_tone[] = "💏🏻";
	inline constexpr const char kiss_person_person_tone1_tone2[] = "🧑🏻‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_light_skin_tone_medium_light_skin_tone[] = "🧑🏻‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_tone1_tone3[] = "🧑🏻‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_light_skin_tone_medium_skin_tone[] = "🧑🏻‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_tone1_tone4[] = "🧑🏻‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_light_skin_tone_medium_dark_skin_tone[] = "🧑🏻‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_tone1_tone5[] = "🧑🏻‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_light_skin_tone_dark_skin_tone[] = "🧑🏻‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_tone2_tone1[] = "🧑🏼‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_medium_light_skin_tone_light_skin_tone[] = "🧑🏼‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_tone2[] = "💏🏼";
	inline constexpr const char kiss_medium_light_skin_tone[] = "💏🏼";
	inline constexpr const char kiss_person_person_tone2_tone3[] = "🧑🏼‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_medium_light_skin_tone_medium_skin_tone[] = "🧑🏼‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_tone2_tone4[] = "🧑🏼‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_medium_light_skin_tone_medium_dark_skin_tone[] = "🧑🏼‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_tone2_tone5[] = "🧑🏼‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_medium_light_skin_tone_dark_skin_tone[] = "🧑🏼‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_tone3_tone1[] = "🧑🏽‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_medium_skin_tone_light_skin_tone[] = "🧑🏽‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_tone3_tone2[] = "🧑🏽‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_medium_skin_tone_medium_light_skin_tone[] = "🧑🏽‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_tone3[] = "💏🏽";
	inline constexpr const char kiss_medium_skin_tone[] = "💏🏽";
	inline constexpr const char kiss_person_person_tone3_tone4[] = "🧑🏽‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_medium_skin_tone_medium_dark_skin_tone[] = "🧑🏽‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_tone3_tone5[] = "🧑🏽‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_medium_skin_tone_dark_skin_tone[] = "🧑🏽‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_tone4_tone1[] = "🧑🏾‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_medium_dark_skin_tone_light_skin_tone[] = "🧑🏾‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_tone4_tone2[] = "🧑🏾‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_medium_dark_skin_tone_medium_light_skin_tone[] = "🧑🏾‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_tone4_tone3[] = "🧑🏾‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_medium_dark_skin_tone_medium_skin_tone[] = "🧑🏾‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_tone4[] = "💏🏾";
	inline constexpr const char kiss_medium_dark_skin_tone[] = "💏🏾";
	inline constexpr const char kiss_person_person_tone4_tone5[] = "🧑🏾‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_medium_dark_skin_tone_dark_skin_tone[] = "🧑🏾‍❤️‍💋‍🧑🏿";
	inline constexpr const char kiss_person_person_tone5_tone1[] = "🧑🏿‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_dark_skin_tone_light_skin_tone[] = "🧑🏿‍❤️‍💋‍🧑🏻";
	inline constexpr const char kiss_person_person_tone5_tone2[] = "🧑🏿‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_dark_skin_tone_medium_light_skin_tone[] = "🧑🏿‍❤️‍💋‍🧑🏼";
	inline constexpr const char kiss_person_person_tone5_tone3[] = "🧑🏿‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_dark_skin_tone_medium_skin_tone[] = "🧑🏿‍❤️‍💋‍🧑🏽";
	inline constexpr const char kiss_person_person_tone5_tone4[] = "🧑🏿‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_person_person_dark_skin_tone_medium_dark_skin_tone[] = "🧑🏿‍❤️‍💋‍🧑🏾";
	inline constexpr const char kiss_tone5[] = "💏🏿";
	inline constexpr const char kiss_dark_skin_tone[] = "💏🏿";
	inline constexpr const char kiss_woman_man[] = "👩‍❤️‍💋‍👨";
	inline constexpr const char kiss_woman_man_tone1[] = "👩🏻‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_light_skin_tone[] = "👩🏻‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_tone1_tone2[] = "👩🏻‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_light_skin_tone_medium_light_skin_tone[] = "👩🏻‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_tone1_tone3[] = "👩🏻‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_light_skin_tone_medium_skin_tone[] = "👩🏻‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_tone1_tone4[] = "👩🏻‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_light_skin_tone_medium_dark_skin_tone[] = "👩🏻‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_tone1_tone5[] = "👩🏻‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_light_skin_tone_dark_skin_tone[] = "👩🏻‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_tone2_tone1[] = "👩🏼‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_medium_light_skin_tone_light_skin_tone[] = "👩🏼‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_tone2[] = "👩🏼‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_medium_light_skin_tone[] = "👩🏼‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_tone2_tone3[] = "👩🏼‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_medium_light_skin_tone_medium_skin_tone[] = "👩🏼‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_tone2_tone4[] = "👩🏼‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_medium_light_skin_tone_medium_dark_skin_tone[] = "👩🏼‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_tone2_tone5[] = "👩🏼‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_medium_light_skin_tone_dark_skin_tone[] = "👩🏼‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_tone3_tone1[] = "👩🏽‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_medium_skin_tone_light_skin_tone[] = "👩🏽‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_tone3_tone2[] = "👩🏽‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_medium_skin_tone_medium_light_skin_tone[] = "👩🏽‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_tone3[] = "👩🏽‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_medium_skin_tone[] = "👩🏽‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_tone3_tone4[] = "👩🏽‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_medium_skin_tone_medium_dark_skin_tone[] = "👩🏽‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_tone3_tone5[] = "👩🏽‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_medium_skin_tone_dark_skin_tone[] = "👩🏽‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_tone4_tone1[] = "👩🏾‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_medium_dark_skin_tone_light_skin_tone[] = "👩🏾‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_tone4_tone2[] = "👩🏾‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_medium_dark_skin_tone_medium_light_skin_tone[] = "👩🏾‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_tone4_tone3[] = "👩🏾‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_medium_dark_skin_tone_medium_skin_tone[] = "👩🏾‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_tone4[] = "👩🏾‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_medium_dark_skin_tone[] = "👩🏾‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_tone4_tone5[] = "👩🏾‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_medium_dark_skin_tone_dark_skin_tone[] = "👩🏾‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_tone5_tone1[] = "👩🏿‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_dark_skin_tone_light_skin_tone[] = "👩🏿‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_woman_man_tone5_tone2[] = "👩🏿‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_dark_skin_tone_medium_light_skin_tone[] = "👩🏿‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_woman_man_tone5_tone3[] = "👩🏿‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_dark_skin_tone_medium_skin_tone[] = "👩🏿‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_woman_man_tone5_tone4[] = "👩🏿‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_dark_skin_tone_medium_dark_skin_tone[] = "👩🏿‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_woman_man_tone5[] = "👩🏿‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_woman_man_dark_skin_tone[] = "👩🏿‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_ww[] = "👩‍❤️‍💋‍👩";
	inline constexpr const char couplekiss_ww[] = "👩‍❤️‍💋‍👩";
	inline constexpr const char kiss_woman_woman_tone1[] = "👩🏻‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_light_skin_tone[] = "👩🏻‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_tone1_tone2[] = "👩🏻‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_light_skin_tone_medium_light_skin_tone[] = "👩🏻‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_tone1_tone3[] = "👩🏻‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_light_skin_tone_medium_skin_tone[] = "👩🏻‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_tone1_tone4[] = "👩🏻‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_light_skin_tone_medium_dark_skin_tone[] = "👩🏻‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_tone1_tone5[] = "👩🏻‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_light_skin_tone_dark_skin_tone[] = "👩🏻‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_tone2_tone1[] = "👩🏼‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_medium_light_skin_tone_light_skin_tone[] = "👩🏼‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_tone2[] = "👩🏼‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_medium_light_skin_tone[] = "👩🏼‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_tone2_tone3[] = "👩🏼‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_medium_light_skin_tone_medium_skin_tone[] = "👩🏼‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_tone2_tone4[] = "👩🏼‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_medium_light_skin_tone_medium_dark_skin_tone[] = "👩🏼‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_tone2_tone5[] = "👩🏼‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_medium_light_skin_tone_dark_skin_tone[] = "👩🏼‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_tone3_tone1[] = "👩🏽‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_medium_skin_tone_light_skin_tone[] = "👩🏽‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_tone3_tone2[] = "👩🏽‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_medium_skin_tone_medium_light_skin_tone[] = "👩🏽‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_tone3[] = "👩🏽‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_medium_skin_tone[] = "👩🏽‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_tone3_tone4[] = "👩🏽‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_medium_skin_tone_medium_dark_skin_tone[] = "👩🏽‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_tone3_tone5[] = "👩🏽‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_medium_skin_tone_dark_skin_tone[] = "👩🏽‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_tone4_tone1[] = "👩🏾‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_medium_dark_skin_tone_light_skin_tone[] = "👩🏾‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_tone4_tone2[] = "👩🏾‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_medium_dark_skin_tone_medium_light_skin_tone[] = "👩🏾‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_tone4_tone3[] = "👩🏾‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_medium_dark_skin_tone_medium_skin_tone[] = "👩🏾‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_tone4[] = "👩🏾‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_medium_dark_skin_tone[] = "👩🏾‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_tone4_tone5[] = "👩🏾‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_medium_dark_skin_tone_dark_skin_tone[] = "👩🏾‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_tone5_tone1[] = "👩🏿‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_dark_skin_tone_light_skin_tone[] = "👩🏿‍❤️‍💋‍👩🏻";
	inline constexpr const char kiss_woman_woman_tone5_tone2[] = "👩🏿‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_dark_skin_tone_medium_light_skin_tone[] = "👩🏿‍❤️‍💋‍👩🏼";
	inline constexpr const char kiss_woman_woman_tone5_tone3[] = "👩🏿‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_dark_skin_tone_medium_skin_tone[] = "👩🏿‍❤️‍💋‍👩🏽";
	inline constexpr const char kiss_woman_woman_tone5_tone4[] = "👩🏿‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_dark_skin_tone_medium_dark_skin_tone[] = "👩🏿‍❤️‍💋‍👩🏾";
	inline constexpr const char kiss_woman_woman_tone5[] = "👩🏿‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_woman_woman_dark_skin_tone[] = "👩🏿‍❤️‍💋‍👩🏿";
	inline constexpr const char kiss_mm[] = "👨‍❤️‍💋‍👨";
	inline constexpr const char couplekiss_mm[] = "👨‍❤️‍💋‍👨";
	inline constexpr const char kiss_man_man[] = "👨‍❤️‍💋‍👨";
	inline constexpr const char kiss_man_man_tone1[] = "👨🏻‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_light_skin_tone[] = "👨🏻‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_tone1_tone2[] = "👨🏻‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_light_skin_tone_medium_light_skin_tone[] = "👨🏻‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_tone1_tone3[] = "👨🏻‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_light_skin_tone_medium_skin_tone[] = "👨🏻‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_tone1_tone4[] = "👨🏻‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_light_skin_tone_medium_dark_skin_tone[] = "👨🏻‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_tone1_tone5[] = "👨🏻‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_light_skin_tone_dark_skin_tone[] = "👨🏻‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_tone2_tone1[] = "👨🏼‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_medium_light_skin_tone_light_skin_tone[] = "👨🏼‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_tone2[] = "👨🏼‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_medium_light_skin_tone[] = "👨🏼‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_tone2_tone3[] = "👨🏼‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_medium_light_skin_tone_medium_skin_tone[] = "👨🏼‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_tone2_tone4[] = "👨🏼‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_medium_light_skin_tone_medium_dark_skin_tone[] = "👨🏼‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_tone2_tone5[] = "👨🏼‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_medium_light_skin_tone_dark_skin_tone[] = "👨🏼‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_tone3_tone1[] = "👨🏽‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_medium_skin_tone_light_skin_tone[] = "👨🏽‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_tone3_tone2[] = "👨🏽‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_medium_skin_tone_medium_light_skin_tone[] = "👨🏽‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_tone3[] = "👨🏽‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_medium_skin_tone[] = "👨🏽‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_tone3_tone4[] = "👨🏽‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_medium_skin_tone_medium_dark_skin_tone[] = "👨🏽‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_tone3_tone5[] = "👨🏽‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_medium_skin_tone_dark_skin_tone[] = "👨🏽‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_tone4_tone1[] = "👨🏾‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_medium_dark_skin_tone_light_skin_tone[] = "👨🏾‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_tone4_tone2[] = "👨🏾‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_medium_dark_skin_tone_medium_light_skin_tone[] = "👨🏾‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_tone4_tone3[] = "👨🏾‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_medium_dark_skin_tone_medium_skin_tone[] = "👨🏾‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_tone4[] = "👨🏾‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_medium_dark_skin_tone[] = "👨🏾‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_tone4_tone5[] = "👨🏾‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_medium_dark_skin_tone_dark_skin_tone[] = "👨🏾‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_tone5_tone1[] = "👨🏿‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_dark_skin_tone_light_skin_tone[] = "👨🏿‍❤️‍💋‍👨🏻";
	inline constexpr const char kiss_man_man_tone5_tone2[] = "👨🏿‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_dark_skin_tone_medium_light_skin_tone[] = "👨🏿‍❤️‍💋‍👨🏼";
	inline constexpr const char kiss_man_man_tone5_tone3[] = "👨🏿‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_dark_skin_tone_medium_skin_tone[] = "👨🏿‍❤️‍💋‍👨🏽";
	inline constexpr const char kiss_man_man_tone5_tone4[] = "👨🏿‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_dark_skin_tone_medium_dark_skin_tone[] = "👨🏿‍❤️‍💋‍👨🏾";
	inline constexpr const char kiss_man_man_tone5[] = "👨🏿‍❤️‍💋‍👨🏿";
	inline constexpr const char kiss_man_man_dark_skin_tone[] = "👨🏿‍❤️‍💋‍👨🏿";
	inline constexpr const char family[] = "👪";
	inline constexpr const char family_man_woman_boy[] = "👨‍👩‍👦";
	inline constexpr const char family_mwg[] = "👨‍👩‍👧";
	inline constexpr const char family_mwgb[] = "👨‍👩‍👧‍👦";
	inline constexpr const char family_mwbb[] = "👨‍👩‍👦‍👦";
	inline constexpr const char family_mwgg[] = "👨‍👩‍👧‍👧";
	inline constexpr const char family_wwb[] = "👩‍👩‍👦";
	inline constexpr const char family_wwg[] = "👩‍👩‍👧";
	inline constexpr const char family_wwgb[] = "👩‍👩‍👧‍👦";
	inline constexpr const char family_wwbb[] = "👩‍👩‍👦‍👦";
	inline constexpr const char family_wwgg[] = "👩‍👩‍👧‍👧";
	inline constexpr const char family_mmb[] = "👨‍👨‍👦";
	inline constexpr const char family_mmg[] = "👨‍👨‍👧";
	inline constexpr const char family_mmgb[] = "👨‍👨‍👧‍👦";
	inline constexpr const char family_mmbb[] = "👨‍👨‍👦‍👦";
	inline constexpr const char family_mmgg[] = "👨‍👨‍👧‍👧";
	inline constexpr const char family_woman_boy[] = "👩‍👦";
	inline constexpr const char family_woman_girl[] = "👩‍👧";
	inline constexpr const char family_woman_girl_boy[] = "👩‍👧‍👦";
	inline constexpr const char family_woman_boy_boy[] = "👩‍👦‍👦";
	inline constexpr const char family_woman_girl_girl[] = "👩‍👧‍👧";
	inline constexpr const char family_man_boy[] = "👨‍👦";
	inline constexpr const char family_man_girl[] = "👨‍👧";
	inline constexpr const char family_man_girl_boy[] = "👨‍👧‍👦";
	inline constexpr const char family_man_boy_boy[] = "👨‍👦‍👦";
	inline constexpr const char family_man_girl_girl[] = "👨‍👧‍👧";
	inline constexpr const char knot[] = "🪢";
	inline constexpr const char yarn[] = "🧶";
	inline constexpr const char thread[] = "🧵";
	inline constexpr const char sewing_needle[] = "🪡";
	inline constexpr const char coat[] = "🧥";
	inline constexpr const char lab_coat[] = "🥼";
	inline constexpr const char safety_vest[] = "🦺";
	inline constexpr const char womans_clothes[] = "👚";
	inline constexpr const char shirt[] = "👕";
	inline constexpr const char t_shirt[] = "👕";
	inline constexpr const char jeans[] = "👖";
	inline constexpr const char briefs[] = "🩲";
	inline constexpr const char shorts[] = "🩳";
	inline constexpr const char necktie[] = "👔";
	inline constexpr const char dress[] = "👗";
	inline constexpr const char bikini[] = "👙";
	inline constexpr const char one_piece_swimsuit[] = "🩱";
	inline constexpr const char kimono[] = "👘";
	inline constexpr const char sari[] = "🥻";
	inline constexpr const char thong_sandal[] = "🩴";
	inline constexpr const char womans_flat_shoe[] = "🥿";
	inline constexpr const char flat_shoe[] = "🥿";
	inline constexpr const char high_heel[] = "👠";
	inline constexpr const char sandal[] = "👡";
	inline constexpr const char womans_sandal[] = "👡";
	inline constexpr const char boot[] = "👢";
	inline constexpr const char womans_boot[] = "👢";
	inline constexpr const char mans_shoe[] = "👞";
	inline constexpr const char athletic_shoe[] = "👟";
	inline constexpr const char running_shoe[] = "👟";
	inline constexpr const char hiking_boot[] = "🥾";
	inline constexpr const char socks[] = "🧦";
	inline constexpr const char gloves[] = "🧤";
	inline constexpr const char scarf[] = "🧣";
	inline constexpr const char tophat[] = "🎩";
	inline constexpr const char top_hat[] = "🎩";
	inline constexpr const char billed_cap[] = "🧢";
	inline constexpr const char womans_hat[] = "👒";
	inline constexpr const char mortar_board[] = "🎓";
	inline constexpr const char helmet_with_cross[] = "⛑️";
	inline constexpr const char helmet_with_white_cross[] = "⛑️";
	inline constexpr const char military_helmet[] = "🪖";
	inline constexpr const char crown[] = "👑";
	inline constexpr const char ring[] = "💍";
	inline constexpr const char pouch[] = "👝";
	inline constexpr const char clutch_bag[] = "👝";
	inline constexpr const char purse[] = "👛";
	inline constexpr const char handbag[] = "👜";
	inline constexpr const char briefcase[] = "💼";
	inline constexpr const char school_satchel[] = "🎒";
	inline constexpr const char backpack[] = "🎒";
	inline constexpr const char luggage[] = "🧳";
	inline constexpr const char eyeglasses[] = "👓";
	inline constexpr const char glasses[] = "👓";
	inline constexpr const char dark_sunglasses[] = "🕶️";
	inline constexpr const char goggles[] = "🥽";
	inline constexpr const char closed_umbrella[] = "🌂";
	inline constexpr const char pink_heart[] = "🩷";
	inline constexpr const char heart[] = "❤️";
	inline constexpr const char red_heart[] = "❤️";
	inline constexpr const char orange_heart[] = "🧡";
	inline constexpr const char yellow_heart[] = "💛";
	inline constexpr const char green_heart[] = "💚";
	inline constexpr const char light_blue_heart[] = "🩵";
	inline constexpr const char blue_heart[] = "💙";
	inline constexpr const char purple_heart[] = "💜";
	inline constexpr const char black_heart[] = "🖤";
	inline constexpr const char grey_heart[] = "🩶";
	inline constexpr const char white_heart[] = "🤍";
	inline constexpr const char brown_heart[] = "🤎";
	inline constexpr const char broken_heart[] = "💔";
	inline constexpr const char heart_exclamation[] = "❣️";
	inline constexpr const char heavy_heart_exclamation_mark_ornament[] = "❣️";
	inline constexpr const char two_hearts[] = "💕";
	inline constexpr const char revolving_hearts[] = "💞";
	inline constexpr const char heartbeat[] = "💓";
	inline constexpr const char beating_heart[] = "💓";
	inline constexpr const char heartpulse[] = "💗";
	inline constexpr const char growing_heart[] = "💗";
	inline constexpr const char sparkling_heart[] = "💖";
	inline constexpr const char cupid[] = "💘";
	inline constexpr const char gift_heart[] = "💝";
	inline constexpr const char mending_heart[] = "❤️‍🩹";
	inline constexpr const char heart_on_fire[] = "❤️‍🔥";
	inline constexpr const char heart_decoration[] = "💟";
	inline constexpr const char peace[] = "☮️";
	inline constexpr const char peace_symbol[] = "☮️";
	inline constexpr const char cross[] = "✝️";
	inline constexpr const char latin_cross[] = "✝️";
	inline constexpr const char star_and_crescent[] = "☪️";
	inline constexpr const char om_symbol[] = "🕉️";
	inline constexpr const char wheel_of_dharma[] = "☸️";
	inline constexpr const char khanda[] = "🪯";
	inline constexpr const char star_of_david[] = "✡️";
	inline constexpr const char six_pointed_star[] = "🔯";
	inline constexpr const char menorah[] = "🕎";
	inline constexpr const char yin_yang[] = "☯️";
	inline constexpr const char orthodox_cross[] = "☦️";
	inline constexpr const char place_of_worship[] = "🛐";
	inline constexpr const char worship_symbol[] = "🛐";
	inline constexpr const char ophiuchus[] = "⛎";
	inline constexpr const char aries[] = "♈";
	inline constexpr const char taurus[] = "♉";
	inline constexpr const char gemini[] = "♊";
	inline constexpr const char cancer[] = "♋";
	inline constexpr const char leo[] = "♌";
	inline constexpr const char virgo[] = "♍";
	inline constexpr const char libra[] = "♎";
	inline constexpr const char scorpius[] = "♏";
	inline constexpr const char scorpio[] = "♏";
	inline constexpr const char sagittarius[] = "♐";
	inline constexpr const char capricorn[] = "♑";
	inline constexpr const char aquarius[] = "♒";
	inline constexpr const char pisces[] = "♓";
	inline constexpr const char id[] = "🆔";
	inline constexpr const char atom[] = "⚛️";
	inline constexpr const char atom_symbol[] = "⚛️";
	inline constexpr const char accept[] = "🉑";
	inline constexpr const char radioactive[] = "☢️";
	inline constexpr const char radioactive_sign[] = "☢️";
	inline constexpr const char biohazard[] = "☣️";
	inline constexpr const char biohazard_sign[] = "☣️";
	inline constexpr const char mobile_phone_off[] = "📴";
	inline constexpr const char vibration_mode[] = "📳";
	inline constexpr const char u6709[] = "🈶";
	inline constexpr const char u7121[] = "🈚";
	inline constexpr const char u7533[] = "🈸";
	inline constexpr const char u55b6[] = "🈺";
	inline constexpr const char u6708[] = "🈷️";
	inline constexpr const char eight_pointed_black_star[] = "✴️";
	inline constexpr const char vs[] = "🆚";
	inline constexpr const char white_flower[] = "💮";
	inline constexpr const char ideograph_advantage[] = "🉐";
	inline constexpr const char secret[] = "㊙️";
	inline constexpr const char congratulations[] = "㊗️";
	inline constexpr const char u5408[] = "🈴";
	inline constexpr const char u6e80[] = "🈵";
	inline constexpr const char u5272[] = "🈹";
	inline constexpr const char u7981[] = "🈲";
	inline constexpr const char a[] = "🅰️";
	inline constexpr const char b[] = "🅱️";
	inline constexpr const char ab[] = "🆎";
	inline constexpr const char cl[] = "🆑";
	inline constexpr const char o2[] = "🅾️";
	inline constexpr const char sos[] = "🆘";
	inline constexpr const char x[] = "❌";
	inline constexpr const char cross_mark[] = "❌";
	inline constexpr const char o[] = "⭕";
	inline constexpr const char octagonal_sign[] = "🛑";
	inline constexpr const char stop_sign[] = "🛑";
	inline constexpr const char no_entry[] = "⛔";
	inline constexpr const char name_badge[] = "📛";
	inline constexpr const char no_entry_sign[] = "🚫";
	inline constexpr const char prohibited[] = "🚫";
	inline constexpr const char anger[] = "💢";
	inline constexpr const char hotsprings[] = "♨️";
	inline constexpr const char hot_springs[] = "♨️";
	inline constexpr const char no_pedestrians[] = "🚷";
	inline constexpr const char do_not_litter[] = "🚯";
	inline constexpr const char no_littering[] = "🚯";
	inline constexpr const char no_bicycles[] = "🚳";
	inline constexpr const char non_potable_water[] = "🚱";
	inline constexpr const char underage[] = "🔞";
	inline constexpr const char no_mobile_phones[] = "📵";
	inline constexpr const char no_smoking[] = "🚭";
	inline constexpr const char exclamation[] = "❗";
	inline constexpr const char grey_exclamation[] = "❕";
	inline constexpr const char question[] = "❓";
	inline constexpr const char question_mark[] = "❓";
	inline constexpr const char grey_question[] = "❔";
	inline constexpr const char bangbang[] = "‼️";
	inline constexpr const char interrobang[] = "⁉️";
	inline constexpr const char low_brightness[] = "🔅";
	inline constexpr const char high_brightness[] = "🔆";
	inline constexpr const char part_alternation_mark[] = "〽️";
	inline constexpr const char warning[] = "⚠️";
	inline constexpr const char children_crossing[] = "🚸";
	inline constexpr const char trident[] = "🔱";
	inline constexpr const char fleur_de_lis[] = "⚜️";
	inline constexpr const char beginner[] = "🔰";
	inline constexpr const char recycle[] = "♻️";
	inline constexpr const char white_check_mark[] = "✅";
	inline constexpr const char u6307[] = "🈯";
	inline constexpr const char chart[] = "💹";
	inline constexpr const char sparkle[] = "❇️";
	inline constexpr const char eight_spoked_asterisk[] = "✳️";
	inline constexpr const char negative_squared_cross_mark[] = "❎";
	inline constexpr const char globe_with_meridians[] = "🌐";
	inline constexpr const char diamond_shape_with_a_dot_inside[] = "💠";
	inline constexpr const char m[] = "Ⓜ️";
	inline constexpr const char circled_m[] = "Ⓜ️";
	inline constexpr const char cyclone[] = "🌀";
	inline constexpr const char zzz[] = "💤";
	inline constexpr const char atm[] = "🏧";
	inline constexpr const char wc[] = "🚾";
	inline constexpr const char water_closet[] = "🚾";
	inline constexpr const char wheelchair[] = "♿";
	inline constexpr const char parking[] = "🅿️";
	inline constexpr const char elevator[] = "🛗";
	inline constexpr const char u7a7a[] = "🈳";
	inline constexpr const char sa[] = "🈂️";
	inline constexpr const char passport_control[] = "🛂";
	inline constexpr const char customs[] = "🛃";
	inline constexpr const char baggage_claim[] = "🛄";
	inline constexpr const char left_luggage[] = "🛅";
	inline constexpr const char wireless[] = "🛜";
	inline constexpr const char mens[] = "🚹";
	inline constexpr const char mens_room[] = "🚹";
	inline constexpr const char womens[] = "🚺";
	inline constexpr const char womens_room[] = "🚺";
	inline constexpr const char baby_symbol[] = "🚼";
	inline constexpr const char restroom[] = "🚻";
	inline constexpr const char put_litter_in_its_place[] = "🚮";
	inline constexpr const char cinema[] = "🎦";
	inline constexpr const char signal_strength[] = "📶";
	inline constexpr const char antenna_bars[] = "📶";
	inline constexpr const char koko[] = "🈁";
	inline constexpr const char symbols[] = "🔣";
	inline constexpr const char input_symbols[] = "🔣";
	inline constexpr const char information_source[] = "ℹ️";
	inline constexpr const char information[] = "ℹ️";
	inline constexpr const char abc[] = "🔤";
	inline constexpr const char abcd[] = "🔡";
	inline constexpr const char capital_abcd[] = "🔠";
	inline constexpr const char ng[] = "🆖";
	inline constexpr const char ok[] = "🆗";
	inline constexpr const char up[] = "🆙";
	inline constexpr const char cool[] = "🆒";
	inline constexpr const char _new[] = "🆕";
	inline constexpr const char free[] = "🆓";
	inline constexpr const char zero[] = "0️⃣";
	inline constexpr const char one[] = "1️⃣";
	inline constexpr const char two[] = "2️⃣";
	inline constexpr const char three[] = "3️⃣";
	inline constexpr const char four[] = "4️⃣";
	inline constexpr const char five[] = "5️⃣";
	inline constexpr const char six[] = "6️⃣";
	inline constexpr const char seven[] = "7️⃣";
	inline constexpr const char eight[] = "8️⃣";
	inline constexpr const char nine[] = "9️⃣";
	inline constexpr const char keycap_ten[] = "🔟";
	inline constexpr const char input_numbers[] = "🔢";
	inline constexpr const char hash[] = "#️⃣";
	inline constexpr const char asterisk[] = "*️⃣";
	inline constexpr const char keycap_asterisk[] = "*️⃣";
	inline constexpr const char eject[] = "⏏️";
	inline constexpr const char eject_symbol[] = "⏏️";
	inline constexpr const char arrow_forward[] = "▶️";
	inline constexpr const char pause_button[] = "⏸️";
	inline constexpr const char double_vertical_bar[] = "⏸️";
	inline constexpr const char play_pause[] = "⏯️";
	inline constexpr const char stop_button[] = "⏹️";
	inline constexpr const char record_button[] = "⏺️";
	inline constexpr const char track_next[] = "⏭️";
	inline constexpr const char next_track[] = "⏭️";
	inline constexpr const char track_previous[] = "⏮️";
	inline constexpr const char previous_track[] = "⏮️";
	inline constexpr const char fast_forward[] = "⏩";
	inline constexpr const char rewind[] = "⏪";
	inline constexpr const char arrow_double_up[] = "⏫";
	inline constexpr const char arrow_double_down[] = "⏬";
	inline constexpr const char arrow_backward[] = "◀️";
	inline constexpr const char arrow_up_small[] = "🔼";
	inline constexpr const char arrow_down_small[] = "🔽";
	inline constexpr const char arrow_right[] = "➡️";
	inline constexpr const char right_arrow[] = "➡️";
	inline constexpr const char arrow_left[] = "⬅️";
	inline constexpr const char left_arrow[] = "⬅️";
	inline constexpr const char arrow_up[] = "⬆️";
	inline constexpr const char up_arrow[] = "⬆️";
	inline constexpr const char arrow_down[] = "⬇️";
	inline constexpr const char down_arrow[] = "⬇️";
	inline constexpr const char arrow_upper_right[] = "↗️";
	inline constexpr const char arrow_lower_right[] = "↘️";
	inline constexpr const char arrow_lower_left[] = "↙️";
	inline constexpr const char arrow_upper_left[] = "↖️";
	inline constexpr const char up_left_arrow[] = "↖️";
	inline constexpr const char arrow_up_down[] = "↕️";
	inline constexpr const char up_down_arrow[] = "↕️";
	inline constexpr const char left_right_arrow[] = "↔️";
	inline constexpr const char arrow_right_hook[] = "↪️";
	inline constexpr const char leftwards_arrow_with_hook[] = "↩️";
	inline constexpr const char arrow_heading_up[] = "⤴️";
	inline constexpr const char arrow_heading_down[] = "⤵️";
	inline constexpr const char twisted_rightwards_arrows[] = "🔀";
	inline constexpr const char repeat[] = "🔁";
	inline constexpr const char repeat_one[] = "🔂";
	inline constexpr const char arrows_counterclockwise[] = "🔄";
	inline constexpr const char arrows_clockwise[] = "🔃";
	inline constexpr const char musical_note[] = "🎵";
	inline constexpr const char notes[] = "🎶";
	inline constexpr const char musical_notes[] = "🎶";
	inline constexpr const char heavy_plus_sign[] = "➕";
	inline constexpr const char heavy_minus_sign[] = "➖";
	inline constexpr const char heavy_division_sign[] = "➗";
	inline constexpr const char heavy_multiplication_x[] = "✖️";
	inline constexpr const char heavy_equals_sign[] = "🟰";
	inline constexpr const char infinity[] = "♾️";
	inline constexpr const char heavy_dollar_sign[] = "💲";
	inline constexpr const char currency_exchange[] = "💱";
	inline constexpr const char tm[] = "™️";
	inline constexpr const char trade_mark[] = "™️";
	inline constexpr const char copyright[] = "©️";
	inline constexpr const char registered[] = "®️";
	inline constexpr const char wavy_dash[] = "〰️";
	inline constexpr const char curly_loop[] = "➰";
	inline constexpr const char loop[] = "➿";
	inline constexpr const char end[] = "🔚";
	inline constexpr const char end_arrow[] = "🔚";
	inline constexpr const char back[] = "🔙";
	inline constexpr const char back_arrow[] = "🔙";
	inline constexpr const char on[] = "🔛";
	inline constexpr const char on_arrow[] = "🔛";
	inline constexpr const char top[] = "🔝";
	inline constexpr const char top_arrow[] = "🔝";
	inline constexpr const char soon[] = "🔜";
	inline constexpr const char soon_arrow[] = "🔜";
	inline constexpr const char heavy_check_mark[] = "✔️";
	inline constexpr const char check_mark[] = "✔️";
	inline constexpr const char ballot_box_with_check[] = "☑️";
	inline constexpr const char radio_button[] = "🔘";
	inline constexpr const char white_circle[] = "⚪";
	inline constexpr const char black_circle[] = "⚫";
	inline constexpr const char red_circle[] = "🔴";
	inline constexpr const char blue_circle[] = "🔵";
	inline constexpr const char brown_circle[] = "🟤";
	inline constexpr const char purple_circle[] = "🟣";
	inline constexpr const char green_circle[] = "🟢";
	inline constexpr const char yellow_circle[] = "🟡";
	inline constexpr const char orange_circle[] = "🟠";
	inline constexpr const char small_red_triangle[] = "🔺";
	inline constexpr const char small_red_triangle_down[] = "🔻";
	inline constexpr const char small_orange_diamond[] = "🔸";
	inline constexpr const char small_blue_diamond[] = "🔹";
	inline constexpr const char large_orange_diamond[] = "🔶";
	inline constexpr const char large_blue_diamond[] = "🔷";
	inline constexpr const char white_square_button[] = "🔳";
	inline constexpr const char black_square_button[] = "🔲";
	inline constexpr const char black_small_square[] = "▪️";
	inline constexpr const char white_small_square[] = "▫️";
	inline constexpr const char black_medium_small_square[] = "◾";
	inline constexpr const char white_medium_small_square[] = "◽";
	inline constexpr const char black_medium_square[] = "◼️";
	inline constexpr const char white_medium_square[] = "◻️";
	inline constexpr const char black_large_square[] = "⬛";
	inline constexpr const char white_large_square[] = "⬜";
	inline constexpr const char orange_square[] = "🟧";
	inline constexpr const char blue_square[] = "🟦";
	inline constexpr const char red_square[] = "🟥";
	inline constexpr const char brown_square[] = "🟫";
	inline constexpr const char purple_square[] = "🟪";
	inline constexpr const char green_square[] = "🟩";
	inline constexpr const char yellow_square[] = "🟨";
	inline constexpr const char speaker[] = "🔈";
	inline constexpr const char mute[] = "🔇";
	inline constexpr const char muted_speaker[] = "🔇";
	inline constexpr const char sound[] = "🔉";
	inline constexpr const char loud_sound[] = "🔊";
	inline constexpr const char bell[] = "🔔";
	inline constexpr const char no_bell[] = "🔕";
	inline constexpr const char mega[] = "📣";
	inline constexpr const char megaphone[] = "📣";
	inline constexpr const char loudspeaker[] = "📢";
	inline constexpr const char speech_left[] = "🗨️";
	inline constexpr const char left_speech_bubble[] = "🗨️";
	inline constexpr const char eye_in_speech_bubble[] = "👁‍🗨";
	inline constexpr const char speech_balloon[] = "💬";
	inline constexpr const char thought_balloon[] = "💭";
	inline constexpr const char anger_right[] = "🗯️";
	inline constexpr const char right_anger_bubble[] = "🗯️";
	inline constexpr const char spades[] = "♠️";
	inline constexpr const char spade_suit[] = "♠️";
	inline constexpr const char clubs[] = "♣️";
	inline constexpr const char club_suit[] = "♣️";
	inline constexpr const char hearts[] = "♥️";
	inline constexpr const char heart_suit[] = "♥️";
	inline constexpr const char diamonds[] = "♦️";
	inline constexpr const char diamond_suit[] = "♦️";
	inline constexpr const char black_joker[] = "🃏";
	inline constexpr const char joker[] = "🃏";
	inline constexpr const char flower_playing_cards[] = "🎴";
	inline constexpr const char mahjong[] = "🀄";
	inline constexpr const char clock1[] = "🕐";
	inline constexpr const char one_oclock[] = "🕐";
	inline constexpr const char clock2[] = "🕑";
	inline constexpr const char two_oclock[] = "🕑";
	inline constexpr const char clock3[] = "🕒";
	inline constexpr const char three_oclock[] = "🕒";
	inline constexpr const char clock4[] = "🕓";
	inline constexpr const char four_oclock[] = "🕓";
	inline constexpr const char clock5[] = "🕔";
	inline constexpr const char five_oclock[] = "🕔";
	inline constexpr const char clock6[] = "🕕";
	inline constexpr const char six_oclock[] = "🕕";
	inline constexpr const char clock7[] = "🕖";
	inline constexpr const char seven_oclock[] = "🕖";
	inline constexpr const char clock8[] = "🕗";
	inline constexpr const char eight_oclock[] = "🕗";
	inline constexpr const char clock9[] = "🕘";
	inline constexpr const char nine_oclock[] = "🕘";
	inline constexpr const char clock10[] = "🕙";
	inline constexpr const char ten_oclock[] = "🕙";
	inline constexpr const char clock11[] = "🕚";
	inline constexpr const char eleven_oclock[] = "🕚";
	inline constexpr const char clock12[] = "🕛";
	inline constexpr const char twelve_oclock[] = "🕛";
	inline constexpr const char clock130[] = "🕜";
	inline constexpr const char one_thirty[] = "🕜";
	inline constexpr const char clock230[] = "🕝";
	inline constexpr const char two_thirty[] = "🕝";
	inline constexpr const char clock330[] = "🕞";
	inline constexpr const char three_thirty[] = "🕞";
	inline constexpr const char clock430[] = "🕟";
	inline constexpr const char four_thirty[] = "🕟";
	inline constexpr const char clock530[] = "🕠";
	inline constexpr const char five_thirty[] = "🕠";
	inline constexpr const char clock630[] = "🕡";
	inline constexpr const char six_thirty[] = "🕡";
	inline constexpr const char clock730[] = "🕢";
	inline constexpr const char seven_thirty[] = "🕢";
	inline constexpr const char clock830[] = "🕣";
	inline constexpr const char eight_thirty[] = "🕣";
	inline constexpr const char clock930[] = "🕤";
	inline constexpr const char nine_thirty[] = "🕤";
	inline constexpr const char clock1030[] = "🕥";
	inline constexpr const char ten_thirty[] = "🕥";
	inline constexpr const char clock1130[] = "🕦";
	inline constexpr const char eleven_thirty[] = "🕦";
	inline constexpr const char clock1230[] = "🕧";
	inline constexpr const char twelve_thirty[] = "🕧";
	inline constexpr const char female_sign[] = "♀️";
	inline constexpr const char male_sign[] = "♂️";
	inline constexpr const char transgender_symbol[] = "⚧";
	inline constexpr const char medical_symbol[] = "⚕️";
	inline constexpr const char regional_indicator_z[] = "🇿";
	inline constexpr const char regional_indicator_y[] = "🇾";
	inline constexpr const char regional_indicator_x[] = "🇽";
	inline constexpr const char regional_indicator_w[] = "🇼";
	inline constexpr const char regional_indicator_v[] = "🇻";
	inline constexpr const char regional_indicator_u[] = "🇺";
	inline constexpr const char regional_indicator_t[] = "🇹";
	inline constexpr const char regional_indicator_s[] = "🇸";
	inline constexpr const char regional_indicator_r[] = "🇷";
	inline constexpr const char regional_indicator_q[] = "🇶";
	inline constexpr const char regional_indicator_p[] = "🇵";
	inline constexpr const char regional_indicator_o[] = "🇴";
	inline constexpr const char regional_indicator_n[] = "🇳";
	inline constexpr const char regional_indicator_m[] = "🇲";
	inline constexpr const char regional_indicator_l[] = "🇱";
	inline constexpr const char regional_indicator_k[] = "🇰";
	inline constexpr const char regional_indicator_j[] = "🇯";
	inline constexpr const char regional_indicator_i[] = "🇮";
	inline constexpr const char regional_indicator_h[] = "🇭";
	inline constexpr const char regional_indicator_g[] = "🇬";
	inline constexpr const char regional_indicator_f[] = "🇫";
	inline constexpr const char regional_indicator_e[] = "🇪";
	inline constexpr const char regional_indicator_d[] = "🇩";
	inline constexpr const char regional_indicator_c[] = "🇨";
	inline constexpr const char regional_indicator_b[] = "🇧";
	inline constexpr const char regional_indicator_a[] = "🇦";
	inline constexpr const char red_car[] = "🚗";
	inline constexpr const char automobile[] = "🚗";
	inline constexpr const char taxi[] = "🚕";
	inline constexpr const char blue_car[] = "🚙";
	inline constexpr const char pickup_truck[] = "🛻";
	inline constexpr const char minibus[] = "🚐";
	inline constexpr const char bus[] = "🚌";
	inline constexpr const char trolleybus[] = "🚎";
	inline constexpr const char race_car[] = "🏎️";
	inline constexpr const char racing_car[] = "🏎️";
	inline constexpr const char police_car[] = "🚓";
	inline constexpr const char ambulance[] = "🚑";
	inline constexpr const char fire_engine[] = "🚒";
	inline constexpr const char truck[] = "🚚";
	inline constexpr const char articulated_lorry[] = "🚛";
	inline constexpr const char tractor[] = "🚜";
	inline constexpr const char probing_cane[] = "🦯";
	inline constexpr const char manual_wheelchair[] = "🦽";
	inline constexpr const char motorized_wheelchair[] = "🦼";
	inline constexpr const char crutch[] = "🩼";
	inline constexpr const char scooter[] = "🛴";
	inline constexpr const char kick_scooter[] = "🛴";
	inline constexpr const char bike[] = "🚲";
	inline constexpr const char bicycle[] = "🚲";
	inline constexpr const char motor_scooter[] = "🛵";
	inline constexpr const char motorbike[] = "🛵";
	inline constexpr const char motorcycle[] = "🏍️";
	inline constexpr const char racing_motorcycle[] = "🏍️";
	inline constexpr const char auto_rickshaw[] = "🛺";
	inline constexpr const char wheel[] = "🛞";
	inline constexpr const char rotating_light[] = "🚨";
	inline constexpr const char oncoming_police_car[] = "🚔";
	inline constexpr const char oncoming_bus[] = "🚍";
	inline constexpr const char oncoming_automobile[] = "🚘";
	inline constexpr const char oncoming_taxi[] = "🚖";
	inline constexpr const char aerial_tramway[] = "🚡";
	inline constexpr const char mountain_cableway[] = "🚠";
	inline constexpr const char suspension_railway[] = "🚟";
	inline constexpr const char railway_car[] = "🚃";
	inline constexpr const char train[] = "🚋";
	inline constexpr const char tram_car[] = "🚋";
	inline constexpr const char mountain_railway[] = "🚞";
	inline constexpr const char monorail[] = "🚝";
	inline constexpr const char bullettrain_side[] = "🚄";
	inline constexpr const char bullettrain_front[] = "🚅";
	inline constexpr const char bullet_train[] = "🚅";
	inline constexpr const char light_rail[] = "🚈";
	inline constexpr const char steam_locomotive[] = "🚂";
	inline constexpr const char locomotive[] = "🚂";
	inline constexpr const char train2[] = "🚆";
	inline constexpr const char metro[] = "🚇";
	inline constexpr const char tram[] = "🚊";
	inline constexpr const char station[] = "🚉";
	inline constexpr const char airplane[] = "✈️";
	inline constexpr const char airplane_departure[] = "🛫";
	inline constexpr const char airplane_arriving[] = "🛬";
	inline constexpr const char airplane_small[] = "🛩️";
	inline constexpr const char small_airplane[] = "🛩️";
	inline constexpr const char seat[] = "💺";
	inline constexpr const char satellite_orbital[] = "🛰️";
	inline constexpr const char rocket[] = "🚀";
	inline constexpr const char flying_saucer[] = "🛸";
	inline constexpr const char helicopter[] = "🚁";
	inline constexpr const char canoe[] = "🛶";
	inline constexpr const char kayak[] = "🛶";
	inline constexpr const char sailboat[] = "⛵";
	inline constexpr const char speedboat[] = "🚤";
	inline constexpr const char motorboat[] = "🛥️";
	inline constexpr const char motor_boat[] = "🛥️";
	inline constexpr const char cruise_ship[] = "🛳️";
	inline constexpr const char passenger_ship[] = "🛳️";
	inline constexpr const char ferry[] = "⛴️";
	inline constexpr const char ship[] = "🚢";
	inline constexpr const char ring_buoy[] = "🛟";
	inline constexpr const char anchor[] = "⚓";
	inline constexpr const char hook[] = "🪝";
	inline constexpr const char fuelpump[] = "⛽";
	inline constexpr const char fuel_pump[] = "⛽";
	inline constexpr const char construction[] = "🚧";
	inline constexpr const char vertical_traffic_light[] = "🚦";
	inline constexpr const char traffic_light[] = "🚥";
	inline constexpr const char busstop[] = "🚏";
	inline constexpr const char bus_stop[] = "🚏";
	inline constexpr const char map[] = "🗺️";
	inline constexpr const char world_map[] = "🗺️";
	inline constexpr const char moyai[] = "🗿";
	inline constexpr const char moai[] = "🗿";
	inline constexpr const char statue_of_liberty[] = "🗽";
	inline constexpr const char tokyo_tower[] = "🗼";
	inline constexpr const char european_castle[] = "🏰";
	inline constexpr const char castle[] = "🏰";
	inline constexpr const char japanese_castle[] = "🏯";
	inline constexpr const char stadium[] = "🏟️";
	inline constexpr const char ferris_wheel[] = "🎡";
	inline constexpr const char roller_coaster[] = "🎢";
	inline constexpr const char carousel_horse[] = "🎠";
	inline constexpr const char fountain[] = "⛲";
	inline constexpr const char beach_umbrella[] = "⛱️";
	inline constexpr const char umbrella_on_ground[] = "⛱️";
	inline constexpr const char beach[] = "🏖️";
	inline constexpr const char beach_with_umbrella[] = "🏖️";
	inline constexpr const char island[] = "🏝️";
	inline constexpr const char desert_island[] = "🏝️";
	inline constexpr const char desert[] = "🏜️";
	inline constexpr const char volcano[] = "🌋";
	inline constexpr const char mountain[] = "⛰️";
	inline constexpr const char mountain_snow[] = "🏔️";
	inline constexpr const char snow_capped_mountain[] = "🏔️";
	inline constexpr const char mount_fuji[] = "🗻";
	inline constexpr const char camping[] = "🏕️";
	inline constexpr const char tent[] = "⛺";
	inline constexpr const char house[] = "🏠";
	inline constexpr const char house_with_garden[] = "🏡";
	inline constexpr const char homes[] = "🏘️";
	inline constexpr const char house_buildings[] = "🏘️";
	inline constexpr const char houses[] = "🏘️";
	inline constexpr const char house_abandoned[] = "🏚️";
	inline constexpr const char derelict_house_building[] = "🏚️";
	inline constexpr const char hut[] = "🛖";
	inline constexpr const char construction_site[] = "🏗️";
	inline constexpr const char building_construction[] = "🏗️";
	inline constexpr const char factory[] = "🏭";
	inline constexpr const char office[] = "🏢";
	inline constexpr const char department_store[] = "🏬";
	inline constexpr const char post_office[] = "🏣";
	inline constexpr const char european_post_office[] = "🏤";
	inline constexpr const char hospital[] = "🏥";
	inline constexpr const char bank[] = "🏦";
	inline constexpr const char hotel[] = "🏨";
	inline constexpr const char convenience_store[] = "🏪";
	inline constexpr const char school[] = "🏫";
	inline constexpr const char love_hotel[] = "🏩";
	inline constexpr const char wedding[] = "💒";
	inline constexpr const char classical_building[] = "🏛️";
	inline constexpr const char church[] = "⛪";
	inline constexpr const char mosque[] = "🕌";
	inline constexpr const char synagogue[] = "🕍";
	inline constexpr const char hindu_temple[] = "🛕";
	inline constexpr const char kaaba[] = "🕋";
	inline constexpr const char shinto_shrine[] = "⛩️";
	inline constexpr const char railway_track[] = "🛤️";
	inline constexpr const char railroad_track[] = "🛤️";
	inline constexpr const char motorway[] = "🛣️";
	inline constexpr const char japan[] = "🗾";
	inline constexpr const char map_of_japan[] = "🗾";
	inline constexpr const char rice_scene[] = "🎑";
	inline constexpr const char park[] = "🏞️";
	inline constexpr const char national_park[] = "🏞️";
	inline constexpr const char sunrise[] = "🌅";
	inline constexpr const char sunrise_over_mountains[] = "🌄";
	inline constexpr const char stars[] = "🌠";
	inline constexpr const char shooting_star[] = "🌠";
	inline constexpr const char sparkler[] = "🎇";
	inline constexpr const char fireworks[] = "🎆";
	inline constexpr const char city_sunset[] = "🌇";
	inline constexpr const char city_sunrise[] = "🌇";
	inline constexpr const char sunset[] = "🌇";
	inline constexpr const char city_dusk[] = "🌆";
	inline constexpr const char cityscape[] = "🏙️";
	inline constexpr const char night_with_stars[] = "🌃";
	inline constexpr const char milky_way[] = "🌌";
	inline constexpr const char bridge_at_night[] = "🌉";
	inline constexpr const char foggy[] = "🌁";
}
};
