/************************************************************************************
 *
 * D++, A Lightweight C++ library for Discord
 *
 * Copyright 2021 Craig Edwards and D++ contributors
 * (https://github.com/brainboxdotcc/DPP/graphs/contributors)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************************/
#pragma once

#include <cstdint>

/**
 * @brief The main namespace for D++ functions. classes and types
 */
namespace dpp {

/**
 * @brief predefined color constants.
 */
namespace colors {
	const uint32_t
		white = 0xFFFFFF,
		discord_white = 0xFFFFFE,
		light_gray = 0xC0C0C0,
		gray = 0x808080,
		dark_gray = 0x404040,
		black = 0x000000,
		discord_black = 0x000001,
		red = 0xFF0000,
		pink = 0xFFAFAF,
		orange = 0xFFC800,
		yellow = 0xFFFF00,
		green = 0x00FF00,
		magenta = 0xFF00FF,
		cyan = 0x00FFFF,
		blue = 0x0000FF,
		light_sea_green = 0x1ABC9C,
		medium_sea_green = 0x2ECC71,
		summer_sky = 0x3498DB,
		deep_lilac = 0x9B59B6,
		ruby = 0xE91E63,
		moon_yellow = 0xF1C40F,
		tahiti_gold = 0xE67E22,
		cinnabar = 0xE74C3C,
		submarine = 0x95A5A6,
		blue_aquamarine = 0x607D8B,
		deep_sea = 0x11806A,
		sea_green = 0x1F8B4C,
		endeavour = 0x206694,
		vivid_violet = 0x71368A,
		jazzberry_jam = 0xAD1457,
		dark_goldenrod = 0xC27C0E,
		rust = 0xA84300,
		brown = 0x992D22,
		gray_chateau = 0x979C9F,
		bismark = 0x546E7A,
		sti_blue = 0x0E4BEF,
		wrx_blue = 0x00247D,
		rallyart_crimson = 0xE60012,
		lime = 0x00FF00,
		forest_green = 0x228B22,
		cadmium_green = 0x097969,
		aquamarine = 0x7FFFD4,
		blue_green = 0x088F8F,
		raspberry = 0xE30B5C,
		scarlet_red = 0xFF2400,
		night = 0x0C090A,
		charcoal = 0x34282C,
		oil = 0x3B3131,
		light_black = 0x454545,
		black_cat = 0x413839,
		iridium = 0x3D3C3A,
		black_eel = 0x463E3F,
		black_cow = 0x4C4646,
		gray_wolf = 0x504A4B,
		grey_wolf = 0x504A4B,
		vampire_gray = 0x565051,
		vampire_grey = 0x565051,
		iron_gray = 0x52595D,
		iron_grey = 0x52595D,
		gray_dolphin = 0x5C5858,
		grey_dolphin = 0x5C5858,
		carbon_gray = 0x625D5D,
		carbon_grey = 0x625D5D,
		ash_gray = 0x666362,
		ash_grey = 0x666362,
		dim_gray = 0x696969,
		dim_grey = 0x696969,
		nardo_gray = 0x686A6C,
		nardo_grey = 0x686A6C,
		cloudy_gray = 0x6D6968,
		cloudy_grey = 0x6D6968,
		smokey_gray = 0x726E6D,
		smokey_grey = 0x726E6D,
		alien_gray = 0x736F6E,
		alien_grey = 0x736F6E,
		sonic_silver = 0x757575,
		platinum_gray = 0x797979,
		platinum_grey = 0x797979,
		granite = 0x837E7C,
		battleship_gray = 0x848482,
		battleship_grey = 0x848482,
		gunmetal_gray = 0x8D918D,
		gunmetal_grey = 0x8D918D,
		gray_cloud = 0xB6B6B4,
		grey_cloud = 0xB6B6B4,
		silver = 0xC0C0C0,
		pale_silver = 0xC9C0BB,
		gray_goose = 0xD1D0CE,
		grey_goose = 0xD1D0CE,
		platinum_silver = 0xCECECE,
		silver_white = 0xDADBDD,
		gainsboro = 0xDCDCDC,
		platinum = 0xE5E4E2,
		metallic_silver = 0xBCC6CC,
		blue_gray = 0x98AFC7,
		blue_grey = 0x98AFC7,
		roman_silver = 0x838996,
		light_slate_gray = 0x778899,
		light_slate_grey = 0x778899,
		slate_gray =  0x708090,
		slate_grey = 0x708090,
		rat_gray = 0x6D7B8D,
		slate_granite_gray = 0x657383,
		slate_granite_grey = 0x657383,
		jet_gray = 0x616D7E,
		jet_grey = 0x616D7E,
		mist_blue = 0x646D7E,
		marble_blue = 0x566D7E,
		slate_blue_grey = 0x737CA1,
		slate_blue_gray = 0x737CA1,
		light_purple_blue = 0x728FCE,
		azure_blue = 0x4863A0,
		blue_jay = 0x2B547E,
		charcoal_blue = 0x36454F,
		dark_blue_grey = 0x29465B,
		dark_slate = 0x2B3856,
		deep_sea_blue = 0x123456,
		night_blue = 0x151B54,
		midnight_blue = 0x191970,
		navy = 0x000080,
		denim_dark_blue = 0x151B8D,
		dark_blue = 0x00008B,
		lapis_blue = 0x15317E,
		new_midnight_blue = 0x0000A0,
		earth_blue = 0x0000A5,
		cobalt_blue = 0x0020C2,
		medium_blue = 0x0000CD,
		blueberry_blue = 0x0041C2,
		canary_blue = 0x2916F5,
		samco_blue = 0x0002FF,
		bright_blue = 0x0909FF,
		blue_orchid = 0x1F45FC,
		sapphire_blue = 0x2554C7,
		blue_eyes = 0x1569C7,
		bright_navy_blue = 0x1974D2,
		balloon_blue = 0x2B60DE,
		royal_blue = 0x4169E1,
		ocean_blue = 0x2B65EC,
		blue_ribbon = 0x306EFF,
		blue_dress = 0x157DEC,
		neon_blue = 0x1589FF,
		dodger_blue = 0x1E90FF,
		glacial_blue_ice = 0x368BC1,
		steel_blue = 0x4682B4,
		silk_blue = 0x488AC7,
		windows_blue = 0x357EC7,
		blue_ivy = 0x3090C7,
		blue_koi = 0x659EC7,
		columbia_blue = 0x87AFC7,
		baby_blue = 0x95B9C7,
		cornflower_blue = 0x6495ED,
		sky_blue_dress = 0x6698FF,
		iceberg = 0x56A5EC,
		butterfly_blue = 0x38ACEC,
		deep_sky_blue = 0x00BFFF,
		midday_blue = 0x3BB9FF,
		crystal_blue = 0x5CB3FF,
		denim_blue = 0x79BAEC,
		day_sky_blue = 0x82CAFF,
		light_sky_blue = 0x87CEFA,
		sky_blue = 0x87CEEB,
		jeans_blue = 0xA0CFEC,
		blue_angel = 0xB7CEEC,
		pastel_blue = 0xB4CFEC,
		light_day_blue = 0xADDFFF,
		sea_blue = 0xC2DFFF,
		heavenly_blue = 0xC6DEFF,
		robin_egg_blue = 0xBDEDFF,
		powder_blue = 0xB0E0E6,
		coral_blue = 0xAFDCEC,
		light_blue = 0xADD8E6,
		light_steel_blue = 0xB0CFDE,
		gulf_blue = 0xC9DFEC,
		pastel_light_blue = 0xD5D6EA,
		lavender_blue = 0xE3E4FA,
		white_blue = 0xDBE9FA,
		lavender = 0xE6E6FA,
		water = 0xEBF4FA,
		alice_blue = 0xF0F8FF,
		ghost_white = 0xF8F8FF,
		azure = 0xF0FFFF,
		light_cyan = 0xE0FFFF,
		light_slate = 0xCCFFFF,
		electric_blue = 0x9AFEFF,
		tron_blue = 0x7DFDFE,
		blue_zircon = 0x57FEFF,
		aqua = 0x00FFFF,
		bright_cyan = 0x0AFFFF,
		celeste = 0x50EBEC,
		blue_diamond = 0x4EE2EC,
		bright_turquoise = 0x16E2F5,
		blue_lagoon = 0x8EEBEC,
		pale_turquoise = 0xAFEEEE,
		pale_blue_lily = 0xCFECEC,
		light_teal = 0xB3D9D9,
		tiffany_blue = 0x81D8D0,
		blue_hosta = 0x77BFC7,
		cyan_opaque = 0x92C7C7,
		northern_lights_blue = 0x78C7C7,
		medium_aquamarine = 0x66CDAA,
		magic_mint = 0xAAF0D1,
		light_aquamarine = 0x93FFE8,
		bright_teal = 0x01F9C6,
		turquoise = 0x40E0D0,
		medium_turquoise = 0x48D1CC,
		deep_turquoise = 0x48CCCD,
		jellyfish = 0x46C7C7,
		blue_turquoise = 0x43C6DB,
		dark_turquoise = 0x00CED1,
		macaw_blue_green = 0x43BFC7,
		seafoam_green = 0x3EA99F,
		cadet_blue = 0x5F9EA0,
		blue_chill = 0x3B9C9C,
		dark_cyan = 0x008B8B,
		teal_green = 0x00827F,
		teal = 0x008080,
		teal_blue = 0x007C80,
		medium_teal = 0x045F5F,
		dark_teal = 0x045D5D,
		deep_teal = 0x033E3E,
		dark_slate_gray = 0x25383C,
		dark_slate_grey = 0x25383C,
		gunmetal = 0x2C3539,
		blue_moss_green = 0x3C565B,
		beetle_green = 0x4C787E,
		grayish_turquoise = 0x5E7D7E,
		greenish_blue = 0x307D7E,
		aquamarine_stone = 0x348781,
		sea_turtle_green = 0x438D80,
		dull_sea_green = 0x4E8975,
		dark_green_blue = 0x1F6357,
		deep_sea_green = 0x306754,
		bottle_green = 0x006A4E,
		elf_green = 0x1B8A6B,
		dark_mint = 0x31906E,
		jade = 0x00A36C,
		earth_green = 0x34A56F,
		chrome_green = 0x1AA260,
		emerald = 0x50C878,
		mint = 0x3EB489,
		metallic_green = 0x7C9D8E,
		camouflage_green = 0x78866B,
		sage_green = 0x848B79,
		hazel_green = 0x617C58,
		venom_green = 0x728C00,
		olive_drab = 0x6B8E23,
		olive = 0x808000,
		dark_olive_green = 0x556B2F,
		military_green = 0x4E5B31,
		green_leaves = 0x3A5F0B,
		army_green = 0x4B5320,
		fern_green = 0x667C26,
		fall_forest_green = 0x4E9258,
		irish_green = 0x08A04B,
		pine_green = 0x387C44,
		medium_forest_green = 0x347235,
		jungle_green = 0x347C2C,
		cactus_green = 0x227442,
		dark_green = 0x006400,
		deep_green = 0x056608,
		deep_emerald_green = 0x046307,
		hunter_green = 0x355E3B,
		dark_forest_green = 0x254117,
		lotus_green = 0x004225,
		seaweed_green = 0x437C17,
		shamrock_green = 0x347C17,
		green_onion = 0x6AA121,
		moss_green = 0x8A9A5B,
		grass_green = 0x3F9B0B,
		green_pepper = 0x4AA02C,
		dark_lime_green = 0x41A317,
		parrot_green = 0x12AD2B,
		clover_green = 0x3EA055,
		dinosaur_green = 0x73A16C,
		green_snake = 0x6CBB3C,
		alien_green = 0x6CC417,
		green_apple = 0x4CC417,
		lime_green = 0x32CD32,
		pea_green = 0x52D017,
		kelly_green = 0x4CC552,
		zombie_green = 0x54C571,
		green_peas = 0x89C35C,
		dollar_bill_green = 0x85BB65,
		frog_green = 0x99C68E,
		turquoise_green = 0xA0D6B4,
		dark_sea_green = 0x8FBC8F,
		basil_green = 0x829F82,
		gray_green = 0xA2AD9C,
		iguana_green = 0x9CB071,
		citron_green = 0x8FB31D,
		acid_green = 0xB0BF1A,
		avocado_green = 0xB2C248,
		pistachio_green = 0x9DC209,
		salad_green = 0xA1C935,
		yellow_green = 0x9ACD32,
		pastel_green = 0x77DD77,
		hummingbird_green = 0x7FE817,
		nebula_green = 0x59E817,
		stoplight_go_green = 0x57E964,
		neon_green = 0x16F529,
		jade_green = 0x5EFB6E,
		lime_mint_green = 0x36F57F,
		spring_green = 0x00FF7F,
		medium_spring_green = 0x00FA9A,
		emerald_green = 0x5FFB17,
		lawn_green = 0x7CFC00,
		bright_green = 0x66FF00,
		chartreuse = 0x7FFF00,
		yellow_lawn_green = 0x87F717,
		aloe_vera_green = 0x98F516,
		dull_green_yellow = 0xB1FB17,
		lemon_green = 0xADF802,
		green_yellow = 0xADFF2F,
		chameleon_green = 0xBDF516,
		neon_yellow_green = 0xDAEE01,
		yellow_green_grosbeak = 0xE2F516,
		tea_green = 0xCCFB5D,
		slime_green = 0xBCE954,
		algae_green = 0x64E986,
		light_green = 0x90EE90,
		dragon_green = 0x6AFB92,
		pale_green = 0x98FB98,
		mint_green = 0x98FF98,
		green_thumb = 0xB5EAAA,
		organic_brown = 0xE3F9A6,
		light_jade = 0xC3FDB8,
		light_mint_green = 0xC2E5D3,
		light_rose_green = 0xDBF9DB,
		chrome_white = 0xE8F1D4,
		honeydew = 0xF0FFF0,
		mint_cream = 0xF5FFFA,
		lemon_chiffon = 0xFFFACD,
		parchment = 0xFFFFC2,
		cream = 0xFFFFCC,
		cream_white = 0xFFFDD0,
		light_goldenrod_yellow = 0xFAFAD2,
		light_yellow = 0xFFFFE0,
		beige = 0xF5F5DC,
		cornsilk = 0xFFF8DC,
		blonde = 0xFBF6D9,
		champagne = 0xF7E7CE,
		antique_white = 0xFAEBD7,
		papaya_whip = 0xFFEFD5,
		blanched_almond = 0xFFEBCD,
		bisque = 0xFFE4C4,
		wheat = 0xF5DEB3,
		moccasin = 0xFFE4B5,
		peach = 0xFFE5B4,
		light_orange = 0xFED8B1,
		peach_puff = 0xFFDAB9,
		coral_peach = 0xFBD5AB,
		navajo_white = 0xFFDEAD,
		golden_blonde = 0xFBE7A1,
		golden_silk = 0xF3E3C3,
		dark_blonde = 0xF0E2B6,
		light_gold = 0xF1E5AC,
		vanilla = 0xF3E5AB,
		tan_brown = 0xECE5B6,
		dirty_white = 0xE8E4C9,
		pale_goldenrod = 0xEEE8AA,
		khaki = 0xF0E68C,
		cardboard_brown = 0xEDDA74,
		harvest_gold = 0xEDE275,
		sun_yellow = 0xFFE87C,
		corn_yellow = 0xFFF380,
		pastel_yellow = 0xFAF884,
		neon_yellow = 0xFFFF33,
		canary_yellow = 0xFFEF00,
		banana_yellow = 0xF5E216,
		mustard_yellow = 0xFFDB58,
		golden_yellow = 0xFFDF00,
		bold_yellow = 0xF9DB24,
		rubber_ducky_yellow = 0xFFD801,
		gold = 0xFFD700,
		bright_gold = 0xFDD017,
		chrome_gold = 0xFFCE44,
		golden_brown = 0xEAC117,
		deep_yellow = 0xF6BE00,
		macaroni_and_cheese = 0xF2BB66,
		saffron = 0xFBB917,
		neon_gold = 0xFDBD01,
		beer = 0xFBB117,
		yellow_orange =  0xFFAE42,
		orange_yellow = 0xFFAE42,
		cantaloupe = 0xFFA62F,
		cheese_orange = 0xFFA600,
		brown_sand = 0xEE9A4D,
		sandy_brown = 0xF4A460,
		brown_sugar = 0xE2A76F,
		camel_brown = 0xC19A6B,
		deer_brown = 0xE6BF83,
		burly_wood = 0xDEB887,
		tan = 0xD2B48C,
		light_french_beige = 0xC8AD7F,
		sand = 0xC2B280,
		sage = 0xBCB88A,
		fall_leaf_brown = 0xC8B560,
		ginger_brown = 0xC9BE62,
		bronze_gold = 0xC9AE5D,
		dark_khaki = 0xBDB76B,
		olive_green = 0xBAB86C,
		brass = 0xB5A642,
		cookie_brown = 0xC7A317,
		metallic_gold = 0xD4AF37,
		bee_yellow = 0xE9AB17,
		school_bus_yellow = 0xE8A317,
		goldenrod = 0xDAA520,
		orange_gold = 0xD4A017,
		caramel = 0xC68E17,
		cinnamon = 0xC58917,
		peru = 0xCD853F,
		bronze = 0xCD7F32,
		tiger_orange = 0xC88141,
		copper = 0xB87333,
		dark_gold = 0xAA6C39,
		metallic_bronze = 0xA97142,
		dark_almond = 0xAB784E,
		wood = 0x966F33,
		oak_brown = 0x806517,
		antique_bronze = 0x665D1E,
		hazel = 0x8E7618,
		dark_yellow = 0x8B8000,
		dark_moccasin = 0x827839,
		khaki_green = 0x8A865D,
		millennium_jade = 0x93917C,
		dark_beige = 0x9F8C76,
		bullet_shell = 0xAF9B60,
		army_brown = 0x827B60,
		sandstone = 0x786D5F,
		taupe = 0x483C32,
		mocha = 0x493D26,
		milk_chocolate = 0x513B1C,
		gray_brown = 0x3D3635,
		dark_coffee = 0x3B2F2F,
		old_burgundy = 0x43302E,
		western_charcoal = 0x49413F,
		bakers_brown = 0x5C3317,
		dark_brown = 0x654321,
		sepia_brown = 0x704214,
		dark_bronze = 0x804A00,
		coffee = 0x6F4E37,
		brown_bear = 0x835C3B,
		red_dirt = 0x7F5217,
		sepia = 0x7F462C,
		sienna = 0xA0522D,
		saddle_brown = 0x8B4513,
		dark_sienna = 0x8A4117,
		sangria = 0x7E3817,
		blood_red = 0x7E3517,
		chestnut = 0x954535,
		coral_brown = 0x9E4638,
		chestnut_red = 0xC34A2C,
		mahogany = 0xC04000,
		red_gold = 0xEB5406,
		red_fox = 0xC35817,
		dark_bisque = 0xB86500,
		light_brown = 0xB5651D,
		petra_gold = 0xB76734,
		copper_red = 0xCB6D51,
		orange_salmon = 0xC47451,
		chocolate = 0xD2691E,
		sedona = 0xCC6600,
		papaya_orange = 0xE56717,
		halloween_orange = 0xE66C2C,
		neon_orange = 0xFF6700,
		bright_orange = 0xFF5F1F,
		pumpkin_orange = 0xF87217,
		carrot_orange = 0xF88017,
		dark_orange = 0xFF8C00,
		construction_cone_orange = 0xF87431,
		indian_saffron = 0xFF7722,
		sunrise_orange = 0xE67451,
		mango_orange = 0xFF8040,
		coral = 0xFF7F50,
		basket_ball_orange = 0xF88158,
		light_salmon_rose = 0xF9966B,
		light_salmon = 0xFFA07A,
		dark_salmon = 0xE9967A,
		tangerine = 0xE78A61,
		light_copper = 0xDA8A67,
		salmon_pink = 0xFF8674,
		salmon = 0xFA8072,
		peach_pink = 0xF98B88,
		light_coral = 0xF08080,
		pastel_red = 0xF67280,
		pink_coral = 0xE77471,
		bean_red = 0xF75D59,
		valentine_red = 0xE55451,
		indian_red = 0xCD5C5C,
		tomato = 0xFF6347,
		shocking_orange = 0xE55B3C,
		orange_red = 0xFF4500,
		neon_red = 0xFD1C03,
		ruby_red = 0xF62217,
		ferrari_red = 0xF70D1A,
		fire_engine_red = 0xF62817,
		lava_red = 0xE42217,
		love_red = 0xE41B17,
		grapefruit = 0xDC381F,
		cherry_red = 0xC24641,
		chilli_pepper = 0xC11B17,
		fire_brick = 0xB22222,
		tomato_sauce_red = 0xB21807,
		carbon_red = 0xA70D2A,
		cranberry = 0x9F000F,
		saffron_red = 0x931314,
		crimson_red = 0x990000,
		red_wine = 0x990012,
		wine_red = 0x990012,
		dark_red = 0x8B0000,
		maroon = 0x800000,
		burgundy = 0x8C001A,
		vermilion = 0x7E191B,
		deep_red = 0x800517,
		red_blood = 0x660000,
		blood_night = 0x551606,
		dark_scarlet = 0x560319,
		black_bean = 0x3D0C02,
		chocolate_brown = 0x3F000F,
		midnight = 0x2B1B17,
		purple_lily = 0x550A35,
		purple_maroon = 0x810541,
		plum_pie = 0x7D0541,
		plum_velvet = 0x7D0552,
		dark_raspberry = 0x872657,
		velvet_maroon = 0x7E354D,
		rosy_finch = 0x7F4E52,
		dull_purple = 0x7F525D,
		puce = 0x7F5A58,
		rose_dust = 0x997070,
		pastel_brown = 0xB1907F,
		rosy_pink = 0xB38481,
		rosy_brown = 0xBC8F8F,
		khaki_rose = 0xC5908E,
		lipstick_pink = 0xC48793,
		pink_brown = 0xC48189,
		old_rose = 0xC08081,
		dusty_pink = 0xD58A94,
		pink_daisy = 0xE799A3,
		rose = 0xE8ADAA,
		dusty_rose = 0xC9A9A6,
		silver_pink = 0xC4AEAD,
		gold_pink = 0xE6C7C2,
		rose_gold = 0xECC5C0,
		deep_peach = 0xFFCBA4,
		pastel_orange = 0xF8B88B,
		desert_sand = 0xEDC9AF,
		unbleached_silk = 0xFFDDCA,
		pig_pink = 0xFDD7E4,
		pale_pink = 0xF2D4D7,
		blush = 0xFFE6E8,
		misty_rose = 0xFFE4E1,
		pink_bubble_gum = 0xFFDFDD,
		light_rose = 0xFBCFCD,
		light_red = 0xFFCCCB,
		warm_pink = 0xF6C6BD,
		deep_rose = 0xFBBBB9,
		light_pink = 0xFFB6C1,
		soft_pink = 0xFFB8BF,
		donut_pink = 0xFAAFBE,
		baby_pink = 0xFAAFBA,
		flamingo_pink = 0xF9A7B0,
		pastel_pink = 0xFEA3AA,
		rose_pink = 0xE7A1B0,
		pink_rose = 0xE7A1B0,
		cadillac_pink = 0xE38AAE,
		carnation_pink = 0xF778A1,
		pastel_rose = 0xE5788F,
		blush_red = 0xE56E94,
		pale_violet_red = 0xDB7093,
		purple_pink = 0xD16587,
		tulip_pink = 0xC25A7C,
		bashful_pink = 0xC25283,
		dark_pink = 0xE75480,
		dark_hot_pink = 0xF660AB,
		hot_pink = 0xFF69B4,
		watermelon_pink = 0xFC6C85,
		violet_red = 0xF6358A,
		hot_deep_pink = 0xF52887,
		bright_pink = 0xFF007F,
		deep_pink = 0xFF1493,
		neon_pink = 0xF535AA,
		chrome_pink = 0xFF33AA,
		neon_hot_pink = 0xFD349C,
		pink_cupcake = 0xE45E9D,
		royal_pink = 0xE759AC,
		dimorphotheca_magenta = 0xE3319D,
		pink_lemonade = 0xE4287C,
		red_pink = 0xFA2A55,
		crimson = 0xDC143C,
		bright_maroon = 0xC32148,
		rose_red = 0xC21E56,
		rogue_pink = 0xC12869,
		burnt_pink = 0xC12267,
		pink_violet = 0xCA226B,
		magenta_pink = 0xCC338B,
		medium_violet_red = 0xC71585,
		dark_carnation_pink = 0xC12283,
		raspberry_purple = 0xB3446C,
		pink_plum = 0xB93B8F,
		orchid = 0xDA70D6,
		deep_mauve = 0xDF73D4,
		violet = 0xEE82EE,
		fuchsia_pink = 0xFF77FF,
		bright_neon_pink = 0xF433FF,
		fuchsia = 0xFF00FF,
		crimson_purple = 0xE238EC,
		heliotrope_purple = 0xD462FF,
		tyrian_purple = 0xC45AEC,
		medium_orchid = 0xBA55D3,
		purple_flower = 0xA74AC7,
		orchid_purple = 0xB048B5,
		rich_lilac = 0xB666D2,
		pastel_violet = 0xD291BC,
		mauve_taupe = 0x915F6D,
		viola_purple = 0x7E587E,
		eggplant = 0x614051,
		plum_purple = 0x583759,
		grape = 0x5E5A80,
		purple_navy = 0x4E5180,
		slate_blue = 0x6A5ACD,
		blue_lotus = 0x6960EC,
		blurple = 0x5865F2,
		light_slate_blue = 0x736AFF,
		medium_slate_blue = 0x7B68EE,
		periwinkle_purple = 0x7575CF,
		very_peri = 0x6667AB,
		bright_grape = 0x6F2DA8,
		purple_amethyst = 0x6C2DC7,
		bright_purple = 0x6A0DAD,
		deep_periwinkle = 0x5453A6,
		dark_slate_blue = 0x483D8B,
		purple_haze = 0x4E387E,
		purple_iris = 0x571B7E,
		dark_purple = 0x4B0150,
		deep_purple = 0x36013F,
		midnight_purple = 0x2E1A47,
		purple_monster = 0x461B7E,
		indigo = 0x4B0082,
		blue_whale = 0x342D7E,
		rebecca_purple = 0x663399,
		purple_jam = 0x6A287E,
		dark_magenta = 0x8B008B,
		purple = 0x800080,
		french_lilac = 0x86608E,
		dark_orchid = 0x9932CC,
		dark_violet = 0x9400D3,
		purple_violet = 0x8D38C9,
		jasmine_purple = 0xA23BEC,
		purple_daffodil = 0xB041FF,
		clematis_violet = 0x842DCE,
		blue_violet = 0x8A2BE2,
		purple_sage_bush = 0x7A5DC7,
		lovely_purple = 0x7F38EC,
		neon_purple = 0x9D00FF,
		purple_plum = 0x8E35EF,
		aztech_purple = 0x893BFF,
		medium_purple = 0x9370DB,
		light_purple = 0x8467D7,
		crocus_purple = 0x9172EC,
		purple_mimosa = 0x9E7BFF,
		periwinkle = 0xCCCCFF,
		pale_lilac = 0xDCD0FF,
		lavender_purple = 0x967BB6,
		rose_purple = 0xB09FCA,
		lilac = 0xC8A2C8,
		mauve = 0xE0B0FF,
		bright_lilac = 0xD891EF,
		purple_dragon = 0xC38EC7,
		plum = 0xDDA0DD,
		blush_pink = 0xE6A9EC,
		pastel_purple = 0xF2A2E8,
		blossom_pink = 0xF9B7FF,
		wisteria_purple = 0xC6AEC7,
		purple_thistle = 0xD2B9D3,
		thistle = 0xD8BFD8,
		purple_white = 0xDFD3E3,
		periwinkle_pink = 0xE9CFEC,
		cotton_candy = 0xFCDFFF,
		lavender_pinocchio = 0xEBDDE2,
		dark_white = 0xE1D9D1,
		ash_white = 0xE9E4D4,
		white_chocolate = 0xEDE6D6,
		soft_ivory = 0xFAF0DD,
		off_white = 0xF8F0E3,
		pearl_white = 0xF8F6F0,
		red_white = 0xF3E8EA,
		lavender_blush = 0xFFF0F5,
		pearl = 0xFDEEF4,
		egg_shell = 0xFFF9E3,
		old_lace = 0xFEF0E3,
		linen = 0xFAF0E6,
		sea_shell = 0xFFF5EE,
		bone_white = 0xF9F6EE,
		rice = 0xFAF5EF,
		floral_white = 0xFFFAF0,
		ivory = 0xFFFFF0,
		white_gold = 0xFFFFF4,
		light_white = 0xFFFFF7,
		white_smoke = 0xF5F5F5,
		cotton = 0xFBFBF9,
		snow = 0xFFFAFA,
		milk_white = 0xFEFCFF,
		half_white = 0xFFFEFA;
} // namespace colors

/**
 * @brief Predefined colour constants, same as colors but for the british.
 */
namespace colours = colors;
} // namespace dpp
