<?php

namespace Dpp\Generator;

use Dpp\StructGeneratorInterface;

/**
 * Generate header and .cpp file for synchronous calls (ending in '_sync')
 */
class SyncGenerator implements StructGeneratorInterface
{

    /**
     * @inheritDoc
     */
    public function generateHeaderStart(): string
    {
return <<<EOT
/************************************************************************************
 *
 * D++, A Lightweight C++ library for Discord
 *
 * Copyright 2022 Craig Edwards and D++ contributors
 * (https://github.com/brainboxdotcc/DPP/graphs/contributors)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************************/


/* Auto @generated by buildtools/make_sync_struct.php.
 *
 * DO NOT EDIT BY HAND!
 *
 * To re-generate this header file re-run the script!
 */

EOT;
    }

    /**
     * @inheritDoc
     */
    public function generateCppStart(): string
    {
        return $this->generateHeaderStart() . <<<EOT

#include <dpp/export.h>
#include <dpp/snowflake.h>
#include <dpp/cluster.h>

namespace dpp {


EOT;
    }

    /**
     * @inheritDoc
     */
    public function checkForChanges(): bool
    {
        /* Check if we need to re-generate by comparing modification times */
        $us = file_exists('include/dpp/cluster_sync_calls.h') ? filemtime('include/dpp/cluster_sync_calls.h') : 0;
        $them = filemtime('include/dpp/cluster.h');
        if ($them <= $us) {
            echo "-- No change required.\n";
            return false;
        }

        echo "-- Autogenerating include/dpp/cluster_sync_calls.h\n";
        echo "-- Autogenerating src/dpp/cluster_sync_calls.cpp\n";
        return true;
    }

    /**
     * @inheritDoc
     */
    public function generateHeaderDef(string $returnType, string $currentFunction, string $parameters, string $noDefaults, string $parameterTypes, string $parameterNames): string
    {
        return "DPP_DEPRECATED(\"Please use coroutines instead of sync functions: https://dpp.dev/coro-introduction.html\") $returnType {$currentFunction}_sync($parameters);\n\n";
    }

    /**
     * @inheritDoc
     */
    public function generateCppDef(string $returnType, string $currentFunction, string $parameters, string $noDefaults, string $parameterTypes, string $parameterNames): string
    {
        return "$returnType cluster::{$currentFunction}_sync($noDefaults) {\n\treturn dpp::sync<$returnType>(this, static_cast<void (cluster::*)($parameterTypes". (!empty($parameterTypes) ? ", " : "") . "command_completion_event_t)>(&cluster::$currentFunction)$parameterNames);\n}\n\n";
    }

    /**
     * @inheritDoc
     */
    public function getCommentArray(): array
    {
        return [
            " * \memberof dpp::cluster",
            " * @throw dpp::rest_exception upon failure to execute REST function",
            " * @deprecated This function is deprecated, please use coroutines instead.",
            " * @warning This function is a blocking (synchronous) call and should only be used from within a separate thread.",
            " * Avoid direct use of this function inside an event handler.",
        ];
    }

    /**
     * @inheritDoc
     */
    public function saveHeader(string $content): void
    {
        file_put_contents('include/dpp/cluster_sync_calls.h', $content);
    }

    /**
     * @inheritDoc
     */
    public function saveCpp(string $cppcontent): void
    {
        file_put_contents('src/dpp/cluster_sync_calls.cpp', $cppcontent);
    }    
}