package truetype

import (
	"encoding/binary"
	"fmt"
)

// Code generated by bin-parser-gen. DO NOT EDIT

func (va *VarAxis) mustParse(data []byte) {
	_ = data[19] // early bound checking
	va.Tag = Tag(binary.BigEndian.Uint32(data[0:4]))
	va.Minimum = Float1616FromUint(binary.BigEndian.Uint32(data[4:8]))
	va.Default = Float1616FromUint(binary.BigEndian.Uint32(data[8:12]))
	va.Maximum = Float1616FromUint(binary.BigEndian.Uint32(data[12:16]))
	va.flags = uint16(binary.BigEndian.Uint16(data[16:18]))
	va.strid = NameID(binary.BigEndian.Uint16(data[18:20]))
}

func parseVarAxis(data []byte) (VarAxis, error) {
	var out VarAxis
	if L := len(data); L < 20 {
		return VarAxis{}, fmt.Errorf("EOF: expected length: 20, got %d", L)
	}
	out.mustParse(data)
	return out, nil
}
func (va VarAxis) writeTo(data []byte) {
	_ = data[19] // early bound checking
	binary.BigEndian.PutUint32(data, uint32(va.Tag))
	binary.BigEndian.PutUint32(data[4:], uint32(Float1616ToUint(va.Minimum)))
	binary.BigEndian.PutUint32(data[8:], uint32(Float1616ToUint(va.Default)))
	binary.BigEndian.PutUint32(data[12:], uint32(Float1616ToUint(va.Maximum)))
	binary.BigEndian.PutUint16(data[16:], uint16(va.flags))
	binary.BigEndian.PutUint16(data[18:], uint16(va.strid))
}

func (va VarAxis) appendTo(data []byte) []byte {
	L := len(data)
	data = append(data, make([]byte, 20)...)
	dst := data[L:]
	va.writeTo(dst)
	return data
}

func (fh *fvarHeader) mustParse(data []byte) {
	_ = data[15] // early bound checking
	fh.majorVersion = uint16(binary.BigEndian.Uint16(data[0:2]))
	fh.minorVersion = uint16(binary.BigEndian.Uint16(data[2:4]))
	fh.axesArrayOffset = uint16(binary.BigEndian.Uint16(data[4:6]))
	fh.reserved = uint16(binary.BigEndian.Uint16(data[6:8]))
	fh.axisCount = uint16(binary.BigEndian.Uint16(data[8:10]))
	fh.axisSize = uint16(binary.BigEndian.Uint16(data[10:12]))
	fh.instanceCount = uint16(binary.BigEndian.Uint16(data[12:14]))
	fh.instanceSize = uint16(binary.BigEndian.Uint16(data[14:16]))
}

func parseFvarHeader(data []byte) (fvarHeader, error) {
	var fh fvarHeader
	if l := len(data); l < 16 {
		return fvarHeader{}, fmt.Errorf("EOF: expected length: 16, got %d", l)
	}
	fh.mustParse(data)
	return fh, nil
}
func (fh fvarHeader) writeTo(data []byte) {
	_ = data[15] // early bound checking
	binary.BigEndian.PutUint16(data, uint16(fh.majorVersion))
	binary.BigEndian.PutUint16(data[2:], uint16(fh.minorVersion))
	binary.BigEndian.PutUint16(data[4:], uint16(fh.axesArrayOffset))
	binary.BigEndian.PutUint16(data[6:], uint16(fh.reserved))
	binary.BigEndian.PutUint16(data[8:], uint16(fh.axisCount))
	binary.BigEndian.PutUint16(data[10:], uint16(fh.axisSize))
	binary.BigEndian.PutUint16(data[12:], uint16(fh.instanceCount))
	binary.BigEndian.PutUint16(data[14:], uint16(fh.instanceSize))
}

func (fh fvarHeader) appendTo(data []byte) []byte {
	L := len(data)
	data = append(data, make([]byte, 16)...)
	dst := data[L:]
	fh.writeTo(dst)
	return data
}
