## बैश वेरिएबल्स
किसी भी अन्य प्रोग्रामिंग भाषा की तरह, आप बैश स्क्रिप्टिंग में भी वेरिएबल्स का उपयोग कर सकते हैं। हालांकि, यहाँ कोई डेटा प्रकार नहीं है, और बैश में एक वेरिएबल नंबर और वर्ण दोनों शामिल कर सकता है।

एक वेरिएबल को मूल्य सौंपने के लिए, आपको बस = चिह्न का उपयोग करना है:
```bash
name="डेवडोजो"
```
ध्यान दें: एक महत्वपूर्ण नोट के रूप में, = चिह्न के आस-पास स्थानों नहीं हो सकता।

इसके बाद, वेरिएबल तक पहुँचने के लिए, आपको $ चिह्न का उपयोग करना होगा और निम्नलिखित रूप से संदर्भित करना होगा:
```bash
echo $name
```
वेरिएबल नाम को कुवच ब्रैकेट्स के बीच रखना आवश्यक नहीं है, लेकिन यह एक अच्छी अभ्यास समझा जाता है, और मैं आपसे सलाह दूंगा कि जब भी आप इस्तेमाल कर सकें, तो इन्हें उपयोग करें:
```bash
echo ${name}
```
उपरोक्त कोड  उत्पादित करेगा: डेवडोजो क्योंकि यह हमारे नाम वेरिएबल की मूल्य है।

आगे, चलो हमारी devdojo.sh स्क्रिप्ट को अपडेट करें और इसमें एक वेरिएबल शामिल करें। फिर से, आप अपने पसंदीदा पाठ संपादक के साथ फ़ाइल devdojo.sh खोल सकते हैं, यहाँ मैं तो नैनो उपयोग कर रहा हूँ फ़ाइल खोलने के लिए:
```bash
nano devdojo.sh
```
यहां फ़ाइल में हमारे नाम वेरिएबल को शामिल करें, स्वागत संदेश के साथ। हमारी फ़ाइल अब इस तरह दिखती है:
```bash
#!/bin/bash
name="डेवडोजो"
echo "नमस्ते $name"
```
इसे सहेजें और निम्नलिखित कमांड का उपयोग करके फ़ाइल को चलाएं:
```bash
./devdojo.sh
```
आपको अपने स्क्रीन पर निम्नलिखित आउटपुट दिखेगा:
```bash
नमस्ते डेवडोजो
```
यहाँ फ़ाइल में लिखी गई स्क्रिप्ट की एक ब्रीफ़ रनडाउन है:
- `#!/bin/bash` - पहले, हमने अपनी शेबैंग को निर्दिष्ट किया।
- `name=डेवडोजो` - तब, हमने एक वेरिएबल name निर्धारित किया और उसे एक मूल्य सौंपा।
- `echo "नमस्ते $name"` - आख़िरकार, हमने वेरिएबल की सामग्री को शास्त्र परिचय के रूप में स्क्रीन पर उत्पन्न किया, `echo` का उपयोग करके।
आप बैश स्क्रिप्ट के बाहर कमांड लाइन में भी वेरिएबल्स जोड़ सकते हैं और उन्हें पैरामीटर्स के रूप में पढ़ा जा सकता है:
```bash
./devdojo.sh बॉबी दोस्त!
```
यह स्क्रिप्ट बॉबी और दोस्त! नामक दो पैरामीटर्स को स्वीकार करती है, जिन्हें अंतर स्थान से विभाजित किया जाता है। devdojo.sh फ़ाइल में हमारे पास निम्नलिखित है:
```bash
#!/bin/bash
echo "नमस्ते वहाँ" $1
```
$1 वहाँ वाले पहले इनपुट (बॉबी) को कमांड लाइन में संदर्भित करता है। इसी तरह, अधिक इनपुट्स हो सकते हैं और वे सभी $ चिह्न से संदर्भित किए जाते हैं और उनके संदर्भण क्रम के अनुसार। इसका मतलब है कि दोस्त! को $2 का उपयोग करके संदर्भित किया जाता है। वेरिएबल्स को पढ़ने के लिए एक और उपयोगी विधि $@ है जो सभी इनपुट्स को पढ़ता है।

इसलिए अब चलो devdojo.sh फ़ाइल को बेहतर समझने के लिए बदलते हैं:
```bash
#!/bin/bash
echo "नमस्ते वहाँ" $1
# $1 : पहला पैरामीटर
echo "नमस्ते वहाँ" $2
# $2 : दूसरा पैरामीटर
echo "नमस्ते वहाँ" $@
# $@ : सभी
```
इसका आउटपुट:
```bash
./devdojo.sh बॉबी दोस्त!
```
निम्नलिखित होगा:
```bash
नमस्ते बॉबी
नमस्ते दोस्त!
नमस्ते बॉबी दोस्त!
```