<p align="center"><img src="https://imgur.com/eXCcDPp.png" height="450" width="auto"></p>

<div align="center">
    <p>
	    <a name="stars"><img src="https://img.shields.io/github/stars/bobbyiliev/introduction-to-bash-scripting?style=for-the-badge"></a>
	    <a name="forks"><img src="https://img.shields.io/github/forks/bobbyiliev/introduction-to-bash-scripting?logoColor=green&style=for-the-badge"></a>
	    <a name="contributions"><img src="https://img.shields.io/github/contributors/bobbyiliev/introduction-to-bash-scripting?logoColor=green&style=for-the-badge"></a>
	    <a name="madeWith"><img src="https://img.shields.io/badge/Made%20with-Markdown-1f425f.svg?style=for-the-badge"></a>
	    <a name="license"><img src="https://img.shields.io/github/license/bobbyiliev/introduction-to-bash-scripting?style=for-the-badge"></a>
    </p>
</div>

## 💡 Introduction to Bash Scripting

This is an open-source introduction to Bash scripting guide/ebook that will help you learn the basics of Bash scripting and start writing awesome Bash scripts that will help you automate your daily SysOps, DevOps, and Dev tasks. No matter if you are a DevOps/SysOps engineer, developer, or just a Linux enthusiast, you can use Bash scripts to combine different Linux commands and automate boring and repetitive daily tasks, so that you can focus on more productive and fun things.

The guide is suitable for anyone working as a developer, system administrator, or a DevOps engineer and wants to learn the basics of Bash scripting.

## 🚀 Download

To download a copy of the ebook use one of the following links:

* [Dark mode](https://github.com/bobbyiliev/introduction-to-bash-scripting/raw/main/ebook/en/export/introduction-to-bash-scripting-dark.pdf)

* [Light mode](https://github.com/bobbyiliev/introduction-to-bash-scripting/raw/main/ebook/en/export/introduction-to-bash-scripting-light.pdf)

* [ePub](https://github.com/bobbyiliev/introduction-to-bash-scripting/raw/main/ebook/en/export/introduction-to-bash-scripting.epub)

## 📘 Chapters

The first 13 chapters would be purely focused on getting some solid Bash scripting foundations then the rest of the chapters would give you some real life examples and scripts.

* [**About the book**](ebook/en/content/000-about-the-author.md)
* [**Introduction to Bash scripting**](ebook/en/content/001-introduction-to-bash.md)
* [**Bash Structure**](ebook/en/content/002-bash-structure.md)
* [**Bash Hello World**](ebook/en/content/003-bash-hello-world.md)
* [**Bash Variables**](ebook/en/content/004-bash-variables.md)
* [**Bash User Input**](ebook/en/content/005-bash-user-input.md)
* [**Bash Comments**](ebook/en/content/006-bash-comments.md)
* [**Bash Arguments**](ebook/en/content/007-bash-arguments.md)
* [**Bash Arrays**](ebook/en/content/008-bash-arrays.md)
* [**Bash Conditional Expressions**](ebook/en/content/009-bash-conditional-expressions.md)
* [**Bash Conditionals**](ebook/en/content/010-bash-conditionals.md)
* [**Bash Loops**](ebook/en/content/011-bash-loops.md)
* [**Bash Functions**](ebook/en/content/012-bash-functions.md)
* [**Debugging, testing and shortcuts**](ebook/en/content/013-debugging-and-testing.md)
* [**Creating custom bash commands**](ebook/en/content/014-creating-custom-bash-commands.md)
* [**Write your first Bash script**](ebook/en/content/015-writing-your-first-bash-script.md)
* [**Creating an interactive menu in Bash**](ebook/en/content/016-creating-an-interactive-menu-in-bash.md)
* [**Executing BASH scripts on Multiple Remote Servers**](ebook/en/content/017-executing-bash-script-on-multiple-remote-server.md)
* [**Work with JSON in BASH using jq**](ebook/en/content/018-working-with-json-in-bash-using-jq.md)
* [**Working with Cloudflare API with Bash**](ebook/en/content/019-working-with-cloudflare-api-with-bash.md)
* [**BASH Script parser to Summarize Your NGINX and Apache Access Logs**](ebook/en/content/020-nginx-and-apache-log-parser.md)
* [**Sending emails with Bash and SSMTP**](ebook/en/content/021-how-to-send-emails-with-bash.md)
* [**Bash Password Generator**](ebook/en/content/022-bash-password-generator.md)
* [**Redirection in Bash**](ebook/en/content/023-bash-redirection.md)
* [**Wrap Up**](ebook/en/content/100-bash-wrap-up.md)

## 🌟 Sponsors

This book is made possible thanks to these fantastic companies!

### 📊 Materialize

The Streaming Database for Real-time Analytics.

[Materialize](https://materialize.com/) is a reactive database that delivers incremental view updates. Materialize helps developers easily build with streaming data using standard SQL.

### 💙 DigitalOcean

DigitalOcean is a cloud services platform delivering the simplicity developers love and businesses trust to run production applications at scale.

It provides highly available, secure, and scalable compute, storage, and networking solutions that help developers build great software faster.

Founded in 2012 with offices in New York and Cambridge, MA, DigitalOcean offers transparent and affordable pricing, an elegant user interface, and one of the largest libraries of open source resources available.

For more information, please visit [https://www.digitalocean.com](https://www.digitalocean.com) or follow [@digitalocean](https://twitter.com/digitalocean) on Twitter.

If you are new to DigitalOcean, you can get a free $100 credit and spin up your own servers via this referral link here:

[Free $100 Credit For DigitalOcean](https://m.do.co/c/2a9bba940f39)

### 👩‍💻 DevDojo

The DevDojo is a resource to learn all things web development and web design. Learn on your lunch break or wake up and enjoy a cup of coffee with us to learn something new.

Join this developer community, and we can all learn together, build together, and grow together.

[Join DevDojo](https://devdojo.com?ref=bobbyiliev)

For more information, please visit [https://www.devdojo.com](https://www.devdojo.com?ref=bobbyiliev) or follow [@thedevdojo](https://twitter.com/thedevdojo) on Twitter.

## 🕸️ Web Page

A web page showcasing the eBook:

[Introduction to Bash Scripting Web Page](https://ebook.bobby.sh/)

The web page was built using [Tails](http://devdojo.com/tails), a new `kick-ass` drag-and-drop TailwindCSS page builder!

### DigitalOcean App Platform

The [website](https://ebook.bobby.sh) is hosted on the [DigitalOcean App Platform](https://www.digitalocean.com/products/app-platform/).

We utilize the ["Deploy to DigitalOcean" Button](https://www.digitalocean.com/docs/app-platform/how-to/add-deploy-do-button) to deploy to the App Platform:

[![Deploy to DO](https://mp-assets1.sfo2.digitaloceanspaces.com/deploy-to-do/do-btn-blue.svg)](https://cloud.digitalocean.com/apps/new?repo=https://github.com/bobbyiliev/introduction-to-bash-scripting/tree/main)

## 📹 Mini Video Course

If you prefer watching videos rather than reading, you can find a quick crash course based on the first 12 chapters of the eBook here:

**[Introduction to Bash Scripting Mini Video Crash Course](https://www.youtube.com/playlist?list=PLY7SzAmnEqp78tsHh1kK0gOx_f-uwQZAT)**

## 👋 About the author

My name is Bobby Iliev, and I have been working as a Linux DevOps Engineer since 2014. I am an avid Linux lover and supporter of the open-source movement philosophy. I am always doing that which I cannot do in order that I may learn how to do it, and I believe in sharing knowledge.

I think it's essential always to keep professional and surround yourself with good people, work hard, and be nice to everyone. You have to perform at a consistently higher level than others. That's the mark of a true professional.

For more information, please visit my blog at [https://bobbyiliev.com](https://bobbyiliev.com), follow me on Twitter [@bobbyiliev_](https://twitter.com/bobbyiliev_) and [YouTube](https://www.youtube.com/channel/UCQWmdHTeAO0UvaNqve9udRw).

In case that you want to support me you can Buy Me a Coffee here:

<a href="https://www.buymeacoffee.com/bobbyiliev" target="_blank"><img src="https://www.buymeacoffee.com/assets/img/custom_images/orange_img.png" alt="Buy Me A Coffee" style="height: 41px !important;width: 174px !important;box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;-webkit-box-shadow: 0px 3px 2px 0px rgba(190, 190, 190, 0.5) !important;" ></a>

## 🔥 PDF Generation Tool

The project uses [Ibis](https://github.com/themsaid/ibis/) developed by [Mohamed Said](https://github.com/themsaid).

Ibis is a PHP tool that helps you write eBooks in markdown.

## 🎨 Book Cover

The cover for this ebook was created with [Canva.com](https://www.canva.com/join/determined-cork-learn).

If you ever need to create a graphic, poster, invitation, logo, presentation – or anything that looks good — give Canva a go.

## 🔗 Links

- [My blog](https://bobbyiliev.com)
- [Free $100 Credit For DigitalOcean](https://m.do.co/c/2a9bba940f39)
- [Join DevDojo](https://devdojo.com?ref=bobbyiliev)
- [Ibis](https://github.com/themsaid/ibis/)
- [Canva](https://www.canva.com/)
- [Tails](http://devdojo.com/tails)

## 📖 Other eBooks

- [Introduction to Docker](https://github.com/bobbyiliev/introduction-to-docker-ebook)
- [Introduction to Git and GitHub](https://github.com/bobbyiliev/introduction-to-git-and-github-ebook)
- [Introduction to SQL](https://github.com/bobbyiliev/introduction-to-sql)
- [Laravel tips and tricks](https://github.com/bobbyiliev/laravel-tips-and-tricks-ebook)
- [Introduction to Terraform](https://leanpub.com/introduction-to-terraform)
- [Introduction to Linux](https://leanpub.com/introduction-to-linux)

## 🤲 Contributing

If you are contributing 🍿 please read the [contributing file](CONTRIBUTING.md) before submitting your pull requests.
