# Security Policy

<!--
For those who are viewing the current markdown file using:
 – VSCode: Press F1 or Cmd/Ctrl+Shift+P and enter ">Markdown: Open Preview". Please install the "markdownlint" and "Markdown All in One" extensions.
 – GitHub: Does this .md file appear different from what you are used to seeing on GitHub? Ensure the URL does not end with "?plain=1".
-->

## Supported Versions

Our commitment to security extends to the following version of the project:

| Version | Supported          |
| ------- | ------------------ |
| @latest | :white_check_mark: |

## Reporting a Vulnerability

We greatly value the security community's efforts in helping keep our project safe. If you've discovered a security vulnerability, the responsible disclosure is crucial for us. Here's how you can report it:

1. **Contact Method**: Email us at <blefnk@gmail.com>.
2. **Email Subject**: Please use a concise yet descriptive subject, such as "Security Vulnerability Found".
3. **Vulnerability Details**: Provide a comprehensive description of the vulnerability. Include reproduction steps, and any other information that might help us understand and resolve the issue effectively.
4. **Proof of Concept**: Attach any proof-of-concept or sample code if available. Please ensure that the research does not involve destructive testing or violate any laws.
5. **Encryption**: For secure communication, use our public PGP key available on our website or public key servers.
6. **Response Timeline**: We aim to acknowledge the report within [e.g., 48 hours] and will keep you updated on our progress.
7. **Investigation and Remediation**: Our team will promptly investigate and work on resolving the issue. We'll maintain communication with you throughout this process.
8. **Disclosure Policy**: Please refrain from public disclosure until we have mitigated the vulnerability. We will collaborate with you to decide on an appropriate disclosure timeline, considering the issue's severity.

We're grateful for the contributions to our project's security. Contributors who help improve our security may be publicly acknowledged (with consent).

*Note: Our security policy may be updated periodically.*
