# Contributing

<!--
For those who are viewing the current markdown file using:
 – VSCode: Press F1 or Cmd/Ctrl+Shift+P and enter ">Markdown: Open Preview". Please install the "markdownlint" and "Markdown All in One" extensions.
 – GitHub: Does this .md file appear different from what you are used to seeing on GitHub? Ensure the URL does not end with "?plain=1".
-->

[![Join the Reliverse Discord](https://discordapp.com/api/guilds/1075533942096150598/widget.png?style=banner2)][bleverse-discord]

Welcome, and thank you for considering contributing to this project! Your involvement is vital to the growth and success of this open-source initiative.

## Getting Started

- **Fork and Setup**: Initiate your contribution journey by forking the repository. Follow the setup instructions in [README.md](../README.md) for guidance.
- **Code of Conduct**: Be familiar with our [Code of Conduct](./CODE_OF_CONDUCT.md). Adherence to these principles is expected from all community members.

## Contribution Guidelines

### Legal Compliance

- **Originality**: Ensure that your contributions are entirely original work.
- **Rights**: Verify that you hold the necessary rights to your contributions.
- **License Adherence**: All contributions must align with the project's licensing terms.

### Pull Request Protocol

- **UI Contributions**: For UI-related changes, utilize the [UI Pull Request Template](.github/ISSUE_TEMPLATE/FEATURE_REQUEST.yml). Include screenshots to facilitate the review process.
- **General Contributions**: For other types of contributions, employ the [General Template](.github/ISSUE_TEMPLATE/FEATURE_REQUEST.yml). Provide a description of your contribution.

### Bug Reporting Process

#### Preliminary Steps

- **Research**: Confirm that the bug has not been reported already.
- **Comprehensive Information**: Compile all relevant details to accurately depict the issue.

#### How to Submit a Bug Report

- **GitHub Issues**: Utilize [GitHub Issues](https://github.com/blefnk/relivator-nextjs-template/issues/new) for reporting bugs.
- **Clarity and Detail**: Clearly articulate both the expected and actual behaviors, and describe the steps to replicate the bug.
- **Security Concerns**: For reporting security vulnerabilities, please contact us directly at <blefnk@gmail.com> instead of using public channels.

### Enhancement Proposals

#### Preliminary Considerations

- **Version Check**: Ensure you're working with the latest version of the software.
- **Existing Suggestions**: Search [GitHub Issues](https://github.com/blefnk/relivator-nextjs-template/issues?q=) and our [Discord Suggestions Channel](https://discord.com/channels/1075533942096150598/1196425440777224212) to see if the suggestion has already been made.
- **Project Alignment**: Assess whether the suggestion is in line with the project's objectives.

#### How to Suggest Enhancements

- **Descriptive Title**: Choose a title that succinctly describes the enhancement.
- **Detailed Proposal**: Provide a step-by-step breakdown of the suggested enhancement.
- **Justification**: Explain why this enhancement would be valuable to the project.

### Making the First Code Contribution

1. **Issue Selection**: Choose an issue from [GitHub issues](https://github.com/blefnk/relivator-nextjs-template/issues?q=) and request its assignment.
2. **Fork and Branch Creation**: Fork the repository and create a new branch, naming it after the issue number.
3. **Committing Changes**: Adhere to a clear commit style, referencing the issue in the PR or commit message.
4. **Submitting a Pull Request**: Propose the changes through a pull request from the forked repository.

## Additional Resources

### Examples of Effective Commit Names

| 🟢 Effective Example                                | 🟡 Less Effective Example | 🔴 Poor Example    |
| --------------------------------------------------- | ------------------------- | ------------------ |
| add(i18n): add internationalization support for RSC | added new stuff           | YOOOOOO            |
| reposition cart for user convenience                | fixing cart issue         | fixing the thing   |
| 📚 upd(docs): fix typos in README                   | doc updates               | (docs)Trust me bro |

[bleverse-discord]: https://discord.gg/Pb8uKbwpsJ
