# Code of Conduct

<!--
For those who are viewing the current markdown file using:
 – VSCode: Press F1 or Cmd/Ctrl+Shift+P and enter ">Markdown: Open Preview". Please install the "markdownlint" and "Markdown All in One" extensions.
 – GitHub: Does this .md file appear different from what you are used to seeing on GitHub? Ensure the URL does not end with "?plain=1".
-->

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to make participating in our project and community a harassment-free experience for everyone, regardless of individual differences.

We commit to creating a friendly and respectful place for learning, teaching, and contributing. All participants in our community are expected to show respect and courtesy to others.

## Our Standards

**Positive Behaviors to Encourage:**

- Demonstrating empathy and kindness
- Being respectful of varying opinions and viewpoints
- Giving and receiving constructive feedback
- Owning up to our mistakes and learning from them
- Prioritizing community well-being and success

**Unacceptable Behaviors Include:**

- Use of sexualized language or imagery, and unwelcome sexual attention or advances
- Trolling, insulting/derogatory comments, and personal or political attacks
- Public or private harassment
- Publishing private information without consent
- Inappropriate private contact without consent
- Other conduct deemed unprofessional in a community setting

## Enforcement Responsibilities

Our community leaders are tasked with clarifying these standards and enforcing them, taking fair and appropriate action to address any instances of unacceptable behavior.

Leaders have the authority to moderate comments, commits, code, and other contributions not in line with this Code of Conduct.

## Scope

This Code of Conduct applies within all project spaces, and also when an individual is representing the project or its community in public spaces.

## Enforcement Process

Inappropriate behavior can be reported to community leaders at <blefnk@gmail.com>. All complaints will be reviewed and investigated and will result in a response deemed necessary and appropriate to the circumstances.

## Enforcement Guidelines

Leaders will follow these guidelines in determining consequences:

### 1. Correction

**Impact**: Inappropriate language or behavior.

**Consequence**: Private warning and clarity on why the behavior was inappropriate. A public apology may be requested.

### 2. Warning

**Impact**: A single or series of violations.

**Consequence**: A warning with consequences for continued behavior. No interaction with those involved for a set period, including community and external channels. Continued violation may lead to a ban.

### 3. Temporary Ban

**Impact**: Serious or sustained inappropriate behavior.

**Consequence**: Temporary ban from interaction or public communication with the community. No interaction with those involved is allowed. Further violation may lead to a permanent ban.

### 4. Permanent Ban

**Impact**: Pattern of serious violations.

**Consequence**: Permanent ban from public interaction within the community.

## Attribution

This Code of Conduct is adapted from the Contributor Covenant and Mozilla's code of conduct enforcement ladder.

- [Contributor Covenant](https://contributor-covenant.org/version/2/0/code_of_conduct.html)
- [Mozilla's Enforcement Ladder](https://github.com/mozilla/diversity)

For FAQs and translations, visit [Contributor Covenant FAQ](https://contributor-covenant.org/faq) and [Translations](https://contributor-covenant.org/translations).
