const STRING_DASHERIZE_REGEXP = /[ _.]/g;
const STRING_DECAMELIZE_REGEXP = /([a-z\d])([A-Z])/g;

function decamelize(str: string): string {
  return str.replace(STRING_DECAMELIZE_REGEXP, '$1_$2').toLowerCase();
}

export function dasherize(str: string): string {
  return decamelize(str).replace(STRING_DASHERIZE_REGEXP, '-');
}
