export { SkyAlertModule } from './lib/modules/alert/alert.module';

export { SkyChevronModule } from './lib/modules/chevron/chevron.module';

export { SkyExpansionIndicatorModule } from './lib/modules/expansion-indicator/expansion-indicator.module';

export { SkyIllustrationResolverService } from './lib/modules/illustration/illustration-resolver.service';
export { SkyIllustrationSize } from './lib/modules/illustration/illustration-size';
export { SkyIllustrationModule } from './lib/modules/illustration/illustration.module';

export { SkyKeyInfoLayoutType } from './lib/modules/key-info/key-info-layout-type';
export { SkyKeyInfoModule } from './lib/modules/key-info/key-info.module';

export { SkyLabelType } from './lib/modules/label/label-type';
export { SkyLabelModule } from './lib/modules/label/label.module';

export { SkyIndicatorDescriptionType } from './lib/modules/shared/indicator-description-type';
export { SkyIndicatorIconType } from './lib/modules/shared/indicator-icon-type';

export { SkyStatusIndicatorModule } from './lib/modules/status-indicator/status-indicator.module';

export { SkyTextHighlightModule } from './lib/modules/text-highlight/text-highlight.module';

export { SkyTokensModule } from './lib/modules/tokens/tokens.module';
export { SkyToken } from './lib/modules/tokens/types/token';
export { SkyTokenSelectedEventArgs } from './lib/modules/tokens/types/token-selected-event-args';
export { SkyTokensMessage } from './lib/modules/tokens/types/tokens-message';
export { SkyTokensMessageType } from './lib/modules/tokens/types/tokens-message-type';

export { SkyWaitModule } from './lib/modules/wait/wait.module';
export { SkyWaitService } from './lib/modules/wait/wait.service';

// Components and directives must be exported to support Angular's "partial" Ivy compiler.
// Obscure names are used to indicate types are not part of the public API.
export { SkyAlertComponent as λ1 } from './lib/modules/alert/alert.component';
export { SkyChevronComponent as λ2 } from './lib/modules/chevron/chevron.component';
export { SkyExpansionIndicatorComponent as λ15 } from './lib/modules/expansion-indicator/expansion-indicator.component';
export { SkyKeyInfoLabelComponent as λ6 } from './lib/modules/key-info/key-info-label.component';
export { SkyKeyInfoValueComponent as λ7 } from './lib/modules/key-info/key-info-value.component';
export { SkyKeyInfoComponent as λ8 } from './lib/modules/key-info/key-info.component';
export { SkyLabelComponent as λ9 } from './lib/modules/label/label.component';
export { SkyStatusIndicatorComponent as λ10 } from './lib/modules/status-indicator/status-indicator.component';
export { SkyTextHighlightDirective as λ11 } from './lib/modules/text-highlight/text-highlight.directive';
export { SkyTokenComponent as λ12 } from './lib/modules/tokens/token.component';
export { SkyTokensComponent as λ13 } from './lib/modules/tokens/tokens.component';
export { SkyWaitComponent as λ14 } from './lib/modules/wait/wait.component';
export { SkyTextHighlightDirective } from './lib/modules/text-highlight/text-highlight.directive';
export { SkyIllustrationComponent as λ16 } from './lib/modules/illustration/illustration.component';

/**
 * @deprecated Use `@skyux/help-inline` instead.
 */
export { SkyHelpInlineModule, λ1 as λ3 } from '@skyux/help-inline';

/**
 * @deprecated Use `@skyux/icon` instead.
 */
export {
  SkyIconStackItem,
  SkyIconModule,
  SkyIconType,
  SkyIconVariantType,
  λ1 as λ4,
  λ2 as λ5,
} from '@skyux/icon';
