import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  ViewEncapsulation,
} from '@angular/core';

import { ICellRendererAngularComp } from 'ag-grid-angular';
import { ICellRendererParams } from 'ag-grid-community';

@Component({
  standalone: true,
  selector: 'app-custom-multiline',
  templateUrl: './custom-multiline.component.html',
  encapsulation: ViewEncapsulation.None,
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class CustomMultilineComponent implements ICellRendererAngularComp {
  public lines: number;

  constructor(private changeDetectorRef: ChangeDetectorRef) {}

  public agInit(params: ICellRendererParams): void {
    this.lines = (params.node?.rowIndex - 3) % 5;
    this.changeDetectorRef.detectChanges();
  }

  public refresh(params: ICellRendererParams): boolean {
    this.agInit(params);
    return true;
  }
}
