// Source: https://github.com/metmuseum/openaccess
import { SkyCellType } from '@skyux/ag-grid';

import { ColDef } from 'ag-grid-community';

/* spell-checker:disable */
export const columnDefinitions: ColDef[] = [
  {
    field: 'select',
    headerName: ' ',
    type: [SkyCellType.RowSelector],
  },
  {
    field: 'object_number',
    headerName: 'Object Number',
    type: [],
    sortable: true,
  },
  {
    field: 'is_highlight',
    headerName: 'Is Highlight',
    type: [],
    sortable: true,
  },
  {
    field: 'is_timeline_work',
    headerName: 'Is Timeline Work',
    type: [],
    sortable: true,
  },
  {
    field: 'is_public_domain',
    headerName: 'Is Public Domain',
    type: [],
    sortable: true,
  },
  {
    field: 'object_id',
    headerName: 'Object ID',
    type: [],
    sortable: true,
  },
  {
    field: 'gallery_number',
    headerName: 'Gallery Number',
    type: [],
    sortable: true,
  },
  {
    field: 'department',
    headerName: 'Department',
    type: [],
    sortable: true,
  },
  {
    field: 'accessionyear',
    headerName: 'AccessionYear',
    type: [],
    sortable: true,
  },
  {
    field: 'object_name',
    headerName: 'Object Name',
    type: [],
    sortable: true,
  },
  {
    field: 'title',
    headerName: 'Title',
    type: [],
    sortable: true,
  },
  {
    field: 'culture',
    headerName: 'Culture',
    type: [],
    sortable: true,
  },
  {
    field: 'period',
    headerName: 'Period',
    type: [],
    sortable: true,
  },
  {
    field: 'dynasty',
    headerName: 'Dynasty',
    type: [],
    sortable: true,
  },
  {
    field: 'reign',
    headerName: 'Reign',
    type: [],
    sortable: true,
  },
  {
    field: 'portfolio',
    headerName: 'Portfolio',
    type: [],
    sortable: true,
  },
  {
    field: 'constituent_id',
    headerName: 'Constituent ID',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_role',
    headerName: 'Artist Role',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_prefix',
    headerName: 'Artist Prefix',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_display_name',
    headerName: 'Artist Display Name',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_display_bio',
    headerName: 'Artist Display Bio',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_suffix',
    headerName: 'Artist Suffix',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_alpha_sort',
    headerName: 'Artist Alpha Sort',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_nationality',
    headerName: 'Artist Nationality',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_begin_date',
    headerName: 'Artist Begin Date',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_end_date',
    headerName: 'Artist End Date',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_gender',
    headerName: 'Artist Gender',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_ulan_url',
    headerName: 'Artist ULAN URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'artist_wikidata_url',
    headerName: 'Artist Wikidata URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'object_date',
    headerName: 'Object Date',
    type: [],
    sortable: true,
  },
  {
    field: 'object_begin_date',
    headerName: 'Object Begin Date',
    type: [],
    sortable: true,
  },
  {
    field: 'object_end_date',
    headerName: 'Object End Date',
    type: [],
    sortable: true,
  },
  {
    field: 'medium',
    headerName: 'Medium',
    type: [],
    sortable: true,
  },
  {
    field: 'dimensions',
    headerName: 'Dimensions',
    type: [],
    sortable: true,
  },
  {
    field: 'credit_line',
    headerName: 'Credit Line',
    type: [],
    sortable: true,
  },
  {
    field: 'geography_type',
    headerName: 'Geography Type',
    type: [],
    sortable: true,
  },
  {
    field: 'city',
    headerName: 'City',
    type: [],
    sortable: true,
  },
  {
    field: 'state',
    headerName: 'State',
    type: [],
    sortable: true,
  },
  {
    field: 'county',
    headerName: 'County',
    type: [],
    sortable: true,
  },
  {
    field: 'country',
    headerName: 'Country',
    type: [],
    sortable: true,
  },
  {
    field: 'region',
    headerName: 'Region',
    type: [],
    sortable: true,
  },
  {
    field: 'subregion',
    headerName: 'Subregion',
    type: [],
    sortable: true,
  },
  {
    field: 'locale',
    headerName: 'Locale',
    type: [],
    sortable: true,
  },
  {
    field: 'locus',
    headerName: 'Locus',
    type: [],
    sortable: true,
  },
  {
    field: 'excavation',
    headerName: 'Excavation',
    type: [],
    sortable: true,
  },
  {
    field: 'river',
    headerName: 'River',
    type: [],
    sortable: true,
  },
  {
    field: 'classification',
    headerName: 'Classification',
    type: [],
    sortable: true,
  },
  {
    field: 'rights_and_reproduction',
    headerName: 'Rights and Reproduction',
    type: [],
    sortable: true,
  },
  {
    field: 'link_resource',
    headerName: 'Link Resource',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'object_wikidata_url',
    headerName: 'Object Wikidata URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'metadata_date',
    headerName: 'Metadata Date',
    type: [],
    sortable: true,
  },
  {
    field: 'repository',
    headerName: 'Repository',
    type: [],
    sortable: true,
  },
  {
    field: 'tags',
    headerName: 'Tags',
    type: [],
    sortable: true,
  },
  {
    field: 'tags_aat_url',
    headerName: 'Tags AAT URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'tags_wikidata_url',
    headerName: 'Tags Wikidata URL',
    type: ['custom_link'],
    sortable: true,
  },
];

export const data = [
  {
    object_number: '24.109.38a\u2013c',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1153',
    gallery_number: '704',
    department: 'The American Wing',
    accessionyear: '1924',
    object_name: 'Candlestick',
    title: 'Candle Holder',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '130',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Joseph Lownes',
    artist_display_bio: '1758\u20131820',
    artist_suffix: ' ',
    artist_alpha_sort: 'Lownes, Joseph',
    artist_nationality: ' ',
    artist_begin_date: '1758      ',
    artist_end_date: '1820      ',
    artist_gender: '',
    artist_ulan_url: 'http://vocab.getty.edu/page/ulan/500330248',
    artist_wikidata_url: '',
    object_date: '1790\u20131810',
    object_begin_date: '1790',
    object_end_date: '1810',
    medium: 'Silver, steel',
    dimensions:
      'Overall: 5 1/16 x 9 5/8 x 4 3/4 in. (12.9 x 24.4 x 12.1 cm); 17 oz. 17 dwt. (556.5 g)\r\n44.12.13,False,False,True,1170,,The American Wing,1944,Candlestick,Standing candlestick,,,,,,,,,,,,,,,,,,,1730\u201350,1730,1750,Brass and iron,H. 62 in. (157.5 cm),Bequest of Sarah Williams',
    credit_line: ' 1944"',
    geography_type: 'Possibly made in',
    city: 'Boston',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1170',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '11.87.78',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1183',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1911',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'Mexican',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1800',
    object_begin_date: '1797',
    object_end_date: '1800',
    medium: 'Tin-glazed earthenware',
    dimensions: 'H. 15 1/2 in. (39.4 cm)',
    credit_line: 'Gift of Mrs. Robert W. de Forest, 1911',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'Mexico',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1183',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dogs',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300265714',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q144',
  },
  {
    object_number: '18.95.4',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1184',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1918',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131830',
    object_begin_date: '1800',
    object_end_date: '1830',
    medium: 'Earthenware',
    dimensions: 'H. 4 in. (10.2 cm); Diam. 5 in. (12.7 cm)',
    credit_line: 'Rogers Fund, 1918',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1184',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '20.14.7',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1185',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1920',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Free-blown lead aquamarine glass',
    dimensions: 'H. 10 1/4 in. (26 cm)',
    credit_line: 'Rogers Fund, 1920',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1185',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1186',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 8 1/4 in. (21 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1186',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1187',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 7 in. (17.8 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1187',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.3',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1188',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 5 3/4 in. (14.6 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1188',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.4',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1189',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 5 1/4 in. (13.3 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1189',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
];
