// Source: https://github.com/metmuseum/openaccess
import { SkyCellType } from '@skyux/ag-grid';

import { ColDef, ColGroupDef } from 'ag-grid-community';

import { GroupInlineHelpComponent } from './inline-help/group-inline-help.component';
import { InlineHelpComponent } from './inline-help/inline-help.component';

/* spell-checker:disable */
export const columnDefinitions: ColDef[] = [
  {
    field: 'select',
    headerName: ' ',
    type: [SkyCellType.RowSelector],
  },
  {
    field: 'object_number',
    headerName: 'Object Number',
    type: [],
    sortable: false,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'is_highlight',
    headerName: 'Is Highlight',
    type: [],
    sortable: true,
  },
  {
    field: 'is_timeline_work',
    headerName: 'Is Timeline Work',
    type: [],
    sortable: true,
  },
  {
    field: 'is_public_domain',
    headerName: 'Is Public Domain',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'object_id',
    headerName: 'Object ID',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'gallery_number',
    headerName: 'Gallery Number',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'department',
    headerName: 'Department',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'accessionyear',
    headerName: 'AccessionYear',
    type: [],
    sortable: false,
  },
  {
    field: 'object_name',
    headerName: 'Object Name',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'title',
    headerName: 'Title',
    type: [],
    sortable: false,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'culture',
    headerName: 'Culture',
    type: [],
    sortable: true,
  },
  {
    field: 'period',
    headerName: 'Period',
    type: [],
    sortable: true,
  },
  {
    field: 'dynasty',
    headerName: 'Dynasty',
    type: [],
    sortable: true,
  },
  {
    field: 'reign',
    headerName: 'Reign',
    type: [],
    sortable: true,
  },
  {
    field: 'portfolio',
    headerName: 'Portfolio',
    type: [],
    sortable: true,
  },
  {
    field: 'constituent_id',
    headerName: 'Constituent ID',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_role',
    headerName: 'Artist Role',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_prefix',
    headerName: 'Artist Prefix',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_display_name',
    headerName: 'Artist Display Name',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'artist_display_bio',
    headerName: 'Artist Display Bio',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'artist_suffix',
    headerName: 'Artist Suffix',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_alpha_sort',
    headerName: 'Artist Alpha Sort',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_nationality',
    headerName: 'Artist Nationality',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_begin_date',
    headerName: 'Artist Begin Date',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_end_date',
    headerName: 'Artist End Date',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_gender',
    headerName: 'Artist Gender',
    type: [],
    sortable: true,
  },
  {
    field: 'artist_ulan_url',
    headerName: 'Artist ULAN URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'artist_wikidata_url',
    headerName: 'Artist Wikidata URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'object_date',
    headerName: 'Object Date',
    type: [],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'object_begin_date',
    headerName: 'Object Begin Date',
    type: [],
    sortable: true,
  },
  {
    field: 'object_end_date',
    headerName: 'Object End Date',
    type: [],
    sortable: true,
  },
  {
    field: 'medium',
    headerName: 'Medium',
    type: [],
    sortable: true,
  },
  {
    field: 'dimensions',
    headerName: 'Dimensions',
    type: [],
    sortable: true,
  },
  {
    field: 'credit_line',
    headerName: 'Credit Line',
    type: SkyCellType.Text,
    sortable: true,
  },
  {
    field: 'geography_type',
    headerName: 'Geography Type',
    type: [],
    sortable: true,
  },
  {
    field: 'city',
    headerName: 'City',
    type: [],
    sortable: true,
  },
  {
    field: 'state',
    headerName: 'State',
    type: [],
    sortable: true,
  },
  {
    field: 'county',
    headerName: 'County',
    type: [],
    sortable: true,
  },
  {
    field: 'country',
    headerName: 'Country',
    type: [],
    sortable: true,
  },
  {
    field: 'region',
    headerName: 'Region',
    type: [],
    sortable: true,
  },
  {
    field: 'subregion',
    headerName: 'Subregion',
    type: [],
    sortable: true,
  },
  {
    field: 'locale',
    headerName: 'Locale',
    type: [],
    sortable: true,
  },
  {
    field: 'locus',
    headerName: 'Locus',
    type: [],
    sortable: true,
  },
  {
    field: 'excavation',
    headerName: 'Excavation',
    type: [],
    sortable: true,
  },
  {
    field: 'river',
    headerName: 'River',
    type: [],
    sortable: true,
  },
  {
    field: 'classification',
    headerName: 'Classification',
    type: [],
    sortable: true,
  },
  {
    field: 'rights_and_reproduction',
    headerName: 'Rights and Reproduction',
    type: [],
    sortable: true,
  },
  {
    field: 'link_resource',
    headerName: 'Link Resource',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'object_wikidata_url',
    headerName: 'Object Wikidata URL',
    type: ['custom_link'],
    sortable: true,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  {
    field: 'metadata_date',
    headerName: 'Metadata Date',
    type: [],
    sortable: true,
  },
  {
    field: 'repository',
    headerName: 'Repository',
    type: [],
    sortable: true,
  },
  {
    field: 'tags',
    headerName: 'Tags',
    type: [],
    sortable: true,
  },
  {
    field: 'tags_aat_url',
    headerName: 'Tags AAT URL',
    type: ['custom_link'],
    sortable: true,
  },
  {
    field: 'tags_wikidata_url',
    headerName: 'Tags Wikidata URL',
    type: ['custom_link'],
    sortable: true,
  },
];

export const columnDefinitionsGrouped: ColGroupDef[] = [
  {
    headerName: 'Object Information',
    headerGroupComponentParams: {
      inlineHelpComponent: GroupInlineHelpComponent,
    },
    children: [
      {
        field: 'object_name',
        headerName: 'Object Name',
        type: [],
        sortable: true,
        headerComponentParams: {
          inlineHelpComponent: InlineHelpComponent,
        },
      },
      {
        field: 'department',
        headerName: 'Department',
        type: [],
        sortable: true,
        headerComponentParams: {
          inlineHelpComponent: InlineHelpComponent,
        },
      },
      {
        field: 'is_public_domain',
        headerName: 'Is Public Domain',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
    ],
  },
  {
    headerName: 'Titular Information',
    headerGroupComponentParams: {
      inlineHelpComponent: GroupInlineHelpComponent,
    },
    children: [
      {
        field: 'title',
        headerName: 'Title',
        type: [],
        sortable: true,
      },
      {
        field: 'culture',
        headerName: 'Culture',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'period',
        headerName: 'Period',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
    ],
  },
  {
    headerName: 'Artist',
    children: [
      {
        field: 'artist_role',
        headerName: 'Artist Role',
        type: [],
        sortable: true,
      },
      {
        field: 'artist_display_name',
        headerName: 'Artist Display Name',
        type: [],
        sortable: true,
      },
      {
        field: 'artist_display_bio',
        headerName: 'Artist Display Bio',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'artist_suffix',
        headerName: 'Artist Suffix',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'artist_nationality',
        headerName: 'Artist Nationality',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'artist_wikidata_url',
        headerName: 'Artist Wikidata URL',
        type: ['custom_link'],
        sortable: true,
        columnGroupShow: 'open',
      },
    ],
  },
  {
    headerName: 'Collection',
    children: [
      {
        field: 'object_date',
        headerName: 'Object Date',
        type: [],
        sortable: true,
      },
      {
        field: 'object_begin_date',
        headerName: 'Object Begin Date',
        type: [],
        sortable: true,
      },
      {
        field: 'object_end_date',
        headerName: 'Object End Date',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'medium',
        headerName: 'Medium',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'dimensions',
        headerName: 'Dimensions',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
    ],
  },
  {
    headerName: 'Geography & Classification',
    children: [
      {
        field: 'geography_type',
        headerName: 'Geography Type',
        type: [],
        sortable: true,
      },
      {
        field: 'city',
        headerName: 'City',
        type: [],
        sortable: true,
      },
      {
        field: 'state',
        headerName: 'State',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'county',
        headerName: 'County',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'country',
        headerName: 'Country',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
    ],
  },
  {
    headerName: 'Metadata',
    children: [
      {
        field: 'classification',
        headerName: 'Classification',
        type: [],
        sortable: true,
      },
      {
        field: 'rights_and_reproduction',
        headerName: 'Rights and Reproduction',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'link_resource',
        headerName: 'Link Resource',
        type: ['custom_link'],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'object_wikidata_url',
        headerName: 'Object Wikidata URL',
        type: ['custom_link'],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'metadata_date',
        headerName: 'Metadata Date',
        type: [],
        sortable: true,
        columnGroupShow: 'open',
      },
      {
        field: 'tags_wikidata_url',
        headerName: 'Tags Wikidata URL',
        type: ['custom_link'],
        sortable: true,
        columnGroupShow: 'open',
      },
    ],
  },
];

export const data = [
  {
    object_number: '24.109.38a\u2013c',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1153',
    gallery_number: '704',
    department: 'The American Wing',
    accessionyear: '1924',
    object_name: 'Candlestick',
    title: 'Candle Holder',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '130',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Joseph Lownes',
    artist_display_bio: '1758\u20131820',
    artist_suffix: ' ',
    artist_alpha_sort: 'Lownes, Joseph',
    artist_nationality: ' ',
    artist_begin_date: '1758      ',
    artist_end_date: '1820      ',
    artist_gender: '',
    artist_ulan_url: 'http://vocab.getty.edu/page/ulan/500330248',
    artist_wikidata_url: '',
    object_date: '1790\u20131810',
    object_begin_date: '1790',
    object_end_date: '1810',
    medium: 'Silver, steel',
    dimensions:
      'Overall: 5 1/16 x 9 5/8 x 4 3/4 in. (12.9 x 24.4 x 12.1 cm); 17 oz. 17 dwt. (556.5 g)\r\n44.12.13,False,False,True,1170,,The American Wing,1944,Candlestick,Standing candlestick,,,,,,,,,,,,,,,,,,,1730\u201350,1730,1750,Brass and iron,H. 62 in. (157.5 cm),Bequest of Sarah Williams',
    credit_line: ' 1944"',
    geography_type: 'Possibly made in',
    city: 'Boston',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1170',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '11.87.78',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1183',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1911',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'Mexican',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1800',
    object_begin_date: '1797',
    object_end_date: '1800',
    medium: 'Tin-glazed earthenware',
    dimensions: 'H. 15 1/2 in. (39.4 cm)',
    credit_line: 'Gift of Mrs. Robert W. de Forest, 1911',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'Mexico',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1183',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dogs',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300265714',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q144',
  },
  {
    object_number: '18.95.4',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1184',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1918',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131830',
    object_begin_date: '1800',
    object_end_date: '1830',
    medium: 'Earthenware',
    dimensions: 'H. 4 in. (10.2 cm); Diam. 5 in. (12.7 cm)',
    credit_line: 'Rogers Fund, 1918',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1184',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '20.14.7',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1185',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1920',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Free-blown lead aquamarine glass',
    dimensions: 'H. 10 1/4 in. (26 cm)',
    credit_line: 'Rogers Fund, 1920',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1185',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1186',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 8 1/4 in. (21 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1186',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1187',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 7 in. (17.8 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1187',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.3',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1188',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 5 3/4 in. (14.6 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1188',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.43.4',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1189',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1650',
    object_begin_date: '1647',
    object_end_date: '1650',
    medium: 'Brass',
    dimensions: 'H. 5 1/4 in. (13.3 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1189',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '36.164',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1190',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1936',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Steel, brass',
    dimensions: '10 x 5 x 5 in. (25.4 x 12.7 x 12.7 cm)',
    credit_line: 'Rogers Fund, 1936',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1190',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '37.134.8',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1191',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1937',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131900',
    object_begin_date: '1800',
    object_end_date: '1900',
    medium: 'Earthenware',
    dimensions: 'H. 1 3/4 in. (4.4 cm); Diam. 2 5/8 in. (6.7 cm)',
    credit_line: 'Gift of Mrs. J. Insley Blair, 1937',
    geography_type: 'Made in',
    city: 'Strasburg',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1191',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.389',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1192',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1770\u20131800',
    object_begin_date: '1770',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 6 1/2 in. (16.5 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1192',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.397',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1193',
    gallery_number: '712',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1660\u201380',
    object_begin_date: '1660',
    object_end_date: '1680',
    medium: 'Brass',
    dimensions: 'H. 10 in. (25.4 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1193',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.398',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1194',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1600\u20131700',
    object_begin_date: '1600',
    object_end_date: '1700',
    medium: 'Brass',
    dimensions: 'H. 8 in. (20.3 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'England|Netherlands',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1194',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.399',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1195',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1600\u20131700',
    object_begin_date: '1600',
    object_end_date: '1700',
    medium: 'Brass',
    dimensions: 'H. 8 in. (20.3 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'England|Netherlands',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1195',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.400',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1196',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1600\u20131700',
    object_begin_date: '1600',
    object_end_date: '1700',
    medium: 'Brass',
    dimensions: 'H. 7 3/4 in. (19.7 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1196',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.401',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1197',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1600\u20131700',
    object_begin_date: '1600',
    object_end_date: '1700',
    medium: 'Brass',
    dimensions: 'H. 8 3/8 in. (21.3 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'England|Netherlands',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1197',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.403',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1198',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American or British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 7 in. (17.8 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'United States|England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1198',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.404',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1199',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American or British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 7 in. (17.8 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'United States|England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1199',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.54',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1200',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1825\u201350',
    object_begin_date: '1825',
    object_end_date: '1850',
    medium: 'Lacy pressed glass',
    dimensions: 'H. 8 1/2 in. (21.6 cm)',
    credit_line: 'Rogers Fund, 1946',
    geography_type: 'Made in',
    city: 'Pittsburgh',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1200',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.297',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1201',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1860\u201370',
    object_begin_date: '1860',
    object_end_date: '1870',
    medium: 'Pressed amethyst glass',
    dimensions: 'H. 7 5/8 in. (19.4 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1201',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.312',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1202',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1875\u20131900',
    object_begin_date: '1875',
    object_end_date: '1900',
    medium: 'Pressed yellow glass',
    dimensions: 'H. 6 5/8 in. (16.8 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1202',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '46.140.358',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1203',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201350',
    object_begin_date: '1840',
    object_end_date: '1850',
    medium: 'Lacy pressed glass, pewter',
    dimensions: 'H. 7 3/8 in. (18.7 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: 'Pittsburgh',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1203',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.359',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1204',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1850\u201370',
    object_begin_date: '1850',
    object_end_date: '1870',
    medium: 'Pressed gray glass',
    dimensions: 'H. 9 13/16 in. (24.9 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1204',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.780',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1206',
    gallery_number: '706',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1850\u201360',
    object_begin_date: '1850',
    object_end_date: '1860',
    medium: 'Lacy pressed glass',
    dimensions:
      '11 3/8 x 4 x 4 in. (28.9 x 10.2 x 10.2 cm)\r\n48.135.61,False,False,True,1207,774,The American Wing,1948,Candlestick,Candlestick,,,,,,,,,,,,,,,,,,,ca. 1740,1737,1740,Brass,H. 7 3/8 in. (18.7 cm),Bequest of Adeline R. Brown',
    credit_line: ' 1947"',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1207',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.62',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1208',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1740\u201370',
    object_begin_date: '1740',
    object_end_date: '1770',
    medium: 'Brass',
    dimensions: 'H. 7 3/4 in. (19.7 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1208',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.73',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1209',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1910',
    object_begin_date: '1907',
    object_end_date: '1910',
    medium: 'Pewter',
    dimensions: 'H. 6 in. (15.2 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1209',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.74a\u2013c',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1210',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British or Irish',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1790',
    object_begin_date: '1787',
    object_end_date: '1790',
    medium: 'Blown glass',
    dimensions: 'H. 10 7/8 in. (27.6 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'England|Ireland',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1210',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.75a\u2013c',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1211',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British or Irish',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1790',
    object_begin_date: '1787',
    object_end_date: '1790',
    medium: 'Blown glass',
    dimensions: 'H. 10 7/8 in. (27.6 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'England|Ireland',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1211',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.76a\u2013c',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1212',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1790',
    object_begin_date: '1787',
    object_end_date: '1790',
    medium: 'Cut glass',
    dimensions: 'H. 10 3/8 in. (26.4 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1212',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '51.171.24',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1213',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1951',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1830\u201335',
    object_begin_date: '1830',
    object_end_date: '1835',
    medium: 'Lacy pressed glass',
    dimensions: 'H. 6 15/16 in. (17.6 cm)',
    credit_line:
      'Gift of Mrs. Charles W. Green, in memory of Dr. Charles W. Green, 1951',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: 'New England ',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1213',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '51.171.32',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1214',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1951',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1830\u201335',
    object_begin_date: '1830',
    object_end_date: '1835',
    medium: 'Lacy pressed glass',
    dimensions: 'H. 8 15/16 in. (22.7 cm)',
    credit_line:
      'Gift of Mrs. Charles W. Green, in memory of Dr. Charles W. Green, 1951',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: 'New England ',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1214',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '51.171.94',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1215',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1951',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1830\u20131900',
    object_begin_date: '1830',
    object_end_date: '1900',
    medium: 'Pressed blue glass',
    dimensions: 'H. 7 1/16 in. (17.9 cm)',
    credit_line:
      'Gift of Mrs. Charles W. Green, in memory of Dr. Charles W. Green, 1951',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1215',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '66.10.33',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1216',
    gallery_number: '734',
    department: 'The American Wing',
    accessionyear: '1966',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American, Shaker',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '8737',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name:
      'United Society of Believers in Christ\u2019s Second Appearing (\u201cShakers\u201d)',
    artist_display_bio: 'American, active ca. 1750\u2013present',
    artist_suffix: ' ',
    artist_alpha_sort:
      'United Society of Believers in Christ\u2019s Second Appearing',
    artist_nationality: ' ',
    artist_begin_date: '1750      ',
    artist_end_date: '9999      ',
    artist_gender: '',
    artist_ulan_url: '(not assigned)',
    artist_wikidata_url: 'https://www.wikidata.org/wiki/Q1370167',
    object_date: '1820\u201360',
    object_begin_date: '1820',
    object_end_date: '1860',
    medium: 'Tin',
    dimensions: 'H. 6 in. (15.2 cm); Diam. 3 5/8 in. (9.2 cm)',
    credit_line: 'Friends of the American Wing Fund, 1966',
    geography_type: 'Made in',
    city: 'New Lebanon',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1216',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '1971.180.119',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1217',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1971',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'Chinese',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131900',
    object_begin_date: '1800',
    object_end_date: '1900',
    medium: 'Porcelain',
    dimensions: '5 3/16 x 6 1/16 in. (13.2 x 15.4 cm)',
    credit_line: 'Bequest of Flora E. Whiting, 1971',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'China',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1217',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Elephants|Flowers',
    tags_aat_url:
      'http://vocab.getty.edu/page/aat/300250160|http://vocab.getty.edu/page/aat/300132399',
    tags_wikidata_url:
      'https://www.wikidata.org/wiki/Q7378|https://www.wikidata.org/wiki/Q506',
  },
  {
    object_number: '1984.133',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1218',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1984',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1845\u201360',
    object_begin_date: '1845',
    object_end_date: '1860',
    medium: 'Porcelain',
    dimensions: 'H. 9 7/8 in. (25.1 cm); Diam. 3 15/16 in. (10 cm)',
    credit_line: 'Friends of the American Wing Fund, 1984',
    geography_type: 'Made in',
    city: 'Trenton',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1218',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.296',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1219',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '113',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Boston & Sandwich Glass Company',
    artist_display_bio: 'American, 1825\u20131888, Sandwich, Massachusetts',
    artist_suffix: ' ',
    artist_alpha_sort: 'Boston and Sandwich Glass Company ',
    artist_nationality: ' ',
    artist_begin_date: '1825      ',
    artist_end_date: '1888      ',
    artist_gender: '',
    artist_ulan_url: 'http://vocab.getty.edu/page/ulan/500334773',
    artist_wikidata_url: 'https://www.wikidata.org/wiki/Q4948224',
    object_date: '1835\u201340',
    object_begin_date: '1835',
    object_end_date: '1840',
    medium: 'Pressed amethyst glass',
    dimensions: 'H. 6 15/16 in. (17.6 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: 'Sandwich',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1219',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.360',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1220',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '113',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Boston & Sandwich Glass Company',
    artist_display_bio: 'American, 1825\u20131888, Sandwich, Massachusetts',
    artist_suffix: ' ',
    artist_alpha_sort: 'Boston and Sandwich Glass Company ',
    artist_nationality: ' ',
    artist_begin_date: '1825      ',
    artist_end_date: '1888      ',
    artist_gender: '',
    artist_ulan_url: 'http://vocab.getty.edu/page/ulan/500334773',
    artist_wikidata_url: 'https://www.wikidata.org/wiki/Q4948224',
    object_date: 'ca. 1840',
    object_begin_date: '1837',
    object_end_date: '1840',
    medium: 'Pressed glass',
    dimensions: 'H. 8 1/2 in. (21.6 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: 'Sandwich',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1220',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '41.99.4',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1221',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '130',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'E. Durnall',
    artist_display_bio: ' ',
    artist_suffix: ' ',
    artist_alpha_sort: 'Durnall, E.',
    artist_nationality: ' ',
    artist_begin_date: '          ',
    artist_end_date: '9999      ',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1750\u201360',
    object_begin_date: '1750',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 7 5/8 in. (19.4 cm)',
    credit_line:
      'Gift of James De Lancey Verplanck and John Bayard Rodgers Verplanck, 1941',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1221',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.36',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1222',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'Mexican',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '131',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Diego Gonzales de la Cueva',
    artist_display_bio: ' ',
    artist_suffix: ' ',
    artist_alpha_sort: 'Gonzales, de la Cueva Diego',
    artist_nationality: ' ',
    artist_begin_date: '1733      ',
    artist_end_date: '1778      ',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Silver',
    dimensions:
      'Overall: 7 3/16 in. (18.3 cm); 19 oz. 7 dwt. (601.9 g)\r\n57.153a',
    credit_line: ' b"',
    geography_type: 'False',
    city: 'False',
    state: 'True',
    county: '1223',
    country: '750',
    region: 'The American Wing',
    subregion: '1957',
    locale: 'Candlestick',
    locus: 'Candlestick',
    excavation: 'American',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: '',
    object_wikidata_url: '124',
    metadata_date: 'Maker',
    repository: ' ',
    tags: 'Cornelius Kierstede',
    tags_aat_url: '1674\u2013ca. 1757',
    tags_wikidata_url: ' ',
  },
  {
    object_number: '46.140.320',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1230',
    gallery_number: '706',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '1314108',
    artist_role: 'Designer|Manufacturer',
    artist_prefix: 'Designed by|Manufactured by',
    artist_display_name: 'Henry Whitney|New England Glass Company',
    artist_display_bio:
      ' |American, East Cambridge, Massachusetts, 1818\u20131888',
    artist_suffix: ' | ',
    artist_alpha_sort: 'Whitney, Henry|New England Glass Company ',
    artist_nationality: ' | ',
    artist_begin_date: '          |1818      ',
    artist_end_date: '9999      |1888      ',
    artist_gender: '|',
    artist_ulan_url: '|http://vocab.getty.edu/page/ulan/500356007',
    artist_wikidata_url: '|https://www.wikidata.org/wiki/Q17083157',
    object_date: '1870\u201375',
    object_begin_date: '1870',
    object_end_date: '1875',
    medium: 'Pressed glass',
    dimensions: 'H. 9 5/8 in. (24.4 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: 'East Cambridge',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1230',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Caryatids',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300001583',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q208120',
  },
  {
    object_number: '61.231.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1231',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1961',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '130',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Cornelius and Company',
    artist_display_bio: '1838\u20131851',
    artist_suffix: ' ',
    artist_alpha_sort: 'Cornelius and Company ',
    artist_nationality: ' ',
    artist_begin_date: '1838      ',
    artist_end_date: '1851      ',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201350',
    object_begin_date: '1840',
    object_end_date: '1850',
    medium: 'Gilt metal, marble, crystal',
    dimensions: '16 7/8 x 4 3/4 x 3 3/8 in. (42.9 x 12.1 x 8.6 cm)',
    credit_line: 'Gift of Mary E. Steers, 1961',
    geography_type: 'Made in',
    city: 'Philadelphia',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1231',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '61.231.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1232',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1961',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '130',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name: 'Cornelius and Company',
    artist_display_bio: '1838\u20131851',
    artist_suffix: ' ',
    artist_alpha_sort: 'Cornelius and Company ',
    artist_nationality: ' ',
    artist_begin_date: '1838      ',
    artist_end_date: '1851      ',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201350',
    object_begin_date: '1840',
    object_end_date: '1850',
    medium: 'Gilt metal, marble, crystal',
    dimensions: '16 7/8 x 4 3/4 x 3 3/8 in. (42.9 x 12.1 x 8.6 cm)',
    credit_line: 'Gift of Mary E. Steers, 1961',
    geography_type: 'Made in',
    city: 'Philadelphia',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1232',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '24.116.6',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1235',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1924',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131830',
    object_begin_date: '1800',
    object_end_date: '1830',
    medium: 'Metal, earthenware, glass',
    dimensions: 'H. 12 in. (30.5 cm); Diam. 4 7/16 in. (11.3 cm)',
    credit_line: 'Bequest of Miss Emilie Ogden, 1924',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1235',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '24.116.7',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1236',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1924',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131830',
    object_begin_date: '1800',
    object_end_date: '1830',
    medium: 'Metal, earthenware, glass',
    dimensions: 'H. 12 in. (30.5 cm); Diam. 4 7/16 in. (11.3 cm)',
    credit_line: 'Bequest of Miss Emilie Ogden, 1924',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1236',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Human Figures',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300404114',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q5937779',
  },
  {
    object_number: '35.124.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1241',
    gallery_number: '704',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1830\u201355',
    object_begin_date: '1830',
    object_end_date: '1855',
    medium: 'Blown glass',
    dimensions: 'H. 9 1/8 in. (23.2 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1241',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '35.124.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1242',
    gallery_number: '704',
    department: 'The American Wing',
    accessionyear: '1935',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1830\u201355',
    object_begin_date: '1830',
    object_end_date: '1855',
    medium: 'Blown glass',
    dimensions: 'H. 9 1/8 in. (23.2 cm)',
    credit_line: 'Rogers Fund, 1935',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1242',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '36.148.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1243',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1936',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201360',
    object_begin_date: '1840',
    object_end_date: '1860',
    medium: 'Yellow glass',
    dimensions: 'H. 10 3/8 in. (26.4 cm)',
    credit_line: 'Rogers Fund, 1936',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1243',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '36.148.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1244',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1936',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201360',
    object_begin_date: '1840',
    object_end_date: '1860',
    medium: 'Yellow glass',
    dimensions: 'H. 10 3/8 in. (26.4 cm)',
    credit_line: 'Rogers Fund, 1936',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1244',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '38.138.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1245',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1938',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1720',
    object_begin_date: '1717',
    object_end_date: '1720',
    medium: 'Brass',
    dimensions: 'H. 6 in. (15.2 cm)',
    credit_line: 'Gift of Allan B. A. Bradley, 1938',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1245',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '38.138.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1246',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1938',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1720',
    object_begin_date: '1717',
    object_end_date: '1720',
    medium: 'Brass',
    dimensions: 'H. 6 in. (15.2 cm)',
    credit_line: 'Gift of Allan B. A. Bradley, 1938',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1246',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.387',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1247',
    gallery_number: '729',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 6 1/2 in. (16.5 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1247',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '41.160.388',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1248',
    gallery_number: '729',
    department: 'The American Wing',
    accessionyear: '1941',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 6 1/2 in. (16.5 cm)',
    credit_line: 'Bequest of W. Gedney Beatty, 1941',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1248',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.67.3',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1249',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131830',
    object_begin_date: '1800',
    object_end_date: '1830',
    medium: 'Earthenware, lusterware',
    dimensions: 'H. 6 1/4 in. (15.9 cm)',
    credit_line:
      'Gift of the Members of the Committee of the Bertha King Benkard Memorial Fund, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1249',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.67.4',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1250',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131830',
    object_begin_date: '1800',
    object_end_date: '1830',
    medium: 'Earthenware, lusterware',
    dimensions: 'H. 6 1/4 in. (15.9 cm)',
    credit_line:
      'Gift of the Members of the Committee of the Bertha King Benkard Memorial Fund, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1250',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.67.61a, b',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1251',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131900',
    object_begin_date: '1800',
    object_end_date: '1900',
    medium: 'Brass',
    dimensions: 'H. 9 5/8 in. (24.4 cm)',
    credit_line:
      'Gift of the Members of the Committee of the Bertha King Benkard Memorial Fund, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'France',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1251',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.67.62a, b',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1252',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1800\u20131900',
    object_begin_date: '1800',
    object_end_date: '1900',
    medium: 'Brass',
    dimensions: 'H. 9 5/8 in. (24.4 cm)',
    credit_line:
      'Gift of the Members of the Committee of the Bertha King Benkard Memorial Fund, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'France',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1252',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.67.63a, b',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1253',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1770\u20131800',
    object_begin_date: '1770',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 11 in. (27.9 cm)',
    credit_line:
      'Gift of the Members of the Committee of the Bertha King Benkard Memorial Fund, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1253',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.67.64a, b',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1254',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1770\u20131800',
    object_begin_date: '1770',
    object_end_date: '1800',
    medium: 'Brass',
    dimensions: 'H. 11 in. (27.9 cm)',
    credit_line:
      'Gift of the Members of the Committee of the Bertha King Benkard Memorial Fund, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1254',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.331',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1255',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201360',
    object_begin_date: '1840',
    object_end_date: '1860',
    medium: 'Pressed glass',
    dimensions: 'H. 5 1/16 in. (12.9 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: 'New England ',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1255',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.332',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1256',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201360',
    object_begin_date: '1840',
    object_end_date: '1860',
    medium: 'Pressed glass',
    dimensions: 'H. 5 1/8 in. (13 cm)',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: 'New England ',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1256',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.734',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1257',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1880\u201390',
    object_begin_date: '1880',
    object_end_date: '1890',
    medium: 'Pressed purple marble glass',
    dimensions: 'Dimensions unavailable',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1257',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.735',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1258',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1880\u201390',
    object_begin_date: '1880',
    object_end_date: '1890',
    medium: 'Pressed purple marble glass',
    dimensions: 'Dimensions unavailable',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1258',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.736',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1259',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1880\u201390',
    object_begin_date: '1880',
    object_end_date: '1890',
    medium: 'Pressed purple marble glass',
    dimensions: 'Dimensions unavailable',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1259',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '46.140.737',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1260',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1946',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1880\u201390',
    object_begin_date: '1880',
    object_end_date: '1890',
    medium: 'Pressed purple marble glass',
    dimensions: 'Dimensions unavailable',
    credit_line: 'Gift of Mrs. Emily Winthrop Miles, 1946',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1260',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.37',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1261',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1710\u201320',
    object_begin_date: '1710',
    object_end_date: '1720',
    medium: 'Brass',
    dimensions: 'H. 6 1/4 in. (15.9 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1261',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.38',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1262',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1710\u201320',
    object_begin_date: '1710',
    object_end_date: '1720',
    medium: 'Brass',
    dimensions: 'H. 6 1/4 in. (15.9 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1262',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.45',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1263',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1760',
    object_begin_date: '1757',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 5 1/4 in. (13.3 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1263',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.46',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1264',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1760',
    object_begin_date: '1757',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 5 1/4 in. (13.3 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1264',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.47',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1265',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1750',
    object_begin_date: '1747',
    object_end_date: '1750',
    medium: 'Brass',
    dimensions: 'H. 8 3/8 in. (21.3 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1265',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.48',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1266',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1750',
    object_begin_date: '1747',
    object_end_date: '1750',
    medium: 'Brass',
    dimensions: 'H. 8 3/8 in. (21.3 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1266',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.49',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1267',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1725\u201340',
    object_begin_date: '1725',
    object_end_date: '1740',
    medium: 'Brass',
    dimensions: 'H. 8 3/8 in. (21.3 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1267',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.50',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1268',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1725\u201340',
    object_begin_date: '1725',
    object_end_date: '1740',
    medium: 'Brass',
    dimensions: 'H. 8 3/8 in. (21.3 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1268',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.51',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1269',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American or British',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1750',
    object_begin_date: '1747',
    object_end_date: '1750',
    medium: 'Brass',
    dimensions: 'H. 8 5/8 in. (21.9 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Possibly made in|Possibly made in',
    city: '',
    state: '',
    county: '',
    country: 'United States|England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1269',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.53',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1270',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1750\u201360',
    object_begin_date: '1750',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 8 3/4 in. (22.2 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1270',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.54',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1271',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1750\u201360',
    object_begin_date: '1750',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 8 3/4 in. (22.2 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1271',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.55',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1272',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1750\u201370',
    object_begin_date: '1750',
    object_end_date: '1770',
    medium: 'Brass',
    dimensions: 'H. 7 3/4 in. (19.7 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1272',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.59',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1273',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1750\u201360',
    object_begin_date: '1750',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 7 7/8 in. (20 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1273',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.60',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1274',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1750\u201360',
    object_begin_date: '1750',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 7 7/8 in. (20 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1274',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.63',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1275',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1760',
    object_begin_date: '1757',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 10 in. (25.4 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1275',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.64',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1276',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1760',
    object_begin_date: '1757',
    object_end_date: '1760',
    medium: 'Brass',
    dimensions: 'H. 10 in. (25.4 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: 'Probably made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1276',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.71',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1277',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1820',
    object_begin_date: '1817',
    object_end_date: '1820',
    medium: 'Pewter',
    dimensions: 'H. 7 3/4 in. (19.7 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1277',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.135.72',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1278',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1820',
    object_begin_date: '1817',
    object_end_date: '1820',
    medium: 'Pewter',
    dimensions: 'H. 7 3/4 in. (19.7 cm)',
    credit_line: 'Bequest of Adeline R. Brown, 1947',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1278',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.145.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1279',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1790',
    object_begin_date: '1787',
    object_end_date: '1790',
    medium: 'Sheffield silver plate',
    dimensions: 'H. 11 1/2 in. (29.2 cm)',
    credit_line: 'Bequest of Fannie Randolph Gaunt, 1948',
    geography_type: 'Probably made in',
    city: 'Sheffield',
    state: 'South Yorkshire',
    county: 'South Yorkshire',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1279',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '48.145.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1280',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1948',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1790',
    object_begin_date: '1787',
    object_end_date: '1790',
    medium: 'Silver plate on copper',
    dimensions: 'H. 11 1/2 in. (29.2 cm)',
    credit_line: 'Bequest of Fannie Randolph Gaunt, 1948',
    geography_type: 'Probably made in',
    city: 'Sheffield',
    state: 'South Yorkshire',
    county: 'South Yorkshire',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1280',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '57.131.1',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1281',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201350',
    object_begin_date: '1840',
    object_end_date: '1850',
    medium: 'Pressed glass',
    dimensions: 'H. 10 3/8 in. (26.4 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: 'New England ',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1281',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '57.131.2',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1282',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201350',
    object_begin_date: '1840',
    object_end_date: '1850',
    medium: 'Pressed glass',
    dimensions: 'H. 10 1/4 in. (26 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: 'New England ',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1282',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '57.131.5',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1283',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1920s',
    object_begin_date: '1917',
    object_end_date: '1920',
    medium: 'Pressed opaque green and white glass',
    dimensions: 'H. 10 3/4 in. (27.3 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'Czech Republic',
    region: 'Bohemia',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1283',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '57.131.6',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'False',
    object_id: '1284',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1920s',
    object_begin_date: '1917',
    object_end_date: '1920',
    medium: 'Pressed opaque white and green glass',
    dimensions: 'H. 10 3/4 in. (27.3 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'Czech Republic',
    region: 'Bohemia',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1284',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '57.131.7',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1285',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1845\u201370',
    object_begin_date: '1845',
    object_end_date: '1870',
    medium: 'Pressed opaque blue glass',
    dimensions: 'H. 9 3/4 in. (24.8 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1285',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '57.131.8',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1286',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1845\u201370',
    object_begin_date: '1845',
    object_end_date: '1870',
    medium: 'Pressed opaque blue glass',
    dimensions: 'H. 9 3/4 in. (24.8 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1286',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: 'Dolphins',
    tags_aat_url: 'http://vocab.getty.edu/page/aat/300250159',
    tags_wikidata_url: 'https://www.wikidata.org/wiki/Q7369',
  },
  {
    object_number: '57.131.9',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1287',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201370',
    object_begin_date: '1840',
    object_end_date: '1870',
    medium: 'Pressed opaque blue and white glass',
    dimensions: 'H. 10 7/8 in. (27.6 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1287',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '57.131.10',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1288',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1957',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1840\u201370',
    object_begin_date: '1840',
    object_end_date: '1870',
    medium: 'Pressed opaque blue and white glass',
    dimensions: 'H. 10 15/16 in. (27.8 cm)',
    credit_line:
      'Bequest of Anna G. W. Green, in memory of her husband, Dr. Charles W. Green, 1957',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1288',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '66.10.30',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1289',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1966',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American, Shaker',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '8737',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name:
      'United Society of Believers in Christ\u2019s Second Appearing (\u201cShakers\u201d)',
    artist_display_bio: 'American, active ca. 1750\u2013present',
    artist_suffix: ' ',
    artist_alpha_sort:
      'United Society of Believers in Christ\u2019s Second Appearing',
    artist_nationality: ' ',
    artist_begin_date: '1750      ',
    artist_end_date: '9999      ',
    artist_gender: '',
    artist_ulan_url: '(not assigned)',
    artist_wikidata_url: 'https://www.wikidata.org/wiki/Q1370167',
    object_date: '1820\u201360',
    object_begin_date: '1820',
    object_end_date: '1860',
    medium: 'Tin',
    dimensions: 'H. 6 in. (15.2 cm); Diam. 3 5/8 in. (9.2 cm)',
    credit_line: 'Friends of the American Wing Fund, 1966',
    geography_type: 'Made in',
    city: 'New Lebanon',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1289',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '66.10.31',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1290',
    gallery_number: '',
    department: 'The American Wing',
    accessionyear: '1966',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: 'American, Shaker',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '8737',
    artist_role: 'Maker',
    artist_prefix: ' ',
    artist_display_name:
      'United Society of Believers in Christ\u2019s Second Appearing (\u201cShakers\u201d)',
    artist_display_bio: 'American, active ca. 1750\u2013present',
    artist_suffix: ' ',
    artist_alpha_sort:
      'United Society of Believers in Christ\u2019s Second Appearing',
    artist_nationality: ' ',
    artist_begin_date: '1750      ',
    artist_end_date: '9999      ',
    artist_gender: '',
    artist_ulan_url: '(not assigned)',
    artist_wikidata_url: 'https://www.wikidata.org/wiki/Q1370167',
    object_date: '1820\u201360',
    object_begin_date: '1820',
    object_end_date: '1860',
    medium: 'Tin',
    dimensions: 'H. 6 in. (15.2 cm); Diam. 3 5/8 in. (9.2 cm)',
    credit_line: 'Friends of the American Wing Fund, 1966',
    geography_type: 'Made in',
    city: 'New Lebanon',
    state: '',
    county: '',
    country: 'United States',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1290',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '1970.126.6',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1291',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1970',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1810',
    object_begin_date: '1807',
    object_end_date: '1810',
    medium: 'Silver plate on copper',
    dimensions: '12 1/16 x 6 1/8 x 5 in. (30.6 x 15.6 x 12.7 cm)',
    credit_line:
      'Gift of Mrs. B. Langdon Tyler and Mrs. William Floyd Nichols, 1970',
    geography_type: 'Made in',
    city: 'Sheffield',
    state: 'South Yorkshire',
    county: 'South Yorkshire',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1291',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '1970.126.7',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1292',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1970',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: 'ca. 1810',
    object_begin_date: '1807',
    object_end_date: '1810',
    medium: 'Silver plate on copper',
    dimensions: '12 1/16 x 6 1/8 x 5 in. (30.6 x 15.6 x 12.7 cm)',
    credit_line:
      'Gift of Mrs. B. Langdon Tyler and Mrs. William Floyd Nichols, 1970',
    geography_type: 'Made in',
    city: 'Sheffield',
    state: 'South Yorkshire',
    county: 'South Yorkshire',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1292',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '1971.180.69',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1293',
    gallery_number: '710',
    department: 'The American Wing',
    accessionyear: '1971',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1670\u20131700',
    object_begin_date: '1670',
    object_end_date: '1700',
    medium: 'Brass',
    dimensions: 'H. 8 1/2 in. (21.6 cm); Diam. 6 1/8 in. (15.6 cm)',
    credit_line: 'Bequest of Flora E. Whiting, 1971',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1293',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '1971.180.70',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1294',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1971',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1670\u20131700',
    object_begin_date: '1670',
    object_end_date: '1700',
    medium: 'Brass',
    dimensions: 'H. 8 1/2 in. (21.6 cm); Diam. 6 1/8 in. (15.6 cm)',
    credit_line: 'Bequest of Flora E. Whiting, 1971',
    geography_type: '',
    city: '',
    state: '',
    county: '',
    country: '',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1294',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
  {
    object_number: '1971.180.78a, b',
    is_highlight: 'False',
    is_timeline_work: 'False',
    is_public_domain: 'True',
    object_id: '1295',
    gallery_number: '774',
    department: 'The American Wing',
    accessionyear: '1971',
    object_name: 'Candlestick',
    title: 'Candlestick',
    culture: '',
    period: '',
    dynasty: '',
    reign: '',
    portfolio: '',
    constituent_id: '',
    artist_role: '',
    artist_prefix: '',
    artist_display_name: '',
    artist_display_bio: '',
    artist_suffix: '',
    artist_alpha_sort: '',
    artist_nationality: '',
    artist_begin_date: '',
    artist_end_date: '',
    artist_gender: '',
    artist_ulan_url: '',
    artist_wikidata_url: '',
    object_date: '1700\u20131800',
    object_begin_date: '1700',
    object_end_date: '1800',
    medium: 'Copper, enamel, brass',
    dimensions: '8 5/8 x 4 13/16 in. (21.9 x 12.2 cm)',
    credit_line: 'Bequest of Flora E. Whiting, 1971',
    geography_type: 'Made in',
    city: '',
    state: '',
    county: '',
    country: 'England',
    region: '',
    subregion: '',
    locale: '',
    locus: '',
    excavation: '',
    river: '',
    classification: '',
    rights_and_reproduction: '',
    link_resource: 'http://www.metmuseum.org/art/collection/search/1295',
    object_wikidata_url: '',
    metadata_date: '',
    repository: 'Metropolitan Museum of Art, New York, NY',
    tags: '',
    tags_aat_url: '',
    tags_wikidata_url: '',
  },
];
