import { Component, OnDestroy, OnInit } from '@angular/core';
import {
  SkyAppViewportReservedPositionType,
  SkyAppViewportService,
} from '@skyux/theme';

@Component({
  selector: 'app-page',
  templateUrl: './page.component.html',
  styleUrls: ['./page.component.scss'],
})
export class PageComponent implements OnInit, OnDestroy {
  public spaces = {
    left: 10,
    top: 40,
    right: 80,
    bottom: 120,
  } as { [key in SkyAppViewportReservedPositionType]: number };

  #viewportSvc: SkyAppViewportService;

  constructor(viewportSvc: SkyAppViewportService) {
    this.#viewportSvc = viewportSvc;
  }

  public ngOnInit(): void {
    for (const [position, size] of Object.entries(this.spaces)) {
      this.#viewportSvc.reserveSpace({
        id: position,
        position: position as SkyAppViewportReservedPositionType,
        size,
      });
    }
  }

  public ngOnDestroy(): void {
    for (const position of Object.keys(this.spaces)) {
      this.#viewportSvc.unreserveSpace(position);
    }
  }
}
