import { SkyCellType } from '@skyux/ag-grid';

import { ColDef } from 'ag-grid-community';

import { InlineHelpComponent } from './inline-help/inline-help.component';

/* spell-checker:disable */
export const columnDefinitions: ColDef[] = [
  {
    field: 'id',
    colId: 'id',
    headerName: 'ID',
    hide: true,
  },
  {
    field: 'name',
    colId: 'name',
    headerName: 'Name',
    sortable: true,
    type: SkyCellType.Text,
    minWidth: 200,
    initialWidth: 200,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
    initialSort: 'asc',
  },
  {
    field: 'birthday',
    colId: 'birthday',
    headerName: 'Birthday',
    sortable: false,
    type: SkyCellType.Date,
    minWidth: 300,
    initialWidth: 300,
    headerComponentParams: {
      inlineHelpComponent: InlineHelpComponent,
    },
  },
  ...[
    ['seasons_played', 'Seasons Played'],
    ['all-star', 'All-Star'],
    ['triplecrown', 'Triple Crowns'],
    ['mvp', 'MVPs'],
    ['cya', 'CYA'],
  ].map(([field, headerName]) => ({
    field,
    colId: field,
    headerName,
    sortable: field === 'mvp',
    type: SkyCellType.Number,
    minWidth: 100,
    initialWidth: 100,
  })),
  ...[
    ['3000h', '3000 Hits'],
    ['500hr', '500 Homeruns'],
    ['1500rbi', '1500 RBIs'],
    ['3000k', '3000 Ks'],
    ['300w', '300 Ws'],
    ['300sv', '300 SVs'],
  ].map(([field, headerName]) => ({
    field,
    colId: field,
    dataType: 'Boolean',
    headerName,
    sortable: false,
    cellClass: 'booleanType',
    initialWidth: 40,
  })),
  {
    field: 'vote%',
    colId: 'vote%',
    headerName: 'Vote %',
    sortable: true,
    type: SkyCellType.Number,
    minWidth: 100,
    initialWidth: 100,
    valueFormatter: (params) =>
      `${(Number(params.value) * 100).toPrecision(4)}%`,
  },
];

// Data derived from https://github.com/andrew-cui-zz/mlb-players-hof

export interface DataType {
  id: string;
  name: string;
  birthday: string;
  seasons_played: number;
  'all-star': number;
  triplecrown: number;
  mvp: number;
  cya: number;
  '3000h': boolean;
  '500hr': boolean;
  '1500rbi': boolean;
  '3000k': boolean;
  '300w': boolean;
  '300sv': boolean;
  'vote%': number;
}

export const data: DataType[] = [
  {
    id: 'aaronha01',
    name: 'Hank Aaron',
    birthday: '1934-02-05',
    seasons_played: 23,
    'all-star': 25,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.978313253,
  },
  {
    id: 'alexape01',
    name: 'Pete Alexander',
    birthday: '1887-02-26',
    seasons_played: 21,
    'all-star': 0,
    triplecrown: 3,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.809160305,
  },
  {
    id: 'alomaro01',
    name: 'Roberto Alomar',
    birthday: '1968-02-05',
    seasons_played: 19,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.900172117,
  },
  {
    id: 'aparilu01',
    name: 'Luis Aparicio',
    birthday: '1934-04-29',
    seasons_played: 18,
    'all-star': 13,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.846153846,
  },
  {
    id: 'bankser01',
    name: 'Ernie Banks',
    birthday: '1931-01-31',
    seasons_played: 19,
    'all-star': 14,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.838120104,
  },
  {
    id: 'benchjo01',
    name: 'Johnny Bench',
    birthday: '1947-12-07',
    seasons_played: 17,
    'all-star': 14,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.964205817,
  },
  {
    id: 'berrayo01',
    name: 'Yogi Berra',
    birthday: '1925-05-12',
    seasons_played: 19,
    'all-star': 18,
    triplecrown: 0,
    mvp: 3,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.856060606,
  },
  {
    id: 'biggicr01',
    name: 'Craig Biggio',
    birthday: '1965-12-14',
    seasons_played: 20,
    'all-star': 7,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.826958106,
  },
  {
    id: 'blylebe01',
    name: 'Bert Blyleven',
    birthday: '1951-04-06',
    seasons_played: 24,
    'all-star': 2,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': false,
    '300sv': false,
    'vote%': 0.796901893,
  },
  {
    id: 'boggswa01',
    name: 'Wade Boggs',
    birthday: '1958-06-15',
    seasons_played: 18,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.918604651,
  },
  {
    id: 'boudrlo01',
    name: 'Lou Boudreau',
    birthday: '1917-07-17',
    seasons_played: 15,
    'all-star': 8,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.773333333,
  },
  {
    id: 'brettge01',
    name: 'George Brett',
    birthday: '1953-05-15',
    seasons_played: 21,
    'all-star': 13,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.981891348,
  },
  {
    id: 'brocklo01',
    name: 'Lou Brock',
    birthday: '1939-06-18',
    seasons_played: 20,
    'all-star': 6,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.797468354,
  },
  {
    id: 'camparo01',
    name: 'Roy Campanella',
    birthday: '1921-11-19',
    seasons_played: 10,
    'all-star': 8,
    triplecrown: 0,
    mvp: 3,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.794117647,
  },
  {
    id: 'carewro01',
    name: 'Rod Carew',
    birthday: '1945-10-01',
    seasons_played: 19,
    'all-star': 18,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.905191874,
  },
  {
    id: 'carltst01',
    name: 'Steve Carlton',
    birthday: '1944-12-22',
    seasons_played: 27,
    'all-star': 10,
    triplecrown: 1,
    mvp: 0,
    cya: 4,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.956140351,
  },
  {
    id: 'cartega01',
    name: 'Gary Carter',
    birthday: '1954-04-08',
    seasons_played: 19,
    'all-star': 11,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.780241935,
  },
  {
    id: 'cobbty01',
    name: 'Ty Cobb',
    birthday: '1886-12-18',
    seasons_played: 24,
    'all-star': 0,
    triplecrown: 1,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.982300885,
  },
  {
    id: 'cochrmi01',
    name: 'Mickey Cochrane',
    birthday: '1903-04-06',
    seasons_played: 13,
    'all-star': 2,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.795031056,
  },
  {
    id: 'collied01',
    name: 'Eddie Collins',
    birthday: '1887-05-02',
    seasons_played: 25,
    'all-star': 0,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.777372263,
  },
  {
    id: 'cronijo01',
    name: 'Joe Cronin',
    birthday: '1906-10-12',
    seasons_played: 20,
    'all-star': 7,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.787564767,
  },
  {
    id: 'dawsoan01',
    name: 'Andre Dawson',
    birthday: '1954-07-10',
    seasons_played: 21,
    'all-star': 8,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.779220779,
  },
  {
    id: 'deandi01',
    name: 'Dizzy Dean',
    birthday: '1910-01-16',
    seasons_played: 12,
    'all-star': 4,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.791666667,
  },
  {
    id: 'dickebi01',
    name: 'Bill Dickey',
    birthday: '1907-06-06',
    seasons_played: 17,
    'all-star': 11,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.801587302,
  },
  {
    id: 'dimagjo01',
    name: 'Joe DiMaggio',
    birthday: '1914-11-25',
    seasons_played: 13,
    'all-star': 13,
    triplecrown: 0,
    mvp: 3,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.888446215,
  },
  {
    id: 'drysddo01',
    name: 'Don Drysdale',
    birthday: '1936-07-23',
    seasons_played: 14,
    'all-star': 9,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.784119107,
  },
  {
    id: 'eckerde01',
    name: 'Dennis Eckersley',
    birthday: '1954-10-03',
    seasons_played: 25,
    'all-star': 6,
    triplecrown: 0,
    mvp: 1,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': true,
    'vote%': 0.83201581,
  },
  {
    id: 'fellebo01',
    name: 'Bob Feller',
    birthday: '1918-11-03',
    seasons_played: 18,
    'all-star': 8,
    triplecrown: 1,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.9375,
  },
  {
    id: 'fingero01',
    name: 'Rollie Fingers',
    birthday: '1946-08-25',
    seasons_played: 17,
    'all-star': 7,
    triplecrown: 0,
    mvp: 1,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': true,
    'vote%': 0.811627907,
  },
  {
    id: 'fiskca01',
    name: 'Carlton Fisk',
    birthday: '1947-12-26',
    seasons_played: 24,
    'all-star': 11,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.795591182,
  },
  {
    id: 'fordwh01',
    name: 'Whitey Ford',
    birthday: '1928-10-21',
    seasons_played: 16,
    'all-star': 10,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.778082192,
  },
  {
    id: 'foxxji01',
    name: 'Jimmie Foxx',
    birthday: '1907-10-22',
    seasons_played: 21,
    'all-star': 9,
    triplecrown: 1,
    mvp: 3,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.792035398,
  },
  {
    id: 'friscfr01',
    name: 'Frankie Frisch',
    birthday: '1897-09-09',
    seasons_played: 19,
    'all-star': 3,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.844720497,
  },
  {
    id: 'gibsobo01',
    name: 'Bob Gibson',
    birthday: '1935-11-09',
    seasons_played: 17,
    'all-star': 9,
    triplecrown: 0,
    mvp: 1,
    cya: 2,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': false,
    '300sv': false,
    'vote%': 0.840399002,
  },
  {
    id: 'glavito02',
    name: 'Tom Glavine',
    birthday: '1966-03-25',
    seasons_played: 22,
    'all-star': 10,
    triplecrown: 0,
    mvp: 0,
    cya: 2,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.91943958,
  },
  {
    id: 'gossari01',
    name: 'Rich Gossage',
    birthday: '1951-07-05',
    seasons_played: 23,
    'all-star': 9,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': true,
    'vote%': 0.858195212,
  },
  {
    id: 'greenha01',
    name: 'Hank Greenberg',
    birthday: '1911-01-01',
    seasons_played: 13,
    'all-star': 5,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.849740933,
  },
  {
    id: 'grovele01',
    name: 'Lefty Grove',
    birthday: '1900-03-06',
    seasons_played: 17,
    'all-star': 6,
    triplecrown: 2,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.763975155,
  },
  {
    id: 'gwynnto01',
    name: 'Tony Gwynn',
    birthday: '1960-05-09',
    seasons_played: 20,
    'all-star': 15,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.976146789,
  },
  {
    id: 'hartnga01',
    name: 'Gabby Hartnett',
    birthday: '1900-12-20',
    seasons_played: 20,
    'all-star': 6,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.77689243,
  },
  {
    id: 'heilmha01',
    name: 'Harry Heilmann',
    birthday: '1894-08-03',
    seasons_played: 17,
    'all-star': 0,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.867521368,
  },
  {
    id: 'henderi01',
    name: 'Rickey Henderson',
    birthday: '1958-12-25',
    seasons_played: 29,
    'all-star': 10,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.948051948,
  },
  {
    id: 'hornsro01',
    name: 'Rogers Hornsby',
    birthday: '1896-04-27',
    seasons_played: 24,
    'all-star': 0,
    triplecrown: 2,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.78111588,
  },
  {
    id: 'hubbeca01',
    name: 'Carl Hubbell',
    birthday: '1903-06-22',
    seasons_played: 16,
    'all-star': 9,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.869565217,
  },
  {
    id: 'hunteca01',
    name: 'Catfish Hunter',
    birthday: '1946-04-08',
    seasons_played: 15,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.762711864,
  },
  {
    id: 'jacksre01',
    name: 'Reggie Jackson',
    birthday: '1946-05-18',
    seasons_played: 21,
    'all-star': 14,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.936170213,
  },
  {
    id: 'jenkife01',
    name: 'Fergie Jenkins',
    birthday: '1942-12-13',
    seasons_played: 20,
    'all-star': 3,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': false,
    '300sv': false,
    'vote%': 0.753950339,
  },
  {
    id: 'johnsra05',
    name: 'Randy Johnson',
    birthday: '1963-09-10',
    seasons_played: 24,
    'all-star': 10,
    triplecrown: 1,
    mvp: 0,
    cya: 5,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.972677596,
  },
  {
    id: 'johnswa01',
    name: 'Walter Johnson',
    birthday: '1887-11-06',
    seasons_played: 21,
    'all-star': 0,
    triplecrown: 3,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.836283186,
  },
  {
    id: 'kalinal01',
    name: 'Al Kaline',
    birthday: '1934-12-19',
    seasons_played: 22,
    'all-star': 18,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.883116883,
  },
  {
    id: 'keelewi01',
    name: 'Willie Keeler',
    birthday: '1872-03-03',
    seasons_played: 20,
    'all-star': 0,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.755474453,
  },
  {
    id: 'killeha01',
    name: 'Harmon Killebrew',
    birthday: '1936-06-29',
    seasons_played: 22,
    'all-star': 13,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.831265509,
  },
  {
    id: 'kinerra01',
    name: 'Ralph Kiner',
    birthday: '1922-10-27',
    seasons_played: 11,
    'all-star': 6,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.754143646,
  },
  {
    id: 'koufasa01',
    name: 'Sandy Koufax',
    birthday: '1935-12-30',
    seasons_played: 12,
    'all-star': 7,
    triplecrown: 3,
    mvp: 1,
    cya: 3,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.868686869,
  },
  {
    id: 'lajoina01',
    name: 'Nap Lajoie',
    birthday: '1874-09-05',
    seasons_played: 22,
    'all-star': 0,
    triplecrown: 1,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.835820896,
  },
  {
    id: 'larkiba01',
    name: 'Barry Larkin',
    birthday: '1964-04-28',
    seasons_played: 19,
    'all-star': 12,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.863874346,
  },
  {
    id: 'lemonbo01',
    name: 'Bob Lemon',
    birthday: '1920-09-22',
    seasons_played: 15,
    'all-star': 7,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.786082474,
  },
  {
    id: 'lyonste01',
    name: 'Ted Lyons',
    birthday: '1900-12-28',
    seasons_played: 21,
    'all-star': 1,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.864541833,
  },
  {
    id: 'maddugr01',
    name: 'Greg Maddux',
    birthday: '1966-04-14',
    seasons_played: 25,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 4,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.971978984,
  },
  {
    id: 'mantlmi01',
    name: 'Mickey Mantle',
    birthday: '1931-10-20',
    seasons_played: 18,
    'all-star': 20,
    triplecrown: 1,
    mvp: 3,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.882191781,
  },
  {
    id: 'maranra01',
    name: 'Rabbit Maranville',
    birthday: '1891-11-11',
    seasons_played: 23,
    'all-star': 0,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.829365079,
  },
  {
    id: 'maricju01',
    name: 'Juan Marichal',
    birthday: '1937-10-20',
    seasons_played: 16,
    'all-star': 10,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.836898396,
  },
  {
    id: 'martipe02',
    name: 'Pedro Martinez',
    birthday: '1971-10-25',
    seasons_played: 18,
    'all-star': 8,
    triplecrown: 1,
    mvp: 0,
    cya: 3,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': false,
    '300sv': false,
    'vote%': 0.910746812,
  },
  {
    id: 'mathech01',
    name: 'Christy Mathewson',
    birthday: '1880-08-12',
    seasons_played: 18,
    'all-star': 0,
    triplecrown: 2,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.907079646,
  },
  {
    id: 'matheed01',
    name: 'Eddie Mathews',
    birthday: '1931-10-13',
    seasons_played: 18,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.794195251,
  },
  {
    id: 'mayswi01',
    name: 'Willie Mays',
    birthday: '1931-05-06',
    seasons_played: 23,
    'all-star': 24,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': true,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.946759259,
  },
  {
    id: 'mccovwi01',
    name: 'Willie McCovey',
    birthday: '1938-01-10',
    seasons_played: 23,
    'all-star': 6,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.814117647,
  },
  {
    id: 'medwijo01',
    name: 'Joe Medwick',
    birthday: '1911-11-24',
    seasons_played: 20,
    'all-star': 10,
    triplecrown: 1,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.848056537,
  },
  {
    id: 'molitpa01',
    name: 'Paul Molitor',
    birthday: '1956-08-22',
    seasons_played: 21,
    'all-star': 7,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.851778656,
  },
  {
    id: 'morgajo02',
    name: 'Joe Morgan',
    birthday: '1943-09-19',
    seasons_played: 22,
    'all-star': 10,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.817567568,
  },
  {
    id: 'murraed02',
    name: 'Eddie Murray',
    birthday: '1956-02-24',
    seasons_played: 23,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.852822581,
  },
  {
    id: 'musiast01',
    name: 'Stan Musial',
    birthday: '1920-11-21',
    seasons_played: 22,
    'all-star': 24,
    triplecrown: 0,
    mvp: 3,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.932352941,
  },
  {
    id: 'niekrph01',
    name: 'Phil Niekro',
    birthday: '1939-04-01',
    seasons_played: 26,
    'all-star': 5,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.803382664,
  },
  {
    id: 'ottme01',
    name: 'Mel Ott',
    birthday: '1909-03-02',
    seasons_played: 22,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.871681416,
  },
  {
    id: 'palmeji01',
    name: 'Jim Palmer',
    birthday: '1945-10-15',
    seasons_played: 19,
    'all-star': 6,
    triplecrown: 0,
    mvp: 0,
    cya: 3,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.925675676,
  },
  {
    id: 'pennohe01',
    name: 'Herb Pennock',
    birthday: '1894-02-10',
    seasons_played: 23,
    'all-star': 0,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.776859504,
  },
  {
    id: 'perezto01',
    name: 'Tony Perez',
    birthday: '1942-05-14',
    seasons_played: 23,
    'all-star': 7,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.771543086,
  },
  {
    id: 'perryga01',
    name: 'Gaylord Perry',
    birthday: '1938-09-15',
    seasons_played: 25,
    'all-star': 5,
    triplecrown: 0,
    mvp: 0,
    cya: 2,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.772009029,
  },
  {
    id: 'piazzmi01',
    name: 'Mike Piazza',
    birthday: '1968-09-04',
    seasons_played: 18,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.829545455,
  },
  {
    id: 'puckeki01',
    name: 'Kirby Puckett',
    birthday: '1960-03-14',
    seasons_played: 12,
    'all-star': 10,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.821359223,
  },
  {
    id: 'riceji01',
    name: 'Jim Rice',
    birthday: '1953-03-08',
    seasons_played: 16,
    'all-star': 8,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.764378479,
  },
  {
    id: 'ripkeca01',
    name: 'Cal Ripken',
    birthday: '1960-08-24',
    seasons_played: 21,
    'all-star': 19,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.985321101,
  },
  {
    id: 'roberro01',
    name: 'Robin Roberts',
    birthday: '1926-09-30',
    seasons_played: 21,
    'all-star': 7,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.868556701,
  },
  {
    id: 'robinbr01',
    name: 'Brooks Robinson',
    birthday: '1937-05-18',
    seasons_played: 23,
    'all-star': 18,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.919786096,
  },
  {
    id: 'robinfr02',
    name: 'Frank Robinson',
    birthday: '1935-08-31',
    seasons_played: 22,
    'all-star': 14,
    triplecrown: 1,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.891566265,
  },
  {
    id: 'robinja02',
    name: 'Jackie Robinson',
    birthday: '1919-01-31',
    seasons_played: 10,
    'all-star': 6,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.775,
  },
  {
    id: 'ruthba01',
    name: 'Babe Ruth',
    birthday: '1895-02-06',
    seasons_played: 22,
    'all-star': 2,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.951327434,
  },
  {
    id: 'ryanno01',
    name: 'Nolan Ryan',
    birthday: '1947-01-31',
    seasons_played: 27,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.987927565,
  },
  {
    id: 'sandbry01',
    name: 'Ryne Sandberg',
    birthday: '1959-09-18',
    seasons_played: 16,
    'all-star': 10,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.761627907,
  },
  {
    id: 'schmimi01',
    name: 'Mike Schmidt',
    birthday: '1949-09-27',
    seasons_played: 18,
    'all-star': 12,
    triplecrown: 0,
    mvp: 3,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.965217391,
  },
  {
    id: 'seaveto01',
    name: 'Tom Seaver',
    birthday: '1944-11-17',
    seasons_played: 22,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 3,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.988372093,
  },
  {
    id: 'simmoal01',
    name: 'Al Simmons',
    birthday: '1902-05-22',
    seasons_played: 21,
    'all-star': 3,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.753787879,
  },
  {
    id: 'sislege01',
    name: 'George Sisler',
    birthday: '1893-03-24',
    seasons_played: 16,
    'all-star': 0,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.857664234,
  },
  {
    id: 'smithoz01',
    name: 'Ozzie Smith',
    birthday: '1954-12-26',
    seasons_played: 19,
    'all-star': 15,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.917372881,
  },
  {
    id: 'smoltjo01',
    name: 'John Smoltz',
    birthday: '1967-05-15',
    seasons_played: 22,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': false,
    '300sv': false,
    'vote%': 0.828779599,
  },
  {
    id: 'snidedu01',
    name: 'Duke Snider',
    birthday: '1926-09-19',
    seasons_played: 18,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.864935065,
  },
  {
    id: 'spahnwa01',
    name: 'Warren Spahn',
    birthday: '1921-04-23',
    seasons_played: 22,
    'all-star': 17,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.831578947,
  },
  {
    id: 'speaktr01',
    name: 'Tris Speaker',
    birthday: '1888-04-04',
    seasons_played: 22,
    'all-star': 0,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.820895522,
  },
  {
    id: 'stargwi01',
    name: 'Willie Stargell',
    birthday: '1940-03-06',
    seasons_played: 21,
    'all-star': 7,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.824355972,
  },
  {
    id: 'suttebr01',
    name: 'Bruce Sutter',
    birthday: '1953-01-08',
    seasons_played: 12,
    'all-star': 6,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': true,
    'vote%': 0.769230769,
  },
  {
    id: 'suttodo01',
    name: 'Don Sutton',
    birthday: '1945-04-02',
    seasons_played: 25,
    'all-star': 4,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': true,
    '300w': true,
    '300sv': false,
    'vote%': 0.816067653,
  },
  {
    id: 'terrybi01',
    name: 'Bill Terry',
    birthday: '1898-10-30',
    seasons_played: 14,
    'all-star': 3,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.773809524,
  },
  {
    id: 'thomafr04',
    name: 'Frank Thomas',
    birthday: '1968-05-27',
    seasons_played: 20,
    'all-star': 5,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.837127846,
  },
  {
    id: 'traynpi01',
    name: 'Pie Traynor',
    birthday: '1898-11-11',
    seasons_played: 17,
    'all-star': 2,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.768595041,
  },
  {
    id: 'vanceda01',
    name: 'Dazzy Vance',
    birthday: '1891-03-04',
    seasons_played: 18,
    'all-star': 0,
    triplecrown: 1,
    mvp: 1,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.816733068,
  },
  {
    id: 'wagneho01',
    name: 'Honus Wagner',
    birthday: '1874-02-24',
    seasons_played: 21,
    'all-star': 0,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.951327434,
  },
  {
    id: 'wanerpa01',
    name: 'Paul Waner',
    birthday: '1903-04-16',
    seasons_played: 22,
    'all-star': 4,
    triplecrown: 0,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.833333333,
  },
  {
    id: 'wilheho01',
    name: 'Hoyt Wilhelm',
    birthday: '1922-07-26',
    seasons_played: 26,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.837974684,
  },
  {
    id: 'willibi01',
    name: 'Billy Williams',
    birthday: '1938-06-15',
    seasons_played: 18,
    'all-star': 6,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.857142857,
  },
  {
    id: 'willite01',
    name: 'Ted Williams',
    birthday: '1918-08-30',
    seasons_played: 19,
    'all-star': 19,
    triplecrown: 2,
    mvp: 2,
    cya: 0,
    '3000h': false,
    '500hr': true,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.933774834,
  },
  {
    id: 'winfida01',
    name: 'Dave Winfield',
    birthday: '1951-10-03',
    seasons_played: 23,
    'all-star': 12,
    triplecrown: 0,
    mvp: 0,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.844660194,
  },
  {
    id: 'wynnea01',
    name: 'Early Wynn',
    birthday: '1920-01-06',
    seasons_played: 23,
    'all-star': 8,
    triplecrown: 0,
    mvp: 0,
    cya: 1,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.76010101,
  },
  {
    id: 'yastrca01',
    name: 'Carl Yastrzemski',
    birthday: '1939-08-22',
    seasons_played: 23,
    'all-star': 18,
    triplecrown: 1,
    mvp: 1,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': true,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.946308725,
  },
  {
    id: 'youngcy01',
    name: 'Cy Young',
    birthday: '1867-03-29',
    seasons_played: 23,
    'all-star': 0,
    triplecrown: 1,
    mvp: 0,
    cya: 0,
    '3000h': false,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': true,
    '300sv': false,
    'vote%': 0.76119403,
  },
  {
    id: 'yountro01',
    name: 'Robin Yount',
    birthday: '1955-09-16',
    seasons_played: 20,
    'all-star': 3,
    triplecrown: 0,
    mvp: 2,
    cya: 0,
    '3000h': true,
    '500hr': false,
    '1500rbi': false,
    '3000k': false,
    '300w': false,
    '300sv': false,
    'vote%': 0.774647887,
  },
];
